/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.mftorder.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class MftSqlUpdateOrgUtils {
    private static final Log logger = LogFactory.getLog(MftSqlUpdateOrgUtils.class);

    public static UpgradeResult updateOrg(List<Map<String, String>> paramList) {
        UpgradeResult result = new UpgradeResult();
        logger.info("MftSqlUpdateOrgUtils--paramList.size()--" + paramList.size() + "---" + paramList);
        result.setSuccess(true);
        result.setLog("data update successfully.");
        Map<String, Object> checkParam = MftSqlUpdateOrgUtils.checkParam(paramList);
        Boolean success = (Boolean)checkParam.get("success");
        if (!success.booleanValue()) {
            result.setSuccess(success.booleanValue());
            result.setLog(checkParam.get("msg").toString());
            return result;
        }
        Map<String, List<Map>> collect = paramList.stream().collect(Collectors.groupingBy(mm -> (String)mm.get("dbkey")));
        int batch = 1000;
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        logger.info("MftSqlUpdateOrgUtils--rootOrgId--" + rootOrgId);
        for (Map.Entry<String, List<Map>> tmap : collect.entrySet()) {
            String dbkey = tmap.getKey();
            List<Map> value = tmap.getValue();
            int index = 0;
            StringBuilder filterStr = new StringBuilder();
            for (Map routeMap : value) {
                String table = (String)routeMap.get("table");
                String field = (String)routeMap.get("field");
                String idfield = (String)routeMap.get("idfield");
                String idvalue = (String)routeMap.get("idvalue");
                filterStr.append("update ");
                filterStr.append(table);
                filterStr.append(" set ");
                MftSqlUpdateOrgUtils.setBatchSql(field, filterStr, rootOrgId);
                filterStr.append(" where ");
                filterStr.append(idfield);
                filterStr.append(" in (");
                filterStr.append(idvalue);
                filterStr.append(");");
                if (++index < batch) continue;
                MftSqlUpdateOrgUtils.batchExeSql(dbkey, filterStr);
                filterStr = new StringBuilder();
                index = 0;
            }
            if (index <= 0) continue;
            MftSqlUpdateOrgUtils.batchExeSql(dbkey, filterStr);
        }
        return result;
    }

    public static void setBatchSql(String field, StringBuilder filterStr, long rootOrgId) {
        if (field.indexOf(",") >= 0) {
            String[] split = field.split(",");
            for (int i = 0; i < split.length; ++i) {
                filterStr.append(split[i]);
                filterStr.append(" = ");
                filterStr.append(rootOrgId);
                if (i >= split.length - 1) continue;
                filterStr.append(",");
            }
        } else {
            filterStr.append(field);
            filterStr.append(" = ");
            filterStr.append(rootOrgId);
        }
    }

    public static void batchExeSql(String dbkey, StringBuilder filterStr) {
        logger.info("batchExeSql--dbkey--" + dbkey + "---filterStr:" + filterStr);
        DB.execute((DBRoute)DBRoute.of((String)dbkey), (String)filterStr.toString());
    }

    public static Map<String, Object> checkParam(List<Map<String, String>> paramList) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("success", Boolean.TRUE);
        resultMap.put("msg", "");
        if (paramList == null || paramList.size() == 0) {
            resultMap.put("success", Boolean.FALSE);
            String info = ResManager.loadKDString((String)"paramList\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MftSqlUpdateOrgUtils_0", (String)"bd-mpdm-common", (Object[])new Object[0]);
            resultMap.put("msg", info);
            return resultMap;
        }
        for (Map<String, String> tempMap : paramList) {
            if (tempMap == null) {
                resultMap.put("success", Boolean.FALSE);
                resultMap.put("msg", "paramList map is null");
                return resultMap;
            }
            if (!tempMap.containsKey("table")) {
                resultMap.put("success", Boolean.FALSE);
                String info = ResManager.loadKDString((String)"paramList\u4e2dtable\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MftSqlUpdateOrgUtils_1", (String)"bd-mpdm-common", (Object[])new Object[0]);
                resultMap.put("msg", info);
                return resultMap;
            }
            if (!tempMap.containsKey("dbkey")) {
                resultMap.put("success", Boolean.FALSE);
                String info = ResManager.loadKDString((String)"paramList\u4e2ddbkey\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MftSqlUpdateOrgUtils_2", (String)"bd-mpdm-common", (Object[])new Object[0]);
                resultMap.put("msg", info);
                return resultMap;
            }
            if (!tempMap.containsKey("field")) {
                resultMap.put("success", Boolean.FALSE);
                String info = ResManager.loadKDString((String)"paramList\u4e2dfield\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MftSqlUpdateOrgUtils_3", (String)"bd-mpdm-common", (Object[])new Object[0]);
                resultMap.put("msg", info);
                return resultMap;
            }
            if (!tempMap.containsKey("idfield")) {
                resultMap.put("success", Boolean.FALSE);
                String info = ResManager.loadKDString((String)"paramList\u4e2didfield\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MftSqlUpdateOrgUtils_4", (String)"bd-mpdm-common", (Object[])new Object[0]);
                resultMap.put("msg", info);
                return resultMap;
            }
            if (tempMap.containsKey("idvalue")) continue;
            resultMap.put("success", Boolean.FALSE);
            String info = ResManager.loadKDString((String)"paramList\u4e2didvalue\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MftSqlUpdateOrgUtils_5", (String)"bd-mpdm-common", (Object[])new Object[0]);
            resultMap.put("msg", info);
            return resultMap;
        }
        return resultMap;
    }
}

