/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.mftorder.utils;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.commons.lang3.math.NumberUtils;

public class MroOrderAutoTransmitUtils {
    private static final Log logger = LogFactory.getLog(MroOrderAutoTransmitUtils.class);
    private static String POM_MROORDER = "pom_mroorder";
    private static Map<String, String> opKeyMap = new HashMap<String, String>(8);
    private static final int BATCHSAVECOUNT = 100;

    public static String autoTransmit(Set<Long> projectIdSet) {
        QFilter qf = new QFilter("treeentryentity.project", "in", projectIdSet);
        String sql = "id,billno,billstatus,treeentryentity.planstatus,treeentryentity.id,treeentryentity.taskstatus,treeentryentity.bizstatus";
        DynamicObject[] load = BusinessDataServiceHelper.load((String)POM_MROORDER, (String)sql, (QFilter[])new QFilter[]{qf});
        HashSet<Long> saveMroOrder = new HashSet<Long>(load.length);
        HashSet<Long> submitMroOrder = new HashSet<Long>(load.length);
        HashSet<Long> auditMroOrder = new HashSet<Long>(load.length);
        HashMap<Long, String> orderNameMap = new HashMap<Long, String>(load.length);
        for (DynamicObject mroOrder : load) {
            String billstatus = mroOrder.getString("billstatus");
            if ("A".equals(billstatus)) {
                saveMroOrder.add(mroOrder.getLong("id"));
                orderNameMap.put(mroOrder.getLong("id"), mroOrder.getString("billno"));
                continue;
            }
            if ("B".equals(billstatus)) {
                submitMroOrder.add(mroOrder.getLong("id"));
                orderNameMap.put(mroOrder.getLong("id"), mroOrder.getString("billno"));
                continue;
            }
            if (!"C".equals(billstatus)) continue;
            DynamicObjectCollection treeentryentity = mroOrder.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject row : treeentryentity) {
                String planstatus = row.getString("planstatus");
                String bizstatus = row.getString("bizstatus");
                if ("C".equals(planstatus) || "C".equals(bizstatus)) continue;
                auditMroOrder.add(mroOrder.getLong("id"));
                orderNameMap.put(mroOrder.getLong("id"), mroOrder.getString("billno"));
            }
        }
        StringBuilder error = new StringBuilder();
        if (saveMroOrder != null && !saveMroOrder.isEmpty()) {
            MroOrderAutoTransmitUtils.autoAuditMroOrder(saveMroOrder, orderNameMap, submitMroOrder, error, "submit", "pom_mroorder");
        }
        if (submitMroOrder != null && !submitMroOrder.isEmpty()) {
            MroOrderAutoTransmitUtils.autoAuditMroOrder(submitMroOrder, orderNameMap, auditMroOrder, error, "audit", "pom_mroorder");
        }
        if (auditMroOrder != null && !auditMroOrder.isEmpty()) {
            MroOrderAutoTransmitUtils.autoAuditMroOrder(auditMroOrder, orderNameMap, null, error, "transmit", "pom_mroorder");
        }
        logger.info("autotransmit------errorinfo---");
        logger.info(error.toString());
        if (error.toString().length() > 255) {
            return error.toString().substring(0, 255);
        }
        return error.toString();
    }

    public static String autoCancel(Set<Long> projectIdSet) {
        QFilter qf = new QFilter("treeentryentity.project", "in", projectIdSet);
        String sql = "id,billno,billstatus,treeentryentity.planstatus,treeentryentity.id,treeentryentity.taskstatus,treeentryentity.bizstatus";
        DynamicObject[] load = BusinessDataServiceHelper.load((String)POM_MROORDER, (String)sql, (QFilter[])new QFilter[]{qf});
        HashSet taskStatusSet = Sets.newHashSet((Object[])new String[]{"C", "E", "J"});
        HashSet<Long> saveAndSubmitMroOrder = new HashSet<Long>(load.length);
        HashSet<Long> unendMroOrder = new HashSet<Long>(load.length);
        HashMap<Long, String> orderNameMap = new HashMap<Long, String>(load.length);
        for (DynamicObject mroOrder : load) {
            String billstatus = mroOrder.getString("billstatus");
            if ("A".equals(billstatus) || "B".equals(billstatus)) {
                saveAndSubmitMroOrder.add(mroOrder.getLong("id"));
                orderNameMap.put(mroOrder.getLong("id"), mroOrder.getString("billno"));
                continue;
            }
            if (!"C".equals(billstatus)) continue;
            DynamicObjectCollection treeentryentity = mroOrder.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject row : treeentryentity) {
                String taskstatus = row.getString("taskstatus");
                if (taskStatusSet.contains(taskstatus)) continue;
                unendMroOrder.add(mroOrder.getLong("id"));
                orderNameMap.put(mroOrder.getLong("id"), mroOrder.getString("billno"));
            }
        }
        StringBuilder error = new StringBuilder();
        if (!saveAndSubmitMroOrder.isEmpty()) {
            MroOrderAutoTransmitUtils.exectOpMroOrder(saveAndSubmitMroOrder, orderNameMap, error, "invalid", POM_MROORDER);
        }
        if (!unendMroOrder.isEmpty()) {
            MroOrderAutoTransmitUtils.exectOpMroOrder(unendMroOrder, orderNameMap, error, "cancel", POM_MROORDER);
        }
        if (error.toString().length() > 255) {
            return error.toString().substring(0, 255);
        }
        return error.toString();
    }

    public static String autoEndWork(Set<Long> projectIdSet) {
        QFilter qf = new QFilter("treeentryentity.project", "in", projectIdSet);
        qf.and(new QFilter("mroordertypeid", "=", (Object)1549849460861874176L));
        String sql = "id,billno,billstatus,treeentryentity.planstatus,treeentryentity.id,treeentryentity.taskstatus,treeentryentity.bizstatus";
        DynamicObject[] load = BusinessDataServiceHelper.load((String)POM_MROORDER, (String)sql, (QFilter[])new QFilter[]{qf});
        HashSet<Long> saveMroOrder = new HashSet<Long>(load.length);
        HashSet<Long> submitMroOrder = new HashSet<Long>(load.length);
        HashSet<Long> auditNoTransmitMroOrder = new HashSet<Long>(load.length);
        HashSet<Long> auditNoBeginWorkMroOrder = new HashSet<Long>(load.length);
        HashSet<Long> auditBeginWorkMroOrder = new HashSet<Long>(load.length);
        HashSet<Long> auditHoldMroOrder = new HashSet<Long>(load.length);
        HashMap<Long, String> orderNameMap = new HashMap<Long, String>(load.length);
        for (DynamicObject mroOrder : load) {
            String billstatus = mroOrder.getString("billstatus");
            if ("A".equals(billstatus)) {
                saveMroOrder.add(mroOrder.getLong("id"));
            } else if ("B".equals(billstatus)) {
                submitMroOrder.add(mroOrder.getLong("id"));
            } else if ("C".equals(billstatus)) {
                DynamicObjectCollection treeentryentity = mroOrder.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject row : treeentryentity) {
                    String planstatus = row.getString("planstatus");
                    String taskstatus = row.getString("taskstatus");
                    String bizstatus = row.getString("bizstatus");
                    if (!"C".equals(planstatus) && !"C".equals(bizstatus)) {
                        auditNoTransmitMroOrder.add(mroOrder.getLong("id"));
                        continue;
                    }
                    if ("C".equals(planstatus) && ("A".equals(taskstatus) || "G".equals(taskstatus)) && !"C".equals(bizstatus)) {
                        auditNoBeginWorkMroOrder.add(mroOrder.getLong("id"));
                        continue;
                    }
                    if ("C".equals(planstatus) && "B".equals(taskstatus) && !"C".equals(bizstatus)) {
                        auditBeginWorkMroOrder.add(mroOrder.getLong("id"));
                        continue;
                    }
                    if (!"C".equals(planstatus) || !"H".equals(taskstatus) || "C".equals(bizstatus)) continue;
                    auditHoldMroOrder.add(mroOrder.getLong("id"));
                }
            }
            orderNameMap.put(mroOrder.getLong("id"), mroOrder.getString("billno"));
        }
        StringBuilder error = new StringBuilder();
        if (saveMroOrder != null && !saveMroOrder.isEmpty()) {
            MroOrderAutoTransmitUtils.autoAuditMroOrder(saveMroOrder, orderNameMap, submitMroOrder, error, "submit", "pom_mroorder");
        }
        if (submitMroOrder != null && !submitMroOrder.isEmpty()) {
            MroOrderAutoTransmitUtils.autoAuditMroOrder(submitMroOrder, orderNameMap, auditNoTransmitMroOrder, error, "audit", "pom_mroorder");
        }
        if (auditNoTransmitMroOrder != null && !auditNoTransmitMroOrder.isEmpty()) {
            MroOrderAutoTransmitUtils.autoAuditMroOrder(auditNoTransmitMroOrder, orderNameMap, auditNoBeginWorkMroOrder, error, "transmit", "pom_mroorder");
        }
        if (auditHoldMroOrder != null && !auditHoldMroOrder.isEmpty()) {
            MroOrderAutoTransmitUtils.autoAuditMroOrder(auditHoldMroOrder, orderNameMap, auditNoBeginWorkMroOrder, error, "multransmit", "pom_mroorder");
        }
        if (auditNoBeginWorkMroOrder != null && !auditNoBeginWorkMroOrder.isEmpty()) {
            MroOrderAutoTransmitUtils.autoAuditMroOrder(auditNoBeginWorkMroOrder, orderNameMap, auditBeginWorkMroOrder, error, "beginwork", "pom_mroorder");
        }
        if (auditBeginWorkMroOrder != null && !auditBeginWorkMroOrder.isEmpty()) {
            MroOrderAutoTransmitUtils.autoAuditMroOrder(auditBeginWorkMroOrder, orderNameMap, null, error, "endwork", "pom_mroorder");
        }
        logger.info("autoEndWork------errorinfo---");
        logger.info(error.toString());
        if (error.toString().length() > 255) {
            return error.toString().substring(0, 255);
        }
        return error.toString();
    }

    public static OperateOption getOperateOption() {
        OperateOption saveOption = OperateOption.create();
        saveOption.setVariableValue("ignorewarn", String.valueOf(true));
        saveOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        saveOption.setVariableValue("strictvalidation", String.valueOf(false));
        saveOption.setVariableValue("ignoreValidation", String.valueOf(true));
        saveOption.setVariableValue("WF", "false");
        return saveOption;
    }

    private static String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        if (optResult.getMessage() != null) {
            errDetail.append(optResult.getMessage().replaceAll("\\(\\)", "").replaceAll("</br>", ""));
        }
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            errDetail.append(errInfo.getMessage().replaceAll("\\(\\)", "").replaceAll("</br>", ""));
        }
        return errDetail.toString();
    }

    public static void autoAuditMroOrder(Set<Long> submitMroOrder, Map<Long, String> orderNameMap, Set<Long> auditMroOrder, StringBuilder error, String opkey, String entityNum) {
        List<Object> auditSuccessPkIds = MroOrderAutoTransmitUtils.batchExecuteMroOrder(submitMroOrder, orderNameMap, error, opkey, entityNum);
        if (auditMroOrder != null) {
            for (Object spid : auditSuccessPkIds) {
                auditMroOrder.add(NumberUtils.toLong((String)spid.toString()));
            }
        }
    }

    public static void exectOpMroOrder(Set<Long> submitMroOrder, Map<Long, String> orderNameMap, StringBuilder error, String opkey, String entityNum) {
        MroOrderAutoTransmitUtils.batchExecuteMroOrder(submitMroOrder, orderNameMap, error, opkey, entityNum);
    }

    public static List<Object> batchExecuteMroOrder(Set<Long> executeIdSet, Map<Long, String> orderNameMap, StringBuilder error, String opkey, String entityNum) {
        ArrayList<Long> executeIdList = new ArrayList<Long>(executeIdSet);
        int allSize = executeIdList.size();
        int times = allSize / 100;
        if (allSize % 100 > 0) {
            ++times;
        }
        List subList = null;
        long startdate = System.currentTimeMillis();
        logger.info("batchExecuteMroOrder begin execute operation datas:times = " + times + ",opkey=" + opkey + ",entityNum=" + entityNum + ",allSize=" + allSize);
        ArrayList<Object> returnAllList = new ArrayList<Object>(allSize);
        for (int i = 1; i <= times; ++i) {
            subList = i < times ? executeIdList.subList(100 * (i - 1), 100 * i) : executeIdList.subList(100 * (i - 1), allSize);
            logger.info("batchExecuteMroOrder execute datas:current  step times = " + i + ",alltimes = " + times);
            OperateOption executeOption = MroOrderAutoTransmitUtils.getOperateOption();
            OperationResult executeResult = OperationServiceHelper.executeOperate((String)opkey, (String)entityNum, (Object[])subList.toArray(), (OperateOption)executeOption);
            List executeSuccessPkIds = executeResult.getSuccessPkIds();
            if (executeSuccessPkIds.size() < subList.size()) {
                ArrayList<String> errorName = new ArrayList<String>(subList.size() - executeSuccessPkIds.size());
                for (int j = 0; j < subList.size(); ++j) {
                    Long orderID = (Long)subList.get(j);
                    if (executeSuccessPkIds.contains(orderID) || !orderNameMap.containsKey(orderID)) continue;
                    errorName.add(orderNameMap.get(orderID));
                }
                error.append(String.format(ResManager.loadKDString((String)"%1$s\u5de5\u5355%2$s\u5931\u8d25\uff1a%3$s", (String)"MroOrderAutoTransmitUtils_3", (String)"bd-mpdm-common", (Object[])new Object[0]), opKeyMap.get(opkey), String.join((CharSequence)"\u3001", errorName), MroOrderAutoTransmitUtils.getErrDetail(executeResult)));
            }
            returnAllList.addAll(executeSuccessPkIds);
        }
        long enddate = System.currentTimeMillis() - startdate;
        logger.info("batchExecuteMroOrder end save orders,cost:" + enddate + "ms");
        return returnAllList;
    }

    static {
        opKeyMap.put("submit", ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"MroOrderAutoTransmitUtils_0", (String)"bd-mpdm-common", (Object[])new Object[0]));
        opKeyMap.put("audit", ResManager.loadKDString((String)"\u5ba1\u6838", (String)"MroOrderAutoTransmitUtils_1", (String)"bd-mpdm-common", (Object[])new Object[0]));
        opKeyMap.put("transmit", ResManager.loadKDString((String)"\u4e0b\u8fbe", (String)"MroOrderAutoTransmitUtils_2", (String)"bd-mpdm-common", (Object[])new Object[0]));
        opKeyMap.put("multransmit", ResManager.loadKDString((String)"\u91cd\u4e0b\u8fbe", (String)"MroOrderAutoTransmitUtils_4", (String)"bd-mpdm-common", (Object[])new Object[0]));
        opKeyMap.put("beginwork", ResManager.loadKDString((String)"\u5f00\u5de5", (String)"MroOrderAutoTransmitUtils_5", (String)"bd-mpdm-common", (Object[])new Object[0]));
        opKeyMap.put("endnwork", ResManager.loadKDString((String)"\u5b8c\u5de5", (String)"MroOrderAutoTransmitUtils_6", (String)"bd-mpdm-common", (Object[])new Object[0]));
    }
}

