/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.mftorder.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.OrderCloseUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class OrderCloseTplUtils {
    private static final Log logger = LogFactory.getLog(OrderCloseTplUtils.class);
    private static String orderEntity = "pom_mftorder";
    private static String stockEntity = "pom_mftstock";

    private static Map<String, String> getPushBillMap() {
        HashMap<String, String> BILLANDNAMECORRESPODINGMAP = new HashMap<String, String>();
        BILLANDNAMECORRESPODINGMAP.put("im_mdc_mftmanuinbill", ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5b8c\u5de5\u5165\u5e93\u5355\u3002", (String)"OrderCloseTplUtils_0", (String)"bd-mpdm-common", (Object[])new Object[0]));
        BILLANDNAMECORRESPODINGMAP.put("im_mdc_mftreturnbill", ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5b8c\u5de5\u9000\u5e93\u5355\u3002", (String)"OrderCloseTplUtils_1", (String)"bd-mpdm-common", (Object[])new Object[0]));
        BILLANDNAMECORRESPODINGMAP.put("im_mdc_mftproorder", ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u751f\u4ea7\u9886\u6599\u5355\u3002", (String)"OrderCloseTplUtils_2", (String)"bd-mpdm-common", (Object[])new Object[0]));
        BILLANDNAMECORRESPODINGMAP.put("im_mdc_mftreturnorder", ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u751f\u4ea7\u9000\u6599\u5355\u3002", (String)"OrderCloseTplUtils_3", (String)"bd-mpdm-common", (Object[])new Object[0]));
        BILLANDNAMECORRESPODINGMAP.put("im_mdc_mftfeedorder", ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u751f\u4ea7\u8865\u6599\u5355\u3002", (String)"OrderCloseTplUtils_4", (String)"bd-mpdm-common", (Object[])new Object[0]));
        BILLANDNAMECORRESPODINGMAP.put("sfc_manftech", ResManager.loadKDString((String)"\u4e0b\u6e38\u5de5\u5e8f\u8ba1\u5212\u4e2d\u5b58\u5728\u5de5\u5e8f\u72b6\u6001\u672a\u5168\u90e8\u5b8c\u5de5\u6216\u4f5c\u5e9f\u7684\u5de5\u5e8f\u3002", (String)"OrderCloseTplUtils_5", (String)"bd-mpdm-common", (Object[])new Object[0]));
        BILLANDNAMECORRESPODINGMAP.put("sfc_processreportbill", ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5de5\u5e8f\u6c47\u62a5\u5355\u3002", (String)"OrderCloseTplUtils_6", (String)"bd-mpdm-common", (Object[])new Object[0]));
        BILLANDNAMECORRESPODINGMAP.put("pom_mftorderreport", ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5de5\u5355\u6c47\u62a5\u5355\u3002", (String)"OrderCloseTplUtils_7", (String)"bd-mpdm-common", (Object[])new Object[0]));
        BILLANDNAMECORRESPODINGMAP.put("pom_xmftstock", ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u5355\u3002", (String)"OrderCloseTplUtils_8", (String)"bd-mpdm-common", (Object[])new Object[0]));
        BILLANDNAMECORRESPODINGMAP.put("pom_xmftorder", ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u751f\u4ea7\u5de5\u5355\u53d8\u66f4\u5355\u3002", (String)"OrderCloseTplUtils_9", (String)"bd-mpdm-common", (Object[])new Object[0]));
        BILLANDNAMECORRESPODINGMAP.put("sfc_reportresource_adjust", ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u6c47\u62a5\u8d44\u6e90\u8c03\u6574\u5355\u3002", (String)"OrderCloseTplUtils_10", (String)"bd-mpdm-common", (Object[])new Object[0]));
        return BILLANDNAMECORRESPODINGMAP;
    }

    private static Map<String, String[]> getPushOmBilMap() {
        HashMap<String, String[]> BILLANDINFOCORRESPODINGMAP = new HashMap<String, String[]>();
        BILLANDINFOCORRESPODINGMAP.put("om_processreport", new String[]{ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u59d4\u5916\u5de5\u5e8f\u6c47\u62a5\u5355\u3002", (String)"OrderCloseTplUtils_22", (String)"bd-mpdm-common", (Object[])new Object[0]), "sumentry.manufactureentryid"});
        BILLANDINFOCORRESPODINGMAP.put("im_mdc_omcmplinbill", new String[]{ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u59d4\u5916\u5b8c\u5de5\u5165\u5e93\u5355\u3002", (String)"OrderCloseTplUtils_23", (String)"bd-mpdm-common", (Object[])new Object[0]), "billentry.manuentryid"});
        BILLANDINFOCORRESPODINGMAP.put("im_mdc_omoutbill", new String[]{ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u59d4\u5916\u9886\u6599\u5355\u3002", (String)"OrderCloseTplUtils_24", (String)"bd-mpdm-common", (Object[])new Object[0]), "billentry.manuentryid"});
        BILLANDINFOCORRESPODINGMAP.put("im_mdc_omreturnbill", new String[]{ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u59d4\u5916\u9000\u6599\u5355\u3002", (String)"OrderCloseTplUtils_25", (String)"bd-mpdm-common", (Object[])new Object[0]), "billentry.manuentryid"});
        BILLANDINFOCORRESPODINGMAP.put("im_mdc_omfeedbill", new String[]{ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u59d4\u5916\u8865\u6599\u5355\u3002", (String)"OrderCloseTplUtils_26", (String)"bd-mpdm-common", (Object[])new Object[0]), "billentry.manuentryid"});
        BILLANDINFOCORRESPODINGMAP.put("om_xmftorder", new String[]{ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u59d4\u5916\u5de5\u5355\u53d8\u66f4\u5355\u3002", (String)"OrderCloseTplUtils_27", (String)"bd-mpdm-common", (Object[])new Object[0]), "treeentryentity.srcbillentryid"});
        BILLANDINFOCORRESPODINGMAP.put("om_xmftstock", new String[]{ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u3002", (String)"OrderCloseTplUtils_28", (String)"bd-mpdm-common", (Object[])new Object[0]), "stockentry.entryorderentryid"});
        BILLANDINFOCORRESPODINGMAP.put("pm_purapplybill", new String[]{ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u59d4\u5916\u91c7\u8d2d\u7533\u8bf7\u5355\u3002", (String)"OrderCloseTplUtils_29", (String)"bd-mpdm-common", (Object[])new Object[0]), "billentry.mftorderentryid"});
        BILLANDINFOCORRESPODINGMAP.put("pm_purorderbill", new String[]{ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u3002", (String)"OrderCloseTplUtils_30", (String)"bd-mpdm-common", (Object[])new Object[0]), "billentry.mftorderentryid"});
        return BILLANDINFOCORRESPODINGMAP;
    }

    private static Map<String, String[]> getPushPropBillMap() {
        HashMap<String, String[]> BILLANDNAMECORRESPODINGMAP = new HashMap<String, String[]>();
        BILLANDNAMECORRESPODINGMAP.put("im_mdc_mftmanuinbill", new String[]{ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5b8c\u5de5\u5165\u5e93\u5355\u3002", (String)"OrderCloseTplUtils_0", (String)"bd-mpdm-common", (Object[])new Object[0]), "billentry.manuentryid"});
        BILLANDNAMECORRESPODINGMAP.put("im_mdc_mftreturnbill", new String[]{ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5b8c\u5de5\u9000\u5e93\u5355\u3002", (String)"OrderCloseTplUtils_1", (String)"bd-mpdm-common", (Object[])new Object[0]), "billentry.manuentryid"});
        BILLANDNAMECORRESPODINGMAP.put("im_mdc_mftproorder", new String[]{ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u751f\u4ea7\u9886\u6599\u5355\u3002", (String)"OrderCloseTplUtils_2", (String)"bd-mpdm-common", (Object[])new Object[0]), "billentry.manuentryid"});
        BILLANDNAMECORRESPODINGMAP.put("im_mdc_mftreturnorder", new String[]{ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u751f\u4ea7\u9000\u6599\u5355\u3002", (String)"OrderCloseTplUtils_3", (String)"bd-mpdm-common", (Object[])new Object[0]), "billentry.manuentryid"});
        BILLANDNAMECORRESPODINGMAP.put("im_mdc_mftfeedorder", new String[]{ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u751f\u4ea7\u8865\u6599\u5355\u3002", (String)"OrderCloseTplUtils_4", (String)"bd-mpdm-common", (Object[])new Object[0]), "billentry.manuentryid"});
        BILLANDNAMECORRESPODINGMAP.put("prop_manftech", new String[]{ResManager.loadKDString((String)"\u4e0b\u6e38\u5de5\u5e8f\u8ba1\u5212\u4e2d\u5b58\u5728\u5de5\u5e8f\u72b6\u6001\u672a\u5168\u90e8\u5b8c\u5de5\u6216\u4f5c\u5e9f\u7684\u5de5\u5e8f\u3002", (String)"OrderCloseTplUtils_5", (String)"bd-mpdm-common", (Object[])new Object[0]), "mftentryseq.id"});
        return BILLANDNAMECORRESPODINGMAP;
    }

    private static Map<Object, Map<String, Object>> orderMapDeepCopy(Map<Object, Map<String, Object>> orderMap) {
        HashMap<Object, Map<String, Object>> deepOrderMap = new HashMap<Object, Map<String, Object>>(16);
        for (Map.Entry<Object, Map<String, Object>> orderEntry : orderMap.entrySet()) {
            Object orderKey = orderEntry.getKey();
            Map<String, Object> orderVal = orderEntry.getValue();
            HashMap<String, Object> deepOrderValMap = new HashMap<String, Object>(16);
            for (Map.Entry<String, Object> orderValEntry : orderVal.entrySet()) {
                String orderValKey = orderValEntry.getKey();
                if (StringUtils.equals((CharSequence)orderValKey, (CharSequence)"dym")) continue;
                Object orderValMap = orderValEntry.getValue();
                deepOrderValMap.put(orderValKey, orderValMap);
            }
            deepOrderMap.put(orderKey, deepOrderValMap);
        }
        return deepOrderMap;
    }

    public static Map<Long, List<String>> checkPushInfoAndClose(Set<Long> orderEntryidSet, String modetype, boolean closeOpFlag, String closeorder) {
        HashMap<Long, List<String>> infoMap = new HashMap<Long, List<String>>(16);
        if (orderEntryidSet != null && !orderEntryidSet.isEmpty()) {
            Long getOrderCloseMap = System.currentTimeMillis();
            Map<String, String> entityMap = OrderCloseTplUtils.getMftModeEntity(modetype);
            Map<Object, Map<String, Object>> orderMap = OrderCloseUtils.getOrderCloseMapByAutoFlag(infoMap, orderEntryidSet, entityMap, closeOpFlag);
            logger.info(String.format("\u5de5\u5355\u5173\u95ed\u8fdb\u884c\u6570\u636e\u8fc7\u6ee4\uff0c\u4f20\u53c2:%s", orderMap.keySet().toString()));
            Map<Object, Map<String, Object>> orderMapCopy = OrderCloseTplUtils.orderMapDeepCopy(orderMap);
            if (null != orderMap && null != orderMapCopy && !orderMap.isEmpty()) {
                Map<String, String> pushBillMap;
                logger.info("\u5de5\u5355\u81ea\u52a8\u5173\u95ed->\u67e5\u627e\u5bf9\u5e94\u7684\u5de5\u5355   \u8fc7\u6ee4\u6389\u672a\u5b8c\u5168\u9886\u6599\u7684\u5206\u5f55\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - getOrderCloseMap));
                logger.info(String.format("\u5de5\u5355\u81ea\u52a8\u5173\u95ed->\u67e5\u627e\u5bf9\u5e94\u7684\u5de5\u5355\u8fc7\u6ee4\u6389\u672a\u5b8c\u5168\u9886\u6599\u7684\u5206\u5f55\uff0c\u4f20\u53c2:%s", orderMapCopy.keySet().toString()));
                if ("1".equals(modetype)) {
                    pushBillMap = OrderCloseTplUtils.getPushBillMap();
                    for (Map.Entry<String, String> m : pushBillMap.entrySet()) {
                        String key = m.getKey();
                        String value = m.getValue();
                        if (!closeOpFlag && "sfc_manftech".equals(key)) continue;
                        Set<String> filterList = OrderCloseTplUtils.filterUnAuditBillByEntityId(infoMap, orderMapCopy, key);
                        OrderCloseTplUtils.dealFilerData(orderMap, filterList, infoMap, value, key);
                    }
                } else if (!"4".equals(modetype)) {
                    if ("2".equals(modetype)) {
                        pushBillMap = OrderCloseTplUtils.getPushOmBilMap();
                        for (Map.Entry<String, String> m : pushBillMap.entrySet()) {
                            String key = m.getKey();
                            String[] value = (String[])m.getValue();
                            String info = value[0];
                            String srcBillEntryIdName = value[1];
                            Set<String> filterList = OrderCloseTplUtils.filterUnAuditBillByEntityId(orderMapCopy, key, srcBillEntryIdName);
                            OrderCloseTplUtils.dealFilerData(orderMap, filterList, infoMap, info);
                        }
                    } else if ("9".equals(modetype)) {
                        pushBillMap = OrderCloseTplUtils.getPushPropBillMap();
                        for (Map.Entry<String, String> m : pushBillMap.entrySet()) {
                            String key = m.getKey();
                            String[] value = (String[])m.getValue();
                            String info = value[0];
                            String srcBillEntryIdName = value[1];
                            Set<String> filterList = OrderCloseTplUtils.filterUnAuditPropBillByEntityId(orderMapCopy, key, srcBillEntryIdName);
                            OrderCloseTplUtils.dealFilerData(orderMap, filterList, infoMap, info);
                        }
                    }
                }
                if (!closeOpFlag) {
                    OrderCloseTplUtils.dealCloseData(orderMap, infoMap);
                }
                Map<Object, DynamicObject> stockMap = OrderCloseUtils.getStockMap(orderMapCopy.keySet(), entityMap.get("stockEntity"));
                if (closeOpFlag) {
                    OrderCloseTplUtils.filterUnProStock(orderMapCopy, orderMap, stockMap, infoMap);
                }
                if ("1".equals(closeorder)) {
                    if (closeOpFlag && "2".equals(modetype)) {
                        OrderCloseTplUtils.checkOmMftTechnics(orderMap);
                    }
                    Long startcloseOrder = System.currentTimeMillis();
                    logger.info(String.format("\u51c6\u5907\u8c03\u7528\u5de5\u5355\u5173\u95ed\u63a5\u53e3\uff0c\u4f20\u53c2:%s", orderMap.keySet().toString()));
                    OrderCloseUtils.closeOrder(orderMap, stockMap, entityMap.get("orderEntity"));
                    logger.info("\u5de5\u5355\u81ea\u52a8\u5173\u95ed->\u5c06\u7b26\u5408\u5173\u95ed\u6761\u4ef6\u7684\u5de5\u5355\u5206\u5f55\u5173\u95ed\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startcloseOrder));
                }
            }
        }
        if (!infoMap.isEmpty()) {
            logger.error("\u5de5\u5355\u81ea\u52a8\u5173\u95ed->infoMap:" + ((Object)infoMap).toString());
        }
        return infoMap;
    }

    private static Map<String, String> getMftModeEntity(String modetype) {
        HashMap<String, String> entityMap = new HashMap<String, String>(20);
        switch (modetype) {
            case "1": {
                entityMap.put("transactEntity", "mpdm_transactproduct");
                entityMap.put("tableName", "t_pom_mftorderentry");
                entityMap.put("reqoutEntity", "im_mdc_mftproorder");
                entityMap.put("orderEntity", "pom_mftorder");
                entityMap.put("stockEntity", "pom_mftstock");
                entityMap.put("manftechEntity", "sfc_manftech");
                break;
            }
            case "2": {
                entityMap.put("transactEntity", "mpdm_transactproduct");
                entityMap.put("tableName", "t_om_mftorderentry");
                entityMap.put("reqoutEntity", "im_mdc_omoutbill");
                entityMap.put("orderEntity", "om_mftorder");
                entityMap.put("stockEntity", "om_mftstock");
                entityMap.put("manftechEntity", "om_mfttechnics");
                break;
            }
            case "3": {
                entityMap.put("transactEntity", "mpdm_transactout");
                entityMap.put("reqoutEntity", "im_mdc_omoutbill");
                entityMap.put("orderEntity", "om_mftorder");
                entityMap.put("stockEntity", "om_mftstock");
                break;
            }
            case "7": {
                entityMap.put("transactEntity", "mpdm_transactproduct");
                entityMap.put("tableName", "t_pom_mroorderentry");
                entityMap.put("reqoutEntity", "im_mdc_mftproorder");
                entityMap.put("orderEntity", "pom_mroorder");
                entityMap.put("stockEntity", "pom_mrostock");
                entityMap.put("manftechEntity", "sfc_mromanuftech");
                break;
            }
            case "9": {
                entityMap.put("transactEntity", "mpdm_transactproduct");
                entityMap.put("tableName", "t_prop_mftorderentry");
                entityMap.put("reqoutEntity", "im_mdc_mftproorder");
                entityMap.put("orderEntity", "prop_mftorder");
                entityMap.put("stockEntity", "prop_mftstock");
                entityMap.put("manftechEntity", "prop_manftech");
                break;
            }
            default: {
                entityMap.put("transactEntity", "mpdm_transactproduct");
                entityMap.put("tableName", "t_pom_mftorderentry");
                entityMap.put("reqoutEntity", "im_mdc_mftproorder");
                entityMap.put("orderEntity", "pom_mftorder");
                entityMap.put("stockEntity", "pom_mftstock");
                entityMap.put("manftechEntity", "sfc_manftech");
            }
        }
        return entityMap;
    }

    private static void dealFilerData(Map<Object, Map<String, Object>> orderMap, Set<String> filterList, Map<Long, List<String>> infoMap, String info, String entityKey) {
        if (null != orderMap && null != filterList && filterList.size() > 0) {
            logger.info(String.format("\u51c6\u5907\u8fc7\u6ee4\u6570\u636e:%s,\u539f\u56e0\uff1a%s", filterList.toString(), info));
            for (String id : filterList) {
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                Long idL = Long.parseLong(id);
                List<String> infoList = infoMap.get(idL);
                if (null == infoList) {
                    ArrayList<String> tempInfoList = new ArrayList<String>();
                    tempInfoList.add(info);
                    infoMap.put(idL, tempInfoList);
                } else {
                    infoList.add(info);
                }
                Iterator<Map.Entry<Object, Map<String, Object>>> iterator = orderMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Object idInMap;
                    Map.Entry<Object, Map<String, Object>> item = iterator.next();
                    if (null == item || null == (idInMap = item.getKey()) || !StringUtils.equals((CharSequence)idInMap.toString(), (CharSequence)id)) continue;
                    iterator.remove();
                    logger.info(String.format("\u751f\u4ea7\u5de5\u5355\u5173\u95ed\u8fc7\u6ee4\u6570\u636e\uff1a%s,\u539f\u56e0:%s", id, info));
                }
            }
        }
    }

    private static void dealCloseData(Map<Object, Map<String, Object>> orderMap, Map<Long, List<String>> infoMap) {
        if (null != orderMap) {
            HashSet<Object> closeSet = new HashSet<Object>(20);
            String message = ResManager.loadKDString((String)"\u201c\u9886\u6599\u72b6\u6001\u201d\u3001\u201c\u4efb\u52a1\u72b6\u6001\u201d\u3001\u201c\u5de5\u5e8f\u72b6\u6001\u201d\u4e0d\u5728\u624b\u5de5\u5173\u95ed\u53c2\u6570\u503c\u8303\u56f4\u5185\u3002", (String)"OrderCloseTplUtils_31", (String)"bd-mpdm-common", (Object[])new Object[0]) + "\n";
            logger.info(String.format("\u51c6\u5907\u8fc7\u6ee4\u6570\u636e:\u5de5\u5355\u624b\u5de5\u5173\u95ed,\u539f\u56e0\uff1a%s", message));
            for (Map.Entry<Object, Map<String, Object>> entry : orderMap.entrySet()) {
                Object key = entry.getKey();
                Map<String, Object> value = entry.getValue();
                if (value == null) continue;
                Object pickstatus = value.get("pickstatus");
                Object taskstatus = value.get("taskstatus");
                Object oprstatus = value.get("oprstatus");
                if (pickstatus != null && "1".equals(pickstatus.toString())) {
                    closeSet.add(key);
                }
                if (taskstatus != null && "1".equals(taskstatus.toString())) {
                    closeSet.add(key);
                }
                if (oprstatus == null || !"1".equals(oprstatus.toString())) continue;
                closeSet.add(key);
            }
            for (Map.Entry<Object, Map<String, Object>> entry : closeSet) {
                Long pid = NumberUtils.toLong((String)entry.toString());
                List<String> infoList = infoMap.get(pid);
                if (null == infoList) {
                    ArrayList<String> tempInfoList = new ArrayList<String>();
                    tempInfoList.add(message);
                    infoMap.put(pid, tempInfoList);
                } else {
                    infoList.add(message);
                }
                Iterator<Map.Entry<Object, Map<String, Object>>> iterator = orderMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Object idInMap;
                    Map.Entry<Object, Map<String, Object>> item = iterator.next();
                    if (null == item || null == (idInMap = item.getKey()) || !StringUtils.equals((CharSequence)idInMap.toString(), (CharSequence)pid.toString())) continue;
                    iterator.remove();
                    logger.info(String.format("\u5de5\u5355\u5173\u95ed\u8fc7\u6ee4\u6570\u636e\uff1a%s,\u539f\u56e0:%s", pid.toString(), message));
                }
            }
        }
    }

    private static void filterUnProStock(Map<Object, Map<String, Object>> copyOrderMap, Map<Object, Map<String, Object>> orderMap, Map<Object, DynamicObject> stockMap, Map<Long, List<String>> infoMap) {
        if (!copyOrderMap.isEmpty()) {
            String info = ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u7ec4\u4ef6\u6e05\u5355\u5b58\u5728\u201c\u9000\u6599\u201d\u4e3a\u662f\u4e14\u672a\u5b8c\u5168\u9000\u6599\u7684\u5206\u5f55\u3002", (String)"OrderCloseTplUtils_21", (String)"bd-mpdm-common", (Object[])new Object[0]);
            String controlscope = "";
            ArrayList<Object> orderEntryList = new ArrayList<Object>(16);
            for (Map.Entry<Object, Map<String, Object>> entry : copyOrderMap.entrySet()) {
                Object key = entry.getKey();
                Map<String, Object> value = entry.getValue();
                controlscope = (String)value.get("controlscope");
                DynamicObject dynamicObject = stockMap.get(key);
                if (null == dynamicObject) continue;
                DynamicObjectCollection stockEntrys = dynamicObject.getDynamicObjectCollection("stockentry");
                if ("C".equals(controlscope) || "A".equals(controlscope)) {
                    for (DynamicObject stockEntry : stockEntrys) {
                        if (!stockEntry.getBoolean("iscannegative") || stockEntry.getBigDecimal("wipqty").compareTo(BigDecimal.ZERO) <= 0) continue;
                        orderEntryList.add(key);
                    }
                    continue;
                }
                if (!"B".equals(controlscope)) continue;
                for (DynamicObject stockEntry : stockEntrys) {
                    if (!stockEntry.getBoolean("iscannegative") || !stockEntry.getBoolean("iskeypart") || stockEntry.getBigDecimal("wipqty").compareTo(BigDecimal.ZERO) <= 0) continue;
                    orderEntryList.add(key);
                }
            }
            for (Map.Entry<Object, Map<String, Object>> entry : orderEntryList) {
                List<String> infoList = infoMap.get(entry);
                if (null != infoList && infoList.size() > 0) {
                    infoList.add(info);
                } else {
                    infoList = new ArrayList<String>(10);
                    infoList.add(info);
                }
                infoMap.put((Long)((Object)entry), infoList);
                if (null == orderMap.get(entry)) continue;
                orderMap.remove(entry);
                logger.info(String.format("\u751f\u4ea7\u5de5\u5355\u5173\u95ed\u8fc7\u6ee4\u6570\u636e\uff1a%s,\u539f\u56e0:%s", entry, info));
            }
        }
    }

    private static Set<String> filterUnAuditBillByEntityId(Map<Long, List<String>> infoMap, Map<Object, Map<String, Object>> orderMap, String entityid) {
        HashSet<String> result = new HashSet<String>(10);
        if (orderMap.isEmpty()) {
            return result;
        }
        String orderEntryName = "billentry.manuentryid";
        if ("sfc_manftech".equals(entityid)) {
            orderEntryName = "mftentryseq.id";
        } else if ("sfc_processreportbill".equals(entityid)) {
            orderEntryName = "sumentry.manufactureentryid";
        } else if ("pom_mftorderreport".equals(entityid)) {
            orderEntryName = "sumentry.mftentryid";
        }
        if ("pom_xmftstock".equals(entityid)) {
            orderEntryName = "stockentry.entryorderentryid";
        } else if ("pom_xmftorder".equals(entityid)) {
            orderEntryName = "treeentryentity.srcbillentryid";
        } else if ("sfc_reportresource_adjust".equals(entityid)) {
            orderEntryName = "sumentry.manufactureentryid";
        }
        QFilter filter = OrderCloseTplUtils.genFilterByEntityId(orderMap, entityid, orderEntryName);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PomOrderCloseUtilsFilter", (String)entityid, (String)orderEntryName, (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String id = row.getString(orderEntryName);
                result.add(id);
            }
            if (null != result && result.size() > 0) {
                logger.info(String.format("\u5de5\u5355\u5173\u95ed\u65f6\u6821\u9a8c\u4e0b\u6e38\u672a\u5ba1\u6838\u7684%s\u6570\u636e\uff0c\u8fc7\u6ee4\u6570\u636e\uff1a%s", entityid, ((Object)result).toString()));
            }
        }
        return result;
    }

    private static QFilter genFilterByEntityId(Map<Object, Map<String, Object>> orderMap, String entityid, String orderEntryName) {
        if ("sfc_manftech".equals(entityid)) {
            QFilter filter = new QFilter(orderEntryName, "in", orderMap.keySet());
            filter.and(new QFilter("oprentryentity.oprstatus", "!=", (Object)"F"));
            filter.and(new QFilter("oprentryentity.oprctrlstrategy.reportmethod", "=", (Object)"1008"));
            filter.and(new QFilter("oprentryentity.oprinvalid", "=", (Object)"0"));
            return filter;
        }
        if ("sfc_processreportbill".equals(entityid)) {
            QFilter profilter = new QFilter(orderEntryName, "in", orderMap.keySet());
            profilter.and(new QFilter("billstatus", "!=", (Object)"C"));
            return profilter;
        }
        if ("pom_mftorderreport".equals(entityid)) {
            Set<Object> keySet = orderMap.keySet();
            ArrayList<String> stringId = new ArrayList<String>(16);
            for (Object key : keySet) {
                stringId.add(key.toString());
            }
            QFilter profilter = new QFilter(orderEntryName, "in", stringId);
            profilter.and(new QFilter("billstatus", "!=", (Object)"C"));
            return profilter;
        }
        if ("pom_xmftstock".equals(entityid)) {
            QFilter filter = new QFilter("billstatus", "!=", (Object)"C");
            filter.and(new QFilter(orderEntryName, "in", orderMap.keySet()));
            return filter;
        }
        if ("pom_xmftorder".equals(entityid)) {
            ArrayList<String> srcEntryIdStrList = new ArrayList<String>(10);
            for (Object key : orderMap.keySet()) {
                if (null == key) continue;
                String keyStr = key.toString();
                srcEntryIdStrList.add(keyStr);
            }
            QFilter filter = new QFilter("billstatus", "!=", (Object)"C");
            filter.and(new QFilter(orderEntryName, "in", srcEntryIdStrList));
            return filter;
        }
        if ("sfc_reportresource_adjust".equals(entityid)) {
            ArrayList<Object> idList = new ArrayList<Object>(16);
            for (Map.Entry<Object, Map<String, Object>> entry : orderMap.entrySet()) {
                Map<String, Object> tempMap = entry.getValue();
                if (!((Boolean)tempMap.get("isprocedure")).booleanValue()) continue;
                idList.add(entry.getKey());
            }
            QFilter profilter = new QFilter(orderEntryName, "in", idList);
            profilter.and(new QFilter("billstatus", "!=", (Object)"C"));
            return profilter;
        }
        QFilter filter = new QFilter(orderEntryName, "in", orderMap.keySet());
        filter.and(new QFilter("billstatus", "!=", (Object)"C"));
        if ("im_mdc_mftmanuinbill".equals(entityid)) {
            filter.and(new QFilter("biztype.number", "=", (Object)"330"));
        } else if ("im_mdc_mftreturnbill".equals(entityid)) {
            filter.and(new QFilter("biztype.number", "=", (Object)"3301"));
        } else if ("im_mdc_mftproorder".equals(entityid)) {
            filter.and(new QFilter("biztype.number", "=", (Object)"320"));
            filter.and(new QFilter("invscheme.number", "!=", (Object)"361"));
        } else if ("im_mdc_mftreturnorder".equals(entityid)) {
            filter.and(new QFilter("biztype.number", "=", (Object)"3201"));
        } else if ("im_mdc_mftfeedorder".equals(entityid)) {
            filter.and(new QFilter("biztype.number", "=", (Object)"320"));
            filter.and(new QFilter("invscheme.number", "=", (Object)"361"));
        }
        return filter;
    }

    private static void checkOmMftTechnics(Map<Object, Map<String, Object>> orderMap) {
        if (null != orderMap && null != orderMap.keySet()) {
            logger.info(String.format("\u8fc7\u6ee4\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b.\u542f\u7528\u5de5\u5e8f\u7ba1\u7406=\u662f+\u4e0b\u6e38\u5de5\u5e8f\u8ba1\u5212\u5de5\u5e8f\u5168\u90e8\u5b8c\u5de5\u4e0d\u7b26\u5408\u6570\u636e\uff0c\u4f20\u53c2:%s", orderMap.keySet().toString()));
            String entityid = "om_mfttechnics";
            String srcBillEntryIdName = "mftentryseq.id";
            Set<String> filterList = OrderCloseTplUtils.filterUnAuditBillByEntityId(orderMap, entityid, srcBillEntryIdName);
            if (null != orderMap && null != filterList && filterList.size() > 0) {
                for (String id : filterList) {
                    Iterator<Map.Entry<Object, Map<String, Object>>> iterator = orderMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Object idInMap;
                        Map.Entry<Object, Map<String, Object>> item = iterator.next();
                        if (null == item || null == (idInMap = item.getKey()) || !StringUtils.equals((CharSequence)idInMap.toString(), (CharSequence)id)) continue;
                        iterator.remove();
                        logger.info(String.format("\u59d4\u5916\u5de5\u5355\u5173\u95ed\u8fc7\u6ee4\u6570\u636e\uff1a%s,\u539f\u56e0:\u5df2\u542f\u7528\u5de5\u5e8f\u7ba1\u7406\u4f46\u4e0b\u6e38\u5de5\u5e8f\u672a\u5168\u90e8\u5b8c\u5de5\u6216\u4f5c\u5e9f", id));
                    }
                }
            }
        }
    }

    private static void dealFilerData(Map<Object, Map<String, Object>> orderMap, Set<String> filterList, Map<Long, List<String>> infoMap, String info) {
        if (null != orderMap && null != filterList && filterList.size() > 0) {
            logger.info(String.format("\u51c6\u5907\u8fc7\u6ee4\u6570\u636e:%s,\u539f\u56e0\uff1a%s", filterList.toString(), info));
            for (String id : filterList) {
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                Long idL = Long.parseLong(id);
                List<String> infoList = infoMap.get(idL);
                if (null == infoList) {
                    ArrayList<String> tempInfoList = new ArrayList<String>();
                    tempInfoList.add(info);
                    infoMap.put(idL, tempInfoList);
                } else {
                    infoList.add(info);
                }
                Iterator<Map.Entry<Object, Map<String, Object>>> iterator = orderMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Object idInMap;
                    Map.Entry<Object, Map<String, Object>> item = iterator.next();
                    if (null == item || null == (idInMap = item.getKey()) || !StringUtils.equals((CharSequence)idInMap.toString(), (CharSequence)id)) continue;
                    iterator.remove();
                    logger.info(String.format("\u59d4\u5916\u5de5\u5355\u5173\u95ed\u8fc7\u6ee4\u6570\u636e\uff1a%s,\u539f\u56e0:%s", id, info));
                }
            }
        }
    }

    private static Set<String> filterUnAuditBillByEntityId(Map<Object, Map<String, Object>> orderMap, String entityid, String srcBillEntryIdName) {
        HashSet<String> result = new HashSet<String>(10);
        if (null != orderMap && null != orderMap.keySet()) {
            QFilter filter = OrderCloseTplUtils.genOMFilterByEntityId(orderMap, entityid, srcBillEntryIdName);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OmOrderCloseUtilsFilter", (String)entityid, (String)srcBillEntryIdName, (QFilter[])new QFilter[]{filter}, (String)"");){
                while (dataSet.hasNext()) {
                    String id;
                    Row row = dataSet.next();
                    if (null == row || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{id = row.getString(srcBillEntryIdName)})) continue;
                    result.add(id);
                }
            }
            if (null != result && result.size() > 0) {
                logger.info(String.format("\u5de5\u5355\u5173\u95ed\u65f6\u6821\u9a8c\u4e0b\u6e38\u672a\u5ba1\u6838\u7684%s\u6570\u636e\uff0c\u8fc7\u6ee4\u6570\u636e\uff1a%s", entityid, ((Object)result).toString()));
            }
        }
        return result;
    }

    private static QFilter genOMFilterByEntityId(Map<Object, Map<String, Object>> orderMap, String entityid, String orderEntryName) {
        ArrayList<String> srcEntryIdStrList = new ArrayList<String>(10);
        for (Object key : orderMap.keySet()) {
            if (null == key) continue;
            String keyStr = key.toString();
            srcEntryIdStrList.add(keyStr);
        }
        QFilter filter = new QFilter("1", "=", (Object)1);
        switch (entityid) {
            case "om_processreport": {
                filter.and(new QFilter(orderEntryName, "in", orderMap.keySet()));
                filter.and(new QFilter("billstatus", "!=", (Object)"C"));
                break;
            }
            case "im_mdc_omcmplinbill": {
                filter.and(new QFilter(orderEntryName, "in", orderMap.keySet()));
                filter.and(new QFilter("billstatus", "!=", (Object)"C"));
                filter.and(new QFilter("billtype.billformid", "=", (Object)entityid));
                break;
            }
            case "im_mdc_omoutbill": {
                filter.and(new QFilter(orderEntryName, "in", orderMap.keySet()));
                filter.and(new QFilter("billstatus", "!=", (Object)"C"));
                filter.and(new QFilter("billtype.billformid", "=", (Object)entityid));
                break;
            }
            case "im_mdc_omreturnbill": {
                filter.and(new QFilter(orderEntryName, "in", orderMap.keySet()));
                filter.and(new QFilter("billstatus", "!=", (Object)"C"));
                filter.and(new QFilter("billtype.billformid", "=", (Object)entityid));
                break;
            }
            case "im_mdc_omfeedbill": {
                filter.and(new QFilter(orderEntryName, "in", orderMap.keySet()));
                filter.and(new QFilter("billstatus", "!=", (Object)"C"));
                filter.and(new QFilter("billtype.billformid", "=", (Object)entityid));
                break;
            }
            case "om_xmftorder": {
                filter.and(new QFilter(orderEntryName, "in", srcEntryIdStrList));
                filter.and(new QFilter("billstatus", "!=", (Object)"C"));
                break;
            }
            case "om_xmftstock": {
                filter.and(new QFilter(orderEntryName, "in", orderMap.keySet()));
                filter.and(new QFilter("billstatus", "!=", (Object)"C"));
                break;
            }
            case "pm_purapplybill": {
                filter.and(new QFilter(orderEntryName, "in", orderMap.keySet()));
                filter.and(new QFilter("billstatus", "!=", (Object)"C"));
                break;
            }
            case "pm_purorderbill": {
                filter.and(new QFilter(orderEntryName, "in", orderMap.keySet()));
                filter.and(new QFilter("billstatus", "!=", (Object)"C"));
                break;
            }
            case "om_mfttechnics": {
                filter.and(new QFilter(orderEntryName, "in", orderMap.keySet()));
                filter.and(new QFilter("oprentryentity.oprstatus", "!=", (Object)"F"));
                filter.and(new QFilter("oprentryentity.oprinvalid", "=", (Object)"0"));
                break;
            }
            default: {
                filter.and(new QFilter("1", "!=", (Object)1));
            }
        }
        return filter;
    }

    private static Set<String> filterUnAuditPropBillByEntityId(Map<Object, Map<String, Object>> orderMap, String entityid, String srcBillEntryIdName) {
        HashSet<String> result = new HashSet<String>(10);
        if (null != orderMap && null != orderMap.keySet()) {
            QFilter filter = OrderCloseTplUtils.genPropFilterByEntityId(orderMap, entityid, srcBillEntryIdName);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PropOrderCloseUtilsFilter", (String)entityid, (String)srcBillEntryIdName, (QFilter[])new QFilter[]{filter}, (String)"");){
                while (dataSet.hasNext()) {
                    String id;
                    Row row = dataSet.next();
                    if (null == row || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{id = row.getString(srcBillEntryIdName)})) continue;
                    result.add(id);
                }
            }
            if (null != result && result.size() > 0) {
                logger.info(String.format("\u5de5\u5355\u5173\u95ed\u65f6\u6821\u9a8c\u4e0b\u6e38\u672a\u5ba1\u6838\u7684%s\u6570\u636e\uff0c\u8fc7\u6ee4\u6570\u636e\uff1a%s", entityid, ((Object)result).toString()));
            }
        }
        return result;
    }

    private static QFilter genPropFilterByEntityId(Map<Object, Map<String, Object>> orderMap, String entityid, String orderEntryName) {
        if ("prop_manftech".equals(entityid)) {
            QFilter filter = new QFilter(orderEntryName, "in", orderMap.keySet());
            filter.and(new QFilter("oprentryentity.oprstatus", "!=", (Object)"F"));
            filter.and(new QFilter("oprentryentity.oprctrlstrategy.reportmethod", "=", (Object)"1008"));
            filter.and(new QFilter("oprentryentity.oprinvalid", "=", (Object)"0"));
            return filter;
        }
        if ("prop_processreportbill".equals(entityid)) {
            QFilter profilter = new QFilter(orderEntryName, "in", orderMap.keySet());
            profilter.and(new QFilter("billstatus", "!=", (Object)"C"));
            return profilter;
        }
        if ("prop_mftorderreport".equals(entityid)) {
            Set<Object> keySet = orderMap.keySet();
            ArrayList<String> stringId = new ArrayList<String>(16);
            for (Object key : keySet) {
                stringId.add(key.toString());
            }
            QFilter profilter = new QFilter(orderEntryName, "in", stringId);
            profilter.and(new QFilter("billstatus", "!=", (Object)"C"));
            return profilter;
        }
        if ("prop_xmftstock".equals(entityid)) {
            QFilter filter = new QFilter("billstatus", "!=", (Object)"C");
            filter.and(new QFilter(orderEntryName, "in", orderMap.keySet()));
            return filter;
        }
        if ("prop_xmftorder".equals(entityid)) {
            ArrayList<String> srcEntryIdStrList = new ArrayList<String>(10);
            for (Object key : orderMap.keySet()) {
                if (null == key) continue;
                String keyStr = key.toString();
                srcEntryIdStrList.add(keyStr);
            }
            QFilter filter = new QFilter("billstatus", "!=", (Object)"C");
            filter.and(new QFilter(orderEntryName, "in", srcEntryIdStrList));
            return filter;
        }
        QFilter filter = new QFilter(orderEntryName, "in", orderMap.keySet());
        filter.and(new QFilter("billstatus", "!=", (Object)"C"));
        if ("im_mdc_mftmanuinbill".equals(entityid)) {
            filter.and(new QFilter("biztype.number", "=", (Object)"330"));
        } else if ("im_mdc_mftreturnbill".equals(entityid)) {
            filter.and(new QFilter("biztype.number", "=", (Object)"3301"));
        } else if ("im_mdc_mftproorder".equals(entityid)) {
            filter.and(new QFilter("biztype.number", "=", (Object)"320"));
            filter.and(new QFilter("invscheme.number", "!=", (Object)"361"));
        } else if ("im_mdc_mftreturnorder".equals(entityid)) {
            filter.and(new QFilter("biztype.number", "=", (Object)"3201"));
        } else if ("im_mdc_mftfeedorder".equals(entityid)) {
            filter.and(new QFilter("biztype.number", "=", (Object)"320"));
            filter.and(new QFilter("invscheme.number", "=", (Object)"361"));
        }
        return filter;
    }
}

