/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.mftorder.utils;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.enums.ManuBillPickStatusEnum;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;

public class OrderCloseUtils {
    private static final Log logger = LogFactory.getLog(OrderCloseUtils.class);
    private static final String ENTITY_ORDER = "orderEntity";
    private static final String ENTITY_STOCK = "stockEntity";
    private static final String ENTITY_OUTREQ = "reqoutEntity";

    public static Map<Object, DynamicObject> getStockMap(Set<Object> orderEntryidSet, String stockEntity) {
        DynamicObject[] stocks;
        HashMap<Object, DynamicObject> stockMap = new HashMap<Object, DynamicObject>(16);
        QFilter filter2 = new QFilter("orderentryid", "in", orderEntryidSet);
        for (DynamicObject stock : stocks = BusinessDataServiceHelper.load((String)stockEntity, (String)"stockentry,orderentryid,stockentry.iscannegative,stockentry.wipqty,stockentry.actissueqty,stockentry.feedingqty,stockentry.rejectedqty,stockentry.useqty,stockentry.iskeypart", (QFilter[])new QFilter[]{filter2})) {
            stockMap.put(stock.getDynamicObject("orderentryid").getPkValue(), stock);
        }
        return stockMap;
    }

    public static Map<Object, Map<String, Object>> getOrderCloseMapByAutoFlag(Map<Long, List<String>> infoMap, Set<Long> orderEntryidSet, Map<String, String> entityMap, boolean autoFlag) {
        Object transactiontype;
        HashMap<Object, Map<String, Object>> orderMap = new HashMap<Object, Map<String, Object>>(20);
        logger.info("getOrderCloseMapByAutoFlag------autoFlag:", (Object)autoFlag);
        QFilter orderQfilter = new QFilter("treeentryentity.id", "in", orderEntryidSet);
        orderQfilter.and(new QFilter("billstatus", "=", (Object)"C"));
        DynamicObject[] orders = BusinessDataServiceHelper.load((String)entityMap.get(ENTITY_ORDER), (String)"billno,transactiontype,transactiontype.isautoclose,transactiontype.autoclosebypro,treeentryentity,treeentryentity.pickstatus,treeentryentity.taskstatus,treeentryentity.pid", (QFilter[])new QFilter[]{orderQfilter});
        HashSet<Long> transactionSet = new HashSet<Long>(20);
        if (orders.length <= 0) {
            String errmsg = ResManager.loadKDString((String)"\u5de5\u5355\u5173\u95ed\uff0c\u672a\u627e\u5230\u5de5\u5355\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"OrderCloseUtils_1", (String)"bd-mpdm-common", (Object[])new Object[0]);
            logger.info(errmsg);
            return orderMap;
        }
        for (DynamicObject order : orders) {
            transactiontype = order.getDynamicObject("transactiontype");
            transactionSet.add(transactiontype.getLong("id"));
        }
        Map<Long, List<DynamicObject>> treeMap = OrderCloseUtils.getAutoclosebyproData(orders);
        QFilter filter = new QFilter("id", "in", transactionSet);
        HashMap transactiontypeMap = new HashMap(20);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryTransactiontype", (String)entityMap.get("transactEntity"), (String)"id,isforceclose,isprocedure,oprstatus,taskstatus,pickstatus,controlscope", (QFilter[])new QFilter[]{filter}, (String)"");
        transactiontype = null;
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long id = row.getLong("id");
                HashMap<String, String> statusMap = new HashMap<String, String>(20);
                statusMap.put("oprstatus", row.getString("oprstatus"));
                statusMap.put("pickstatus", row.getString("pickstatus"));
                statusMap.put("taskstatus", row.getString("taskstatus"));
                transactiontypeMap.put(id, statusMap);
            }
        }
        catch (Throwable row) {
            transactiontype = row;
            throw row;
        }
        finally {
            if (dataSet != null) {
                if (transactiontype != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)transactiontype).addSuppressed(row);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        HashMap manftechMap = new HashMap(20);
        QFilter filter2 = new QFilter("mftentryseq.id", "in", orderEntryidSet);
        try (DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)"querySfcManftech", (String)entityMap.get("manftechEntity"), (String)"id,oprentryentity.id,oprentryentity.oprstatus,mftentryseq.id", (QFilter[])new QFilter[]{filter2}, (String)"");){
            while (dataSet2.hasNext()) {
                HashMap<String, String> statusMap;
                Row row = dataSet2.next();
                Long mftentryid = row.getLong("mftentryseq.id");
                Long entryid = row.getLong("oprentryentity.id");
                if (entryid <= 0L) continue;
                String oprstatus = row.getString("oprentryentity.oprstatus");
                if (manftechMap.containsKey(mftentryid)) {
                    statusMap = (HashMap<String, String>)manftechMap.get(mftentryid);
                    statusMap.put(oprstatus, oprstatus);
                    manftechMap.put(mftentryid, statusMap);
                    continue;
                }
                statusMap = new HashMap<String, String>(20);
                statusMap.put(oprstatus, oprstatus);
                manftechMap.put(mftentryid, statusMap);
            }
        }
        for (DynamicObject order : orders) {
            DynamicObject transactiontype2 = order.getDynamicObject("transactiontype");
            if (autoFlag && !transactiontype2.getBoolean("isautoclose")) {
                String errmsg = String.format(ResManager.loadKDString((String)"\u5de5\u5355\u5173\u95ed\uff0c\u5de5\u5355%1$s\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u672a\u5f00\u542f\u81ea\u52a8\u5173\u95ed\u3002", (String)"OrderCloseUtils_2", (String)"bd-mpdm-common", (Object[])new Object[0]), order.getString("billno"));
                logger.info(errmsg);
                continue;
            }
            boolean autoclosebypro = transactiontype2.getBoolean("autoclosebypro");
            Long tranid = (Long)transactiontype2.getPkValue();
            DynamicObjectCollection orderEntrys = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntrys) {
                Long entryid = (Long)orderEntry.getPkValue();
                if (!orderEntryidSet.contains(entryid)) continue;
                String pickstatus = orderEntry.getString("pickstatus");
                String taskstatus = orderEntry.getString("taskstatus");
                if (!autoFlag || (ManuBillPickStatusEnum.ENDWORK.getValue().equals(pickstatus) || ManuBillPickStatusEnum.SOMEENDWORK.getValue().equals(pickstatus)) && StringUtils.equals((CharSequence)taskstatus, (CharSequence)"C")) {
                    HashMap<String, Object> orderEntryMap = new HashMap<String, Object>(16);
                    orderEntryMap.put("isprocedure", transactiontype2.getBoolean("isprocedure"));
                    orderEntryMap.put("controlscope", transactiontype2.getString("controlscope"));
                    orderEntryMap.put("closeclear", transactiontype2.getBoolean("closeclear"));
                    if (transactiontypeMap.containsKey(tranid) && !autoFlag) {
                        Map tranMap = (Map)transactiontypeMap.get(tranid);
                        if (StringUtils.isNotBlank((CharSequence)((CharSequence)tranMap.get("pickstatus"))) && ((String)tranMap.get("pickstatus")).indexOf(pickstatus) < 0) {
                            orderEntryMap.put("pickstatus", "1");
                        }
                        if (StringUtils.isNotBlank((CharSequence)((CharSequence)tranMap.get("taskstatus"))) && ((String)tranMap.get("taskstatus")).indexOf(taskstatus) < 0) {
                            orderEntryMap.put("taskstatus", "1");
                        }
                        if (manftechMap.containsKey(entryid) && transactiontype2.getBoolean("isprocedure")) {
                            Map manftechStatusMap = (Map)manftechMap.get(entryid);
                            for (Map.Entry entry : manftechStatusMap.entrySet()) {
                                String key = (String)entry.getKey();
                                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)tranMap.get("oprstatus"))) || ((String)tranMap.get("oprstatus")).indexOf(key) >= 0) continue;
                                orderEntryMap.put("oprstatus", "1");
                                break;
                            }
                        }
                    }
                    if (autoFlag && autoclosebypro) {
                        List<DynamicObject> list = treeMap.get(entryid);
                        ArrayList<String> tempInfoList = new ArrayList<String>(8);
                        if (list != null && !list.isEmpty()) {
                            for (DynamicObject dynamicObject : list) {
                                String protaskstatus = dynamicObject.getString("taskstatus");
                                if (StringUtils.equals((CharSequence)protaskstatus, (CharSequence)"C")) continue;
                                tempInfoList.add(String.format(ResManager.loadKDString((String)"\u5de5\u5355\u5173\u95ed\u65f6\u6839\u636e\u5de5\u5355\u5206\u5f55id\u83b7\u53d6\u5de5\u5355\u5bf9\u5e94\u7684\u4e8b\u52a1\u7c7b\u578b\u548c\u5206\u5f55\u5bf9\u8c61\u6570\u636e\u88ab\u8fc7\u6ee4\uff0c\u5f00\u542f\u81ea\u52a8\u5173\u95ed\u8003\u8651\u8054\u526f\u4ea7\u54c1\u6570\u636e\u6821\u9a8c\u672a\u901a\u8fc7\uff0cid\uff1a%1$s\uff0c\u4efb\u52a1\u72b6\u6001\uff1a%2$s\u3002", (String)"OrderCloseUtils_3", (String)"bd-mpdm-common", (Object[])new Object[0]), orderEntry.getPkValue().toString(), protaskstatus));
                            }
                        }
                        if (!tempInfoList.isEmpty()) {
                            infoMap.put(entryid, tempInfoList);
                            continue;
                        }
                    }
                    orderEntryMap.put("dym", orderEntry);
                    orderEntryMap.put("billno", order.getString("billno"));
                    orderMap.put(orderEntry.getPkValue(), orderEntryMap);
                    logger.info(String.format("\u6839\u636e\u5de5\u5355\u5206\u5f55id\u83b7\u53d6\u5de5\u5355\u5bf9\u5e94\u7684\u4e8b\u52a1\u7c7b\u578b\u548c\u5206\u5f55\u5bf9\u8c61\u83b7\u5f97:%s", orderEntry.getPkValue().toString()));
                    continue;
                }
                if (autoFlag && (!ManuBillPickStatusEnum.ENDWORK.getValue().equals(pickstatus) && !ManuBillPickStatusEnum.SOMEENDWORK.getValue().equals(pickstatus) || !StringUtils.equals((CharSequence)taskstatus, (CharSequence)"C"))) {
                    logger.info(String.format("\u5de5\u5355\u5173\u95ed\u65f6\u6839\u636e\u5de5\u5355\u5206\u5f55id\u83b7\u53d6\u5de5\u5355\u5bf9\u5e94\u7684\u4e8b\u52a1\u7c7b\u578b\u548c\u5206\u5f55\u5bf9\u8c61\u6570\u636e\u88ab\u8fc7\u6ee4\uff0cid:%s,\u4efb\u52a1\u72b6\u6001\uff1a%s,\u9886\u6599\u72b6\u6001:%s", orderEntry.getPkValue().toString(), taskstatus, pickstatus));
                    continue;
                }
                if (autoFlag) continue;
                ArrayList<String> tempInfoList = new ArrayList<String>(8);
                tempInfoList.add(String.format(ResManager.loadKDString((String)"\u5de5\u5355\u5173\u95ed\u65f6\u6839\u636e\u5de5\u5355\u5206\u5f55id\u83b7\u53d6\u5de5\u5355\u5bf9\u5e94\u7684\u4e8b\u52a1\u7c7b\u578b\u548c\u5206\u5f55\u5bf9\u8c61\u6570\u636e\u88ab\u8fc7\u6ee4\uff0cid\uff1a%1$s\uff0c\u4efb\u52a1\u72b6\u6001\uff1a%2$s\uff0c\u9886\u6599\u72b6\u6001\uff1a%3$s\u3002", (String)"OrderCloseUtils_0", (String)"bd-mpdm-common", (Object[])new Object[0]), orderEntry.getPkValue().toString(), taskstatus, pickstatus));
                infoMap.put(entryid, tempInfoList);
            }
        }
        return orderMap;
    }

    public static void closeOrder(Map<Object, Map<String, Object>> orderMap, Map<Object, DynamicObject> stockMap, String orderEntityId) {
        HashMap<String, Object> calparam;
        DynamicObject[] orders;
        if (orderMap.isEmpty()) {
            return;
        }
        long currentUserId = UserServiceHelper.getCurrentUserId();
        ArrayList<String> orderbillnos = new ArrayList<String>(16);
        HashSet<Long> orderEntryIds = new HashSet<Long>(16);
        logger.info(String.format("\u5de5\u5355\u5173\u95ed\uff0c\u5165\u53c2\u6570\u636e:%s", orderMap.keySet().toString()));
        QFilter orderQfilter = new QFilter("treeentryentity.id", "in", orderMap.keySet());
        for (DynamicObject order : orders = BusinessDataServiceHelper.load((String)orderEntityId, (String)"billno,treeentryentity.producttype,treeentryentity.bizstatus,treeentryentity.closetime,treeentryentity.closer,treeentryentity.pid", (QFilter[])new QFilter[]{orderQfilter})) {
            orderbillnos.add(order.getString("billno"));
            DynamicObjectCollection entryCol = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : entryCol) {
                if (!orderMap.containsKey(entry.getPkValue()) || !"C".equals(entry.getString("producttype"))) continue;
                entry.set("bizstatus", (Object)"C");
                entry.set("closetime", (Object)new Date());
                entry.set("closer", (Object)currentUserId);
                orderEntryIds.add(entry.getLong("id"));
                logger.info(String.format("\u5de5\u5355\u5173\u95ed\uff0c\u5206\u5f55ID\u4e3a:%s", entry.getPkValue().toString()));
                OrderCloseUtils.updateStatusByMainProduct(entryCol, entry.getPkValue());
            }
        }
        SaveServiceHelper.update((DynamicObject[])orders);
        DynamicObjectCollection entryEntity = orders[0].getDynamicObjectCollection("treeentryentity");
        if (!entryEntity.isEmpty()) {
            IDataEntityType dataEntityType = ((DynamicObject)entryEntity.get(0)).getDataEntityType();
            DataEntityCacheManager cacheManager = new DataEntityCacheManager(dataEntityType);
            cacheManager.removeByDt();
        }
        ArrayList<DynamicObject> stockList = new ArrayList<DynamicObject>(16);
        for (Map.Entry<Object, Map<String, Object>> entry : orderMap.entrySet()) {
            Object key = entry.getKey();
            Map<String, Object> value = entry.getValue();
            if (!((Boolean)value.get("closeclear")).booleanValue()) continue;
            stockList.add(stockMap.get(key));
        }
        if (!stockList.isEmpty()) {
            OrderCloseUtils.clearStockWipqty(stockList);
        }
        if (StringUtils.equals((CharSequence)"pom_mftorder", (CharSequence)orderEntityId)) {
            calparam = new HashMap<String, Object>();
            calparam.put("mftorderentryids", orderMap.keySet());
            calparam.put("mftorderbillnos", orderbillnos);
            OrderCloseUtils.calMaccService(calparam);
        }
        if (!orderEntryIds.isEmpty()) {
            calparam = new HashMap(20);
            calparam.put("orderentryids", orderEntryIds);
            calparam.put("modetype", "closebookdate");
            calparam.put("pageEntity", orderEntityId);
            calparam.put("optype", "shut");
            String jsonString = JSON.toJSONString(calparam);
            logger.info(String.format("start invoke mftorder.setbookdate:%s", jsonString));
            EventServiceHelper.triggerEventSubscribe((String)"mftorder.setbookdate", (String)jsonString);
        }
    }

    private static void clearStockWipqty(List<DynamicObject> stockList) {
        DynamicObject[] stocks;
        for (DynamicObject stock : stocks = stockList.toArray(new DynamicObject[stockList.size()])) {
            DynamicObjectCollection stockEntryDym = stock.getDynamicObjectCollection("stockentry");
            if (stockEntryDym == null) continue;
            for (int i = 0; i < stockEntryDym.size(); ++i) {
                DynamicObject stockEntry = (DynamicObject)stockEntryDym.get(i);
                BigDecimal actissueQty = stockEntry.getBigDecimal("actissueqty");
                BigDecimal feedingQty = stockEntry.getBigDecimal("feedingqty");
                BigDecimal rejectedQty = stockEntry.getBigDecimal("rejectedqty");
                stockEntry.set("wipqty", (Object)0);
                if (stockEntry.getBoolean("iscannegative")) {
                    stockEntry.set("useqty", (Object)0);
                    continue;
                }
                stockEntry.set("useqty", (Object)actissueQty.add(feedingQty).subtract(rejectedQty));
            }
        }
        SaveServiceHelper.update((DynamicObject[])stocks);
    }

    public static void calMaccService(Map<String, Object> calcParam) {
        String jsonString = JSON.toJSONString(calcParam);
        EventServiceHelper.triggerEventSubscribe((String)"pom_mftorder.closeorder", (String)jsonString);
    }

    private static void updateStatusByMainProduct(DynamicObjectCollection entryCol, Object pkValue) {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        for (int j = 0; j < entryCol.size(); ++j) {
            DynamicObject entry = (DynamicObject)entryCol.get(j);
            if (!entry.get("pid").equals(pkValue)) continue;
            entry.set("bizstatus", (Object)"C");
            entry.set("closetime", (Object)new Date());
            entry.set("closer", (Object)currentUserId);
        }
    }

    public static Map<String, String> setEntityName(String orderEntity) {
        HashMap<String, String> entityMap = new HashMap<String, String>(16);
        if ("om_mftorder".equals(orderEntity)) {
            entityMap.put(ENTITY_ORDER, "om_mftorder");
            entityMap.put(ENTITY_STOCK, "om_mftstock");
            entityMap.put(ENTITY_OUTREQ, "im_mdc_omoutbill");
        } else {
            entityMap.put(ENTITY_ORDER, "pom_mftorder");
            entityMap.put(ENTITY_STOCK, "pom_mftstock");
            entityMap.put(ENTITY_OUTREQ, "im_mdc_mftproorder");
        }
        return entityMap;
    }

    public static Map<Long, List<DynamicObject>> getAutoclosebyproData(DynamicObject[] orders) {
        HashMap<Long, List<DynamicObject>> treeMap = new HashMap<Long, List<DynamicObject>>(16);
        for (DynamicObject order : orders) {
            DynamicObject transactiontype = order.getDynamicObject("transactiontype");
            boolean autoclosebypro = transactiontype.getBoolean("autoclosebypro");
            if (!autoclosebypro) continue;
            DynamicObjectCollection orderEntrys = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntrys) {
                ArrayList<DynamicObject> list;
                Long pid = orderEntry.getLong("pid");
                if (pid == 0L) continue;
                if (treeMap.containsKey(pid)) {
                    list = (ArrayList<DynamicObject>)treeMap.get(pid);
                    list.add(orderEntry);
                    treeMap.put(pid, list);
                    continue;
                }
                list = new ArrayList<DynamicObject>(10);
                list.add(orderEntry);
                treeMap.put(pid, list);
            }
        }
        return treeMap;
    }
}

