/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.mftorder.utils;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.CreateStockUtils;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.mftorder.utils.OrderBaseData;
import kd.bd.mpdm.common.mftorder.utils.StockOpUtils;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsBomQueryHelper;
import kd.bd.mpdm.common.stockchange.utils.EntityNameUtils;
import kd.bd.mpdm.common.utils.MulBaseDataUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class OrderOpUtils {
    private static final String CHAR_S = ";";

    private OrderOpUtils() {
    }

    public static void beforeExeData(BeforeOperationArgs e, List<DynamicObject> savedataEntities, List<DynamicObject> updatedataEntities, Set<Long> deleteStockIds, Log logger, String stockname, OperationResult op) {
        Object[] objs = e.getDataEntities();
        IDataEntityType type = e.getDataEntities()[0].getDataEntityType();
        DBRoute rt = new DBRoute(type.getDBRouteKey());
        SequenceReader seqReader = new SequenceReader(rt);
        seqReader.autoSetPrimaryKey(objs, type);
        List dataEntities = e.getValidExtDataEntities();
        ArrayList<ExtendedDataEntity> passedDataEntitys = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        ArrayList<DynamicObject> orderList = new ArrayList<DynamicObject>(dataEntities.size());
        for (ExtendedDataEntity dataEntity : e.getValidExtDataEntities()) {
            orderList.add(dataEntity.getDataEntity());
        }
        OrderBaseData baseData = CreateStockUtils.getStocks(orderList, "save", stockname);
        savedataEntities.addAll(baseData.getSaveStocks());
        updatedataEntities.addAll(baseData.getUpdateStocks());
        deleteStockIds.addAll(baseData.getDeleteOrderEntryIds());
        Map<Long, String> orderErrInfoMap = baseData.getOrderErrInfoMap();
        for (ExtendedDataEntity dataEntity : e.getValidExtDataEntities()) {
            DynamicObject obj = dataEntity.getDataEntity();
            String err = orderErrInfoMap.get((Long)obj.getPkValue());
            if (err != null) {
                OperateErrorInfo errorInfo = new OperateErrorInfo("genOneStock", ErrorLevel.FatalError, obj.getPkValue());
                errorInfo.setMessage(obj.getString("billno") + ":" + StringUtils.strip((String)err, (String)"[]"));
                errorInfo.setTitle(ResManager.loadKDString((String)"\u751f\u6210\u7ec4\u4ef6\u6e05\u5355", (String)"OrderOpUtils_0", (String)"bd-mpdm-common", (Object[])new Object[0]));
                op.getAllErrorInfo().add(errorInfo);
                ArrayList<DynamicObject> removeStocks = new ArrayList<DynamicObject>(16);
                for (DynamicObject stock : savedataEntities) {
                    String orderId = stock.getString("orderid");
                    if (!orderId.equals(obj.getPkValue().toString())) continue;
                    removeStocks.add(stock);
                }
                if (removeStocks.isEmpty()) continue;
                savedataEntities.removeAll(removeStocks);
                continue;
            }
            passedDataEntitys.add(dataEntity);
        }
        if (passedDataEntitys.isEmpty()) {
            e.cancel = true;
            e.setCancelMessage(ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25", (String)"OrderOpUtils_1", (String)"bd-mpdm-common", (Object[])new Object[0]));
        } else {
            e.getValidExtDataEntities().clear();
            e.getValidExtDataEntities().addAll(passedDataEntitys);
        }
    }

    public static void updateStock(EndOperationTransactionArgs e, List<DynamicObject> savedataEntities, List<DynamicObject> updatedataEntities) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (!savedataEntities.isEmpty()) {
            OrderOpUtils.setOrderNo(savedataEntities, dataEntities);
        }
        if (!updatedataEntities.isEmpty()) {
            OrderOpUtils.setOrderNo(updatedataEntities, dataEntities);
        }
    }

    private static void setOrderNo(List<DynamicObject> savedataEntities, DynamicObject[] dataEntities) {
        HashMap<String, Object> cacheMap = new HashMap<String, Object>(dataEntities.length);
        for (DynamicObject order : dataEntities) {
            cacheMap.put(order.getPkValue().toString(), order.get("billno"));
        }
        for (DynamicObject saveData : savedataEntities) {
            String orderid = saveData.getString("orderid");
            if (!cacheMap.containsKey(orderid)) continue;
            saveData.set("orderno", cacheMap.get(orderid));
        }
        cacheMap.clear();
        cacheMap = null;
    }

    public static void handleStock(String stockname, List<DynamicObject> savedataEntities, List<DynamicObject> updatedataEntities, Set<Long> deleteStockIds, Log logger) {
        HashSet<Long> stockIdSet = new HashSet<Long>(16);
        if (!deleteStockIds.isEmpty()) {
            MPDMMftGenStocksUtils.deleteOrderStock(deleteStockIds, stockname);
        }
        if (!savedataEntities.isEmpty()) {
            ArrayList<DynamicObject> innerStocks = new ArrayList<DynamicObject>(16);
            ArrayList<DynamicObject> otherStocks = new ArrayList<DynamicObject>(16);
            if ("pom_mftstock".equals(stockname) || "prop_mftstock".equals(stockname)) {
                for (DynamicObject saveStock : savedataEntities) {
                    DynamicObject tran = saveStock.getDynamicObject("transactiontypeid");
                    if (tran != null) {
                        boolean isinnerprocess = tran.getBoolean("isinnerprocess");
                        if (isinnerprocess) {
                            innerStocks.add(saveStock);
                            continue;
                        }
                        otherStocks.add(saveStock);
                        continue;
                    }
                    otherStocks.add(saveStock);
                }
            } else {
                otherStocks.addAll(savedataEntities);
            }
            if (!otherStocks.isEmpty()) {
                OrderOpUtils.toStockByBotp(savedataEntities, stockname, logger, stockIdSet);
            }
            if (!innerStocks.isEmpty()) {
                String orderName = EntityNameUtils.getEntityName(1, 0, stockname);
                TableDefine targetTableDefine = EntityMetadataCache.loadTableDefine((String)stockname, (String)"stockentry");
                TableDefine srcTableDefine = EntityMetadataCache.loadTableDefine((String)orderName, (String)"treeentryentity");
                String lkEntryKey = targetTableDefine.getEntityKey() + "_lk";
                String lkHeadKey = "billhead_lk";
                for (DynamicObject innerStock : innerStocks) {
                    DynamicObjectCollection stockEntrys = innerStock.getDynamicObjectCollection("stockentry");
                    if (stockEntrys.size() < 1) {
                        DynamicObjectCollection linkRows = innerStock.getDynamicObjectCollection(lkHeadKey);
                        linkRows.clear();
                        DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
                        linkRows.add((Object)linkRow);
                        linkRow.set(lkHeadKey + "_stableid", (Object)srcTableDefine.getTableId());
                        linkRow.set(lkHeadKey + "_sbillid", innerStock.get("orderid"));
                        linkRow.set(lkHeadKey + "_sid", innerStock.get("orderentryid"));
                        continue;
                    }
                    for (DynamicObject targetRow : stockEntrys) {
                        DynamicObjectCollection linkRows = targetRow.getDynamicObjectCollection(lkEntryKey);
                        if (!linkRows.isEmpty() || linkRows.getDynamicObjectType() == null) continue;
                        DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
                        linkRows.add((Object)linkRow);
                        linkRow.set(lkEntryKey + "_stableid", (Object)srcTableDefine.getTableId());
                        linkRow.set(lkEntryKey + "_sbillid", innerStock.get("orderid"));
                        linkRow.set(lkEntryKey + "_sid", innerStock.get("orderentryid"));
                    }
                }
                OperateOption create = OperateOption.create();
                create.setVariableValue("ishasright", "true");
                create.setVariableValue("ignorewarn", "true");
                create.setVariableValue("ignoreinteraction", "true");
                OperationResult saveOperate = SaveServiceHelper.saveOperate((String)stockname, (DynamicObject[])innerStocks.toArray(new DynamicObject[innerStocks.size()]), (OperateOption)create);
                if (!saveOperate.isSuccess()) {
                    throw new KDBizException(new ErrorCode("AutoGenerateStock3", String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4fdd\u5b58\u7ec4\u4ef6\u6e05\u5355\u5f02\u5e38\uff1a%1$s", (String)"OrderOpUtils_8", (String)"bd-mpdm-common", (Object[])new Object[0]), OrderOpUtils.getErrDetail(saveOperate))), new Object[0]);
                }
                StockOpUtils.addStockIdToSet(stockIdSet, saveOperate);
            }
        }
        if (!updatedataEntities.isEmpty()) {
            long start = System.currentTimeMillis();
            OrderOpUtils.updateBill(updatedataEntities);
            long end = System.currentTimeMillis() - start;
            logger.info("" + end);
        }
        StockOpUtils.callOrderToStock(stockname, updatedataEntities, stockIdSet);
    }

    public static void updateBill(List<DynamicObject> updatedataEntities) {
        HashMap<String, DynamicObject> stockMap = new HashMap<String, DynamicObject>(16);
        ArrayList<String> stockId = new ArrayList<String>(16);
        for (DynamicObject updatedataEntitie : updatedataEntities) {
            if (!updatedataEntitie.containsProperty("billstatus") || !"A".equals(updatedataEntitie.getString("billstatus"))) continue;
            stockId.add(updatedataEntitie.getPkValue().toString());
            stockMap.put(updatedataEntitie.getPkValue().toString(), updatedataEntitie);
        }
        List<String> stockLockIdList = OrderOpUtils.getStockLock(stockId);
        if (!stockLockIdList.isEmpty()) {
            ArrayList<String> errno = new ArrayList<String>(stockLockIdList.size());
            for (String stockLockId : stockLockIdList) {
                DynamicObject stock = (DynamicObject)stockMap.get(stockLockId);
                errno.add(stock.getString("billno"));
            }
            throw new KDBizException(new ErrorCode("AutoGenerateStock4", String.format(ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\uff1a%1$s\u6b63\u5728\u88ab\u7f16\u8f91\u6216\u64cd\u4f5c\u3002", (String)"OrderOpUtils_10", (String)"bd-mpdm-common", (Object[])new Object[0]), ((Object)errno).toString())), new Object[0]);
        }
        SaveServiceHelper.update((DynamicObject[])updatedataEntities.toArray(new DynamicObject[updatedataEntities.size()]));
    }

    private static void toStockByBotp(List<DynamicObject> saveEntities, String stockname, Log logger, Set<Long> stockIdSet) {
        HashMap<String, DynamicObject> stockMap = new HashMap<String, DynamicObject>(16);
        String orderName = EntityNameUtils.getEntityName(1, 0, stockname);
        PushArgs pushArgs = new PushArgs();
        pushArgs.setTargetEntityNumber(stockname);
        pushArgs.setHasRight(true);
        pushArgs.setRuleId(EntityNameUtils.getEntityName(1, 6, stockname));
        pushArgs.setBuildConvReport(true);
        pushArgs.setSourceEntityNumber(orderName);
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(16);
        for (DynamicObject obj : saveEntities) {
            ListSelectedRow srcBill1 = new ListSelectedRow((Object)Long.parseLong(obj.getString("orderid")));
            srcBill1.setEntryEntityKey("treeentryentity");
            if (stockname.equals("om_componentlist")) {
                srcBill1.setEntryEntityKey("billentry");
            }
            srcBill1.setEntryPrimaryKeyValue((Object)Long.parseLong(obj.getString("orderentryid")));
            needPushRows.add(srcBill1);
            stockMap.put(obj.getString("orderentryid"), obj);
        }
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)stockname);
        if (!pushResult.isSuccess()) {
            logger.info("\u4e0b\u63a8\u7ec4\u4ef6\u6e05\u5355\u5355\u5931\u8d25:" + MPDMMftGenStocksUtils.getErrByRes(pushResult));
            throw new KDBizException(new ErrorCode("AutoGenerateStock", MPDMMftGenStocksUtils.getErrByRes(pushResult)), new Object[0]);
        }
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        if (targetBillObjs.isEmpty()) {
            throw new KDBizException(new ErrorCode("AutoGenerateStock1", ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u672a\u751f\u6210\uff0c\u8bf7\u68c0\u67e5\u5de5\u5355\u751f\u6210\u7ec4\u4ef6\u6e05\u5355\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"OrderOpUtils_3", (String)"bd-mpdm-common", (Object[])new Object[0])), new Object[0]);
        }
        for (DynamicObject targetBillObj : targetBillObjs) {
            DynamicObject orderEntryDym = targetBillObj.getDynamicObject("orderentryid");
            if (orderEntryDym == null) {
                throw new KDBizException(new ErrorCode("AutoGenerateStock2", ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u4e0a\u7684\u5de5\u5355\u5206\u5f55ID\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5de5\u5355\u751f\u6210\u7ec4\u4ef6\u6e05\u5355\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"OrderOpUtils_4", (String)"bd-mpdm-common", (Object[])new Object[0])), new Object[0]);
            }
            OrderOpUtils.compareStock((DynamicObject)stockMap.get(orderEntryDym.getPkValue().toString()), targetBillObj, stockname);
        }
        OperateOption create = OperateOption.create();
        create.setVariableValue("ishasright", "true");
        create.setVariableValue("ignorewarn", "true");
        create.setVariableValue("ignoreinteraction", "true");
        create.setVariableValue("ordersave", "1");
        OperationResult saveOperate = SaveServiceHelper.saveOperate((String)stockname, (DynamicObject[])targetBillObjs.toArray(new DynamicObject[targetBillObjs.size()]), (OperateOption)create);
        if (!saveOperate.isSuccess()) {
            throw new KDBizException(new ErrorCode("AutoGenerateStock3", String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4fdd\u5b58\u7ec4\u4ef6\u6e05\u5355\u5f02\u5e38\uff1a%1$s", (String)"OrderOpUtils_8", (String)"bd-mpdm-common", (Object[])new Object[0]), OrderOpUtils.getErrDetail(saveOperate))), new Object[0]);
        }
        StockOpUtils.addStockIdToSet(stockIdSet, saveOperate);
    }

    private static void compareStock(DynamicObject stock, DynamicObject targetBillObj, String stockname) {
        if (stock == null) {
            return;
        }
        String orderName = EntityNameUtils.getEntityName(1, 0, stockname);
        TableDefine srcTableDefine = EntityMetadataCache.loadTableDefine((String)orderName, (String)orderName);
        DynamicObjectCollection collection = targetBillObj.getDynamicObjectCollection("stockentry");
        DynamicObjectCollection stockCol = stock.getDynamicObjectCollection("stockentry");
        collection.clear();
        for (int i = 0; i < stockCol.size(); ++i) {
            DynamicObjectCollection linkRows = ((DynamicObject)stockCol.get(i)).getDynamicObjectCollection("stockentry_lk");
            if (linkRows.isEmpty()) {
                DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
                linkRow.set("stockentry_lk_stableid", (Object)srcTableDefine.getTableId());
                linkRow.set("stockentry_lk_sbillid", stock.get("orderid"));
                linkRow.set("stockentry_lk_sid", stock.get("orderentryid"));
                linkRows.add((Object)linkRow);
            }
            collection.add(stockCol.get(i));
        }
        targetBillObj.set("orderid", stock.get("orderid"));
        targetBillObj.set("billno", stock.get("billno"));
        targetBillObj.set("productmasterid", stock.get("productmasterid"));
        targetBillObj.set("org", stock.get("org"));
        targetBillObj.set("transactiontypeid", stock.get("transactiontypeid"));
        targetBillObj.set("orderno", stock.get("orderno"));
        targetBillObj.set("productid", stock.get("productid"));
        targetBillObj.set("unitid", stock.get("unitid"));
        targetBillObj.set("mftdeptorgid", stock.get("mftdeptorgid"));
        targetBillObj.set("bomid", stock.get("bomid"));
        if (stockname.equals("om_componentlist")) {
            targetBillObj.set("bomid", (Object)MsBomQueryHelper.getDataCacheByID(stock.get("bomid")));
        }
        targetBillObj.set("replaceno", stock.get("replaceno"));
        targetBillObj.set("auxproperty", stock.get("auxproperty"));
        targetBillObj.set("qty", stock.get("qty"));
        targetBillObj.set("baseqty", stock.get("baseqty"));
        targetBillObj.set("baseunitid", stock.get("baseunitid"));
        targetBillObj.set("billauxqty", stock.get("billauxqty"));
        targetBillObj.set("sourcebillid", stock.get("sourcebillid"));
    }

    public static String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        if (optResult.getMessage() != null) {
            errDetail.append(optResult.getMessage());
        }
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            errDetail.append(errInfo.getMessage());
        }
        return errDetail.toString();
    }

    public static List<String> getStockLock(List<String> stockId) {
        DynamicObject[] loads;
        ArrayList<String> stockLockId = new ArrayList<String>(16);
        for (DynamicObject load : loads = BusinessDataServiceHelper.load((String)"bos_datalock", (String)"objectid,entitykey.id", (QFilter[])new QFilter[]{new QFilter("objectid", "in", stockId)})) {
            stockLockId.add(load.getString("objectid"));
        }
        return stockLockId;
    }

    public static Map<Long, DynamicObject> getMftOrderDataMap(Set<Long> ids, String entityid) {
        HashMap<Long, DynamicObject> orderMap = new HashMap<Long, DynamicObject>(20);
        if (!ids.isEmpty()) {
            DynamicObject[] load;
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityid);
            String selectFields = OrderOpUtils.getOrderSelectFields();
            for (DynamicObject dym : load = BusinessDataServiceHelper.load((String)entityType.getName(), (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})) {
                Long pkValue = (Long)dym.getPkValue();
                if (orderMap.containsKey(pkValue)) continue;
                orderMap.put(pkValue, dym);
            }
        }
        return orderMap;
    }

    public static String validateBOMType(ExtendedDataEntity extendedDataEntity, Map<Object, DynamicObject> bomMap) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        DynamicObject transactiontype = dataEntity.getDynamicObject("transactiontype");
        if (transactiontype == null) {
            return null;
        }
        DynamicObjectCollection transbomtypes = transactiontype.getDynamicObjectCollection("bomtypes");
        if (CollectionUtils.isEmpty((Collection)transbomtypes)) {
            return null;
        }
        List<Long> transBomTypePkValues = MulBaseDataUtils.getPkValuesByMulData(transbomtypes);
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            DynamicObject bdmaterial;
            DynamicObject mftmaterial;
            DynamicObject loadBOM;
            DynamicObject loadBOMType;
            DynamicObject bom = dynamicObject.getDynamicObject("bomid");
            if (bom == null || (loadBOMType = (loadBOM = bomMap.get(bom.getPkValue())).getDynamicObject("type")) == null) continue;
            if (!transBomTypePkValues.contains(loadBOMType.getPkValue())) {
                return String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\uff08%1$s\uff09\u4e2d\u7684BOM\u7c7b\u578b\u4e0e\u5206\u5f55BOM\uff08%2$s\uff09\u7684\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrderOpUtils_6", (String)"bd-mpdm-common", (Object[])new Object[0]), transactiontype.getString("name"), bom.getString("number"));
            }
            String producttype = dynamicObject.getString("producttype");
            if (!StringUtils.equals((String)"C", (String)producttype) || (mftmaterial = dynamicObject.getDynamicObject("material")) == null || (bdmaterial = mftmaterial.getDynamicObject("masterid")) == null) continue;
            String materialName = bdmaterial.getString("number");
            String bomName = bom.getString("number");
            DynamicObject mftMaterialBom = loadBOM.getDynamicObject("material");
            if (mftMaterialBom == null) continue;
            DynamicObject bdmaterialbom = mftMaterialBom.getDynamicObject("masterid");
            if (bdmaterialbom == null) {
                DynamicObject mftInfo = MaterialMftQueryHelper.getDataCacheByID(mftMaterialBom.getPkValue());
                bdmaterialbom = mftInfo.getDynamicObject("masterid");
            }
            if (bdmaterialbom.getPkValue().equals(bdmaterial.getPkValue())) continue;
            return String.format(ResManager.loadKDString((String)"\u4e3b\u7269\u6599BOM\u201c%1$s\u201d\u4e0e\u7269\u6599\u201c%2$s\u201d\u65e0\u5173\u8054\u5173\u7cfb\u3002", (String)"OrderOpUtils_11", (String)"bd-mpdm-common", (Object[])new Object[0]), bomName, materialName);
        }
        return null;
    }

    public static List<Long> queryStockIdByOrderEntrys(List<Object> orderEntryIDList, String keyEntity) {
        ArrayList<Long> stockIDList = new ArrayList<Long>(16);
        QFilter qfilter = new QFilter("orderentryid", "in", orderEntryIDList);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-OrderOpUtils-queryStockIdByOrderEntrys", (String)keyEntity, (String)"id", (QFilter[])new QFilter[]{qfilter}, (String)"");){
            while (ds.hasNext()) {
                Row dsRow = ds.next();
                stockIDList.add(dsRow.getLong("id"));
            }
        }
        return stockIDList;
    }

    public static List<Long> queryManuTechIdByOrderEntrys(List<Object> orderEntryIDList, String keyEntity) {
        ArrayList<Long> technicsIDList = new ArrayList<Long>(16);
        QFilter qfilter = new QFilter("mftentryseq", "in", orderEntryIDList);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-OrderOpUtils-queryManuTechIdByOrderEntrys", (String)keyEntity, (String)"id", (QFilter[])new QFilter[]{qfilter}, (String)"");){
            while (ds.hasNext()) {
                Row dsRow = ds.next();
                technicsIDList.add(dsRow.getLong("id"));
            }
        }
        return technicsIDList;
    }

    public static String listToString(List<Long> lists) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lists.size(); ++i) {
            sb.append(lists.get(i));
            if (i == lists.size() - 1) continue;
            sb.append(CHAR_S);
        }
        return sb.toString();
    }

    public static List<Long> stringToList(String ids) {
        if (kd.bos.util.StringUtils.isEmpty((String)ids)) {
            return Collections.emptyList();
        }
        String[] idArray = ids.split(CHAR_S);
        ArrayList<Long> lists = new ArrayList<Long>(idArray.length);
        for (String idString : idArray) {
            lists.add(Long.parseLong(idString));
        }
        return lists;
    }

    public static boolean isGenStockByEvent(String stockname, int billCount) {
        boolean flag = false;
        if (stockname.equals("pom_mftstock") && OrderOpUtils.isEvtGenStock(billCount)) {
            flag = true;
        }
        return flag;
    }

    private static boolean isEvtGenStock(int billCount) {
        boolean flag = false;
        int evtgenstockmax = (Integer)SystemParamServiceHelper.getBillParameter((String)"pom_mftorder", (String)"evtgenstockmax");
        if (evtgenstockmax > 0 && billCount > evtgenstockmax) {
            flag = true;
        }
        return flag;
    }

    private static int getEvtGenStockBatch() {
        int evtgenstockbatch = (Integer)SystemParamServiceHelper.getBillParameter((String)"pom_mftorder", (String)"evtgenstockbatch");
        return evtgenstockbatch;
    }

    public static void sendEventGenStock(Set<String> orderNos) {
        int evtGenStockBatch = OrderOpUtils.getEvtGenStockBatch();
        int count = 0;
        HashSet<String> billNos = new HashSet<String>(16);
        HashMap<String, Object> calparam = new HashMap<String, Object>(16);
        for (String order : orderNos) {
            billNos.add(order);
            if (++count != evtGenStockBatch) continue;
            calparam.put("billNos", billNos);
            calparam.put("appId", "pom");
            String jsonString = JSON.toJSONString(calparam);
            EventServiceHelper.triggerEventSubscribe((String)"pom_mftorder.genStockEvent", (String)jsonString);
            count = 0;
            billNos.clear();
        }
        if (!billNos.isEmpty()) {
            calparam.put("billNos", billNos);
            calparam.put("appId", "pom");
            String jsonString = JSON.toJSONString(calparam);
            EventServiceHelper.triggerEventSubscribe((String)"pom_mftorder.genStockEvent", (String)jsonString);
        }
    }

    public static void genStockByEvent(Set<String> billNos, String stockname) {
        Log log = LogFactory.getLog((String)"kd.mmc.pom.mftoder.genStockByEvnet");
        QFilter filter = new QFilter("billno", "in", billNos);
        DynamicObject[] orders = BusinessDataServiceHelper.load((String)"pom_mftorder", (String)OrderOpUtils.getOrderSelectFields(), (QFilter[])filter.toArray());
        ArrayList<DynamicObject> orderList = new ArrayList<DynamicObject>(16);
        if (orders != null && orders.length > 0) {
            for (DynamicObject bill : orders) {
                orderList.add(bill);
            }
        }
        ArrayList<DynamicObject> savedataEntities = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> updatedataEntities = new ArrayList<DynamicObject>();
        HashSet<Long> deleteStockIds = new HashSet<Long>();
        OrderBaseData baseData = CreateStockUtils.getStocks(orderList, "save", stockname);
        savedataEntities.addAll(baseData.getSaveStocks());
        updatedataEntities.addAll(baseData.getUpdateStocks());
        deleteStockIds.addAll(baseData.getDeleteOrderEntryIds());
        HashSet<Long> stockIdSet = new HashSet<Long>(16);
        if (!savedataEntities.isEmpty()) {
            OrderOpUtils.setOrderNo(savedataEntities, orders);
        }
        if (!updatedataEntities.isEmpty()) {
            OrderOpUtils.setOrderNo(updatedataEntities, orders);
        }
        if (!deleteStockIds.isEmpty()) {
            MPDMMftGenStocksUtils.deleteOrderStock(deleteStockIds, stockname);
        }
        if (!savedataEntities.isEmpty()) {
            ArrayList<DynamicObject> innerStocks = new ArrayList<DynamicObject>(16);
            ArrayList<DynamicObject> otherStocks = new ArrayList<DynamicObject>(16);
            if ("pom_mftstock".equals(stockname)) {
                for (DynamicObject saveStock : savedataEntities) {
                    DynamicObject tran = saveStock.getDynamicObject("transactiontypeid");
                    if (tran != null) {
                        boolean isinnerprocess = tran.getBoolean("isinnerprocess");
                        if (isinnerprocess) {
                            innerStocks.add(saveStock);
                            continue;
                        }
                        otherStocks.add(saveStock);
                        continue;
                    }
                    otherStocks.add(saveStock);
                }
            } else {
                otherStocks.addAll(savedataEntities);
            }
            if (!otherStocks.isEmpty()) {
                OrderOpUtils.toStockByBotp(savedataEntities, stockname, log, stockIdSet);
            }
            if (!innerStocks.isEmpty()) {
                OperateOption create = OperateOption.create();
                create.setVariableValue("ishasright", "true");
                create.setVariableValue("ignorewarn", "true");
                create.setVariableValue("ignoreinteraction", "true");
                OperationResult saveOperate = SaveServiceHelper.saveOperate((String)stockname, (DynamicObject[])innerStocks.toArray(new DynamicObject[innerStocks.size()]), (OperateOption)create);
                if (!saveOperate.isSuccess()) {
                    throw new KDBizException(new ErrorCode("AutoGenerateStock3", String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4fdd\u5b58\u7ec4\u4ef6\u6e05\u5355\u5f02\u5e38\uff1a%1$s", (String)"OrderOpUtils_8", (String)"bd-mpdm-common", (Object[])new Object[0]), OrderOpUtils.getErrDetail(saveOperate))), new Object[0]);
                }
                StockOpUtils.addStockIdToSet(stockIdSet, saveOperate);
            }
        }
        if (!updatedataEntities.isEmpty()) {
            long start = System.currentTimeMillis();
            OrderOpUtils.updateBill(updatedataEntities);
            long end = System.currentTimeMillis() - start;
            log.info("" + end);
        }
        StockOpUtils.callOrderToStock(stockname, updatedataEntities, stockIdSet);
    }

    private static String getOrderSelectFields() {
        String selectFields = "isinitbill,entrustdept,billtype,id,billno,transactiontype,org,number,billstatus,treeentryentity,treeentryentity.id,treeentryentity.planstatus,treeentryentity.taskstatus,treeentryentity.pid,treeentryentity.beginbookdate,treeentryentity.closebookdate,treeentryentity.startworktime,treeentryentity.transmittime,treeentryentity.endworktime,treeentryentity.closetime,treeentryentity.closer,treeentryentity.endcasetime,treeentryentity.inwardept,treeentryentity.bizstatus,treeentryentity.producttype,treeentryentity.quainwaqty,treeentryentity.unquainwaqty,treeentryentity.scrinwaqty,treeentryentity.material,treeentryentity.unit,treeentryentity.producedept,treeentryentity.bomid,treeentryentity.replaceno,treeentryentity.auxproperty,treeentryentity.qty,treeentryentity.baseqty,treeentryentity.baseunit,treeentryentity.auxptyqty,treeentryentity.auxptyunit,treeentryentity.processroute,treeentryentity.materielmasterid,treeentryentity.srcorderentryid,treeentryentity.oprentryid,treeentryentity.sourcebilltype,treeentryentity.materialspread,treeentryentity.manuversion,treeentryentity.planbegintime,treeentryentity.planendtime,treeentryentity.lot,treeentryentity.batchno,treeentryentity.configuredcode,treeentryentity.workcenter,treeentryentity.expendbomtime,treeentryentity.tracknumber,treeentryentity.sourceentryseq";
        return selectFields;
    }
}

