/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.mftorder.utils;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import kd.bd.mpdm.common.mftorder.utils.OrderBaseData;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class PlanScopeHelper {
    private static Log logger = LogFactory.getLog(PlanScopeHelper.class);
    public static final String MSPLAN_MATPLANSCOP = "msplan_matplanscop";
    public static final String MSPLAN_PLANSCOPE_WHS = "msplan_planscope_whs";
    public static final String MRP_STOCKSUPPLY_POLICY = "mrp_stocksupply_policy";
    public static final String IM_WAREHOUSESETUP = "im_warehousesetup";
    public static final String PDM_MANUVERSION = "pdm_manuversion";
    private static ThreadLocal<Boolean> isEnablePlanScopeCache = new ThreadLocal();
    private static final String _SPLIT_ = "_";

    private PlanScopeHelper() {
    }

    public static void setStockEntryWarehouseByPlanScopeSer(DynamicObject stockEntry, DynamicObject orderEntry, Long masterId, DynamicObject org, DynamicObject materialMftInfo, DynamicObject bomEntry) {
        Map supplyInfo;
        if (stockEntry == null || orderEntry == null || materialMftInfo == null) {
            return;
        }
        Object interAssistType = null;
        DynamicObject manuVersiontInfo = orderEntry.getDynamicObject("manuversion");
        if (manuVersiontInfo != null) {
            manuVersiontInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)manuVersiontInfo.getPkValue(), (String)PDM_MANUVERSION, (String)"supwarehouseid,supstockorgid,suplocationid");
        }
        if ((supplyInfo = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IPlanScopeService", (String)"getDefSupplierInfoConsiderInterAssist", (Object[])new Object[]{bomEntry, materialMftInfo, org, interAssistType, manuVersiontInfo})) != null) {
            if (supplyInfo.get("entrysupplyorg") != null) {
                stockEntry.set("supplyorgid", (Object)BusinessDataServiceHelper.loadSingleFromCache(supplyInfo.get("entrysupplyorg"), (String)"bos_org"));
            } else if (supplyInfo.get("entrysupplyorgunitid") != null) {
                stockEntry.set("supplyorgid", (Object)BusinessDataServiceHelper.loadSingleFromCache(supplyInfo.get("entrysupplyorgunitid"), (String)"bos_org"));
            }
            stockEntry.set("warehouseid", supplyInfo.get("entrywarehouse"));
            stockEntry.set("location", supplyInfo.get("entrylocation"));
        }
    }

    public static void setStockEntryWarehouseByPlanScopeSer(OrderBaseData baseData, DynamicObject stockEntry, DynamicObject orderEntry, DynamicObject org, DynamicObject materialMftInfo, DynamicObject bomEntry) {
        Map<String, Long> supplyInfo;
        DynamicObject manuVersiontInfo = orderEntry.getDynamicObject("manuversion");
        StringBuilder keystr = new StringBuilder(150);
        String bomEntryid = bomEntry == null ? "0" : bomEntry.getPkValue().toString();
        Long entrymaterialId = materialMftInfo.getLong("id");
        long manuVersionId = manuVersiontInfo == null ? 0L : manuVersiontInfo.getLong("id");
        keystr.append(entrymaterialId).append(org.getPkValue()).append(manuVersionId).append(bomEntryid);
        Map<String, Map<String, Long>> supplyInfos = baseData.getSupplyInfos();
        if (supplyInfos != null && supplyInfos.size() > 0 && (supplyInfo = supplyInfos.get(keystr.toString())) != null && supplyInfo.size() > 0) {
            DynamicObject supplyOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)supplyInfo.get("entrysupplyorg"), (String)"bos_org");
            stockEntry.set("supplyorgid", (Object)supplyOrg);
            stockEntry.set("warehouseid", (Object)supplyInfo.get("entrywarehouse"));
            stockEntry.set("location", (Object)supplyInfo.get("entrylocation"));
            stockEntry.set("warehouseid_id", (Object)supplyInfo.get("entrywarehouse"));
            stockEntry.set("location_id", (Object)supplyInfo.get("entrylocation"));
        }
    }

    public static void setStockEntryOutWarehouseByPlanScopeSer(OrderBaseData baseData, DynamicObject stockEntry, DynamicObject orderEntry, DynamicObject org, DynamicObject materialMftInfo, DynamicObject bomEntry) {
        Map<String, Long> supplyInfo;
        DynamicObject manuVersiontInfo = orderEntry.getDynamicObject("manuversion");
        StringBuilder keystr = new StringBuilder(150);
        String bomEntryid = bomEntry == null ? "0" : bomEntry.getPkValue().toString();
        Long entrymaterialId = materialMftInfo.getLong("id");
        long manuVersionId = manuVersiontInfo == null ? 0L : manuVersiontInfo.getLong("id");
        keystr.append(entrymaterialId).append(org.getPkValue()).append(manuVersionId).append(bomEntryid);
        Map<String, Map<String, Long>> supplyInfos = baseData.getSupplyInfos();
        if (supplyInfos != null && supplyInfos.size() > 0 && (supplyInfo = supplyInfos.get(keystr.toString())) != null && supplyInfo.size() > 0) {
            DynamicObject supplyOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)supplyInfo.get("entrysupplyorg"), (String)"bos_org");
            stockEntry.set("outorgunitid", (Object)supplyOrg);
            stockEntry.set("outwarehouseid", null);
            stockEntry.set("outlocation", null);
            stockEntry.set("outwarehouseid", (Object)supplyInfo.get("entrywarehouse"));
            stockEntry.set("outlocation", (Object)supplyInfo.get("entrylocation"));
            stockEntry.set("outwarehouseid_id", (Object)supplyInfo.get("entrywarehouse"));
            stockEntry.set("outlocation_id", (Object)supplyInfo.get("entrylocation"));
        }
    }

    public static Map<String, Map<String, Long>> batchInvokPlanScopeService(Map<String, Long> bomEntryIdMap, Map<String, Long> entrymaterialIdMap, Map<String, Long> entrysupplyorgIdMap, Map<String, Long> interAssistTypeIdMap, Map<String, Long> manuVersiontIdMap) {
        Long startdate = System.currentTimeMillis();
        String accountId = RequestContext.get().getAccountId();
        String key = accountId + UUID.randomUUID();
        HashMap<String, String> params = new HashMap<String, String>(5);
        params.put("bomEntryIdMap", SerializationUtils.toJsonString(bomEntryIdMap));
        params.put("entrymaterialIdMap", SerializationUtils.toJsonString(entrymaterialIdMap));
        params.put("entrysupplyorgIdMap", SerializationUtils.toJsonString(entrysupplyorgIdMap));
        params.put("interAssistTypeIdMap", SerializationUtils.toJsonString(interAssistTypeIdMap));
        params.put("manuVersiontIdMap", SerializationUtils.toJsonString(manuVersiontIdMap));
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache().put(key, params);
        logger.info("\u8c03\u7528\u8ba1\u5212\u8303\u56f4\u5fae\u670d\u52a1\u83b7\u53d6\u9ed8\u8ba4\u7684\u4f9b\u8d27\u4fe1\u606f\u8003\u8651\u5185\u534f\u5f00\u59cb,\u4f20\u5165\u53c2\u6570key\uff1a" + bomEntryIdMap.keySet());
        Map supplyInfos = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IPlanScopeService", (String)"getBatchDefSupplierInfoConsiderInterAssist", (Object[])new Object[]{key});
        long enddate = System.currentTimeMillis() - startdate;
        logger.info("\u8c03\u7528\u8ba1\u5212\u8303\u56f4\u5fae\u670d\u52a1\u83b7\u53d6\u9ed8\u8ba4\u7684\u4f9b\u8d27\u4fe1\u606f\u8003\u8651\u5185\u534f\u7ed3\u675f--------------cost:" + enddate + "ms");
        return supplyInfos;
    }

    public static Map<String, Map<String, Long>> getBatchDefSupplierInfoConsiderInterAssist(Map<String, LinkedList<Object>> params) {
        if (params == null) {
            return null;
        }
        logger.info("getBatchDefSupplierInfoConsiderInterAssist params size" + params.size());
        HashMap<Long, DynamicObject> materialmftinfos = new HashMap<Long, DynamicObject>(params.size());
        HashMap<String, Long> entrymaterialIdMap = new HashMap<String, Long>(params.size());
        HashMap<String, Long> entrysupplyorgIdMap = new HashMap<String, Long>(params.size());
        HashMap<String, Long> manuVersiontIdMap = new HashMap<String, Long>(params.size());
        HashMap<String, DynamicObject> bomEntryIdMap = new HashMap<String, DynamicObject>(params.size());
        HashMap<Object, DynamicObject> manuVersionMap = new HashMap<Object, DynamicObject>(params.size());
        HashSet<String> noInnerSet = new HashSet<String>(16);
        HashSet<String> innerSet = new HashSet<String>(16);
        for (Map.Entry<String, LinkedList<Object>> stringLinkedListEntry : params.entrySet()) {
            String key = stringLinkedListEntry.getKey();
            LinkedList<Object> param = stringLinkedListEntry.getValue();
            DynamicObject materialmftInfo = (DynamicObject)param.get(1);
            if (materialmftInfo != null) {
                materialmftinfos.put(materialmftInfo.getLong("id"), materialmftInfo);
            }
            entrymaterialIdMap.put(key, materialmftInfo == null ? 0L : materialmftInfo.getLong("id"));
            DynamicObject dynamicObject = (DynamicObject)param.get(3);
            if (dynamicObject != null) {
                manuVersionMap.put(dynamicObject.getPkValue(), dynamicObject);
                manuVersiontIdMap.put(key, dynamicObject.getLong("id"));
            }
            bomEntryIdMap.put(key, (DynamicObject)param.get(0));
            DynamicObject org = (DynamicObject)param.get(2);
            if (org != null) {
                entrysupplyorgIdMap.put(key, org.getLong("id"));
            }
            if (param.get(4) == null) {
                noInnerSet.add(key);
                continue;
            }
            innerSet.add(key);
            entrysupplyorgIdMap.put(key, ((DynamicObject)param.get(4)).getLong("id"));
        }
        params.clear();
        params = null;
        Set manuVersionIdSet = manuVersionMap.keySet();
        if (!manuVersionIdSet.isEmpty()) {
            Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)PDM_MANUVERSION, (String)"number,supstockorgid,supwarehouseid,suplocationid", (QFilter[])new QFilter[]{new QFilter("id", "in", manuVersionIdSet)});
            manuVersionMap.clear();
            manuVersionMap.putAll(loadFromCache);
        }
        HashMap<String, Map<String, Long>> supplyInfo = new HashMap<String, Map<String, Long>>(16);
        HashMap<String, Long> keyWarehouses = new HashMap<String, Long>(16);
        HashMap<Long, Map> orgWarehouseMaterial = new HashMap<Long, Map>(16);
        for (String string : innerSet) {
            Long materialInfoId = (Long)entrymaterialIdMap.get(string);
            DynamicObject materialInfo = (DynamicObject)materialmftinfos.get(materialInfoId);
            Long orgId = (Long)entrysupplyorgIdMap.get(string);
            Map materialWarehouse = orgWarehouseMaterial.computeIfAbsent(orgId, k -> new HashMap());
            if (materialInfo == null) continue;
            DynamicObject material = materialInfo.getDynamicObject("masterid");
            Long materialId = material.getLong("id");
            PlanScopeHelper.updateSupplyInfoMaterialMft(supplyInfo, string, materialInfo, materialWarehouse, materialId, keyWarehouses);
        }
        HashMap<String, Map<String, Long>> supplyInfoMft = new HashMap<String, Map<String, Long>>(16);
        for (String key : noInnerSet) {
            DynamicObject manuVersion;
            Object manuVersiontId;
            Long materialInfoId = (Long)entrymaterialIdMap.get(key);
            DynamicObject materialInfo = (DynamicObject)materialmftinfos.get(materialInfoId);
            if (materialInfo == null) continue;
            DynamicObject material = materialInfo.getDynamicObject("masterid");
            Long materialId = material.getLong("id");
            String invinfosrc = materialInfo.getString("invinfosrc");
            Long orgId = (Long)entrysupplyorgIdMap.get(key);
            Map materialWarehouse = orgWarehouseMaterial.computeIfAbsent(orgId, k -> new HashMap());
            if ("A".equals(invinfosrc)) {
                DynamicObject bomEntry = (DynamicObject)bomEntryIdMap.get(key);
                if (bomEntry == null) {
                    PlanScopeHelper.updateSupplyInfoMaterialMft(supplyInfo, key, materialInfo, materialWarehouse, materialId, keyWarehouses);
                    continue;
                }
                PlanScopeHelper.updateSupplyInfoBomEntry(supplyInfo, key, bomEntry, materialWarehouse, materialId, keyWarehouses);
                continue;
            }
            if ("B".equals(invinfosrc)) {
                PlanScopeHelper.updateSupplyInfoMaterialMft(supplyInfo, key, materialInfo, materialWarehouse, materialId, keyWarehouses);
                continue;
            }
            if ("C".equals(invinfosrc)) {
                manuVersiontId = (Long)manuVersiontIdMap.get(key);
                manuVersion = (DynamicObject)manuVersionMap.get(manuVersiontId);
                if (manuVersion == null) continue;
                PlanScopeHelper.updateSupplyInfoManuVersion(supplyInfo, key, manuVersion, materialWarehouse, materialId, keyWarehouses);
                continue;
            }
            if (!"D".equals(invinfosrc)) continue;
            manuVersiontId = (Long)manuVersiontIdMap.get(key);
            manuVersion = (DynamicObject)manuVersionMap.get(manuVersiontId);
            if (manuVersion == null) {
                PlanScopeHelper.updateSupplyInfoMaterialMft(supplyInfo, key, materialInfo, materialWarehouse, materialId, keyWarehouses);
                continue;
            }
            DynamicObject warehouse = manuVersion.getDynamicObject("supwarehouseid");
            Long entrywarehouseId = warehouse == null ? 0L : warehouse.getLong("id");
            if (entrywarehouseId == 0L) {
                PlanScopeHelper.updateSupplyInfoMaterialMft(supplyInfo, key, materialInfo, materialWarehouse, materialId, keyWarehouses);
                continue;
            }
            Set materials = materialWarehouse.computeIfAbsent(entrywarehouseId, k -> new HashSet());
            materials.add(materialId);
            keyWarehouses.put(key, entrywarehouseId);
            PlanScopeHelper.updateSupplyInfoMaterialMft(supplyInfoMft, key, materialInfo, materialWarehouse, materialId, null);
        }
        Long l = System.currentTimeMillis();
        logger.info("PlanScopehelper \u67e5\u8be2\u8ba1\u5212\u8303\u56f4\u4ed3\u5e93\u5b9a\u4e49\u7269\u6599\u4e0e\u8ba1\u5212\u8303\u56f4\u5173\u7cfb\u5f00\u59cb");
        HashMap<String, Map<String, Long>> supplierInfos = new HashMap<String, Map<String, Long>>(16);
        for (Map.Entry orgWarehouseMaterialEntry : orgWarehouseMaterial.entrySet()) {
            Long orgId = (Long)orgWarehouseMaterialEntry.getKey();
            Map warehouseMaterial = (Map)orgWarehouseMaterialEntry.getValue();
            Set<Long> warehouseIds = warehouseMaterial.keySet();
            Map<Long, Long> warehousesPlanscopes = PlanScopeHelper.getPlanscopeBywarehouses(warehouseIds, orgId);
            QFilter basedataFilter = BaseDataServiceHelper.getBaseDataFilter((String)MSPLAN_MATPLANSCOP, (Long)orgId);
            for (Map.Entry<Long, Long> warehousesPlanscopeEntry : warehousesPlanscopes.entrySet()) {
                Long planscopeId = warehousesPlanscopeEntry.getValue();
                if (planscopeId == null) continue;
                Long warehouseId = warehousesPlanscopeEntry.getKey();
                Set materialIds = (Set)warehouseMaterial.get(warehouseId);
                Map<String, Map<String, Long>> supplierInfo = PlanScopeHelper.getSupplierInfo(planscopeId, orgId, warehouseId, materialIds, basedataFilter);
                supplierInfos.putAll(supplierInfo);
            }
        }
        logger.info("PlanScopehelper \u67e5\u8be2\u8ba1\u5212\u8303\u56f4\u4ed3\u5e93\u5b9a\u4e49\u7269\u6599\u4e0e\u8ba1\u5212\u8303\u56f4\u5173\u7cfb\u7ed3\u675f total cost:" + (System.currentTimeMillis() - l));
        for (Map.Entry keyWarehouse : keyWarehouses.entrySet()) {
            String key = (String)keyWarehouse.getKey();
            Long warehouseId = (Long)keyWarehouse.getValue();
            Long materialInfoId = (Long)entrymaterialIdMap.get(key);
            DynamicObject materialInfo = (DynamicObject)materialmftinfos.get(materialInfoId);
            if (materialInfo == null) continue;
            DynamicObject material = materialInfo.getDynamicObject("masterid");
            Long materialId = material.getLong("id");
            Long orgId = (Long)entrysupplyorgIdMap.get(key);
            String supplierInfoKey = materialId + "" + orgId + "" + warehouseId;
            Map supplierInfo = (Map)supplierInfos.get(supplierInfoKey);
            if (supplierInfo == null || supplierInfo.isEmpty() || (Long)supplierInfo.get("entrywarehouse") == 0L) {
                Map map = (Map)supplyInfoMft.get(key);
                if (map == null || map.isEmpty() || (Long)map.get("entrywarehouse") == 0L) continue;
                supplyInfo.put(key, map);
                Long entrywarehouse = (Long)map.get("entrywarehouse");
                String supplierKey = materialId + "" + orgId + "" + entrywarehouse;
                Map supplier = (Map)supplierInfos.get(supplierKey);
                if (supplier == null || supplier.isEmpty() || (Long)supplier.get("entrywarehouse") == 0L) continue;
                PlanScopeHelper.updateSupplyInfoPlanScope(supplyInfo, key, supplier);
                continue;
            }
            PlanScopeHelper.updateSupplyInfoPlanScope(supplyInfo, key, supplierInfo);
        }
        return supplyInfo;
    }

    private static void updateSupplyInfoBomEntry(Map<String, Map<String, Long>> supplyInfo, String key, DynamicObject bomEntry, Map<Long, Set<Long>> materialWarehouse, Long materialId, Map<String, Long> keyWarehouses) {
        Map supplyInfoMap = supplyInfo.computeIfAbsent(key, k -> new HashMap());
        Long warehouseId = PlanScopeHelper.getPkId(bomEntry.get("entrywarehouse"));
        supplyInfoMap.put("entrysupplyorg", PlanScopeHelper.getPkId(bomEntry.get("entrysupplyorg")));
        supplyInfoMap.put("entrywarehouse", PlanScopeHelper.getPkId(bomEntry.get("entrywarehouse")));
        supplyInfoMap.put("entrylocation", PlanScopeHelper.getPkId(bomEntry.get("entrylocation")));
        if (warehouseId == 0L) {
            return;
        }
        Set materials = materialWarehouse.computeIfAbsent(warehouseId, k -> new HashSet());
        materials.add(materialId);
        if (keyWarehouses == null) {
            return;
        }
        keyWarehouses.put(key, warehouseId);
    }

    private static void initializeSupplyInfo(Map<String, Map<String, Long>> supplyInfo, List<String> keys) {
        for (String key : keys) {
            HashMap<String, Long> supplyInfoMap = new HashMap<String, Long>(3);
            supplyInfoMap.put("entrysupplyorg", 0L);
            supplyInfoMap.put("entrywarehouse", 0L);
            supplyInfoMap.put("entrylocation", 0L);
            supplyInfo.put(key, supplyInfoMap);
        }
    }

    private static void updateSupplyInfoMaterialMft(Map<String, Map<String, Long>> supplyInfo, String key, DynamicObject entryMaterialMft, Map<Long, Set<Long>> materialWarehouse, Long materialId, Map<String, Long> keyWarehouses) {
        Map supplyInfoMap = supplyInfo.computeIfAbsent(key, k -> new HashMap());
        DynamicObject supplyorgunitid = entryMaterialMft.getDynamicObject("supplyorgunitid");
        DynamicObject warehouse = entryMaterialMft.getDynamicObject("warehouse");
        DynamicObject location = entryMaterialMft.getDynamicObject("location");
        Long warehouseId = warehouse == null ? 0L : warehouse.getLong("id");
        supplyInfoMap.put("entrysupplyorg", supplyorgunitid == null ? 0L : supplyorgunitid.getLong("id"));
        supplyInfoMap.put("entrywarehouse", warehouseId);
        supplyInfoMap.put("entrylocation", location == null ? 0L : location.getLong("id"));
        if (warehouseId == 0L) {
            return;
        }
        Set materials = materialWarehouse.computeIfAbsent(warehouseId, k -> new HashSet());
        materials.add(materialId);
        if (keyWarehouses == null) {
            return;
        }
        keyWarehouses.put(key, warehouseId);
    }

    private static void updateSupplyInfoManuVersion(Map<String, Map<String, Long>> supplyInfo, String key, DynamicObject manuVersiontInfo, Map<Long, Set<Long>> materialWarehouse, Long materialId, Map<String, Long> keyWarehouses) {
        DynamicObject supplyorgunitid = manuVersiontInfo.getDynamicObject("supstockorgid");
        Long entrysupplyorgunitid = supplyorgunitid == null ? 0L : supplyorgunitid.getLong("id");
        DynamicObject warehouse = manuVersiontInfo.getDynamicObject("supwarehouseid");
        Long entrywarehouseId = warehouse == null ? 0L : warehouse.getLong("id");
        DynamicObject location = manuVersiontInfo.getDynamicObject("suplocationid");
        Long entrylocationId = location == null ? 0L : location.getLong("id");
        Map supplyInfoMap = supplyInfo.computeIfAbsent(key, k -> new HashMap());
        supplyInfoMap.put("entrysupplyorg", entrysupplyorgunitid);
        supplyInfoMap.put("entrywarehouse", entrywarehouseId);
        supplyInfoMap.put("entrylocation", entrylocationId);
        if (entrywarehouseId == 0L) {
            return;
        }
        Set materials = materialWarehouse.computeIfAbsent(entrywarehouseId, k -> new HashSet());
        materials.add(materialId);
        keyWarehouses.put(key, entrywarehouseId);
    }

    private static void updateSupplyInfoPlanScope(Map<String, Map<String, Long>> supplyInfo, String key, Map<String, Long> supplierInfo) {
        Long entrysupplyorgunit = supplierInfo.get("entrysupplyorgunitid");
        Long entrywarehouse = supplierInfo.get("entrywarehouse");
        Long entrylocation = supplierInfo.get("entrylocation");
        Map supplyInfoMap = supplyInfo.computeIfAbsent(key, k -> new HashMap());
        supplyInfoMap.put("entrysupplyorg", entrysupplyorgunit);
        supplyInfoMap.put("entrywarehouse", entrywarehouse);
        supplyInfoMap.put("entrylocation", entrylocation);
    }

    public static Map<Object, DynamicObject> getMaterialMftInfos(List<Long> materialIds, Long orgId, String entityKey, String selectFields) {
        if (materialIds == null || materialIds.size() == 0 || orgId == 0L || StringUtils.isBlank((CharSequence)entityKey)) {
            return null;
        }
        HashMap<Object, DynamicObject> materialPlanMaps = new HashMap<Object, DynamicObject>(materialIds.size());
        long starttime = System.currentTimeMillis();
        QFilter qFilterMater = new QFilter("masterid", "in", materialIds);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterOrg = BaseDataServiceHelper.getBaseDataFilter((String)entityKey, (Long)orgId);
        Map data = BusinessDataServiceHelper.loadFromCache((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{qFilterMater, qFilterStatus, qFilterOrg, qFilterEnable});
        HashMap datas = Maps.newHashMapWithExpectedSize((int)data.size());
        HashMap materialdatas = Maps.newHashMapWithExpectedSize((int)data.size());
        for (Object dobj : datas.values()) {
            datas.put(dobj.getPkValue(), dobj);
            DynamicObject material = dobj.getDynamicObject("masterid");
            materialdatas.computeIfAbsent(material.getPkValue(), k -> new HashMap()).put(dobj.getPkValue(), dobj);
        }
        Map<String, DynamicObject> createOrgMaterialInfoMap = PlanScopeHelper.getDataByCreateOrgData(datas);
        for (Long matrialId : materialIds) {
            DynamicObject materialPlan = createOrgMaterialInfoMap.get(orgId + _SPLIT_ + matrialId);
            if (materialPlan == null) continue;
            materialPlanMaps.put(matrialId, materialPlan);
        }
        materialIds.removeAll(materialPlanMaps.keySet());
        if (materialIds.size() == 0) {
            return materialPlanMaps;
        }
        for (Long matrialId : materialIds) {
            Map map = (Map)materialdatas.get(matrialId);
            DynamicObject plan = PlanScopeHelper.getDataByIdMin(map);
            materialPlanMaps.put(matrialId, plan);
        }
        long endtime = System.currentTimeMillis();
        logger.info("planorder-insert-getMaterialInfo,\u83b7\u53d6\u7269\u6599\u751f\u4ea7\u4fe1\u606f\uff0c\u8017\u65f6" + (endtime - starttime) + "ms");
        return materialPlanMaps;
    }

    public static Map<String, DynamicObject> getDataByCreateOrgData(Map<Object, DynamicObject> datas) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)datas.size());
        for (DynamicObject data : datas.values()) {
            DynamicObject createorg = data.getDynamicObject("createorg");
            DynamicObject material = data.getDynamicObject("masterid");
            map.put(createorg.getPkValue() + _SPLIT_ + material.getPkValue(), data);
        }
        return map;
    }

    public static DynamicObject getDataByIdMin(Map<Object, DynamicObject> data) {
        DynamicObject plan = null;
        if (data != null && data.size() > 0) {
            TreeSet<Object> ts = new TreeSet<Object>(data.keySet());
            ts.comparator();
            Object id = ts.first();
            plan = data.get(id);
        }
        return plan;
    }

    public static Map<Long, Long> getPlanscopeBywarehouses(Set<Long> warehouseIds, Long orgId) {
        Long startdate = System.currentTimeMillis();
        logger.info("PlanScopehelper getPlanscopeBywarehouses \u67e5\u8be2\u8ba1\u5212\u8303\u56f4\u4ed3\u5e93\u5b9a\u4e49\u5f00\u59cb");
        HashMap<Long, Long> inwareInfo = new HashMap<Long, Long>(16);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEffectuate = new QFilter("effectuate_type", "=", (Object)"A");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterWarehouse = new QFilter("warehouse", "in", warehouseIds);
        QFilter orgFilter = new QFilter("createorg", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, orgFilter, qFilterWarehouse, qFilterEffectuate};
        HashMap<Long, Map> createorgInwareInfo = new HashMap<Long, Map>();
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_PLANSCOPE_WHS, (String)"id,createorg,planscope,warehouse", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long createorgid = row.getLong(1);
                Long planscope = row.getLong(2);
                Long warehouse = row.getLong(3);
                Map inwareInfoMap = createorgInwareInfo.computeIfAbsent(warehouse, k -> new HashMap(16));
                inwareInfoMap.put(createorgid, planscope);
            }
        }
        for (Map.Entry createorgsupplier : createorgInwareInfo.entrySet()) {
            Long key = (Long)createorgsupplier.getKey();
            Map value = (Map)createorgsupplier.getValue();
            Long planscopeId = (Long)value.get(orgId);
            if ((planscopeId == null || planscopeId.equals(0L)) && value.size() > 0) {
                Iterator it = value.entrySet().iterator();
                planscopeId = (Long)it.next().getValue();
            }
            inwareInfo.put(key, planscopeId);
        }
        logger.info("PlanScopehelper getPlanscopeBywarehouses \u67e5\u8be2\u8ba1\u5212\u8303\u56f4\u4ed3\u5e93\u5b9a\u4e49\u7ed3\u675f cost:" + (System.currentTimeMillis() - startdate));
        return inwareInfo;
    }

    public static Map<String, Map<String, Long>> getSupplierInfo(Long planScopeId, Long orgId, Long warehouseId, Set<Long> materialIds, QFilter basedataFilter) {
        Long startdate = System.currentTimeMillis();
        logger.info("PlanScopehelper getSupplierInfo \u67e5\u8be2\u7269\u6599\u4e0e\u8ba1\u5212\u8303\u56f4\u5173\u7cfb\u8868\u5f00\u59cb");
        HashMap<String, Map<String, Long>> supplierInfo = new HashMap<String, Map<String, Long>>(16);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterMaterial = new QFilter("material", "in", materialIds);
        QFilter qFilterPlanscope = new QFilter("entrymatplanscop.planscope", "=", (Object)planScopeId);
        QFilter qFilterStartUseing = new QFilter("entrymatplanscop.start_useing", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, qFilterMaterial, basedataFilter, qFilterPlanscope, qFilterStartUseing};
        HashMap<String, Map> createorgsupplierInfo = new HashMap<String, Map>(16);
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_MATPLANSCOP, (String)"id,createorg,entrymatplanscop.supplier_org,entrymatplanscop.supplier_warehouse,entrymatplanscop.supplier_shipping,material", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long createorgid = row.getLong(1);
                Long supplier_org = row.getLong(2);
                Long supplier_warehouse = row.getLong(3);
                Long supplier_shipping = row.getLong(4);
                Long materialId = row.getLong(5);
                Map computeIfAbsent = createorgsupplierInfo.computeIfAbsent(materialId + "" + orgId + "" + warehouseId, k -> new HashMap(16));
                Map supplierInfoMap = computeIfAbsent.computeIfAbsent(createorgid, k -> new HashMap(16));
                supplierInfoMap.put("entrysupplyorgunitid", supplier_org);
                supplierInfoMap.put("entrywarehouse", supplier_warehouse);
                supplierInfoMap.put("entrylocation", supplier_shipping);
            }
        }
        for (Map.Entry createorgsupplier : createorgsupplierInfo.entrySet()) {
            String key = (String)createorgsupplier.getKey();
            Map value = (Map)createorgsupplier.getValue();
            Map supplierInfoMap = (Map)value.get(orgId);
            if ((supplierInfoMap == null || supplierInfoMap.isEmpty()) && value.size() > 0) {
                for (Map.Entry entry : value.entrySet()) {
                    if (supplierInfoMap != null && !supplierInfoMap.isEmpty()) continue;
                    supplierInfoMap = (Map)entry.getValue();
                    break;
                }
            }
            supplierInfo.put(key, supplierInfoMap);
        }
        logger.info("PlanScopehelper getSupplierInfo \u67e5\u8be2\u7269\u6599\u4e0e\u8ba1\u5212\u8303\u56f4\u5173\u7cfb\u8868\u7ed3\u675f cost:" + (System.currentTimeMillis() - startdate));
        return supplierInfo;
    }

    public static boolean isUsePlanscope() {
        Boolean isEnablePlanScope = isEnablePlanScopeCache.get();
        if (null == isEnablePlanScope) {
            isEnablePlanScopeCache.set((Boolean)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IPlanScopeService", (String)"isEnablePlanScope", (Object[])new Object[0]));
        }
        return isEnablePlanScopeCache.get();
    }

    public static Map<Object, DynamicObject> getSupplynetworkMap(Collection<DynamicObject> values) {
        if (values == null || values.isEmpty()) {
            return new HashMap<Object, DynamicObject>(16);
        }
        HashSet<Long> supplynetworkIdSet = new HashSet<Long>(16);
        for (DynamicObject planInfo : values) {
            DynamicObject supplynetwork = planInfo.getDynamicObject("supplynetwork");
            if (supplynetwork == null) continue;
            supplynetworkIdSet.add((Long)supplynetwork.getPkValue());
        }
        return BusinessDataServiceHelper.loadFromCache((String)"mrp_definitionsupply", (String)"number,defsupplytype,orgentry.supplyorg,orgentry.supplyproportion,orgentry.supplyrule,orgentry.supplyorgtype", (QFilter[])new QFilter[]{new QFilter("id", "in", supplynetworkIdSet)});
    }

    public static boolean isNotExistRuleC(DynamicObject supplynetworkNew, Object mftOrgId) {
        if (supplynetworkNew != null) {
            DynamicObjectCollection orgentrys = supplynetworkNew.getDynamicObjectCollection("orgentry");
            for (DynamicObject orgentry : orgentrys) {
                String supplyrule = orgentry.getString("supplyrule");
                DynamicObject supplyorg = orgentry.getDynamicObject("supplyorg");
                if (!"C".equals(supplyrule) || !supplyorg.getPkValue().toString().equals(mftOrgId.toString())) continue;
                return false;
            }
        }
        return true;
    }

    public static Long getPlanScope(Long orgId) {
        Long planScopeId = 0L;
        QFilter qFilterStatus = new QFilter("planscope.status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("planscope.enable", "=", (Object)"1");
        QFilter qFilterEffect = new QFilter("effectuate_type", "=", (Object)"A");
        QFilter qFilterPlanscopeType = new QFilter("planscope.type", "=", (Object)"A");
        QFilter qFilterorg = new QFilter("planscope.createorg", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, qFilterorg, qFilterEffect, qFilterPlanscopeType};
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_PLANSCOPE_WHS, (String)"id,createorg,planscope", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long createorgid = row.getLong(1);
                Long planscopeid = row.getLong(2);
                if (createorgid.equals(orgId)) {
                    Long l = planScopeId = planscopeid;
                    return l;
                }
                planScopeId = planscopeid;
            }
            dataset.close();
        }
        return planScopeId;
    }

    public static Map<String, Long> getDefInwareInfo(DynamicObject planscope, DynamicObject material, DynamicObject supplyOrg) {
        Map<String, Long> inwareInfo = new HashMap<String, Long>(3);
        inwareInfo.put("inwarehouse", 0L);
        inwareInfo.put("inwarelocation", 0L);
        if (planscope == null || supplyOrg == null || material == null) {
            return inwareInfo;
        }
        DynamicObject materialMftInfo = MaterialMftQueryHelper.getDataCacheByMaterial(material, supplyOrg);
        String type = planscope.getString("type");
        Long planScopeId = planscope.getLong("id");
        Long supplyOrgId = supplyOrg.getLong("id");
        Long materialId = material.getLong("id");
        if ("A".equals(type)) {
            if (materialMftInfo != null) {
                DynamicObject inwarorg = materialMftInfo.getDynamicObject("inwarorg");
                DynamicObject inwarehouse = materialMftInfo.getDynamicObject("inwarehouse");
                DynamicObject inwarelocation = materialMftInfo.getDynamicObject("inwarelocation");
                inwareInfo.put("inwarorg", inwarorg == null ? 0L : inwarorg.getLong("id"));
                inwareInfo.put("inwarehouse", inwarehouse == null ? 0L : inwarehouse.getLong("id"));
                inwareInfo.put("inwarelocation", inwarelocation == null ? 0L : inwarelocation.getLong("id"));
            }
        } else if ("B".equals(type) && ((inwareInfo = PlanScopeHelper.getInwareInfo(planScopeId, supplyOrgId, materialId)) == null || inwareInfo.get("inwarehouse") == 0L)) {
            inwareInfo = PlanScopeHelper.getInwareInfoByPlanscope(planScopeId, supplyOrgId, Boolean.TRUE);
        }
        if (inwareInfo != null && inwareInfo.get("inwarorg") == null) {
            inwareInfo.put("inwarorg", 0L);
        }
        if (inwareInfo != null && inwareInfo.get("inwarehouse") == null) {
            inwareInfo.put("inwarehouse", 0L);
        }
        if (inwareInfo != null && inwareInfo.get("inwarelocation") == null) {
            inwareInfo.put("inwarelocation", 0L);
        }
        return inwareInfo;
    }

    public static Map<String, Long> getDefInwareInfo(DynamicObject planscope, Long materialId, Long supplyOrgId) {
        Map<String, Long> inwareInfo = new HashMap<String, Long>(3);
        if (planscope == null || supplyOrgId == null || materialId == null) {
            inwareInfo.put("inwarorg", 0L);
            inwareInfo.put("inwarehouse", 0L);
            inwareInfo.put("inwarelocation", 0L);
            return inwareInfo;
        }
        DynamicObject materialMftInfo = MaterialMftQueryHelper.getDataCacheByMaterialID(materialId, supplyOrgId, null);
        String type = planscope.getString("type");
        Long planScopeId = planscope.getLong("id");
        if ("A".equals(type)) {
            if (materialMftInfo != null) {
                DynamicObject inwarorg = materialMftInfo.getDynamicObject("inwarorg");
                DynamicObject inwarehouse = materialMftInfo.getDynamicObject("inwarehouse");
                DynamicObject inwarelocation = materialMftInfo.getDynamicObject("inwarelocation");
                inwareInfo.put("inwarorg", inwarorg == null ? 0L : inwarorg.getLong("id"));
                inwareInfo.put("inwarehouse", inwarehouse == null ? 0L : inwarehouse.getLong("id"));
                inwareInfo.put("inwarelocation", inwarelocation == null ? 0L : inwarelocation.getLong("id"));
            }
        } else if ("B".equals(type) && ((inwareInfo = PlanScopeHelper.getInwareInfo(planScopeId, supplyOrgId, materialId)) == null || inwareInfo.get("inwarehouse") == 0L)) {
            inwareInfo = PlanScopeHelper.getInwareInfoByPlanscope(planScopeId, supplyOrgId, true);
        }
        return inwareInfo;
    }

    public static Map<String, Long> getInwareInfoByPlanscope(Long planscopeId, Long orgId, Boolean isIninvWhs) {
        Map<String, Long> inwareInfo = new HashMap(16);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEffectuate = new QFilter("effectuate_type", "=", (Object)"A");
        QFilter qFilterIsIninvWhs = new QFilter("is_ininv_whs", "=", (Object)isIninvWhs);
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterWarehouse = new QFilter("planscope", "=", (Object)planscopeId);
        QFilter basedataFilter = BaseDataServiceHelper.getBaseDataFilter((String)MSPLAN_PLANSCOPE_WHS, (Long)orgId);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, basedataFilter, qFilterWarehouse, qFilterEffectuate, qFilterIsIninvWhs};
        HashMap<Long, Map> createorgInwareInfo = new HashMap<Long, Map>();
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_PLANSCOPE_WHS, (String)"id,createorg,warehouse,invorg", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long createorgid = row.getLong(1);
                Long warehouse = row.getLong(2);
                Long in_storage_org = row.getLong(3);
                Map inwareInfoMap = createorgInwareInfo.computeIfAbsent(createorgid, k -> new HashMap(16));
                inwareInfoMap.put("inwarorg", in_storage_org);
                inwareInfoMap.put("inwarehouse", warehouse);
            }
            dataset.close();
        }
        inwareInfo = (Map)createorgInwareInfo.get(orgId);
        if ((inwareInfo == null || inwareInfo.isEmpty()) && createorgInwareInfo.size() > 0) {
            Iterator it = createorgInwareInfo.entrySet().iterator();
            inwareInfo = (Map)it.next().getValue();
        }
        return inwareInfo;
    }

    public static Map<String, Long> getInwareInfo(Long planScopeId, Long orgId, Long materialId) {
        Map<String, Long> inwareInfo = new HashMap(16);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterMaterial = new QFilter("material", "=", (Object)materialId);
        QFilter qFilterStartUseing = new QFilter("entrymatplanscop.start_useing", "=", (Object)"1");
        QFilter qFilterPlanscope = new QFilter("entrymatplanscop.planscope", "=", (Object)planScopeId);
        QFilter basedataFilter = BaseDataServiceHelper.getBaseDataFilter((String)MSPLAN_MATPLANSCOP, (Long)orgId);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, qFilterMaterial, basedataFilter, qFilterPlanscope, qFilterStartUseing};
        HashMap<Long, Map> createorgInwareInfo = new HashMap<Long, Map>();
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_MATPLANSCOP, (String)"id,createorg,entrymatplanscop.in_storage_org,entrymatplanscop.in_storage_warehouse,entrymatplanscop.in_storage_shipping", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long createorgid = row.getLong(1);
                Long in_storage_org = row.getLong(2);
                Long in_storage_warehouse = row.getLong(3);
                Long in_storage_shipping = row.getLong(4);
                Map inwareInfoMap = createorgInwareInfo.computeIfAbsent(createorgid, k -> new HashMap(16));
                inwareInfoMap.put("inwarorg", in_storage_org);
                inwareInfoMap.put("inwarehouse", in_storage_warehouse);
                inwareInfoMap.put("inwarelocation", in_storage_shipping);
            }
            dataset.close();
        }
        inwareInfo = (Map)createorgInwareInfo.get(orgId);
        if ((inwareInfo == null || inwareInfo.isEmpty()) && createorgInwareInfo.size() > 0) {
            Iterator it = createorgInwareInfo.entrySet().iterator();
            inwareInfo = (Map)it.next().getValue();
        }
        return inwareInfo;
    }

    public static void setInWarInfo(IDataModel iDataModel, Long orgId, Long masterid, int rowIndex) {
        DynamicObject materialMftInfo = MaterialMftQueryHelper.getDataCacheByMaterialID(masterid, orgId, null);
        if (materialMftInfo != null && materialMftInfo.get("inwarorg") != null) {
            DynamicObject inwarehouse = materialMftInfo.getDynamicObject("inwarehouse");
            DynamicObject inwarelocation = materialMftInfo.getDynamicObject("inwarelocation");
            iDataModel.setValue("entryinwardept", materialMftInfo.get("inwarorg"));
            iDataModel.setValue("inwardept", materialMftInfo.get("inwarorg"), rowIndex);
            iDataModel.setValue("entrywarehouse", (Object)inwarehouse);
            iDataModel.setValue("warehouse", (Object)inwarehouse, rowIndex);
            iDataModel.setValue("entrylocation", (Object)inwarelocation);
            iDataModel.setValue("location", (Object)inwarelocation, rowIndex);
        } else {
            List<Long> inwareOrgFilter = PlanScopeHelper.getInwareOrgFilter(orgId);
            if (!inwareOrgFilter.isEmpty()) {
                if (inwareOrgFilter.contains(orgId)) {
                    iDataModel.setValue("entryinwardept", (Object)orgId);
                    iDataModel.setValue("inwardept", (Object)orgId, rowIndex);
                } else {
                    iDataModel.setValue("entryinwardept", (Object)inwareOrgFilter.get(0));
                    iDataModel.setValue("inwardept", (Object)inwareOrgFilter.get(0), rowIndex);
                }
            }
        }
    }

    public static List<Long> getPlanScopes(Long orgId) {
        ArrayList<Long> planScopeIds = new ArrayList<Long>();
        QFilter qFilterStatus = new QFilter("planscope.status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("planscope.enable", "=", (Object)"1");
        QFilter qFilterEffect = new QFilter("effectuate_type", "=", (Object)"A");
        QFilter qFilterPlanscopeType = new QFilter("planscope.type", "=", (Object)"A");
        QFilter basedataFilter = new QFilter("createorg", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, basedataFilter, qFilterEffect, qFilterPlanscopeType};
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_PLANSCOPE_WHS, (String)"id,createorg,planscope", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long planscopeid = row.getLong(2);
                planScopeIds.add(planscopeid);
            }
            dataset.close();
        }
        return planScopeIds;
    }

    public static List<Long> getPlanScopes(Long orgId, Long materialId) {
        return PlanScopeHelper.getPlanScopes(orgId, materialId, null);
    }

    public static List<Long> getPlanScopes(Long orgId, Long materialId, QFilter qFilterInterAssist) {
        List<Long> planScopeIds = new ArrayList(16);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterMaterial = new QFilter("material", "=", (Object)materialId);
        if (qFilterInterAssist != null) {
            qFilterMaterial.and(qFilterInterAssist);
        }
        QFilter qFilterStartUseing = new QFilter("entrymatplanscop.start_useing", "=", (Object)"1");
        QFilter orgFilter = new QFilter("createorg", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, qFilterMaterial, orgFilter, qFilterStartUseing};
        HashMap<Long, List> createorgplanScopeMap = new HashMap<Long, List>();
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_MATPLANSCOP, (String)"id,createorg,entrymatplanscop.planscope", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long createorgid = row.getLong(1);
                Long planScopeId = row.getLong(2);
                List planScopeList = createorgplanScopeMap.computeIfAbsent(createorgid, k -> new ArrayList(16));
                planScopeList.add(planScopeId);
            }
            dataset.close();
        }
        planScopeIds = (List)createorgplanScopeMap.get(orgId);
        if ((planScopeIds == null || planScopeIds.isEmpty()) && createorgplanScopeMap.size() > 0) {
            Iterator it = createorgplanScopeMap.entrySet().iterator();
            planScopeIds = (List)it.next().getValue();
        }
        return planScopeIds;
    }

    private static boolean checkOrgIsAccount(Long orgid) {
        DynamicObject dyOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgid, (String)"bos_org");
        return dyOrg.getBoolean("fisaccounting");
    }

    private static List<Long> getInwareOrgFilter(Long mftOrg) {
        ArrayList<Long> filterList = new ArrayList<Long>();
        if (PlanScopeHelper.checkOrgIsAccount(mftOrg)) {
            List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)mftOrg);
            if (!allToOrg.isEmpty()) {
                filterList.addAll(allToOrg);
            }
        } else {
            List fromOrgs = OrgUnitServiceHelper.getFromOrgs((String)"04", (Long)mftOrg, (String)"10");
            if (fromOrgs.isEmpty()) {
                Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)mftOrg, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                Integer fromOrg = map == null || map.isEmpty() ? Integer.valueOf(0) : map.get("id");
                Long longFromOrg = (Long)((Object)fromOrg);
                List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)longFromOrg);
                if (!allToOrg.isEmpty()) {
                    filterList.addAll(allToOrg);
                }
            } else {
                Long fromOrg = (Long)fromOrgs.get(0);
                List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)fromOrg);
                if (!allToOrg.isEmpty()) {
                    filterList.addAll(allToOrg);
                }
            }
        }
        return filterList;
    }

    public static String validateAfterMaterialChanged(DynamicObject entryRowEntity, DynamicObject material, Map<Long, Map<Object, DynamicObject>> planMaterialMap, Map<Object, DynamicObject> supplynetworkMap, DynamicObject mtfOrg, DynamicObject entrustdept) {
        String errorInfo = "";
        if (material != null) {
            Long masterId = (Long)material.getDynamicObject("masterid").getPkValue();
            String supplyrule = entryRowEntity.getString("supplyrule");
            Long innerTypeOrgId = PlanScopeHelper.innerTypeOrgId(entryRowEntity, mtfOrg, entrustdept);
            DynamicObject planMaterial = planMaterialMap.get(innerTypeOrgId).get(masterId);
            if ("C".equals(supplyrule) && entrustdept != null) {
                if (planMaterial == null) {
                    errorInfo = String.format(ResManager.loadKDString((String)"\u59d4\u6258\u7ec4\u7ec7\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u5f53\u524d\u751f\u4ea7\u7ec4\u7ec7\u7684\u7269\u6599\uff08%1$s\uff09\uff0c\u5728\u59d4\u6258\u7ec4\u7ec7\uff08%2$s\uff09\u4e2d\u4e0d\u5b58\u5728\u53ef\u7528\u7684\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"PlanScopeHelper_7", (String)"bd-mpdm-common", (Object[])new Object[0]), material.getDynamicObject("masterid").getString("number"), entrustdept.getString("name"));
                }
                if (planMaterial != null && !"10060".equals(planMaterial.getString("materialattr"))) {
                    errorInfo = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u751f\u4ea7\u7ec4\u7ec7\u7684\u7269\u6599\uff08%1$s\uff09\uff0c\u5728\u59d4\u6258\u7ec4\u7ec7\uff08%2$s\uff09\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u7684\u7269\u6599\u5c5e\u6027\u4e0d\u7b49\u4e8e\u5185\u534f\u4ef6\u3002", (String)"PlanScopeHelper_8", (String)"bd-mpdm-common", (Object[])new Object[0]), material.getDynamicObject("masterid").getString("number"), entrustdept.getString("name"));
                }
                if (planMaterial != null && "10060".equals(planMaterial.getString("materialattr"))) {
                    DynamicObject supplynetwork = planMaterial.getDynamicObject("supplynetwork");
                    if (supplynetwork != null) {
                        DynamicObject supplynetworkNew = supplynetworkMap.get(supplynetwork.getPkValue());
                        if (PlanScopeHelper.isNotExistRuleC(supplynetworkNew, mtfOrg.getPkValue())) {
                            errorInfo = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u751f\u4ea7\u7ec4\u7ec7\u7684\u7269\u6599\uff08%1$s\uff09\uff0c\u5728\u59d4\u6258\u7ec4\u7ec7\uff08%2$s\uff09\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u7684\u4f9b\u5e94\u7f51\u7edc\u4e2d\u4e0d\u5b58\u5728\u4f9b\u5e94\u7ec4\u7ec7\u4e3a\u201c%3$s\u201d\uff0c\u4f9b\u5e94\u89c4\u5219\u4e3a\u201c\u8de8\u7ec4\u7ec7\u5165\u5e93\u201d\u7684\u5206\u5f55\u3002", (String)"PlanScopeHelper_9", (String)"bd-mpdm-common", (Object[])new Object[0]), material.getDynamicObject("masterid").getString("number"), entrustdept.getString("name"), mtfOrg.getString("name"));
                        }
                    } else {
                        errorInfo = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u751f\u4ea7\u7ec4\u7ec7\u7684\u7269\u6599\uff08%1$s\uff09\uff0c\u5728\u59d4\u6258\u7ec4\u7ec7\uff08%2$s\uff09\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u4e3a\u5185\u534f\u4ef6\uff0c\u4f9b\u5e94\u7f51\u7edc\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PlanScopeHelper_10", (String)"bd-mpdm-common", (Object[])new Object[0]), material.getDynamicObject("masterid").getString("number"), entrustdept.getString("name"));
                    }
                }
            } else if (planMaterial != null && "10060".equals(planMaterial.getString("materialattr"))) {
                errorInfo = String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u89c4\u5219\u4e3a\u7a7a\u6216\u8de8\u7ec4\u7ec7\u8c03\u62e8\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u7269\u6599\u5c5e\u6027\uff08\u7269\u6599\u8ba1\u5212\u4fe1\u606f\uff09\u4e3a\u5185\u534f\u4ef6\u7684\u7269\u6599\uff08%1$s\uff09\u3002", (String)"PlanScopeHelper_11", (String)"bd-mpdm-common", (Object[])new Object[0]), material.getDynamicObject("masterid").getString("number"));
            }
        }
        return errorInfo;
    }

    public static void setDefSupplyRule(IDataModel iDataModel) {
        DynamicObject entrustdept = (DynamicObject)iDataModel.getValue("entrustdept");
        if (entrustdept != null) {
            DynamicObjectCollection entryEntity = iDataModel.getEntryEntity("treeentryentity");
            if (entryEntity.isEmpty()) {
                return;
            }
            for (int i = 0; i < entryEntity.size(); ++i) {
                iDataModel.setValue("supplyrule", (Object)"C", i);
            }
        }
    }

    public static Map<String, Long> getInwareInfoByInwarehouse(Long warehouseId, Long orgId) {
        Map<String, Long> inwareInfo = new HashMap(16);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEffectuate = new QFilter("effectuate_type", "=", (Object)"A");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterWarehouse = new QFilter("warehouse", "=", (Object)warehouseId);
        QFilter orgFilter = new QFilter("createorg", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, orgFilter, qFilterWarehouse, qFilterEffectuate};
        HashMap<Long, Map> createorgInwareInfo = new HashMap<Long, Map>();
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_PLANSCOPE_WHS, (String)"id,createorg,planscope,invorg", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long createorgid = row.getLong(1);
                Long planscope = row.getLong(2);
                Long in_storage_org = row.getLong(3);
                Map inwareInfoMap = createorgInwareInfo.computeIfAbsent(createorgid, k -> new HashMap(16));
                inwareInfoMap.put("inwarorg", in_storage_org);
                inwareInfoMap.put("planscope", planscope);
            }
            dataset.close();
        }
        inwareInfo = (Map)createorgInwareInfo.get(orgId);
        if ((inwareInfo == null || inwareInfo.isEmpty()) && createorgInwareInfo.size() > 0) {
            Iterator it = createorgInwareInfo.entrySet().iterator();
            inwareInfo = (Map)it.next().getValue();
        }
        return inwareInfo;
    }

    public static Map<String, Long> getInwareInfoByInwarehouse(Long warehouseId, Long orgId, Boolean isIninvWhs) {
        Map<String, Long> inwareInfo = new HashMap(16);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEffectuate = new QFilter("effectuate_type", "=", (Object)"A");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterWarehouse = new QFilter("warehouse", "=", (Object)warehouseId);
        QFilter orgFilter = new QFilter("createorg", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, orgFilter, qFilterWarehouse, qFilterEffectuate};
        HashMap<Long, Map> createorgInwareInfo = new HashMap<Long, Map>();
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_PLANSCOPE_WHS, (String)"id,createorg,planscope,invorg", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long createorgid = row.getLong(1);
                Long planscope = row.getLong(2);
                Long in_storage_org = row.getLong(3);
                Map inwareInfoMap = createorgInwareInfo.computeIfAbsent(createorgid, k -> new HashMap(16));
                inwareInfoMap.put("inwarorg", in_storage_org);
                inwareInfoMap.put("planscope", planscope);
            }
            dataset.close();
        }
        inwareInfo = (Map)createorgInwareInfo.get(orgId);
        if ((inwareInfo == null || inwareInfo.isEmpty()) && createorgInwareInfo.size() > 0) {
            Iterator it = createorgInwareInfo.entrySet().iterator();
            inwareInfo = (Map)it.next().getValue();
        }
        return inwareInfo;
    }

    public static Map<Long, Map<String, Object>> getMaterialInwareInfo(Long mftorgId, Long entrustOrgId, Set<Long> masterIdSet) {
        Long orgId = mftorgId;
        if (entrustOrgId != null && !"0".equals(entrustOrgId.toString())) {
            orgId = entrustOrgId;
        }
        return PlanScopeHelper.getMaterialInwareInfo(orgId, masterIdSet);
    }

    public static Map<Long, Map<String, Object>> getMaterialInwareInfo(Long orgId, Set<Long> masterIdSet) {
        HashMap<Long, Map<String, Object>> materialInwareInfo = new HashMap<Long, Map<String, Object>>(16);
        boolean usePlanscope = PlanScopeHelper.isUsePlanscope();
        Long planScope = PlanScopeHelper.getPlanScope(orgId);
        DynamicObject planScopeDym = BusinessDataServiceHelper.loadSingleFromCache((Object)planScope, (String)"msplan_planscope", (String)"type");
        for (Long masterId : masterIdSet) {
            HashMap<String, Long> inwareInfoRes = new HashMap<String, Long>(16);
            inwareInfoRes.put("planscope", 0L);
            inwareInfoRes.put("inwarorg", 0L);
            inwareInfoRes.put("inwarehouse", 0L);
            inwareInfoRes.put("inwarelocation", 0L);
            if (usePlanscope) {
                inwareInfoRes.put("planscope", planScope);
                Map<String, Long> inwareInfo = PlanScopeHelper.getDefInwareInfo(planScopeDym, masterId, orgId);
                if (inwareInfo != null) {
                    inwareInfoRes.put("inwarorg", inwareInfo.get("inwarorg"));
                    inwareInfoRes.put("inwarehouse", inwareInfo.get("inwarehouse"));
                    inwareInfoRes.put("inwarelocation", inwareInfo.get("inwarelocation"));
                }
            } else {
                DynamicObject materialMftInfo = MaterialMftQueryHelper.getDataCacheByMaterialID(masterId, orgId, null);
                if (materialMftInfo != null && materialMftInfo.get("inwarorg") != null) {
                    DynamicObject inwarehouse = materialMftInfo.getDynamicObject("inwarehouse");
                    DynamicObject inwarelocation = materialMftInfo.getDynamicObject("inwarelocation");
                    inwareInfoRes.put("inwarorg", PlanScopeHelper.getPkId(materialMftInfo.getDynamicObject("inwarorg")));
                    inwareInfoRes.put("inwarehouse", PlanScopeHelper.getPkId(inwarehouse));
                    inwareInfoRes.put("inwarelocation", PlanScopeHelper.getPkId(inwarelocation));
                } else {
                    List<Long> inwareOrgFilter = PlanScopeHelper.getInwareOrgFilter(orgId);
                    if (!inwareOrgFilter.isEmpty()) {
                        if (inwareOrgFilter.contains(orgId)) {
                            inwareInfoRes.put("inwarorg", orgId);
                        } else {
                            inwareInfoRes.put("inwarorg", inwareOrgFilter.get(0));
                        }
                    }
                }
            }
            if (inwareInfoRes.get("planscope") == null) {
                inwareInfoRes.put("planscope", 0L);
            }
            if (inwareInfoRes.get("inwarorg") == null) {
                inwareInfoRes.put("inwarorg", 0L);
            }
            if (inwareInfoRes.get("inwarehouse") == null) {
                inwareInfoRes.put("inwarehouse", 0L);
            }
            if (inwareInfoRes.get("inwarelocation") == null) {
                inwareInfoRes.put("inwarelocation", 0L);
            }
            materialInwareInfo.put(masterId, inwareInfoRes);
        }
        return materialInwareInfo;
    }

    public static Long getPkId(DynamicObject entrymaterial) {
        return entrymaterial == null ? 0L : entrymaterial.getLong("id");
    }

    public static Long getPkId(Object objDym) {
        if (objDym instanceof DynamicObject) {
            return ((DynamicObject)objDym).getLong("id");
        }
        if (objDym instanceof Long) {
            return (Long)objDym;
        }
        return 0L;
    }

    public static Long innerTypeOrgId(int row, IDataModel iDataModel) {
        DynamicObject org = (DynamicObject)iDataModel.getValue("org");
        DynamicObject entrustdept = (DynamicObject)iDataModel.getValue("entrustdept");
        String supplyrule = (String)iDataModel.getValue("supplyrule", row);
        if ("C".equals(supplyrule) && entrustdept != null) {
            return entrustdept.getLong("id");
        }
        return org.getLong("id");
    }

    public static Long innerTypeOrgId(DynamicObject entry, DynamicObject org, DynamicObject entrustdept) {
        String supplyrule = entry.getString("supplyrule");
        if ("C".equals(supplyrule) && entrustdept != null) {
            return entrustdept.getLong("id");
        }
        return org.getLong("id");
    }
}

