/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.mftorder.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.manuftech.utils.ManuftechCreateBillUtil;
import kd.bd.mpdm.common.mftorder.utils.CreateStockByBomUtils;
import kd.bd.mpdm.common.mftorder.utils.CreateStockUtils;
import kd.bd.mpdm.common.mftorder.utils.OrderBaseData;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bd.mpdm.common.stockchange.utils.StockChangeUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class ReadManuVersionUtils {
    private static Log logger = LogFactory.getLog(ReadManuVersionUtils.class);

    private ReadManuVersionUtils() {
    }

    public static List<Long> getLongList(String orderentryids, DynamicObject[] objs) {
        String[] split = orderentryids.split(",");
        List<String> asList = Arrays.asList(split);
        List<Long> orderentryidListOld = new ArrayList<Long>(16);
        if (!asList.isEmpty()) {
            orderentryidListOld = asList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        }
        if (orderentryidListOld.isEmpty()) {
            for (DynamicObject order : objs) {
                DynamicObjectCollection treeentryentity = order.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject entry : treeentryentity) {
                    orderentryidListOld.add((Long)entry.getPkValue());
                }
            }
        }
        return orderentryidListOld;
    }

    public static List<Long> filterList(List<Long> orderentryidListOld, DynamicObject[] objs) {
        ArrayList<Long> orderentryidList = new ArrayList<Long>(16);
        for (DynamicObject order : objs) {
            DynamicObjectCollection orderEntrys = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntrys) {
                Long orderEntryId = (Long)orderEntry.getPkValue();
                if (!orderentryidListOld.isEmpty() && !orderentryidListOld.contains(orderEntryId)) continue;
                orderentryidList.add(orderEntryId);
            }
        }
        return orderentryidList;
    }

    public static void setStockValue(Map<Long, DynamicObject> stockMap, List<DynamicObject> saveBomStocks, List<Long> orderentryidList) {
        DynamicObject[] stocks;
        for (DynamicObject stock : stocks = BusinessDataServiceHelper.load((String)"pom_mftstock", (String)(StockChangeUtils.selectStockProperties("pom_xmftstock") + ",pid"), (QFilter[])new QFilter[]{new QFilter("orderentryid", "in", orderentryidList)})) {
            DynamicObject orderentryid = stock.getDynamicObject("orderentryid");
            DynamicObjectCollection stockentrys = stock.getDynamicObjectCollection("stockentry");
            stockentrys.clear();
            if (orderentryid == null) continue;
            stockMap.put((Long)orderentryid.getPkValue(), stock);
            saveBomStocks.add(stock);
        }
    }

    public static void updateStock(Map<Long, DynamicObject> orderEntryMap, Map<Long, DynamicObject> stockMap) {
        Date now = TimeServiceHelper.now();
        DynamicObject currentUser = UserServiceHelper.getCurrentUser((String)"id");
        for (Map.Entry<Long, DynamicObject> m : stockMap.entrySet()) {
            Long orderEntryId = m.getKey();
            DynamicObject stock = m.getValue();
            DynamicObject orderEntry = orderEntryMap.get(orderEntryId);
            if (orderEntry == null || stock == null) continue;
            stock.set("modifytime", (Object)now);
            stock.set("modifier", (Object)currentUser);
            stock.set("bomid", orderEntry.get("bomid"));
        }
    }

    public static void updateSeq(DynamicObject saveBomStock, String entryKey) {
        DynamicObjectCollection entrys = saveBomStock.getDynamicObjectCollection(entryKey);
        for (int i = 0; i < entrys.size(); ++i) {
            ((DynamicObject)entrys.get(i)).set("seq", (Object)(i + 1));
        }
    }

    public static void updateOrderEntry(DynamicObject order, String expendbomtime, List<Long> orderentryidList, Map<Long, DynamicObject> orderEntryMap, DynamicObject manuversion) {
        Date expendbomtimeDate = new Date(Long.parseLong(expendbomtime));
        DynamicObjectCollection orderEntrys = order.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject orderEntry : orderEntrys) {
            Long orderEntryId = (Long)orderEntry.getPkValue();
            if (orderentryidList.isEmpty() || orderentryidList.contains(orderEntryId)) {
                orderEntry.set("expendbomtime", (Object)expendbomtimeDate);
                ReadManuVersionUtils.setManuVersion(orderEntry, manuversion);
            }
            orderEntryMap.put(orderEntryId, orderEntry);
        }
    }

    public static void setManuVersion(DynamicObject orderEntry, DynamicObject manuversionNew) {
        DynamicObject manuversion;
        if (manuversionNew != null) {
            orderEntry.set("manuversion", (Object)manuversionNew);
            orderEntry.set("scheduler", manuversionNew.get("person"));
        }
        if ((manuversion = orderEntry.getDynamicObject("manuversion")) != null) {
            DynamicObject bom = manuversion.getDynamicObject("bom");
            DynamicObject processroute = manuversion.getDynamicObject("processroute");
            if (bom != null) {
                orderEntry.set("bomid", (Object)bom);
            }
            if (processroute != null) {
                orderEntry.set("processroute", (Object)processroute);
            }
            orderEntry.set("scheduler", manuversion.get("person"));
        }
    }

    public static void setTechnicsValue(String entityName, Map<Long, DynamicObject> technicsMap, List<DynamicObject> saveTechnics, List<Long> orderentryidList) {
        if (saveTechnics.isEmpty()) {
            DynamicObject[] technics;
            for (DynamicObject technic : technics = BusinessDataServiceHelper.load((String)entityName, (String)ReadManuVersionUtils.selectTechnicsProperties(), (QFilter[])new QFilter[]{new QFilter("mftentryseq", "in", orderentryidList)})) {
                DynamicObject orderentryid = technic.getDynamicObject("mftentryseq");
                if (orderentryid == null) continue;
                technicsMap.put((Long)orderentryid.getPkValue(), technic);
                saveTechnics.add(technic);
            }
        } else {
            for (DynamicObject technic : saveTechnics) {
                DynamicObject orderentryid = technic.getDynamicObject("mftentryseq");
                if (orderentryid == null) continue;
                technicsMap.put((Long)orderentryid.getPkValue(), technic);
            }
        }
        logger.info("\u91cd\u8bfb\u751f\u4ea7\u7248\u672cupdateTechnics setTechnicsValue size:" + technicsMap.size());
    }

    public static String selectTechnicsProperties() {
        Set<String> entryFields = ReadManuVersionUtils.getAllEntryFields("proentryentity");
        Set<String> allEntryFields = ReadManuVersionUtils.getAllEntryFields("oprentryentity");
        Set<String> actsubentryentityFields = ReadManuVersionUtils.getAllEntryFields("actsubentryentity");
        StringBuilder sb = new StringBuilder("id,billno,org,billstatus,mftentryseq,manufactureorderid,material,qty,unit,baseqty,baseunit,processroute,modifytime,modifier,proentryentity.seq,oprentryentity.seq");
        for (String entryField : entryFields) {
            sb.append(",");
            sb.append(entryField);
        }
        for (String entryField : allEntryFields) {
            sb.append(",");
            sb.append(entryField);
        }
        for (String entryField : actsubentryentityFields) {
            sb.append(",");
            sb.append(entryField);
        }
        return sb.toString();
    }

    public static Set<String> getAllEntryFields(String entryKey) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"sfc_manftech");
        EntityType subEntryType = (EntityType)mainType.getAllEntities().get(entryKey);
        return subEntryType.getFields().keySet();
    }

    public static void updateTechnics(Map<Long, DynamicObject> orderEntryMap, Map<Long, DynamicObject> technicsMap, Set<Object> processRouteIds) {
        Date now = TimeServiceHelper.now();
        DynamicObject currentUser = UserServiceHelper.getCurrentUser((String)"id");
        logger.info("\u91cd\u8bfb\u751f\u4ea7\u7248\u672cupdateTechnics updateTechnics size:" + technicsMap.size());
        boolean isEnablePlanScope = (Boolean)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IPlanScopeService", (String)"isEnablePlanScope", (Object[])new Object[0]);
        for (Map.Entry<Long, DynamicObject> m : technicsMap.entrySet()) {
            Long orderEntryId = m.getKey();
            DynamicObject technic = m.getValue();
            DynamicObject trans = technic.getDynamicObject("transactiontype");
            boolean versionreq = trans.getBoolean("versionreq");
            DynamicObject orderEntry = orderEntryMap.get(orderEntryId);
            if (orderEntry == null || technic == null) continue;
            technic.set("modifytime", (Object)now);
            technic.set("modifier", (Object)currentUser);
            DynamicObject newprocessroute = orderEntry.getDynamicObject("processroute");
            DynamicObject oldprocessroute = technic.getDynamicObject("processroute");
            String newprocessrouteId = newprocessroute == null ? "0" : newprocessroute.getPkValue().toString();
            String oldprocessrouteId = oldprocessroute == null ? "0" : oldprocessroute.getPkValue().toString();
            technic.set("processroute", (Object)newprocessroute);
            String oldprocessnum = oldprocessroute == null ? "null" : oldprocessroute.getString("number");
            String newprocessnum = newprocessroute == null ? "null" : newprocessroute.getString("number");
            logger.info("\u91cd\u8bfb\u751f\u4ea7\u7248\u672cupdateTechnics updateTechnics :oldprocessroute:" + oldprocessnum + "/newprocessroute:" + newprocessnum);
            logger.info("\u91cd\u8bfb\u751f\u4ea7\u7248\u672cupdateTechnics updateTechnics :" + (newprocessroute != null) + "/" + !newprocessrouteId.equals(oldprocessrouteId) + "/" + (versionreq || isEnablePlanScope));
            if (newprocessroute == null || newprocessrouteId.equals(oldprocessrouteId) || !versionreq && !isEnablePlanScope) continue;
            DynamicObjectCollection proentryentity = technic.getDynamicObjectCollection("proentryentity");
            DynamicObjectCollection oprentryentity = technic.getDynamicObjectCollection("oprentryentity");
            proentryentity.clear();
            oprentryentity.clear();
            processRouteIds.add(newprocessroute.getPkValue());
            logger.info("\u91cd\u8bfb\u751f\u4ea7\u7248\u672cupdateTechnics updateTechnics \u6ee1\u8db3\u91cd\u65b0\u5c55\u5f00\u6761\u4ef6\u3002");
        }
    }

    public static void updateTechnics(String entityName, Map<Long, DynamicObject> orderEntryMap, List<DynamicObject> saveTechnics, List<Long> orderentryidList) {
        HashMap<Long, DynamicObject> technicsMap = new HashMap<Long, DynamicObject>(16);
        HashSet<Object> processRouteIds = new HashSet<Object>(16);
        logger.info("\u91cd\u8bfb\u751f\u4ea7\u7248\u672cupdateTechnics  saveTechnics size :" + saveTechnics.size());
        ReadManuVersionUtils.setTechnicsValue(entityName, technicsMap, saveTechnics, orderentryidList);
        ReadManuVersionUtils.updateTechnics(orderEntryMap, technicsMap, processRouteIds);
        logger.info("\u91cd\u8bfb\u751f\u4ea7\u7248\u672cupdateTechnics processRouteIds size " + processRouteIds.size());
        if (!saveTechnics.isEmpty() && !processRouteIds.isEmpty()) {
            Map processRoutes = BusinessDataServiceHelper.loadFromCache((Object[])processRouteIds.toArray(new Object[processRouteIds.size()]), (String)"pdm_route");
            logger.info("\u91cd\u8bfb\u751f\u4ea7\u7248\u672cupdateTechnics processRoutes size " + processRoutes.size());
            for (DynamicObject saveTechnic : saveTechnics) {
                DynamicObject processRoute;
                DynamicObject processRouteold = saveTechnic.getDynamicObject("processroute");
                DynamicObject mftentryseq = saveTechnic.getDynamicObject("mftentryseq");
                DynamicObject orderEntryObj = orderEntryMap.get(mftentryseq.getPkValue());
                if (processRouteold == null || orderEntryObj == null || (processRoute = (DynamicObject)processRoutes.get(processRouteold.getPkValue())) == null) continue;
                DynamicObjectCollection entryentity = processRoute.getDynamicObjectCollection("entryentity");
                DynamicObjectCollection proentryentitys = saveTechnic.getDynamicObjectCollection("proentryentity");
                for (DynamicObject entry : entryentity) {
                    DynamicObject newEntryObj = proentryentitys.addNew();
                    ManuftechCreateBillUtil.setProEntryEntityValue(entry, orderEntryObj, newEntryObj);
                    newEntryObj.set("seq", (Object)proentryentitys.getRowCount());
                }
                DynamicObjectCollection processentry = processRoute.getDynamicObjectCollection("processentry");
                DynamicObjectCollection oprentryentitys = saveTechnic.getDynamicObjectCollection("oprentryentity");
                for (DynamicObject entry : processentry) {
                    DynamicObject newEntryObj = oprentryentitys.addNew();
                    ReadManuVersionUtils.createOprentryentityRow(saveTechnic, newEntryObj, orderEntryObj, entry, oprentryentitys.getRowCount());
                }
            }
        }
    }

    public static void createOprentryentityRow(DynamicObject saveTechnic, DynamicObject oprentryentity, DynamicObject orderEntryObj, DynamicObject entry, int seq) {
        oprentryentity.set("oprproductionqty", (Object)saveTechnic.getBigDecimal("qty"));
        ManuftechCreateBillUtil.setOprEntryEntityValue(entry, orderEntryObj, oprentryentity);
        if (seq != 0) {
            oprentryentity.set("seq", (Object)seq);
        }
        ManuftechCreateBillUtil.setActSubEntryEntityValue(entry, orderEntryObj, oprentryentity);
    }

    public static void updateStock(Map<Long, DynamicObject> orderEntryMap, List<DynamicObject> saveBomStocks, List<DynamicObject> orderList, List<Long> orderentryidList) {
        HashMap<Long, DynamicObject> stockMap = new HashMap<Long, DynamicObject>(16);
        ReadManuVersionUtils.setStockValue(stockMap, saveBomStocks, orderentryidList);
        ReadManuVersionUtils.updateStock(orderEntryMap, stockMap);
        if (!saveBomStocks.isEmpty()) {
            OrderBaseData baseData = new OrderBaseData();
            CreateStockUtils.putOrderMap(orderList, baseData, "pom_mftstock");
            CreateStockByBomUtils.expandBomStocks(saveBomStocks, baseData);
            for (DynamicObject saveBomStock : saveBomStocks) {
                ReadManuVersionUtils.updateSeq(saveBomStock, "stockentry");
            }
        }
    }

    public static Object getVariableValue(OperateOption option, String keyName) {
        if ("expendbomtime".equals(keyName)) {
            String expendbomtime = option.getVariableValue(keyName, "");
            if ("".equals(expendbomtime)) {
                expendbomtime = String.valueOf(TimeServiceHelper.now().getTime());
            }
            return expendbomtime;
        }
        if ("manuversion".equals(keyName)) {
            String manuversionId = option.getVariableValue("manuversion", "0");
            DynamicObject manuversion = null;
            if (!"0".equals(manuversionId)) {
                manuversion = BusinessDataServiceHelper.loadSingleFromCache((String)"pdm_manuversion", (String)"bom,processroute,begindate,enddate,person,supwarehouseid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(manuversionId))});
            }
            return manuversion;
        }
        return "";
    }

    public static Set<Long> getPushOrderIdSet(ExtendedDataEntity[] dataEntities) {
        ArrayList<Long> orderIdList = new ArrayList<Long>(16);
        for (ExtendedDataEntity rowDataEntity : dataEntities) {
            DynamicObject order = rowDataEntity.getDataEntity();
            orderIdList.add((Long)order.getPkValue());
        }
        Long[] array = orderIdList.toArray(new Long[0]);
        Map findTargetBills = BFTrackerServiceHelper.findTargetBills((String)"pom_mftorder", (Long[])array);
        Map findDirtTargetBills = BFTrackerServiceHelper.findDirtTargetBills((String)"pom_mftorder", (Long[])array);
        findTargetBills.keySet().remove("pom_mftstock");
        findTargetBills.keySet().remove("sfc_manftech");
        HashSet<Long> pushOrderIdSet = new HashSet<Long>(16);
        if (findTargetBills.size() > 0) {
            HashSet targetBillIdSet = new HashSet();
            for (Map.Entry m : findTargetBills.entrySet()) {
                targetBillIdSet.addAll((Collection)m.getValue());
            }
            for (Long orderId : orderIdList) {
                List lists = (List)findDirtTargetBills.get(orderId);
                for (BFRow bfRow : lists) {
                    BFRowId bFRowId = bfRow.getId();
                    BFRowId sId = bfRow.getSId();
                    Long billId = bFRowId.getBillId();
                    if (!targetBillIdSet.contains(billId)) continue;
                    pushOrderIdSet.add(sId.getBillId());
                }
            }
        }
        return pushOrderIdSet;
    }

    public static Set<Long> getPushOrderEntryIdSet(ExtendedDataEntity[] dataEntities) {
        ArrayList<Long> orderIdList = new ArrayList<Long>(16);
        for (ExtendedDataEntity rowDataEntity : dataEntities) {
            DynamicObject order = rowDataEntity.getDataEntity();
            orderIdList.add((Long)order.getPkValue());
        }
        Long[] orderIdArr = orderIdList.toArray(new Long[0]);
        OperateOption createOption = OperateOption.create();
        List linkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)"pom_mftorder", (Long[])orderIdArr, (OperateOption)createOption);
        HashSet<Long> entryIdsExistLink = new HashSet<Long>(linkDownNodes.size());
        for (BFRowLinkDownNode node : linkDownNodes) {
            node.getRowId();
            Map tNodes = node.getTNodes();
            for (Map.Entry s : tNodes.entrySet()) {
                BFRowId key = (BFRowId)s.getKey();
                Long mainTableId = key.getMainTableId();
                String entityNumber = EntityMetadataCache.loadTableDefine((Long)mainTableId).getEntityNumber();
                if ("pom_mftstock".equals(entityNumber) || "sfc_manftech".equals(entityNumber)) continue;
                entryIdsExistLink.add(node.getRowId().getEntryId());
            }
        }
        return entryIdsExistLink;
    }

    public static List<Long> getLockListByName(String orderEntryKey, DynamicObjectCollection querys) {
        ArrayList<Long> orderentryidStockList = new ArrayList<Long>(16);
        ArrayList<String> stockIdList = new ArrayList<String>(16);
        HashMap<String, Long> stockIdMap = new HashMap<String, Long>(16);
        for (DynamicObject query : querys) {
            if (!"A".equals(query.getString("billstatus"))) continue;
            String stockId = query.get("id").toString();
            stockIdList.add(stockId);
            stockIdMap.put(stockId, query.getLong(orderEntryKey));
        }
        List<String> stockLockIdList = OrderOpUtils.getStockLock(stockIdList);
        for (String stockLockId : stockLockIdList) {
            orderentryidStockList.add((Long)stockIdMap.get(stockLockId));
        }
        return orderentryidStockList;
    }

    public static DynamicObject[] getDym(ExtendedDataEntity[] dataEntities) {
        ArrayList<DynamicObject> orders = new ArrayList<DynamicObject>(16);
        for (ExtendedDataEntity rowDataEntity : dataEntities) {
            orders.add(rowDataEntity.getDataEntity());
        }
        return orders.toArray(new DynamicObject[0]);
    }

    public static List<Long> getPushOrderEntryIdSet(DynamicObjectCollection querys, String entryKeyName, String entityName) {
        ArrayList<Long> orderentryidStockList = new ArrayList<Long>(16);
        HashSet<Long> stockIdList = new HashSet<Long>(16);
        HashMap<Long, Long> stockIdMap = new HashMap<Long, Long>(16);
        for (DynamicObject query : querys) {
            stockIdList.add(query.getLong("id"));
            stockIdMap.put(query.getLong("id"), query.getLong(entryKeyName));
        }
        OperateOption createOption = OperateOption.create();
        List linkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)entityName, (Long[])stockIdList.toArray(new Long[0]), (OperateOption)createOption);
        HashSet<Long> entryIdsExistLink = new HashSet<Long>(linkDownNodes.size());
        for (BFRowLinkDownNode node : linkDownNodes) {
            entryIdsExistLink.add(node.getRowId().getBillId());
        }
        if (stockIdList.size() > 0 && StringUtils.equals((CharSequence)"pom_mftstock", (CharSequence)entityName)) {
            SqlBuilder sql = new SqlBuilder();
            Set collect = stockIdList.stream().map(k -> k.toString()).collect(Collectors.toSet());
            sql.appendIn("select fstockid from t_pom_xmanustockentry_b where fstockid ", collect.toArray());
            try (DataSet dataSet = DB.queryDataSet((String)(ReadManuVersionUtils.class.getName() + "getPushOrderEntryIdSet"), (DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sql);){
                for (Row row : dataSet) {
                    entryIdsExistLink.add(row.getLong("fstockid"));
                }
            }
        }
        for (Long stockLockId : entryIdsExistLink) {
            orderentryidStockList.add((Long)stockIdMap.get(stockLockId));
        }
        return orderentryidStockList;
    }

    public static List<Long> getProductConfigure(List<Object> orderEntryIdList) {
        HashSet<Long> masterIdSet = new HashSet<Long>(16);
        HashSet<Long> configuredcodeSet = new HashSet<Long>(16);
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        DynamicObjectCollection querys = QueryServiceHelper.query((String)"pom_mftorder", (String)"treeentryentity.materielmasterid,treeentryentity.configuredcode,org", (QFilter[])new QFilter[]{new QFilter("treeentryentity.id", "in", orderEntryIdList)});
        for (DynamicObject query : querys) {
            masterIdSet.add(query.getLong("treeentryentity.materielmasterid"));
            configuredcodeSet.add(query.getLong("treeentryentity.configuredcode"));
            orgIdSet.add(query.getLong("org"));
        }
        QFilter q = new QFilter("materielno", "in", masterIdSet);
        q.and(new QFilter("prodorgid", "in", orgIdSet));
        q.and(new QFilter("masterconfigcode", "in", configuredcodeSet));
        DynamicObjectCollection productconfigures = QueryServiceHelper.query((String)"pdm_productconfigure", (String)"id", (QFilter[])new QFilter[]{q});
        ArrayList<Long> queryIdSet = new ArrayList<Long>(16);
        for (DynamicObject productconfigure : productconfigures) {
            queryIdSet.add(productconfigure.getLong("id"));
        }
        return queryIdSet;
    }
}

