/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.mftorder.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bd.mpdm.common.stockchange.utils.EntityNameUtils;
import kd.bd.mpdm.common.utils.UnitPrecisionUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class StockCulUtils {
    private static final String TREEENTRYENTITYID = "treeentryentity.id";
    private static final ThreadLocal<Map<String, Map<String, Object>>> orderQtyThreadLocal = new ThreadLocal();
    private static final ThreadLocal<Map<String, DynamicObject>> manuftechThreadLocal = new ThreadLocal();

    private StockCulUtils() {
    }

    public static void batchCulUseQtyByOrderEntryId(List<Long> orderEntryIdList, String orderName) {
        QFilter qf = new QFilter("orderentryid", "in", orderEntryIdList);
        DynamicObject[] stockDymList = BusinessDataServiceHelper.load((String)EntityNameUtils.getEntityName(0, 1, orderName), (String)"transactiontypeid,orderentryid,baseqty,stockentry,stockentry.demandqty,stockentry.wipqty,stockentry.useqty,stockentry.iscannegative,stockentry.qtytype,stockentry.actissueqty,stockentry.feedingqty,stockentry.rejectedqty,stockentry.processseq,stockentry.oprno,stockentry.materialunitid", (QFilter[])new QFilter[]{qf});
        if (stockDymList == null) {
            return;
        }
        Map<Object, Object> orderBizStatusMap = new HashMap(16);
        if (!"pm_om_purorderbill".equals(orderName)) {
            orderBizStatusMap = StockCulUtils.getOrderBizStatusMap(orderEntryIdList, orderName);
        }
        ArrayList<DynamicObject> updateStockDymList = new ArrayList<DynamicObject>(orderEntryIdList.size());
        HashSet<Long> updateStockIDSet = new HashSet<Long>(orderEntryIdList.size());
        HashMap<Long, DynamicObject> transactionTypeMap = new HashMap<Long, DynamicObject>(16);
        for (int i = 0; i < stockDymList.length; ++i) {
            DynamicObjectCollection stockEntryDym;
            DynamicObject stockDy = stockDymList[i];
            Long orderEntryId = (Long)stockDy.getDynamicObject("orderentryid").getPkValue();
            String orderBizStatus = (String)orderBizStatusMap.get(orderEntryId);
            if (!"pm_om_purorderbill".equals(orderName) && (orderBizStatus == null || "C".equals(orderBizStatus)) || (stockEntryDym = stockDy.getDynamicObjectCollection("stockentry")) == null || stockEntryDym.isEmpty()) continue;
            for (int j = 0; j < stockEntryDym.size(); ++j) {
                BigDecimal useQty;
                BigDecimal newWipQty;
                Long transID;
                DynamicObject stockEntry = (DynamicObject)stockEntryDym.get(j);
                BigDecimal actissueQty = stockEntry.getBigDecimal("actissueqty");
                BigDecimal feedingQty = stockEntry.getBigDecimal("feedingqty");
                BigDecimal rejectedQty = stockEntry.getBigDecimal("rejectedqty");
                BigDecimal oldwipqty = stockEntry.getBigDecimal("wipqty");
                BigDecimal olduseqty = stockEntry.getBigDecimal("useqty");
                BigDecimal outsQty = actissueQty.add(feedingQty).subtract(rejectedQty);
                if (oldwipqty == null) {
                    oldwipqty = BigDecimal.ZERO;
                }
                if (olduseqty == null) {
                    olduseqty = BigDecimal.ZERO;
                }
                DynamicObject transactionType = stockDymList[i].getDynamicObject("transactiontypeid");
                if (!"pm_om_purorderbill".equals(orderName) && (transactionType = (DynamicObject)transactionTypeMap.get(transID = Long.valueOf(transactionType.getLong("id")))) == null) {
                    transactionType = TransactionTypeQueryHelper.getDataCacheByID(transID);
                    transactionTypeMap.put(transID, transactionType);
                }
                if (oldwipqty.compareTo(newWipQty = outsQty.subtract(useQty = StockCulUtils.culUseQty(stockEntry, stockDymList[i].getDynamicObject("orderentryid").getPkValue(), transactionType, orderName))) == 0 && olduseqty.compareTo(useQty) == 0) continue;
                stockEntry.set("wipqty", (Object)newWipQty);
                stockEntry.set("useqty", (Object)useQty);
                UnitPrecisionUtils.caleQtyPrecision(stockEntry, "materialunitid", "wipqty", "useqty");
                if (updateStockIDSet.contains(stockDy.getLong("id"))) continue;
                updateStockDymList.add(stockDy);
                updateStockIDSet.add(stockDy.getLong("id"));
            }
        }
        if (!updateStockDymList.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])updateStockDymList.toArray(new DynamicObject[updateStockDymList.size()]));
        }
    }

    public static BigDecimal culUseQty(DynamicObject stockEntry, Object orderEntryId, DynamicObject transactiontype, String orderName) {
        if ("pm_om_purorderbill".equals(orderName)) {
            return MPDMMftGenStocksUtils.aculOMUseQty(stockEntry, orderEntryId, transactiontype);
        }
        if (stockEntry.getBoolean("iscannegative")) {
            return BigDecimal.ZERO;
        }
        String deduction = transactiontype.getString("deduction");
        if ("A".equals(deduction)) {
            return StockCulUtils.aculUseQtyA(stockEntry, orderEntryId, orderName);
        }
        if ("B".equals(deduction)) {
            return StockCulUtils.aculUseQtyB(stockEntry, orderEntryId, transactiontype, orderName);
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal aculUseQtyA(DynamicObject stockEntry, Object orderEntryId, String orderName) {
        Map<String, Object> orderMap = StockCulUtils.getOrderQtyMap(orderEntryId, orderName);
        if (orderMap.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal orderBaseQty = BigDecimal.ONE;
        BigDecimal stockqty = BigDecimal.ZERO;
        BigDecimal quainwaqty = (BigDecimal)orderMap.get("quainwaqty");
        BigDecimal unquainwaqty = (BigDecimal)orderMap.get("unquainwaqty");
        BigDecimal scrinwaqty = (BigDecimal)orderMap.get("scrinwaqty");
        stockqty = quainwaqty.add(unquainwaqty).add(scrinwaqty);
        orderBaseQty = (BigDecimal)orderMap.get("baseqty");
        String qtytype = stockEntry.getString("qtytype");
        BigDecimal useQty = BigDecimal.ZERO;
        if (orderBaseQty.compareTo(BigDecimal.ZERO) == 0) {
            orderBaseQty = BigDecimal.ONE;
        }
        if ("A".equals(qtytype) || "C".equals(qtytype)) {
            BigDecimal demandBaseQty = stockEntry.getBigDecimal("demandqty");
            useQty = stockqty.multiply(demandBaseQty).divide(orderBaseQty, 8, 4);
        }
        if ("B".equals(qtytype)) {
            useQty = stockqty.compareTo(orderBaseQty) >= 0 ? stockEntry.getBigDecimal("demandqty") : BigDecimal.ZERO;
        }
        return useQty;
    }

    public static BigDecimal aculUseQtyB(DynamicObject stockEntry, Object orderEntryId, DynamicObject transactiontype, String orderName) {
        BigDecimal useQty = BigDecimal.ZERO;
        if (transactiontype.getBoolean("isprocedure")) {
            useQty = StockCulUtils.aculUseQtyC(stockEntry, orderEntryId, orderName);
        } else {
            Map<String, Object> orderMap = StockCulUtils.getOrderQtyMap(orderEntryId, orderName);
            if (orderMap.isEmpty()) {
                return BigDecimal.ZERO;
            }
            BigDecimal orderBaseQty = BigDecimal.ONE;
            BigDecimal reportQty = BigDecimal.ZERO;
            orderBaseQty = (BigDecimal)orderMap.get("qty");
            reportQty = (BigDecimal)orderMap.get("reportqty");
            if (orderBaseQty.compareTo(BigDecimal.ZERO) == 0) {
                orderBaseQty = BigDecimal.ONE;
            }
            BigDecimal demandBaseQty = stockEntry.getBigDecimal("demandqty");
            String qtytype = stockEntry.getString("qtytype");
            if ("A".equals(qtytype) || "C".equals(qtytype)) {
                useQty = reportQty.multiply(demandBaseQty).divide(orderBaseQty, 8, 4);
            }
            if ("B".equals(qtytype)) {
                useQty = reportQty.compareTo(orderBaseQty) >= 0 ? demandBaseQty : BigDecimal.ZERO;
            }
        }
        return useQty;
    }

    public static BigDecimal aculUseQtyC(DynamicObject stockEntry, Object orderEntryId, String orderName) {
        BigDecimal useQty = BigDecimal.ZERO;
        BigDecimal demandBaseQty = stockEntry.getBigDecimal("demandqty");
        DynamicObject manftechDym = StockCulUtils.getManufTechDy(orderEntryId, orderName);
        if (manftechDym == null) {
            return useQty;
        }
        String processseq = stockEntry.getString("processseq");
        String oprno = stockEntry.getString("oprno");
        DynamicObjectCollection workPlanEntrys = manftechDym.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject workPlanEntry : workPlanEntrys) {
            if (!processseq.equals(workPlanEntry.getString("oprparent")) || !oprno.equals(workPlanEntry.getString("oprno"))) continue;
            BigDecimal orderBaseQty = StockCulUtils.getOrderBaseQty(orderEntryId, orderName);
            BigDecimal oprtotalReportQty = workPlanEntry.getBigDecimal("oprtotalreportbaseqty");
            String qtytype = stockEntry.getString("qtytype");
            if ("A".equals(qtytype) || "C".equals(qtytype)) {
                useQty = oprtotalReportQty.multiply(demandBaseQty).divide(orderBaseQty, 8, 4);
            }
            if (!"B".equals(qtytype)) continue;
            if (oprtotalReportQty.compareTo(orderBaseQty) >= 0) {
                useQty = demandBaseQty;
                continue;
            }
            useQty = BigDecimal.ZERO;
        }
        return useQty;
    }

    public static BigDecimal getOrderBaseQty(Object orderEntryId, String orderName) {
        Map<String, Object> orderMap = StockCulUtils.getOrderQtyMap(orderEntryId, orderName);
        if (orderMap.isEmpty()) {
            return BigDecimal.ONE;
        }
        BigDecimal orderBaseQty = BigDecimal.ONE;
        orderBaseQty = (BigDecimal)orderMap.get("baseqty");
        if (orderBaseQty.compareTo(BigDecimal.ZERO) == 0) {
            orderBaseQty = BigDecimal.ONE;
        }
        return orderBaseQty;
    }

    public static boolean isInteger(Object str) {
        if (str == null || "0".equals(str.toString())) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str.toString()).matches();
    }

    private static Map<String, Object> getOrderQtyMap(Object orderEntryId, String orderName) {
        Map<String, Object> dataMap;
        String orderKeys = String.valueOf(orderEntryId) + orderName;
        Map<String, Map<String, Object>> orderQtyDataMap = orderQtyThreadLocal.get();
        if (orderQtyDataMap == null) {
            orderQtyDataMap = new HashMap<String, Map<String, Object>>();
            orderQtyThreadLocal.set(orderQtyDataMap);
        }
        if ((dataMap = orderQtyDataMap.get(orderKeys)) != null && !dataMap.isEmpty()) {
            return dataMap;
        }
        QFilter qfilter = new QFilter(TREEENTRYENTITYID, "=", orderEntryId);
        dataMap = new HashMap<String, Object>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-StockCulUtils-getOrderQtyMap", (String)orderName, (String)"treeentryentity.baseqty baseqty ,treeentryentity.qty qty,treeentryentity.reportqty reportqty,treeentryentity.quainwaqty quainwaqty,treeentryentity.unquainwaqty unquainwaqty ,treeentryentity.scrinwaqty scrinwaqty ", (QFilter[])new QFilter[]{qfilter}, (String)"");){
            while (ds.hasNext()) {
                Row dsRow = ds.next();
                dataMap.put("baseqty", "0E-10".equals(dsRow.getString("baseqty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("baseqty"));
                dataMap.put("quainwaqty", "0E-10".equals(dsRow.getString("quainwaqty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("quainwaqty"));
                dataMap.put("unquainwaqty", "0E-10".equals(dsRow.getString("unquainwaqty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("unquainwaqty"));
                dataMap.put("scrinwaqty", "0E-10".equals(dsRow.getString("scrinwaqty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("scrinwaqty"));
                dataMap.put("qty", "0E-10".equals(dsRow.getString("qty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("qty"));
                dataMap.put("reportqty", "0E-10".equals(dsRow.getString("reportqty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("reportqty"));
            }
        }
        orderQtyDataMap.put(orderKeys, dataMap);
        return dataMap;
    }

    private static DynamicObject getManufTechDy(Object orderEntryId, String orderName) {
        DynamicObject manftechDym;
        String orderKeys = String.valueOf(orderEntryId) + orderName;
        Map<String, DynamicObject> techMap = manuftechThreadLocal.get();
        if (techMap == null) {
            techMap = new HashMap<String, DynamicObject>();
            manuftechThreadLocal.set(techMap);
        }
        if ((manftechDym = techMap.get(orderKeys)) != null) {
            return manftechDym;
        }
        if (techMap.containsKey(orderKeys)) {
            return manftechDym;
        }
        QFilter filter = new QFilter("mftentryseq", "=", orderEntryId);
        manftechDym = BusinessDataServiceHelper.loadSingle((String)EntityNameUtils.getEntityName(0, 2, orderName), (String)"baseqty,oprentryentity.oprtotalreportqty,oprentryentity.oprtotalreportbaseqty,oprentryentity.oprparent,oprentryentity.oprno", (QFilter[])new QFilter[]{filter});
        techMap.put(orderKeys, manftechDym);
        return manftechDym;
    }

    private static Map<Long, String> getOrderBizStatusMap(List<Long> orderEntryIdList, String orderName) {
        QFilter qfilter = new QFilter(TREEENTRYENTITYID, "in", orderEntryIdList);
        HashMap<Long, String> dataMap = new HashMap<Long, String>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-StockCulUtils-getOrderBaseStatus", (String)orderName, (String)"treeentryentity.bizstatus bizstatus ,treeentryentity.id  id  ", (QFilter[])new QFilter[]{qfilter}, (String)"");){
            while (ds.hasNext()) {
                Row dsRow = ds.next();
                dataMap.put(dsRow.getLong("id"), dsRow.getString("bizstatus"));
            }
        }
        return dataMap;
    }

    public static Map<String, Boolean> getRepConfigSet() {
        HashMap<String, Boolean> retMap = new HashMap<String, Boolean>(16);
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        String fields = "createorg,entrymaterial,entryver,auxproperties,numrate,isreduction,iscalculate";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)StockCulUtils.class.getName(), (String)"mpdm_bomrepconfig", (String)fields, (QFilter[])new QFilter[]{filter}, (String)"modifytime desc");){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                boolean isNeedOrg = row.getBoolean("createorg");
                boolean isNeedMat = row.getBoolean("entrymaterial");
                boolean isNeedVer = row.getBoolean("entryver");
                boolean isNeedAuxp = row.getBoolean("auxproperties");
                boolean isNeedNum = row.getBoolean("numrate");
                boolean isCalculate = row.getBoolean("iscalculate");
                boolean isReduction = row.getBoolean("isreduction");
                retMap.put("isNeedOrg", isNeedOrg);
                retMap.put("isNeedMat", isNeedMat);
                retMap.put("isNeedVer", isNeedVer);
                retMap.put("isNeedAuxp", isNeedAuxp);
                retMap.put("isNeedNum", isNeedNum);
                retMap.put("isCalculate", isCalculate);
                retMap.put("isReduction", isReduction);
            }
        }
        return retMap;
    }

    public static String getReplaceCompareString(DynamicObject dym, Map<String, Boolean> repConfigSet) {
        boolean isNeedVer = repConfigSet.get("isNeedVer");
        boolean isNeedAuxp = repConfigSet.get("isNeedAuxp");
        StringBuilder info = new StringBuilder();
        boolean isRepEntry = "repmaterentry".equals(dym.getDataEntityType().getName());
        String rep = isRepEntry ? "rep" : "";
        DynamicObject material = dym.getDynamicObject(rep + "material");
        String materialId = material.getDynamicObject("masterid").getPkValue().toString();
        String auxPropertyId = "0";
        DynamicObject auxProperty = dym.getDynamicObject(rep + "auxpty");
        if (auxProperty != null) {
            auxPropertyId = auxProperty.getPkValue().toString();
        }
        String bomVersionId = "0";
        DynamicObject bomVersion = dym.getDynamicObject(rep + "bomversion");
        if (bomVersion != null) {
            bomVersionId = bomVersion.getPkValue().toString();
        }
        info.append(materialId);
        if (isNeedAuxp) {
            info.append(auxPropertyId);
        }
        if (isNeedVer) {
            info.append(bomVersionId);
        }
        if (isRepEntry) {
            Object reppriority = dym.get(rep + "priority");
            info.append(reppriority);
        }
        return info.toString();
    }

    public static String getStockCompareString(DynamicObject entry, Map<String, Boolean> repConfigSet) {
        boolean isNeedVer = repConfigSet.get("isNeedVer");
        boolean isNeedAuxp = repConfigSet.get("isNeedAuxp");
        StringBuilder info = new StringBuilder();
        DynamicObject material = entry.getDynamicObject("materialid");
        String materialId = material.getDynamicObject("masterid").getPkValue().toString();
        String auxPropertyId = "0";
        DynamicObject auxProperty = entry.getDynamicObject("childauxpropertyid");
        if (auxProperty != null) {
            auxPropertyId = auxProperty.getPkValue().toString();
        }
        String bomVersionId = "0";
        DynamicObject bomVersion = entry.getDynamicObject("bomreversion");
        if (bomVersion != null) {
            bomVersionId = bomVersion.getPkValue().toString();
        }
        info.append(materialId);
        if (isNeedAuxp) {
            info.append(auxPropertyId);
        }
        if (isNeedVer) {
            info.append(bomVersionId);
        }
        return info.toString();
    }

    public static boolean isAlike(List<String> infoList, Map<String, BigDecimal> infoListMap, Map<String, BigDecimal> replaceInfoListMap, Map<String, Boolean> repConfigSet) {
        boolean isNeedNum = repConfigSet.get("isNeedNum");
        String infoOne = infoList.get(0);
        BigDecimal stockMole = infoListMap.get(infoOne + "0");
        if (!(infoList.size() != 1 && isNeedNum || stockMole.compareTo(BigDecimal.ZERO) == 0)) {
            return true;
        }
        BigDecimal stockDeno = infoListMap.get(infoOne + "1");
        BigDecimal repMole = replaceInfoListMap.get(infoOne + "0");
        BigDecimal repDeno = replaceInfoListMap.get(infoOne + "1");
        for (String info : infoList) {
            BigDecimal stockMoleNew = infoListMap.get(info + "0");
            BigDecimal stockDenoNew = infoListMap.get(info + "1");
            BigDecimal repMoleNew = replaceInfoListMap.get(info + "0");
            BigDecimal repDenoNew = replaceInfoListMap.get(info + "1");
            BigDecimal moleMul = repMole.multiply(stockMoleNew);
            BigDecimal demoMul = repDeno.multiply(stockDenoNew);
            BigDecimal moleMulNew = stockMole.multiply(repMoleNew);
            BigDecimal demoMulNew = stockDeno.multiply(repDenoNew);
            if (stockMoleNew.compareTo(BigDecimal.ZERO) == 0) {
                return false;
            }
            if (moleMul.multiply(demoMulNew).compareTo(demoMul.multiply(moleMulNew)) == 0) continue;
            return false;
        }
        return true;
    }

    public static Map<String, BigDecimal> calRepRes(DynamicObject dymList, DynamicObject dym, DynamicObject stockEntry, Map<String, Boolean> repConfigSet) {
        BigDecimal sn2 = dymList.getBigDecimal("repmole");
        BigDecimal sd2 = dymList.getBigDecimal("repdeno");
        HashMap<String, BigDecimal> res = new HashMap<String, BigDecimal>(2);
        if (repConfigSet.get("isCalculate").booleanValue()) {
            BigDecimal n2 = dym.getBigDecimal("mole");
            BigDecimal d2 = dym.getBigDecimal("deno");
            BigDecimal n1 = stockEntry.getBigDecimal("qtynumerator");
            BigDecimal d1 = stockEntry.getBigDecimal("qtydenominator");
            DynamicObject unit = dymList.getDynamicObject("repunit");
            int precision = MPDMMftGenStocksUtils.getPrecision(unit);
            int roundType = MPDMMftGenStocksUtils.getRoundType(unit);
            BigDecimal mole = sn2.multiply(n1).multiply(d2);
            BigDecimal deno = sd2.multiply(d1).multiply(n2);
            if (deno.compareTo(BigDecimal.ZERO) == 0) {
                deno = BigDecimal.ONE;
            }
            if (repConfigSet.get("isReduction").booleanValue()) {
                return StockCulUtils.getGCDRes(mole, deno, precision, roundType);
            }
            res.put("mole", mole);
            res.put("deno", deno);
            return res;
        }
        res.put("mole", sn2);
        res.put("deno", sd2);
        return res;
    }

    private static Map<String, BigDecimal> getGCDRes(BigDecimal mole, BigDecimal deno, int precision, int roundType) {
        HashMap<String, BigDecimal> res = new HashMap<String, BigDecimal>(2);
        for (int i = 0; !(i >= 12 || StockCulUtils.compareNumber(mole) && StockCulUtils.compareNumber(deno)); ++i) {
            mole = mole.multiply(BigDecimal.TEN);
            deno = deno.multiply(BigDecimal.TEN);
        }
        int get_gcd = StockCulUtils.get_gcd(mole.intValue(), deno.intValue());
        BigDecimal gcd = new BigDecimal(get_gcd);
        mole = mole.divide(gcd, precision, roundType);
        deno = deno.divide(gcd, precision, roundType);
        res.put("mole", mole);
        res.put("deno", deno);
        return res;
    }

    public static boolean compareNumber(BigDecimal number) {
        BigDecimal b = number.setScale(0, 1);
        return number.subtract(b).compareTo(BigDecimal.ZERO) == 0;
    }

    public static BigDecimal completeDivide(BigDecimal dividend, BigDecimal divisor) {
        BigDecimal res = BigDecimal.ZERO;
        try {
            res = dividend.divide(divisor);
        }
        catch (ArithmeticException exception) {
            res = BigDecimal.ZERO;
        }
        return res;
    }

    private static int get_gcd(int a, int b) {
        if (a < 0 || b < 0) {
            return 1;
        }
        if (b == 0) {
            if (a == 0) {
                return 1;
            }
            return a;
        }
        while (a % b != 0) {
            int temp = a % b;
            a = b;
            b = temp;
        }
        return b;
    }
}

