/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.mftorder.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class StockOpUtils {
    private static Map<String, Boolean> orderToStockReflex = new HashMap<String, Boolean>(16);

    public static Boolean isCallOrderToStock(String stockName) {
        if (!orderToStockReflex.containsKey(stockName)) {
            orderToStockReflex.put(stockName, Boolean.FALSE);
            Map operateInfos = EntityMetadataCache.getDataEntityOperate((String)stockName, (String)"ordertostock");
            Object plugins = operateInfos.get("plugins");
            if (plugins instanceof List) {
                List pluginList = (List)plugins;
                for (Map pluginInfos : pluginList) {
                    if (null == pluginInfos.get("enabled") || !((Boolean)pluginInfos.get("enabled")).booleanValue()) continue;
                    orderToStockReflex.put(stockName, Boolean.TRUE);
                    break;
                }
            }
        }
        return orderToStockReflex.get(stockName);
    }

    public static void addStockIdToSet(Set<Long> stockIdSet, OperationResult saveOperate) {
        stockIdSet.addAll(saveOperate.getSuccessPkIds().stream().map(x -> (Long)x).collect(Collectors.toSet()));
    }

    public static void callOrderToStock(String stockname, List<DynamicObject> updatedataEntities, Set<Long> stockIdSet) {
        try {
            Set entityToSave = updatedataEntities.stream().filter(x -> "A".equals(x.getString("billstatus"))).collect(Collectors.toSet());
            Object[] stockIds = entityToSave.stream().map(x -> x.getPkValue()).collect(Collectors.toSet()).toArray();
            OperationServiceHelper.executeOperate((String)"save", (String)stockname, (Object[])stockIds, (OperateOption)OperateOption.create());
            if (StockOpUtils.isCallOrderToStock(stockname).booleanValue()) {
                stockIdSet.addAll(updatedataEntities.stream().map(x -> x.getLong("id")).collect(Collectors.toSet()));
                OperationServiceHelper.executeOperate((String)"ordertostock", (String)stockname, (Object[])stockIdSet.toArray(), (OperateOption)OperateOption.create());
            }
        }
        catch (Exception e) {
            String stockLocalValue = MetadataServiceHelper.getDataEntityType((String)stockname).getDisplayName().getLocaleValue();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5904\u7406\u5f02\u5e38\u3002", (String)"StockOpUtils_0", (String)"bd-mpdm-common", (Object[])new Object[0]), stockLocalValue));
        }
    }
}

