/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.mftorder.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class StockRefreshInvQtyUtils {
    private static final Log logger = LogFactory.getLog(StockRefreshInvQtyUtils.class);
    private static String[] keyStrQuery = new String[]{"org", "warehouse", "location", "material", "auxpty", "baseunit", "ownertype", "owner", "configuredcode", "tracknumber"};

    public static String[] getKeyStrs() {
        return new String[]{"org", "warehouse", "location", "material", "lotnum", "auxpty", "baseunit", "ownertype", "owner", "configuredcode", "tracknumber"};
    }

    private StockRefreshInvQtyUtils() {
    }

    public static Map<Object, String> getKeyEntryIdMap(JSONArray filterArray, Map<String, BigDecimal> avbBaseQtyMap, Map<String, BigDecimal> reserveBaseQtyMap) {
        HashMap<Object, String> keyEntryIdMap = new HashMap<Object, String>(16);
        for (int i = 0; i < filterArray.size(); ++i) {
            JSONObject resJson = (JSONObject)filterArray.get(i);
            String keyStr = StockRefreshInvQtyUtils.getKeyStr(resJson);
            keyEntryIdMap.put(resJson.get((Object)"entryid"), keyStr);
            avbBaseQtyMap.put(keyStr, BigDecimal.ZERO);
            reserveBaseQtyMap.put(keyStr, BigDecimal.ZERO);
        }
        return keyEntryIdMap;
    }

    private static String getKeyStr(JSONObject resJson) {
        StringBuilder sb = new StringBuilder();
        for (String str : StockRefreshInvQtyUtils.getKeyStrs()) {
            sb.append(resJson.get((Object)str));
            sb.append(",");
        }
        return sb.toString();
    }

    private static String[] getBatchKeyStr(JSONObject resJson) {
        String[] strs = new String[2];
        strs[0] = StockRefreshInvQtyUtils.getKeyStr(resJson);
        StringBuilder sb = new StringBuilder();
        for (String str : StockRefreshInvQtyUtils.getKeyStrs()) {
            if (str.equals("lotnum")) {
                sb.append("");
                sb.append(",");
                continue;
            }
            sb.append(resJson.get((Object)str));
            sb.append(",");
        }
        strs[1] = sb.toString();
        return strs;
    }

    public static Object getStockEntryJSONObject(DynamicObject stockentry, DynamicObject obj) {
        JSONObject jo = new JSONObject();
        jo.put("org", stockentry.getDynamicObject("supplyorgid") == null ? Integer.valueOf(0) : stockentry.getDynamicObject("supplyorgid").getPkValue());
        jo.put("warehouse", stockentry.getDynamicObject("warehouseid") == null ? Integer.valueOf(0) : stockentry.getDynamicObject("warehouseid").getPkValue());
        jo.put("location", stockentry.getDynamicObject("location") == null ? Integer.valueOf(0) : stockentry.getDynamicObject("location").getPkValue());
        jo.put("material", stockentry.getDynamicObject("materielmasterid") == null ? Integer.valueOf(0) : stockentry.getDynamicObject("materielmasterid").getPkValue());
        jo.put("lotnum", stockentry.get("batchno"));
        jo.put("auxpty", stockentry.getDynamicObject("childauxpropertyid") == null ? Integer.valueOf(0) : stockentry.getDynamicObject("childauxpropertyid").getPkValue());
        jo.put("baseunit", stockentry.getDynamicObject("materialunitid") == null ? Integer.valueOf(0) : stockentry.getDynamicObject("materialunitid").getPkValue());
        jo.put("ownertype", stockentry.get("supplymode"));
        jo.put("owner", stockentry.getDynamicObject("supplierid") == null ? Integer.valueOf(0) : stockentry.getDynamicObject("supplierid").getPkValue());
        jo.put("configuredcode", stockentry.getDynamicObject("entryconfiguredcode") == null ? Integer.valueOf(0) : stockentry.getDynamicObject("entryconfiguredcode").getPkValue());
        jo.put("tracknumber", obj.getDynamicObject("tracknumber") == null ? Integer.valueOf(0) : obj.getDynamicObject("tracknumber").getPkValue());
        jo.put("entryid", stockentry.getPkValue());
        jo.put("avbbaseqty", (Object)0);
        jo.put("reservebaseqty", (Object)0);
        return jo;
    }

    public static void getKeyQtyMap(JSONArray filterArray, Map<String, BigDecimal> avbBaseQtyMap, Map<String, BigDecimal> reserveBaseQtyMap) {
        HashMap filterMap = new HashMap(16);
        for (String keyStr : keyStrQuery) {
            filterMap.put(keyStr, new HashSet(16));
        }
        for (int i = 0; i < filterArray.size(); ++i) {
            JSONObject resJson = (JSONObject)filterArray.get(i);
            for (String keyStr : keyStrQuery) {
                Set set = (Set)filterMap.get(keyStr);
                set.add(resJson.get((Object)keyStr));
            }
        }
        LinkedHashMap params = new LinkedHashMap(16);
        for (String baseStr : keyStrQuery) {
            params.put(baseStr, filterMap.get(baseStr));
        }
        logger.info("\u7ec4\u4ef6\u6e05\u5355\u5e93\u5b58\u67e5\u8be2\u5f00\u59cb:");
        String res = (String)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"MpsReserveService", (String)"getInventoryAvbQty", (Object[])new Object[]{"im_inv_realbalance", params});
        logger.info("\u7ec4\u4ef6\u6e05\u5355\u5e93\u5b58\u67e5\u8be2\u7ed3\u675f:" + res);
        JSONObject resJson = (JSONObject)JSONObject.parse((String)res);
        if (resJson != null && "true".equals(resJson.get((Object)"success").toString())) {
            JSONArray cols = (JSONArray)resJson.get((Object)"col");
            for (int i = 0; i < cols.size(); ++i) {
                JSONObject col = (JSONObject)cols.get(i);
                String[] keyStrs = StockRefreshInvQtyUtils.getBatchKeyStr(col);
                StockRefreshInvQtyUtils.setBaseQty(avbBaseQtyMap, keyStrs[0], col, reserveBaseQtyMap);
                if (keyStrs[0].equals(keyStrs[1])) continue;
                StockRefreshInvQtyUtils.setBaseQty(avbBaseQtyMap, keyStrs[1], col, reserveBaseQtyMap);
            }
        } else {
            logger.info("\u7ec4\u4ef6\u6e05\u5355\u5e93\u5b58\u67e5\u8be2\u5931\u8d25:" + resJson);
        }
    }

    private static void setBaseQty(Map<String, BigDecimal> avbBaseQtyMap, String keyStr, JSONObject col, Map<String, BigDecimal> reserveBaseQtyMap) {
        BigDecimal reserveBaseQty;
        BigDecimal avbBaseQty = avbBaseQtyMap.get(keyStr);
        if (avbBaseQty != null) {
            avbBaseQtyMap.put(keyStr, avbBaseQty.add(new BigDecimal(col.get((Object)"baseqty").toString())));
        }
        if ((reserveBaseQty = reserveBaseQtyMap.get(keyStr)) != null) {
            reserveBaseQtyMap.put(keyStr, reserveBaseQty.add(new BigDecimal(col.get((Object)"lockbaseqty").toString())));
        }
    }

    public static void getEntryIdQtyMap(Map<Object, String> keyEntryIdMap, Map<String, BigDecimal> avbBaseQtyMap, Map<String, BigDecimal> reserveBaseQtyMap, Map<Object, BigDecimal> avbBaseQtyEntryIdMap, Map<Object, BigDecimal> reserveBaseQtyEntryIdMap) {
        for (Map.Entry<Object, String> m : keyEntryIdMap.entrySet()) {
            Object key = m.getKey();
            avbBaseQtyEntryIdMap.put(key, avbBaseQtyMap.get(m.getValue()));
            reserveBaseQtyEntryIdMap.put(key, reserveBaseQtyMap.get(m.getValue()));
        }
    }
}

