/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.mftorderbom.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.CreateStockByBomUtils;
import kd.bd.mpdm.common.mftorder.utils.CreateStockUtils;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.mftorder.utils.OrderBaseData;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;

public class CreateStockCardUtils {
    private static final Log logger = LogFactory.getLog(CreateStockCardUtils.class);

    private CreateStockCardUtils() {
    }

    public static void expandGKStocks(List<DynamicObject> saveGKStocks, OrderBaseData baseData, String stockname) {
        HashSet<Long> workCardIdSet = new HashSet<Long>(16);
        Long orgId = 0L;
        for (DynamicObject saveGKStock : saveGKStocks) {
            DynamicObject workcard;
            DynamicObject mtfOrg = saveGKStock.getDynamicObject("org");
            if (mtfOrg != null) {
                if (orgId != 0L && !orgId.equals((Long)mtfOrg.getPkValue())) {
                    throw new KDBizException(new ErrorCode("CardAutoGenerateStock", ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u4e2a\u7ec4\u7ec7\u540c\u65f6\u66f4\u65b0\u7ec4\u4ef6\u6e05\u5355\u3002", (String)"CreateStockCardUtils_0", (String)"bd-mpdm-common", (Object[])new Object[0])), new Object[0]);
                }
                orgId = (Long)mtfOrg.getPkValue();
            }
            if ((workcard = saveGKStock.getDynamicObject("workcard")) == null) continue;
            workCardIdSet.add((Long)workcard.getPkValue());
        }
        logger.info("\u5de5\u5361id\u96c6\u5408\u957f\u5ea6" + workCardIdSet.size());
        if (!workCardIdSet.isEmpty()) {
            QFilter filter = new QFilter("workcard", "in", workCardIdSet);
            filter.and(new QFilter("status", "=", (Object)"C"));
            filter.and(new QFilter("enable", "=", (Object)"1"));
            QFilter planFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_cardmatcommand", (Long)orgId);
            Map loads = BusinessDataServiceHelper.loadFromCache((String)"mpdm_cardmatcommand", (String)"workcard,number", (QFilter[])new QFilter[]{planFilter, filter});
            logger.info("\u67e5\u8be2\u7684\u5de5\u5361\u7269\u6599\u6e05\u5355\u957f\u5ea6" + loads.size());
            HashMap<Long, Long> workCardCommandMap = new HashMap<Long, Long>(16);
            for (Map.Entry m : loads.entrySet()) {
                DynamicObject value = (DynamicObject)m.getValue();
                DynamicObject wcard = value.getDynamicObject("workcard");
                workCardCommandMap.put((Long)wcard.getPkValue(), (Long)value.getPkValue());
            }
            Map<Long, DynamicObject> botpStockMap = CreateStockCardUtils.getBotpStockMap(stockname, loads);
            logger.info("\u5de5\u5361\u4e0b\u63a8\u7684\u7ec4\u4ef6\u6e05\u5355\u957f\u5ea6" + botpStockMap.size());
            for (DynamicObject saveGKStock : saveGKStocks) {
                Long cardComId;
                DynamicObject botpStock;
                DynamicObject workcard = saveGKStock.getDynamicObject("workcard");
                if (workcard == null || (botpStock = botpStockMap.get(cardComId = (Long)workCardCommandMap.get((Long)workcard.getPkValue()))) == null) continue;
                DynamicObjectCollection saveEntry = saveGKStock.getDynamicObjectCollection("stockentry");
                DynamicObjectCollection botpEntry = botpStock.getDynamicObjectCollection("stockentry");
                if (botpEntry != null) {
                    DynamicObject botpStockNew = (DynamicObject)OrmUtils.clone((IDataEntityBase)botpStock, (boolean)false, (boolean)true);
                    saveEntry.addAll((Collection)botpStockNew.getDynamicObjectCollection("stockentry"));
                }
                saveGKStock.set("stockentry", (Object)saveEntry);
                saveGKStock.set("sourcebillid", botpStock.get("sourcebillid"));
            }
            CreateStockCardUtils.setGKStockBaseData(baseData, saveGKStocks);
            for (DynamicObject saveGKStock : saveGKStocks) {
                Long orderEntryId = CreateStockByBomUtils.getOrderEntryIdByStock(saveGKStock);
                DynamicObject orderEntry = baseData.getOrderEntry(orderEntryId);
                Object planbegintime = orderEntry.get("planbegintime");
                DynamicObject mtfOrg = saveGKStock.getDynamicObject("org");
                orgId = (Long)mtfOrg.getPkValue();
                DynamicObjectCollection stockEntrys = saveGKStock.getDynamicObjectCollection("stockentry");
                if (!CreateStockUtils.checkMterialErr(baseData, stockEntrys, orgId, saveGKStock)) continue;
                logger.info("\u8bbe\u7f6e\u5de5\u5361\u7269\u6599\u9700\u6c42\u5c55\u5f00\u7684\u7ec4\u4ef6\u6e05\u5355\u6570\u91cf");
                CreateStockCardUtils.setGKQty(saveGKStock, stockEntrys, baseData, planbegintime);
                for (DynamicObject stockEntry : stockEntrys) {
                    stockEntry.set("sourcetype", (Object)"B");
                }
            }
        }
    }

    private static void setGKQty(DynamicObject saveGKStock, DynamicObjectCollection stockEntrys, OrderBaseData baseData, Object planbegintime) {
        for (DynamicObject stockEntry : stockEntrys) {
            if ("bos_org".equals(stockEntry.get("supplymode"))) {
                logger.info("\u8bbe\u7f6e\u5de5\u5361\u7269\u6599\u9700\u6c42\u5c55\u5f00\u7684\u7ec4\u4ef6\u6e05\u5355\u4e1a\u52a1\u5355\u5143" + stockEntry.get("supplymode"));
                DynamicObject orgfield = (DynamicObject)stockEntry.get("supplyorgid");
                if (orgfield != null) {
                    Long orgfieldId = (Long)orgfield.getPkValue();
                    stockEntry.set("supplierid", CreateStockByBomUtils.getSupplyByBaseData(baseData, orgfieldId));
                    logger.info("\u8bbe\u7f6e\u5de5\u5361\u7269\u6599\u9700\u6c42\u5c55\u5f00\u7684\u7ec4\u4ef6\u6e05\u5355\u8d27\u4e3b" + CreateStockByBomUtils.getSupplyByBaseData(baseData, orgfieldId));
                }
            }
            stockEntry.set("demanddate", planbegintime);
            DynamicObject entryunit = stockEntry.getDynamicObject("materialunitid");
            int precision = MPDMMftGenStocksUtils.getPrecision(entryunit);
            String qtyType = stockEntry.getString("qtytype");
            BigDecimal useratio = stockEntry.getBigDecimal("useratio").divide(BigDecimal.valueOf(100L), 4, 4);
            BigDecimal qtynumerator = stockEntry.getBigDecimal("qtynumerator");
            BigDecimal qtydenominator = stockEntry.getBigDecimal("qtydenominator");
            BigDecimal baseqty = saveGKStock.getBigDecimal("baseqty");
            BigDecimal standqty = MPDMMftGenStocksUtils.calculateStandQty(entryunit, qtyType, useratio, baseqty, qtynumerator, qtydenominator);
            BigDecimal scraprate = stockEntry.getBigDecimal("scraprate");
            BigDecimal fixscrap = stockEntry.getBigDecimal("fixscrap");
            BigDecimal demandQty = MPDMMftGenStocksUtils.calculateDemadQty(precision, false, standqty, scraprate, fixscrap, "");
            stockEntry.set("standqty", (Object)standqty);
            stockEntry.set("demandqty", (Object)demandQty);
            String over = stockEntry.getString("overissuecontrl");
            if ("B".equals(over)) {
                stockEntry.set("extraratioqty", (Object)stockEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.add(stockEntry.getBigDecimal("issinhighlimit").divide(BigDecimal.valueOf(100L), 4, 4))));
                stockEntry.set("lackraitioqty", (Object)stockEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.subtract(stockEntry.getBigDecimal("issinlowlimit").divide(BigDecimal.valueOf(100L), 4, 4))));
            } else {
                stockEntry.set("extraratioqty", stockEntry.get("demandqty"));
                stockEntry.set("lackraitioqty", stockEntry.get("demandqty"));
            }
            stockEntry.set("cansendqty", MPDMMftGenStocksUtils.aculCanSendQty(stockEntry));
            stockEntry.set("unissueqty", MPDMMftGenStocksUtils.aculUnSendQty(stockEntry));
        }
    }

    private static void setGKStockBaseData(OrderBaseData baseData, List<DynamicObject> saveGKStocks) {
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        HashMap<Long, Set<Long>> orgMasterMap = new HashMap<Long, Set<Long>>(16);
        HashSet<Long> supplyOrgIdSet = new HashSet<Long>(16);
        for (DynamicObject saveGKStock : saveGKStocks) {
            DynamicObject org = saveGKStock.getDynamicObject("org");
            Long orgId = (Long)org.getPkValue();
            orgIdSet.add(orgId);
            HashSet<Long> masterSet = (HashSet<Long>)orgMasterMap.get(orgId);
            if (masterSet == null) {
                masterSet = new HashSet<Long>(16);
            }
            for (DynamicObject stockEntry : saveGKStock.getDynamicObjectCollection("stockentry")) {
                masterSet.add((Long)stockEntry.getDynamicObject("materielmasterid").getPkValue());
            }
            orgMasterMap.put(orgId, masterSet);
        }
        HashMap<Long, Object> orgMasterWastMap = new HashMap<Long, Object>(orgIdSet.size());
        HashMap<Long, Object> orgMaterialMftInfoMap = new HashMap<Long, Object>(orgIdSet.size());
        for (Long orgId : orgIdSet) {
            CreateStockUtils.getInfoByMaster(orgId, orgMasterWastMap, orgMaterialMftInfoMap, orgMasterMap, supplyOrgIdSet);
        }
        HashMap<Long, Object> supplyMap = new HashMap<Long, Object>(16);
        CreateStockUtils.getSupplyMap(supplyMap, supplyOrgIdSet);
        baseData.setOrgMasterWastMap(orgMasterWastMap);
        baseData.setOrgMaterialMftInfoMap(orgMaterialMftInfoMap);
        baseData.setSupplyMap(supplyMap);
    }

    private static Map<Long, DynamicObject> getBotpStockMap(String stockname, Map<Object, DynamicObject> loads) {
        if (loads.isEmpty()) {
            return new HashMap<Long, DynamicObject>(16);
        }
        HashMap<Long, DynamicObject> botpStockMap = new HashMap<Long, DynamicObject>(16);
        PushArgs pushArgs = new PushArgs();
        pushArgs.setTargetEntityNumber(stockname);
        pushArgs.setHasRight(true);
        pushArgs.setRuleId("1392938988158872576");
        pushArgs.setBuildConvReport(true);
        pushArgs.setSourceEntityNumber("mpdm_cardmatcommand");
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(16);
        for (Map.Entry<Object, DynamicObject> m : loads.entrySet()) {
            ListSelectedRow srcBill = new ListSelectedRow(m.getKey());
            needPushRows.add(srcBill);
        }
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)stockname);
        if (!pushResult.isSuccess()) {
            logger.info(MPDMMftGenStocksUtils.getErrByRes(pushResult));
            throw new KDBizException(new ErrorCode("StockAutoGenerateStock", MPDMMftGenStocksUtils.getErrByRes(pushResult)), new Object[0]);
        }
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        for (DynamicObject targetBillObj : targetBillObjs) {
            DynamicObjectCollection stockEntrys = targetBillObj.getDynamicObjectCollection("stockentry");
            ArrayList<DynamicObject> delEntrys = new ArrayList<DynamicObject>(16);
            for (DynamicObject stockEntry : stockEntrys) {
                if (!"M".equals(stockEntry.get("issuemode")) && !stockEntry.getBoolean("isstep")) continue;
                delEntrys.add(stockEntry);
            }
            for (DynamicObject delEntry : delEntrys) {
                stockEntrys.remove((Object)delEntry);
            }
            botpStockMap.put(targetBillObj.getLong("sourcebillid"), targetBillObj);
        }
        return botpStockMap;
    }
}

