/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.mftorderbom.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.CreateStockByBomUtils;
import kd.bd.mpdm.common.mftorder.utils.CreateStockUtils;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.mftorder.utils.OrderBaseData;
import kd.bd.mpdm.common.query.helper.WorkcenterQueryHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;

public class InnerProStocksUtils {
    public static void expandGKStocks(List<DynamicObject> saveInnerProStocks, OrderBaseData baseData, String stockname) {
        Long orgId = 0L;
        DynamicObject mtfOrg = null;
        HashSet<Long> oprEntryIds = new HashSet<Long>(16);
        HashSet<Long> srcOrderEntryIds = new HashSet<Long>(16);
        HashSet<Long> billtypeIds = new HashSet<Long>(16);
        for (DynamicObject stock : saveInnerProStocks) {
            Object billtype = stock.get("billtype");
            if (billtype instanceof Long) {
                billtypeIds.add((Long)billtype);
            }
            DynamicObjectCollection linkRows = stock.getDynamicObjectCollection("billhead_lk");
            linkRows.clear();
            if (linkRows.isEmpty()) {
                DynamicObject linkRow = linkRows.addNew();
                String orderName = "pom_mftorder";
                TableDefine srcTableDefine = EntityMetadataCache.loadTableDefine((String)orderName, (String)orderName);
                linkRow.set("billhead_lk_stableid", (Object)srcTableDefine.getTableId());
                linkRow.set("billhead_lk_sbillid", stock.get("orderid"));
                linkRow.set("billhead_lk_sid", stock.get("orderid"));
            }
            if ((mtfOrg = stock.getDynamicObject("org")) != null) {
                if (orgId != 0L && !orgId.equals((Long)mtfOrg.getPkValue())) {
                    throw new KDBizException(new ErrorCode("CardAutoGenerateStock", ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u4e2a\u7ec4\u7ec7\u540c\u65f6\u66f4\u65b0\u7ec4\u4ef6\u6e05\u5355\u3002", (String)"InnerProStocksUtils_0", (String)"bd-mpdm-common", (Object[])new Object[0])), new Object[0]);
                }
                orgId = (Long)mtfOrg.getPkValue();
            }
            long orderEntryId = InnerProStocksUtils.getOrderEntryId(stock);
            DynamicObject orderEntry = baseData.getOrderEntry(orderEntryId);
            long oprEntryId = orderEntry.getLong("oprentryid");
            oprEntryIds.add(oprEntryId);
            long srcOrderEntryId = orderEntry.getLong("srcorderentryid");
            srcOrderEntryIds.add(srcOrderEntryId);
        }
        Map<Long, DynamicObject> srcOrderEntryId_oldStockObj = InnerProStocksUtils.getOldStockMap(srcOrderEntryIds);
        Map<Long, Map<String, String>> oprentryid_dataMap = InnerProStocksUtils.getOprEntryDataMap(oprEntryIds, "sfc_manftech");
        QFilter[] billTypeQf = new QFilter[]{new QFilter("id", "in", billtypeIds)};
        Map billtypeid_ObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_billtype", (QFilter[])billTypeQf);
        HashSet<Map<String, Object>> stockMapSet = new HashSet<Map<String, Object>>(16);
        HashMap<Long, List> srcStockId_innerOrderEntryId = new HashMap<Long, List>(16);
        for (DynamicObject stock : saveInnerProStocks) {
            DynamicObjectCollection stockEntryColl;
            long srcOrderEntryId;
            DynamicObject oldStock;
            Object billtype = stock.get("billtype");
            if (billtype instanceof Long) {
                stock.set("billtype", billtypeid_ObjMap.get(billtype));
            }
            long orderEntryId = InnerProStocksUtils.getOrderEntryId(stock);
            DynamicObject orderEntry = baseData.getOrderEntry(orderEntryId);
            long oprEntryId = orderEntry.getLong("oprentryid");
            Map<String, String> dataMap = oprentryid_dataMap.get(oprEntryId);
            String oprKey = "_oprentryid";
            if (dataMap != null) {
                String oprno = dataMap.get("oprno");
                String processseq = dataMap.get("processseq");
                oprKey = oprno + "_" + processseq;
            }
            if ((oldStock = srcOrderEntryId_oldStockObj.get(srcOrderEntryId = orderEntry.getLong("srcorderentryid"))) == null || (stockEntryColl = oldStock.getDynamicObjectCollection("stockentry")) == null) continue;
            for (DynamicObject oldStockEntry : stockEntryColl) {
                String oprno = oldStockEntry.getString("oprno");
                String processseq = oldStockEntry.getString("processseq");
                String keyStr = oprno + "_" + processseq;
                if (!oprKey.equals(keyStr)) continue;
                HashMap<String, Object> stockDataMap = new HashMap<String, Object>(2);
                stockDataMap.put("stockid", oldStock.getPkValue());
                stockDataMap.put("stockentryid", oldStockEntry.getPkValue());
                stockMapSet.add(stockDataMap);
                List orderEntryIds = srcStockId_innerOrderEntryId.computeIfAbsent(oldStock.getLong("id"), e -> new ArrayList());
                orderEntryIds.add(orderEntryId);
            }
        }
        if (!stockMapSet.isEmpty()) {
            Map<Long, List<DynamicObject>> oldStockId_newStockObjMap = InnerProStocksUtils.getBotpStockMap(stockMapSet, "pom_mftstock");
            for (Map.Entry<Long, List<DynamicObject>> entry : oldStockId_newStockObjMap.entrySet()) {
                Long srcStockId = entry.getKey();
                List<DynamicObject> innerStocks = entry.getValue();
                List innerOrderEntryIds = (List)srcStockId_innerOrderEntryId.get(srcStockId);
                block14: for (Long innerOrderEntryId : innerOrderEntryIds) {
                    for (DynamicObject stock : saveInnerProStocks) {
                        Object masterid;
                        DynamicObject oldMaterial;
                        long orderEntryId = InnerProStocksUtils.getOrderEntryId(stock);
                        if (!innerOrderEntryId.equals(orderEntryId)) continue;
                        DynamicObject innerorderEntry = baseData.getOrderEntry(innerOrderEntryId);
                        long oprEntryId = innerorderEntry.getLong("oprentryid");
                        Map<String, String> dataMap = oprentryid_dataMap.get(oprEntryId);
                        String oprKey = "_oprentryid";
                        if (dataMap != null) {
                            String oprno = dataMap.get("oprno");
                            String processseq = dataMap.get("processseq");
                            oprKey = oprno + "_" + (String)processseq;
                        }
                        DynamicObject innerStock = null;
                        block16: for (DynamicObject innerStock_1 : innerStocks) {
                            DynamicObjectCollection stockEntryColl = innerStock_1.getDynamicObjectCollection("stockentry");
                            if (stockEntryColl == null) continue;
                            for (DynamicObject oldStockEntry : stockEntryColl) {
                                String oprno = oldStockEntry.getString("oprno");
                                String processseq = oldStockEntry.getString("processseq");
                                String keyStr = oprno + "_" + processseq;
                                if (!oprKey.equals(keyStr)) continue;
                                innerStock = innerStock_1;
                                continue block16;
                            }
                        }
                        if (innerStock == null) continue;
                        DynamicObject transactproduct = stock.getDynamicObject("transactiontypeid");
                        boolean isconsiderloss = false;
                        if (transactproduct != null) {
                            isconsiderloss = transactproduct.getBoolean("isconsiderloss");
                        }
                        DynamicObject orderEntry = baseData.getOrderEntry(orderEntryId);
                        DynamicObjectCollection oldStockEntryColl = stock.getDynamicObjectCollection("stockentry");
                        oldStockEntryColl.clear();
                        DynamicObjectCollection innerStockEntryColl = innerStock.getDynamicObjectCollection("stockentry");
                        HashMap<Long, Object> orgMaterialMftInfoMap = new HashMap<Long, Object>(16);
                        HashMap<Long, Object> orgMasterWastMap = new HashMap<Long, Object>(16);
                        HashMap<Long, Set<Long>> orgMasterMap = new HashMap<Long, Set<Long>>(16);
                        HashSet<Long> supplyOrgIdSet = new HashSet<Long>(16);
                        HashSet<Long> masterSet = new HashSet<Long>(16);
                        orgMasterMap.put(orgId, masterSet);
                        for (DynamicObject stockEntry : innerStockEntryColl) {
                            oldMaterial = stockEntry.getDynamicObject("materialid");
                            masterid = oldMaterial.getDynamicObject("masterid").getPkValue();
                            masterSet.add((Long)masterid);
                        }
                        CreateStockUtils.getInfoByMaster(orgId, orgMasterWastMap, orgMaterialMftInfoMap, orgMasterMap, supplyOrgIdSet);
                        for (DynamicObject stockEntry : innerStockEntryColl) {
                            oldMaterial = stockEntry.getDynamicObject("materialid");
                            masterid = oldMaterial.getDynamicObject("masterid").getPkValue();
                            Object materialMftInfoMapo = orgMaterialMftInfoMap.get(orgId);
                            if (materialMftInfoMapo instanceof Map) {
                                Map materialMftInfoMapoMap = (Map)materialMftInfoMapo;
                                Object newMftMaterialInfoObj = materialMftInfoMapoMap.get(masterid);
                                if (newMftMaterialInfoObj instanceof DynamicObject) {
                                    String issuemode;
                                    DynamicObject newMftMaterialInfo = (DynamicObject)newMftMaterialInfoObj;
                                    stockEntry.set("materialid", (Object)newMftMaterialInfo);
                                    DynamicObject supply = newMftMaterialInfo.getDynamicObject("supplyorgunitid");
                                    stockEntry.set("supplyorgid", (Object)supply);
                                    stockEntry.set("warehouseid", newMftMaterialInfo.get("warehouse"));
                                    stockEntry.set("location", newMftMaterialInfo.get("location"));
                                    InnerProStocksUtils.setStockEntryWarehouse(mtfOrg, stockEntry, orderEntry, baseData);
                                    stockEntry.set("isstockallot", newMftMaterialInfo.get("isstockallot"));
                                    stockEntry.set("outorgunitid", newMftMaterialInfo.get("outstorageunit"));
                                    stockEntry.set("outwarehouseid", newMftMaterialInfo.get("outwarehouse"));
                                    stockEntry.set("outlocation", newMftMaterialInfo.get("outwarelocation"));
                                    switch (issuemode = newMftMaterialInfo.getString("issuemode")) {
                                        case "11010": {
                                            stockEntry.set("issuemode", (Object)"A");
                                            break;
                                        }
                                        case "11050": {
                                            stockEntry.set("issuemode", (Object)"B");
                                            break;
                                        }
                                        case "11040": {
                                            stockEntry.set("issuemode", (Object)"C");
                                            break;
                                        }
                                    }
                                    stockEntry.set("isbulkmaterial", newMftMaterialInfo.get("isbulkmaterial"));
                                    String isbackflush = newMftMaterialInfo.getString("isbackflush");
                                    stockEntry.set("isbackflush", (Object)isbackflush);
                                    stockEntry.set("backflushtime", null);
                                    if ("B".equals(isbackflush)) {
                                        stockEntry.set("backflushtime", transactproduct.get("backflushtime"));
                                    }
                                    stockEntry.set("iskeypart", newMftMaterialInfo.get("iskeypart"));
                                    Date planbegintime = orderEntry.getDate("planbegintime");
                                    Date planendtime = orderEntry.getDate("planendtime");
                                    stockEntry.set("demanddate", CreateStockByBomUtils.getDemandDate(null, planbegintime, stockEntry, planendtime));
                                    boolean isprocedure = transactproduct.getBoolean("isprocedure");
                                    if (!isprocedure) {
                                        stockEntry.set("processseq", (Object)"1");
                                        stockEntry.set("oprno", (Object)"10");
                                        stockEntry.set("machiningtype", null);
                                        stockEntry.set("workprocedureid", null);
                                        stockEntry.set("operationdesc", null);
                                        stockEntry.set("oprworkcenter", null);
                                        stockEntry.set("outsupplier", null);
                                        stockEntry.set("workstation", null);
                                    }
                                    DynamicObject unit = stockEntry.getDynamicObject("materialunitid");
                                    String qtyType = stockEntry.getString("qtytype");
                                    BigDecimal useratio = stockEntry.getBigDecimal("useratio").divide(new BigDecimal("100"), 4, 4);
                                    BigDecimal orderQty = orderEntry.getBigDecimal("baseqty");
                                    BigDecimal qtynumerator = stockEntry.getBigDecimal("qtynumerator");
                                    BigDecimal qtydenominator = stockEntry.getBigDecimal("qtydenominator");
                                    stockEntry.set("standqty", (Object)MPDMMftGenStocksUtils.calculateStandQty(unit, qtyType, useratio, orderQty, qtynumerator, qtydenominator));
                                    int precision = unit.get("precision") == null ? 2 : unit.getInt("precision");
                                    BigDecimal standqty = stockEntry.getBigDecimal("standqty");
                                    BigDecimal scraprate = stockEntry.getBigDecimal("scraprate");
                                    BigDecimal fixscrap = stockEntry.getBigDecimal("fixscrap");
                                    String wastagerateformula = "B";
                                    DynamicObject material = stockEntry.getDynamicObject("materialid");
                                    String orgMasterWast = baseData.getOrgMasterWast(orgId, material.getDynamicObject("masterid").getLong("id"));
                                    if (orgMasterWast != null) {
                                        wastagerateformula = orgMasterWast;
                                    } else if (!isconsiderloss) {
                                        wastagerateformula = "";
                                    }
                                    stockEntry.set("demandqty", (Object)MPDMMftGenStocksUtils.calculateDemadQty(precision, isconsiderloss, standqty, scraprate, fixscrap, wastagerateformula));
                                    stockEntry.set("sourcetype", (Object)"B");
                                    Boolean isquotacontrol = newMftMaterialInfo.getBoolean("isquotacontrol");
                                    if (isquotacontrol.booleanValue()) {
                                        stockEntry.set("overissuecontrl", (Object)"B");
                                        stockEntry.set("issinhighlimit", newMftMaterialInfo.get("issinhighlimit"));
                                        stockEntry.set("extraratioqty", (Object)stockEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.add(newMftMaterialInfo.getBigDecimal("issinhighlimit").divide(BigDecimal.valueOf(100L), 4, 4))));
                                        stockEntry.set("issinlowlimit", newMftMaterialInfo.get("issinlowlimit"));
                                        stockEntry.set("lackraitioqty", (Object)stockEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.subtract(newMftMaterialInfo.getBigDecimal("issinlowlimit").divide(BigDecimal.valueOf(100L), 4, 4))));
                                    } else {
                                        stockEntry.set("overissuecontrl", (Object)"A");
                                        stockEntry.set("extraratioqty", stockEntry.get("demandqty"));
                                        stockEntry.set("lackraitioqty", stockEntry.get("demandqty"));
                                    }
                                    stockEntry.set("cansendqty", MPDMMftGenStocksUtils.aculCanSendQty(stockEntry));
                                    stockEntry.set("unissueqty", MPDMMftGenStocksUtils.aculUnSendQty(stockEntry));
                                    DynamicObjectCollection linkRows = stockEntry.getDynamicObjectCollection("stockentry_lk");
                                    linkRows.clear();
                                    if (!linkRows.isEmpty()) continue;
                                    DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
                                    String orderName = "pom_mftorder";
                                    TableDefine srcTableDefine = EntityMetadataCache.loadTableDefine((String)orderName, (String)orderName);
                                    linkRow.set("stockentry_lk_stableid", (Object)srcTableDefine.getTableId());
                                    linkRow.set("stockentry_lk_sbillid", stock.get("orderid"));
                                    linkRow.set("stockentry_lk_sid", (Object)orderEntryId);
                                    linkRows.add((Object)linkRow);
                                    continue;
                                }
                                String number = "";
                                if (oldMaterial.getDynamicObject("masterid") != null) {
                                    number = oldMaterial.getDynamicObject("masterid").getString("number");
                                }
                                ErrorCode errorCode = new ErrorCode("nullMftMaterialInfo", String.format(ResManager.loadKDString((String)"\u7269\u6599\uff08\u7f16\u7801\uff1a%s\uff09\u5728\u8be5\u53d7\u6258\u7ec4\u7ec7\u4e0b\u65e0\u53ef\u7528\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"InnerProStocksUtils_1", (String)"bd-mpdm-common", (Object[])new Object[0]), number));
                                throw new KDBizException(errorCode, new Object[0]);
                            }
                            ErrorCode errorCode = new ErrorCode("nullMftMaterialInfo", ResManager.loadKDString((String)"\u8be5\u53d7\u6258\u7ec4\u7ec7\u4e0b\u65e0\u53ef\u7528\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"InnerProStocksUtils_2", (String)"bd-mpdm-common", (Object[])new Object[0]));
                            throw new KDBizException(errorCode, new Object[0]);
                        }
                        oldStockEntryColl.addAll((Collection)innerStockEntryColl);
                        continue block14;
                    }
                }
            }
        }
    }

    private static long getOrderEntryId(DynamicObject stock) {
        Object orderentryidObj = stock.get("orderentryid");
        long orderEntryId = 0L;
        if (orderentryidObj instanceof DynamicObject) {
            orderEntryId = ((DynamicObject)orderentryidObj).getLong("id");
        } else if (orderentryidObj instanceof Long) {
            orderEntryId = stock.getLong("orderentryid");
        } else if (orderentryidObj instanceof String) {
            orderEntryId = Long.parseLong(orderentryidObj.toString());
        }
        return orderEntryId;
    }

    public static Map<Long, Map<String, String>> getOprEntryDataMap(Set<Long> oprEntryIds, String entity) {
        Objects.requireNonNull(oprEntryIds);
        HashMap<Long, Map<String, String>> oprentryid_dataMap = new HashMap<Long, Map<String, String>>(16);
        QFilter[] qf = new QFilter[]{new QFilter("oprentryentity.id", "in", oprEntryIds)};
        String selects = "oprentryentity.id,oprentryentity.oprno oprno,oprentryentity.oprparent oprparent";
        String algoKey = "InnerProStocksUtils.getOprEntryDataMap";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entity, (String)selects, (QFilter[])qf, null);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                HashMap<String, String> dataMap = new HashMap<String, String>(2);
                dataMap.put("oprno", next.getString("oprno"));
                dataMap.put("processseq", next.getString("oprparent"));
                oprentryid_dataMap.put(next.getLong("oprentryentity.id"), dataMap);
            }
        }
        return oprentryid_dataMap;
    }

    private static Map<Long, DynamicObject> getOldStockMap(Set<Long> srcOrderEntryIds) {
        DynamicObject[] stocks;
        Objects.requireNonNull(srcOrderEntryIds);
        QFilter[] qf = new QFilter[]{new QFilter("orderentryid.id", "in", srcOrderEntryIds)};
        String algoKey = "InnerProStocksUtils.getOldStockMap";
        String selects = "id,orderentryid.id";
        HashSet<Long> stockIds = new HashSet<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pom_mftstock", (String)selects, (QFilter[])qf, null);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                stockIds.add(next.getLong("id"));
            }
        }
        HashMap<Long, DynamicObject> srcOrderEntryId_oldStockObj = new HashMap<Long, DynamicObject>(16);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"pom_mftstock");
        for (DynamicObject stock : stocks = BusinessDataServiceHelper.load((Object[])stockIds.toArray(), (DynamicObjectType)type)) {
            long orderEntryId = stock.getLong("orderentryid.id");
            srcOrderEntryId_oldStockObj.put(orderEntryId, stock);
        }
        return srcOrderEntryId_oldStockObj;
    }

    private static Map<Long, List<DynamicObject>> getBotpStockMap(Set<Map<String, Object>> stockMapSet, String stockName) {
        HashMap<Long, List<DynamicObject>> botpStockMap = new HashMap<Long, List<DynamicObject>>(16);
        PushArgs pushArgs = new PushArgs();
        pushArgs.setTargetEntityNumber(stockName);
        pushArgs.setHasRight(true);
        pushArgs.setRuleId("1485510711827303424");
        pushArgs.setBuildConvReport(true);
        pushArgs.setSourceEntityNumber(stockName);
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(16);
        for (Map<String, Object> stockMap : stockMapSet) {
            if (stockMap == null) continue;
            ListSelectedRow srcBill = new ListSelectedRow();
            srcBill.setPrimaryKeyValue(stockMap.get("stockid"));
            srcBill.setEntryPrimaryKeyValue(stockMap.get("stockentryid"));
            srcBill.setEntryEntityKey("stockentry");
            needPushRows.add(srcBill);
        }
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)stockName);
        if (!pushResult.isSuccess()) {
            throw new KDBizException(new ErrorCode("StockAutoGenerateStock", MPDMMftGenStocksUtils.getErrByRes(pushResult)), new Object[0]);
        }
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        for (DynamicObject targetBillObj : targetBillObjs) {
            List targetBillObjList = botpStockMap.computeIfAbsent(targetBillObj.getLong("sourcebillid"), e -> new ArrayList());
            targetBillObjList.add(targetBillObj);
        }
        return botpStockMap;
    }

    private static void setStockEntryWarehouse(DynamicObject mtfOrg, DynamicObject stockEntry, DynamicObject orderEntry, OrderBaseData baseData) {
        Object warehousesource;
        String stockName = "pom_mftstock";
        if ("A".equals(stockEntry.getString("isbackflush"))) {
            return;
        }
        Long pk = 0L;
        if (mtfOrg != null) {
            pk = (Long)mtfOrg.getPkValue();
        }
        HashMap<String, Object> cacheMap = new HashMap<String, Object>(16);
        if (baseData != null) {
            Map<String, Object> warehouseOrgMap = baseData.getWarehouseOrgMap();
            warehousesource = warehouseOrgMap.get(pk.toString());
        } else {
            Map<String, Object> pmAppParameterMap = MPDMMftGenStocksUtils.getPmAppParameterMap(pk, stockName);
            warehousesource = pmAppParameterMap.get("fwarehousesource");
        }
        if (warehousesource != null && "0".equals(warehousesource.toString())) {
            Long wcID;
            DynamicObject workCenter = null;
            if (orderEntry.containsProperty("workcenter")) {
                workCenter = orderEntry.getDynamicObject("workcenter");
            }
            Long l = wcID = workCenter == null ? Long.valueOf("0") : (Long)workCenter.getPkValue();
            if (wcID != 0L) {
                if (baseData == null) {
                    if (cacheMap.containsKey("wh_" + wcID)) {
                        workCenter = (DynamicObject)cacheMap.get("wh_" + wcID);
                    } else {
                        workCenter = WorkcenterQueryHelper.getDataCacheByID(wcID);
                        cacheMap.put("wh_" + wcID, workCenter);
                    }
                } else {
                    workCenter = baseData.getWcBlackWHMap(wcID);
                }
            }
            Object workCenterEntry = null;
            if (stockEntry.containsProperty("oprworkcenter")) {
                workCenterEntry = stockEntry.get("oprworkcenter");
            }
            Long entryWcID = 0L;
            if (workCenterEntry != null) {
                entryWcID = workCenterEntry instanceof DynamicObject ? (Long)((DynamicObject)workCenterEntry).getPkValue() : (Long)workCenterEntry;
            }
            DynamicObject workCenterEntryDym = null;
            if (entryWcID != 0L) {
                if (baseData == null) {
                    if (cacheMap.containsKey("wh_" + entryWcID)) {
                        workCenterEntryDym = (DynamicObject)cacheMap.get("wh_" + entryWcID);
                    } else {
                        workCenterEntryDym = WorkcenterQueryHelper.getDataCacheByID(entryWcID);
                        cacheMap.put("wh_" + entryWcID, workCenterEntry);
                    }
                } else {
                    workCenterEntryDym = baseData.getWcBlackWHMap(entryWcID);
                }
            }
            if (workCenter != null && workCenter.get("warehouse") != null) {
                stockEntry.set("warehouseid", workCenter.get("warehouse"));
                stockEntry.set("location", workCenter.get("location"));
            } else if (workCenterEntryDym != null && workCenterEntryDym.get("warehouse") != null) {
                stockEntry.set("warehouseid", workCenterEntryDym.get("warehouse"));
                stockEntry.set("location", workCenterEntryDym.get("location"));
            } else {
                stockEntry.set("warehouseid", null);
                stockEntry.set("location", null);
            }
        }
    }
}

