/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.page;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bd.mpdm.common.page.FieldElement;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.TextProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ISuportClick;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.field.TextEdit;
import kd.bos.metadata.entity.commonfield.TextField;

public class TextElement
extends FieldElement
implements ISuportClick {
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    protected List<ClickListener> buttonClickListeners = new ArrayList<ClickListener>();

    public TextElement(String name, String displayName) {
        super(name, displayName);
    }

    public TextElement(String name, String displayName, String parentName) {
        super(name, displayName, parentName);
    }

    public void addButtonClickListener(ClickListener listener) {
        this.buttonClickListeners.add(listener);
    }

    protected TextField _getField() {
        TextField textField = new TextField();
        textField.setEditStyle(1);
        this._updateField(textField);
        return textField;
    }

    private void _updateField(TextField textField) {
        textField.setId(this.name);
        textField.setKey(this.name);
        textField.setMinLength(0);
        textField.setMaxLength(1000);
    }

    protected TextProp _getProperty() {
        TextProp textProp = new TextProp();
        this._updateProp(textProp);
        return textProp;
    }

    @Override
    public Control getControl(IFormView view) {
        TextEdit textEdit = new TextEdit();
        textEdit.setKey(this.name);
        textEdit.setEntryKey(this.parentName);
        textEdit.setEntryControlKey(this.parentName);
        textEdit.setView(view);
        textEdit.setModel(view.getModel());
        return textEdit;
    }

    @Override
    public void registerEntryProp(EntryType entryType) {
        TextProp textProp = this._getProperty();
        entryType.registerSimpleProperty((DynamicSimpleProperty)textProp);
    }

    void _updateProp(TextProp textProp) {
        textProp.setName(this.name);
        textProp.setDbIgnore(true);
        textProp.setAlias("");
        textProp.setMustInput(false);
        textProp.setDisplayName(new LocaleString(this.displayName));
        textProp.setPrivacyType(0L);
        textProp.setFilterControlType("text");
        textProp.setSysField(false);
    }

    public void addClickListener(ClickListener listener) {
        this.buttonClickListeners.add(listener);
    }

    public void addItemClickListener(ItemClickListener itemClickListener) {
    }

    public void click() {
        BeforeClickEvent e = new BeforeClickEvent((Object)this);
        this.fireBeforeClick(e);
        if (!e.isCancel()) {
            ClickEvent e1 = new ClickEvent((Object)this);
            this.fireClick(e1);
        }
    }

    protected void fireBeforeClick(BeforeClickEvent e) {
        for (ClickListener l : this.buttonClickListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".beforeClick"));
            Throwable throwable = null;
            try {
                l.beforeClick(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    protected void fireClick(ClickEvent e) {
        if (this.buttonClickListeners != null) {
            for (ClickListener l : this.buttonClickListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".click"));
                Throwable throwable = null;
                try {
                    l.click((EventObject)e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }
}

