/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.programe.utils;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.mftorder.utils.CreateStockUtils;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.mftorder.utils.OrderBaseData;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ProgrameOperateStockUtils {
    private static final Log logger = LogFactory.getLog(ProgrameOperateStockUtils.class);
    private static final String PROGRAMMME = "programme";

    private ProgrameOperateStockUtils() {
    }

    public static void expandStocks(List<DynamicObject> saveProgrameStocks, OrderBaseData baseData) {
        logger.info("--\u6309\u914d\u65b9\u5c55\u5f00\u5f00\u59cb--");
        Set programmeIdSet = saveProgrameStocks.stream().filter(x -> null != x.getDynamicObject(PROGRAMMME)).map(x -> x.getDynamicObject(PROGRAMMME).getPkValue()).collect(Collectors.toSet());
        logger.info("--\u914d\u65b9id--" + JSON.toJSONString(programmeIdSet));
        Map programeCacheMap = BusinessDataServiceHelper.loadFromCache((Object[])programmeIdSet.toArray(), (String)"fmm_programe");
        Collection programeCacheSet = programeCacheMap.values();
        HashSet materialIdSet = new HashSet(16);
        for (DynamicObject programmeObj : programeCacheSet) {
            Set effectiveGroupRowSet = programmeObj.getDynamicObjectCollection("groupentity").stream().filter(x -> null != x.get("entrymaterial") && "D".equals(x.getString("prodtype"))).collect(Collectors.toSet());
            materialIdSet.addAll(effectiveGroupRowSet.stream().map(x -> x.getDynamicObject("entrymaterial").getLong("id")).collect(Collectors.toSet()));
            materialIdSet.addAll(effectiveGroupRowSet.stream().filter(x -> null != x.getDynamicObject("parentmat")).map(x -> x.getDynamicObject("parentmat").getLong("id")).collect(Collectors.toSet()));
        }
        HashMap<Long, Object> orgMaterialMftInfoMap = new HashMap<Long, Object>(16);
        HashSet<Long> supplyOrgIdSet = new HashSet<Long>(16);
        Set orgIdSet = saveProgrameStocks.stream().filter(x -> null != x.getDynamicObject("org")).map(x -> x.getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        for (Long orgId : orgIdSet) {
            HashMap<Long, Set<Long>> orgMasterMap = new HashMap<Long, Set<Long>>(16);
            orgMasterMap.put(orgId, materialIdSet);
            CreateStockUtils.getMaterialMftInfoByMaster(orgId, orgMaterialMftInfoMap, orgMasterMap, supplyOrgIdSet);
            baseData.setOrgMaterialMftInfoMap(orgMaterialMftInfoMap);
        }
        for (DynamicObject saveProgramStock : saveProgrameStocks) {
            DynamicObject programme = saveProgramStock.getDynamicObject(PROGRAMMME);
            if (null == programme) continue;
            Long orderEntryId = ProgrameOperateStockUtils.getOrderEntryIdByStock(saveProgramStock);
            DynamicObject order = baseData.getOrderByEntryId(orderEntryId);
            boolean showJump = order.getDynamicObject("transactiontype").getBoolean("showjump");
            DynamicObject orderEntry = baseData.getOrderEntry(orderEntryId);
            Date expendTime = orderEntry.getDate("expendbomtime");
            StringBuilder errInfo = new StringBuilder(200);
            ArrayList<String> materialNameList = new ArrayList<String>(16);
            StringBuilder materialName = new StringBuilder();
            DynamicObject programeQueryObj = (DynamicObject)programeCacheMap.get(programme.getPkValue());
            DynamicObjectCollection entryEntity = programeQueryObj.getDynamicObjectCollection("entryentity");
            Set groupEntitySet = programeQueryObj.getDynamicObjectCollection("groupentity").stream().filter(x -> "D".equals(x.getString("prodtype"))).collect(Collectors.toSet());
            logger.info("--groupEntitySet size--" + groupEntitySet.size());
            for (DynamicObject groupRow : groupEntitySet) {
                logger.info("--groupRow.getPkValue() \u8df3\u5c42\u548c\u6709\u6548\u671f\u6821\u9a8c--" + groupRow.getPkValue());
                if (!showJump && groupRow.getBoolean("entryisjumplevel") || expendTime.before(groupRow.getDate("entryvaliddate")) || expendTime.after(groupRow.getDate("entryinvaliddate"))) continue;
                logger.info("--groupRow.getPkValue() \u8df3\u5c42\u548c\u6709\u6548\u671f\u6821\u9a8c\u901a\u8fc7--" + groupRow.getPkValue());
                String res = ProgrameOperateStockUtils.createAndSetStockEntry(order, orderEntry, saveProgramStock, baseData, groupRow, entryEntity);
                if (!"0".equals(res) && !"1".equals(res)) {
                    materialNameList.add(res);
                }
                DynamicObjectCollection stockEntrys = saveProgramStock.getDynamicObjectCollection("stockentry");
                int size = stockEntrys.size();
                for (int i = 0; i < size; ++i) {
                    ((DynamicObject)stockEntrys.get(i)).set("seq", (Object)(i + 1));
                }
            }
            ProgrameOperateStockUtils.appendErrInfo(materialNameList, materialName);
            if (materialName.length() > 0) {
                ProgrameOperateStockUtils.appendErrInfoOrder(materialName, orderEntry, order, errInfo);
            }
            if ("".equals(errInfo.toString())) continue;
            CreateStockUtils.setErr(orderEntryId, baseData, errInfo.toString(), saveProgramStock);
        }
        CreateStockUtils.setStockWareHouse(saveProgrameStocks, baseData);
        logger.info("--\u6309\u914d\u65b9\u5c55\u5f00\u7ed3\u675f--");
    }

    private static String createAndSetStockEntry(DynamicObject order, DynamicObject orderEntry, DynamicObject saveProgrammeStock, OrderBaseData baseData, DynamicObject groupRow, DynamicObjectCollection entryEntity) {
        Optional<DynamicObject> optional;
        Boolean isquotacontrol;
        logger.info("--createAndSetStockEntry in--");
        String stockName = saveProgrammeStock.getDataEntityType().getName();
        DynamicObject org = saveProgrammeStock.getDynamicObject("org");
        if (org == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5355[%1$s]\u751f\u6210\u7684\u7ec4\u4ef6\u6e05\u5355\u7684\u751f\u4ea7\u7ec4\u7ec7\u4e3a\u7a7a.", (String)"ProgrameOperateStockUtils_0", (String)"bd-mpdm-common", (Object[])new Object[0]), order.getString("billno")));
        }
        logger.info("--createAndSetStockEntry pass orgcheck--");
        Long orgId = (Long)org.getPkValue();
        DynamicObject entrymaterial = ProgrameOperateStockUtils.getMaterialMftFromProgramme(groupRow, baseData, orgId);
        if (entrymaterial == null) {
            logger.info("\u627e\u4e0d\u5230\u7269\u6599\u751f\u4ea7\u4fe1\u606f\uff1a\u53ef\u80fd\u662f\u914d\u65b9\u672a\u914d\u7f6e\u7269\u6599\u751f\u4ea7\u4fe1\u606f,\u914d\u65b9\u5206\u5f55\u7684ID=" + groupRow.getPkValue().toString());
            String programeNumber = saveProgrammeStock.getDynamicObject(PROGRAMMME).getString("number");
            Long masterId = ProgrameOperateStockUtils.getMaterialId(groupRow);
            if (masterId != null && !masterId.equals(0L)) {
                DynamicObject materialmftInfo = baseData.getOrgMaterialMftInfo(orgId, masterId);
                String materialmftInfoStr = "";
                materialmftInfoStr = materialmftInfo == null ? "0" : (materialmftInfo.getPkValue() == null ? "1" : materialmftInfo.getPkValue().toString());
                logger.info("\u627e\u4e0d\u5230\u7269\u6599\u751f\u4ea7\u4fe1\u606f\uff1a\u53ef\u80fd\u662f\u914d\u65b9\u7ec4\u4ef6\u4fe1\u606f\u672a\u914d\u7f6e\u7269\u6599\u751f\u4ea7\u4fe1\u606f," + materialmftInfoStr);
                DynamicObject dataCacheByMaterialID = MaterialMftQueryHelper.getDataCacheByMaterialID(masterId, orgId, null);
                String dataCacheByMaterialIDStr = "";
                dataCacheByMaterialIDStr = dataCacheByMaterialID == null ? "0" : (dataCacheByMaterialID.getPkValue() == null ? "1" : dataCacheByMaterialID.getPkValue().toString());
                logger.info("\u627e\u4e0d\u5230\u7269\u6599\u751f\u4ea7\u4fe1\u606f\uff1a\u53ef\u80fd\u662f\u914d\u65b9\u7ec4\u4ef6\u660e\u7ec6\u672a\u914d\u7f6e\u7269\u6599\u751f\u4ea7\u4fe1\u606f,\u91cd\u65b0\u67e5\u8be2\u7ed3\u679c" + dataCacheByMaterialIDStr);
            } else {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u914d\u65b9[%1$s]\u7684\u5206\u5f55\u5b58\u5728\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u4e3a\u7a7a\u7684\u6570\u636e\uff0c\u8bf7\u6838\u67e5.", (String)"ProgrameOperateStockUtils_1", (String)"bd-mpdm-common", (Object[])new Object[0]), programeNumber));
            }
        }
        logger.info("--createAndSetStockEntry entrymaterial != null--");
        Long masterid = ProgrameOperateStockUtils.getMaterialId(groupRow);
        DynamicObject materialmftInfo = baseData.getOrgMaterialMftInfo(orgId, masterid);
        if (materialmftInfo == null || !materialmftInfo.getBoolean("enable") || !"C".equalsIgnoreCase(materialmftInfo.getString("status"))) {
            DynamicObject material = MaterialQueryHelper.getDataCacheByID(masterid);
            logger.info("\u627e\u4e0d\u5230\u7269\u6599\u751f\u4ea7\u4fe1\u606f\uff1a:" + material.getPkValue().toString());
            return material.getString("number") + "," + material.getString("name");
        }
        DynamicObjectCollection stockEntrys = saveProgrammeStock.getDynamicObjectCollection("stockentry");
        DynamicObject stockEntry = stockEntrys.addNew();
        logger.info("--createAndSetStockEntry addNew--");
        DynamicObject transactproduct = CreateStockUtils.getTran(saveProgrammeStock, stockName, baseData);
        Date planbegintime = orderEntry.getDate("planbegintime");
        Date planendtime = orderEntry.getDate("planendtime");
        stockEntry.set("demanddate", ProgrameOperateStockUtils.getDemandDate(planbegintime, stockEntry, planendtime));
        String materialsource = "A";
        boolean isconsiderloss = false;
        Object backflushtime = null;
        if (transactproduct != null) {
            isconsiderloss = transactproduct.getBoolean("isconsiderloss");
            materialsource = transactproduct.getString("materialsource");
            backflushtime = transactproduct.get("backflushtime");
        }
        long groupRowid = groupRow.getLong("id");
        baseData.getProgEntryMap().put(groupRowid, groupRow);
        stockEntry.set("progentryid", (Object)groupRowid);
        stockEntry.set("isbomextend", (Object)Boolean.FALSE);
        DynamicObject entryunit = MPDMMftGenStocksUtils.getEntryUnit(groupRow, materialmftInfo);
        stockEntry.set("materialunitid", (Object)entryunit);
        stockEntry.set("materialid", (Object)materialmftInfo);
        stockEntry.set("materielmasterid", (Object)masterid);
        stockEntry.set("useratio", (Object)100);
        stockEntry.set("pid", (Object)0L);
        stockEntry.set("qtytype", (Object)groupRow.getString("entryqtytype"));
        stockEntry.set("fixscrap", groupRow.get("assignrate"));
        stockEntry.set("scraprate", groupRow.get("scraprate"));
        stockEntry.set("qtynumerator", groupRow.get("qtynumerator"));
        stockEntry.set("qtydenominator", groupRow.get("qtydenominator"));
        stockEntry.set("isjumplevel", groupRow.get("entryisjumplevel"));
        stockEntry.set("standqty", (Object)MPDMMftGenStocksUtils.getStandQty(groupRow, orderEntry, stockEntry));
        String wastagerateformula = "B";
        String orgMasterWast = baseData.getOrgMasterWast(orgId, masterid);
        if (orgMasterWast != null) {
            wastagerateformula = orgMasterWast;
        } else if (!isconsiderloss) {
            wastagerateformula = "";
        }
        stockEntry.set("wastagerateformula", (Object)wastagerateformula);
        stockEntry.set("demandqty", (Object)MPDMMftGenStocksUtils.getDemandQty(groupRow, isconsiderloss, stockEntry, wastagerateformula));
        stockEntry.set("bomreversion", (Object)groupRow.getDynamicObject("entryversion"));
        stockEntry.set("childauxpropertyid", groupRow.get("entryauxproperty"));
        stockEntry.set("considerminbatch", materialmftInfo.get("considerminbatch"));
        DynamicObject parentMatObj = groupRow.getDynamicObject("parentmat");
        if (null != parentMatObj) {
            stockEntry.set("parentmaterial", (Object)baseData.getOrgMaterialMftInfo(orgId, parentMatObj.getLong("id")));
        }
        if ((isquotacontrol = Boolean.valueOf(materialmftInfo.get("isquotacontrol") == null ? false : materialmftInfo.getBoolean("isquotacontrol"))).booleanValue()) {
            stockEntry.set("overissuecontrl", (Object)"B");
            stockEntry.set("issinhighlimit", materialmftInfo.get("issinhighlimit"));
            stockEntry.set("extraratioqty", (Object)stockEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.add(materialmftInfo.getBigDecimal("issinhighlimit").divide(BigDecimal.valueOf(100L), 4, 4))));
            stockEntry.set("issinlowlimit", materialmftInfo.get("issinlowlimit"));
            stockEntry.set("lackraitioqty", (Object)stockEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.subtract(materialmftInfo.getBigDecimal("issinlowlimit").divide(BigDecimal.valueOf(100L), 4, 4))));
        } else {
            stockEntry.set("overissuecontrl", (Object)"A");
            stockEntry.set("extraratioqty", stockEntry.get("demandqty"));
            stockEntry.set("lackraitioqty", stockEntry.get("demandqty"));
        }
        stockEntry.set("bomentryid", (Object)0L);
        stockEntry.set("cansendqty", MPDMMftGenStocksUtils.aculCanSendQty(stockEntry));
        stockEntry.set("unissueqty", MPDMMftGenStocksUtils.aculUnSendQty(stockEntry));
        stockEntry.set("sourcetype", (Object)"F");
        ProgrameOperateStockUtils.setStockEntryByProgrameInfoExPandWarehouse(stockEntry, groupRow);
        if ("B".equals(materialsource)) {
            CreateStockUtils.setStockEntryByMftInfoExPandWarehouse(stockEntry, materialmftInfo);
        }
        if (ProgrameOperateStockUtils.hasProperties(stockEntry, "isjumplevel")) {
            logger.info("--createAndSetStockEntry \u8df3\u5c42\u903b\u8f91\u5904\u7406--");
            stockEntry.set("isjumplevel", groupRow.get("entryisjumplevel"));
            if (stockEntry.getBoolean("isjumplevel")) {
                stockEntry.set("issuemode", (Object)"C");
            }
        }
        if (ProgrameOperateStockUtils.hasProperties(stockEntry, "pstockentryid")) {
            stockEntry.set("pstockentryid", (Object)0L);
        }
        if ("B".equals(stockEntry.get("isbackflush"))) {
            stockEntry.set("backflushtime", backflushtime);
        } else {
            stockEntry.set("backflushtime", null);
        }
        String proentryIdStr = groupRow.getString("proentryid");
        if (StringUtils.isNotEmpty((String)proentryIdStr) && CollectionUtils.isNotEmpty((Collection)entryEntity) && (optional = entryEntity.stream().filter(x -> proentryIdStr.equals(String.valueOf(x.getPkValue()))).findFirst()).isPresent()) {
            DynamicObject entryRow = optional.get();
            stockEntry.set("oprno", entryRow.get("processno"));
            stockEntry.set("workprocedureid", entryRow.get("prostatge"));
            stockEntry.set("operationdesc", entryRow.get("prostatgedesc"));
        }
        logger.info("--createAndSetStockEntry out--");
        return "0";
    }

    private static Long getOrderEntryIdByStock(DynamicObject saveBomStock) {
        Object orderEntryObj = saveBomStock.get("orderentryid");
        if (orderEntryObj != null) {
            Object newObj = orderEntryObj instanceof DynamicObject ? ((DynamicObject)orderEntryObj).getPkValue() : orderEntryObj;
            return NumberUtils.toLong((String)newObj.toString());
        }
        return 0L;
    }

    public static void setStockEntryByProgrameInfoExPandWarehouse(DynamicObject stockEntry, DynamicObject programmeRow) {
        if (programmeRow == null) {
            logger.info("\u7ec4\u4ef6\u6e05\u5355\u5206\u5f55id\u5bf9\u5e94\u7684\u914d\u65b9\u7ec4\u4ef6\u5206\u5f55\u4e3a\u7a7a\uff0c" + stockEntry.getLong("id"));
            return;
        }
        String issuemodestr = MPDMMftGenStocksUtils.getIssuemode(programmeRow.get("entryissuemode"));
        stockEntry.set("issuemode", (Object)issuemodestr);
        stockEntry.set("isstockallot", programmeRow.get("entryisstockalloc"));
        stockEntry.set("isbackflush", programmeRow.get("entryisbackflush"));
        stockEntry.set("outorgunitid", programmeRow.get("entryoutorg"));
        stockEntry.set("outwarehouseid", programmeRow.get("entryoutwarehouse"));
        stockEntry.set("outlocation", programmeRow.get("entryoutlocation"));
        stockEntry.set("supplymode", programmeRow.get("entryownertype"));
        stockEntry.set("supplierid", programmeRow.get("entryowner"));
        stockEntry.set("supplyorgid", programmeRow.get("entrysupplyorg"));
        stockEntry.set("warehouseid", programmeRow.get("entrywarehouse"));
        stockEntry.set("location", programmeRow.get("entrylocation"));
        stockEntry.set("childauxpropertyid", programmeRow.get("entryauxproperty"));
    }

    private static DynamicObject getMaterialMftFromProgramme(DynamicObject programmeEntry, OrderBaseData baseData, Long orgId) {
        Long masterid = ProgrameOperateStockUtils.getMaterialId(programmeEntry);
        if (masterid == null || masterid.equals(0L)) {
            return null;
        }
        return baseData.getOrgMaterialMftInfo(orgId, masterid);
    }

    private static Object getDemandDate(Date planbegintime, DynamicObject stockEntry, Date planendtime) {
        Date replanbegintime;
        BigDecimal leadtime = stockEntry.getBigDecimal("leadtime");
        Calendar c = Calendar.getInstance();
        c.setTime(planbegintime);
        if (leadtime != null) {
            c.add(5, leadtime.intValue());
        }
        if ((replanbegintime = c.getTime()) == null) {
            replanbegintime = planbegintime;
        } else if (replanbegintime.after(planendtime)) {
            replanbegintime = planendtime;
        }
        return replanbegintime;
    }

    private static Long getMaterialId(DynamicObject programmeEntry) {
        DynamicObject entrymaterial = programmeEntry.getDynamicObject("entrymaterial");
        if (entrymaterial == null) {
            return 0L;
        }
        return entrymaterial.getLong("masterid");
    }

    private static boolean hasProperties(DynamicObject data, String propertiesNumber) {
        return data.getDataEntityType().getProperties().containsKey((Object)propertiesNumber);
    }

    private static void appendErrInfo(List<String> materialNameList, StringBuilder materialName) {
        if (!materialNameList.isEmpty()) {
            if (materialNameList.size() == 1) {
                materialName.append("\u3010");
                materialName.append(materialNameList.get(0));
                materialName.append("\u3011");
            } else if (materialNameList.size() > 1) {
                for (int i = 0; i < materialNameList.size(); ++i) {
                    if (i == materialNameList.size() - 1) {
                        materialName.append("\u3010");
                        materialName.append(materialNameList.get(i));
                        materialName.append("\u3011");
                        continue;
                    }
                    materialName.append("\u3010");
                    materialName.append(materialNameList.get(i));
                    materialName.append("\u3011");
                    materialName.append(",");
                }
            }
        }
    }

    private static void appendErrInfoOrder(StringBuilder materialName, DynamicObject orderEntry, DynamicObject order, StringBuilder errInfo) {
        String orderName = order.getDataEntityType().getName();
        String mtfOrgName = "";
        mtfOrgName = "pm_om_purorderbill".equals(orderName) ? orderEntry.getDynamicObject("entryreqorg").getString("name") : order.getDynamicObject("org").getString("name");
        errInfo.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7[%1$s]\u4e0a\u4e0d\u5b58\u5728\u914d\u65b9\u7ec4\u4ef6\u5206\u5f55\u4e2d\"\u7ec4\u4ef6\"\u4e3a%2$s\u53ef\u7528\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f;", (String)"ProgrameOperateStockUtils_2", (String)"bd-mpdm-common", (Object[])new Object[0]), mtfOrgName, materialName));
    }

    public static boolean isShowJump(DynamicObject transactionType) {
        if (transactionType == null) {
            return false;
        }
        String stockmaterials = "";
        if (ProgrameOperateStockUtils.isWWTransactionType(transactionType)) {
            if (!transactionType.containsProperty("feedtype") || !transactionType.containsProperty("showjump")) {
                transactionType = BusinessDataServiceHelper.loadSingleFromCache((Object)transactionType.getPkValue(), (String)transactionType.getDataEntityType().getName());
            }
            stockmaterials = transactionType.getString("feedtype");
        } else {
            if (!transactionType.containsProperty("stockmaterials") || !transactionType.containsProperty("showjump")) {
                transactionType = TransactionTypeQueryHelper.getDataCacheByID(transactionType.getPkValue());
            }
            stockmaterials = transactionType.getString("stockmaterials");
        }
        return transactionType.getBoolean("showjump") && "A".equals(stockmaterials);
    }

    private static boolean isWWTransactionType(DynamicObject transactionType) {
        return "mpdm_transactout".equalsIgnoreCase(transactionType.getDataEntityType().getName());
    }
}

