/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.route;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.bomcache.BomUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessRouteVersionUtils {
    private static final String KEY_ENTITY_RULE = "bd_bomversionrule_new";
    private static final String KEY_ENTITY_VERSION = "bd_bomversion_new";
    private static final String KEY_ENTITY_OLDVERSION = "mpdm_processversion";
    private static Log logger = LogFactory.getLog(ProcessRouteVersionUtils.class);

    public static boolean isRouteVsersion(Long orgId) {
        return ProcessRouteVersionUtils.getBizAppParam(orgId, "isopenrouteversion", "fmm");
    }

    public static boolean isMaterialVsersion(DynamicObject material) {
        return false;
    }

    public static boolean isExistsHisRtByParam(Long orgId) {
        String numberTag = "IsExistsHisRtData_" + String.valueOf(orgId);
        String value = ProcessRouteVersionUtils.getParamValue(numberTag);
        return "true".equalsIgnoreCase(value);
    }

    public static boolean isPdmRoute(DynamicObject route) {
        return "pdm_route".equals(route.getDataEntityType().getName());
    }

    public static String syncOldVersion(DynamicObject route) {
        if (ProcessRouteVersionUtils.isPdmRoute(route)) {
            int oldVersionSeq;
            int newVersionSeq;
            DynamicObject newVersion = route.getDynamicObject("routeversion");
            DynamicObject oldVersion = route.getDynamicObject("version");
            DynamicObject createOrg = route.getDynamicObject("createorg");
            if (newVersion != null && oldVersion != null && ProcessRouteVersionUtils.isCheckSeq() && (newVersionSeq = ProcessRouteVersionUtils.getSeqByNewversion(newVersion)) != (oldVersionSeq = ProcessRouteVersionUtils.getSeqByOldversion(oldVersion))) {
                return String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u53f7\uff1a%1$s\uff0c\u65b0\u7248\u672c\u201c%2$s\u201d\u4e0e\u65e7\u7248\u672c\u201c%3$s\u201d\u7684\u987a\u5e8f\u53f7\u4e0d\u4e00\u81f4\u3002", (String)"ProcessRouteVersionUtils_04", (String)"bd-mpdm-common", (Object[])new Object[0]), route.getString("number"), newVersion.getString("number"), oldVersion.getString("number"));
            }
            if (newVersion != null && oldVersion == null && ProcessRouteVersionUtils.isExistsHisRtByParam((Long)createOrg.getPkValue())) {
                newVersionSeq = ProcessRouteVersionUtils.getSeqByNewversion(newVersion);
                DynamicObject oldVersionA = ProcessRouteVersionUtils.getOldversionBySeq(createOrg, newVersionSeq);
                if (oldVersionA == null) {
                    oldVersionA = ProcessRouteVersionUtils.buildOldVersionBySeq(createOrg, newVersionSeq, newVersion, route.getString("number"));
                }
                route.set("version", (Object)oldVersionA);
            }
        }
        return "";
    }

    public static boolean isCheckSeq() {
        return "true".equalsIgnoreCase(ProcessRouteVersionUtils.getParamValue("routeSubmitCheckVersionSeq"));
    }

    public static DynamicObject buildOldVersionBySeq(DynamicObject createOrg, int orderSeq, DynamicObject newVersion, String rtNumber) {
        DynamicObject versionObj = ORM.create().newDynamicObject(KEY_ENTITY_OLDVERSION);
        versionObj.set("createorg", (Object)createOrg);
        versionObj.set("number", (Object)newVersion.getString("name"));
        versionObj.set("name", (Object)newVersion.getString("name"));
        String info = String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u53f7\uff1a%1$s\uff0c\u65b0\u7248\u672c\uff1a%2$s\u3002", (String)"ProcessRouteVersionUtils_03", (String)"bd-mpdm-common", (Object[])new Object[0]), rtNumber, newVersion.getString("number"));
        versionObj.set("remark", (Object)info);
        versionObj.set("status", (Object)"C");
        versionObj.set("enable", (Object)"1");
        versionObj.set("orderseq", (Object)orderSeq);
        versionObj.set("creator", (Object)RequestContext.get().getUserId());
        versionObj.set("createtime", (Object)new Date());
        versionObj.set("effectivedate", (Object)new Date());
        versionObj.set("expirationdate", (Object)BomUtils.getEndDate());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{versionObj});
        ProcessRouteVersionUtils.refreshBaseDataCache(KEY_ENTITY_OLDVERSION, createOrg.getLong("id"));
        return versionObj;
    }

    public static void refreshBaseDataCache(String entityname, Long orgId) {
        String cacheType = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
        String key = entityname + orgId;
        BaseDataCtrlCacheMrg.clearCache((String)cacheType, (String)key);
        BaseDataService baseDataService = new BaseDataService();
        baseDataService.clearBaseDataFilterCache(entityname, orgId);
    }

    public static DynamicObject getOldversionBySeq(DynamicObject createOrg, int orderSeq) {
        QFilter qf = new QFilter("createorg", "=", createOrg.getPkValue());
        qf.and(new QFilter("orderseq", "=", (Object)orderSeq));
        return BusinessDataServiceHelper.loadSingleFromCache((String)KEY_ENTITY_OLDVERSION, (String)"id,number,name", (QFilter[])new QFilter[]{qf});
    }

    public static int getSeqByNewversion(DynamicObject newversion) {
        DynamicObject versionname;
        String versionNameField = "versionname";
        boolean isContainField = newversion.containsProperty(versionNameField);
        DynamicObject dynamicObject = versionname = isContainField ? newversion.getDynamicObject(versionNameField) : null;
        if (versionname == null) {
            DynamicObject newversionA = BusinessDataServiceHelper.loadSingleFromCache((Object)newversion.getPkValue(), (String)KEY_ENTITY_VERSION, (String)versionNameField);
            versionname = newversionA.getDynamicObject(versionNameField);
        }
        String selectProperties = "entryseq";
        DynamicObject ruleEntry = BusinessDataServiceHelper.loadSingleFromCache((Object)versionname.getPkValue(), (String)"bd_bomversionruleentry_f7", (String)selectProperties);
        return ruleEntry.getInt("entryseq");
    }

    public static int getSeqByOldversion(DynamicObject oldVersion) {
        int seq;
        if (oldVersion == null) {
            return 0;
        }
        String seqNameField = "orderseq";
        boolean isContainField = oldVersion.containsProperty(seqNameField);
        int n = seq = isContainField ? oldVersion.getInt(seqNameField) : 0;
        if (seq == 0) {
            DynamicObject version = BusinessDataServiceHelper.loadSingleFromCache((Object)oldVersion.getPkValue(), (String)KEY_ENTITY_OLDVERSION, (String)seqNameField);
            if (version == null) {
                return 0;
            }
            seq = version.getInt(seqNameField);
        }
        return seq;
    }

    public static String getParamValue(String number) {
        DynamicObject dy = QueryServiceHelper.queryOne((String)"pdm_routeversioninitset", (String)"value", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        return dy == null ? "" : dy.getString("value");
    }

    public static boolean getBizAppParam(Long orgId, String paramNumber, String bizAppNum) {
        AppParam appParam = new AppParam();
        DynamicObject bizApp = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"id,orgfunc", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bizAppNum)});
        appParam.setAppId(bizApp.getString("id"));
        String orgfunc = bizApp.getString("orgfunc");
        if (StringUtils.isEmpty((String)orgfunc)) {
            orgfunc = "15";
        }
        appParam.setViewType(orgfunc);
        appParam.setOrgId(orgId);
        appParam.setActBookId(Long.valueOf(0L));
        Map syPparams = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        return syPparams.getOrDefault(paramNumber, false);
    }

    public static DynamicObject getDefaultVersionRule(String type) {
        String defField = "B".equals(type) ? "isdefaultroute" : ("C".equals(type) ? "isdefaultprograme" : "isdefault");
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterType = new QFilter("multype", "like", (Object)("%" + type + "%"));
        QFilter qFilter2 = new QFilter(defField, "=", (Object)Boolean.TRUE);
        return BusinessDataServiceHelper.loadSingleFromCache((String)KEY_ENTITY_RULE, (String)"id,number,entryentity.version,entryentity.seq", (QFilter[])new QFilter[]{qFilter2, qFilterStatus, qFilterEnable, qFilterType});
    }

    public static Date getValidDate(Date validdate) {
        return validdate == null ? new Date() : validdate;
    }

    public static Date getInValidDate(Date invaliddate) {
        if (invaliddate == null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                invaliddate = sdf.parse("2999-12-31");
            }
            catch (ParseException e) {
                logger.error((Object)"SimpleDateFormat ParseException", (Throwable)e);
            }
        }
        return invaliddate;
    }

    public static DynamicObject getAutoVersionWithDynamicObject(Long orgId, Long materId, Long materGroupId, Long ruleId, int oldVersionSeq) {
        int maxSeq = oldVersionSeq > 0 ? oldVersionSeq - 1 : ProcessRouteVersionUtils.getExistsVersionMaxSeq(orgId, materId, materGroupId, ruleId);
        return ProcessRouteVersionUtils.getNotRouteVersionDynamicObject(ruleId, maxSeq);
    }

    private static DynamicObject getNotRouteVersionDynamicObject(Object ruleId, int maxSeq) {
        DynamicObjectCollection rules;
        QFilter qFilter = new QFilter("id", "=", ruleId);
        if (maxSeq >= 0) {
            qFilter.and(new QFilter("entryentity.seq", ">", (Object)maxSeq));
        }
        if ((rules = QueryServiceHelper.query((String)KEY_ENTITY_RULE, (String)"entryentity.id id,entryentity.version version,entryentity.seq seq", (QFilter[])new QFilter[]{qFilter}, (String)"entryentity.seq")) == null || rules.isEmpty()) {
            return null;
        }
        return (DynamicObject)rules.get(0);
    }

    private static int getExistsVersionMaxSeq(Long orgId, Long materId, Long materGroupId, Long ruleId) {
        QFilter qFilter = new QFilter("bomversionrule", "=", (Object)ruleId);
        qFilter.and(new QFilter("type", "=", (Object)"B"));
        if (materId != null && !materId.equals(0L)) {
            qFilter.and(new QFilter("material", "=", (Object)materId));
            qFilter.and(new QFilter("materialgroup", "=", (Object)0L));
        } else if (materGroupId != null && !materGroupId.equals(0L)) {
            qFilter.and(new QFilter("material", "=", (Object)0L));
            qFilter.and(new QFilter("materialgroup", "=", (Object)materGroupId));
        } else {
            qFilter.and(new QFilter("material", "=", (Object)0L));
            qFilter.and(new QFilter("materialgroup", "=", (Object)0L));
        }
        String selectProperties = "versionname.entryseq entryseq";
        int maxSeq = -1;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(ProcessRouteVersionUtils.class.getName() + "getExistsVersionMaxSeq"), (String)KEY_ENTITY_VERSION, (String)selectProperties, (QFilter[])new QFilter[]{qFilter}, (String)" versionname.entryseq desc ");){
            for (Row arow : ds) {
                if (maxSeq >= arow.getInteger("entryseq")) continue;
                maxSeq = arow.getInteger("entryseq");
            }
        }
        return maxSeq;
    }

    public static DynamicObject createAndGetRouteVersion(DynamicObject route, boolean isCreate, Set<Long> unVersionIdSet) {
        DynamicObject newRouteVersion;
        DynamicObject createorg = route.getDynamicObject("createorg");
        DynamicObject material = route.getDynamicObject("material");
        DynamicObject materialGroup = route.getDynamicObject("materialgroup");
        String processType = route.getString("processtype");
        DynamicObject rule = ProcessRouteVersionUtils.getDefaultVersionRule("B");
        if (rule == null) {
            if (!isCreate) {
                return null;
            }
            ErrorCode ec = new ErrorCode("rule", ResManager.loadKDString((String)"\u672a\u627e\u5230\u9ed8\u8ba4\u7248\u672c\u89c4\u5219\uff0c\u65e0\u6cd5\u521b\u5efa\u5de5\u827a\u8def\u7ebf\u7248\u672c\u3002", (String)"ProcessRouteVersionUtils_01", (String)"bd-mpdm-common", (Object[])new Object[0]));
            throw new KDBizException(ec, new Object[0]);
        }
        int orderVersionSeq = 0;
        if (route.getDynamicObject("version") != null && ProcessRouteVersionUtils.isCheckSeq()) {
            orderVersionSeq = ProcessRouteVersionUtils.getSeqByOldversion(route.getDynamicObject("version"));
        }
        return (newRouteVersion = ProcessRouteVersionUtils.getRouteVersion(processType, route.getDynamicObjectType().getName(), createorg, material, materialGroup, rule, (Long)route.getPkValue(), unVersionIdSet, orderVersionSeq)) == null && isCreate ? ProcessRouteVersionUtils.createRouteVersion(createorg, material, materialGroup, rule, (Long)route.getPkValue(), orderVersionSeq) : newRouteVersion;
    }

    public static DynamicObject getInitProcessVersion(String processType, String entityNumber, DynamicObject createorg, DynamicObject material, DynamicObject materialGroup) {
        DynamicObject rule = ProcessRouteVersionUtils.getDefaultVersionRule("B");
        return rule == null ? null : ProcessRouteVersionUtils.getRouteVersion(processType, entityNumber, createorg, material, materialGroup, rule, 0L);
    }

    public static DynamicObject getRouteVersion(String processType, String entityNumber, DynamicObject createorg, DynamicObject material, DynamicObject materialGroup, DynamicObject rule, Long routeId) {
        return ProcessRouteVersionUtils.getRouteVersion(processType, entityNumber, createorg, material, materialGroup, rule, routeId, null, 0);
    }

    private static QFilter buildQFilter(String processType, DynamicObject material, DynamicObject materialGroup, DynamicObject rule) {
        QFilter qFilter = new QFilter("bomversionrule", "=", rule.getPkValue());
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("type", "=", (Object)"B"));
        if ("A".equals(processType)) {
            qFilter.and(new QFilter("material", "=", material == null ? Long.valueOf(-1L) : material.getPkValue()));
            qFilter.and(new QFilter("materialgroup", "=", (Object)0L));
        } else if ("B".equals(processType)) {
            qFilter.and(new QFilter("material", "=", (Object)0L));
            qFilter.and(new QFilter("materialgroup", "=", materialGroup == null ? Long.valueOf(-1L) : materialGroup.getPkValue()));
        } else {
            qFilter.and(new QFilter("material", "=", (Object)0L));
            qFilter.and(new QFilter("materialgroup", "=", (Object)0L));
        }
        return qFilter;
    }

    public static DynamicObject getRouteVersion(String processType, String entityNumber, DynamicObject createorg, DynamicObject material, DynamicObject materialGroup, DynamicObject rule, Long routeId, Set<Long> unVersionIdSet, int oldVersionSeq) {
        DynamicObjectCollection coll;
        Set versionIdSet;
        if (rule == null) {
            return null;
        }
        QFilter qFilter = ProcessRouteVersionUtils.buildQFilter(processType, material, materialGroup, rule);
        if (unVersionIdSet != null && !unVersionIdSet.isEmpty()) {
            qFilter.and(new QFilter("id", "not in", unVersionIdSet));
        }
        Date date = new Date();
        QFilter qFilterDate = new QFilter("effectdate", "<=", (Object)date);
        qFilterDate.and(new QFilter("invaliddate", ">", (Object)date));
        if (oldVersionSeq > 0) {
            qFilter.and(new QFilter("versionname.entryseq", "=", (Object)oldVersionSeq));
        }
        if ((versionIdSet = (coll = QueryServiceHelper.query((String)KEY_ENTITY_VERSION, (String)"id,name,versionname.entryseq entryseq", (QFilter[])new QFilter[]{qFilter, qFilterDate}, (String)"versionname.entryseq desc")).stream().map(p -> p.getLong("id")).collect(Collectors.toSet())) == null || versionIdSet.isEmpty()) {
            return null;
        }
        List<Long> versionIdList = coll.stream().map(p -> p.getLong("id")).collect(Collectors.toList());
        if (oldVersionSeq > 0) {
            return ProcessRouteVersionUtils.getCurrentVersionById((Long)versionIdList.get(0));
        }
        qFilter = new QFilter("routeversion", "in", versionIdSet);
        if ("A".equals(processType)) {
            qFilter.and(new QFilter("material", "=", material == null ? Long.valueOf(-1L) : material.getPkValue()));
        } else if ("B".equals(processType)) {
            qFilter.and(new QFilter("materialgroup", "=", materialGroup == null ? Long.valueOf(-1L) : materialGroup.getPkValue()));
        } else {
            qFilter.and(new QFilter("material", "=", (Object)0L));
            qFilter.and(new QFilter("materialgroup", "=", (Object)0L));
        }
        qFilter.and(new QFilter("id", "<>", (Object)routeId));
        qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)entityNumber, (Long)createorg.getLong("id")));
        DynamicObjectCollection routeVersionColl = QueryServiceHelper.query((String)entityNumber, (String)"routeversion", (QFilter[])new QFilter[]{qFilter}, (String)"");
        Set<Long> routeVersionIdSet = routeVersionColl.stream().map(p -> p.getLong("routeversion")).collect(Collectors.toSet());
        Long maxVersionId = ProcessRouteVersionUtils.getNotUsedVersionId(versionIdList, routeVersionIdSet);
        return maxVersionId == null || maxVersionId.equals(0L) ? null : ProcessRouteVersionUtils.getCurrentVersionById(maxVersionId);
    }

    public static Long getNotUsedVersionId(List<Long> versionIdList, Set<Long> routeVersionIdSet) {
        int maxSeq = -1;
        int size = versionIdList.size();
        int i = 0;
        while (i < size) {
            Long id = versionIdList.get(i);
            if (routeVersionIdSet.contains(id)) {
                maxSeq = i - 1;
                break;
            }
            maxSeq = i++;
        }
        return maxSeq >= 0 ? versionIdList.get(maxSeq) : Long.valueOf(0L);
    }

    public static DynamicObject createRouteVersion(DynamicObject createorg, DynamicObject material, DynamicObject materialGroup, DynamicObject rule, Long srcBillId, int oldVersionSeq) {
        DynamicObject versionDy = ProcessRouteVersionUtils.getAutoVersionWithDynamicObject((Long)createorg.getPkValue(), ProcessRouteVersionUtils.getDynamicObjectId(material), ProcessRouteVersionUtils.getDynamicObjectId(materialGroup), (Long)rule.getPkValue(), oldVersionSeq);
        if (versionDy == null) {
            ErrorCode ec = new ErrorCode("version", ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7248\u672c\u53f7\uff0c\u4e0d\u5141\u8bb8\u521b\u5efa\u5de5\u827a\u8def\u7ebf\u7248\u672c\u3002", (String)"ProcessRouteVersionUtils_02", (String)"bd-mpdm-common", (Object[])new Object[0]));
            throw new KDBizException(ec, new Object[0]);
        }
        return ProcessRouteVersionUtils.buildVersionData(versionDy, material, materialGroup, rule, createorg, "B", srcBillId);
    }

    private static Long getDynamicObjectId(DynamicObject dy) {
        Long id = 0L;
        if (dy != null) {
            id = (Long)dy.getPkValue();
        }
        return id;
    }

    public static DynamicObject getCurrentVersion(String processType, DynamicObject createorg, DynamicObject material, DynamicObject materialGroup, DynamicObject rule, Long srcBillId) {
        QFilter qFilter = ProcessRouteVersionUtils.buildQFilter(processType, material, materialGroup, rule);
        qFilter.and(new QFilter("srcbillid", "=", (Object)srcBillId));
        return ProcessRouteVersionUtils.getCurrentVersionByFilter(qFilter);
    }

    public static DynamicObject getCurrentVersionById(Long id) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        return ProcessRouteVersionUtils.getCurrentVersionByFilter(qFilter);
    }

    public static DynamicObject getCurrentVersionByFilter(QFilter qfilter) {
        return BusinessDataServiceHelper.loadSingle((String)KEY_ENTITY_VERSION, (String)ProcessRouteVersionUtils.getVersonSelectProperties(), (QFilter[])new QFilter[]{qfilter});
    }

    public static String getNum(DynamicObject material, DynamicObject materialGroup) {
        if (material != null) {
            return material.getString("number") + "-";
        }
        if (materialGroup != null) {
            return materialGroup.getString("number") + "-";
        }
        return "";
    }

    private static DynamicObject buildVersionData(DynamicObject versionDy, DynamicObject material, DynamicObject materialGroup, DynamicObject rule, DynamicObject createorg, String type, Long srcBillId) {
        String version = versionDy.getString("version");
        Long versionId = versionDy.getLong("id");
        DynamicObject bomversion = ORM.create().newDynamicObject(KEY_ENTITY_VERSION);
        String ruleNum = rule.getString("number");
        DynamicObject ruleEntry = BusinessDataServiceHelper.loadSingleFromCache((Object)versionId, (String)"bd_bomversionruleentry_f7");
        ILocaleString verName = ruleEntry.getLocaleString("version");
        String verNum = verName.getLocaleValue();
        String tag = "B".equals(type) ? "route" : ("C".equals(type) ? "formula" : "bom");
        String number = ProcessRouteVersionUtils.getNum(material, materialGroup) + ruleNum + "-" + tag + "-" + verNum;
        bomversion.set("number", (Object)number);
        bomversion.set("name", (Object)version);
        bomversion.set("type", (Object)type);
        bomversion.set("versionname", (Object)ruleEntry);
        bomversion.set("bomversionrule", (Object)rule);
        bomversion.set("material", (Object)material);
        bomversion.set("materialgroup", (Object)materialGroup);
        bomversion.set("createorg", (Object)createorg);
        bomversion.set("effectdate", (Object)ProcessRouteVersionUtils.getValidDate(null));
        bomversion.set("invaliddate", (Object)ProcessRouteVersionUtils.getInValidDate(null));
        bomversion.set("ctrlstrategy", (Object)"5");
        bomversion.set("enable", (Object)"1");
        bomversion.set("status", (Object)"C");
        bomversion.set("ecnbillno", (Object)"");
        bomversion.set("srcbillid", (Object)srcBillId);
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)KEY_ENTITY_VERSION, (DynamicObject[])new DynamicObject[]{bomversion}, (OperateOption)ProcessRouteVersionUtils.getOperateOption());
        if (!operateResult.isSuccess()) {
            StringBuilder sb = new StringBuilder();
            for (IOperateInfo info : operateResult.getAllErrorOrValidateInfo()) {
                sb.append(info.getMessage()).append('\n');
            }
            if (sb.length() <= 0) {
                sb.append(operateResult.getMessage());
            }
            ErrorCode ec = new ErrorCode("save", sb.toString());
            throw new KDBizException(ec, new Object[0]);
        }
        List addPkIds = operateResult.getSuccessPkIds();
        QFilter qFilter3 = new QFilter("id", "in", (Object)addPkIds);
        return ProcessRouteVersionUtils.getCurrentVersionByFilter(qFilter3);
    }

    private static String getVersonSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",number");
        sb.append(",name");
        sb.append(",material");
        sb.append(",materialgroup");
        sb.append(",ecnbillno");
        sb.append(",srcbillid");
        return sb.toString();
    }

    public static OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", "true");
        option.setVariableValue("ignoreinteraction", "true");
        option.setVariableValue("batchop_batchsize", "50");
        option.setVariableValue("needlog", String.valueOf(true));
        return option;
    }

    public static void updateProcessVersionSeq() {
        String orderBys = "createorg asc,effectivedate asc,name asc ";
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)KEY_ENTITY_OLDVERSION, (String)"id,createorg,orderseq", null, (String)orderBys);
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        int seq = 0;
        for (DynamicObject data : datas) {
            Long orgId = 0L;
            data.set("orderseq", (Object)0);
            DynamicObject createOrg = data.getDynamicObject("createorg");
            if (createOrg != null) {
                orgId = (Long)createOrg.getPkValue();
            }
            if (orgIdSet.add(orgId)) {
                seq = 0;
            }
            data.set("orderseq", (Object)(++seq));
        }
        SaveServiceHelper.save((DynamicObject[])datas);
    }
}

