/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.state.utils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.excel.ExecuteContext;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.ExprParser;
import kd.bos.formula.excel.MapExecuteContext;
import kd.bos.formula.excel.VerifyVisitor;
import kd.bos.formula.excel.Visitor;
import kd.bos.servicehelper.MetadataServiceHelper;

public class StateUtils {
    public static MainEntityType getMainEntityType(DynamicObject dy) {
        if (dy != null) {
            Object billentityPkValue = dy.getPkValue();
            return MetadataServiceHelper.getDataEntityType((String)billentityPkValue.toString());
        }
        return null;
    }

    public static void showConditionForm(String conditionJson, String entityNumber, String fieldNodes, String sourceCtrlKey, IFormView view, IFormPlugin plugin) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_condition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        String funcsXML = (String)view.getFormShowParameter().getCustomParam("functiontypes");
        if (StringUtils.isNotBlank((CharSequence)funcsXML)) {
            showParameter.getCustomParams().put("functiontypes", funcsXML);
        }
        showParameter.setCloseCallBack(new CloseCallBack(plugin, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public static void showBillFieldForm(String nodesJson, String custumparam, IFormView view, IFormPlugin plugin) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mpdm_billfieldselect");
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, custumparam));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public static void showBillFieldForm(Object params, String formId, String closeCallBack, IFormView view, IFormPlugin plugin) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.setCustomParam("treenodes", params);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, closeCallBack));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public static String getSelects(String ... vals) {
        if (vals != null && vals.length > 0) {
            HashSet selects = new HashSet();
            for (int i = 0; i < vals.length; ++i) {
                if (vals[i] == null) continue;
                String[] str = vals[i].split(",");
                selects.addAll(Arrays.stream(str).collect(Collectors.toSet()));
            }
            return StringUtils.join((Object[])selects.toArray(), (char)',');
        }
        return null;
    }

    public static void receiveCondition(String conditionJson, String entryEntityKey, String conditionFldKey, String descFldKey, IDataModel model) {
        if (StringUtils.isBlank((CharSequence)conditionJson)) {
            return;
        }
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
        if (StringUtils.isBlank((CharSequence)entryEntityKey)) {
            model.setValue(conditionFldKey, (Object)conditionJson);
            model.setValue(descFldKey, (Object)condition.getExprDesc());
        } else {
            int row = model.getEntryCurrentRowIndex(entryEntityKey);
            model.setValue(conditionFldKey, (Object)conditionJson, row);
            model.setValue(descFldKey, (Object)condition.getExprDesc(), row);
        }
    }

    public static String getConditionStr(String bill, String condition) {
        if (condition == null || condition.isEmpty()) {
            return "1=1";
        }
        CRCondition valByConditions = (CRCondition)SerializationUtils.fromJsonString((String)condition, CRCondition.class);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)bill);
        StringBuilder sb = new StringBuilder();
        sb.append("CASE");
        FilterCondition filterCondition = valByConditions.getFilterCondition();
        FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
        String[] strings = filterBuilder.buildFilterScript();
        String conditionFormula = strings[0];
        HashSet<String> formulaSrcFields = new HashSet<String>(8);
        conditionFormula = StateUtils.getConditionFormulaVariable(mainEntityType, conditionFormula, formulaSrcFields);
        return conditionFormula;
    }

    public static String getConditionStr(String bill, String condition, Set<String> formulaSrcFields) {
        if (condition == null || condition.isEmpty()) {
            return "1=1";
        }
        CRCondition valByConditions = (CRCondition)SerializationUtils.fromJsonString((String)condition, CRCondition.class);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)bill);
        StringBuilder sb = new StringBuilder();
        sb.append("CASE");
        FilterCondition filterCondition = valByConditions.getFilterCondition();
        FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
        String[] strings = filterBuilder.buildFilterScript();
        String conditionFormula = strings[0];
        String valFormula = valByConditions.getExpression();
        conditionFormula = StateUtils.getConditionFormulaVariable(mainEntityType, conditionFormula, formulaSrcFields);
        return conditionFormula;
    }

    public static String getConditionFormulaVariable(MainEntityType mainEntityType, String formula, Set<String> vars) {
        Expr expr = ExprParser.parse((String)formula);
        VerifyVisitor visitor = new VerifyVisitor((ExecuteContext)new MapExecuteContext());
        expr.accept((Visitor)visitor);
        List invalidSymboList = visitor.getInvalidSymboList();
        for (String s : invalidSymboList) {
            String absoluteFieldName = s = s.toLowerCase(Locale.ENGLISH);
            String[] str = s.split("\\.");
            if (str.length > 1 && mainEntityType.findProperty(str[0]) != null) {
                StringBuilder sb = new StringBuilder(StateUtils.getAbsolutePropertyName(mainEntityType.findProperty(str[0])).toLowerCase(Locale.ENGLISH));
                for (int i = 1; i < str.length; ++i) {
                    sb.append('.').append(str[i]);
                }
                absoluteFieldName = sb.toString();
            } else {
                if (mainEntityType.findProperty(s) == null) continue;
                absoluteFieldName = StateUtils.getAbsolutePropertyName(mainEntityType.findProperty(s)).toLowerCase(Locale.ENGLISH);
            }
            vars.add(absoluteFieldName);
            if (!absoluteFieldName.equals(s)) {
                formula = formula.replaceAll("\\(" + s + " ", "(" + absoluteFieldName + " ");
                formula = formula.replaceAll(" " + s + "\\)", " " + absoluteFieldName + ")");
                formula = formula.replaceAll(" " + s + " ", " " + absoluteFieldName + " ");
            }
            if (!formula.contains("EMPTY_TO_TEXT")) continue;
            if (formula.contains("!=")) {
                formula = String.format("( %s is not null )", absoluteFieldName);
                continue;
            }
            formula = String.format("( %s is null )", absoluteFieldName);
        }
        return formula;
    }

    private static String getAbsolutePropertyName(IDataEntityProperty property) {
        StringBuilder fieldName = new StringBuilder();
        Stack<String> stack = new Stack<String>();
        if (property != null) {
            stack.push(property.getName());
            if (property.getParent() != null && property.getParent() instanceof EntryType) {
                EntryType parent = (EntryType)property.getParent();
                stack.push(parent.getName());
                while (parent.getParent() != null && parent.getParent() instanceof EntryType) {
                    parent = (EntryType)parent.getParent();
                    stack.push(parent.getName());
                }
            }
        }
        while (!stack.isEmpty()) {
            fieldName.append((String)stack.pop()).append('.');
        }
        if (fieldName.length() > 0) {
            return fieldName.substring(0, fieldName.length() - 1);
        }
        return fieldName.toString();
    }

    public static String getConditionPro(String condition) {
        if (condition == null || condition.isEmpty()) {
            return null;
        }
        CRCondition valByConditions = (CRCondition)SerializationUtils.fromJsonString((String)condition, CRCondition.class);
        List list = valByConditions.getFilterCondition().getFilterRow();
        StringBuilder sb = new StringBuilder();
        if (!list.isEmpty()) {
            for (SimpleFilterRow simpleFilterRow : list) {
                sb.append(simpleFilterRow.getFieldName());
                sb.append(',');
            }
            sb.substring(sb.length() - 1);
            return sb.toString().substring(0, sb.length() - 1);
        }
        return null;
    }

    public static Boolean isPrefabricatedData(String number) {
        HashSet<String> numbers = new HashSet<String>(8);
        numbers.add("ZTGZ-001_S");
        numbers.add("ZTGZ-002_S");
        numbers.add("ZTGZ-003_S");
        numbers.add("ZTGZ-004_S");
        numbers.add("ZTGZ-005_S");
        numbers.add("ZTFA-001_S");
        numbers.add("ZTCL-001_S");
        return numbers.contains(number);
    }
}

