/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.stockchange.utils;

import java.math.BigDecimal;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.stockchange.utils.ChangeConfigUtils;
import kd.bd.mpdm.common.stockchange.utils.EntityNameUtils;
import kd.bd.mpdm.common.stockchange.utils.StockChangeUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class StockChangeImportUtils {
    private StockChangeImportUtils() {
    }

    public static void changeManuBillAfterSubmit(DynamicObject stockChangeEntry, DynamicObject stockChangeBill, DynamicObject stock) {
        String changeType = stockChangeEntry.getString("entrychangetype");
        if (StringUtils.equals((CharSequence)"A", (CharSequence)changeType)) {
            StockChangeImportUtils.changeBillForNew(stockChangeEntry, stockChangeBill, stock);
        } else if (StringUtils.equals((CharSequence)"B", (CharSequence)changeType)) {
            StockChangeImportUtils.changeBillForChange(stockChangeEntry, stockChangeBill, stock);
        }
    }

    private static void changeBillForChange(DynamicObject stockChangeEntry, DynamicObject stockChangeBill, DynamicObject stock) {
        String[] updateFields;
        String stockSeq = stockChangeEntry.getString("stockentryseq");
        DynamicObject stockDymOld = stock;
        if (stockDymOld == null) {
            return;
        }
        String stockeid = stockDymOld.getPkValue().toString();
        DynamicObject stockEntry = StockChangeImportUtils.getEntryIdBySeq(stockDymOld, stockSeq);
        if (stockEntry == null) {
            return;
        }
        String stockEntryid = stockEntry.getPkValue().toString();
        for (String fields : updateFields = ChangeConfigUtils.stockentryModifyfields) {
            stockChangeEntry.set(fields, stockEntry.get(fields));
        }
        stockChangeBill.set("org", stockDymOld.get("org"));
        stockChangeBill.set("transactiontypeid", stockDymOld.get("transactiontypeid"));
        stockChangeEntry.set("productno", stockDymOld.get("productid"));
        stockChangeEntry.set("productbaseunit", stockDymOld.get("baseunitid"));
        stockChangeEntry.set("productbaseqty", stockDymOld.get("baseqty"));
        stockChangeEntry.set("entryorderno", stockDymOld.get("orderno"));
        stockChangeEntry.set("entryorderentryid", stockDymOld.get("orderentryid"));
        stockChangeEntry.set("actissueqty", stockEntry.get("actissueqty"));
        stockChangeEntry.set("rejectedqty", stockEntry.get("rejectedqty"));
        stockChangeEntry.set("feedingqty", stockEntry.get("feedingqty"));
        stockChangeEntry.set("scrapqty", stockEntry.get("scrapqty"));
        stockChangeEntry.set("pstockentryid", stockEntry.get("pstockentryid"));
        DynamicObject materialInfo = stockChangeEntry.getDynamicObject("materialid");
        DynamicObject masterid = materialInfo.getDynamicObject("masterid");
        stockChangeEntry.set("materialunitid", (Object)masterid.getDynamicObject("baseunit"));
        stockChangeEntry.set("materielmasterid", (Object)masterid);
        StockChangeImportUtils.autoFillStockChange(stockChangeEntry, stockEntry.getString("qtytype"), stockDymOld);
        stockChangeEntry.set("stockid", (Object)stockeid);
        stockChangeEntry.set("stockentryid", (Object)stockEntryid);
        stockChangeEntry.set("entryidf", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)stockEntry.getPkValue(), (String)StockChangeUtils.getEntityName(1, 5, stock.getDataEntityType().getName())));
    }

    private static void changeBillForNew(DynamicObject stockChangeEntry, DynamicObject stockChangeBill, DynamicObject stock) {
        DynamicObject stockDymOld = stock;
        if (stockDymOld == null) {
            return;
        }
        String stockeid = stockDymOld.getPkValue().toString();
        stockChangeBill.set("org", stockDymOld.get("org"));
        DynamicObject tran = stockDymOld.getDynamicObject("transactiontypeid");
        stockChangeBill.set("transactiontypeid", (Object)tran);
        stockChangeEntry.set("productno", stockDymOld.get("productid"));
        stockChangeEntry.set("productbaseunit", stockDymOld.get("baseunitid"));
        stockChangeEntry.set("productbaseqty", stockDymOld.get("baseqty"));
        stockChangeEntry.set("entryorderno", stockDymOld.get("orderno"));
        stockChangeEntry.set("entryorderentryid", stockDymOld.get("orderentryid"));
        DynamicObject materialInfo = stockChangeEntry.getDynamicObject("materialid");
        DynamicObject masterid = materialInfo.getDynamicObject("masterid");
        if (StringUtils.isBlank((CharSequence)stockChangeEntry.getString("backflushtime"))) {
            stockChangeEntry.set("backflushtime", tran.get("backflushtime"));
        }
        StockChangeImportUtils.autoFillStockNew(stockChangeEntry);
        stockChangeEntry.set("materialunitid", (Object)masterid.getDynamicObject("baseunit"));
        stockChangeEntry.set("materielmasterid", (Object)masterid);
        String qtyType = stockChangeEntry.getString("qtytype");
        if (!("A".equals(qtyType) || "B".equals(qtyType) || "C".equals(qtyType))) {
            qtyType = "A";
        }
        StockChangeImportUtils.autoFillStockChange(stockChangeEntry, qtyType, stockDymOld);
        stockChangeEntry.set("stockid", (Object)stockeid);
    }

    public static void autoFillStockNew(DynamicObject stockChangeEntry) {
        DynamicObject oldMaterialInfo = stockChangeEntry.getDynamicObject("materialid");
        DynamicObject materialInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)oldMaterialInfo.getPkValue(), (String)"bd_materialmftinfo");
        DynamicObject outstorageunit = materialInfo.getDynamicObject("outstorageunit");
        DynamicObject outwarehouse = materialInfo.getDynamicObject("outwarehouse");
        DynamicObject outwarelocation = materialInfo.getDynamicObject("outwarelocation");
        DynamicObject supplyorgunitid = materialInfo.getDynamicObject("supplyorgunitid");
        DynamicObject warehouse = materialInfo.getDynamicObject("warehouse");
        DynamicObject location = materialInfo.getDynamicObject("location");
        if (stockChangeEntry.getDynamicObject("outorgunitid") == null) {
            stockChangeEntry.set("outorgunitid", (Object)outstorageunit);
        }
        if (stockChangeEntry.getDynamicObject("outwarehouseid") == null && outwarehouse != null) {
            stockChangeEntry.set("outwarehouseid", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)outwarehouse.getPkValue(), (String)"bd_warehouse"));
        }
        if (stockChangeEntry.getDynamicObject("outlocation") == null) {
            stockChangeEntry.set("outlocation", (Object)outwarelocation);
        }
        if (stockChangeEntry.getDynamicObject("supplyorgid") == null) {
            stockChangeEntry.set("supplyorgid", (Object)supplyorgunitid);
        }
        if (stockChangeEntry.getDynamicObject("warehouseid") == null && warehouse != null) {
            stockChangeEntry.set("warehouseid", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)warehouse.getPkValue(), (String)"bd_warehouse"));
        }
        if (stockChangeEntry.getDynamicObject("location") == null) {
            stockChangeEntry.set("location", (Object)location);
        }
    }

    private static DynamicObject getEntryIdBySeq(DynamicObject stockDymOld, String stockSeq) {
        DynamicObjectCollection entryCol = stockDymOld.getDynamicObjectCollection("stockentry");
        if (entryCol == null) {
            return null;
        }
        for (DynamicObject stockBillEntry : entryCol) {
            if (!StringUtils.equals((CharSequence)stockBillEntry.getString("seq"), (CharSequence)stockSeq)) continue;
            return stockBillEntry;
        }
        return null;
    }

    public static void autoFillStockChange(DynamicObject stockChangeEntry, String qtyType, DynamicObject stockDymOld) {
        stockChangeEntry.set("qtytype", (Object)qtyType);
        DynamicObject baseUnit = stockChangeEntry.getDynamicObject("materialunitid");
        int precision = 2;
        if (baseUnit != null) {
            precision = baseUnit.get("precision") == null ? 2 : baseUnit.getInt("precision");
        }
        BigDecimal useratio = stockChangeEntry.getBigDecimal("useratio").divide(BigDecimal.valueOf(100L), 4, 4);
        BigDecimal orderQty = stockChangeEntry.getBigDecimal("productbaseqty");
        BigDecimal qtynumerator = stockChangeEntry.getBigDecimal("qtynumerator");
        BigDecimal qtydenominator = stockChangeEntry.getBigDecimal("qtydenominator");
        String wastagerateformula = stockChangeEntry.getString("wastagerateformula");
        if (!"A".equals(wastagerateformula) && !"B".equals(wastagerateformula)) {
            wastagerateformula = "B";
            stockChangeEntry.set("wastagerateformula", (Object)wastagerateformula);
        }
        stockChangeEntry.set("standqty", (Object)MPDMMftGenStocksUtils.calculateStandQty(baseUnit, qtyType, useratio, orderQty, qtynumerator, qtydenominator));
        BigDecimal standqty = stockChangeEntry.getBigDecimal("standqty");
        BigDecimal scraprate = stockChangeEntry.getBigDecimal("scraprate");
        BigDecimal fixscrap = stockChangeEntry.getBigDecimal("fixscrap");
        stockChangeEntry.set("demandqty", (Object)MPDMMftGenStocksUtils.calculateDemadQty(precision, stockDymOld.getBoolean("transactiontypeid.isconsiderloss"), standqty, scraprate, fixscrap, wastagerateformula));
        stockChangeEntry.set("extraratioqty", (Object)stockChangeEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.add(stockChangeEntry.getBigDecimal("issinhighlimit").divide(BigDecimal.valueOf(100L), 4, 4))));
        stockChangeEntry.set("lackraitioqty", (Object)stockChangeEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.subtract(stockChangeEntry.getBigDecimal("issinlowlimit").divide(BigDecimal.valueOf(100L), 4, 4))));
        stockChangeEntry.set("actissueqty", MPDMMftGenStocksUtils.aculActissueQty(stockChangeEntry));
        stockChangeEntry.set("cansendqty", MPDMMftGenStocksUtils.aculCanSendQty(stockChangeEntry));
        stockChangeEntry.set("unissueqty", MPDMMftGenStocksUtils.aculUnSendQty(stockChangeEntry));
        String stockName = stockDymOld.getDataEntityType().getName();
        stockChangeEntry.set("useqty", (Object)MPDMMftGenStocksUtils.aculUseQty(stockChangeEntry, stockDymOld.getDynamicObject("orderentryid").getPkValue(), stockDymOld.getDynamicObject("transactiontypeid"), EntityNameUtils.getEntityName(1, 0, stockName)));
        stockChangeEntry.set("wipqty", (Object)MPDMMftGenStocksUtils.aculWIPQty(stockChangeEntry));
    }
}

