/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.stockchange.utils;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import kd.bd.mpdm.common.stockchange.utils.ChangeObject;
import kd.bd.mpdm.common.stockchange.utils.StockChangeUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class StockChangeLogUtils {
    private static final Log logger = LogFactory.getLog(StockChangeLogUtils.class);

    private StockChangeLogUtils() {
    }

    public static DynamicObject addChangeLog(List<ChangeObject> changelist, DynamicObject stockChangeEntry, DynamicObject stockChangeBill) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)StockChangeUtils.getEntityName(3, 4, stockChangeBill.getDataEntityType().getName()));
        DynamicObject xmftstocklog = (DynamicObject)dt.createInstance();
        xmftstocklog.set("stockchangeid", stockChangeBill.getPkValue());
        xmftstocklog.set("stockchangeentryid", stockChangeEntry.getPkValue());
        xmftstocklog.set("changeno", stockChangeBill.get("billno"));
        xmftstocklog.set("org", stockChangeBill.get("org"));
        xmftstocklog.set("creator", stockChangeBill.get("creator"));
        xmftstocklog.set("createtime", stockChangeBill.get("createtime"));
        xmftstocklog.set("reason", stockChangeBill.get("reason"));
        xmftstocklog.set("billstatus", (Object)"A");
        xmftstocklog.set("entryidf", stockChangeEntry.get("entryidf"));
        xmftstocklog.set("stockno", stockChangeEntry.get("stockno"));
        xmftstocklog.set("stockentryid", stockChangeEntry.get("stockentryid"));
        xmftstocklog.set("stockid", stockChangeEntry.get("stockid"));
        xmftstocklog.set("stockchangeentryseq", (Object)stockChangeEntry.getString("seq"));
        String entrychangetype = stockChangeEntry.getString("entrychangetype");
        DynamicObjectCollection entryentity = xmftstocklog.getDynamicObjectCollection("entryentity");
        DynamicObject addNew = entryentity.addNew();
        StockChangeLogUtils.createStockChangeLogEntry(stockChangeEntry, changelist, entrychangetype, addNew);
        return xmftstocklog;
    }

    public static void createStockChangeLogEntry(DynamicObject stockChangeEntry, List<ChangeObject> changelist, String entrychangetype, DynamicObject addNew) {
        DynamicObject materialUnitid = stockChangeEntry.getDynamicObject("materialunitid");
        int precision = materialUnitid == null ? 4 : materialUnitid.getInt("precision");
        DynamicObject materialProdInfo = stockChangeEntry.getDynamicObject("materialid");
        addNew.set("materialid", (Object)materialProdInfo);
        for (ChangeObject changeObject : changelist) {
            String colName;
            DataEntityPropertyCollection properties = addNew.getDynamicObjectType().getProperties();
            boolean containsKey = properties.containsKey((Object)(colName = changeObject.getColName()));
            if (!containsKey) continue;
            Object newValue = changeObject.getNewValue();
            Object oldValue = changeObject.getOldValue();
            if (StringUtils.equals((CharSequence)"qtytype", (CharSequence)colName)) {
                addNew.set("qtytype", newValue);
                continue;
            }
            if (StringUtils.equals((CharSequence)"A", (CharSequence)entrychangetype)) {
                if (StringUtils.equals((CharSequence)"childauxpropertyid", (CharSequence)colName)) {
                    StockChangeLogUtils.replaceJSONObject(newValue, colName, addNew);
                    continue;
                }
                StockChangeLogUtils.addNewEntryValue(newValue, colName, precision, addNew);
                continue;
            }
            if (StringUtils.equals((CharSequence)"childauxpropertyid", (CharSequence)colName)) {
                StockChangeLogUtils.replaceJSONObject(oldValue, newValue, colName, addNew);
                continue;
            }
            StockChangeLogUtils.repalce(oldValue, newValue, colName, addNew, precision);
        }
        addNew.set("entrychangetype", (Object)entrychangetype);
    }

    public static List<ChangeObject> getChangeFieldList(DynamicObject stockBillEntry, DynamicObject stockChangeEntry, String stockChangeName) {
        Set<String> stockFields = StockChangeUtils.getAllStockEentryFields(stockChangeName);
        ArrayList<ChangeObject> changelist = new ArrayList<ChangeObject>(stockFields.size());
        Object stockfield = null;
        Object stockchangefield = null;
        for (String stockField : stockFields) {
            if ("childauxpropertyid".equals(stockField)) {
                Object stockBillField = stockBillEntry.get(stockField);
                Object stockChangeField = stockChangeEntry.get(stockField);
                StockChangeLogUtils.settleAuxProperty(stockField, stockBillField, stockChangeField, changelist);
                continue;
            }
            stockfield = StockChangeLogUtils.getStockChangeField(stockField, stockBillEntry);
            stockchangefield = StockChangeLogUtils.getStockChangeField(stockField, stockChangeEntry);
            StockChangeLogUtils.setChangeFieldList(changelist, stockfield, stockchangefield, stockField);
        }
        return changelist;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void settleAuxProperty(String stockField, Object stockBillField, Object stockChangeField, List<ChangeObject> changelist) {
        changeObject = new ChangeObject();
        changeObject.setColName(stockField);
        stockBillJson = StockChangeLogUtils.getBaseAux(stockBillField);
        stockChangeJson = StockChangeLogUtils.getBaseAux(stockChangeField);
        stockBillSet = stockBillJson.keySet();
        stockChangeSet = stockChangeJson.keySet();
        stockSet = new HashSet<E>();
        stockSet.addAll(stockBillSet);
        stockSet.addAll(stockChangeSet);
        newStockBillJson = new JSONObject();
        newStockChangeJson = new JSONObject();
        for (String property : stockSet) {
            stockBillProperty = stockBillJson.get((Object)property);
            stockChangeProperty = stockChangeJson.get((Object)property);
            newStockBillJson.put(property, stockBillProperty);
            newStockChangeJson.put(property, stockChangeProperty);
        }
        stockRes = new JSONObject();
        changeRes = new JSONObject();
        rows = QueryServiceHelper.queryDataSet((String)"settleAuxProperty", (String)"bd_auxproperty", (String)"flexfield,name,valuetype,valuesource,assistanttype", (QFilter[])new QFilter[]{new QFilter("flexfield", "in", stockSet)}, null);
        var15_15 = null;
        try {
            block31: while (rows.hasNext()) {
                next = rows.next();
                name = next.getString("name");
                valuetype = next.getInteger("valuetype");
                valuesource = next.getString("valuesource");
                flexfield = next.getString("flexfield");
                switch (valuetype) {
                    case 1: {
                        ids = new ArrayList<Long>();
                        stock = newStockBillJson.getLong(flexfield) == null ? Long.valueOf(0L) : newStockBillJson.getLong(flexfield);
                        change = newStockChangeJson.getLong(flexfield) == null ? Long.valueOf(0L) : newStockChangeJson.getLong(flexfield);
                        ids.add(stock);
                        ids.add(change);
                        stockRes.put(name, (Object)"");
                        changeRes.put(name, (Object)"");
                        dataResult = QueryServiceHelper.queryDataSet((String)"queryBaseData", (String)valuesource, (String)(StockChangeLogUtils.getNameProperty(valuesource) + " AS name,id"), (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}, (String)"");
                        var25_27 = null;
                        try {
                            while (dataResult.hasNext()) {
                                row = dataResult.next();
                                res = row.getString("name");
                                id /* !! */  = row.getLong("id");
                                if (stock.equals(id /* !! */ )) {
                                    stockRes.put(name, (Object)res);
                                }
                                if (!change.equals(id /* !! */ )) continue;
                                changeRes.put(name, (Object)res);
                            }
                            if (dataResult == null) continue block31;
                            if (var25_27 != null) {
                            }
                            ** GOTO lbl85
                        }
                        catch (Throwable row) {
                            try {
                                var25_27 = row;
                                throw row;
                            }
                            catch (Throwable var29_34) {
                                if (dataResult == null) throw var29_34;
                                if (var25_27 == null) {
                                    dataResult.close();
                                    throw var29_34;
                                }
                                try {
                                    dataResult.close();
                                    throw var29_34;
                                }
                                catch (Throwable var30_38) {
                                    var25_27.addSuppressed(var30_38);
                                    throw var29_34;
                                }
                            }
                        }
                        try {
                            dataResult.close();
                        }
                        catch (Throwable row) {
                            var25_27.addSuppressed(row);
                        }
                        continue block31;
lbl85:
                        // 1 sources

                        dataResult.close();
                        break;
                    }
                    case 2: {
                        masterids = new ArrayList<Long>();
                        stock1 = newStockBillJson.getLong(flexfield) == null ? Long.valueOf(0L) : newStockBillJson.getLong(flexfield);
                        change1 = newStockChangeJson.getLong(flexfield) == null ? Long.valueOf(0L) : newStockChangeJson.getLong(flexfield);
                        masterids.add(stock1);
                        masterids.add(change1);
                        stockRes.put(name, (Object)"");
                        changeRes.put(name, (Object)"");
                        dataSet = QueryServiceHelper.queryDataSet((String)"queryAssiatantData", (String)"bos_assistantdata_detail", (String)"name,masterid", (QFilter[])new QFilter[]{new QFilter("masterid", "in", masterids)}, (String)"");
                        id /* !! */  = null;
                        try {
                            while (dataSet.hasNext()) {
                                row = dataSet.next();
                                res = row.getString("name");
                                id = row.getLong("masterid");
                                if (stock1.equals(id)) {
                                    stockRes.put(name, (Object)res);
                                }
                                if (!change1.equals(id)) continue;
                                changeRes.put(name, (Object)res);
                            }
                            if (dataSet == null) continue block31;
                            if (id /* !! */  != null) {
                            }
                            ** GOTO lbl138
                        }
                        catch (Throwable var29_36) {
                            try {
                                id /* !! */  = var29_36;
                                throw var29_36;
                            }
                            catch (Throwable var32_40) {
                                if (dataSet == null) throw var32_40;
                                if (id /* !! */  == null) {
                                    dataSet.close();
                                    throw var32_40;
                                }
                                try {
                                    dataSet.close();
                                    throw var32_40;
                                }
                                catch (Throwable var33_41) {
                                    id /* !! */ .addSuppressed(var33_41);
                                    throw var32_40;
                                }
                            }
                        }
                        try {
                            dataSet.close();
                        }
                        catch (Throwable var29_35) {
                            id /* !! */ .addSuppressed(var29_35);
                        }
                        continue block31;
lbl138:
                        // 1 sources

                        dataSet.close();
                        break;
                    }
                    case 3: {
                        stock2 = newStockBillJson.getString(flexfield) == null ? "" : newStockBillJson.getString(flexfield);
                        change2 = newStockChangeJson.getString(flexfield) == null ? "" : newStockChangeJson.getString(flexfield);
                        stockRes.put(name, (Object)stock2);
                        changeRes.put(name, (Object)change2);
                        continue block31;
                    }
                }
            }
            changeObject.setOldValue(stockRes);
            changeObject.setNewValue(changeRes);
            changelist.add(changeObject);
            return;
        }
        catch (Throwable var16_18) {
            var15_15 = var16_18;
            throw var16_18;
        }
        finally {
            if (rows != null) {
                if (var15_15 != null) {
                    try {
                        rows.close();
                    }
                    catch (Throwable var16_17) {
                        var15_15.addSuppressed(var16_17);
                    }
                } else {
                    rows.close();
                }
            }
        }
    }

    private static JSONObject getBaseAux(Object obj) {
        JSONObject res = new JSONObject();
        if (obj instanceof DynamicObject) {
            String value = ((DynamicObject)obj).get("value").toString();
            res = JSONObject.parseObject((String)value);
        } else if (obj instanceof Long && (Long)obj != 0L) {
            Long value;
            String key;
            Row next;
            QFilter hx = new QFilter("hx", "=", obj);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryaux_getBaseAux", (String)"bd_flexauxprop_bd", (String)"auxproptype,auxpropval", (QFilter[])new QFilter[]{hx}, (String)"");){
                while (ds.hasNext()) {
                    next = ds.next();
                    key = next.getString("auxproptype");
                    value = next.getLong("auxpropval");
                    res.put(key, (Object)value);
                }
            }
            ds = QueryServiceHelper.queryDataSet((String)"queryaux_getText", (String)"bd_flexauxprop_txt", (String)"auxproptype,auxpropval", (QFilter[])new QFilter[]{hx}, (String)"");
            var4_5 = null;
            try {
                while (ds.hasNext()) {
                    next = ds.next();
                    key = next.getString("auxproptype");
                    value = next.getLong("auxpropval");
                    res.put(key, (Object)value);
                }
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (var4_5 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            var4_5.addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        return res;
    }

    private static String getNameProperty(String source) {
        String billEntityTypeId = FormMetadataCache.getFormConfig((String)source).getEntityTypeId();
        BasedataEntityType entityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)billEntityTypeId);
        return entityType.getNameProperty();
    }

    public static List<ChangeObject> getChangeFieldList(DynamicObject stockChangeEntry, String stockChangeName) {
        Set<String> stockFields = StockChangeUtils.getAllStockEentryFields(stockChangeName);
        Object stockchangefield = null;
        ArrayList<ChangeObject> changelist = new ArrayList<ChangeObject>(stockFields.size());
        for (String stockField : stockFields) {
            if ("childauxpropertyid".equals(stockField)) {
                StockChangeLogUtils.settleAddNewAuxProperty(stockField, stockChangeEntry, changelist);
                continue;
            }
            stockchangefield = StockChangeLogUtils.getStockChangeField(stockField, stockChangeEntry);
            StockChangeLogUtils.setChangeFieldList(changelist, "", stockchangefield, stockField);
        }
        return changelist;
    }

    private static void settleAddNewAuxProperty(String stockField, DynamicObject stockChangeEntry, List<ChangeObject> changelist) {
        Object o = stockChangeEntry.get(stockField);
        StockChangeLogUtils.settleAuxProperty(stockField, null, o, changelist);
    }

    private static Object getStockChangeField(String stockField, DynamicObject stockChangeEntry) {
        Object stockchangefield = stockChangeEntry.get(stockField);
        if (StringUtils.isBlank((Object)stockchangefield)) {
            stockchangefield = "";
        }
        return stockchangefield;
    }

    private static void setChangeFieldList(List<ChangeObject> changelist, Object stockfield, Object stockchangefield, String stockField) {
        ChangeObject changefield = new ChangeObject();
        changefield.setColName(stockField);
        changefield.setNewValue(StockChangeLogUtils.getValue(stockField, stockchangefield));
        changefield.setOldValue(StockChangeLogUtils.getValue(stockField, stockfield));
        changelist.add(changefield);
    }

    public static void addNewEntryValue(Object newValue, String colName, int precision, DynamicObject addNew) {
        String newValueString = "";
        if (newValue instanceof Boolean) {
            newValueString = StockChangeLogUtils.replaceBooleanField(newValue);
        } else if (newValue instanceof Date) {
            newValueString = new SimpleDateFormat("yyyy/MM/dd HH:mm").format((Date)newValue);
        } else if (StringUtils.equals((CharSequence)"supplymode", (CharSequence)colName)) {
            newValueString = StockChangeLogUtils.replaceSupplyMode(newValue);
        } else if (StringUtils.equals((CharSequence)"wastagerateformula", (CharSequence)colName)) {
            newValueString = StockChangeLogUtils.replaceWastagerateFormula(newValue);
        } else if (StringUtils.equals((CharSequence)"overissuecontrl", (CharSequence)colName)) {
            newValueString = StockChangeLogUtils.replaceOverissueContrl(newValue);
        } else if (StringUtils.equals((CharSequence)"issuemode", (CharSequence)colName)) {
            newValueString = StockChangeLogUtils.replaceIssuemode(newValue);
        } else if (StringUtils.equals((CharSequence)"isbackflush", (CharSequence)colName)) {
            newValueString = StockChangeLogUtils.replaceIsbackflush(newValue);
        } else if (StringUtils.equals((CharSequence)"scraprate", (CharSequence)colName)) {
            newValueString = ((BigDecimal)newValue).stripTrailingZeros().toPlainString();
        } else if (newValue instanceof BigDecimal) {
            int scale = ((BigDecimal)newValue).scale();
            int scalePrecision = scale > precision ? precision : scale;
            BigDecimal newValueBigDecimal = ((BigDecimal)newValue).setScale(scalePrecision, 4);
            newValueString = newValueBigDecimal.toEngineeringString();
        } else {
            newValueString = String.valueOf(newValue);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)newValueString, (CharSequence)"null") && newValueString.isEmpty()) {
            newValueString = ResManager.loadKDString((String)"\u65e0", (String)"StockChangeLogUtils_0", (String)"bd-mpdm-common", (Object[])new Object[0]);
            String errMsg = String.format("addNewEntryValue newValue=%s;colName=%s", newValue, colName);
            logger.info(errMsg);
        }
        addNew.set(colName, (Object)newValueString);
    }

    public static String getOldValueAndNewValue(Object oldValue, Object newValue, String colName, int precision) {
        String oldValueString = null;
        String newValueString = null;
        try {
            oldValueString = "";
            newValueString = "";
            if (newValue instanceof Boolean) {
                oldValueString = StockChangeLogUtils.replaceBooleanField(oldValue);
                newValueString = StockChangeLogUtils.replaceBooleanField(newValue);
            } else if (newValue instanceof Date || oldValue instanceof Timestamp) {
                if (oldValue instanceof Date) {
                    oldValueString = new SimpleDateFormat("yyyy/MM/dd HH:mm").format((Date)oldValue);
                }
                if (newValue instanceof Date) {
                    newValueString = new SimpleDateFormat("yyyy/MM/dd HH:mm").format((Date)newValue);
                }
            } else if (StringUtils.equals((CharSequence)"supplymode", (CharSequence)colName)) {
                oldValueString = StockChangeLogUtils.replaceSupplyMode(oldValue);
                newValueString = StockChangeLogUtils.replaceSupplyMode(newValue);
            } else if (StringUtils.equals((CharSequence)"wastagerateformula", (CharSequence)colName)) {
                oldValueString = StockChangeLogUtils.replaceWastagerateFormula(oldValue);
                newValueString = StockChangeLogUtils.replaceWastagerateFormula(newValue);
            } else if (StringUtils.equals((CharSequence)"overissuecontrl", (CharSequence)colName)) {
                oldValueString = StockChangeLogUtils.replaceOverissueContrl(oldValue);
                newValueString = StockChangeLogUtils.replaceOverissueContrl(newValue);
            } else if (StringUtils.equals((CharSequence)"issuemode", (CharSequence)colName)) {
                oldValueString = StockChangeLogUtils.replaceIssuemode(oldValue);
                newValueString = StockChangeLogUtils.replaceIssuemode(newValue);
            } else if (StringUtils.equals((CharSequence)"isbackflush", (CharSequence)colName)) {
                oldValueString = StockChangeLogUtils.replaceIsbackflush(oldValue);
                newValueString = StockChangeLogUtils.replaceIsbackflush(newValue);
            } else if (oldValue instanceof BigDecimal) {
                int scale = ((BigDecimal)newValue).scale();
                int scalePrecision = scale > precision ? precision : scale;
                BigDecimal newValueBigDecimal = ((BigDecimal)newValue).setScale(scalePrecision, 4);
                BigDecimal oldValueBigDecimal = ((BigDecimal)oldValue).setScale(scalePrecision, 4);
                oldValueString = oldValueBigDecimal.toEngineeringString();
                newValueString = newValueBigDecimal.toEngineeringString();
            } else {
                oldValueString = oldValue != null ? oldValue.toString() : "";
                newValueString = newValue != null ? newValue.toString() : "";
            }
        }
        catch (Exception e) {
            logger.info("\u53d8\u66f4\u65e5\u5fd7colName:" + colName + "--" + oldValue + "--" + newValue);
            throw e;
        }
        return oldValueString + "," + newValueString;
    }

    public static void replaceJSONObject(Object stockValue, Object changeValue, String colName, DynamicObject addnew) {
        if (stockValue instanceof JSONObject && changeValue instanceof JSONObject) {
            JSONObject oldValue = (JSONObject)stockValue;
            JSONObject newValue = (JSONObject)changeValue;
            if (oldValue == null || newValue == null || oldValue.size() == 0) {
                addnew.set(colName, (Object)ResManager.loadKDString((String)"\u65e0", (String)"StockChangeLogUtils_0", (String)"bd-mpdm-common", (Object[])new Object[0]));
                return;
            }
            String oldValueString = "";
            String newValueString = "";
            StringJoiner stringJoiner = new StringJoiner(";");
            for (String key : oldValue.keySet()) {
                oldValueString = oldValue.getString(key);
                newValueString = newValue.getString(key);
                if (StringUtils.isBlank((CharSequence)oldValueString)) {
                    oldValueString = ResManager.loadKDString((String)"\u65e0", (String)"StockChangeLogUtils_0", (String)"bd-mpdm-common", (Object[])new Object[0]);
                }
                if (StringUtils.isBlank((CharSequence)newValueString)) {
                    newValueString = ResManager.loadKDString((String)"\u65e0", (String)"StockChangeLogUtils_0", (String)"bd-mpdm-common", (Object[])new Object[0]);
                }
                String colValue = oldValueString + "->" + newValueString;
                if (StringUtils.equals((CharSequence)oldValueString, (CharSequence)newValueString)) {
                    stringJoiner.add(key + ":" + newValueString);
                    continue;
                }
                stringJoiner.add(key + ":" + colValue);
            }
            addnew.set(colName, (Object)stringJoiner.toString());
        } else {
            addnew.set(colName, (Object)"");
        }
    }

    public static void replaceJSONObject(Object changeValue, String colName, DynamicObject addnew) {
        if (changeValue instanceof JSONObject) {
            JSONObject newValue = (JSONObject)changeValue;
            if (newValue == null || newValue.size() == 0) {
                addnew.set(colName, (Object)ResManager.loadKDString((String)"\u65e0", (String)"StockChangeLogUtils_0", (String)"bd-mpdm-common", (Object[])new Object[0]));
                return;
            }
            String newValueString = "";
            StringJoiner stringJoiner = new StringJoiner(";");
            for (String key : newValue.keySet()) {
                newValueString = newValue.getString(key);
                if (StringUtils.isBlank((CharSequence)newValueString)) {
                    newValueString = ResManager.loadKDString((String)"\u65e0", (String)"StockChangeLogUtils_0", (String)"bd-mpdm-common", (Object[])new Object[0]);
                }
                stringJoiner.add(key + ":" + newValueString);
            }
            addnew.set(colName, (Object)stringJoiner.toString());
        } else {
            addnew.set(colName, (Object)"");
        }
    }

    public static void repalce(Object oldValue, Object newValue, String colName, DynamicObject addNew, int precision) {
        String oldValueAndNewValue = StockChangeLogUtils.getOldValueAndNewValue(oldValue, newValue, colName, precision);
        String[] split = oldValueAndNewValue.split(",");
        String oldValueString = "";
        String newValueString = "";
        if (split.length == 1) {
            oldValueString = oldValueAndNewValue.substring(0, oldValueAndNewValue.indexOf(44));
            newValueString = oldValueAndNewValue.substring(oldValueAndNewValue.indexOf(44) + 1, oldValueAndNewValue.length());
        } else if (split.length == 2) {
            oldValueString = split[0];
            newValueString = split[1];
        }
        if (StringUtils.isBlank((CharSequence)oldValueString)) {
            oldValueString = ResManager.loadKDString((String)"\u65e0", (String)"StockChangeLogUtils_0", (String)"bd-mpdm-common", (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)newValueString)) {
            newValueString = ResManager.loadKDString((String)"\u65e0", (String)"StockChangeLogUtils_0", (String)"bd-mpdm-common", (Object[])new Object[0]);
        }
        String colValue = oldValueString + "->" + newValueString;
        if (StringUtils.equals((CharSequence)oldValueString, (CharSequence)newValueString)) {
            addNew.set(colName, (Object)newValueString);
        } else {
            if (oldValue instanceof BigDecimal) {
                if (new BigDecimal(oldValueString).compareTo(new BigDecimal(newValueString)) < 0) {
                    colValue = colValue + " \u2191";
                } else if (new BigDecimal(newValueString).compareTo(new BigDecimal(oldValueString)) < 0) {
                    colValue = colValue + " \u2193";
                }
            }
            try {
                addNew.set(colName, (Object)colValue);
            }
            catch (Exception e) {
                logger.info("\u53d8\u66f4\u65e5\u5fd7colName:" + colName + "--" + colValue);
                throw e;
            }
        }
    }

    public static String replaceIsbackflush(Object oldValue) {
        return oldValue.toString().replace("A", ResManager.loadKDString((String)"\u4e0d\u5012\u51b2", (String)"StockChangeLogUtils_1", (String)"bd-mpdm-common", (Object[])new Object[0])).replace("B", ResManager.loadKDString((String)"\u59cb\u7ec8\u5012\u51b2", (String)"StockChangeLogUtils_2", (String)"bd-mpdm-common", (Object[])new Object[0])).replace("C", ResManager.loadKDString((String)"\u5de5\u4f5c\u4e2d\u5fc3\u51b3\u5b9a\u662f\u5426\u5012\u51b2\u3002", (String)"StockChangeLogUtils_3", (String)"bd-mpdm-common", (Object[])new Object[0]));
    }

    public static String replaceIssuemode(Object oldValue) {
        return oldValue.toString().replace("A", ResManager.loadKDString((String)"\u751f\u4ea7\u9886\u6599", (String)"StockChangeLogUtils_4", (String)"bd-mpdm-common", (Object[])new Object[0])).replace("B", ResManager.loadKDString((String)"\u76f4\u9001", (String)"StockChangeLogUtils_5", (String)"bd-mpdm-common", (Object[])new Object[0])).replace("C", ResManager.loadKDString((String)"\u4e0d\u9886\u6599", (String)"StockChangeLogUtils_6", (String)"mmc-pom-common", (Object[])new Object[0]));
    }

    public static String replaceOverissueContrl(Object oldValue) {
        return oldValue.toString().replace("A", ResManager.loadKDString((String)"\u53ef\u8d85\u53d1", (String)"StockChangeLogUtils_7", (String)"bd-mpdm-common", (Object[])new Object[0])).replace("B", ResManager.loadKDString((String)"\u4e0d\u53ef\u8d85\u53d1", (String)"StockChangeLogUtils_8", (String)"bd-mpdm-common", (Object[])new Object[0]));
    }

    public static String replaceWastagerateFormula(Object oldValue) {
        return oldValue.toString().replace("A", ResManager.loadKDString((String)"\u6807\u51c6\u7528\u91cf/\uff081-\u635f\u8017\u7387\uff08%\uff09\uff09", (String)"StockChangeLogUtils_9", (String)"bd-mpdm-common", (Object[])new Object[0])).replace("B", ResManager.loadKDString((String)"\u6807\u51c6\u7528\u91cf*\uff081+\u635f\u8017\u7387\uff08%\uff09\uff09", (String)"StockChangeLogUtils_10", (String)"bd-mpdm-common", (Object[])new Object[0]));
    }

    public static String replaceBooleanField(Object oldValue) {
        return oldValue.toString().replace("false", ResManager.loadKDString((String)"\u5426", (String)"StockChangeLogUtils_11", (String)"bd-mpdm-common", (Object[])new Object[0])).replace("true", ResManager.loadKDString((String)"\u662f", (String)"StockChangeLogUtils_12", (String)"bd-mpdm-common", (Object[])new Object[0]));
    }

    public static String replaceSupplyMode(Object oldValue) {
        return oldValue.toString().replace("bd_customer", ResManager.loadKDString((String)"\u5ba2\u6237", (String)"StockChangeLogUtils_13", (String)"bd-mpdm-common", (Object[])new Object[0])).replace("bos_org", ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143", (String)"StockChangeLogUtils_14", (String)"bd-mpdm-common", (Object[])new Object[0])).replace("bd_supplier", ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"StockChangeLogUtils_15", (String)"bd-mpdm-common", (Object[])new Object[0]));
    }

    public static Object getValue(String stock, Object changefield) {
        Object value;
        if (changefield instanceof DynamicObject) {
            DynamicObject dym = (DynamicObject)changefield;
            value = "materialid".equals(stock) ? dym.getString("masterid.name") : (dym.getDynamicObjectType().getProperties().containsKey((Object)"name") ? dym.getString("name") : (dym.getDynamicObjectType().getProperties().containsKey((Object)"number") ? dym.getString("number") : dym.getPkValue()));
        } else {
            value = changefield;
        }
        return value;
    }

    public static void validateLogIsExistAndDelete(DynamicObject[] stockChangeBills) {
        String stockChangeName = stockChangeBills[0].getDataEntityType().getName();
        ORMImpl impl = new ORMImpl();
        ArrayList<String> entryPks = new ArrayList<String>(16);
        for (DynamicObject stockChangeBill : stockChangeBills) {
            DynamicObjectCollection entryCol = stockChangeBill.getDynamicObjectCollection("stockentry");
            for (DynamicObject entryDym : entryCol) {
                entryPks.add(entryDym.getPkValue().toString());
            }
        }
        QFilter qFilter = new QFilter("stockchangeentryid", "in", entryPks);
        boolean exists = impl.exists(StockChangeUtils.getEntityName(3, 4, stockChangeName), new QFilter[]{qFilter});
        if (exists) {
            DeleteServiceHelper.delete((String)StockChangeUtils.getEntityName(3, 4, stockChangeName), (QFilter[])new QFilter[]{qFilter});
        }
    }
}

