/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.stockchange.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.stockchange.utils.ChangeObject;
import kd.bd.mpdm.common.stockchange.utils.StockChangeLogUtils;
import kd.bd.mpdm.common.stockchange.utils.StockChangeMapping;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class StockChangeUtils {
    public static final String STOCKNOCHANGEFIELDS = "bomreversion,qtytype,useratio,iscannegative,isstockallot,outorgunitid,outwarehouseid,outlocation,isbackflush,backflushtime,isjumplevel,parentmaterial,ecostcenter";
    private static final ThreadLocal<Map<Integer, Map<String, DynamicObject>>> stockThreadLocal = new ThreadLocal();

    private StockChangeUtils() {
    }

    public static String getEntityName(int srcIndex, int targetIndex, String srcName) {
        String stockName = StockChangeMapping.getEntityName(srcIndex, targetIndex, srcName);
        if (stockName.equals("0") || stockName.equals("")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e%1$s%2$s\u83b7\u53d6%3$s\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5236\u9020\u4e91mmc\u7ba1\u7406\u5458\u7ef4\u62a4\u5b9e\u4f53\u6620\u5c04\u3002", (String)"StockChangeUtils_0", (String)"bd-mpdm-common", (Object[])new Object[0]), srcIndex, srcName, targetIndex));
        }
        return stockName;
    }

    public static String getEntityName(int srcIndex, int targetIndex, String srcName, String defaultTargetName) {
        String stockName = StockChangeMapping.getEntityName(srcIndex, targetIndex, srcName);
        if (stockName.equals("0") || stockName.equals("")) {
            return defaultTargetName;
        }
        return stockName;
    }

    public static List<QFilter> getStockFilter(IDataModel model) {
        DynamicObject supplier;
        QFilter planFilter = new QFilter("orderentryid.planstatus", "=", (Object)"C");
        QFilter bizFilter = new QFilter("orderentryid.bizstatus", "=", (Object)"A");
        QFilter auditFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter transcationFilter = new QFilter("transactiontypeid.isstockchange", "=", (Object)"1");
        DynamicObject tran = (DynamicObject)model.getValue("transactiontypeid");
        QFilter transFilter = tran != null ? new QFilter("transactiontypeid.id", "=", tran.getPkValue()) : new QFilter("transactiontypeid", "=", (Object)0L);
        DynamicObject org = (DynamicObject)model.getValue("org");
        QFilter orgFilter = org != null ? new QFilter("org.id", "=", org.getPkValue()) : new QFilter("org.id", "=", (Object)0L);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(planFilter);
        filters.add(bizFilter);
        filters.add(auditFilter);
        filters.add(transcationFilter);
        filters.add(transFilter);
        filters.add(orgFilter);
        if ("om_xmftstock".equals(model.getDataEntity().getDataEntityType().getName()) && (supplier = (DynamicObject)model.getValue("suppliertop")) != null) {
            filters.add(new QFilter("orderentryid.supplier", "=", supplier.getPkValue()));
        }
        return filters;
    }

    public static void setStockInfo(DynamicObject stock, int changeIndex, int currentSelectIndex, IDataModel model, IFormView view) {
        if (stock == null) {
            model.setValue("stockid", null, changeIndex);
            model.setValue("stockno", null, changeIndex);
            model.setValue("productbaseqty", null, changeIndex);
            model.setValue("productbaseunit", null, changeIndex);
            model.setValue("producttransid", null, changeIndex);
            model.setValue("entryorderentryid", null, changeIndex);
            model.setValue("entryorderno", null, changeIndex);
            model.setValue("prodeptorgid", null, changeIndex);
            model.setValue("productno", null, changeIndex);
            model.setValue("backflushtime", null, changeIndex);
            model.setValue("qtynumerator", (Object)BigDecimal.ZERO, changeIndex);
            model.setValue("standqty", (Object)BigDecimal.ZERO, changeIndex);
            model.setValue("demandqty", (Object)BigDecimal.ZERO, changeIndex);
            DynamicObject mtfOrg = (DynamicObject)model.getValue("org");
            if (mtfOrg == null) {
                return;
            }
        } else {
            DynamicObject transac;
            model.setValue("stockid", (Object)stock.getPkValue().toString(), changeIndex);
            model.setValue("stockno", stock.get("billno"), changeIndex);
            model.setValue("productbaseqty", stock.get("baseqty"), changeIndex);
            model.setValue("productbaseunit", stock.get("baseunitid"), changeIndex);
            model.setValue("producttransid", stock.get("transactiontypeid"), changeIndex);
            model.setValue("entryorderentryid", stock.get("orderentryid"), changeIndex);
            model.setValue("entryorderno", stock.get("orderno"), changeIndex);
            model.setValue("prodeptorgid", stock.get("mftdeptorgid"), changeIndex);
            model.setValue("productno", stock.get("productid"), changeIndex);
            DynamicObject product = stock.getDynamicObject("productid");
            DynamicObject material = (DynamicObject)model.getValue("materialid", changeIndex);
            model.setValue("rework", (Object)"false", changeIndex);
            if (material != null && product != null && material.getPkValue().equals(product.getPkValue())) {
                model.setValue("rework", (Object)"true", changeIndex);
            }
            model.setValue("demanddate", stock.getDynamicObject("orderentryid").get("planbegintime"), changeIndex);
            String isbackflush = (String)model.getValue("isbackflush", changeIndex);
            if ("B".equals(isbackflush) && (transac = (DynamicObject)stock.get("transactiontypeid")) != null) {
                model.setValue("backflushtime", transac.get("backflushtime"), changeIndex);
            }
            model.setValue("productconfiguredcode", stock.get("configuredcode"), changeIndex);
            model.setValue("entrytracknumber", stock.get("tracknumber"), changeIndex);
            model.setValue("entrybdproject", stock.get("bdproject"), changeIndex);
            model.setValue("qtynumerator", (Object)BigDecimal.ZERO, changeIndex);
            model.setValue("standqty", (Object)BigDecimal.ZERO, changeIndex);
            model.setValue("demandqty", (Object)BigDecimal.ZERO, changeIndex);
            DynamicObject mtfOrg = (DynamicObject)model.getValue("org");
            if (mtfOrg == null) {
                return;
            }
        }
        if (changeIndex == currentSelectIndex) {
            model.setValue("warehousefield", model.getValue("warehouseid", changeIndex));
            StockChangeUtils.lockLocationField(model.getValue("warehouseid", changeIndex), view);
            model.setValue("locationfield", model.getValue("location", changeIndex));
            model.setValue("backflushtimefield", model.getValue("backflushtime", changeIndex));
            model.setValue("demanddatefield", model.getValue("demanddate", changeIndex));
        }
    }

    private static void lockLocationField(Object newObj, IFormView view) {
        if (newObj != null) {
            long warehouseId = (Long)((DynamicObject)newObj).getPkValue();
            DynamicObject warehouse = BusinessDataServiceHelper.loadSingle((Object)warehouseId, (String)"bd_warehouse");
            boolean isopenlocation = warehouse.getBoolean("isopenlocation");
            if (isopenlocation) {
                view.setEnable(Boolean.TRUE, new String[]{"locationfield"});
            } else {
                view.setEnable(Boolean.FALSE, new String[]{"locationfield"});
            }
        } else {
            view.setEnable(Boolean.FALSE, new String[]{"locationfield"});
        }
    }

    public static List<QFilter> getStockFilter() {
        QFilter planFilter = new QFilter("orderentryid.planstatus", "=", (Object)"C");
        QFilter bizFilter = new QFilter("orderentryid.bizstatus", "=", (Object)"A");
        QFilter auditFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter transcationFilter = new QFilter("transactiontypeid.isstockchange", "=", (Object)"1");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(planFilter);
        filters.add(bizFilter);
        filters.add(auditFilter);
        filters.add(transcationFilter);
        return filters;
    }

    public static void afterLog(AfterOperationArgs e) {
        DynamicObject[] stockChangeBills = e.getDataEntities();
        StockChangeLogUtils.validateLogIsExistAndDelete(stockChangeBills);
        ArrayList<DynamicObject> saveLogList = new ArrayList<DynamicObject>(16);
        Map<String, DynamicObject> stockNoDymMap = StockChangeUtils.getStockNoDymMap(stockChangeBills, stockChangeBills[0].getDataEntityType().getName());
        for (int i = 0; i < stockChangeBills.length; ++i) {
            DynamicObject stockChangeBill = stockChangeBills[i];
            DynamicObjectCollection entryCol = stockChangeBill.getDynamicObjectCollection("stockentry");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject stockChangeEntry = (DynamicObject)entryCol.get(j);
                DynamicObject stockLog = StockChangeUtils.updateChangeLog(stockChangeBill, stockChangeEntry, stockNoDymMap);
                if (null == stockLog) continue;
                saveLogList.add(stockLog);
            }
        }
        if (!saveLogList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveLogList.toArray(new DynamicObject[saveLogList.size()]));
        }
        StockChangeUtils.removeStockThreadLocal();
    }

    public static void removeStockThreadLocal() {
        stockThreadLocal.remove();
    }

    public static Map<String, DynamicObject> getStockNoDymMap(DynamicObject[] stockChangeBills, String stockChangeName) {
        DynamicObject[] stockDyms;
        Map<String, DynamicObject> dataMap;
        Map<Integer, Map<String, DynamicObject>> stockDataMap;
        HashMap<String, DynamicObject> stockNoDymMap = new HashMap<String, DynamicObject>(16);
        Set<String> stockIdList = StockChangeUtils.getStockNoList(stockChangeBills);
        if (stockIdList.isEmpty()) {
            return stockNoDymMap;
        }
        StringBuilder billnoKeys = new StringBuilder();
        for (String billno : stockIdList) {
            billnoKeys.append(billno);
        }
        int billnoHashCode = billnoKeys.toString().hashCode();
        if (billnoKeys.length() > 0) {
            billnoKeys.delete(0, billnoKeys.length());
        }
        if ((stockDataMap = stockThreadLocal.get()) == null) {
            stockDataMap = new HashMap<Integer, Map<String, DynamicObject>>();
            stockThreadLocal.set(stockDataMap);
        }
        if ((dataMap = stockDataMap.get(billnoHashCode)) != null && !dataMap.isEmpty()) {
            return dataMap;
        }
        String orderName = StockChangeUtils.getEntityName(3, 0, stockChangeName);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)orderName);
        EntityType subEntryType = (EntityType)mainType.getAllEntities().get("treeentryentity");
        DynamicObject orderEntry = new DynamicObject((DynamicObjectType)subEntryType);
        IDataEntityType dataEntityType = orderEntry.getDataEntityType();
        DataEntityCacheManager cacheManager = new DataEntityCacheManager(dataEntityType);
        cacheManager.removeByDt();
        for (DynamicObject stockDym : stockDyms = BusinessDataServiceHelper.load((String)StockChangeUtils.getEntityName(3, 1, stockChangeName), (String)StockChangeUtils.selectStockProperties(stockChangeName), (QFilter[])new QFilter[]{new QFilter("billno", "in", stockIdList)})) {
            stockNoDymMap.put(stockDym.getString("billno"), stockDym);
        }
        stockDataMap.put(billnoHashCode, stockNoDymMap);
        return stockNoDymMap;
    }

    public static String selectStockProperties(String stockChangeName) {
        Set<String> stockFields = StockChangeUtils.getAllStockEentryFields(stockChangeName);
        StringBuilder sb = new StringBuilder("id,billno,productid,billstatus,orderno,productmasterid,orderid,qty,baseqty,billauxqty,orderentryid,baseunitid,unitid,billauxunit,org,bomid,replaceno,modifytime,modifier,auxproperty,transactiontypeid,stockentry.seq,mftdeptorgid,configuredcode,tracknumber,bdproject");
        for (String stockField : stockFields) {
            sb.append(',');
            sb.append("stockentry");
            sb.append('.');
            sb.append(stockField);
        }
        sb.append(',');
        sb.append("stockentry");
        sb.append(".pid");
        return sb.toString();
    }

    public static Map<String, Boolean> getStockNoChangeMap(DynamicObject[] stockChangeBills, String stockChangeName) {
        DynamicObject[] stockChangeDyms;
        HashMap<String, Boolean> stockNoDymMap = new HashMap<String, Boolean>(16);
        Set<String> stockNoList = StockChangeUtils.getStockNoList(stockChangeBills);
        for (DynamicObject stockChangeDym : stockChangeDyms = BusinessDataServiceHelper.load((String)stockChangeName, (String)"stockentry.stockno", (QFilter[])new QFilter[]{new QFilter("stockentry.stockno", "in", stockNoList).and(new QFilter("billstatus", "!=", (Object)"C"))})) {
            DynamicObjectCollection entryCol = stockChangeDym.getDynamicObjectCollection("stockentry");
            for (DynamicObject entry : entryCol) {
                stockNoDymMap.put(entry.getString("stockno"), Boolean.TRUE);
            }
        }
        return stockNoDymMap;
    }

    public static Map<String, String> getStockNoChangeBillnoMap(DynamicObject[] stockChangeBills, String stockChangeName) {
        DynamicObject[] stockChangeDyms;
        HashMap<String, String> stockNoDymMap = new HashMap<String, String>(16);
        Set<String> stockNoList = StockChangeUtils.getStockNoList(stockChangeBills);
        for (DynamicObject stockChangeDym : stockChangeDyms = BusinessDataServiceHelper.load((String)stockChangeName, (String)"stockentry.stockno,billno", (QFilter[])new QFilter[]{new QFilter("stockentry.stockno", "in", stockNoList).and(new QFilter("billstatus", "!=", (Object)"C"))})) {
            DynamicObjectCollection entryCol = stockChangeDym.getDynamicObjectCollection("stockentry");
            for (DynamicObject entry : entryCol) {
                stockNoDymMap.put(entry.getString("stockno"), stockChangeDym.getString("billno"));
            }
        }
        return stockNoDymMap;
    }

    private static Set<String> getStockNoList(DynamicObject[] stockChangeBills) {
        HashSet<String> stockNoList = new HashSet<String>(stockChangeBills.length);
        for (int i = 0; i < stockChangeBills.length; ++i) {
            DynamicObject stockChangeBill = stockChangeBills[i];
            DynamicObjectCollection entryCol = stockChangeBill.getDynamicObjectCollection("stockentry");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject stockChangeEntry = (DynamicObject)entryCol.get(j);
                String stockNo = stockChangeEntry.getString("stockno");
                if ("".equals(stockNo)) continue;
                stockNoList.add(stockNo);
            }
        }
        return stockNoList;
    }

    private static DynamicObject updateChangeLog(DynamicObject stockChangeBill, DynamicObject stockChangeEntry, Map<String, DynamicObject> stockIdDymMap) {
        String changeType = stockChangeEntry.getString("entrychangetype");
        String stockNo = stockChangeEntry.getString("stockno");
        if ("".equals(stockNo)) {
            return null;
        }
        String stockChangeName = stockChangeBill.getDataEntityType().getName();
        DynamicObject stockBill = stockIdDymMap.get(stockNo);
        DynamicObjectCollection stockBillEntryCols = stockBill.getDynamicObjectCollection("stockentry");
        List<ChangeObject> changeFieldList = new ArrayList<ChangeObject>();
        if (StringUtils.equals((CharSequence)"B", (CharSequence)changeType)) {
            DynamicObject stockEntryF7 = stockChangeEntry.getDynamicObject("entryidf");
            if (stockEntryF7 != null) {
                DynamicObject stockBillEntryNew = null;
                String stockentryid = stockEntryF7.getPkValue().toString();
                for (DynamicObject stockBillEntry : stockBillEntryCols) {
                    if (!stockBillEntry.getPkValue().toString().equals(stockentryid)) continue;
                    stockBillEntryNew = stockBillEntry;
                }
                if (stockBillEntryNew != null) {
                    changeFieldList = StockChangeLogUtils.getChangeFieldList(stockBillEntryNew, stockChangeEntry, stockChangeName);
                }
            }
        } else if (StringUtils.equals((CharSequence)"A", (CharSequence)changeType)) {
            changeFieldList = StockChangeLogUtils.getChangeFieldList(stockChangeEntry, stockChangeName);
        }
        return StockChangeLogUtils.addChangeLog(changeFieldList, stockChangeEntry, stockChangeBill);
    }

    public static boolean changeExistUnAuditChange(DynamicObject stockChangeEntry, Map<String, Boolean> stockNoChangeMap) {
        Boolean isExit = stockNoChangeMap.get(stockChangeEntry.getString("stockno"));
        if (null == isExit) {
            return false;
        }
        return isExit;
    }

    public static String changeExistUnAuditChangeBillno(DynamicObject stockChangeEntry, Map<String, String> stockNoChangeMap) {
        String billno = stockNoChangeMap.get(stockChangeEntry.getString("stockno"));
        return billno;
    }

    public static Map<String, DynamicObject> getStockChangeMap(DynamicObject[] stockChangeBills, String stockChangeName) {
        DynamicObject[] stockDyms;
        HashMap<String, DynamicObject> stockChangeMap = new HashMap<String, DynamicObject>(16);
        HashSet<Long> stockChangeIdList = new HashSet<Long>();
        for (DynamicObject stockChangeBill : stockChangeBills) {
            if ("0".equals(stockChangeBill.getPkValue().toString())) continue;
            stockChangeIdList.add((Long)stockChangeBill.getPkValue());
        }
        for (DynamicObject stockDym : stockDyms = BusinessDataServiceHelper.load((String)stockChangeName, (String)StockChangeUtils.selectStockProperties(stockChangeName), (QFilter[])new QFilter[]{new QFilter("id", "in", stockChangeIdList)})) {
            stockChangeMap.put(stockDym.getPkValue().toString(), stockDym);
        }
        return stockChangeMap;
    }

    public static Map<String, DynamicObject> getManftechMap(DynamicObject[] stockChangeBills, String stockChangeName) {
        DynamicObject[] manftechDyms;
        HashMap<String, DynamicObject> manftechMap = new HashMap<String, DynamicObject>(16);
        HashSet<Long> orderEntryList = new HashSet<Long>();
        for (int i = 0; i < stockChangeBills.length; ++i) {
            DynamicObject stockChangeBill = stockChangeBills[i];
            DynamicObjectCollection entryCol = stockChangeBill.getDynamicObjectCollection("stockentry");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject stockChangeEntry = (DynamicObject)entryCol.get(j);
                DynamicObject orderEntry = stockChangeEntry.getDynamicObject("entryorderentryid");
                if (orderEntry == null) continue;
                orderEntryList.add((Long)orderEntry.getPkValue());
            }
        }
        for (DynamicObject manftechDym : manftechDyms = BusinessDataServiceHelper.load((String)StockChangeUtils.getEntityName(3, 2, stockChangeName), (String)MPDMMftGenStocksUtils.manftechSelectProperties().toString(), (QFilter[])new QFilter[]{new QFilter("mftentryseq", "in", orderEntryList)})) {
            manftechMap.put(manftechDym.getDynamicObject("mftentryseq").getPkValue().toString(), manftechDym);
        }
        return manftechMap;
    }

    public static Map<String, DynamicObject> getStockChangeLogMap(DynamicObject[] stockChangeBills, String stockChangeName) {
        DynamicObject[] stockDyms;
        HashMap<String, DynamicObject> stockChangeMap = new HashMap<String, DynamicObject>(16);
        HashSet<String> stockChangeIdList = new HashSet<String>();
        for (DynamicObject stockChangeBill : stockChangeBills) {
            DynamicObjectCollection entryCol = stockChangeBill.getDynamicObjectCollection("stockentry");
            for (int j = 0; j < entryCol.size(); ++j) {
                stockChangeIdList.add(((DynamicObject)entryCol.get(j)).getPkValue().toString());
            }
        }
        for (DynamicObject stockDym : stockDyms = BusinessDataServiceHelper.load((String)StockChangeUtils.getEntityName(3, 4, stockChangeName), (String)"entryidf,id,stockchangeentryid,billstatus", (QFilter[])new QFilter[]{new QFilter("stockchangeentryid", "in", stockChangeIdList)})) {
            stockChangeMap.put(stockDym.getString("stockchangeentryid"), stockDym);
        }
        return stockChangeMap;
    }

    public static Set<String> getAllStockEentryFields(String stockChangeName) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)StockChangeUtils.getEntityName(3, 1, stockChangeName));
        EntityType subEntryType = (EntityType)mainType.getAllEntities().get("stockentry");
        Set<String> keySet = subEntryType.getFields().keySet();
        keySet.remove("setuplocation");
        keySet.remove("isGroupNode");
        return keySet;
    }

    public static Set<String> getAllStockFields(String stockChangeName) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)StockChangeUtils.getEntityName(3, 1, stockChangeName));
        Set<String> keySet = mainType.getFields().keySet();
        keySet.remove("stockentry");
        return keySet;
    }

    public static Map<Object, DynamicObject> getStockF7Map(DynamicObject[] stockChangeBills, String stockName) {
        DynamicObject[] stockDyms;
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)stockName);
        EntityType subEntryType = (EntityType)mainType.getAllEntities().get("stockentry");
        DynamicObject stockEntry = new DynamicObject((DynamicObjectType)subEntryType);
        IDataEntityType dataEntityType = stockEntry.getDataEntityType();
        DataEntityCacheManager cacheManager = new DataEntityCacheManager(dataEntityType);
        cacheManager.removeByDt();
        HashMap<Object, DynamicObject> stockF7Map = new HashMap<Object, DynamicObject>(16);
        HashSet<Long> stockF7IdList = new HashSet<Long>();
        for (DynamicObject stockChangeBill : stockChangeBills) {
            DynamicObjectCollection entryCol = stockChangeBill.getDynamicObjectCollection("stockentry");
            for (int j = 0; j < entryCol.size(); ++j) {
                Long entryidf = Long.parseLong(((DynamicObject)entryCol.get(j)).getString("stockentryid"));
                stockF7IdList.add(entryidf);
            }
        }
        for (DynamicObject stockDym : stockDyms = BusinessDataServiceHelper.load((String)(stockName + "f7"), (String)"entryseq,qtytype", (QFilter[])new QFilter[]{new QFilter("id", "in", stockF7IdList)})) {
            stockF7Map.put(stockDym.getPkValue(), stockDym);
        }
        return stockF7Map;
    }
}

