/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.utils;

import java.math.BigDecimal;
import kd.bd.mpdm.common.enums.UnitConvertDirEnum;
import kd.bd.mpdm.common.mftorder.helper.BillUnitAndQtytHelper;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;

public class AuxQtyAndUnitHelper {
    public static void setAucBizQtyAndUnit(IDataModel bill, int rowindex, String fieldName, Object newValue) {
        DynamicObject material;
        DynamicObject materialmftinfo = (DynamicObject)bill.getValue("material", rowindex);
        if (materialmftinfo != null && null != (material = materialmftinfo.getDynamicObject("masterid"))) {
            String selectProperties = "auxptyunit,unitconvertdir";
            DynamicObject auxptyUnit = (material = MaterialQueryHelper.getDataCacheByID(material.getPkValue())).getDynamicObject("auxptyunit");
            if (null != auxptyUnit) {
                switch (fieldName) {
                    case "qty": 
                    case "baseqty": {
                        AuxQtyAndUnitHelper.changeUntAndQty(bill.getEntryRowEntity("treeentryentity", rowindex), material, auxptyUnit, "baseqty", "baseunit", "auxptyqty");
                        break;
                    }
                    case "auxptyqty": {
                        AuxQtyAndUnitHelper.changeAuxptyQty(bill.getEntryRowEntity("treeentryentity", rowindex), material, "baseunit", "auxptyunit", "auxptyqty", "baseqty", "unit", "qty");
                        break;
                    }
                }
            }
        }
    }

    public static BigDecimal changeUntAndQty(DynamicObject entry, DynamicObject material, DynamicObject auxptyUnit, String baseQtyFiledName, String baseUnitFiledName, String qtyUnit2ndFiledName) {
        BigDecimal qtyUnit2nd = null;
        if (null != material) {
            boolean isConvert;
            StringBuilder spBuilder = new StringBuilder();
            if (!material.containsProperty("auxptyunit")) {
                spBuilder.append("auxptyunit");
            }
            if (!material.containsProperty("unitconvertdir")) {
                if (spBuilder.length() > 0) {
                    spBuilder.append(",");
                }
                spBuilder.append("unitconvertdir");
            }
            if (spBuilder.length() > 0) {
                material = MaterialQueryHelper.getDataCacheByID(material.getPkValue());
            }
            String unitConvertDir = material.getString("unitconvertdir");
            boolean bl = isConvert = UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
            if (isConvert) {
                BigDecimal baseQty = entry.getBigDecimal(baseQtyFiledName);
                DynamicObject baseUnit = entry.getDynamicObject(baseUnitFiledName);
                if (BigDecimal.ZERO.compareTo(baseQty) == 0) {
                    entry.set(qtyUnit2ndFiledName, (Object)BigDecimal.ZERO);
                    return BigDecimal.ZERO;
                }
                qtyUnit2nd = BillUnitAndQtytHelper.getDesQtyConv(material, baseUnit, baseQty, auxptyUnit);
                entry.set(qtyUnit2ndFiledName, (Object)qtyUnit2nd);
            }
        }
        return qtyUnit2nd;
    }

    private static void changeAuxptyQty(DynamicObject entry, DynamicObject material, String baseUnitFiledName, String unit2ndFiledName, String qtyUnit2ndFiledName, String baseQtyFiledName, String unitFiledName, String qtyFiledName) {
        if (null != material) {
            boolean isConvert;
            StringBuilder spBuilder = new StringBuilder();
            if (!material.containsProperty("auxptyunit")) {
                spBuilder.append("auxptyunit");
            }
            if (!material.containsProperty("unitconvertdir")) {
                if (spBuilder.length() > 0) {
                    spBuilder.append(",");
                }
                spBuilder.append("unitconvertdir");
            }
            if (spBuilder.length() > 0) {
                material = MaterialQueryHelper.getDataCacheByID(material.getPkValue());
            }
            String unitConvertDir = material.getString("unitconvertdir");
            boolean bl = isConvert = UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
            if (isConvert) {
                DynamicObject baseUnit = entry.getDynamicObject("baseunit");
                DynamicObject unit2nd = entry.getDynamicObject(unit2ndFiledName);
                BigDecimal qtyUnit2nd = entry.getBigDecimal(qtyUnit2ndFiledName);
                BigDecimal baseQty = BillUnitAndQtytHelper.getDesQtyConv(material, unit2nd, qtyUnit2nd, baseUnit);
                entry.set(baseQtyFiledName, (Object)baseQty);
                AuxQtyAndUnitHelper.setQtyByBaseQtyChange(entry, material, baseUnit, baseQty, unitFiledName, qtyFiledName);
            }
        }
    }

    private static void setQtyByBaseQtyChange(DynamicObject entry, DynamicObject material, DynamicObject baseUnit, BigDecimal baseQty, String unitFiledName, String qtyFiledName) {
        BigDecimal qty = BigDecimal.ZERO;
        if (baseQty.compareTo(BigDecimal.ZERO) != 0) {
            DynamicObject unit = entry.getDynamicObject(unitFiledName);
            if (unit == null) {
                return;
            }
            qty = BillUnitAndQtytHelper.getDesQtyConv(material, baseUnit, baseQty, unit);
        }
        entry.set(qtyFiledName, (Object)qty);
    }
}

