/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class AverageAssignUtil {
    private AverageAssignUtil() {
    }

    public static <T> List<List<T>> getAssignShardList(List<T> sourceLst, int shardCount) {
        ArrayList<List<T>> result = new ArrayList<List<T>>(10);
        if (shardCount == 0) {
            shardCount = 1;
        }
        int remaider = sourceLst.size() % shardCount;
        int number = sourceLst.size() / shardCount;
        int offset = 0;
        if (shardCount > sourceLst.size()) {
            shardCount = sourceLst.size();
        }
        for (int i = 0; i < shardCount; ++i) {
            List<T> value = null;
            if (remaider > 0) {
                value = sourceLst.subList(i * number + offset, (i + 1) * number + offset + 1);
                --remaider;
                ++offset;
            } else {
                value = sourceLst.subList(i * number + offset, (i + 1) * number + offset);
            }
            result.add(value);
        }
        return result;
    }

    public static <T> List<List<T>> getAssignListByMaxSize(List<T> sourceLst, int rowMaxSize) {
        int shardCount = AverageAssignUtil.getAssignCount(sourceLst, rowMaxSize);
        return AverageAssignUtil.getAssignShardList(sourceLst, shardCount);
    }

    private static <T> int getAssignCount(List<T> sourceSet, int rowMaxSize) {
        BigDecimal maxCountDecimal = new BigDecimal(rowMaxSize);
        BigDecimal sumSizeDecimal = new BigDecimal(sourceSet.size());
        BigDecimal assginCount = BigDecimal.ONE;
        if (maxCountDecimal.compareTo(BigDecimal.ZERO) > 0) {
            assginCount = sumSizeDecimal.divide(maxCountDecimal, 0, 0);
        }
        return assginCount.intValue();
    }
}

