/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.MapUtils;

public class BotpUtils {
    private static final String FORM_BOTP_BILLTRACKER = "botp_billtracker";
    private static final String KEY_S_TABLEID = "stableid";
    private static final String KEY_S_BILLID = "sbillid";
    private static final String KEYS_TTABLEID_TBILLID = "ttableid, tbillid";
    private static final String KEYS_STABLEID_SBILLID_TTABLEID_TBILLID = "stableid, sbillid, ttableid, tbillid";

    public static void fixRowLink(String targetEntityNumber, String targetEntryKey, String srcEntityNumber, String srcEntryKey, String targetRelationField, String srcRelationField, Long targetBillId, Long srcBillId) {
        if (StringUtils.isNotBlank((CharSequence)targetEntityNumber) && StringUtils.isNotBlank((CharSequence)targetEntryKey) && StringUtils.isNotBlank((CharSequence)srcEntityNumber) && StringUtils.isNotBlank((CharSequence)srcEntryKey) && StringUtils.isNotBlank((CharSequence)srcRelationField) && StringUtils.isNotBlank((CharSequence)targetRelationField) && null != targetBillId && !targetBillId.equals(0L) && null != srcBillId && !srcBillId.equals(0L)) {
            DynamicObject[] sourceBillObjs;
            TableDefine srcTableDefine;
            DynamicObject targetBillObj = BusinessDataServiceHelper.loadSingle((Object)targetBillId, (String)targetEntityNumber);
            TableDefine targetTableDefine = EntityMetadataCache.loadTableDefine((String)targetEntityNumber, (String)targetEntryKey);
            boolean isupdate = BotpUtils.createLinkEntity(targetTableDefine, targetBillObj, srcTableDefine = EntityMetadataCache.loadTableDefine((String)srcEntityNumber, (String)srcEntryKey), sourceBillObjs = BotpUtils.loadSourceBillByID(srcTableDefine, srcBillId), srcRelationField, targetRelationField);
            if (isupdate) {
                SaveServiceHelper.saveOperate((String)targetEntityNumber, (DynamicObject[])new DynamicObject[]{targetBillObj}, (OperateOption)OperateOption.create());
            }
        }
    }

    private static DynamicObject[] loadSourceBillByID(TableDefine srcTableDefine, Long srcBillId) {
        BillEntityType sourceMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)srcTableDefine.getEntityNumber());
        HashSet<String> selectFields = new HashSet<String>();
        selectFields.add("id");
        selectFields.add(sourceMainType.getBillNo());
        selectFields.add(srcTableDefine.getEntityKey() + ".id");
        selectFields.add(srcTableDefine.getEntityKey() + ".seq");
        QFilter filter = new QFilter("id", "=", (Object)srcBillId);
        return BusinessDataServiceHelper.load((String)srcTableDefine.getEntityNumber(), (String)StringUtils.join((Object[])selectFields.toArray(), (String)","), (QFilter[])new QFilter[]{filter});
    }

    private static boolean createLinkEntity(TableDefine targetTableDefine, DynamicObject targetBillObj, TableDefine srcTableDefine, DynamicObject[] sourceBillObjs, String srcRelationField, String targetRelationField) {
        String srcRowSeq;
        HashMap<String, Object[]> srcRowIds = new HashMap<String, Object[]>();
        for (DynamicObject srcObj : sourceBillObjs) {
            DynamicObjectCollection srcRows = srcObj.getDynamicObjectCollection(srcTableDefine.getEntityKey());
            for (DynamicObject srcRow : srcRows) {
                srcRowSeq = "0";
                if (srcRow.get(srcRelationField) != null) {
                    srcRowSeq = String.valueOf(srcRow.get(srcRelationField));
                }
                Object[] srcRowId = new Object[]{srcObj.getPkValue(), srcRow.getPkValue()};
                srcRowIds.put(srcRowSeq, srcRowId);
            }
        }
        Long srcTableId = srcTableDefine.getTableId();
        String lkEntryKey = targetTableDefine.getEntityKey() + "_lk";
        boolean isupdate = false;
        DynamicObjectCollection targetRows = targetBillObj.getDynamicObjectCollection(targetTableDefine.getEntityKey());
        for (DynamicObject targetRow : targetRows) {
            DynamicObjectCollection linkRows = targetRow.getDynamicObjectCollection(lkEntryKey);
            if (!linkRows.isEmpty()) continue;
            srcRowSeq = "0";
            if (targetRow.get(targetRelationField) != null) {
                srcRowSeq = String.valueOf(targetRow.get(targetRelationField));
            }
            if (!srcRowIds.containsKey(srcRowSeq)) continue;
            DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
            linkRows.add((Object)linkRow);
            Object[] srcRowId = (Object[])srcRowIds.get(srcRowSeq);
            linkRow.set(lkEntryKey + "_stableid", (Object)srcTableId);
            linkRow.set(lkEntryKey + "_sbillid", srcRowId[0]);
            linkRow.set(lkEntryKey + "_sid", srcRowId[1]);
            isupdate = true;
        }
        return isupdate;
    }

    public static Map<Long, Set<String>> findTargetBill(String entityNumber, String entryKey, Long[] billIds, Long[] entryIds, OperateOption option) {
        HashMap<Long, Set<String>> map = new HashMap<Long, Set<String>>(16);
        if ("pom_mftstock".equals(entityNumber)) {
            option.setVariableValue("botp_track_only_dirt_link", "false");
        }
        List bfRowLinkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)entityNumber, (String)entryKey, (Long[])billIds, (Long[])entryIds, (OperateOption)option);
        for (BFRowLinkDownNode node : bfRowLinkDownNodes) {
            BFRowId sRowId = node.getRowId();
            HashSet<String> entityNumbers = new HashSet<String>(16);
            Map tNodes = node.getTNodes();
            BotpUtils.getEntityNumbers(tNodes, entityNumbers);
            map.put(sRowId.getEntryId(), entityNumbers);
        }
        return map;
    }

    private static void getEntityNumbers(Map<BFRowId, BFRowLinkDownNode> node, Set<String> entityNumbers) {
        if (MapUtils.isEmpty(node)) {
            return;
        }
        node.forEach((k, v) -> {
            entityNumbers.add(EntityMetadataCache.loadTableDefine((Long)v.getRowId().getMainTableId()).getEntityNumber());
            BotpUtils.getEntityNumbers(v.getTNodes(), entityNumbers);
        });
    }

    public static Map<Long, Set<String>> findTargetBill(String entityNumber, Long[] billIds, OperateOption option) {
        HashMap<Long, Set<String>> map = new HashMap<Long, Set<String>>(16);
        List bfRowLinkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)entityNumber, (Long[])billIds, (OperateOption)option);
        for (BFRowLinkDownNode node : bfRowLinkDownNodes) {
            BFRowId sRowId = node.getRowId();
            HashSet entityNumbers = new HashSet(16);
            Map tNodes = node.getTNodes();
            tNodes.forEach((k, v) -> entityNumbers.add(EntityMetadataCache.loadTableDefine((Long)v.getRowId().getMainTableId()).getEntityNumber()));
            map.put(sRowId.getBillId(), entityNumbers);
        }
        return map;
    }

    public static Map<Long, Map<String, HashSet<Long>>> findTargetBillsBatch(String entityNumber, Long[] billIds) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || billIds == null || billIds.length == 0) {
            return new HashMap<Long, Map<String, HashSet<Long>>>();
        }
        ConvertDataService reader = new ConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(entityNumber, entityNumber);
        Long myMainTableId = mainTableDefine.getTableId();
        HashSet<Long> myBillIds = new HashSet<Long>(16);
        for (Long billId : billIds) {
            myBillIds.add(billId);
        }
        if (myBillIds.size() == 0) {
            return new LinkedHashMap<Long, Map<String, HashSet<Long>>>();
        }
        LinkedHashMap allLinkBills = new LinkedHashMap();
        HashMap<Long, HashSet<Long>> tgtBillIds = new HashMap<Long, HashSet<Long>>();
        tgtBillIds.put(myMainTableId, myBillIds);
        HashMap<Long, List<Long>> srcBIllIdDownBillIds = new HashMap<Long, List<Long>>(8);
        int count = 0;
        while (tgtBillIds.size() > 0 && count < 100) {
            ++count;
            ArrayList<BFRowId> allBillRowIds = new ArrayList<BFRowId>();
            for (Map.Entry entry : tgtBillIds.entrySet()) {
                Long sMainTableId = (Long)entry.getKey();
                Long[] sBillIds = ((Set)entry.getValue()).toArray(new Long[((Set)entry.getValue()).size()]);
                List<BFRow> downRows = BotpUtils.readDownBillBFRows(sMainTableId, sBillIds);
                for (BFRow row : downRows) {
                    Long srcId = row.getSId().getBillId();
                    List downList = srcBIllIdDownBillIds.computeIfAbsent(srcId, k -> new ArrayList());
                    downList.add(row.getId().getBillId());
                    allBillRowIds.add(row.getId());
                }
            }
            tgtBillIds.clear();
            for (BFRowId bFRowId : allBillRowIds) {
                if (!BotpUtils.addToMap(allLinkBills, bFRowId.getTableId(), bFRowId.getBillId())) continue;
                BotpUtils.addToMap(tgtBillIds, bFRowId.getTableId(), bFRowId.getBillId());
            }
        }
        LinkedHashMap<String, HashSet<Long>> linkBills = new LinkedHashMap<String, HashSet<Long>>();
        for (Map.Entry entry : allLinkBills.entrySet()) {
            HashSet<Long> existBillIds;
            Long mainTableId = (Long)entry.getKey();
            TableDefine tableDefine = reader.loadTableDefine(mainTableId);
            if (tableDefine == null || (existBillIds = BotpUtils.readExistsBillIds(tableDefine.getEntityNumber(), ((Set)entry.getValue()).toArray(new Long[0]))).isEmpty()) continue;
            linkBills.put(tableDefine.getEntityNumber(), existBillIds);
        }
        HashMap<Long, List> searchIdAllDownMap = new HashMap<Long, List>(16);
        for (Long billId : billIds) {
            List alldDown = searchIdAllDownMap.computeIfAbsent(billId, k -> new ArrayList());
            BotpUtils.searchDown(billId, srcBIllIdDownBillIds, alldDown);
        }
        HashMap<Long, Map<String, HashSet<Long>>> hashMap = new HashMap<Long, Map<String, HashSet<Long>>>(16);
        for (Long billId : billIds) {
            Map tableDown = hashMap.computeIfAbsent(billId, k -> new HashMap());
            List allDown = (List)searchIdAllDownMap.get(billId);
            for (Map.Entry item : linkBills.entrySet()) {
                String tableName = (String)item.getKey();
                Set ids = (Set)item.getValue();
                for (Long id : ids) {
                    if (!allDown.contains(id)) continue;
                    HashSet down = tableDown.computeIfAbsent(tableName, k -> new HashSet());
                    down.add(id);
                }
            }
        }
        return hashMap;
    }

    private static void searchDown(long srcId, Map<Long, List<Long>> srcBIllIdDownBillIds, List<Long> allDown) {
        if (srcBIllIdDownBillIds.containsKey(srcId)) {
            List<Long> downList = srcBIllIdDownBillIds.get(srcId);
            allDown.addAll(downList);
            for (Long s : downList) {
                BotpUtils.searchDown(s, srcBIllIdDownBillIds, allDown);
            }
        }
    }

    private static List<BFRow> readDownBillBFRows(Long srcMainTableId, Long[] srcBillIds) {
        if (srcBillIds == null || srcBillIds.length == 0) {
            return new ArrayList<BFRow>();
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter(KEY_S_TABLEID, "=", (Object)srcMainTableId));
        qFilters.add(new QFilter(KEY_S_BILLID, "in", (Object)srcBillIds));
        ArrayList<BFRow> rows = new ArrayList<BFRow>(srcBillIds.length);
        try (DataSet ds = ORM.create().queryDataSet("botpUtils", FORM_BOTP_BILLTRACKER, KEYS_STABLEID_SBILLID_TTABLEID_TBILLID, qFilters.toArray(new QFilter[0]));){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long sTableId = row.getLong(0);
                Long sBillId = row.getLong(1);
                Long tTableId = row.getLong(2);
                Long tBillId = row.getLong(3);
                BFRowId sRowId = new BFRowId(sTableId, sBillId, sTableId, sBillId);
                BFRowId rowId = new BFRowId(tTableId, tBillId, tTableId, tBillId);
                BFRow bfRow = new BFRow();
                bfRow.setSId(sRowId);
                bfRow.setId(rowId);
                rows.add(bfRow);
            }
        }
        return rows;
    }

    private static <T1, T2> boolean addToMap(Map<T1, Set<T2>> map, T1 groupId, T2 detail) {
        Set<T2> set = map.get(groupId);
        if (set == null) {
            set = new HashSet<T2>();
            map.put(groupId, set);
        }
        return set.add(detail);
    }

    private static HashSet<Long> readExistsBillIds(String entityNumber, Long[] billIds) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return new HashSet<Long>(0);
        }
        if (billIds == null || billIds.length == 0) {
            return new HashSet<Long>(0);
        }
        HashSet<Long> existBillIds = new HashSet<Long>(billIds.length);
        QFilter idfilter = new QFilter("id", "in", (Object)billIds);
        try (DataSet dataSet = ORM.create().queryDataSet("EntryTrackReader.readExistsBillIds", entityNumber, "id", new QFilter[]{idfilter});){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long billId = row.getLong("id");
                existBillIds.add(billId);
            }
        }
        return existBillIds;
    }
}

