/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bd.mpdm.common.mftorder.enums.ManuBillTaskStatusEnum;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bd.mpdm.common.utils.DyObjUtils;
import kd.bd.mpdm.common.utils.DynamicObjDataUtil;
import kd.bd.mpdm.common.utils.MPDMListUtils;
import kd.bd.mpdm.common.utils.MpdmDyObjUtils;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.commons.lang3.math.NumberUtils;

public class CheckManuOrderUtil {
    private static Log logger = LogFactory.getLog(CheckManuOrderUtil.class);

    public static StringBuffer checkManuOrderEntryStatus(String entityName, String checkType, String operationName, Object pk, String orderName) {
        StringBuffer errors = new StringBuffer();
        QFilter filter = new QFilter("treeentryentity.id", "=", pk);
        QFilter[] filters = new QFilter[]{filter};
        ORM orm = ORM.create();
        DynamicObjectCollection deptCol = orm.query(entityName, "id,billno,treeentryentity.id,treeentryentity.planstatus,treeentryentity.bizstatus", filters, "id");
        if (deptCol.size() == 0) {
            errors.append(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5bf9\u5e94%1$s\u5206\u5f55\u5df2\u88ab\u5220\u9664\u3002", (String)"CheckManuOrderUtil_25", (String)"bd-mpdm-common", (Object[])new Object[0]), orderName));
            return errors;
        }
        block0: for (int i = 0; i < deptCol.size(); ++i) {
            DynamicObject obj = (DynamicObject)deptCol.get(i);
            for (int j = 0; j < obj.getDynamicObjectCollection("treeentryentity").size(); ++j) {
                String info;
                DynamicObject manuEntryObj = (DynamicObject)obj.getDynamicObjectCollection("treeentryentity").get(j);
                if (!pk.equals(manuEntryObj.getPkValue())) continue;
                if ("checkTaskStatus".equals(checkType)) {
                    if ("B".equals(manuEntryObj.getString("bizstatus"))) {
                        info = String.format(ResManager.loadKDString((String)"%1$s\uff08\u7f16\u53f7\uff1a%2$s\uff1b\u884c\u53f7\uff1a%3$s\uff09\u7684\u4e1a\u52a1\u72b6\u6001\u4e3a\u6302\u8d77\uff0c\u4e0d\u5141\u8bb8\u6539\u53d8\u5de5\u5e8f\u72b6\u6001\u3002", (String)"CheckManuOrderUtil_21", (String)"bd-mpdm-common", (Object[])new Object[0]), orderName, obj.get("billno"), j) + "\n";
                        errors.append(info);
                        continue block0;
                    }
                    if ("C".equals(manuEntryObj.getString("bizstatus"))) {
                        info = String.format(ResManager.loadKDString((String)"%1$s\uff08\u7f16\u53f7\uff1a%2$s\uff1b\u884c\u53f7\uff1a%3$s\uff09\u7684\u4e1a\u52a1\u72b6\u6001\u4e3a\u5173\u95ed\uff0c\u4e0d\u5141\u8bb8\u6539\u53d8\u5de5\u5e8f\u72b6\u6001\u3002", (String)"CheckManuOrderUtil_22", (String)"bd-mpdm-common", (Object[])new Object[0]), orderName, obj.get("billno"), j) + "\n";
                        errors.append(info);
                        continue block0;
                    }
                    if (!"D".equals(manuEntryObj.getString("bizstatus"))) continue block0;
                    info = String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u884c\u4e1a\u52a1\u72b6\u6001\u4e3a\u7ed3\u6848\uff0c\u4e0d\u5141\u8bb8\u6539\u53d8\u5de5\u5e8f\u72b6\u6001\u3002", (String)"CheckManuOrderUtil_23", (String)"bd-mpdm-common", (Object[])new Object[0]), orderName, obj.get("billno")) + "\n";
                    errors.append(info);
                    continue block0;
                }
                if (!"checkBizStatus".equals(checkType) || "C".equals(manuEntryObj.getString("planstatus"))) continue block0;
                info = String.format(ResManager.loadKDString((String)"%1$s\uff08\u7f16\u53f7\uff1a%2$s\uff1b\u884c\u53f7\uff1a%3$s\uff09\u7684\u8ba1\u5212\u72b6\u6001\u4e0d\u4e3a\u4e0b\u8fbe\uff0c\u4e0d\u5141\u8bb8%4$s\u3002", (String)"CheckManuOrderUtil_24", (String)"bd-mpdm-common", (Object[])new Object[0]), orderName, obj.get("billno"), j + 1, operationName) + "\n";
                errors.append(info);
                continue block0;
            }
        }
        return errors;
    }

    public static void updateManuOrderEntryStatus2(String orderType, String status, String operateKey, Set<Object> entryPks, DynamicObject[] technicsBills) {
        QFilter filter = new QFilter("treeentryentity.id", "in", entryPks);
        HashSet<Long> beginWorkOrderEntryIds = new HashSet<Long>(16);
        HashSet<Long> unBeginWorkOrderEntryIds = new HashSet<Long>(16);
        Date date = new Date();
        DynamicObject[] mftOrders = BusinessDataServiceHelper.load((String)orderType, (String)"org,isinitbill,id,pid,taskstatus,producttype,startworktime,quainwaqty,unquainwaqty,scrinwaqty,baseqty", (QFilter[])new QFilter[]{filter});
        Map<Long, Date> costSubOneDateMap = CheckManuOrderUtil.getCostSubOneDateMap(mftOrders);
        for (int i = 0; i < mftOrders.length; ++i) {
            boolean isinitbill = mftOrders[i].containsProperty("isinitbill") && mftOrders[i].getBoolean("isinitbill");
            Long orgID = MpdmDyObjUtils.getDyObjId(mftOrders[i].get("org"));
            for (int j = 0; j < mftOrders[i].getDynamicObjectCollection("treeentryentity").size(); ++j) {
                DynamicObject entryObj = (DynamicObject)mftOrders[i].getDynamicObjectCollection("treeentryentity").get(j);
                ArrayList<DynamicObject> subEntryObjs = new ArrayList<DynamicObject>();
                for (int k = 0; k < mftOrders[i].getDynamicObjectCollection("treeentryentity").size(); ++k) {
                    if (!entryObj.getPkValue().toString().equals(((DynamicObject)mftOrders[i].getDynamicObjectCollection("treeentryentity").get(k)).get("pid").toString())) continue;
                    subEntryObjs.add((DynamicObject)mftOrders[i].getDynamicObjectCollection("treeentryentity").get(k));
                }
                for (Object o : entryPks) {
                    boolean finish;
                    if (!o.equals(entryObj.getPkValue())) continue;
                    boolean start = operateKey.contains("start") && "E".equals(status) && !"B".equals(entryObj.getString("taskstatus")) && !"C".equals(entryObj.getString("taskstatus")) && !"D".equals(entryObj.getString("taskstatus"));
                    boolean bl = finish = operateKey.contains("finish") && "F".equals(status) && !"B".equals(entryObj.getString("taskstatus")) && !"C".equals(entryObj.getString("taskstatus")) && !"D".equals(entryObj.getString("taskstatus"));
                    if (start || finish) {
                        String taskStatus = "B";
                        if (isinitbill) {
                            date = costSubOneDateMap.get(orgID);
                            if (date == null) {
                                date = new Date();
                            }
                            taskStatus = CheckManuOrderUtil.getTaskStatus(entryObj);
                        }
                        entryObj.set("taskstatus", (Object)taskStatus);
                        entryObj.set("startworktime", (Object)date);
                        CheckManuOrderUtil.updateSubEntryObjs(subEntryObjs, taskStatus, date);
                        beginWorkOrderEntryIds.add(entryObj.getLong("id"));
                    }
                    if (!operateKey.contains("unrelease") && !operateKey.contains("unplan") && !operateKey.contains("unconfirm")) continue;
                    for (int k = 0; k < technicsBills.length; ++k) {
                        DynamicObjectCollection dynamicObjectCollection;
                        List collect;
                        if (!entryObj.getPkValue().equals(technicsBills[k].getDynamicObject("mftentryseq").getPkValue()) || (collect = (dynamicObjectCollection = technicsBills[k].getDynamicObjectCollection("oprentryentity")).stream().map(x -> x.getString("oprstatus")).collect(Collectors.toList())).contains("E") || collect.contains("F") || collect.contains("G")) continue;
                        entryObj.set("taskstatus", (Object)"A");
                        entryObj.set("startworktime", null);
                        CheckManuOrderUtil.updateSubEntryObjs(subEntryObjs, "A", null);
                        unBeginWorkOrderEntryIds.add(entryObj.getLong("id"));
                    }
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])mftOrders);
        String accountId = RequestContext.get().getAccountId();
        String cacheKey = accountId + "bd-mpdm-technicstplop";
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(cacheKey);
        if (!beginWorkOrderEntryIds.isEmpty()) {
            String beginWorkOrderEntryIdsStr = JSONObject.toJSON(beginWorkOrderEntryIds).toString();
            cache.put("beginWorkOrderEntryIds", (Object)beginWorkOrderEntryIdsStr);
        }
        if (!unBeginWorkOrderEntryIds.isEmpty()) {
            String unBeginWorkOrderEntryIdsStr = JSONObject.toJSON(unBeginWorkOrderEntryIds).toString();
            cache.put("unBeginWorkOrderEntryIds", (Object)unBeginWorkOrderEntryIdsStr);
        }
    }

    public static void changeMftOrderManuftechstatus(String entityName, String status, Object pkvalue) {
        QFilter qFilter = new QFilter("treeentryentity.id", "=", pkvalue);
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((String)entityName, (String)CheckManuOrderUtil.selectField(), (QFilter[])new QFilter[]{qFilter});
        if (loadSingle != null) {
            for (DynamicObject Dynamic : loadSingle.getDynamicObjectCollection("treeentryentity")) {
                if (!Dynamic.getPkValue().equals(pkvalue)) continue;
                Dynamic.set("manftechstatus", (Object)status);
                SaveServiceHelper.update((DynamicObject)loadSingle);
                break;
            }
        }
    }

    private static String selectField() {
        StringBuilder selField = new StringBuilder();
        selField.append("id");
        selField.append(',').append("treeentryentity").append(".id");
        selField.append(',').append("treeentryentity").append('.').append("manftechstatus");
        selField.append(',').append("treeentryentity").append('.').append("planbegintime");
        selField.append(',').append("treeentryentity").append('.').append("planendtime");
        return selField.toString();
    }

    public static void updateMftStockByFetchBill(String entityName, DynamicObject[] fetchBills) {
        List<Long> orderIDs = DyObjUtils.getDyObjIdLst(fetchBills, "mftentryseq");
        QFilter qf = new QFilter("orderentryid", "in", orderIDs);
        String selectProperties = "id,org,billstatus,orderentryid,stockentry,stockentry.cansendqty,stockentry.isbackflush,stockentry.oprworkcenter,stockentry.warehouseid,stockentry.location,stockentry.processseq,stockentry.oprno,stockentry.machiningtype,stockentry.outsupplier,stockentry.workprocedureid,stockentry.workstation,stockentry.operationdesc,stockentry.leadtime,stockentry.demanddate";
        if ("pom_mftstock".equals(entityName)) {
            selectProperties = selectProperties + ",stockentry.beginworkbf";
        }
        DynamicObject[] stockBillLst = BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])qf.toArray());
        Map<Long, List<DynamicObject>> stockBillMap = Stream.of(stockBillLst).collect(Collectors.groupingBy(p -> p.getDynamicObject("orderentryid").getLong("id")));
        for (DynamicObject fetchBill : fetchBills) {
            Long orderEntryID;
            List<DynamicObject> stockLst;
            Object mftentryseqObj = fetchBill.get("mftentryseq");
            if (mftentryseqObj == null || (stockLst = stockBillMap.get(orderEntryID = DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)mftentryseqObj))) == null || stockLst.size() < 1) continue;
            DynamicObject stockBill = stockLst.get(0);
            DynamicObject mtfOrg = stockBill.getDynamicObject("org");
            DynamicObjectCollection entryCol = stockBill.getDynamicObjectCollection("stockentry");
            for (int i = 0; i < entryCol.size(); ++i) {
                DynamicObject stockBillEntry = (DynamicObject)entryCol.get(i);
                CheckManuOrderUtil.updateMftStockEntry(entityName, stockBillEntry, fetchBill);
                if (!"A".equals(stockBill.getString("billstatus"))) continue;
                MPDMMftGenStocksUtils.setStockEntryWarehouse(mtfOrg, stockBillEntry, stockBill.getDynamicObject("orderentryid"));
            }
        }
        SaveServiceHelper.update((DynamicObject[])stockBillLst);
    }

    @Deprecated
    public static void updateMftStock(String entityName, DynamicObject load, Object pkvalue) {
        DynamicObject stockBill;
        QFilter qfilter = new QFilter("orderentryid", "=", pkvalue);
        String selectProperties = "id,org,billstatus,orderentryid,stockentry,stockentry.cansendqty,stockentry.isbackflush,stockentry.oprworkcenter,stockentry.warehouseid,stockentry.location,stockentry.processseq,stockentry.oprno,stockentry.machiningtype,stockentry.outsupplier,stockentry.workprocedureid,stockentry.workstation,stockentry.operationdesc,stockentry.leadtime,stockentry.demanddate";
        if ("pom_mftstock".equals(entityName)) {
            selectProperties = selectProperties + ",stockentry.beginworkbf";
        }
        if ((stockBill = BusinessDataServiceHelper.loadSingle((String)entityName, (String)selectProperties, (QFilter[])new QFilter[]{qfilter})) == null) {
            return;
        }
        DynamicObject mtfOrg = stockBill.getDynamicObject("org");
        DynamicObjectCollection entryCol = stockBill.getDynamicObjectCollection("stockentry");
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject stockBillEntry = (DynamicObject)entryCol.get(i);
            CheckManuOrderUtil.updateMftStockEntry(entityName, stockBillEntry, load);
            if (!"A".equals(stockBill.getString("billstatus"))) continue;
            MPDMMftGenStocksUtils.setStockEntryWarehouse(mtfOrg, stockBillEntry, stockBill.getDynamicObject("orderentryid"));
        }
        SaveServiceHelper.update((DynamicObject)stockBill);
    }

    private static void updateMftStockEntry(String entityName, DynamicObject stockBillEntry, DynamicObject load) {
        if (load == null) {
            return;
        }
        String name = load.getDataEntityType().getName();
        DynamicObjectCollection workPlanEntrys = load.getDynamicObjectCollection("oprentryentity");
        boolean label = false;
        int seqInt = NumberUtils.toInt((String)stockBillEntry.getString("processseq"));
        String oprno = stockBillEntry.getString("oprno");
        logger.info("seqInt={} oprno={}", (Object)seqInt, (Object)oprno);
        DynamicObject defaultWorkPlanEntry = null;
        Optional<DynamicObject> pointWorkPlanEntrys = workPlanEntrys.stream().filter(workPlanEntry -> NumberUtils.toInt((String)workPlanEntry.getString("oprparent")) == seqInt && StringUtils.equals((CharSequence)workPlanEntry.getString("oprno"), (CharSequence)oprno)).findFirst();
        if ("prop_mftstock".equalsIgnoreCase(entityName)) {
            logger.info("\u6d41\u7a0b\u5de5\u5e8f\u8ba1\u5212\u91cd\u65b0\u83b7\u53d6");
            pointWorkPlanEntrys = workPlanEntrys.stream().filter(workPlanEntry -> StringUtils.equals((CharSequence)workPlanEntry.getString("oprno"), (CharSequence)oprno)).findFirst();
        }
        if (pointWorkPlanEntrys.isPresent()) {
            defaultWorkPlanEntry = pointWorkPlanEntrys.get();
        } else {
            logger.info("\u6d41\u7a0b\u5de5\u5e8f\u8ba1\u5212\u5206\u5f55\u4e3a\u7a7a");
            DynamicObjectCollection pros = load.getDynamicObjectCollection("proentryentity");
            for (DynamicObject pro : pros) {
                List collect;
                Optional<DynamicObject> minOpr;
                if (!"A".equals(pro.getString("processseqtype")) || !(minOpr = (collect = workPlanEntrys.stream().filter(var -> pro.getString("processseq").equals(var.get("oprparent"))).collect(Collectors.toList())).stream().min(Comparator.comparing(var -> var.getInt("oprno")))).isPresent()) continue;
                defaultWorkPlanEntry = minOpr.get();
            }
        }
        if (defaultWorkPlanEntry != null) {
            stockBillEntry.set("oprno", defaultWorkPlanEntry.get("oprno"));
            stockBillEntry.set("processseq", defaultWorkPlanEntry.get("oprparent"));
            if (stockBillEntry.containsProperty("oprworkcenter")) {
                stockBillEntry.set("oprworkcenter", defaultWorkPlanEntry.get("oprworkcenter"));
            }
            if (!"prop_mftstock".equalsIgnoreCase(entityName)) {
                stockBillEntry.set("outsupplier", defaultWorkPlanEntry.get("supplier"));
            }
            if (stockBillEntry.containsProperty("machiningtype")) {
                stockBillEntry.set("machiningtype", defaultWorkPlanEntry.get("machiningtype"));
            }
            stockBillEntry.set("workprocedureid", defaultWorkPlanEntry.get("oproperation"));
            if (stockBillEntry.containsProperty("workstation")) {
                stockBillEntry.set("workstation", defaultWorkPlanEntry.get("workstation"));
            }
            stockBillEntry.set("operationdesc", defaultWorkPlanEntry.get("oprdescription"));
            if ("sfc_manftech".equals(name)) {
                stockBillEntry.set("beginworkbf", defaultWorkPlanEntry.get("beginworkbf"));
            }
            BigDecimal leadTime = stockBillEntry.getBigDecimal("leadtime");
            Calendar c = Calendar.getInstance();
            c.setTime(defaultWorkPlanEntry.getDate("oprplanbegintime"));
            c.add(5, leadTime.intValue());
            Date planFinishTime = defaultWorkPlanEntry.getDate("oprplanfinishtime");
            stockBillEntry.set("demanddate", (Object)(c.getTime().getTime() > planFinishTime.getTime() ? planFinishTime : c.getTime()));
        }
    }

    public static Map<String, Object> getPmAppParameterMap(Long orgId) {
        AppParam appParam = new AppParam("064+TL0DU6T9", orgId, Long.valueOf(0L));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<String> changeEntryStatus(String entityName, String status, boolean cancel, String operateKey, Object object, DynamicObject technicsBill, DynamicObjectCollection entryCol, String orderName) {
        ArrayList<String> errors = new ArrayList<String>();
        int j = 0;
        while (j < entryCol.size()) {
            block37: {
                ArrayList<String> status1;
                block38: {
                    Boolean isoutbill;
                    StringBuffer error;
                    block41: {
                        block40: {
                            block39: {
                                if (!"sfc_manftech".equals(technicsBill.getDataEntityType().getName()) || "1002".equals(((DynamicObject)entryCol.get(j)).getString("machiningtype"))) {
                                    // empty if block
                                }
                                if (!object.toString().equals(((DynamicObject)entryCol.get(j)).getPkValue().toString())) break block37;
                                error = new StringBuffer();
                                if ("".equals(status)) break block38;
                                isoutbill = false;
                                DynamicObject transaction = technicsBill.getDynamicObject("transactiontype").getDynamicObject("transactiontype");
                                if (!"408".equals((transaction = BusinessDataServiceHelper.loadSingle((Object)transaction.getPkValue(), (String)"bd_biztype")).getString("number")) || !technicsBill.getDynamicObject("transactiontype").getBoolean("isprocedure")) break block39;
                                isoutbill = true;
                                break block40;
                            }
                            error = CheckManuOrderUtil.checkManuOrderEntryStatus(entityName, "checkTaskStatus", "", technicsBill.getDynamicObject("mftentryseq").getPkValue(), orderName);
                            if (error.length() <= 0) break block40;
                            errors.add(error.toString());
                            break block37;
                        }
                        if (!"C".equals(technicsBill.getString("billstatus"))) {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\uff08%1$s\uff09\u672a\u5ba1\u6838\u3002", (String)"CheckManuOrderUtil_26", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.getString("billno")));
                            return errors;
                        }
                        if (!((DynamicObject)entryCol.get(j)).getBoolean("oprinvalid")) break block41;
                        String format = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"CheckManuOrderUtil_6", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.getString("billno"), ((DynamicObject)entryCol.get(j)).getString("oprparent"), ((DynamicObject)entryCol.get(j)).getString("oprno"));
                        errors.add(format);
                        break block37;
                    }
                    String oldStatus = ((DynamicObject)entryCol.get(j)).getString("oprstatus");
                    switch (operateKey) {
                        case "donothing_confirm": {
                            status1 = new ArrayList<String>(Arrays.asList("A", "B"));
                            if (status1.contains(oldStatus)) break;
                            String format = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e0d\u6ee1\u8db3\u201c\u521b\u5efa\u201d\u6216\u8005\u201c\u8ba1\u5212\u201d\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"CheckManuOrderUtil_7", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.getString("billno"), ((DynamicObject)entryCol.get(j)).getString("oprparent"), ((DynamicObject)entryCol.get(j)).getString("oprno"));
                            errors.add(format);
                            break block37;
                        }
                        case "donothing_release": {
                            String format;
                            status1 = new ArrayList<String>(Arrays.asList("A", "B", "C"));
                            if (!status1.contains(oldStatus)) {
                                format = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e0d\u6ee1\u8db3\u201c\u8ba1\u5212\u201d\u6216\u8005\u201c\u8ba1\u5212\u786e\u8ba4\u201d\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"CheckManuOrderUtil_8", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.getString("billno"), ((DynamicObject)entryCol.get(j)).getString("oprparent"), ((DynamicObject)entryCol.get(j)).getString("oprno"));
                                errors.add(format);
                                break block37;
                            } else {
                                error = CheckManuOrderUtil.checkManuOrderEntryStatus(entityName, "checkBizStatus", "", technicsBill.getDynamicObject("mftentryseq").getPkValue(), orderName);
                                break;
                            }
                        }
                        case "donothing_start": {
                            String format;
                            if (!"D".contains(oldStatus)) {
                                format = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212[%1$s]\u5de5\u5e8f\u5e8f\u5217[%2$s]\u5de5\u5e8f\u53f7[%3$s]\u4e0d\u4e3a[\u8ba1\u5212\u4e0b\u8fbe]\u3002", (String)"CheckManuOrderUtil_9", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.getString("billno"), ((DynamicObject)entryCol.get(j)).getString("oprparent"), ((DynamicObject)entryCol.get(j)).getString("oprno"));
                                errors.add(format);
                                break block37;
                            } else {
                                error = CheckManuOrderUtil.checkManuOrderEntryStatus(entityName, "checkBizStatus", "", technicsBill.getDynamicObject("mftentryseq").getPkValue(), orderName);
                                break;
                            }
                        }
                        case "donothing_finish": {
                            String format;
                            status1 = new ArrayList<String>(Arrays.asList("D", "E"));
                            if (!status1.contains(oldStatus)) {
                                format = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212[%1$s]\u5de5\u5e8f\u5e8f\u5217[%2$s]\u5de5\u5e8f\u53f7[%3$s]\u4e0d\u4e3a[\u8ba1\u5212\u4e0b\u8fbe]\u6216[\u5f00\u5de5]\u3002", (String)"CheckManuOrderUtil_10", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.getString("billno"), ((DynamicObject)entryCol.get(j)).getString("oprparent"), ((DynamicObject)entryCol.get(j)).getString("oprno"));
                                errors.add(format);
                                break block37;
                            } else {
                                error = CheckManuOrderUtil.checkManuOrderEntryStatus(entityName, "checkBizStatus", "", technicsBill.getDynamicObject("mftentryseq").getPkValue(), orderName);
                                break;
                            }
                        }
                        case "donothing_closed": {
                            String format;
                            if (!"F".contains(oldStatus)) {
                                format = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e0d\u6ee1\u8db3\u201c\u5b8c\u5de5\u201d\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"CheckManuOrderUtil_20", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.getString("billno"), ((DynamicObject)entryCol.get(j)).getString("oprparent"), ((DynamicObject)entryCol.get(j)).getString("oprno"));
                                errors.add(format);
                                break block37;
                            } else {
                                error = CheckManuOrderUtil.checkManuOrderEntryStatus(entityName, "checkBizStatus", "", technicsBill.getDynamicObject("mftentryseq").getPkValue(), orderName);
                                break;
                            }
                        }
                        case "donothing_unplan": {
                            status1 = new ArrayList<String>(Arrays.asList("C", "D", "E", "F", "G"));
                            if (status1.contains(oldStatus)) break;
                            String format = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e0d\u6ee1\u8db3\u201c\u8ba1\u5212\u786e\u8ba4\u201d\u3001\u201c\u4e0b\u8fbe\u201d\u3001\u201c\u5f00\u5de5\u201d\u3001\u201c\u5b8c\u5de5\u201d\u6216\u8005\u201c\u5173\u95ed\u201d\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"CheckManuOrderUtil_11", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.getString("billno"), ((DynamicObject)entryCol.get(j)).getString("oprparent"), ((DynamicObject)entryCol.get(j)).getString("oprno"));
                            errors.add(format);
                            break block37;
                        }
                        case "donothing_unconfirm": {
                            status1 = new ArrayList<String>(Arrays.asList("D", "E", "F", "G"));
                            if (status1.contains(oldStatus)) break;
                            String format = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e0d\u6ee1\u8db3\u201c\u4e0b\u8fbe\u201d\u3001\u201c\u5f00\u5de5\u201d\u3001\u201c\u5b8c\u5de5\u201d\u6216\u8005\u201c\u5173\u95ed\u201d\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"CheckManuOrderUtil_13", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.getString("billno"), ((DynamicObject)entryCol.get(j)).getString("oprparent"), ((DynamicObject)entryCol.get(j)).getString("oprno"));
                            errors.add(format);
                            break block37;
                        }
                        case "donothing_unrelease": {
                            status1 = new ArrayList<String>(Arrays.asList("E", "F", "G"));
                            if (status1.contains(oldStatus)) break;
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e0d\u6ee1\u8db3\u201c\u5f00\u5de5\u201d\u3001\u201c\u5b8c\u5de5\u201d\u6216\u8005\u201c\u5173\u95ed\u201d\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"CheckManuOrderUtil_14", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.get("billno"), ((DynamicObject)entryCol.get(j)).get("oprparent"), ((DynamicObject)entryCol.get(j)).get("oprno")));
                            break block37;
                        }
                        case "donothing_unstart": {
                            status1 = new ArrayList<String>(Arrays.asList("F", "G"));
                            if (status1.contains(oldStatus)) break;
                            String format = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e0d\u6ee1\u8db3\u201c\u5b8c\u5de5\u201d\u6216\u8005\u201c\u5173\u95ed\u201d\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"CheckManuOrderUtil_18", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.getString("billno"), ((DynamicObject)entryCol.get(j)).getString("oprparent"), ((DynamicObject)entryCol.get(j)).getString("oprno"));
                            errors.add(format);
                            break block37;
                        }
                        case "donothing_unfinish": {
                            if ("G".contains(oldStatus)) break;
                            String format = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e0d\u6ee1\u8db3\u201c\u5173\u95ed\u201d\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"CheckManuOrderUtil_19", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.getString("billno"), ((DynamicObject)entryCol.get(j)).getString("oprparent"), ((DynamicObject)entryCol.get(j)).getString("oprno"));
                            errors.add(format);
                            break block37;
                        }
                    }
                    if (error.length() <= 0) {
                        long userId = Long.parseLong(RequestContext.get().getUserId());
                        technicsBill.set("modifier", (Object)userId);
                        technicsBill.set("modifytime", (Object)new Date());
                        ((DynamicObject)entryCol.get(j)).set("oprstatus", (Object)status);
                        SaveServiceHelper.update((DynamicObject)technicsBill);
                        if (isoutbill != false) return errors;
                        HashSet<Object> entryPks = new HashSet<Object>(1);
                        entryPks.add(technicsBill.getDynamicObject("mftentryseq").getPkValue());
                        DynamicObject[] technicsBills = new DynamicObject[]{technicsBill};
                        CheckManuOrderUtil.updateManuOrderEntryStatus2(entityName, status, operateKey, entryPks, technicsBills);
                        return errors;
                    }
                    errors.add(error.toString());
                    break block37;
                }
                String oldStatus = ((DynamicObject)entryCol.get(j)).getString("oprstatus");
                status1 = new ArrayList<String>(Arrays.asList("A", "B", "C"));
                if (!status1.contains(oldStatus)) return errors;
                if (!((DynamicObject)entryCol.get(j)).getBoolean("oprinvalid") || cancel) {
                    if (((DynamicObject)entryCol.get(j)).getBoolean("oprinvalid")) return errors;
                    if (!cancel) return errors;
                }
                ((DynamicObject)entryCol.get(j)).set("oprinvalid", (Object)cancel);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{technicsBill});
                return errors;
            }
            ++j;
        }
        return errors;
    }

    public static void changeOrderManuftechstatus(String entityName, String status, Set<Object> mftentryseqSet) {
        if (mftentryseqSet == null || mftentryseqSet.size() < 1) {
            return;
        }
        QFilter qFilter = new QFilter("treeentryentity.id", "in", mftentryseqSet);
        DynamicObject[] coll = BusinessDataServiceHelper.load((String)entityName, (String)CheckManuOrderUtil.selectField(), (QFilter[])new QFilter[]{qFilter});
        if (coll != null && coll.length > 0) {
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(coll.length);
            for (DynamicObject loadSingle : coll) {
                boolean isupdate = false;
                for (DynamicObject Dynamic : loadSingle.getDynamicObjectCollection("treeentryentity")) {
                    if (!mftentryseqSet.contains(Dynamic.getPkValue())) continue;
                    Dynamic.set("manftechstatus", (Object)status);
                    isupdate = true;
                }
                if (!isupdate) continue;
                updateList.add(loadSingle);
            }
            if (updateList.size() > 0) {
                SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
            }
        }
    }

    public static Map<Object, Object> updateManuStock(String entityName, Map<Long, DynamicObject> mftechMap, Set<Long> mftSeqIDSet) {
        DynamicObject[] stockBills;
        if (mftechMap == null || mftSeqIDSet == null || mftSeqIDSet.size() < 1) {
            return null;
        }
        HashMap<Object, Object> stockEntryIdAndWareHouseDynMap = new HashMap<Object, Object>(16);
        QFilter qfilter = new QFilter("orderentryid", "in", mftSeqIDSet);
        StringBuilder sf = new StringBuilder();
        sf.append("id,org,number,orderentryid,stockentry");
        sf.append(",stockentry.cansendqty");
        sf.append(",").append("processseq");
        sf.append(",").append("oprno");
        sf.append(",").append("oprworkcenter");
        sf.append(",").append("machiningtype");
        sf.append(",").append("outsupplier");
        sf.append(",").append("workprocedureid");
        sf.append(",").append("workstation");
        sf.append(",").append("operationdesc");
        sf.append(",").append("warehouseid");
        sf.append(",").append("location");
        sf.append(",").append("billstatus");
        sf.append(",").append("stockentry.isbackflush");
        sf.append(",stockentry.leadtime,stockentry.demanddate");
        if ("pom_mftstock".equals(entityName)) {
            sf.append(",").append("stockentry.beginworkbf");
        }
        if ((stockBills = BusinessDataServiceHelper.load((String)entityName, (String)sf.toString(), (QFilter[])new QFilter[]{qfilter})) == null || stockBills.length < 1) {
            return null;
        }
        ArrayList<DynamicObject> updateStockColl = new ArrayList<DynamicObject>(stockBills.length);
        for (DynamicObject stockBill : stockBills) {
            DynamicObject stockBillEntry;
            int i;
            DynamicObject mtfOrg = stockBill.getDynamicObject("org");
            DynamicObjectCollection entryCol = stockBill.getDynamicObjectCollection("stockentry");
            for (i = 0; i < entryCol.size(); ++i) {
                stockBillEntry = (DynamicObject)entryCol.get(i);
                CheckManuOrderUtil.updateMftStockEntry(entityName, stockBillEntry, mftechMap.get(stockBill.getDynamicObject("orderentryid").getPkValue()));
            }
            if ("A".equals(stockBill.getString("billstatus"))) {
                for (i = 0; i < entryCol.size(); ++i) {
                    stockBillEntry = (DynamicObject)entryCol.get(i);
                    MPDMMftGenStocksUtils.setStockEntryWarehouse(mtfOrg, stockBillEntry, stockBill.getDynamicObject("orderentryid"));
                    stockEntryIdAndWareHouseDynMap.put(stockBillEntry.getPkValue(), stockBillEntry.getDynamicObject("warehouseid"));
                }
            }
            updateStockColl.add(stockBill);
        }
        SaveServiceHelper.update((DynamicObject[])updateStockColl.toArray(new DynamicObject[updateStockColl.size()]));
        return stockEntryIdAndWareHouseDynMap;
    }

    public static Map<Object, Object> updateWareHouseManuStock(List<DynamicObject> stockBills, Map<Long, DynamicObject> mftechMap, Set<Long> mftSeqIDSet) {
        if (mftechMap == null || mftSeqIDSet == null || mftSeqIDSet.size() < 1) {
            return null;
        }
        HashMap<Object, Object> stockEntryIdAndWareHouseDynMap = new HashMap<Object, Object>(16);
        for (DynamicObject stockBill : stockBills) {
            DynamicObject stockBillEntry;
            int i;
            DynamicObject mtfOrg = stockBill.getDynamicObject("org");
            DynamicObjectCollection entryCol = stockBill.getDynamicObjectCollection("stockentry");
            for (i = 0; i < entryCol.size(); ++i) {
                stockBillEntry = (DynamicObject)entryCol.get(i);
                CheckManuOrderUtil.updateMftStockEntry(stockBill.getDataEntityType().getName(), stockBillEntry, mftechMap.get(stockBill.getDynamicObject("orderentryid").getPkValue()));
            }
            if (!"A".equals(stockBill.getString("billstatus"))) continue;
            for (i = 0; i < entryCol.size(); ++i) {
                stockBillEntry = (DynamicObject)entryCol.get(i);
                MPDMMftGenStocksUtils.setStockEntryWarehouse(mtfOrg, stockBillEntry, stockBill.getDynamicObject("orderentryid"));
                stockEntryIdAndWareHouseDynMap.put(stockBillEntry.getPkValue(), stockBillEntry.getDynamicObject("warehouseid"));
            }
        }
        return stockEntryIdAndWareHouseDynMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<String> changeEntryStatus(String entityName, String status, boolean cancel, String operateKey, List<Object> objects, DynamicObject[] technicsBills, String orderName) {
        Map<Long, DynamicObject> orderBizMap;
        Map<Long, DynamicObject> orderTaskMap;
        if (technicsBills == null || technicsBills.length < 1) {
            return null;
        }
        HashSet<String> objectSet = new HashSet<String>(objects.size());
        for (Object object : objects) {
            objectSet.add((String)object);
        }
        ArrayList<String> errors = new ArrayList<String>();
        Map<Object, Boolean> cacheMap = null;
        HashSet<Long> mftIDTaskSet = new HashSet<Long>(16);
        HashSet<Long> mftIDBizSet = new HashSet<Long>(16);
        DynamicObject[] dynamicObjectArray = technicsBills;
        int n = dynamicObjectArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                orderTaskMap = null;
                orderBizMap = null;
                if (mftIDTaskSet != null && mftIDTaskSet.size() > 0) {
                    orderTaskMap = CheckManuOrderUtil.getOrderObjByEntryId(mftIDTaskSet);
                }
                if (mftIDBizSet != null && mftIDBizSet.size() > 0) {
                    orderBizMap = CheckManuOrderUtil.getOrderObjByEntryId(mftIDTaskSet);
                }
                break;
            }
            DynamicObject technicsBill = dynamicObjectArray[n2];
            DynamicObjectCollection entryCol = technicsBill.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                if (!"sfc_manftech".equals(technicsBill.getDataEntityType().getName()) || "1002".equals(((DynamicObject)entryCol.get(j)).getString("machiningtype"))) {
                    // empty if block
                }
                if (!objectSet.contains(((DynamicObject)entryCol.get(j)).getPkValue().toString()) || "".equals(status)) continue;
                Boolean isoutbill = CheckManuOrderUtil.isOutBill(technicsBill.getDynamicObject("transactiontype"), cacheMap);
                if (!isoutbill.booleanValue()) {
                    mftIDTaskSet.add((Long)technicsBill.getDynamicObject("mftentryseq").getPkValue());
                }
                if (((DynamicObject)entryCol.get(j)).getBoolean("oprinvalid") || !operateKey.equals("donothing_release") && !operateKey.equals("donothing_start") && !operateKey.equals("donothing_finish") && !operateKey.equals("donothing_closed")) continue;
                mftIDBizSet.add((Long)technicsBill.getDynamicObject("mftentryseq").getPkValue());
            }
            ++n2;
        }
        long userId = RequestContext.get().getCurrUserId();
        Date curDate = new Date();
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(technicsBills.length);
        DynamicObject[] dynamicObjectArray2 = technicsBills;
        int n3 = dynamicObjectArray2.length;
        int n4 = 0;
        while (true) {
            DynamicObjectCollection entryCol;
            DynamicObject technicsBill;
            if (n4 < n3) {
                technicsBill = dynamicObjectArray2[n4];
                entryCol = technicsBill.getDynamicObjectCollection("oprentryentity");
            } else {
                if (updateList != null && updateList.size() > 0) {
                    SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
                }
                return errors;
            }
            block28: for (int j = 0; j < entryCol.size(); ++j) {
                ArrayList<String> status1;
                if (!"sfc_manftech".equals(technicsBill.getDataEntityType().getName()) || "1002".equals(((DynamicObject)entryCol.get(j)).getString("machiningtype"))) {
                    // empty if block
                }
                if (!objectSet.contains(((DynamicObject)entryCol.get(j)).getPkValue().toString())) continue;
                StringBuffer error = new StringBuffer();
                Long mftentryseqID = (Long)technicsBill.getDynamicObject("mftentryseq").getPkValue();
                if (!"".equals(status)) {
                    Boolean isoutbill = CheckManuOrderUtil.isOutBill(technicsBill.getDynamicObject("transactiontype"), cacheMap);
                    if (!isoutbill.booleanValue() && (error = CheckManuOrderUtil.checkManuOrderEntryStatus("checkTaskStatus", "", "", orderTaskMap == null ? null : orderTaskMap.get(mftentryseqID), mftentryseqID, orderName)).length() > 0) {
                        errors.add(error.toString());
                        continue;
                    }
                    if (!"C".equals(technicsBill.getString("billstatus"))) {
                        errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\uff08%s\uff09\u672a\u5ba1\u6838\u3002", (String)"CheckManuOrderUtil_27", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.getString("billno")));
                        return errors;
                    }
                    if (((DynamicObject)entryCol.get(j)).getBoolean("oprinvalid")) {
                        String format = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"CheckManuOrderUtil_6", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.getString("billno"), ((DynamicObject)entryCol.get(j)).getString("oprparent"), ((DynamicObject)entryCol.get(j)).getString("oprno"));
                        errors.add(format);
                        continue;
                    }
                    String oldStatus = ((DynamicObject)entryCol.get(j)).getString("oprstatus");
                    switch (operateKey) {
                        case "donothing_confirm": {
                            status1 = new ArrayList<String>(Arrays.asList("A", "B"));
                            if (status1.contains(oldStatus)) break;
                            String format = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e0d\u6ee1\u8db3\u201c\u521b\u5efa\u201d\u6216\u8005\u201c\u8ba1\u5212\u201d\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"CheckManuOrderUtil_7", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.getString("billno"), ((DynamicObject)entryCol.get(j)).getString("oprparent"), ((DynamicObject)entryCol.get(j)).getString("oprno"));
                            errors.add(format);
                            continue block28;
                        }
                        case "donothing_release": {
                            String format;
                            status1 = new ArrayList<String>(Arrays.asList("A", "B", "C"));
                            if (!status1.contains(oldStatus)) {
                                format = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e0d\u6ee1\u8db3\u201c\u8ba1\u5212\u201d\u6216\u8005\u201c\u8ba1\u5212\u786e\u8ba4\u201d\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"CheckManuOrderUtil_8", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.getString("billno"), ((DynamicObject)entryCol.get(j)).getString("oprparent"), ((DynamicObject)entryCol.get(j)).getString("oprno"));
                                errors.add(format);
                                continue block28;
                            }
                            error = CheckManuOrderUtil.checkManuOrderEntryStatus("checkBizStatus", "", "", orderBizMap == null ? null : orderBizMap.get(mftentryseqID), mftentryseqID, orderName);
                            break;
                        }
                        case "donothing_start": {
                            String format;
                            if (!"D".contains(oldStatus)) {
                                format = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212[%1$s]\u5de5\u5e8f\u5e8f\u5217[%2$s]\u5de5\u5e8f\u53f7[%3$s]\u4e0d\u4e3a[\u8ba1\u5212\u4e0b\u8fbe]\u3002", (String)"CheckManuOrderUtil_9", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.getString("billno"), ((DynamicObject)entryCol.get(j)).getString("oprparent"), ((DynamicObject)entryCol.get(j)).getString("oprno"));
                                errors.add(format);
                                continue block28;
                            }
                            error = CheckManuOrderUtil.checkManuOrderEntryStatus("checkBizStatus", "", "", orderBizMap == null ? null : orderBizMap.get(mftentryseqID), mftentryseqID, orderName);
                            break;
                        }
                        case "donothing_finish": {
                            String format;
                            status1 = new ArrayList<String>(Arrays.asList("D", "E"));
                            if (!status1.contains(oldStatus)) {
                                format = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212[%1$s]\u5de5\u5e8f\u5e8f\u5217[%2$s]\u5de5\u5e8f\u53f7[%3$s]\u4e0d\u4e3a[\u8ba1\u5212\u4e0b\u8fbe]\u6216[\u5f00\u5de5]\u3002", (String)"CheckManuOrderUtil_10", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.getString("billno"), ((DynamicObject)entryCol.get(j)).getString("oprparent"), ((DynamicObject)entryCol.get(j)).getString("oprno"));
                                errors.add(format);
                                continue block28;
                            }
                            error = CheckManuOrderUtil.checkManuOrderEntryStatus("checkBizStatus", "", "", orderBizMap == null ? null : orderBizMap.get(mftentryseqID), mftentryseqID, orderName);
                            break;
                        }
                        case "donothing_closed": {
                            String format;
                            if (!"F".contains(oldStatus)) {
                                format = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e0d\u6ee1\u8db3\u201c\u5b8c\u5de5\u201d\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"CheckManuOrderUtil_20", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.getString("billno"), ((DynamicObject)entryCol.get(j)).getString("oprparent"), ((DynamicObject)entryCol.get(j)).getString("oprno"));
                                errors.add(format);
                                continue block28;
                            }
                            error = CheckManuOrderUtil.checkManuOrderEntryStatus("checkBizStatus", "", "", orderBizMap == null ? null : orderBizMap.get(mftentryseqID), mftentryseqID, orderName);
                            break;
                        }
                        case "donothing_unplan": {
                            status1 = new ArrayList<String>(Arrays.asList("C", "D", "E", "F", "G"));
                            if (status1.contains(oldStatus)) break;
                            String format = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e0d\u6ee1\u8db3\u201c\u8ba1\u5212\u786e\u8ba4\u201d\u3001\u201c\u4e0b\u8fbe\u201d\u3001\u201c\u5f00\u5de5\u201d\u3001\u201c\u5b8c\u5de5\u201d\u6216\u8005\u201c\u5173\u95ed\u201d\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"CheckManuOrderUtil_11", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.getString("billno"), ((DynamicObject)entryCol.get(j)).getString("oprparent"), ((DynamicObject)entryCol.get(j)).getString("oprno"));
                            errors.add(format);
                            continue block28;
                        }
                        case "donothing_unconfirm": {
                            status1 = new ArrayList<String>(Arrays.asList("D", "E", "F", "G"));
                            if (status1.contains(oldStatus)) break;
                            String format = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e0d\u6ee1\u8db3\u201c\u4e0b\u8fbe\u201d\u3001\u201c\u5f00\u5de5\u201d\u3001\u201c\u5b8c\u5de5\u201d\u6216\u8005\u201c\u5173\u95ed\u201d\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"CheckManuOrderUtil_13", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.getString("billno"), ((DynamicObject)entryCol.get(j)).getString("oprparent"), ((DynamicObject)entryCol.get(j)).getString("oprno"));
                            errors.add(format);
                            continue block28;
                        }
                        case "donothing_unrelease": {
                            status1 = new ArrayList<String>(Arrays.asList("E", "F", "G"));
                            if (status1.contains(oldStatus)) break;
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e0d\u6ee1\u8db3\u201c\u5f00\u5de5\u201d\u3001\u201c\u5b8c\u5de5\u201d\u6216\u8005\u201c\u5173\u95ed\u201d\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"CheckManuOrderUtil_14", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.get("billno"), ((DynamicObject)entryCol.get(j)).get("oprparent"), ((DynamicObject)entryCol.get(j)).get("oprno")));
                            continue block28;
                        }
                        case "donothing_unstart": {
                            status1 = new ArrayList<String>(Arrays.asList("F", "G"));
                            if (status1.contains(oldStatus)) break;
                            String format = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e0d\u6ee1\u8db3\u201c\u5b8c\u5de5\u201d\u6216\u8005\u201c\u5173\u95ed\u201d\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"CheckManuOrderUtil_18", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.getString("billno"), ((DynamicObject)entryCol.get(j)).getString("oprparent"), ((DynamicObject)entryCol.get(j)).getString("oprno"));
                            errors.add(format);
                            continue block28;
                        }
                        case "donothing_unfinish": {
                            if ("G".contains(oldStatus)) break;
                            String format = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e0d\u6ee1\u8db3\u201c\u5173\u95ed\u201d\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"CheckManuOrderUtil_19", (String)"bd-mpdm-common", (Object[])new Object[0]), technicsBill.getString("billno"), ((DynamicObject)entryCol.get(j)).getString("oprparent"), ((DynamicObject)entryCol.get(j)).getString("oprno"));
                            errors.add(format);
                            continue block28;
                        }
                    }
                    if (error.length() > 0) {
                        errors.add(error.toString());
                        continue;
                    }
                    ((DynamicObject)entryCol.get(j)).set("oprstatus", (Object)status);
                    technicsBill.set("modifier", (Object)userId);
                    technicsBill.set("modifytime", (Object)curDate);
                    updateList.add(technicsBill);
                    if (isoutbill.booleanValue()) break;
                    break;
                }
                String oldStatus = ((DynamicObject)entryCol.get(j)).getString("oprstatus");
                status1 = new ArrayList<String>(Arrays.asList("A", "B", "C"));
                if (!status1.contains(oldStatus) || (!((DynamicObject)entryCol.get(j)).getBoolean("oprinvalid") || cancel) && (((DynamicObject)entryCol.get(j)).getBoolean("oprinvalid") || !cancel)) break;
                ((DynamicObject)entryCol.get(j)).set("oprinvalid", (Object)cancel);
                updateList.add(technicsBill);
                break;
            }
            ++n4;
        }
    }

    public static boolean isOutBill(DynamicObject transaction, Map<Object, Boolean> cacheMap) {
        if (transaction == null) {
            return false;
        }
        if (cacheMap == null) {
            cacheMap = new HashMap<Object, Boolean>(16);
        }
        if (cacheMap.containsKey(transaction.getPkValue())) {
            return cacheMap.get(transaction.getPkValue());
        }
        Boolean isoutbill = false;
        DynamicObject bizType = transaction.getDynamicObject("transactiontype");
        if ("408".equals((bizType = BusinessDataServiceHelper.loadSingleFromCache((Object)bizType.getPkValue(), (String)"bd_biztype", (String)"number")).getString("number")) && transaction.getBoolean("isprocedure")) {
            isoutbill = true;
        }
        cacheMap.put(transaction.getPkValue(), isoutbill);
        return isoutbill;
    }

    public static Map<Long, DynamicObject> getOrderObjByEntryId(Set<Long> orderEntryIds) {
        QFilter filter = new QFilter("treeentryentity.id", "in", orderEntryIds);
        String selectFields = "id,billno,billstatus,treeentryentity.id,treeentryentity.materielmasterid,treeentryentity.baseunit,treeentryentity.bizstatus,treeentryentity.planstatus,treeentryentity.pid,treeentryentity.taskstatus";
        DynamicObject[] dyColl = BusinessDataServiceHelper.load((String)"pom_mftorder", (String)selectFields, (QFilter[])new QFilter[]{filter});
        HashMap<Long, DynamicObject> dyMap = new HashMap<Long, DynamicObject>(16);
        for (int i = 0; i < dyColl.length; ++i) {
            DynamicObject dy = dyColl[i];
            for (int j = 0; j < dy.getDynamicObjectCollection("treeentryentity").size(); ++j) {
                dyMap.put(((DynamicObject)dy.getDynamicObjectCollection("treeentryentity").get(j)).getLong("id"), dy);
            }
        }
        return dyMap;
    }

    public static StringBuffer checkManuOrderEntryStatus(String checkType, String billno, String operationName, DynamicObject orderDy, Long entryID, String orderName) {
        StringBuffer errors = new StringBuffer();
        if (orderDy == null || orderDy.getPkValue() == null) {
            errors.append(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5bf9\u5e94\u751f\u4ea7\u5de5\u5355\u5df2\u88ab\u5220\u9664\u3002\n", (String)"CheckManuOrderUtil_28", (String)"bd-mpdm-common", (Object[])new Object[0]));
            return errors;
        }
        boolean isfind = false;
        for (int j = 0; j < orderDy.getDynamicObjectCollection("treeentryentity").size(); ++j) {
            DynamicObject manuEntryObj = (DynamicObject)orderDy.getDynamicObjectCollection("treeentryentity").get(j);
            if (!entryID.equals(manuEntryObj.getPkValue())) continue;
            if ("checkTaskStatus".equals(checkType)) {
                if ("B".equals(manuEntryObj.getString("bizstatus"))) {
                    errors.append(String.format(ResManager.loadKDString((String)"%1$s\uff08\u7f16\u53f7\uff1a%2$s\uff1b\u884c\u53f7\uff1a%3$s\uff09\u7684\u4e1a\u52a1\u72b6\u6001\u4e3a\u6302\u8d77\uff0c\u4e0d\u5141\u8bb8\u6539\u53d8\u5de5\u5e8f\u72b6\u6001\u3002\n", (String)"CheckManuOrderUtil_29", (String)"bd-mpdm-common", (Object[])new Object[0]), orderName, orderDy.get("billno"), j));
                } else if ("C".equals(manuEntryObj.getString("bizstatus"))) {
                    errors.append(String.format(ResManager.loadKDString((String)"%1$s\uff08\u7f16\u53f7\uff1a%2$s\uff1b\u884c\u53f7\uff1a%3$s\uff09\u7684\u4e1a\u52a1\u72b6\u6001\u4e3a\u5173\u95ed\uff0c\u4e0d\u5141\u8bb8\u6539\u53d8\u5de5\u5e8f\u72b6\u6001\u3002\n", (String)"CheckManuOrderUtil_30", (String)"bd-mpdm-common", (Object[])new Object[0]), orderName, orderDy.get("billno"), j));
                } else if ("D".equals(manuEntryObj.getString("bizstatus"))) {
                    errors.append(String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u884c\u4e1a\u52a1\u72b6\u6001\u4e3a\u7ed3\u6848\uff0c\u4e0d\u5141\u8bb8\u6539\u53d8\u5de5\u5e8f\u72b6\u6001\u3002\n", (String)"CheckManuOrderUtil_31", (String)"bd-mpdm-common", (Object[])new Object[0]), orderName, orderDy.get("billno")));
                }
            } else if ("checkBizStatus".equals(checkType) && !"C".equals(manuEntryObj.getString("planstatus"))) {
                errors.append(String.format(ResManager.loadKDString((String)"%1$s\uff08\u7f16\u53f7\uff1a%2$s\uff1b\u884c\u53f7\uff1a%3$s\uff09\u7684\u8ba1\u5212\u72b6\u6001\u4e0d\u4e3a\u4e0b\u8fbe\uff0c\u4e0d\u5141\u8bb8%4$s\u3002\n", (String)"CheckManuOrderUtil_32", (String)"bd-mpdm-common", (Object[])new Object[0]), orderName, orderDy.get("billno"), j, operationName));
            }
            isfind = true;
            break;
        }
        if (!isfind) {
            errors.append(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5bf9\u5e94\u751f\u4ea7\u5de5\u5355\u5206\u5f55\u5df2\u88ab\u5220\u9664\u3002\n", (String)"CheckManuOrderUtil_33", (String)"bd-mpdm-common", (Object[])new Object[0]));
            return errors;
        }
        return errors;
    }

    public static void updateManuOrderEntryStatus(String orderType, String manftechType, DynamicObject orderDy, DynamicObject manftechDy, Long orderEntryID, Long manftechEntryID) {
        if (orderDy == null && (orderEntryID == null || orderEntryID == 0L)) {
            return;
        }
        if (manftechDy == null && (manftechEntryID == null || manftechEntryID == 0L)) {
            return;
        }
        orderDy = CheckManuOrderUtil.getOrderDy(orderType, orderDy, orderEntryID);
        manftechDy = CheckManuOrderUtil.getManfTechDy(manftechType, manftechDy, manftechEntryID);
        Object entryPk = manftechDy.getDynamicObject("mftentryseq").getPkValue();
        HashSet status = Sets.newHashSet((Object[])new String[]{"A", "B", "C", "D"});
        HashSet status1 = Sets.newHashSet((Object[])new String[]{"F", "G"});
        for (int i = 0; i < orderDy.getDynamicObjectCollection("treeentryentity").size(); ++i) {
            DynamicObject entryObj = (DynamicObject)orderDy.getDynamicObjectCollection("treeentryentity").get(i);
            if (!entryPk.equals(entryObj.getPkValue())) continue;
            ArrayList<DynamicObject> subEntryObjs = new ArrayList<DynamicObject>();
            for (int j = 0; j < orderDy.getDynamicObjectCollection("treeentryentity").size(); ++j) {
                if (!entryPk.toString().equals(((DynamicObject)orderDy.getDynamicObjectCollection("treeentryentity").get(j)).get("pid").toString())) continue;
                subEntryObjs.add((DynamicObject)orderDy.getDynamicObjectCollection("treeentryentity").get(j));
            }
            boolean flag = false;
            boolean flag1 = false;
            boolean flag2 = false;
            boolean isUpdate = false;
            for (int k = 0; k < manftechDy.getDynamicObjectCollection("oprentryentity").size(); ++k) {
                DynamicObject technicsEntryObj = (DynamicObject)manftechDy.getDynamicObjectCollection("oprentryentity").get(k);
                if (status.contains(technicsEntryObj.getString("oprstatus"))) {
                    flag = true;
                }
                if ("E".equals(technicsEntryObj.getString("oprstatus"))) {
                    flag1 = true;
                }
                if (!status1.contains(technicsEntryObj.getString("oprstatus"))) continue;
                flag2 = true;
            }
            if (flag) {
                if (flag1) {
                    if (flag2) {
                        if (!"D".equals(entryObj.getString("taskstatus"))) {
                            entryObj.set("taskstatus", (Object)"D");
                            CheckManuOrderUtil.updateSubEntryObjs(subEntryObjs, "D");
                            isUpdate = true;
                        }
                    } else if (!"B".equals(entryObj.getString("taskstatus"))) {
                        entryObj.set("taskstatus", (Object)"B");
                        CheckManuOrderUtil.updateSubEntryObjs(subEntryObjs, "B");
                        isUpdate = true;
                    }
                } else if (flag2) {
                    if (!"D".equals(entryObj.getString("taskstatus"))) {
                        entryObj.set("taskstatus", (Object)"D");
                        CheckManuOrderUtil.updateSubEntryObjs(subEntryObjs, "D");
                        isUpdate = true;
                    }
                } else if (!"A".equals(entryObj.getString("taskstatus"))) {
                    entryObj.set("taskstatus", (Object)"A");
                    CheckManuOrderUtil.updateSubEntryObjs(subEntryObjs, "A");
                    isUpdate = true;
                }
            } else if (flag1) {
                if (flag2) {
                    if (!"D".equals(entryObj.getString("taskstatus"))) {
                        entryObj.set("taskstatus", (Object)"D");
                        CheckManuOrderUtil.updateSubEntryObjs(subEntryObjs, "D");
                        isUpdate = true;
                    }
                } else if (!"B".equals(entryObj.getString("taskstatus"))) {
                    entryObj.set("taskstatus", (Object)"B");
                    CheckManuOrderUtil.updateSubEntryObjs(subEntryObjs, "B");
                    isUpdate = true;
                }
            } else if (flag2) {
                if (!"C".equals(entryObj.getString("taskstatus"))) {
                    entryObj.set("taskstatus", (Object)"C");
                    CheckManuOrderUtil.updateSubEntryObjs(subEntryObjs, "C");
                    isUpdate = true;
                }
            } else if (!"A".equals(entryObj.getString("taskstatus"))) {
                entryObj.set("taskstatus", (Object)"A");
                CheckManuOrderUtil.updateSubEntryObjs(subEntryObjs, "A");
                isUpdate = true;
            }
            if (!isUpdate) continue;
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{orderDy});
            DynamicObjectCollection entryEntity = orderDy.getDynamicObjectCollection("treeentryentity");
            if (entryEntity.isEmpty()) continue;
            IDataEntityType dataEntityType = ((DynamicObject)entryEntity.get(0)).getDataEntityType();
            DataEntityCacheManager cacheManager = new DataEntityCacheManager(dataEntityType);
            cacheManager.removeByDt();
        }
    }

    public static DynamicObject getOrderDy(String orderType, DynamicObject orderDy, Long orderEntryID) {
        if (orderDy != null) {
            return orderDy;
        }
        QFilter filter = new QFilter("treeentryentity.id", "=", (Object)orderEntryID);
        String selectFields = "id,treeentryentity.pid,treeentryentity.taskstatus,treeentryentity.id";
        orderDy = BusinessDataServiceHelper.loadSingle((String)orderType, (String)selectFields, (QFilter[])new QFilter[]{filter});
        return orderDy;
    }

    public static DynamicObject getManfTechDy(String manftechType, DynamicObject manftechDy, Long manftechEntryID) {
        if (manftechDy != null) {
            return manftechDy;
        }
        QFilter filter = new QFilter("oprentryentity.id", "=", (Object)manftechEntryID);
        String selectFields = "id,billno,oprentryentity.id,oprentryentity.oprstatus,billstatus,mftentryseq";
        manftechDy = BusinessDataServiceHelper.loadSingle((String)manftechType, (String)selectFields, (QFilter[])new QFilter[]{filter});
        return manftechDy;
    }

    private static void updateSubEntryObjs(List<DynamicObject> subEntryObjs, String value) {
        if (subEntryObjs == null || subEntryObjs.size() < 1) {
            return;
        }
        for (DynamicObject obj : subEntryObjs) {
            obj.set("taskstatus", (Object)value);
        }
    }

    private static void updateSubEntryObjs(List<DynamicObject> subEntryObjs, String value, Date date) {
        if (subEntryObjs == null || subEntryObjs.size() < 1) {
            return;
        }
        for (DynamicObject obj : subEntryObjs) {
            obj.set("taskstatus", (Object)value);
            obj.set("startworktime", (Object)date);
        }
    }

    private static List<Map<String, Object>> cadQueryStartCostAccountInfo(List<Long> orgIds, String orgViewType) {
        if (orgIds == null) {
            ErrorCode errorCode = new ErrorCode("paramError", "paramError");
            throw new KDBizException(errorCode, new Object[]{"orgIds is null"});
        }
        List<List<Long>> subList = MPDMListUtils.getSubList(500, orgIds);
        ArrayList<Map<String, Object>> returnMapList = new ArrayList<Map<String, Object>>(16);
        for (List<Long> orgLs : subList) {
            List mapList = (List)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"StartCostAccountService", (String)"queryStartCostAccountInfoList", (Object[])new Object[]{orgLs, orgViewType});
            returnMapList.addAll(mapList);
        }
        return returnMapList;
    }

    private static Map<Long, Date> getCostSubOneDateMap(Set<Long> orgIds) {
        HashMap<Long, Date> orgId_earliestBeginDate = new HashMap<Long, Date>(16);
        if (orgIds == null) {
            return orgId_earliestBeginDate;
        }
        if (orgIds.isEmpty()) {
            return orgId_earliestBeginDate;
        }
        List<Map<String, Object>> dataList = CheckManuOrderUtil.cadQueryStartCostAccountInfo(new ArrayList<Long>(orgIds), "04");
        for (Map<String, Object> dataMap : dataList) {
            Object earliestBeginDate;
            Object orgId = dataMap.get("orgId");
            if (orgId == null || !((earliestBeginDate = dataMap.get("earliestBeginDate")) instanceof Date)) continue;
            Date date = (Date)earliestBeginDate;
            orgId_earliestBeginDate.put(Long.valueOf(orgId.toString()), DateUtils.addDay(date, -1));
        }
        return orgId_earliestBeginDate;
    }

    private static Map<Long, Date> getCostSubOneDateMap(DynamicObject[] manuObjs) {
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (DynamicObject mftOrder : manuObjs) {
            Long orgID;
            boolean isinitbill;
            boolean bl = isinitbill = mftOrder.containsProperty("isinitbill") && mftOrder.getBoolean("isinitbill");
            if (!isinitbill || !MpdmDyObjUtils.isNotEmptyId(orgID = MpdmDyObjUtils.getDyObjId(mftOrder.get("org")))) continue;
            orgIds.add(orgID);
        }
        return CheckManuOrderUtil.getCostSubOneDateMap(orgIds);
    }

    private static String getTaskStatus(DynamicObject entry) {
        String taskStatus = "B";
        BigDecimal quainwaqty = entry.getBigDecimal("quainwaqty");
        BigDecimal unquainwaqty = entry.getBigDecimal("unquainwaqty");
        BigDecimal scrinwaqty = entry.getBigDecimal("scrinwaqty");
        BigDecimal baseqty = entry.getBigDecimal("baseqty");
        BigDecimal sum = quainwaqty.add(unquainwaqty).add(scrinwaqty);
        if (sum.compareTo(BigDecimal.ZERO) > 0 && sum.compareTo(baseqty) < 0) {
            taskStatus = ManuBillTaskStatusEnum.SOMEENDWORK.getValue();
        } else if (sum.compareTo(baseqty) >= 0) {
            taskStatus = ManuBillTaskStatusEnum.ENDWORK.getValue();
        }
        return taskStatus;
    }

    public static StringBuffer checkManuOrderEntryStatus(String checkType, String billno, String operationName, Map<String, Object> orderMap, String type) {
        StringBuffer errors = new StringBuffer();
        if (orderMap == null) {
            errors.append(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5bf9\u5e94%s\u5de5\u5355\u5206\u5f55\u5df2\u88ab\u5220\u9664\u3002", (String)"CheckManuOrderUtil_40", (String)"bd-mpdm-common", (Object[])new Object[0]), type)).append("\n");
            return errors;
        }
        if ("checkTaskStatus".equals(checkType)) {
            if ("B".equals(orderMap.get("treeentryentity.bizstatus"))) {
                errors.append(String.format(ResManager.loadKDString((String)"%1$s\u5de5\u5355[%2$s]\u884c\u4e1a\u52a1\u72b6\u6001\u72b6\u6001\u4e3a\u6302\u8d77,\u4e0d\u53ef\u4ee5\u6539\u53d8\u5de5\u5e8f\u72b6\u6001\u3002", (String)"CheckManuOrderUtil_41", (String)"bd-mpdm-common", (Object[])new Object[0]), type, orderMap.get("billno"))).append("\n");
            } else if ("C".equals(orderMap.get("treeentryentity.bizstatus"))) {
                errors.append(String.format(ResManager.loadKDString((String)"%1$s\u5de5\u5355[%2$s]\u884c\u4e1a\u52a1\u72b6\u6001\u72b6\u6001\u4e3a\u5173\u95ed,\u4e0d\u53ef\u4ee5\u6539\u53d8\u5de5\u5e8f\u72b6\u6001\u3002", (String)"CheckManuOrderUtil_42", (String)"bd-mpdm-common", (Object[])new Object[0]), type, orderMap.get("billno"))).append("\n");
            }
        } else if ("checkBizStatus".equals(checkType) && !"C".equals(orderMap.get("treeentryentity.planstatus"))) {
            errors.append(String.format(ResManager.loadKDString((String)"%1$s\u5de5\u5355[%2$s]\u884c\u8ba1\u5212\u72b6\u6001\u4e0d\u4e3a\u4e0b\u8fbe,\u4e0d\u5141\u8bb8", (String)"CheckManuOrderUtil_43", (String)"bd-mpdm-common", (Object[])new Object[0]), type, orderMap.get("billno"))).append(operationName).append("\u3002\n");
        }
        return errors;
    }
}

