/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;

public class DateUtils {
    public static Date getShortDate(Date source) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(source);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getAddDate(Date source, int days) {
        return org.apache.commons.lang3.time.DateUtils.addDays((Date)source, (int)days);
    }

    public static String transDate(Object value) {
        return new SimpleDateFormat("yyyy-MM-dd").format((Date)value);
    }

    public static Date addInteger(Date date, int dateType, int amount) {
        Date myDate = null;
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(dateType, amount);
            myDate = calendar.getTime();
        }
        return myDate;
    }

    public static Date addDay(Date date, int dayAmount) {
        return DateUtils.addInteger(date, 5, dayAmount);
    }

    public static int conpareToDate(String date1, String date2) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            Date dt1 = df.parse(date1);
            Date dt2 = df.parse(date2);
            long t1 = dt1.getTime();
            long t2 = dt2.getTime();
            long c = t2 - t1;
            if (c == 0L) {
                return 0;
            }
            BigDecimal tc = new BigDecimal(String.valueOf(c));
            tc = tc.divide(new BigDecimal(86400000), 10, RoundingMode.HALF_UP);
            return tc.intValue();
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\uff01", (String)"DateUtils_0", (String)"bd-mpdm-common", (Object[])new Object[0]));
        }
    }

    public static Date getYearFirstDate(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        return calendar.getTime();
    }

    public static Date getYearLastDate(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        return calendar.getTime();
    }

    public static Date getFirstDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int firstDay = cal.getActualMinimum(5);
        cal.set(5, firstDay);
        return cal.getTime();
    }

    public static Date getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        return cal.getTime();
    }

    public static List getYearList(Date start, Date end) {
        ArrayList yearList = new ArrayList(16);
        int beginYear = DateUtils.getYear(start);
        int endYear = DateUtils.getYear(end);
        for (int i = beginYear; i <= endYear; ++i) {
            HashMap<String, Object> week = new HashMap<String, Object>(16);
            week.put("index", i + "");
            Date beginDate = i == beginYear ? start : DateUtils.getYearFirstDate(i);
            Date endDate = i == endYear ? end : DateUtils.getYearLastDate(i);
            week.put("beginDate", beginDate);
            week.put("endDate", endDate);
            yearList.add(week);
        }
        return yearList;
    }

    public static int getYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static int getMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static int getDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static List getMonthList(Date start, Date end) {
        ArrayList monthList = new ArrayList(16);
        int beginYear = DateUtils.getYear(start);
        int beginMonth = DateUtils.getMonth(start);
        int diff = DateUtils.getMonth(start, end);
        for (int i = 0; i <= diff; ++i) {
            if (i > 0 && ++beginMonth > 12) {
                beginMonth = 1;
                ++beginYear;
            }
            Date beginDate = DateUtils.getFirstDayOfMonth(beginYear, beginMonth);
            Date endDate = DateUtils.getLastDayOfMonth(beginYear, beginMonth);
            HashMap<String, Object> week = new HashMap<String, Object>(16);
            week.put("index", beginYear + "-" + beginMonth);
            week.put("title", beginYear + "-" + beginMonth);
            week.put("beginDate", beginDate);
            week.put("endDate", endDate);
            monthList.add(week);
        }
        return monthList;
    }

    public static int getWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        return calendar.get(3);
    }

    public static int getMonth(Date start, Date end) {
        if (start.after(end)) {
            Date t = start;
            start = end;
            end = t;
        }
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        Calendar temp = Calendar.getInstance();
        temp.setTime(end);
        temp.add(5, 1);
        int year = endCalendar.get(1) - startCalendar.get(1);
        int month = endCalendar.get(2) - startCalendar.get(2);
        if (startCalendar.get(5) == 1 && temp.get(5) == 1) {
            return year * 12 + month + 1;
        }
        if (startCalendar.get(5) != 1 && temp.get(5) == 1) {
            return year * 12 + month;
        }
        if (startCalendar.get(5) == 1 && temp.get(5) != 1) {
            return year * 12 + month;
        }
        return year * 12 + month - 1 < 0 ? 0 : year * 12 + month;
    }

    public static Date getEndOfDay(Date date) {
        if (date == null) {
            date = new Date();
        }
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime endOfDay = localDateTime.with(LocalTime.MAX);
        return Date.from(endOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getStartOfDay(Date date) {
        if (date == null) {
            date = new Date();
        }
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime startOfDay = localDateTime.with(LocalTime.MIN);
        return Date.from(startOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getWeekStart() {
        Calendar cal = Calendar.getInstance();
        int dayWeek = cal.get(7);
        if (dayWeek == 1) {
            cal.add(5, -1);
        }
        cal.set(7, 2);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getWeekEnd() {
        Calendar cal = Calendar.getInstance();
        int dayWeek = cal.get(7);
        if (dayWeek == 1) {
            cal.add(5, -1);
        }
        cal.set(7, 7);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        cal.add(7, 1);
        return cal.getTime();
    }

    public static Date getMinMaxDate(Date date, boolean isMin) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateFormat.format(date) + (isMin ? " 00:00:00" : " 23:59:59"));
        }
        catch (ParseException parseException) {
            return date;
        }
    }
}

