/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.utils;

import java.util.Set;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ECNLocalCacheUtils {
    public static LocalMemoryCache currentLocal = null;
    public static final String PDM_ECN_REGION = "PDM_ECN_LC";
    public static final String PDM_ECOBOM = "pdm_ecobom";
    public static final String CACHETYE_PGCACHE = "pgcache";
    public static final String CACHETYE_LCCACHE = "lccache";
    private static final Log logger = LogFactory.getLog(ECNLocalCacheUtils.class);

    public static String getAcctId() {
        String acctId = CacheKeyUtil.getAcctId();
        if (acctId == null || acctId.length() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u79df\u6237\u4e3a\u7a7a\u3002", (String)"ECNLocalCacheUtils_3", (String)"bd-mpdm-common", (Object[])new Object[0]));
        }
        return acctId;
    }

    public static void initLocalCtrlCache() {
        if (currentLocal == null) {
            CacheConfigInfo info = new CacheConfigInfo();
            info.setTimeout(3600);
            info.setMaxMemSize(10000);
            currentLocal = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(ECNLocalCacheUtils.getAcctId(), PDM_ECN_REGION, info);
        }
    }

    public static Object getLocalCtrlCache(String keyString) {
        ECNLocalCacheUtils.initLocalCtrlCache();
        return currentLocal.get(keyString);
    }

    public static void setLocalCtrlCache(String keyString, Object cacheObject) {
        ECNLocalCacheUtils.initLocalCtrlCache();
        currentLocal.put(keyString, cacheObject);
    }

    public static void clearLocalCtrlCache(Set<String> keyStringSet) {
        if (keyStringSet == null || keyStringSet.isEmpty()) {
            return;
        }
        ECNLocalCacheUtils.initLocalCtrlCache();
        for (String keyString : keyStringSet) {
            currentLocal.remove(new String[]{keyString});
        }
    }

    public static String serializeToBase64(DynamicObject ecoBom, String cacheType) {
        String keyString = "";
        if (CACHETYE_LCCACHE.equalsIgnoreCase(cacheType)) {
            Long ecoBomId = ecoBom.getLong("id");
            if (ecoBomId == null || ecoBomId.equals(0L)) {
                String msg = String.format(ResManager.loadKDString((String)"\u7f13\u5b58\u53d6\u6570\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u67e5\u770b\u3002", (String)"ECNLocalCacheUtils_2", (String)"bd-mpdm-common", (Object[])new Object[0]), ecoBomId);
                throw new KDBizException(new ErrorCode("mpdm-ecn-localcache", msg), new Object[0]);
            }
            keyString = ecoBomId.toString();
            ECNLocalCacheUtils.setLocalCtrlCache(keyString, ecoBom);
        } else {
            keyString = SerializationUtils.serializeToBase64((Object)ecoBom);
        }
        return keyString;
    }

    public static DynamicObject deSerializeFromBase64(String ecoBomId, String cacheType) {
        if (CACHETYE_LCCACHE.equalsIgnoreCase(cacheType)) {
            Object cacheObject = ECNLocalCacheUtils.getLocalCtrlCache(ecoBomId);
            if (cacheObject == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4BOM\u6570\u636e\u7f13\u5b58\u5df2\u5931\u6548\uff0c\u8bf7\u9000\u51fa\u91cd\u8bd5\u3002ecoBomId:\u201c%1$s\u201d\u3002", (String)"ECNLocalCacheUtils_1", (String)"bd-mpdm-common", (Object[])new Object[0]), ecoBomId);
                logger.warn(msg);
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement errorST : stackTrace) {
                    if (errorST == null) continue;
                    sb.append(errorST).append("\r\n");
                }
                logger.warn(sb.toString());
                return null;
            }
            return (DynamicObject)cacheObject;
        }
        return (DynamicObject)SerializationUtils.deSerializeFromBase64((String)ecoBomId);
    }
}

