/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.utils;

import java.util.ArrayList;
import kd.bos.unifiedthreadpool.api.ThreadExecutorService;
import kd.bos.unifiedthreadpool.api.ThreadPoolFactory;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategy;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategyFactory;
import kd.bos.unifiedthreadpool.tasktype.Priority;
import kd.bos.unifiedthreadpool.tasktype.TaskType;
import kd.bos.unifiedthreadpool.tasktype.ThreadLimitedModel;
import org.apache.commons.collections4.CollectionUtils;

public class MMCCommonThreadPoolUtil {
    public static final String REGION = "mmc";
    public static final String THREADPOOLNAME = "mmc-threadpool";
    private static volatile ThreadExecutorService pool;

    private MMCCommonThreadPoolUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadExecutorService getThreadExecutorService() {
        if (pool != null) return pool;
        Class<MMCCommonThreadPoolUtil> clazz = MMCCommonThreadPoolUtil.class;
        synchronized (MMCCommonThreadPoolUtil.class) {
            if (pool != null) return pool;
            ThreadPoolStrategy strategy = ThreadPoolStrategyFactory.create();
            strategy.setMinThreadNum(4).setMaxThreadNum(8).setOverflowThreadNum(2).setThreadIdeMinutes(1L);
            ArrayList<TaskType> taskTypes = new ArrayList<TaskType>(TaskTypeEnum.values().length);
            for (TaskTypeEnum taskType : TaskTypeEnum.values()) {
                taskTypes.add(new TaskType(taskType.taskTypeName, taskType.priority, taskType.limitedModel, (Object)taskType.threadLimitedValuel, taskType.taskQueueMaxSize));
            }
            if (CollectionUtils.isNotEmpty(taskTypes)) {
                taskTypes.forEach(arg_0 -> ((ThreadPoolStrategy)strategy).register(arg_0));
            }
            pool = ThreadPoolFactory.create((String)REGION, (String)THREADPOOLNAME, (ThreadPoolStrategy)strategy);
            // ** MonitorExit[var0] (shouldn't be in output)
            return pool;
        }
    }

    public static enum TaskTypeEnum {
        PMC_TASK("pmc-task", Priority.ONE, ThreadLimitedModel.NUMBER, 2, 1000);

        private String taskTypeName;
        private Priority priority;
        private ThreadLimitedModel limitedModel;
        private int threadLimitedValuel;
        int taskQueueMaxSize;

        private TaskTypeEnum(String taskTypeName, Priority priority, ThreadLimitedModel limitedModel, int threadLimitedValuel, int taskQueueMaxSize) {
            this.taskTypeName = taskTypeName;
            this.priority = priority;
            this.limitedModel = limitedModel;
            this.threadLimitedValuel = threadLimitedValuel;
            this.taskQueueMaxSize = taskQueueMaxSize;
        }

        public String getTaskTypeName() {
            return this.taskTypeName;
        }

        public void setTaskTypeName(String taskTypeName) {
            this.taskTypeName = taskTypeName;
        }

        public Priority getPriority() {
            return this.priority;
        }

        public void setPriority(Priority priority) {
            this.priority = priority;
        }

        public ThreadLimitedModel getLimitedModel() {
            return this.limitedModel;
        }

        public void setLimitedModel(ThreadLimitedModel limitedModel) {
            this.limitedModel = limitedModel;
        }

        public int getThreadLimitedValuel() {
            return this.threadLimitedValuel;
        }

        public void setThreadLimitedValuel(int threadLimitedValuel) {
            this.threadLimitedValuel = threadLimitedValuel;
        }

        public int getTaskQueueMaxSize() {
            return this.taskQueueMaxSize;
        }

        public void setTaskQueueMaxSize(int taskQueueMaxSize) {
            this.taskQueueMaxSize = taskQueueMaxSize;
        }
    }
}

