/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class MaterialStandardUtils {
    private static Log logger = LogFactory.getLog(MaterialStandardUtils.class);
    private static final String EntityID_Org_structure = "bos_org_structure";
    private static final String EntityID_Org_org = "bos_org";
    private static final String PROP_LONGNUMBER = "longnumber";
    public static final String ID = "id";
    public static final String NUMBER = "number";
    public static final String NAME = "name";
    public static final String ENABLE = "enable";
    public static final String CREATEORG = "createorg";

    public static Set<Long> getGroupStandard(String entityNumber, Set<Long> createOrgs, boolean isAddEnable) {
        HashSet<Long> standardSetIds = new HashSet<Long>();
        try {
            DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityNumber);
            if (ctrlview == null) {
                return standardSetIds;
            }
            ORM ormOv = ORM.create();
            QFilter f1 = new QFilter("view.id", "=", (Object)Long.valueOf(ctrlview.getPkValue().toString()));
            QFilter f2 = new QFilter("org", "in", createOrgs);
            HashSet<String> orglongnumberSets = new HashSet<String>();
            try (DataSet ds = ormOv.queryDataSet(MaterialStandardUtils.class.getName(), EntityID_Org_structure, PROP_LONGNUMBER, new QFilter[]{f1, f2});){
                for (Row row : ds) {
                    if (row.getString(PROP_LONGNUMBER) == null) continue;
                    orglongnumberSets.add(row.getString(PROP_LONGNUMBER));
                }
            }
            HashSet<String> orgnumberSets = new HashSet<String>();
            ArrayList orglongnumberList = new ArrayList(orglongnumberSets);
            String orgLongNumber = "";
            if (orglongnumberList.size() > 1) {
                for (int i = 1; i < orglongnumberList.size(); ++i) {
                    orgLongNumber = i == 1 ? MaterialStandardUtils.getInterSeciton((String)orglongnumberList.get(i - 1), (String)orglongnumberList.get(i)) : MaterialStandardUtils.getInterSeciton(orgLongNumber, (String)orglongnumberList.get(i));
                }
            } else if (orglongnumberList.size() == 1) {
                orgLongNumber = (String)orglongnumberList.get(0);
            } else {
                return standardSetIds;
            }
            String[] orgnumbers = orgLongNumber.split("!");
            orgnumberSets.addAll(new HashSet<String>(Arrays.asList(orgnumbers)));
            QFilter f = new QFilter(NUMBER, "in", orgnumberSets);
            f2 = new QFilter(ENABLE, "=", (Object)"1");
            QFilter[] qFilters = new QFilter[]{f, f2};
            HashSet<Long> orgIdSets = new HashSet<Long>();
            try (DataSet ds = ormOv.queryDataSet(MaterialStandardUtils.class.getName(), EntityID_Org_org, ID, qFilters);){
                for (Row row : ds) {
                    if (row.getLong(ID) == null) continue;
                    orgIdSets.add(row.getLong(ID));
                }
            }
            f = new QFilter(CREATEORG, "in", orgIdSets);
            qFilters = isAddEnable ? new QFilter[]{f, f2} : new QFilter[]{f};
            ds = ormOv.queryDataSet(MaterialStandardUtils.class.getName(), entityNumber + "groupstandard", ID, qFilters, ID);
            var17_24 = null;
            try {
                for (Row row : ds) {
                    if (row.get(ID) == null) continue;
                    standardSetIds.add(Long.valueOf(row.get(ID).toString()));
                }
            }
            catch (Throwable throwable) {
                var17_24 = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (var17_24 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            var17_24.addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        return standardSetIds;
    }

    public static List<Long> queryGroupsByGroupId(String entity, Object standardId, Object id, Set<Long> useOrgs) {
        if (id == null) {
            return null;
        }
        ArrayList<Long> list = new ArrayList<Long>();
        Long dataId = Long.valueOf(id.toString());
        DynamicObject group = BusinessDataServiceHelper.loadSingleFromCache((String)(entity + "group"), (String)"longnumber,parent", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)dataId)});
        list.add(dataId);
        if (group == null) {
            return list;
        }
        String longNumberDlm = ".";
        MainEntityType dataEntityType = (MainEntityType)group.getDataEntityType();
        DynamicProperty property = dataEntityType.getProperty("parent");
        GroupProp grop = (GroupProp)property;
        if (grop instanceof ParentBasedataProp) {
            longNumberDlm = ((ParentBasedataProp)grop).getLongNumberDLM();
        }
        String longnumber = group.getString(PROP_LONGNUMBER);
        QFilter f1 = new QFilter(PROP_LONGNUMBER, "like", (Object)(longnumber + longNumberDlm + "%"));
        QFilter f2 = new QFilter("standard", "=", (Object)Long.valueOf(standardId.toString()));
        QFilter f3 = new QFilter(CREATEORG, "in", useOrgs);
        QFilter[] qFilters = new QFilter[]{f1, f2, f3};
        ORM ormOv = ORM.create();
        try (DataSet ds = ormOv.queryDataSet(MaterialStandardUtils.class.getName(), entity + "group", ID, qFilters);){
            for (Row row : ds) {
                if (row.getString(ID) == null) continue;
                list.add(row.getLong(ID));
            }
        }
        return list;
    }

    public static List<Long> queryGroupsByGroupId(String entity, Object standardId, Object id) {
        if (id == null) {
            return null;
        }
        ArrayList<Long> list = new ArrayList<Long>();
        DynamicObject group = BusinessDataServiceHelper.loadSingleFromCache((String)(entity + "group"), (String)"longnumber,parent", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)Long.valueOf(id.toString()))});
        list.add(Long.valueOf(id.toString()));
        if (group == null) {
            return list;
        }
        String longNumberDlm = ".";
        MainEntityType dataEntityType = (MainEntityType)group.getDataEntityType();
        DynamicProperty property = dataEntityType.getProperty("parent");
        GroupProp grop = (GroupProp)property;
        if (grop instanceof ParentBasedataProp) {
            longNumberDlm = ((ParentBasedataProp)grop).getLongNumberDLM();
        }
        String longnumber = group.getString(PROP_LONGNUMBER);
        QFilter f1 = new QFilter(PROP_LONGNUMBER, "like", (Object)(longnumber + longNumberDlm + "%"));
        QFilter f2 = new QFilter("standard", "=", (Object)Long.valueOf(standardId.toString()));
        QFilter[] qFilters = new QFilter[]{f1, f2};
        ORM ormOV = ORM.create();
        try (DataSet ds = ormOV.queryDataSet(MaterialStandardUtils.class.getName(), entity + "group", ID, qFilters);){
            for (Row row : ds) {
                if (row.getString(ID) == null) continue;
                list.add(row.getLong(ID));
            }
        }
        return list;
    }

    public static Set<Long> getGroupOrgId(String entity, Set<Long> useOrgs) {
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entity);
        HashSet<String> longnumberSet = new HashSet<String>();
        ORM ormOv = ORM.create();
        DataSet ds = ormOv.queryDataSet(MaterialStandardUtils.class.getName(), EntityID_Org_structure, PROP_LONGNUMBER, new QFilter[]{new QFilter("org", "in", useOrgs), new QFilter("view.id", "=", (Object)ctrlview.getLong(ID))});
        Object object = null;
        try {
            for (Row row : ds) {
                if (row.getString(PROP_LONGNUMBER) == null) continue;
                longnumberSet.add(row.getString(PROP_LONGNUMBER));
            }
        }
        catch (Throwable iter) {
            object = iter;
            throw iter;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable iter) {
                        ((Throwable)object).addSuppressed(iter);
                    }
                } else {
                    ds.close();
                }
            }
        }
        HashSet<String> numberSets = new HashSet<String>();
        for (String longnumber : longnumberSet) {
            String[] numbers = longnumber.split("!");
            numberSets.addAll(new HashSet<String>(Arrays.asList(numbers)));
        }
        HashSet<Long> ids = new HashSet<Long>();
        try (DataSet ds2 = ormOv.queryDataSet(MaterialStandardUtils.class.getName(), EntityID_Org_org, ID, new QFilter[]{new QFilter(NUMBER, "in", numberSets)});){
            for (Row row : ds2) {
                if (row.getLong(ID) == null) continue;
                ids.add(row.getLong(ID));
            }
        }
        return ids;
    }

    public static DynamicObjectCollection getMaterialOrg(String entityType, String appNumber) {
        QFilter extendOrgQFilter;
        String orgFuncPro;
        long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appNumber, (String)entityType, (String)"47150e89000000ac");
        if (result == null) {
            return new DynamicObjectCollection();
        }
        String useOrgFunc = BaseDataServiceHelper.getUseOrgFunc((String)entityType);
        QFilter[] filters = null;
        QFilter idsFilter = new QFilter("org", "in", (Object)result.getHasPermOrgs());
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (!StringUtils.isEmpty((CharSequence)useOrgFunc) && StringUtils.isNotEmpty((CharSequence)(orgFuncPro = OrgServiceHelper.getOrgBizPro((String)useOrgFunc)))) {
            QFilter orgFuncFilter = new QFilter(orgFuncPro, "=", (Object)Boolean.TRUE);
            filterList.add(orgFuncFilter);
        }
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityType);
        ArrayList<Long> viewOrgIds = new ArrayList<Long>();
        String view = "";
        view = null == ctrlview ? "16" : ctrlview.getString(ID);
        QFilter f2 = new QFilter("view.id", "=", (Object)Long.valueOf(view));
        QFilter f3 = new QFilter("isctrlunit", "=", (Object)Boolean.TRUE);
        QFilter[] qfilters = null;
        qfilters = result.hasAllOrgPerm() ? new QFilter[]{f2, f3} : new QFilter[]{f2, f3, idsFilter};
        DynamicObject[] viewOrgs = BusinessDataServiceHelper.load((String)EntityID_Org_structure, (String)"org", (QFilter[])qfilters);
        if (null == viewOrgs) {
            return new DynamicObjectCollection();
        }
        for (DynamicObject viewOrg : viewOrgs) {
            if (viewOrg.getDynamicObject("org") == null) continue;
            viewOrgIds.add((Long)viewOrg.getDynamicObject("org").getPkValue());
        }
        idsFilter = new QFilter(ID, "in", viewOrgIds);
        filterList.add(idsFilter);
        IBaseDataCtrlPlugin baseDataCtrlPlugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)entityType);
        if (baseDataCtrlPlugin != null && (extendOrgQFilter = baseDataCtrlPlugin.getExtendOrgQFilter()) != null) {
            filterList.add(extendOrgQFilter);
        }
        filters = filterList.toArray(new QFilter[0]);
        DynamicObjectCollection col = QueryServiceHelper.query((String)EntityID_Org_org, (String)"id,name", (QFilter[])filters);
        return col;
    }

    public static String getInterSeciton(String max, String min) {
        String result = "";
        if (max.length() < min.length()) {
            String s = max;
            max = min;
            min = s;
        }
        String subStr = min;
        int begin = 0;
        int end = min.length();
        int i = 1;
        while (!max.contains(subStr)) {
            if (end == min.length()) {
                begin = 0;
                end = min.length() - i++;
            } else {
                ++begin;
                ++end;
            }
            subStr = min.substring(begin, end);
        }
        result = subStr;
        return result;
    }
}

