/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.utils;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.enums.ManuBillPickStatusEnum;
import kd.bd.mpdm.common.mftorder.enums.ManuBillProductTypeEnum;
import kd.bd.mpdm.common.mftorder.enums.QtyTypeEnum;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class MftOrderCalMaterialUtils {
    private static final Log logger = LogFactory.getLog(MftOrderCalMaterialUtils.class);
    public static final String KEY_PICKSTATUS = "pickstatus";
    public static final String KEY_PICKINGPAIRS = "pickingpairs";
    public static final String KEY_TEXT_ORDER = "orderno";
    public static final String KEY_TEXT_ORDERID = "orderid";
    public static final String KEY_PRMT_ORDERENTRYID = "orderentryid";
    public static final String KEY_QTY = "qty";
    public static final String KEY_ENTITYID_STOCK = "pom_mftstock";
    public static final String KEY_TRANSACTIONTYPE = "transactiontype";
    public static final String KEY_PRODUCTTYPE = "producttype";

    public static void calMaterial(String billno, Object entrypk, boolean isFromManuBill, String entityid) {
        QFilter[] filters = new QFilter[]{new QFilter("billno", "=", (Object)billno), new QFilter("billstatus", "=", (Object)"C")};
        DynamicObject manuBill = BusinessDataServiceHelper.loadSingle((String)entityid, (String)MftOrderCalMaterialUtils.selectMftOrderColumn(), (QFilter[])filters);
        DynamicObjectCollection col = manuBill.getDynamicObjectCollection("treeentryentity");
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject entry = (DynamicObject)col.get(i);
            Object pkValue = entry.getPkValue();
            String producttype = entry.getString(KEY_PRODUCTTYPE);
            if (!entrypk.toString().equals(pkValue.toString()) || !ManuBillProductTypeEnum.MAIN.getValue().equals(producttype) || !isFromManuBill && !MftOrderCalMaterialUtils.isAutoCal(manuBill)) continue;
            DynamicObject baseunit = entry.getDynamicObject("baseunit");
            DynamicObject unit = entry.getDynamicObject("unit");
            BigDecimal qty = entry.getBigDecimal(KEY_QTY);
            BigDecimal pickQty = MftOrderCalMaterialUtils.calPickQtyByEntry(manuBill, entry, unit);
            boolean isExistsMaterialReq = MftOrderCalMaterialUtils.getExistsMaterialReq(entry.getPkValue());
            if (pickQty.compareTo(BigDecimal.ZERO) == 0 && !isExistsMaterialReq) {
                entry.set(KEY_PICKINGPAIRS, (Object)pickQty);
                entry.set(KEY_PICKSTATUS, (Object)ManuBillPickStatusEnum.NOBEGINWORK.getValue());
                continue;
            }
            if (pickQty.compareTo(BigDecimal.ZERO) == 0 && isExistsMaterialReq) {
                entry.set(KEY_PICKINGPAIRS, (Object)pickQty);
                entry.set(KEY_PICKSTATUS, (Object)ManuBillPickStatusEnum.BEGINWORK.getValue());
                continue;
            }
            if (pickQty.compareTo(BigDecimal.ZERO) > 0 && pickQty.compareTo(qty) < 0) {
                entry.set(KEY_PICKINGPAIRS, (Object)pickQty);
                entry.set(KEY_PICKSTATUS, (Object)ManuBillPickStatusEnum.BEGINWORK.getValue());
                continue;
            }
            if (pickQty.compareTo(qty) == 0) {
                entry.set(KEY_PICKINGPAIRS, (Object)pickQty);
                entry.set(KEY_PICKSTATUS, (Object)ManuBillPickStatusEnum.ENDWORK.getValue());
                continue;
            }
            if (pickQty.compareTo(qty) <= 0) continue;
            entry.set(KEY_PICKINGPAIRS, (Object)pickQty);
            entry.set(KEY_PICKSTATUS, (Object)ManuBillPickStatusEnum.SOMEENDWORK.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{manuBill});
    }

    public static void calMaterial(Set<Long> orderEntryidList, boolean isFromManuBill, String entityid, Map<String, String> entityMap) {
        HashSet orderEntryid = new HashSet(orderEntryidList.size());
        QFilter[] filters = new QFilter[]{new QFilter("treeentryentity.id", "in", orderEntryidList), new QFilter("billstatus", "=", (Object)"C")};
        DynamicObject[] loadList = BusinessDataServiceHelper.load((String)entityid, (String)MftOrderCalMaterialUtils.selectMftOrderColumn(), (QFilter[])filters);
        HashSet<String> mftIds = new HashSet<String>(loadList.length);
        HashMap<String, DynamicObject> srcMap = new HashMap<String, DynamicObject>(loadList.length);
        HashSet transactiontypeList = Sets.newHashSet();
        Set<Object> basunitList = Sets.newHashSet();
        Map<Object, Object> measureunitData = Maps.newHashMap();
        HashMap<String, DynamicObject> transactiontypeMap = Maps.newHashMap();
        String tableName = "t_pom_mftorderentry";
        if (StringUtils.equals((CharSequence)"om_mftorder", (CharSequence)entityid)) {
            tableName = "t_om_mftorderentry";
        }
        for (DynamicObject object : loadList) {
            mftIds.add(object.getString("id"));
            DynamicObject transactiontype = object.getDynamicObject(KEY_TRANSACTIONTYPE);
            tableName = object.getDynamicObjectCollection("treeentryentity").getDynamicObjectType().getAlias();
            srcMap.put(object.getString("billno"), object);
            if (transactiontype == null) continue;
            Long transactiontypeId = (Long)transactiontype.getPkValue();
            transactiontypeList.add(transactiontypeId);
        }
        if (!mftIds.isEmpty() && mftIds.size() > 0) {
            basunitList = MftOrderCalMaterialUtils.getMaterialUnitData(mftIds, tableName);
            measureunitData = MftOrderCalMaterialUtils.getMeasureunitData(basunitList);
            if (!transactiontypeList.isEmpty() && transactiontypeList.size() > 0) {
                QFilter[] filters1 = new QFilter[]{new QFilter("id", "in", (Object)transactiontypeList)};
                DynamicObjectCollection query = QueryServiceHelper.query((String)"mpdm_transactproduct", (String)"id,isvolcal,controlscope", (QFilter[])filters1);
                transactiontypeMap = new HashMap<String, DynamicObject>(16);
                for (DynamicObject trans : query) {
                    transactiontypeMap.put(trans.getString("id"), trans);
                }
            }
        }
        try {
            orderEntryidList.forEach(slong -> orderEntryid.add(slong.toString()));
            if ("om_mftorder".equals(entityid)) {
                DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"IMftOrderCalMaterialUtils", (String)"calMaterial", (Object[])new Object[]{measureunitData, transactiontypeMap, mftIds, orderEntryid, srcMap, isFromManuBill, entityid, entityMap});
            } else {
                DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"IMftOrderCalMaterialUtils", (String)"calMaterial", (Object[])new Object[]{measureunitData, transactiontypeMap, mftIds, orderEntryid, srcMap, isFromManuBill, entityid});
            }
        }
        catch (Exception ex) {
            throw new KDException((Throwable)ex, new ErrorCode("MftOrderCalMaterialUtils", ex.getMessage() != null ? ex.getMessage() : ex.toString()), new Object[0]);
        }
    }

    public static boolean isAutoCal(DynamicObject manuBill) {
        DynamicObject transactiontype = manuBill.getDynamicObject(KEY_TRANSACTIONTYPE);
        transactiontype = BusinessDataServiceHelper.loadSingleFromCache((Object)transactiontype.getPkValue(), (String)"mpdm_transactproduct");
        boolean isvolcal = transactiontype.getBoolean("isvolcal");
        return isvolcal;
    }

    public static BigDecimal calPickQtyByEntry(DynamicObject manuBill, DynamicObject entry, DynamicObject baseunit) {
        BigDecimal pickQty = BigDecimal.ZERO;
        Boolean pickflag = false;
        String controlscope = MftOrderCalMaterialUtils.getControlScope(manuBill);
        DynamicObject stock = MPDMMftGenStocksUtils.getOrderStock(manuBill.getPkValue().toString(), entry.getPkValue().toString(), KEY_ENTITYID_STOCK);
        if (null == stock) {
            return BigDecimal.ZERO;
        }
        DynamicObjectCollection stockentrys = stock.getDynamicObjectCollection("stockentry");
        BigDecimal qty = entry.getBigDecimal(KEY_QTY);
        for (int i = 0; i < stockentrys.size(); ++i) {
            BigDecimal standQty;
            DynamicObject stockentry = (DynamicObject)stockentrys.get(i);
            BigDecimal actissueqty = stockentry.getBigDecimal("actissueqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : stockentry.getBigDecimal("actissueqty");
            BigDecimal feedingqty = stockentry.getBigDecimal("feedingqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : stockentry.getBigDecimal("feedingqty");
            BigDecimal rejectedqty = stockentry.getBigDecimal("rejectedqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : stockentry.getBigDecimal("rejectedqty");
            BigDecimal scrapqty = stockentry.getBigDecimal("scrapqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : stockentry.getBigDecimal("scrapqty");
            BigDecimal demandqty = stockentry.getBigDecimal("demandqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : stockentry.getBigDecimal("demandqty");
            BigDecimal fixscrap = stockentry.getBigDecimal("fixscrap").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : stockentry.getBigDecimal("fixscrap");
            String qtytype = stockentry.getString("qtytype");
            String isbackflush = stockentry.getString("isbackflush");
            boolean iskeypart = stockentry.getBoolean("iskeypart");
            String issuemode = stockentry.getString("issuemode");
            BigDecimal bigDecimal = standQty = stockentry.getBigDecimal("standqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : stockentry.getBigDecimal("standqty");
            if ("C".equals(issuemode) || "A".equals(controlscope) && "B".equals(isbackflush) || "B".equals(controlscope) && !iskeypart || demandqty.compareTo(BigDecimal.ZERO) == 0 || standQty.compareTo(BigDecimal.ZERO) == 0) continue;
            if (QtyTypeEnum.REGULAR.getValue().equals(qtytype)) {
                BigDecimal helpqty = actissueqty.add(feedingqty).subtract(rejectedqty).subtract(scrapqty);
                BigDecimal newpickqty = BigDecimal.ZERO;
                if (helpqty.compareTo(demandqty) >= 0) {
                    newpickqty = qty;
                }
                if (newpickqty.compareTo(pickQty) < 0) {
                    pickQty = newpickqty;
                    pickflag = true;
                    continue;
                }
                if (pickflag.booleanValue() || pickQty.compareTo(BigDecimal.ZERO) != 0) continue;
                pickQty = newpickqty;
                pickflag = true;
                continue;
            }
            DynamicObject measureunit = BusinessDataServiceHelper.loadSingleFromCache((Object)baseunit.getPkValue(), (String)"bd_measureunits");
            int precision = measureunit.getInt("precision");
            String precisionaccount = measureunit.getString("precisionaccount");
            int deal = 4;
            switch (precisionaccount) {
                case "2": {
                    deal = 1;
                    break;
                }
                case "3": {
                    deal = 0;
                    break;
                }
                default: {
                    deal = 4;
                }
            }
            BigDecimal helpqty = actissueqty.add(feedingqty).subtract(rejectedqty).subtract(scrapqty);
            BigDecimal newpickqty = helpqty.multiply(qty).divide(demandqty.subtract(fixscrap), precision, deal);
            if (newpickqty.compareTo(pickQty) < 0) {
                pickQty = newpickqty;
                pickflag = true;
                continue;
            }
            if (pickflag.booleanValue() || pickQty.compareTo(BigDecimal.ZERO) != 0) continue;
            pickQty = newpickqty;
            pickflag = true;
        }
        return pickQty;
    }

    public static String getControlScope(DynamicObject manuBill) {
        DynamicObject transactiontype = manuBill.getDynamicObject(KEY_TRANSACTIONTYPE);
        transactiontype = BusinessDataServiceHelper.loadSingleFromCache((Object)transactiontype.getPkValue(), (String)"mpdm_transactproduct");
        String controlscope = transactiontype.getString("controlscope");
        return controlscope;
    }

    public static Set<String> getMaterialUnitData(Set<String> orderList, String tableName) {
        HashSet<String> unitList = new HashSet<String>();
        StringBuilder msb = new StringBuilder();
        int index = 0;
        for (String materialId : orderList) {
            if (++index == orderList.size()) {
                msb.append(materialId);
                continue;
            }
            msb.append(materialId);
            msb.append(",");
        }
        String queryMainSql = "select fid,funit,fbaseunit from " + tableName + " where fid in (" + msb + ") ";
        try (DataSet queryMainData = DB.queryDataSet((String)"queryunitData", (DBRoute)new DBRoute("scm"), (String)queryMainSql);){
            for (Row row : queryMainData) {
                String fid = row.getString("fid");
                String baseunit = row.getString("fbaseunit");
                String unit = row.getString("funit");
                unitList.add(unit);
            }
        }
        return unitList;
    }

    public static Map<String, String> getMeasureunitData(Set<String> unitList) {
        HashMap<String, String> map = new HashMap<String, String>();
        int index = 0;
        StringBuilder msb = new StringBuilder();
        for (String unitId : unitList) {
            if (++index == unitList.size()) {
                msb.append(unitId);
                continue;
            }
            msb.append(unitId);
            msb.append(",");
        }
        String queryMainSql = "select fid,fprecision,fprecisiontype from T_bd_Measureunit where  fid in (" + msb + ") ";
        try (DataSet queryMainData = DB.queryDataSet((String)"queryMeasureunitData", (DBRoute)DBRoute.base, (String)queryMainSql);){
            for (Row row : queryMainData) {
                String fid = row.getString("fid");
                String precision = row.getString("fprecision");
                String precisiontype = row.getString("fprecisiontype");
                map.put(fid, precision + "@@" + precisiontype);
            }
        }
        return map;
    }

    public static String selectMftOrderColumn() {
        return "id,billno,transactiontype,treeentryentity.producttype,treeentryentity.qty,treeentryentity.baseqty,treeentryentity.unit,treeentryentity.baseunit,treeentryentity.pickstatus,treeentryentity.pickingpairs";
    }

    private static boolean getExistsMaterialReq(Object pkid) {
        boolean isExistsMaterialReq = Boolean.FALSE;
        try {
            logger.info("\u5f00\u59cb\u8c03\u7528im\u662f\u5426\u5b58\u5728\u751f\u4ea7\u5de5\u5355\u4e0b\u6e38\u5355\u636e\u670d\u52a1 " + pkid);
            isExistsMaterialReq = (Boolean)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"MdcCheckMftorderService", (String)"isExistsMaterialReq", (Object[])new Object[]{pkid});
            logger.info("\u8c03\u7528im\u662f\u5426\u5b58\u5728\u751f\u4ea7\u5de5\u5355\u4e0b\u6e38\u5355\u636e\u670d\u52a1\u7ed3\u675f " + isExistsMaterialReq);
        }
        catch (Exception ex) {
            logger.error("\u8c03\u7528\u670d\u52a1\u51fa\u73b0\u5f02\u5e38" + ex.getMessage());
        }
        return isExistsMaterialReq;
    }
}

