/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.commonfield.DropdownItem;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.AdvConBarItemAp;

public class QueryNameByEntityUtils {
    private static final Log logger = LogFactory.getLog(QueryNameByEntityUtils.class);

    private QueryNameByEntityUtils() {
    }

    public static String queryName(String field, String entityNum) {
        Map allFieldMap = EntityMetadataCache.getDataEntityType((String)entityNum).getAllFields();
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)allFieldMap.get(field);
        if (iDataEntityProperty != null) {
            String strname = iDataEntityProperty.getName();
            LocaleString name = iDataEntityProperty.getDisplayName();
            if (!name.isEmpty()) {
                strname = name.toString();
            }
            return strname;
        }
        return null;
    }

    public static String queryNameAndEntry(String field, String entityNum) {
        Map allFieldMap = EntityMetadataCache.getDataEntityType((String)entityNum).getAllFields();
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)allFieldMap.get(field);
        if (iDataEntityProperty != null) {
            String parentName;
            String strname = iDataEntityProperty.getName();
            LocaleString name = iDataEntityProperty.getDisplayName();
            if (!name.isEmpty()) {
                strname = name.toString();
            }
            if (StringUtils.isNotBlank((CharSequence)(parentName = QueryNameByEntityUtils.getParentName(iDataEntityProperty, entityNum)))) {
                strname = parentName + "." + strname;
            }
            return strname;
        }
        return null;
    }

    public static Map<String, String> queryNameMap(Set<String> fieldSet, String entityNum) {
        HashMap<String, String> fieldMap = new HashMap<String, String>(16);
        Map allFieldMap = EntityMetadataCache.getDataEntityType((String)entityNum).getAllFields();
        for (String field : fieldSet) {
            String parentName;
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)allFieldMap.get(field);
            if (iDataEntityProperty == null) continue;
            String strname = iDataEntityProperty.getName();
            LocaleString name = iDataEntityProperty.getDisplayName();
            if (!name.isEmpty()) {
                strname = name.toString();
            }
            if (StringUtils.isNotBlank((CharSequence)(parentName = QueryNameByEntityUtils.getParentName(iDataEntityProperty, entityNum)))) {
                strname = parentName + "." + strname;
            }
            fieldMap.put(field, strname);
        }
        return fieldMap;
    }

    public static String getParentName(IDataEntityProperty iDataEntityProperty, String entityNum) {
        IDataEntityType dataEntityType = iDataEntityProperty.getParent();
        String pstrName = dataEntityType.getName();
        if (pstrName == null || pstrName.equals(entityNum)) {
            return null;
        }
        LocaleString name2 = dataEntityType.getDisplayName();
        if (!name2.isEmpty()) {
            pstrName = name2.toString();
        }
        return pstrName;
    }

    public static String getButtonName(String buttonKey, String entityNum) {
        String buttonName = "";
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNum, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        if (null != formMeta) {
            List items = formMeta.getItems();
            for (ControlAp controlAp : items) {
                LocaleString name;
                String key = controlAp.getKey();
                if (controlAp instanceof AdvConBarItemAp) {
                    List dropdownItems = ((AdvConBarItemAp)controlAp).getDropdownItems();
                    for (DropdownItem dropdownItem : dropdownItems) {
                        LocaleString name2;
                        String key1 = dropdownItem.getKey();
                        if (!StringUtils.equals((CharSequence)key1, (CharSequence)buttonKey) || null == (name2 = dropdownItem.getTitle())) continue;
                        buttonName = name2.getLocaleValue();
                    }
                }
                if (!StringUtils.equals((CharSequence)key, (CharSequence)buttonKey) || null == (name = controlAp.getName())) continue;
                buttonName = name.getLocaleValue();
            }
        }
        return buttonName;
    }

    public static String getEntryName(String entryEntity, String entityNum) {
        String entityName = null;
        Map entryMap = EntityMetadataCache.getDataEntityType((String)entityNum).getAllEntities();
        for (Map.Entry fentry : entryMap.entrySet()) {
            EntityType value;
            LocaleString displayName;
            String key = (String)fentry.getKey();
            if (!entryEntity.equals(key) || (displayName = (value = (EntityType)fentry.getValue()).getDisplayName()).isEmpty()) continue;
            entityName = displayName.toString();
        }
        return entityName;
    }
}

