/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.utils;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class RepairPlanCardUtils {
    private static final Log logger = LogFactory.getLog(RepairPlanCardUtils.class);

    private RepairPlanCardUtils() {
    }

    public static void dealMetaOtherInfo(BeginOperationTransactionArgs e) {
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject userObj = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
        DynamicObject[] dos = e.getDataEntities();
        String key = e.getOperationKey();
        Date now = new Date();
        block14: for (int i = 0; i < dos.length; ++i) {
            DynamicObject obj = dos[i];
            switch (key) {
                case "save": {
                    obj.set("enabler", (Object)userObj);
                    obj.set("enabletime", (Object)now);
                    continue block14;
                }
                case "audit": {
                    obj.set("auditor", (Object)userObj);
                    obj.set("audittime", (Object)now);
                    continue block14;
                }
                case "unaudit": {
                    obj.set("auditor", null);
                    obj.set("audittime", null);
                    continue block14;
                }
                case "enable": {
                    obj.set("disabler", null);
                    obj.set("disabletime", null);
                    obj.set("enabler", (Object)userObj);
                    obj.set("enabletime", (Object)now);
                    continue block14;
                }
                case "disable": {
                    obj.set("disabler", (Object)userObj);
                    obj.set("disabletime", (Object)now);
                    obj.set("enabler", null);
                    obj.set("enabletime", null);
                    continue block14;
                }
            }
        }
    }

    public static boolean checkUnique(long dataPK, long repairplancardPK, String enable, String entityName) {
        QFilter[] qFilters;
        QFilter cardNoQfiter = new QFilter("repairplancard", "=", (Object)repairplancardPK);
        QFilter enableQfiter = new QFilter("enable", "in", (Object)enable);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        if (dataPK > 0L) {
            QFilter pkQFilter = new QFilter("id", "not in", (Object)dataPK);
            qFilters = new QFilter[]{pkQFilter, cardNoQfiter, enableQfiter, statusFilter};
        } else {
            qFilters = new QFilter[]{cardNoQfiter, enableQfiter, statusFilter};
        }
        boolean isExists = QueryServiceHelper.exists((String)entityName, (QFilter[])qFilters);
        return isExists;
    }
}

