/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class ResourceCheckHelper {
    public static Map<Long, String> checkResult(Set<Long> bizIdSet, String entityNumber) {
        DynamicObject resourceCheck = ResourceCheckHelper.getResourceCheckObj(entityNumber);
        HashMap<Long, String> resultMap = new HashMap<Long, String>(bizIdSet.size());
        if (resourceCheck != null) {
            String idtag = resourceCheck.getString("idsetfieldtag");
            QFilter qfilter = new QFilter("bizbillid", "in", bizIdSet);
            qfilter.and(new QFilter("bizentity", "=", (Object)entityNumber));
            qfilter.and(new QFilter("bizidtag", "=", (Object)(StringUtils.isEmpty((String)idtag) ? "id" : idtag)));
            qfilter.and(new QFilter("srcresourcecheck", "=", (Object)resourceCheck.getLong("id")));
            DynamicObjectCollection bizResults = QueryServiceHelper.query((String)"msplan_bizbillcheckresult", (String)ResourceCheckHelper.getBizResultProperties(), (QFilter[])new QFilter[]{qfilter});
            for (DynamicObject bizResult : bizResults) {
                resultMap.put(bizResult.getLong("bizbillid"), bizResult.getString("checkremark"));
            }
        }
        return resultMap;
    }

    private static String getBizResultProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",").append("bizbillid");
        sb.append(",").append("checkremark");
        return sb.toString();
    }

    private static DynamicObject getResourceCheckObj(String entityNumber) {
        QFilter qfilter = new QFilter("mainentity", "=", (Object)entityNumber);
        qfilter.and(new QFilter("status", "=", (Object)"C"));
        qfilter.and(new QFilter("enable", "=", (Object)"1"));
        qfilter.and(new QFilter("isdefault", "=", (Object)"1"));
        return QueryServiceHelper.queryOne((String)"msplan_resourcecheck", (String)ResourceCheckHelper.getSelectProperties(), (QFilter[])qfilter.toArray());
    }

    private static String getSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",").append("opnumber");
        sb.append(",").append("opname");
        sb.append(",").append("idsetfieldtag");
        sb.append(",").append("bizresultfieldname");
        sb.append(",").append("bizresultfieldnumber");
        return sb.toString();
    }
}

