/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.utils;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class WareHouseLocationQFilter {
    public static final String WAREHOUSE_STATUS = "status";
    private static final String WAREHOUSE_ENABLE = "enable";
    private static final String WAREHOUSE_SET_STARTSTATUS = "startstatus";
    private static final String WAREHOUSE_SET_INITSTATUS = "initstatus";
    private static final String WAREHOUSE_FORM = "bd_warehouse";
    private static final String WAREHOUSE_SET_FORM = "im_warehousesetup";
    private static final String WAREHOUSE_SET_WAREHOUSE = "warehouse";
    private static final String WAREHOUSE_ID = "id";
    public static final String WAREHOUSE_ENTRYENTITY = "entryentity";
    public static final String WAREHOUSE_ENTRYENTITY_LOCATION = "location";
    public static final String WAREHOUSE_ENTRYENTITY_LOCATION_ID = "id";

    public static Set<Long> getWareHouseFilter(DynamicObject org) {
        HashSet<Long> enableSet = new HashSet<Long>(100);
        HashSet<Long> disableSet = new HashSet<Long>(100);
        if (org == null) {
            return enableSet;
        }
        QFilter wareHouseStatus = new QFilter(WAREHOUSE_STATUS, "!=", (Object)"C");
        QFilter wareHouseEnable = new QFilter(WAREHOUSE_ENABLE, "=", (Object)"0");
        QFilter wareHouseFilter = wareHouseStatus.or(wareHouseEnable);
        QFilter enable = new QFilter(WAREHOUSE_ENABLE, "=", (Object)"1");
        QFilter startStatus = new QFilter(WAREHOUSE_SET_STARTSTATUS, "=", (Object)"B");
        QFilter initStatus = new QFilter(WAREHOUSE_SET_INITSTATUS, "=", (Object)"B");
        Map wareHouse = BusinessDataServiceHelper.loadFromCache((String)WAREHOUSE_FORM, (QFilter[])new QFilter[]{wareHouseFilter});
        Set set = wareHouse.entrySet();
        for (Map.Entry entry : set) {
            long id = Long.parseLong(entry.getKey().toString());
            disableSet.add(id);
        }
        QFilter createOrg = new QFilter("org", "=", (Object)org.getLong("id"));
        Map wareHouseSet = BusinessDataServiceHelper.loadFromCache((String)WAREHOUSE_SET_FORM, (QFilter[])new QFilter[]{enable, startStatus, initStatus, createOrg});
        Set setSet = wareHouseSet.entrySet();
        for (Map.Entry entry : setSet) {
            DynamicObject wareHouseSetObj = (DynamicObject)entry.getValue();
            DynamicObject wareHouseObj = wareHouseSetObj.getDynamicObject(WAREHOUSE_SET_WAREHOUSE);
            if (wareHouseObj == null) continue;
            long id = wareHouseObj.getLong("id");
            enableSet.add(id);
        }
        enableSet.removeAll(disableSet);
        return enableSet;
    }

    public static Set<Long> getLocationFilter(DynamicObject outWareHouseObj) {
        HashSet<Long> locationIds = new HashSet<Long>(100);
        if (outWareHouseObj == null) {
            return locationIds;
        }
        DynamicObjectCollection col = outWareHouseObj.getDynamicObjectCollection(WAREHOUSE_ENTRYENTITY);
        for (DynamicObject obj : col) {
            DynamicObject location = obj.getDynamicObject(WAREHOUSE_ENTRYENTITY_LOCATION);
            long id = location.getLong("id");
            locationIds.add(id);
        }
        return locationIds;
    }
}

