/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.utils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.BillTypeControlInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BillTypeDifferentialHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class WorkcardDataInfoUtils {
    private static final Log logger = LogFactory.getLog(WorkcardDataInfoUtils.class);
    private static final ThreadLocal<Map<String, Map<String, String>>> mustInputFieldThreadLocal = new ThreadLocal();

    private WorkcardDataInfoUtils() {
    }

    public static Set<String> getHiddlenField(long worktypectrlId, String entityNumber) {
        HashSet<String> hiddlenSet = new HashSet<String>(16);
        QFilter filter = new QFilter("id", "=", (Object)worktypectrlId);
        filter.and(new QFilter("entryentity.basedata", "=", (Object)entityNumber));
        filter.and(new QFilter("entryentity.subentryentity.ishide", "=", (Object)Boolean.TRUE));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryWorktypectrlishide", (String)"mpdm_worktypectrl", (String)"id,entryentity.subentryentity.fieldname,entryentity.subentryentity.field", (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String fieldname = row.getString("entryentity.subentryentity.field");
                hiddlenSet.add(fieldname);
            }
        }
        logger.info("hiddlenSet---" + ((Object)hiddlenSet).toString());
        return hiddlenSet;
    }

    public static Map<String, String> getMustInputField(long worktypectrlId, String entityNumber) {
        String keyString;
        Map<String, String> mustInputMap;
        Map<String, Map<String, String>> map = mustInputFieldThreadLocal.get();
        if (map == null) {
            map = new HashMap<String, Map<String, String>>();
            mustInputFieldThreadLocal.set(map);
        }
        if ((mustInputMap = map.get(keyString = String.valueOf(worktypectrlId) + "_" + entityNumber)) != null) {
            return mustInputMap;
        }
        mustInputMap = new HashMap<String, String>(16);
        QFilter filter = new QFilter("id", "=", (Object)worktypectrlId);
        filter.and(new QFilter("entryentity.basedata", "=", (Object)entityNumber));
        filter.and(new QFilter("entryentity.subentryentity.mustinput", "=", (Object)Boolean.TRUE));
        Map<String, String> mustInputKeys = WorkcardDataInfoUtils.getMustInputKeys(entityNumber);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryWorktypectrlmustinput", (String)"mpdm_worktypectrl", (String)"id,entryentity.subentryentity.fieldname,entryentity.subentryentity.field", (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String field = row.getString("entryentity.subentryentity.field");
                String fieldname = row.getString("entryentity.subentryentity.fieldname");
                mustInputMap.put(field, fieldname);
            }
        }
        for (Map.Entry<String, String> mustKey : mustInputKeys.entrySet()) {
            String key = mustKey.getKey();
            if (mustInputMap.containsKey(key)) continue;
            mustInputMap.put(key, mustKey.getValue());
        }
        map.put(keyString, mustInputMap);
        return mustInputMap;
    }

    public static Map<Long, Map<String, String>> getMustInputSetField(Set<Long> worktypectrlIdSet, String entityNumber) {
        HashMap mustInputMap = new HashMap(16);
        QFilter filter = new QFilter("id", "in", worktypectrlIdSet);
        filter.and(new QFilter("entryentity.basedata", "=", (Object)entityNumber));
        filter.and(new QFilter("entryentity.subentryentity.mustinput", "=", (Object)Boolean.TRUE));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryWorktypectrlmustinput", (String)"mpdm_worktypectrl", (String)"id,entryentity.subentryentity.fieldname,entryentity.subentryentity.field", (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long ctrlid = row.getLong("id");
                String field = row.getString("entryentity.subentryentity.field");
                String fieldname = row.getString("entryentity.subentryentity.fieldname");
                if (mustInputMap.containsKey(ctrlid)) {
                    Map map = (Map)mustInputMap.get(ctrlid);
                    map.put(field, fieldname);
                    continue;
                }
                HashMap<String, String> tempMap = new HashMap<String, String>(16);
                tempMap.put(field, fieldname);
                mustInputMap.put(ctrlid, tempMap);
            }
        }
        logger.info("mustInputMap---" + ((Object)mustInputMap).toString());
        Map<String, String> mustInputKeys = WorkcardDataInfoUtils.getMustInputKeys(entityNumber);
        HashMap<Long, Map<String, String>> resultMustInputMap = new HashMap<Long, Map<String, String>>(mustInputMap.size());
        for (Map.Entry mmap : mustInputMap.entrySet()) {
            Map mvalue = (Map)mmap.getValue();
            for (Map.Entry<String, String> mustKey : mustInputKeys.entrySet()) {
                String key = mustKey.getKey();
                if (mvalue.containsKey(key)) continue;
                mvalue.put(key, mustKey.getValue());
            }
            resultMustInputMap.put((Long)mmap.getKey(), mvalue);
        }
        return resultMustInputMap;
    }

    public static Map<String, Map<String, Set<String>>> getWorktypectrlField(Set<Long> worktypectrlIdSet, String entityNumber) {
        HashMap<String, Map<String, Set<String>>> resultMap = new HashMap<String, Map<String, Set<String>>>(16);
        QFilter filter = new QFilter("id", "in", worktypectrlIdSet);
        filter.and(new QFilter("entryentity.basedata", "=", (Object)entityNumber));
        Map<String, String> mustInputKeys = WorkcardDataInfoUtils.getMustInputKeys(entityNumber);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getWorktypectrlField", (String)"mpdm_worktypectrl", (String)"id,entryentity.subentryentity.fieldname,entryentity.subentryentity.field,entryentity.subentryentity.mustinput,entryentity.subentryentity.ishide", (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String field = row.getString("entryentity.subentryentity.field");
                if (StringUtils.isBlank((CharSequence)field)) continue;
                Boolean ismust = Boolean.FALSE;
                if (mustInputKeys.containsKey(field)) {
                    ismust = Boolean.TRUE;
                }
                String id = row.getString("id");
                boolean mustinput = row.getBoolean("entryentity.subentryentity.mustinput");
                boolean ishide = row.getBoolean("entryentity.subentryentity.ishide");
                if (resultMap.containsKey(id)) {
                    Map fset = (Map)resultMap.get(id);
                    if (mustinput || ismust.booleanValue()) {
                        WorkcardDataInfoUtils.addSetData(fset, field, "1");
                    } else {
                        WorkcardDataInfoUtils.addSetData(fset, field, "2");
                    }
                    if (ishide) {
                        WorkcardDataInfoUtils.addSetData(fset, field, "3");
                        continue;
                    }
                    WorkcardDataInfoUtils.addSetData(fset, field, "4");
                    continue;
                }
                HashMap<String, Set<String>> tempMap = new HashMap<String, Set<String>>(16);
                if (mustinput || ismust.booleanValue()) {
                    WorkcardDataInfoUtils.addSetData(tempMap, field, "1");
                } else {
                    WorkcardDataInfoUtils.addSetData(tempMap, field, "2");
                }
                if (ishide) {
                    WorkcardDataInfoUtils.addSetData(tempMap, field, "3");
                } else {
                    WorkcardDataInfoUtils.addSetData(tempMap, field, "4");
                }
                resultMap.put(id, tempMap);
            }
        }
        return resultMap;
    }

    private static void addSetData(Map<String, Set<String>> fset, String field, String key) {
        if (fset.containsKey(key)) {
            Set<String> set = fset.get(key);
            set.add(field);
        } else {
            HashSet<String> sset = new HashSet<String>(16);
            sset.add(field);
            fset.put(key, sset);
        }
    }

    public static void showDataWithCardType(IDataModel model, IFormView view, Object worktypectrlId, String entityNumber) {
        DynamicObject typectrl = BusinessDataServiceHelper.loadSingleFromCache((Object)worktypectrlId, (String)"mpdm_worktypectrl");
        if (typectrl != null) {
            HashSet<Long> worktypectrlIdSet = new HashSet<Long>(16);
            Long typeId = (Long)typectrl.getPkValue();
            worktypectrlIdSet.add(typeId);
            Map<String, Map<String, Set<String>>> fieldMap = WorkcardDataInfoUtils.getWorktypectrlField(worktypectrlIdSet, entityNumber);
            if (fieldMap != null && !fieldMap.isEmpty()) {
                Map<String, Set<String>> typeMap = fieldMap.get(typeId.toString());
                for (Map.Entry<String, Set<String>> map : typeMap.entrySet()) {
                    String key = map.getKey();
                    Set<String> value = map.getValue();
                    if (value == null || value.isEmpty()) continue;
                    WorkcardDataInfoUtils.setWorkCardFiledView(view, key, value);
                }
            }
        }
    }

    public static void setWorkCardFiledView(IFormView view, String type, Set<String> fieldSet) {
        for (String field : fieldSet) {
            FieldEdit cellEdit;
            Control control;
            String[] split = field.split("\\.");
            switch (split.length) {
                case 1: {
                    field = split[0];
                    break;
                }
                case 2: {
                    field = split[1];
                    break;
                }
                case 3: {
                    field = split[2];
                    break;
                }
            }
            if ((control = view.getControl(field)) instanceof EntryGrid || (cellEdit = (FieldEdit)control) == null) continue;
            switch (type) {
                case "1": {
                    cellEdit.setMustInput(true);
                    break;
                }
                case "2": {
                    cellEdit.setMustInput(false);
                    break;
                }
                case "3": {
                    cellEdit.setVisible("", false);
                    break;
                }
                case "4": {
                    cellEdit.setVisible("", true);
                    break;
                }
            }
        }
    }

    public static void setPreparePropertyFieldKeys(PreparePropertysEventArgs e, String entityNum) {
        Map fieldMap = BillTypeDifferentialHelper.getFullControlInfos((String)entityNum);
        Map allFieldMap = EntityMetadataCache.getDataEntityType((String)entityNum).getAllFields();
        Set allFieldSet = allFieldMap.entrySet();
        for (Map.Entry entry : allFieldSet) {
            String fieldNum = (String)entry.getKey();
            BillTypeControlInfo info = (BillTypeControlInfo)fieldMap.get(fieldNum);
            if (info == null) continue;
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)entry.getValue();
            IDataEntityType dataEntityType = dataEntityProperty.getParent();
            String pFieldNum = dataEntityType.getName();
            if (pFieldNum == null || pFieldNum.equals(entityNum)) {
                e.getFieldKeys().add(fieldNum);
                continue;
            }
            fieldNum = WorkcardDataInfoUtils.getPreStr(dataEntityType, entityNum, fieldNum);
            e.getFieldKeys().add(fieldNum);
        }
    }

    public static Map<String, String> getMustInputKeys(String entityNum) {
        HashMap<String, String> mustInputSet = new HashMap<String, String>(16);
        Map fieldMap = BillTypeDifferentialHelper.getFullControlInfos((String)entityNum);
        Map allFieldMap = EntityMetadataCache.getDataEntityType((String)entityNum).getAllFields();
        Set allFieldSet = allFieldMap.entrySet();
        for (Map.Entry entry : allFieldSet) {
            String fieldNum = (String)entry.getKey();
            BillTypeControlInfo info = (BillTypeControlInfo)fieldMap.get(fieldNum);
            if (info == null) continue;
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)entry.getValue();
            IDataEntityType dataEntityType = dataEntityProperty.getParent();
            String pFieldNum = dataEntityType.getName();
            if (pFieldNum != null && !pFieldNum.equals(entityNum)) {
                fieldNum = WorkcardDataInfoUtils.getPreStr(dataEntityType, entityNum, fieldNum);
            }
            if (!info.isMustInput()) continue;
            String fieldName = info.getFieldName();
            mustInputSet.put(fieldNum, fieldName);
        }
        return mustInputSet;
    }

    public static String getPreStr(IDataEntityType dataEntityType, String formNum, String retFieldNum) {
        String pFieldNum = dataEntityType.getName();
        if (pFieldNum == null || pFieldNum.equals(formNum)) {
            return retFieldNum;
        }
        String newFielNum = pFieldNum + "." + retFieldNum;
        IDataEntityType pDataEntityType = dataEntityType.getParent();
        return WorkcardDataInfoUtils.getPreStr(pDataEntityType, formNum, newFielNum);
    }

    public static void getPageHour(Map<Long, BigDecimal> pagehourmap, Long vid, BigDecimal standardhours) {
        if (pagehourmap.containsKey(vid)) {
            BigDecimal sumstandardhours = pagehourmap.get(vid);
            sumstandardhours = sumstandardhours.add(standardhours);
            pagehourmap.put(vid, sumstandardhours);
        } else {
            pagehourmap.put(vid, standardhours);
        }
    }

    public static String getEntryProcessseq(DynamicObjectCollection entryentity, Long vid) {
        String processseq = "1";
        for (DynamicObject erow : entryentity) {
            Long pageversionid = erow.getLong("pageversionid");
            if (!pageversionid.equals(vid)) continue;
            processseq = erow.getString("processseq");
            break;
        }
        return processseq;
    }
}

