/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.wordcard.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class WorkCardUtils {
    public static Set<Object> getWorkCardTypeFromEntity(String entityName) {
        if (StringUtils.isEmpty((String)entityName)) {
            return Collections.emptySet();
        }
        QFilter filter = new QFilter("entryentity.basedata", "=", (Object)entityName);
        String selectProperties = "id";
        Map workTypeCtrlMap = BusinessDataServiceHelper.loadFromCache((String)"mpdm_worktypectrl", (String)selectProperties, (QFilter[])new QFilter[]{filter});
        if (workTypeCtrlMap != null) {
            HashSet<Object> workTypeCtrlIdSet = new HashSet<Object>(16);
            for (Map.Entry workTypeCtrls : workTypeCtrlMap.entrySet()) {
                workTypeCtrlIdSet.add(((DynamicObject)workTypeCtrls.getValue()).getPkValue());
            }
            filter = new QFilter("worktypectrl.id", "in", workTypeCtrlIdSet);
            Map jobCardTypeMap = BusinessDataServiceHelper.loadFromCache((String)"mpdm_jobcardtype", (String)selectProperties, (QFilter[])new QFilter[]{filter});
            if (jobCardTypeMap != null) {
                HashSet<Object> jobCardTypeIdSet = new HashSet<Object>(16);
                for (Map.Entry jobCardTypes : jobCardTypeMap.entrySet()) {
                    jobCardTypeIdSet.add(((DynamicObject)jobCardTypes.getValue()).getPkValue());
                }
                return jobCardTypeIdSet;
            }
        }
        return Collections.emptySet();
    }

    public static String getUniqueKey(DynamicObject dataEntity, String processtype) {
        DynamicObject customer = dataEntity.getDynamicObject("customer");
        String cardversion = dataEntity.getString("cardversion");
        DynamicObject cardtype = dataEntity.getDynamicObject("cardtype");
        DynamicObject material = dataEntity.getDynamicObject("material");
        DynamicObject materialtype = dataEntity.getDynamicObject("materialtype");
        DynamicObject zone = dataEntity.getDynamicObject("zone");
        String cardhourtype = dataEntity.getString("cardhourtype");
        String cardnum = dataEntity.getString("cardnum");
        String cardnumid = dataEntity.getString("cardnumid");
        DynamicObject createOrg = dataEntity.getDynamicObject("createorg");
        long cardtypePK = cardtype == null ? 0L : cardtype.getLong("id");
        long customerPK = customer == null ? 0L : customer.getLong("id");
        long materialPK = material == null ? 0L : material.getLong("id");
        long materialtypePK = materialtype == null ? 0L : materialtype.getLong("id");
        long zonePK = zone == null ? 0L : zone.getLong("id");
        long createOrgPK = createOrg == null ? 0L : createOrg.getLong("id");
        StringBuilder uniquekey = new StringBuilder();
        uniquekey.append(cardtypePK);
        uniquekey.append("@@");
        uniquekey.append(customerPK);
        uniquekey.append("@@");
        uniquekey.append(cardversion);
        uniquekey.append("@@");
        uniquekey.append(cardnum);
        uniquekey.append("@@");
        uniquekey.append(materialPK);
        uniquekey.append("@@");
        uniquekey.append(materialtypePK);
        uniquekey.append("@@");
        uniquekey.append(cardnumid);
        if ("C".equals(processtype)) {
            uniquekey.append("@@");
            uniquekey.append(zonePK);
            uniquekey.append("@@");
            uniquekey.append(cardhourtype);
        }
        return uniquekey.toString();
    }
}

