/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.bom;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.bombasedata.ReplacePlanConsts;
import kd.bd.mpdm.common.bombasedata.ReplaceUpdateBomUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.bos.util.StringUtils;

public class ReplacePlanBusiness {
    private static final Log logger = LogFactory.getLog(ReplacePlanBusiness.class);
    private static final BigDecimal ONE00 = new BigDecimal("100");
    private static final BigDecimal ONE99 = new BigDecimal("99");
    public static final DBRoute scmDBRoute = new DBRoute("scm");
    public static final String UPDATELOGERROR_SQL = " update t_mpdm_replaceplanlog set frunstatus = 'D',fcalculatepro = 100 where fid = ?";
    public static final String UPDATELOGENTRYERROR_SQL = " update t_mpdm_repplanlogentry set fentryexecstatus = 'D',fdetiallog = 'save log error' where fid = ?";

    public Map<String, Set<Long>> getEffectBomEntryIdSet(Long bizOrg, Long replacePlanId, boolean isAdd) {
        return this.getEffectBomEntryIdSetByFilter(bizOrg, null, replacePlanId, isAdd);
    }

    public Map<String, Set<Long>> getEffectBomEntryIdSet(Long bizOrg, Set<Long> bomIdSet, Long replacePlanId, boolean isAdd) {
        QFilter qFilter = null;
        if (bomIdSet != null && !bomIdSet.isEmpty()) {
            qFilter = new QFilter("id", "in", bomIdSet);
        }
        return this.getEffectBomEntryIdSetByFilter(bizOrg, qFilter, replacePlanId, isAdd);
    }

    public Map<String, Set<Long>> getEffectBomEntryIdSetByFilter(Long bizOrg, QFilter queryFilter, Long replacePlanId, boolean isAdd) {
        DynamicObject bomRepConfig;
        QFilter extFilter;
        DynamicObject replacePlan = this.getReplacePlan(replacePlanId);
        DynamicObjectCollection coll = this.getReplacePlanMMEntry(replacePlan);
        Set<Long> materialIdSet = this.getReplacePlanMaterialIdSet(coll);
        if (materialIdSet.isEmpty()) {
            logger.info("mmc-ReplacePlanBusiness-getEffectBomEntryIdSet:materialIdSet is null return");
            return Collections.emptyMap();
        }
        QFilter qFilter = null;
        qFilter = isAdd ? this.getAddDataQFilter(bizOrg, materialIdSet, replacePlan) : this.getEditDataQFilter(bizOrg, materialIdSet, replacePlan);
        if (queryFilter != null) {
            qFilter.and(queryFilter);
        }
        if ((extFilter = this.getBomExtFilter(bomRepConfig = this.getBomRepConfig())) != null) {
            qFilter.and(extFilter);
        }
        logger.info("mmc-ReplacePlanBusiness-getEffectBomEntryIdSet:qFilter=" + qFilter.toString());
        JSONArray bomDatas = this.getBomData(qFilter);
        if (bomDatas.isEmpty()) {
            logger.info("mmc-ReplacePlanBusiness-getEffectBomEntryIdSet:bomDatas.isEmpty() return ");
            return Collections.emptyMap();
        }
        if (isAdd) {
            return this.genMatchBomEntryDataList(bomDatas, coll, true, this.getReplacePlanRMEntry(replacePlan));
        }
        return this.getBomEntryIdFromJsonArray(bomDatas);
    }

    private QFilter getAddDataQFilter(Long bizOrg, Set<Long> materialIdSet, DynamicObject replacePlan) {
        QFilter qFilter = new QFilter("entry.entrymaterialid", "in", materialIdSet);
        qFilter.and(new QFilter("createorg", "=", (Object)bizOrg));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("entry.entryinvaliddate", ">", (Object)new Date()));
        qFilter.and(new QFilter("entry.entryreplaceplan", "=", (Object)0L));
        qFilter.and(new QFilter("entry.entryisjumplevel", "=", (Object)false));
        qFilter.and(new QFilter("entry.entryqtynumerator", ">", (Object)BigDecimal.ZERO));
        qFilter.and(new QFilter("entry.entryqtydenominator", ">", (Object)BigDecimal.ZERO));
        return qFilter;
    }

    private QFilter getEditDataQFilter(Long bizOrg, Set<Long> materialIdSet, DynamicObject replacePlan) {
        QFilter qFilter = new QFilter("entry.entryreplaceplan", "=", replacePlan.getPkValue());
        qFilter.and(new QFilter("createorg", "=", (Object)bizOrg));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("entry.entryinvaliddate", ">", (Object)new Date()));
        qFilter.and(new QFilter("entry.entryqtynumerator", ">", (Object)BigDecimal.ZERO));
        qFilter.and(new QFilter("entry.entryqtydenominator", ">", (Object)BigDecimal.ZERO));
        return qFilter;
    }

    private Map<String, Set<Long>> getBomEntryIdFromJsonArray(JSONArray bomDatas) {
        if (bomDatas == null || bomDatas.isEmpty()) {
            return Collections.emptyMap();
        }
        int size = bomDatas.size();
        HashMap<String, Set<Long>> matchBomEntryDataMap = new HashMap<String, Set<Long>>(16);
        HashMap<Long, String> cacheReplaceGroupMap = new HashMap<Long, String>(16);
        for (int i = 0; i < size; ++i) {
            JSONObject bomData = bomDatas.getJSONObject(i);
            Long bomentryId = bomData.getLong("entryid");
            String replaceGroupNo = this.getExistsBomReplaceGroupno(bomData, cacheReplaceGroupMap);
            HashSet<Long> bomEntryIdSet = (HashSet<Long>)matchBomEntryDataMap.get(replaceGroupNo);
            if (bomEntryIdSet == null) {
                bomEntryIdSet = new HashSet<Long>(16);
            }
            bomEntryIdSet.add(bomentryId);
            matchBomEntryDataMap.put(replaceGroupNo, bomEntryIdSet);
        }
        return matchBomEntryDataMap;
    }

    private String getExistsBomReplaceGroupno(JSONObject bomData, Map<Long, String> cacheReplaceGroupMap) {
        String replaceGroupNo = bomData.getString("entryreplacegroup");
        Long bomId = bomData.getLong("id");
        if (StringUtils.isEmpty((String)replaceGroupNo)) {
            replaceGroupNo = this.genReplaceGroupNo(bomData);
        }
        cacheReplaceGroupMap.put(bomId, replaceGroupNo);
        bomData.put("entryreplacegroup", (Object)replaceGroupNo);
        return replaceGroupNo;
    }

    private Set<Long> getBomEntryIdFromList(List<JSONObject> bomDataList) {
        if (bomDataList == null || bomDataList.isEmpty()) {
            return Collections.emptySet();
        }
        int size = bomDataList.size();
        HashSet<Long> bomEntryIdSet = new HashSet<Long>(size);
        for (int i = 0; i < size; ++i) {
            JSONObject bomData = bomDataList.get(i);
            bomEntryIdSet.add(bomData.getLong("entryid"));
        }
        return bomEntryIdSet;
    }

    private DynamicObjectCollection getReplacePlanMMEntry(DynamicObject replacePlan) {
        return replacePlan.getDynamicObjectCollection("mainmaterentry");
    }

    private DynamicObjectCollection getReplacePlanRMEntry(DynamicObject replacePlan) {
        return replacePlan.getDynamicObjectCollection("repmaterentry");
    }

    private Set<Long> getReplacePlanMaterialIdSet(DynamicObjectCollection coll) {
        HashSet<Long> materialIdSet = new HashSet<Long>(16);
        if (coll == null || coll.isEmpty()) {
            return materialIdSet;
        }
        boolean hasReplace = false;
        for (DynamicObject entry : coll) {
            DynamicObject materialMft = entry.getDynamicObject("material");
            if (materialMft == null || materialMft.getDynamicObject("masterid") == null) continue;
            materialIdSet.add((Long)materialMft.getDynamicObject("masterid").getPkValue());
            if (!entry.getBoolean("isreplace")) continue;
            hasReplace = true;
        }
        if (!hasReplace) {
            String errorStr = ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u66ff\u4ee3\u65b9\u6848\u4e2d\uff0c\u4e3b\u7269\u6599\u5206\u5f55\u672a\u52fe\u9009\u201c\u66ff\u4ee3\u4e3b\u6599\u201d\u3002", (String)"ReplacePlanBusiness_02", (String)"bd-mpdm-business", (Object[])new Object[0]);
            throw new KDBizException(errorStr);
        }
        return materialIdSet;
    }

    private Map<String, DynamicObject> getReplacePlanMainMaterialKeys(DynamicObjectCollection coll, DynamicObject bomRepConfig) {
        HashMap<String, DynamicObject> mmKeyMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject entry : coll) {
            DynamicObject materialMft = entry.getDynamicObject("material");
            if (materialMft == null || materialMft.getDynamicObject("masterid") == null) continue;
            mmKeyMap.put(this.genReplacePlanKeys(entry, bomRepConfig), entry);
        }
        return mmKeyMap;
    }

    private String genReplacePlanKeys(DynamicObject entry, DynamicObject bomRepConfig) {
        StringBuilder sb = new StringBuilder();
        DynamicObject materialMft = entry.getDynamicObject("material");
        sb.append(materialMft.getDynamicObject("masterid").getPkValue());
        sb.append("_");
        if (bomRepConfig.getBoolean("entryver")) {
            DynamicObject bomVersion = entry.getDynamicObject("bomversion");
            sb.append(bomVersion == null ? "0" : bomVersion.getPkValue());
        } else {
            sb.append("0");
        }
        sb.append("_");
        if (bomRepConfig.getBoolean("auxproperties")) {
            DynamicObject auxpty = entry.getDynamicObject("auxpty");
            sb.append(auxpty == null ? "0" : auxpty.getPkValue());
        } else {
            sb.append("0");
        }
        return sb.toString();
    }

    private DynamicObject getFirstReplacePlanMM(DynamicObjectCollection coll) {
        DynamicObject firstEntry = null;
        for (DynamicObject entry : coll) {
            DynamicObject materialMft = entry.getDynamicObject("material");
            if (materialMft == null || materialMft.getDynamicObject("masterid") == null) continue;
            if (entry.getBoolean("isreplace")) {
                return entry;
            }
            firstEntry = entry;
        }
        return firstEntry;
    }

    private Map<String, Set<Long>> genMatchBomEntryDataList(JSONArray bomDatas, DynamicObjectCollection coll, boolean isMul, DynamicObjectCollection rmColl) {
        DynamicObject bomRepConfig = this.getBomRepConfig();
        int size = bomDatas.size();
        Map<String, DynamicObject> replacePlanMMEntryMap = this.getReplacePlanMainMaterialKeys(coll, bomRepConfig);
        DynamicObject firstReplacePlanMMEntry = this.getFirstReplacePlanMM(coll);
        String firstReplacePlanMMKeys = this.genReplacePlanKeys(firstReplacePlanMMEntry, bomRepConfig);
        List<JSONObject> firstBomDataList = this.getFirstBomDataList(bomDatas, bomRepConfig, firstReplacePlanMMKeys);
        if (firstBomDataList == null || firstBomDataList.isEmpty()) {
            logger.info("mmc-ReplacePlanBusiness-genMatchBomEntryDataList:firstBomDataList is null,return null");
            return Collections.emptyMap();
        }
        logger.info("mmc-ReplacePlanBusiness-genMatchBomEntryDataList:firstBomDataList.size=" + firstBomDataList.size());
        Set<Long> bomIdSet = this.getAllBomIdSet(bomDatas);
        Set<Long> optBomIdSet = this.getOptBomIdSet(bomIdSet);
        if (replacePlanMMEntryMap != null && replacePlanMMEntryMap.size() > 1 && !optBomIdSet.isEmpty()) {
            bomIdSet.removeAll(optBomIdSet);
        }
        HashSet<Long> executeBomEntryIdSet = new HashSet<Long>(64);
        HashMap<String, ArrayList<JSONObject>> ppBomMap = new HashMap<String, ArrayList<JSONObject>>(64);
        for (JSONObject firstBomData : firstBomDataList) {
            Long firstBomId = firstBomData.getLong("id");
            BigDecimal firstRate = this.getFirstRate(firstBomData, firstReplacePlanMMEntry);
            String replaceGroupNo = this.genReplaceGroupNo(firstBomData);
            logger.info("mmc-ReplacePlanBusiness-genMatchBomEntryDataList:loop firstBomDataList,firstBomId=" + firstBomId + ",replaceGroupNo=" + replaceGroupNo + ",firstRate=" + firstRate + "," + this.getBomTag(firstBomData));
            if (!bomIdSet.contains(firstBomId)) {
                logger.info("mmc-ReplacePlanBusiness-genMatchBomEntryDataList:loop firstBomDataList,is opt bom continue");
                continue;
            }
            if (rmColl.size() > 1 && !optBomIdSet.isEmpty() && optBomIdSet.contains(firstBomId)) {
                logger.info("mmc-ReplacePlanBusiness-genMatchBomEntryDataList:loop firstBomDataList,is opt bom,rm.size > 1, continue");
                continue;
            }
            for (int i = 0; i < size; ++i) {
                Long bomEntryId;
                JSONObject bomData = bomDatas.getJSONObject(i);
                Long bomId = bomData.getLong("id");
                if (!bomId.equals(firstBomId) || executeBomEntryIdSet.contains(bomEntryId = bomData.getLong("entryid"))) continue;
                ArrayList<JSONObject> groupList = (ArrayList<JSONObject>)ppBomMap.get(replaceGroupNo);
                if (groupList == null) {
                    groupList = new ArrayList<JSONObject>(16);
                }
                Map<String, Object> matchMap = this.checkIsMatch(bomData, bomRepConfig, firstReplacePlanMMEntry, replacePlanMMEntryMap, firstRate, groupList);
                boolean isFullPP = (Boolean)matchMap.get("result");
                String matchResult = (String)matchMap.get("msg");
                if (isFullPP) {
                    executeBomEntryIdSet.add(bomEntryId);
                    groupList.add(bomData);
                    bomData.put("entryreplacegroup", (Object)replaceGroupNo);
                    ppBomMap.put(replaceGroupNo, groupList);
                    continue;
                }
                logger.info("mmc-ReplacePlanBusiness-isFullPP = false,matchResult=" + matchResult + "," + this.getBomTag(bomData));
            }
        }
        if (ppBomMap.isEmpty()) {
            logger.info("mmc-ReplacePlanBusiness-ppBomMap is null,return null");
            return Collections.emptyMap();
        }
        if (!isMul && executeBomEntryIdSet.size() != size) {
            logger.info("mmc-ReplacePlanBusiness-executeBomEntryIdSet.size <> bomentryIdSet.size,return null");
            return Collections.emptyMap();
        }
        HashMap<String, Set<Long>> matchBomEntryDataMap = new HashMap<String, Set<Long>>(16);
        Set<String> replacePlanMMKeys = replacePlanMMEntryMap.keySet();
        for (Map.Entry entrys : ppBomMap.entrySet()) {
            List groupList = (List)entrys.getValue();
            Set<String> groupMMKeys = this.getGroupListKeySet(groupList, bomRepConfig);
            if (!this.isFullMatch(groupMMKeys, replacePlanMMKeys)) continue;
            matchBomEntryDataMap.put((String)entrys.getKey(), this.getBomEntryIdFromList(groupList));
        }
        return matchBomEntryDataMap;
    }

    private boolean isFullMatch(Set<String> setA, Set<String> setB) {
        HashSet<String> resSet = new HashSet<String>(16);
        resSet.addAll(setA);
        resSet.retainAll(setB);
        return resSet.size() == setB.size();
    }

    private String genReplaceGroupNo(JSONObject bomData) {
        int seq = bomData.getInteger("seq");
        return ORM.create().genLongId("mpdm_replaceplan") + "_" + seq;
    }

    private String genKeysByBomEntry(JSONObject bomData, DynamicObject bomRepConfig) {
        Long materialId = bomData.getLong("entrymaterialid");
        Long bomVersionId = bomData.getLong("entryversion");
        Long bomAuxId = bomData.getLong("entryauxproperty");
        StringBuilder sb = new StringBuilder();
        sb.append(materialId);
        sb.append("_");
        if (bomRepConfig.getBoolean("entryver")) {
            sb.append(bomVersionId == null ? "0" : bomVersionId);
        } else {
            sb.append("0");
        }
        sb.append("_");
        if (bomRepConfig.getBoolean("auxproperties")) {
            sb.append(bomAuxId == null ? "0" : bomAuxId);
        } else {
            sb.append("0");
        }
        return sb.toString();
    }

    private List<JSONObject> getFirstBomDataList(JSONArray bomDatas, DynamicObject bomRepConfig, String firstReplacePlanMMKeys) {
        ArrayList<JSONObject> list = new ArrayList<JSONObject>(16);
        for (int i = 0; i < bomDatas.size(); ++i) {
            JSONObject bomData = bomDatas.getJSONObject(i);
            String bomMaterialKeys = this.genKeysByBomEntry(bomData, bomRepConfig);
            if (!firstReplacePlanMMKeys.equals(bomMaterialKeys)) continue;
            list.add(bomData);
        }
        return list;
    }

    private Set<Long> getAllBomIdSet(JSONArray bomDatas) {
        HashSet<Long> bomIdSet = new HashSet<Long>(16);
        for (int i = 0; i < bomDatas.size(); ++i) {
            JSONObject bomData = bomDatas.getJSONObject(i);
            bomIdSet.add(bomData.getLong("id"));
        }
        return bomIdSet;
    }

    private Map<String, Object> checkIsMatch(JSONObject bomData, DynamicObject bomRepConfig, DynamicObject firstReplacePlanMMEntry, Map<String, DynamicObject> replacePlanMMEntryMap, BigDecimal firstRate, List<JSONObject> groupList) {
        BigDecimal fz = bomData.getBigDecimal("entryqtynumerator");
        BigDecimal fm = bomData.getBigDecimal("entryqtydenominator");
        String bomMaterialKeys = this.genKeysByBomEntry(bomData, bomRepConfig);
        Set<String> existKeys = this.getGroupListKeySet(groupList, bomRepConfig);
        if (existKeys.contains(bomMaterialKeys)) {
            return this.genMatchResultMap(false, " existKeys is contains bomMaterialKeys ");
        }
        DynamicObject replacePlanMMEntry = replacePlanMMEntryMap.get(bomMaterialKeys);
        if (replacePlanMMEntry == null) {
            return this.genMatchResultMap(false, " replacePlanMMEntry is null ");
        }
        if (this.isFirst(firstReplacePlanMMEntry, replacePlanMMEntry)) {
            return this.genMatchResultMap(true, "is first MM,full match");
        }
        if (!bomRepConfig.getBoolean("numrate")) {
            return this.genMatchResultMap(true, "bomRepConfg numrate is false,full match");
        }
        BigDecimal currentReplacePlanFz = replacePlanMMEntry.getBigDecimal("mole");
        BigDecimal currentReplacePlanFm = replacePlanMMEntry.getBigDecimal("deno");
        BigDecimal tmpPercent = fz.multiply(currentReplacePlanFm).divide(fm.multiply(currentReplacePlanFz), 20, 4);
        if (tmpPercent.compareTo(firstRate) == 0) {
            return this.genMatchResultMap(true, "full match");
        }
        return this.genMatchResultMap(false, "tmpPercent <> firstRate ,tmpPercent=" + tmpPercent);
    }

    private Map<String, Object> genMatchResultMap(boolean result, String msg) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("result", result);
        resultMap.put("msg", msg);
        return resultMap;
    }

    private Set<String> getGroupListKeySet(List<JSONObject> groupList, DynamicObject bomRepConfig) {
        HashSet<String> keyMaterialSet = new HashSet<String>(16);
        for (JSONObject bomData : groupList) {
            keyMaterialSet.add(this.genKeysByBomEntry(bomData, bomRepConfig));
        }
        return keyMaterialSet;
    }

    private BigDecimal getFirstRate(JSONObject firstBomData, DynamicObject firstReplacePlanMMEntry) {
        BigDecimal firstFz = firstBomData.getBigDecimal("entryqtynumerator");
        BigDecimal firstFm = firstBomData.getBigDecimal("entryqtydenominator");
        BigDecimal firstReplacePlanFz = firstReplacePlanMMEntry.getBigDecimal("mole");
        BigDecimal firstReplacePlanFm = firstReplacePlanMMEntry.getBigDecimal("deno");
        return firstFz.multiply(firstReplacePlanFm).divide(firstFm.multiply(firstReplacePlanFz), 20, 4);
    }

    private boolean isFirst(DynamicObject firstReplacePlanMMEntry, DynamicObject replacePlanMMEntry) {
        return firstReplacePlanMMEntry.getPkValue().equals(replacePlanMMEntry.getPkValue());
    }

    private JSONArray getBomData(QFilter qfilter) {
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(logger.getClass().getName() + "_getBomData"), (String)"pdm_mftbom", (String)this.getBomSelectProperties(), (QFilter[])new QFilter[]{qfilter}, (String)"id,entry.seq");){
            JSONArray jSONArray = ReplacePlanBusiness.parseToJSONArray(ds);
            return jSONArray;
        }
    }

    public static JSONArray parseToJSONArray(DataSet dateSet) {
        JSONArray retArray = new JSONArray();
        try {
            if (dateSet == null) {
                JSONArray jSONArray = retArray;
                return jSONArray;
            }
            String[] fieldNames = dateSet.getRowMeta().getFieldNames();
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                JSONObject obj = new JSONObject();
                for (int i = 0; i < fieldNames.length; ++i) {
                    String key = fieldNames[i];
                    Object value = row.get(key);
                    obj.put(key, value);
                }
                if (obj.isEmpty()) continue;
                retArray.add((Object)obj);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (dateSet != null) {
                dateSet.close();
            }
        }
        return retArray;
    }

    private String getBomSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("").append("id").append(" as ").append("id");
        sb.append(",").append("number").append(" as ").append("number");
        sb.append(",entry.").append("id").append(" as ").append("entryid");
        sb.append(",entry.").append("seq").append(" as ").append("seq");
        sb.append(",entry.").append("entrymaterialid").append(" as ").append("entrymaterialid");
        sb.append(",entry.").append("entryversion").append(" as ").append("entryversion");
        sb.append(",entry.").append("entryqtynumerator").append(" as ").append("entryqtynumerator");
        sb.append(",entry.").append("entryqtydenominator").append(" as ").append("entryqtydenominator");
        sb.append(",entry.").append("entryvaliddate").append(" as ").append("entryvaliddate");
        sb.append(",entry.").append("entryinvaliddate").append(" as ").append("entryinvaliddate");
        sb.append(",entry.").append("entryauxproperty").append(" as ").append("entryauxproperty");
        sb.append(",entry.").append("entryisreplace").append(" as ").append("entryisreplace");
        sb.append(",entry.").append("entryreplaceplan").append(" as ").append("entryreplaceplan");
        sb.append(",entry.").append("entryreplacegroup").append(" as ").append("entryreplacegroup");
        sb.append(",entry.").append("entryisreplaceplanmm").append(" as ").append("entryisreplaceplanmm");
        sb.append(",entry.").append("reppriority").append(" as ").append("reppriority");
        return sb.toString();
    }

    private DynamicObject getReplacePlan(Long replacePlanId) {
        QFilter qfilter = new QFilter("id", "=", (Object)replacePlanId);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_replaceplan", (QFilter[])new QFilter[]{qfilter});
    }

    private DynamicObject getBomRepConfig() {
        String selectProperties = "createorg,entrymaterial,entryver,auxproperties,numrate,isreduction,iscalculate,filterrulevalue_tag";
        QFilter qfilter = new QFilter("id", "=", (Object)ReplacePlanConsts.BOMREPCONFIGID);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_bomrepconfig", (String)selectProperties, (QFilter[])new QFilter[]{qfilter});
    }

    private QFilter getBomExtFilter(DynamicObject bomRepConfig) {
        String filterrulevalue = bomRepConfig.getString("filterrulevalue_tag");
        if (null != filterrulevalue && !"".equals(filterrulevalue)) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"pdm_mftbom");
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterrulevalue, FilterCondition.class);
            FilterBuilder fb = new FilterBuilder(entityType, filterCondition);
            UserService userService = new UserService();
            fb.setUserService((IUserService)userService);
            fb.buildFilter(false);
            return fb.getQFilter();
        }
        return null;
    }

    public Long insertExecLogByOne(Long replacePlanId, Map<String, Set<Long>> bomentryIdMap, Long orgId, String opKey) {
        HashSet<Long> allBomEntryIdSet = new HashSet<Long>(64);
        HashMap<Long, String> bomEntryIdRepMap = new HashMap<Long, String>(64);
        HashMap<Long, Long> replacePlanMap = new HashMap<Long, Long>(64);
        for (Map.Entry<String, Set<Long>> bomEntrys : bomentryIdMap.entrySet()) {
            Set<Long> entryIdSet = bomEntrys.getValue();
            if (entryIdSet == null || entryIdSet.isEmpty()) continue;
            allBomEntryIdSet.addAll(entryIdSet);
            for (Long entryId : entryIdSet) {
                bomEntryIdRepMap.put(entryId, bomEntrys.getKey());
                replacePlanMap.put(entryId, replacePlanId);
            }
        }
        return this.insertExecLog(allBomEntryIdSet, orgId, replacePlanMap, bomEntryIdRepMap, opKey);
    }

    public DynamicObject addLogHead(Long orgId) {
        DynamicObject head = BusinessDataServiceHelper.newDynamicObject((String)"mpdm_replaceplan_log");
        head.set("org", (Object)orgId);
        head.set("billno", (Object)"");
        head.set("billstatus", (Object)"A");
        head.set("creator", (Object)RequestContext.get().getCurrUserId());
        head.set("createtime", (Object)new Date());
        head.set("runstatus", (Object)"B");
        head.set("calculatepro", (Object)BigDecimal.ZERO);
        return head;
    }

    public Set<Long> getOptBomIdSet(Set<Long> bomIdSet) {
        HashSet<Long> optBomIdSet = new HashSet<Long>(16);
        QFilter qfilter = new QFilter("id", "in", bomIdSet);
        qfilter.and(new QFilter("optioncontrol", "=", (Object)"A"));
        qfilter.and(new QFilter("type.configtype", "=", (Object)"A"));
        qfilter.and(new QFilter("materialid.configproperties", "=", (Object)"3"));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"pdm_mftbom", (String)"id", (QFilter[])new QFilter[]{qfilter});
        for (DynamicObject bom : coll) {
            optBomIdSet.add(bom.getLong("id"));
        }
        return optBomIdSet;
    }

    public void addLogEntry(DynamicObject head, Set<Long> allBomEntryIdSet, Map<Long, Long> replacePlanMap, Map<Long, String> bomEntryIdRepMap, Long orgId, String opKey) {
        DynamicObjectCollection coll = head.getDynamicObjectCollection("entryentity");
        QFilter qFilter = new QFilter("entry.id", "in", allBomEntryIdSet);
        JSONArray bomDatas = this.getBomData(qFilter);
        int size = bomDatas.size();
        JSONObject bomData = null;
        for (int i = 0; i < size; ++i) {
            bomData = bomDatas.getJSONObject(i);
            Long bomEntryId = bomData.getLong("entryid");
            DynamicObject entry = coll.addNew();
            entry.set("seq", (Object)(i + 1));
            entry.set("replaceplan", (Object)replacePlanMap.get(bomEntryId));
            entry.set("updatetype", (Object)this.getUpdateType(opKey));
            entry.set("bomid", (Object)bomData.getLong("id"));
            entry.set("bomentryid", (Object)bomEntryId);
            entry.set("bomnumber", (Object)bomData.getString("number"));
            entry.set("bomentryseq", (Object)bomData.getInteger("seq"));
            entry.set("entrymaterialid", (Object)bomData.getLong("entrymaterialid"));
            entry.set("begindate", null);
            entry.set("enddate", null);
            entry.set("exectimelong", (Object)BigDecimal.ZERO);
            entry.set("entryexecstatus", (Object)"A");
            entry.set("detiallog", (Object)"");
            entry.set("replacegroup", (Object)bomEntryIdRepMap.get(bomEntryId));
        }
        head.set("updatemode", (Object)this.getUpdateType(opKey));
        this.genLogBillNo(head, orgId);
    }

    public Long saveLog(DynamicObject head) {
        String errorString;
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(16);
        saveList.add(head);
        OperateOption option = this.getOperateOption();
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"mpdm_replaceplan_log", (DynamicObject[])saveList.toArray(new DynamicObject[saveList.size()]), (OperateOption)option);
        if (saveResult.getAllErrorOrValidateInfo() != null && !StringUtils.isEmpty((String)(errorString = this.getErrorMsg(saveResult)))) {
            String errorStr = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u6267\u884c\u65e5\u5fd7\u7ed3\u679c\u65f6\u53d1\u751f\u9519\u8bef\uff1a%1$s\u3002", (String)"ReplacePlanBusiness_01", (String)"bd-mpdm-business", (Object[])new Object[0]), errorString);
            throw new KDBizException(errorStr);
        }
        List successDataList = saveResult.getSuccessPkIds();
        return (Long)successDataList.get(0);
    }

    public Long insertExecLogByBatch(Map<String, Long> bomReplaceMap, Map<String, Set<Long>> bomentryIdMap, Long orgId, String opKey) {
        HashSet<Long> allBomEntryIdSet = new HashSet<Long>(64);
        HashMap<Long, String> bomEntryIdRepMap = new HashMap<Long, String>(64);
        HashMap<Long, Long> replacePlanMap = new HashMap(64);
        for (Map.Entry<String, Set<Long>> bomEntrys : bomentryIdMap.entrySet()) {
            Set<Long> entryIdSet = bomEntrys.getValue();
            if (entryIdSet == null || entryIdSet.isEmpty()) continue;
            allBomEntryIdSet.addAll(entryIdSet);
            for (Long entryId : entryIdSet) {
                bomEntryIdRepMap.put(entryId, bomEntrys.getKey());
                replacePlanMap.put(entryId, bomReplaceMap.get(bomEntrys.getKey()));
            }
        }
        if ("btn_delreplace".equals(opKey)) {
            replacePlanMap = this.queryBomEntryReplacePlan(allBomEntryIdSet);
        }
        return this.insertExecLog(allBomEntryIdSet, orgId, replacePlanMap, bomEntryIdRepMap, opKey);
    }

    public Map<Long, Long> queryBomEntryReplacePlan(Set<Long> allBomEntryIdSet) {
        HashMap<Long, Long> replacePlanMap = new HashMap<Long, Long>(64);
        String selectFields = "entryid,entryreplaceplan";
        QFilter qfilter = new QFilter("entryid", "in", allBomEntryIdSet);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"pdm_mftbomentry", (String)selectFields, (QFilter[])new QFilter[]{qfilter}, (String)"");
        for (DynamicObject dy : coll) {
            replacePlanMap.put(dy.getLong("entryid"), dy.getLong("entryreplaceplan"));
        }
        return replacePlanMap;
    }

    public Long insertExecLog(Set<Long> allBomEntryIdSet, Long orgId, Map<Long, Long> replacePlanMap, Map<Long, String> bomEntryIdRepMap, String opKey) {
        DynamicObject head = this.addLogHead(orgId);
        this.addLogEntry(head, allBomEntryIdSet, replacePlanMap, bomEntryIdRepMap, orgId, opKey);
        return this.saveLog(head);
    }

    private String getErrorMsg(OperationResult operationResult) {
        StringBuilder errMsg = new StringBuilder();
        List validateErrors = operationResult.getValidateResult().getValidateErrors();
        for (ValidateResult validateResult : validateErrors) {
            List allErrorInfo = validateResult.getAllErrorInfo();
            String validatorKey = validateResult.getValidatorKey();
            allErrorInfo.forEach(operateErrorInfo -> {
                String message = operateErrorInfo.getMessage();
                errMsg.append(validatorKey).append(message);
            });
        }
        if (errMsg.length() < 1 && !operationResult.getAllErrorInfo().isEmpty()) {
            errMsg.append(operationResult.getAllErrorInfo());
        }
        if (errMsg.length() < 1 && !operationResult.isSuccess() && operationResult.getMessage() != null) {
            errMsg.append(operationResult.getMessage());
        }
        if (errMsg.length() < 1 && operationResult.getInteractionContext() != null && operationResult.getInteractionContext().getSimpleMessage() != null) {
            errMsg.append(operationResult.getInteractionContext().getSimpleMessage());
        }
        if (errMsg.length() < 1 && !operationResult.isSuccess()) {
            errMsg.append(operationResult.toString());
        }
        return errMsg.toString();
    }

    private OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", "true");
        option.setVariableValue("ignoreinteraction", "true");
        option.setVariableValue("batchop_batchsize", "50");
        option.setVariableValue("needlog", String.valueOf(true));
        return option;
    }

    private void genLogBillNo(DynamicObject head, Long orgId) {
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)"mpdm_replaceplan_log", (DynamicObject)head, (String)String.valueOf(orgId));
        if (codeRuleInfo == null) {
            head.set("billno", (Object)("AUTO-" + ORM.create().genLongId("mpdm_replaceplan_log")));
        } else {
            head.set("billno", (Object)this.getNumbers(codeRuleInfo, head));
        }
    }

    private String getNumbers(CodeRuleInfo codeRule, DynamicObject data) {
        return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)data);
    }

    private String getUpdateType(String opKey) {
        if ("addbomdata".equalsIgnoreCase(opKey) || "btn_addreplace".equalsIgnoreCase(opKey)) {
            return "A";
        }
        if ("btn_resetreplace".equalsIgnoreCase(opKey)) {
            return "B";
        }
        if ("updatebomdata".equalsIgnoreCase(opKey)) {
            return "D";
        }
        return "C";
    }

    private Map<String, Object> buildResultMap(String msg, boolean isSuccessful, String msg_tag) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("msg", msg);
        resultMap.put("result", isSuccessful);
        resultMap.put("msg_tag", msg_tag);
        return resultMap;
    }

    private DynamicObject getLog(Long logId) {
        String selectProperties = this.getLogSelectProperties();
        QFilter qfilter = new QFilter("id", "=", (Object)logId);
        return BusinessDataServiceHelper.loadSingle((String)"mpdm_replaceplan_log", (String)selectProperties, (QFilter[])new QFilter[]{qfilter});
    }

    private String getLogSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("billno");
        sb.append(",").append("runstatus");
        sb.append(",").append("calculatepro");
        sb.append(",entryentity.").append("updatetype");
        sb.append(",entryentity.").append("replaceplan");
        sb.append(",entryentity.").append("bomid");
        sb.append(",entryentity.").append("bomentryid");
        sb.append(",entryentity.").append("bomentryseq");
        sb.append(",entryentity.").append("begindate");
        sb.append(",entryentity.").append("enddate");
        sb.append(",entryentity.").append("exectimelong");
        sb.append(",entryentity.").append("entryexecstatus");
        sb.append(",entryentity.").append("detiallog");
        sb.append(",entryentity.").append("detiallog_tag");
        sb.append(",entryentity.").append("replacegroup");
        return sb.toString();
    }

    public Map<String, Object> updateBomEntryByLog(Long logid) {
        Map<String, Object> resultMap = this.buildResultMap("", true, "");
        DynamicObject log = this.getLog(logid);
        DynamicObjectCollection coll = log.getDynamicObjectCollection("entryentity");
        ArrayList<String> groupNoList = new ArrayList<String>(16);
        Map<String, List<DynamicObject>> groupNoMap = this.getReplaceGroupNoList(coll, groupNoList);
        BigDecimal calculatepro = BigDecimal.ONE;
        log.set("runstatus", (Object)"B");
        log.set("calculatepro", (Object)calculatepro);
        int size = groupNoList.size();
        boolean hasError = false;
        StringBuilder errorSimpleString = new StringBuilder();
        StringBuilder errorDetailString = new StringBuilder();
        boolean saveLogTag = true;
        if (size > 0) {
            for (String replaceGroupNo : groupNoList) {
                calculatepro = ONE00.divide(new BigDecimal(size), new MathContext(10));
                if (calculatepro.compareTo(ONE00) >= 0) {
                    calculatepro = ONE99;
                }
                long startTime = System.currentTimeMillis();
                log.set("calculatepro", (Object)calculatepro);
                List<DynamicObject> entryList = groupNoMap.get(replaceGroupNo);
                Long replacePlanId = this.getReplacePlanId(entryList);
                Long bomId = this.getBomId(entryList);
                Set<Long> bomEntryIdSet = this.getBomEntryIdFromLog(entryList);
                this.updateLongEntryData(entryList, new Date(), null, "", "", true);
                saveLogTag = this.saveLogSetp(log);
                if (!saveLogTag) break;
                String updateType = this.getUpdateType(entryList);
                Map<String, Object> childResultMap = this.updateBomEntryReplacePlan(bomId, bomEntryIdSet, replaceGroupNo, replacePlanId, updateType);
                String execResultSimple = this.getErrorSimpleString(childResultMap);
                String execResultDetail = this.getErrorDetailString(childResultMap);
                boolean execResult = this.checkIsOk(childResultMap);
                if (!execResult) {
                    hasError = true;
                    errorSimpleString.append(execResultSimple).append("\r\n");
                    errorDetailString.append(execResultDetail).append("\r\n");
                } else {
                    long enddate = System.currentTimeMillis() - startTime;
                    execResultDetail = execResultSimple = String.format(ResManager.loadKDString((String)"\u8017\u65f6\uff1a%1$s\uff08ms\uff09\u3002", (String)"ReplacePlanBusiness_03", (String)"bd-mpdm-business", (Object[])new Object[0]), enddate);
                }
                this.updateLongEntryData(entryList, null, new Date(), execResultSimple, execResultDetail, execResult);
                saveLogTag = this.saveLogSetp(log);
                if (saveLogTag) continue;
                break;
            }
        }
        if (!saveLogTag) {
            return this.buildResultMap(" save Log error", false, " save Log error");
        }
        log.set("calculatepro", (Object)ONE00);
        if (hasError) {
            log.set("runstatus", (Object)"D");
        } else {
            log.set("runstatus", (Object)"C");
        }
        this.saveLogSetp(log);
        if (errorSimpleString.length() > 0) {
            resultMap = this.buildResultMap(errorSimpleString.toString(), false, errorDetailString.toString());
        }
        return resultMap;
    }

    private boolean saveLogSetp(DynamicObject log) {
        try {
            SaveServiceHelper.update((DynamicObject)log);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.updateLogEnd(log);
            return false;
        }
        return true;
    }

    private void updateLogEnd(DynamicObject log) {
        DB.execute((DBRoute)scmDBRoute, (String)UPDATELOGERROR_SQL, (Object[])new Object[]{log.getPkValue()});
        DB.execute((DBRoute)scmDBRoute, (String)UPDATELOGENTRYERROR_SQL, (Object[])new Object[]{log.getPkValue()});
    }

    private boolean checkIsOk(Map<String, Object> resultMap) {
        return (Boolean)resultMap.get("result");
    }

    private String getErrorSimpleString(Map<String, Object> resultMap) {
        if (this.checkIsOk(resultMap)) {
            return "";
        }
        String msg = (String)resultMap.get("msg");
        if (StringUtils.isEmpty((String)msg)) {
            msg = "error:msg is null";
        }
        return msg;
    }

    private String getErrorDetailString(Map<String, Object> resultMap) {
        if (this.checkIsOk(resultMap)) {
            return "";
        }
        String msg = (String)resultMap.get("msg_tag");
        if (StringUtils.isEmpty((String)msg)) {
            msg = "error:msg is null";
        }
        return msg;
    }

    private Long getReplacePlanId(List<DynamicObject> entryList) {
        DynamicObject entry = entryList.get(0);
        return (Long)entry.getDynamicObject("replaceplan").getPkValue();
    }

    private String getUpdateType(List<DynamicObject> entryList) {
        DynamicObject entry = entryList.get(0);
        return entry.getString("updatetype");
    }

    private Long getBomId(List<DynamicObject> entryList) {
        DynamicObject entry = entryList.get(0);
        return entry.getLong("bomid");
    }

    private Set<Long> getBomEntryIdFromLog(List<DynamicObject> entryList) {
        HashSet<Long> bomentryIdSet = new HashSet<Long>(16);
        for (int i = 0; i < entryList.size(); ++i) {
            DynamicObject entry = entryList.get(i);
            Long bomentryId = entry.getLong("bomentryid");
            bomentryIdSet.add(bomentryId);
        }
        return bomentryIdSet;
    }

    private void updateLongEntryData(List<DynamicObject> entryList, Date beginDate, Date endDate, String msg, String msg_tag, boolean execResult) {
        for (int i = 0; i < entryList.size(); ++i) {
            DynamicObject entry = entryList.get(i);
            if (beginDate != null && endDate == null) {
                entry.set("entryexecstatus", (Object)"B");
                entry.set("begindate", (Object)beginDate);
                continue;
            }
            if (execResult) {
                entry.set("entryexecstatus", (Object)"C");
            } else {
                entry.set("entryexecstatus", (Object)"D");
            }
            entry.set("enddate", (Object)endDate);
            if (msg.length() > 250) {
                msg = msg.substring(0, 250);
            }
            entry.set("detiallog", (Object)msg);
            entry.set("detiallog_tag", (Object)msg_tag);
            entry.set("exectimelong", (Object)this.getDiffDateLong(entry.getDate("begindate"), endDate));
        }
    }

    private BigDecimal getDiffDateLong(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            return BigDecimal.ZERO;
        }
        long date1ms = beginDate.getTime();
        long date2ms = endDate.getTime();
        return new BigDecimal(date2ms - date1ms).divide(new BigDecimal("1000"), new MathContext(10));
    }

    private Map<String, List<DynamicObject>> getReplaceGroupNoList(DynamicObjectCollection coll, List<String> groupNoList) {
        HashMap<String, List<DynamicObject>> map = new HashMap<String, List<DynamicObject>>(16);
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject entry = (DynamicObject)coll.get(i);
            String replaceGroupNo = entry.getString("replacegroup");
            ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)map.get(replaceGroupNo);
            if (list == null) {
                list = new ArrayList<DynamicObject>(16);
                groupNoList.add(replaceGroupNo);
            }
            list.add(entry);
            map.put(replaceGroupNo, list);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> updateBomEntryReplacePlan(Long bomId, Set<Long> bomEntryIdSet, String replaceGroupNo, Long replacePlanId, String updateType) {
        HashSet lockSuccessfulIdSet;
        Map bomMap = ReplaceUpdateBomUtils.getBomIdMap(bomEntryIdSet);
        String message = ReplaceUpdateBomUtils.batchRequire((Map)bomMap, lockSuccessfulIdSet = new HashSet(16));
        if (!StringUtils.isEmpty((String)message)) {
            return this.buildResultMap(message, Boolean.FALSE, message);
        }
        try {
            JSONObject resultData = (JSONObject)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"IUpdateBomReplacePlan", (String)"updateBom", (Object[])new Object[]{bomId, bomEntryIdSet, replaceGroupNo, replacePlanId, updateType});
            Map<String, Object> map = this.buildResultMap(resultData.getString("msg"), resultData.getBoolean("result"), resultData.getString("msg_tag"));
            return map;
        }
        finally {
            ReplaceUpdateBomUtils.releaseLock(lockSuccessfulIdSet);
        }
    }

    public boolean checkBomEntryIdMatch(Long replacePlanId, Set<Long> bomEntryId) {
        DynamicObject replacePlan = this.getReplacePlan(replacePlanId);
        DynamicObjectCollection coll = this.getReplacePlanMMEntry(replacePlan);
        QFilter qFilter = new QFilter("entry.id", "in", bomEntryId);
        qFilter.and(new QFilter("entry.entryisreplace", "=", (Object)false));
        JSONArray bomDatas = this.getBomData(qFilter);
        if (bomDatas.isEmpty()) {
            return false;
        }
        DynamicObjectCollection rmColl = this.getReplacePlanRMEntry(replacePlan);
        Map<String, Set<Long>> matchResult = this.genMatchBomEntryDataList(bomDatas, coll, false, rmColl);
        return matchResult != null && !matchResult.isEmpty();
    }

    public String getBomTag(JSONObject bomData) {
        String bomNumber = bomData.getString("number");
        String bomSeq = bomData.getString("seq");
        String materialId = bomData.getString("entrymaterialid");
        StringBuilder sb = new StringBuilder();
        sb.append("bomnumber:").append(bomNumber).append(",bomseq:").append(bomSeq).append(",materialId:").append(materialId);
        return sb.toString();
    }

    public String autoReplaceBomData(Long orgId, Long replacePlanId, QFilter bomQFilter, boolean isAdd) {
        String msg;
        String opKey = isAdd ? "addbomdata" : "updatebomdata";
        ReplacePlanBusiness business = new ReplacePlanBusiness();
        Map<String, Set<Long>> matchMap = business.getEffectBomEntryIdSetByFilter(orgId, bomQFilter, replacePlanId, isAdd);
        if (matchMap == null || matchMap.isEmpty()) {
            return "";
        }
        Long logId = this.insertExecLogByOne(replacePlanId, matchMap, orgId, opKey);
        Map<String, Object> childResultMap = business.updateBomEntryByLog(logId);
        boolean isSuccessful = childResultMap == null ? false : (Boolean)childResultMap.get("result");
        String string = msg = childResultMap == null ? "" : (String)childResultMap.get("msg");
        if (!isSuccessful) {
            return msg;
        }
        return msg;
    }
}

