/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.calendar;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.botp.EcoCommonHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class SyncOrgDataToTreeBusiness {
    private static final String ENTITY_TREE = "mpdm_org_workcenter_tree";
    private static final String ENTITY_WORKCENTER = "mpdm_workcentre";
    private static final String ENTITY_WORKSHOP = "mpdm_workshopsetup";

    private String getOrgSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",org.id orgId");
        sb.append(",org.number orgNumber");
        sb.append(",org.name orgName");
        sb.append(",parent parentId");
        sb.append(",level");
        sb.append(",longnumber");
        sb.append(",fullname");
        sb.append(",isleaf");
        return sb.toString();
    }

    private String getTreeSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",number");
        sb.append(",name");
        sb.append(",issyncdata");
        sb.append(",workshop");
        sb.append(",workcenter");
        sb.append(",org");
        sb.append(",parentorg");
        sb.append(",level");
        sb.append(",longnumber");
        sb.append(",isleaf");
        sb.append(",parent");
        sb.append(",type");
        sb.append(",enable");
        sb.append(",status");
        sb.append(",masterid");
        sb.append(",creator");
        sb.append(",createtime");
        sb.append(",fullname");
        sb.append(",modifier");
        sb.append(",modifytime");
        return sb.toString();
    }

    private String getWcSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",createorg");
        sb.append(",number");
        sb.append(",name");
        sb.append(",workshop");
        return sb.toString();
    }

    private String getWorkShopSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",createorg");
        sb.append(",workshoporg.number number");
        sb.append(",workshoporg.name name");
        return sb.toString();
    }

    private QFilter getEnableQFiter() {
        QFilter qf = new QFilter("enable", "=", (Object)"1");
        qf.and(new QFilter("status", "=", (Object)"C"));
        return qf;
    }

    private QFilter getCreateOrgQFiter(Set<Long> orgIdSet) {
        QFilter qf = new QFilter("createorg", "in", orgIdSet);
        qf.and(this.getEnableQFiter());
        return qf;
    }

    private DynamicObjectCollection queryWorkCenterDataByOrg(Set<Long> orgIdSet) {
        QFilter qf = this.getCreateOrgQFiter(orgIdSet);
        return QueryServiceHelper.query((String)ENTITY_WORKCENTER, (String)this.getWcSelectProperties(), (QFilter[])new QFilter[]{qf}, (String)"number");
    }

    private DynamicObjectCollection queryWorkShopDataByOrg(Set<Long> orgIdSet) {
        QFilter qf = this.getCreateOrgQFiter(orgIdSet);
        return QueryServiceHelper.query((String)ENTITY_WORKSHOP, (String)this.getWorkShopSelectProperties(), (QFilter[])new QFilter[]{qf}, (String)"number");
    }

    private DynamicObjectCollection queryNewOrgDatas(Long viewId, QFilter qfilter) {
        QFilter filterTreetype = new QFilter("view", "=", (Object)viewId);
        if (qfilter != null) {
            filterTreetype = filterTreetype.and(qfilter);
        }
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter = freezeFilter.or(freezeFilter1);
        return QueryServiceHelper.query((String)"bos_org_structure", (String)this.getOrgSelectProperties(), (QFilter[])new QFilter[]{filterTreetype, freezeFilter}, (String)"level,longnumber");
    }

    private DynamicObject buildOrgDataByHis(DynamicObject hisTree) {
        DynamicObject tree = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_TREE);
        EcoCommonHelper.putHeadProperties((DynamicObject)hisTree, (DynamicObject)tree, null);
        tree.set("parent", null);
        return tree;
    }

    private DynamicObject buildTreeData(Long id, Long currentUserId, Date currentDate) {
        DynamicObject tree = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_TREE);
        tree.set("id", (Object)id);
        tree.set("masterid", (Object)id);
        tree.set("creator", (Object)currentUserId);
        tree.set("createtime", (Object)currentDate);
        tree.set("issyncdata", (Object)true);
        tree.set("enable", (Object)"1");
        tree.set("status", (Object)"C");
        tree.set("type", (Object)"A");
        return tree;
    }

    public Long getNearParentId(Long oldParentId, Set<Long> orgIdSetA, Long rootId) {
        for (int i = 0; i < 20; ++i) {
            DynamicObjectCollection coll = this.queryNewOrgDatas(914427355726916608L, new QFilter("org", "=", (Object)oldParentId));
            if (coll == null || coll.isEmpty()) break;
            oldParentId = ((DynamicObject)coll.get(0)).getLong("parentId");
            if (!orgIdSetA.contains(oldParentId)) continue;
            return oldParentId;
        }
        return rootId;
    }

    public DynamicObjectCollection mergeOrgData(DynamicObjectCollection orgColA, DynamicObjectCollection orgColB) {
        DynamicObjectCollection orgCol = orgColA;
        Long rootId = 0L;
        if (!orgColA.isEmpty()) {
            rootId = ((DynamicObject)orgColA.get(0)).getLong("orgId");
        }
        if (orgColB != null && !orgColB.isEmpty()) {
            Set<Long> orgIdSetA = orgColA.stream().map(p -> p.getLong("orgId")).collect(Collectors.toSet());
            Set orgIdSetB = orgColB.stream().map(p -> p.getLong("orgId")).collect(Collectors.toSet());
            for (DynamicObject obj : orgColB) {
                Long orgId = obj.getLong("orgId");
                if (orgId == null || orgId.equals(0L) || orgIdSetA.contains(orgId)) continue;
                Long parentId = obj.getLong("parentId");
                if (!(parentId == null || parentId.equals(0L) || orgIdSetA.contains(parentId) || orgIdSetB.contains(parentId))) {
                    obj.set("parentId", (Object)this.getNearParentId(parentId, orgIdSetA, rootId));
                }
                orgCol.add((Object)obj);
            }
        }
        return orgCol;
    }

    public void syncOrgData() {
        DynamicObjectCollection dynamicObjectCollection;
        DynamicObject tree;
        Long parentId;
        DynamicObjectCollection orgColA = this.queryNewOrgDatas(4L, null);
        DynamicObjectCollection orgColB = this.queryNewOrgDatas(914427355726916608L, null);
        DynamicObjectCollection orgCol = this.mergeOrgData(orgColA, orgColB);
        QFilter qf = new QFilter("id", ">", (Object)0L);
        QFilter qf2 = new QFilter("issyncdata", "=", (Object)false);
        DynamicObject[] hisHandTreeColl = BusinessDataServiceHelper.load((String)ENTITY_TREE, (String)this.getTreeSelectProperties(), (QFilter[])new QFilter[]{qf, qf2});
        DeleteServiceHelper.delete((String)ENTITY_TREE, (QFilter[])new QFilter[]{qf});
        Set orgIdSet = orgCol.stream().map(p -> p.getLong("orgId")).collect(Collectors.toSet());
        HashSet<Long> allOrgIdSet = new HashSet<Long>(128);
        allOrgIdSet.addAll(orgIdSet);
        Date currentDate = new Date();
        Long currentUserId = RequestContext.get().getCurrUserId();
        HashMap<Long, DynamicObject> treeMap = new HashMap<Long, DynamicObject>(128);
        HashMap<Long, Long> parentOrgIdMap = new HashMap<Long, Long>(128);
        long[] ids = ORM.create().genLongIds(ENTITY_TREE, orgCol.size());
        int i = 0;
        for (DynamicObject dynamicObject : orgCol) {
            Long id = ids[i];
            Long orgId = dynamicObject.getLong("orgId");
            if (orgId == null || orgId.equals(0L)) continue;
            parentId = dynamicObject.getLong("parentId");
            DynamicObject tree2 = this.buildTreeData(id, currentUserId, currentDate);
            tree2.set("number", (Object)dynamicObject.getString("orgNumber"));
            tree2.set("name", (Object)dynamicObject.getString("orgName"));
            tree2.set("level", (Object)dynamicObject.getInt("level"));
            tree2.set("org", (Object)orgId);
            tree2.set("parentorg", (Object)parentId);
            tree2.set("longnumber", (Object)dynamicObject.getString("longnumber"));
            tree2.set("fullname", (Object)dynamicObject.getString("fullname"));
            tree2.set("isleaf", (Object)dynamicObject.getBoolean("isleaf"));
            if (parentId == null || parentId.equals(0L)) {
                tree2.set("parent", null);
            }
            treeMap.put(orgId, tree2);
            parentOrgIdMap.put(orgId, parentId);
            ++i;
        }
        for (DynamicObject hisTree : hisHandTreeColl) {
            Long hisOrgId = SyncOrgDataToTreeBusiness.getDynamicObjectId(hisTree.getDynamicObject("org"));
            Long hisOrgParentId = SyncOrgDataToTreeBusiness.getDynamicObjectId(hisTree.getDynamicObject("parentorg"));
            if (orgIdSet.contains(hisOrgId)) continue;
            tree = this.buildOrgDataByHis(hisTree);
            tree.set("isleaf", (Object)true);
            tree.set("type", (Object)"A");
            treeMap.put(hisOrgId, tree);
            parentOrgIdMap.put(hisOrgId, hisOrgParentId);
            allOrgIdSet.add(hisOrgId);
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            DynamicObject parentTree;
            Long orgId = (Long)entry.getKey();
            DynamicObject tree3 = (DynamicObject)entry.getValue();
            parentId = (Long)parentOrgIdMap.get(orgId);
            if (parentId == null || (parentTree = (DynamicObject)treeMap.get(parentId)) == null) continue;
            tree3.set("parent", (Object)parentTree);
            tree3.set("longnumber", (Object)(parentTree.getString("longnumber") + "!" + tree3.getString("number")));
            tree3.set("level", (Object)(parentTree.getInt("level") + 1));
            parentTree.set("isleaf", (Object)false);
        }
        DynamicObjectCollection workShopDatas = this.queryWorkShopDataByOrg(allOrgIdSet);
        if (!workShopDatas.isEmpty()) {
            ids = ORM.create().genLongIds(ENTITY_TREE, workShopDatas.size());
            i = 0;
            for (DynamicObject workShop : workShopDatas) {
                Long workShopId = workShop.getLong("id");
                Long createorgId = workShop.getLong("createorg");
                Long id = ids[i];
                tree = this.buildTreeData(id, currentUserId, currentDate);
                tree.set("number", (Object)workShop.getString("number"));
                tree.set("name", (Object)workShop.getString("name"));
                tree.set("workshop", (Object)workShopId);
                tree.set("org", (Object)createorgId);
                tree.set("parentorg", (Object)0L);
                tree.set("isleaf", (Object)true);
                tree.set("type", (Object)"B");
                treeMap.put(workShopId, tree);
                DynamicObject parentTree = (DynamicObject)treeMap.get(createorgId);
                if (parentTree != null) {
                    tree.set("parent", (Object)parentTree);
                    tree.set("level", (Object)(parentTree.getInt("level") + 1));
                    tree.set("longnumber", (Object)(parentTree.getString("longnumber") + "!" + tree.getString("number")));
                    parentTree.set("isleaf", (Object)false);
                }
                ++i;
            }
        }
        if (!(dynamicObjectCollection = this.queryWorkCenterDataByOrg(allOrgIdSet)).isEmpty()) {
            ids = ORM.create().genLongIds(ENTITY_TREE, dynamicObjectCollection.size());
            i = 0;
            for (DynamicObject workCenter : dynamicObjectCollection) {
                Long workCenterId = workCenter.getLong("id");
                Long createorgId = workCenter.getLong("createorg");
                Long workshopId = workCenter.getLong("workshop");
                if (workshopId != null && !workshopId.equals(0L) && !treeMap.containsKey(workshopId)) {
                    workshopId = 0L;
                }
                Long id = ids[i];
                DynamicObject tree4 = this.buildTreeData(id, currentUserId, currentDate);
                tree4.set("number", (Object)workCenter.getString("number"));
                tree4.set("name", (Object)workCenter.getString("name"));
                tree4.set("workcenter", (Object)workCenterId);
                tree4.set("workshop", (Object)workshopId);
                tree4.set("org", (Object)createorgId);
                tree4.set("parentorg", (Object)0L);
                tree4.set("isleaf", (Object)true);
                tree4.set("type", (Object)"C");
                treeMap.put(workCenterId, tree4);
                Long keyIds = workshopId == null || workshopId.equals(0L) ? createorgId : workshopId;
                DynamicObject parentTree = (DynamicObject)treeMap.get(keyIds);
                if (parentTree != null) {
                    tree4.set("parent", (Object)parentTree);
                    tree4.set("level", (Object)(parentTree.getInt("level") + 1));
                    tree4.set("longnumber", (Object)(parentTree.getString("longnumber") + "!" + tree4.getString("number")));
                    parentTree.set("isleaf", (Object)false);
                }
                ++i;
            }
        }
        Collection colls = treeMap.values();
        SaveServiceHelper.save((DynamicObject[])colls.toArray(new DynamicObject[colls.size()]));
    }

    public static long getParentOrgId(Long id) {
        String selectFields = "parent";
        QFilter qfA = new QFilter("org", "=", (Object)id);
        QFilter qfB = new QFilter("type", "=", (Object)"A");
        DynamicObject org = QueryServiceHelper.queryOne((String)ENTITY_TREE, (String)selectFields, (QFilter[])new QFilter[]{qfA, qfB});
        return org == null ? 0L : org.getLong("parent");
    }

    public static Long getDynamicObjectId(DynamicObject dy) {
        Long id = 0L;
        if (dy != null) {
            id = (Long)dy.getPkValue();
        }
        return id;
    }

    public DynamicObjectCollection getOrgDatas(String appid) {
        String orderBy = "level,type,longnumber,number";
        HasPermOrgResult hasPermOrgResult = this.getPermissionOrgs(appid);
        QFilter[] qf = null;
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            QFilter filterOrg = new QFilter("org.id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            qf = new QFilter[]{filterOrg};
        }
        return QueryServiceHelper.query((String)ENTITY_TREE, (String)this.getTreeSelectProperties(), qf, (String)orderBy);
    }

    public HasPermOrgResult getPermissionOrgs(String appid) {
        RequestContext requestContext = RequestContext.get();
        long userID = requestContext.getCurrUserId();
        String formId = "mpdm_calendar_setting";
        return PermissionServiceHelper.getAllPermOrgs((long)userID, (String)"15", (String)(StringUtils.isEmpty((String)appid) ? "0efa1992000000ac" : appid), (String)formId, (String)"47150e89000000ac");
    }
}

