/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class UpdateProjectEvent
implements IEventServicePlugin {
    public Object handleEvent(KDBizEvent evt) {
        EntityEvent event = (EntityEvent)evt;
        List businesskeys = event.getBusinesskeys();
        ArrayList<Long> ids = new ArrayList<Long>(8);
        if (businesskeys == null) {
            return super.handleEvent(evt);
        }
        businesskeys.forEach(id -> ids.add(Long.parseLong(id)));
        String entityNumber = event.getEntityNumber();
        if (StringUtils.equals((CharSequence)"mpdm_materialmtcinfo", (CharSequence)entityNumber)) {
            this.updateProjectWithMaterialMtcInfo(ids);
        } else if (StringUtils.equals((CharSequence)"mpdm_mrtype", (CharSequence)entityNumber)) {
            this.updateProjectWithMrType(ids);
        }
        return super.handleEvent(evt);
    }

    private void updateProjectWithMaterialMtcInfo(List<Long> businesskeys) {
        DynamicObject[] pmpd_projects;
        HashMap<Long, UpdateModel> map = new HashMap<Long, UpdateModel>();
        String selectFields = "id,egmodelone,mratype.id,mratype.modelone,mratype.modelmpdone,mratype.modeltwo,mratype.modeltrd";
        DynamicObjectCollection materialMtcInfos = QueryServiceHelper.query((String)"mpdm_materialmtcinfo", (String)selectFields, (QFilter[])new QFilter("id", "in", businesskeys).toArray());
        for (DynamicObject materialMtcInfo : materialMtcInfos) {
            UpdateModel updateModel = new UpdateModel(materialMtcInfo.getLong("id"), materialMtcInfo.getLong("mratype.id"), materialMtcInfo.getString("mratype.modelone"), materialMtcInfo.getString("mratype.modelmpdone"), materialMtcInfo.getString("mratype.modeltwo"), materialMtcInfo.getString("mratype.modeltrd"));
            updateModel.setEgModelOne(materialMtcInfo.getString("egmodelone"));
            map.put(materialMtcInfo.getLong("id"), updateModel);
        }
        QFilter qFilter = new QFilter("devices", "in", businesskeys);
        for (DynamicObject project : pmpd_projects = BusinessDataServiceHelper.load((String)"pmpd_project", (String)"id,devices,fixdevicetype,modelone,modelmpdone,modeltwo,modeltrd,egmodelone", (QFilter[])qFilter.toArray())) {
            long fixdevicetype = project.getLong("devices_id");
            UpdateModel updateModel = (UpdateModel)map.get(fixdevicetype);
            project.set("fixdevicetype_id", (Object)updateModel.getMraTypeId());
            project.set("modelone", (Object)updateModel.getModelOne());
            project.set("modelmpdone", (Object)updateModel.getModelMPDOne());
            project.set("modeltwo", (Object)updateModel.getModelTwo());
            project.set("modeltrd", (Object)updateModel.getModelTrd());
            project.set("egmodelone", (Object)updateModel.getEgModelOne());
        }
        SaveServiceHelper.save((DynamicObject[])pmpd_projects);
    }

    private void updateProjectWithMrType(List<Long> businesskeys) {
        DynamicObject[] pmpd_projects;
        HashMap<Long, UpdateModel> map = new HashMap<Long, UpdateModel>();
        String selectFields = "id,modelone,modelmpdone,modeltwo,modeltrd";
        DynamicObjectCollection mrTypes = QueryServiceHelper.query((String)"mpdm_mrtype", (String)selectFields, (QFilter[])new QFilter("id", "in", businesskeys).toArray());
        for (DynamicObject mrType : mrTypes) {
            UpdateModel updateModel = new UpdateModel(mrType.getLong("id"), mrType.getLong("id"), mrType.getString("modelone"), mrType.getString("modelmpdone"), mrType.getString("modeltwo"), mrType.getString("modeltrd"));
            map.put(mrType.getLong("id"), updateModel);
        }
        QFilter qFilter = new QFilter("fixdevicetype", "in", businesskeys);
        for (DynamicObject project : pmpd_projects = BusinessDataServiceHelper.load((String)"pmpd_project", (String)"id,devices,fixdevicetype,modelone,modelmpdone,modeltwo,modeltrd", (QFilter[])qFilter.toArray())) {
            long findId = project.getLong("fixdevicetype_id");
            UpdateModel updateModel = (UpdateModel)map.get(findId);
            project.set("modelone", (Object)updateModel.getModelOne());
            project.set("modelmpdone", (Object)updateModel.getModelMPDOne());
            project.set("modeltwo", (Object)updateModel.getModelTwo());
            project.set("modeltrd", (Object)updateModel.getModelTrd());
        }
        SaveServiceHelper.save((DynamicObject[])pmpd_projects);
    }

    static class UpdateModel {
        private long id;
        private long mraTypeId;
        private String modelOne;
        private String modelMPDOne;
        private String modelTwo;
        private String modelTrd;
        private String egModelOne;

        public UpdateModel(long id, long mraTypeId, String modelOne, String modelMPDOne, String modelTwo, String modelTrd) {
            this.id = id;
            this.mraTypeId = mraTypeId;
            this.modelOne = modelOne;
            this.modelMPDOne = modelMPDOne;
            this.modelTwo = modelTwo;
            this.modelTrd = modelTrd;
        }

        public long getId() {
            return this.id;
        }

        public long getMraTypeId() {
            return this.mraTypeId;
        }

        public String getModelOne() {
            return this.modelOne;
        }

        public String getModelMPDOne() {
            return this.modelMPDOne;
        }

        public String getModelTwo() {
            return this.modelTwo;
        }

        public String getModelTrd() {
            return this.modelTrd;
        }

        public String getEgModelOne() {
            return this.egModelOne;
        }

        public void setEgModelOne(String egModelOne) {
            this.egModelOne = egModelOne;
        }
    }
}

