/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.helper.bean.BillMutexInfo;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.mutex.DataMutex;
import kd.bos.mvc.SessionManager;
import kd.bos.sharemeta.ShareMetaUtil;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class BatchMaintainHelper {
    private static final Log logger = LogFactory.getLog(BatchMaintainHelper.class);
    public static final String BILL_GROUP_ID = "default_netctrl";
    public static final String ENTRY_GROUP_ID = "entry_netctrl";
    public static final String TARGET_PROP = "targetEntryProp";
    public static final String LOCKED_ID = "lockedIds";
    public static final String OPKEY = "batchMaintain";
    public static final String BD_MPDM_BUSINESS = "bd-mpdm-business";
    public static final String OPKEYNAME = "opkey";
    private static DistributeSessionlessCache sessionlessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("BatchMaintainHelper-dataMutex", new DistributeCacheHAPolicy(true, true));
    private static final int CACHE_KEEP_TIME_S = Integer.parseInt(System.getProperty("mutex.cachetimeout_h", "24")) * 60 * 60;
    private static final int HEADLOCK_EXPIRE_SECONDS = 14400;

    public static LocalMemoryCache getLocalCache(String formId) {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(43200);
        info.setMaxItemSize(10000);
        String region = ShareMetaUtil.getLocalCacheRegion((String)CacheKeyUtil.getAcctId(), (String)formId);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(region, "BatchMaintainHelper", info);
    }

    public static Map<String, Object> loadDesignerMetadata(String id, String lang, boolean runtime) {
        MetadataReader reader = new MetadataReader(false, lang);
        reader.setAppGroup(AppGroupUtils.getCurrentAppGroup());
        AbstractMetadata metadata = reader.readMetaForMetadataDao(id, BatchMaintainHelper.getDataEntityType(DesignFormMeta.class), runtime, false);
        if (metadata == null && AppGroupUtils.isGrayGroup()) {
            reader = new MetadataReader(false, lang);
            metadata = reader.readMetaForMetadataDao(id, OrmUtils.getDataEntityType(DesignFormMeta.class), runtime, false);
        }
        return metadata == null ? null : metadata.buildDesignMeta(lang);
    }

    private static IDataEntityType getDataEntityType(Class<?> cls) {
        IDataEntityType dataEntityType = OrmUtils.getDataEntityType(cls);
        if (AppGroupUtils.isGrayGroup()) {
            IDataEntityType det;
            try {
                det = (IDataEntityType)dataEntityType.clone();
            }
            catch (CloneNotSupportedException var4) {
                throw new KDException((Throwable)var4, BosErrorCode.bOS, new Object[]{var4.getMessage()});
            }
            det.setAlias(AppGroupUtils.getCurrentAppGroupTableName((String)det.getAlias()));
            return det;
        }
        return dataEntityType;
    }

    public static List<BillMutexInfo> tryLockBill(IPageCache cache, Set<BillMutexInfo> mutexInfos) {
        String lockedIds;
        ArrayList<BillMutexInfo> fails = new ArrayList<BillMutexInfo>();
        ArrayList success = new ArrayList();
        String pageEntityLockKey = cache.getPageId();
        if (CollectionUtils.isNotEmpty(mutexInfos)) {
            Set<BillMutexInfo> billMutexInfo = mutexInfos.stream().filter(k -> !k.isEntryId()).collect(Collectors.toSet());
            List<BillMutexInfo> failBills = BatchMaintainHelper.requireMutex(billMutexInfo);
            Set<BillMutexInfo> successBills = billMutexInfo.stream().filter(k -> !failBills.contains(k)).collect(Collectors.toSet());
            successBills.forEach(su -> {
                HashMap<String, String> dataObjIdMap = new HashMap<String, String>(1);
                dataObjIdMap.put(pageEntityLockKey, System.currentTimeMillis() + "");
                sessionlessCache.put(BatchMaintainHelper.buildIntentKey(su.getEntityName(), su.getId()), dataObjIdMap, CACHE_KEEP_TIME_S);
            });
            List failBillId = failBills.stream().map(BillMutexInfo::getId).collect(Collectors.toList());
            Set noTryEntryMutexInfos = mutexInfos.stream().filter(k -> k.isEntryId() && failBillId.contains(k.getParentId())).collect(Collectors.toSet());
            Set<BillMutexInfo> entryMutexInfos = mutexInfos.stream().filter(k -> k.isEntryId() && !failBillId.contains(k.getParentId())).collect(Collectors.toSet());
            List<BillMutexInfo> failEntrys = BatchMaintainHelper.requireMutex(entryMutexInfos);
            fails.addAll(failBills);
            fails.addAll(failEntrys);
            fails.addAll(noTryEntryMutexInfos);
            success.addAll(mutexInfos.stream().filter(k -> !fails.contains(k)).collect(Collectors.toList()));
        }
        if (StringUtils.isEmpty((String)(lockedIds = cache.get(LOCKED_ID)))) {
            cache.put(LOCKED_ID, SerializationUtils.serializeToBase64(success));
        } else {
            List requiredIds = (List)SerializationUtils.deSerializeFromBase64((String)lockedIds);
            requiredIds.addAll(success);
            cache.put(LOCKED_ID, SerializationUtils.serializeToBase64((Object)requiredIds));
        }
        return fails;
    }

    public static List<BillMutexInfo> requireMutex(Set<BillMutexInfo> billMutexInfos) {
        ArrayList<BillMutexInfo> fails = new ArrayList<BillMutexInfo>();
        ArrayList requireParams = new ArrayList();
        billMutexInfos.forEach(billInfo -> {
            HashMap<String, Object> requireParam = new HashMap<String, Object>();
            requireParam.put("dataObjId", billInfo.getId());
            requireParam.put("dataObjNumber", billInfo.isEntryId() ? billInfo.getEntryNo() : billInfo.getBillNo());
            requireParam.put("groupId", billInfo.isEntryId() ? ENTRY_GROUP_ID : BILL_GROUP_ID);
            requireParam.put("entityKey", billInfo.getEntityName());
            requireParam.put("operationKey", OPKEY);
            requireParam.put("isStrict", true);
            requireParams.add(requireParam);
        });
        Map<String, BillMutexInfo> idBillMutex = billMutexInfos.stream().collect(Collectors.toMap(BillMutexInfo::getId, mutexInfo -> mutexInfo));
        if (requireParams.size() > 0) {
            try (DataMutex dataMutex = DataMutex.create();){
                Map mutexResult = dataMutex.batchrequire(requireParams);
                for (Map.Entry mutexItem : mutexResult.entrySet()) {
                    String objId = (String)mutexItem.getKey();
                    Boolean ret = (Boolean)mutexItem.getValue();
                    BillMutexInfo billMutexInfo = idBillMutex.get(objId);
                    if (ret.booleanValue()) continue;
                    String groupId = billMutexInfo.isEntryId() ? ENTRY_GROUP_ID : BILL_GROUP_ID;
                    Map lockInfo = dataMutex.getLockInfo(objId, groupId, billMutexInfo.getEntityName());
                    if (!(!billMutexInfo.isEntryId() && lockInfo == null || !billMutexInfo.isEntryId() && lockInfo != null && !((String)lockInfo.get(OPKEYNAME)).contains(OPKEY)) && !billMutexInfo.isEntryId()) continue;
                    BatchMaintainHelper.recordFailInfo(lockInfo, billMutexInfo);
                    fails.add(billMutexInfo);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        return fails;
    }

    private static void recordFailInfo(Map<String, String> lockInfo, BillMutexInfo billMutexInfo) {
        StringBuilder errMsg = new StringBuilder();
        if (lockInfo != null) {
            long userId = 0L;
            try {
                userId = Long.parseLong(lockInfo.get("userid"));
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_user");
                Map cacheUserObjs = BusinessDataReader.loadFromCache((Object[])new Object[]{userId}, (DynamicObjectType)dt);
                DynamicObject userObj = (DynamicObject)cacheUserObjs.get(userId);
                if (userObj != null) {
                    errMsg.append(userObj.getString("name")).append(" ");
                }
            }
            catch (NumberFormatException e) {
                logger.warn((Throwable)e);
            }
            if (billMutexInfo.isEntryId()) {
                errMsg.append(String.format(ResManager.loadKDString((String)"\u6b63\u5728\u7f16\u8f91\u3010%1$s\u3011\u5206\u5f55\u3010%2$s\u3011\u8bb0\u5f55\uff0c", (String)"BatchMaintainHelper_1", (String)BD_MPDM_BUSINESS, (Object[])new Object[0]), billMutexInfo.getBillNo(), billMutexInfo.getSeq()));
            } else {
                errMsg.append(String.format(ResManager.loadKDString((String)"\u6b63\u5728\u7f16\u8f91\u3010%s\u3011\u8bb0\u5f55\uff0c", (String)"BatchMaintainHelper_2", (String)BD_MPDM_BUSINESS, (Object[])new Object[0]), billMutexInfo.getBillNo()));
            }
            if (RequestContext.get().getUserId() != null && RequestContext.get().getUserId().equals(userId + "")) {
                errMsg.append(ResManager.loadKDString((String)"\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u5f3a\u5236\u8e22\u51fa\u53e6\u4e00\u4e2a\u767b\u5f55\u7528\u6237\u3002", (String)"BatchMaintainHelper_3", (String)BD_MPDM_BUSINESS, (Object[])new Object[0]));
            } else {
                errMsg.append(ResManager.loadKDString((String)"\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"BatchMaintainHelper_4", (String)BD_MPDM_BUSINESS, (Object[])new Object[0]));
            }
        } else if (billMutexInfo.isEntryId()) {
            errMsg.append(String.format(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u3010%1$s\u3011\u5206\u5f55\u3010%2$s\u3011\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"BatchMaintainHelper_5", (String)BD_MPDM_BUSINESS, (Object[])new Object[0]), billMutexInfo.getBillNo(), billMutexInfo.getSeq()));
        } else {
            errMsg.append(String.format(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u3010%s\u3011\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"BatchMaintainHelper_6", (String)BD_MPDM_BUSINESS, (Object[])new Object[0]), billMutexInfo.getBillNo()));
        }
        billMutexInfo.setErrMsg(errMsg.toString());
    }

    public static void releasePageMutex(IPageCache cache) {
        String s = cache.get(LOCKED_ID);
        String billLockKey = cache.getPageId();
        if (StringUtils.isNotEmpty((String)s)) {
            List requiredIds = (List)SerializationUtils.deSerializeFromBase64((String)s);
            BatchMaintainHelper.filterNotLastOneHeadLock(requiredIds, billLockKey);
            BatchMaintainHelper.releaseMutexBatch(requiredIds);
            cache.remove(LOCKED_ID);
        }
    }

    public static void releasePartMutex(IPageCache cache, List<BillMutexInfo> partLockedInfo) {
        if (partLockedInfo != null) {
            String billLockKey = cache.getPageId();
            BatchMaintainHelper.filterNotLastOneHeadLock(partLockedInfo, billLockKey);
            BatchMaintainHelper.releaseMutexBatch(partLockedInfo);
            List lockedIds = partLockedInfo.stream().map(BillMutexInfo::getId).collect(Collectors.toList());
            String s = cache.get(LOCKED_ID);
            if (StringUtils.isNotEmpty((String)s)) {
                List requiredIds = (List)SerializationUtils.deSerializeFromBase64((String)s);
                requiredIds.removeIf(o -> lockedIds.contains(o.getId()));
                cache.put(LOCKED_ID, SerializationUtils.serializeToBase64((Object)requiredIds));
            }
        }
    }

    private static void filterNotLastOneHeadLock(List<BillMutexInfo> requiredIds, String billLockKey) {
        if (requiredIds != null) {
            requiredIds.removeIf(mutexInfo -> {
                if (!mutexInfo.isEntryId()) {
                    sessionlessCache.remove(BatchMaintainHelper.buildIntentKey(mutexInfo.getEntityName(), mutexInfo.getId()), billLockKey);
                    Map lockHold = sessionlessCache.getAll(BatchMaintainHelper.buildIntentKey(mutexInfo.getEntityName(), mutexInfo.getId()));
                    if (lockHold != null) {
                        ArrayList<String> del = new ArrayList<String>(4);
                        for (Map.Entry lockEntry : lockHold.entrySet()) {
                            String pageId = (String)lockEntry.getKey();
                            String time = (String)lockEntry.getValue();
                            long diffInMinutes = (System.currentTimeMillis() - Long.parseLong(time)) / 1000L;
                            if (diffInMinutes <= 14400L) continue;
                            sessionlessCache.remove(BatchMaintainHelper.buildIntentKey(mutexInfo.getEntityName(), mutexInfo.getId()), pageId);
                            del.add(pageId);
                        }
                        del.forEach(lockHold::remove);
                    }
                    return lockHold != null && lockHold.size() > 0;
                }
                return false;
            });
        }
    }

    public static void releaseMutexBatch(List<BillMutexInfo> requiredIds) {
        if (requiredIds == null) {
            return;
        }
        ArrayList releaseMutexList = new ArrayList(8);
        requiredIds.forEach(mutexInfo -> {
            HashMap<String, String> releaseParam = new HashMap<String, String>();
            releaseParam.put("dataObjId", mutexInfo.getId());
            releaseParam.put("groupId", mutexInfo.isEntryId() ? ENTRY_GROUP_ID : BILL_GROUP_ID);
            releaseParam.put("entityKey", mutexInfo.getEntityName());
            releaseParam.put("operationKey", OPKEY);
            releaseMutexList.add(releaseParam);
        });
        Map<String, BillMutexInfo> idBillMutex = requiredIds.stream().collect(Collectors.toMap(BillMutexInfo::getId, mutexInfo -> mutexInfo, (exist, replace) -> replace));
        if (releaseMutexList.size() > 0) {
            try (DataMutex dataMutex = DataMutex.create();){
                Map releaseResult = dataMutex.batchRelease(releaseMutexList);
                for (Map.Entry releaseItem : releaseResult.entrySet()) {
                    String objId = (String)releaseItem.getKey();
                    boolean releaseRet = (Boolean)releaseItem.getValue();
                    BillMutexInfo mutex = idBillMutex.get(objId);
                    if (releaseRet) continue;
                    logger.info("batch release mutex [{}]-[{}]-[{}] fail", new Object[]{mutex.getEntityName(), mutex.isEntryId() ? "entryId" : "billId", objId});
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    public static boolean checkLockedForSameUser(String viewPageId, String entityName, String objId, StringBuilder errMsg) {
        boolean locked = false;
        if (!MutexHelper.isOpenIntentLocks()) {
            String pageId = BatchMaintainHelper.generatePage4ListOp(viewPageId, entityName, objId);
            FormShowParameter fs = SessionManager.getCurrent().getFormShowParameter(pageId);
            if (fs != null && fs.getSessionId().equals(RequestContext.get().getGlobalSessionId())) {
                return false;
            }
            try (DataMutex dataMutex = DataMutex.create();){
                long userId;
                Map lockInfo = dataMutex.getLockInfo(objId, BILL_GROUP_ID, entityName);
                if (lockInfo != null && (userId = Long.parseLong((String)lockInfo.get("userid"))) == RequestContext.get().getCurrUserId()) {
                    locked = true;
                    MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_user");
                    Map cacheUserObjs = BusinessDataReader.loadFromCache((Object[])new Object[]{userId}, (DynamicObjectType)dt);
                    DynamicObject userObj = (DynamicObject)cacheUserObjs.get(userId);
                    if (userObj != null) {
                        errMsg.append(userObj.getString("name")).append(" ");
                    }
                    errMsg.append(ResManager.loadKDString((String)"\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"BatchMaintainHelper_7", (String)BD_MPDM_BUSINESS, (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        return locked;
    }

    public static boolean checkLockedByBatchOp(String entityName, String objId, StringBuilder errMsg) {
        boolean locked = false;
        try (DataMutex dataMutex = DataMutex.create();){
            Map lockInfo = dataMutex.getLockInfo(objId, BILL_GROUP_ID, entityName);
            if (lockInfo != null && OPKEY.equals(lockInfo.get(OPKEYNAME))) {
                locked = true;
                long userId = Long.parseLong((String)lockInfo.get("userid"));
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_user");
                Map cacheUserObjs = BusinessDataReader.loadFromCache((Object[])new Object[]{userId}, (DynamicObjectType)dt);
                DynamicObject userObj = (DynamicObject)cacheUserObjs.get(userId);
                if (userObj != null) {
                    errMsg.append(userObj.getString("name")).append(" ");
                }
                errMsg.append(ResManager.loadKDString((String)"\u6b63\u5728\u6279\u91cf\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"BatchMaintainHelper_8", (String)BD_MPDM_BUSINESS, (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return locked;
    }

    public static String buildIntentKey(String entityKey, String dataObjId) {
        RequestContext rc = RequestContext.get();
        StringBuilder intentKey = new StringBuilder();
        intentKey.append("IMUTEX:").append(rc.getAccountId()).append(':').append(entityKey).append("_YX").append(':').append(dataObjId);
        return intentKey.toString();
    }

    private static String generatePage4ListOp(String pageId, String viewBillFormId, Object pkValue) {
        if (pkValue instanceof String) {
            pkValue = pkValue.toString().replace("/", "");
        }
        return pageId + "_" + viewBillFormId + "_" + pkValue;
    }

    public static void updateViewAndReFocus(IFormView view, String entryGridName, int updateRow) {
        AbstractGrid grid = (AbstractGrid)view.getControl(entryGridName);
        int focusRow = grid.getEntryState().getFocusRow();
        view.updateView(entryGridName, updateRow);
        grid.selectRows(focusRow);
    }
}

