/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.helper;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.helper.SystemCallParamHelper;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class CloseDateHelper {
    public static void initBookDate(String entityId, DynamicObject bill, BillEntityType sourceEntity) {
        Date bookDate;
        boolean bookDateBill = CloseDateHelper.isExistField((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityId), "bookdate");
        if (!bookDateBill) {
            return;
        }
        Date bizDate = (Date)bill.get("biztime");
        if (null == bizDate) {
            bizDate = DateUtils.getShortDate((Date)new Date());
        }
        if (SystemCallParamHelper.isEnable("sbs_scmcapplevelparam", "INV0004")) {
            bookDate = bizDate;
        } else {
            Map<String, Object> closeDateMap = CloseDateHelper.getCloseDateMap(entityId, bill, sourceEntity);
            if (null != closeDateMap) {
                Date closeDate = (Date)closeDateMap.get("closeDate");
                Date addDate = DateUtils.getAddDate((Date)closeDate, (int)1);
                bookDate = bizDate != null && addDate != null && bizDate.before(addDate) ? addDate : (null == bizDate ? new Date() : bizDate);
            } else {
                bookDate = null == bizDate ? new Date() : bizDate;
            }
        }
        bill.set("bookdate", (Object)DateUtils.getShortDate((Date)bookDate));
    }

    public static Map<String, Object> getCloseDateMap(String entityName, DynamicObject bill, BillEntityType sourceEntity) {
        Date closeDate;
        HashMap<String, Object> closeDateMap = new HashMap<String, Object>(16);
        String source = "inv";
        Date invCloseDate = CloseDateHelper.getInvCloseDate(entityName, bill);
        Date calCloseDate = CloseDateHelper.getCalCloseDate(sourceEntity, bill);
        if (invCloseDate == null && calCloseDate == null) {
            return null;
        }
        if (invCloseDate != null && calCloseDate != null) {
            if (invCloseDate.after(calCloseDate)) {
                closeDate = invCloseDate;
            } else {
                closeDate = calCloseDate;
                source = "cal";
            }
        } else if (null == invCloseDate) {
            closeDate = calCloseDate;
            source = "cal";
        } else {
            closeDate = invCloseDate;
        }
        closeDateMap.put("closeDate", closeDate);
        closeDateMap.put("key", source);
        return closeDateMap;
    }

    public static Date getInvCloseDate(String entityName, DynamicObject bill) {
        HashMap<Long, Set<Long>> orgWarehouseMap = CloseDateHelper.getAllOrgWarehouseMap(entityName, bill);
        QFilter closeFilter = CloseDateHelper.buildOrgWarehousesFilter(orgWarehouseMap);
        if (closeFilter == null) {
            return null;
        }
        closeFilter.and(new QFilter("isdelete", "<>", (Object)true));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"im_closeaccountrecord", (String)"im_closeaccountrecord", (String)"closedate", (QFilter[])closeFilter.toArray(), (String)"closedate desc").top(1);
        Date closeDate = null;
        for (Row row : dataSet) {
            closeDate = row.getDate("closedate");
        }
        return closeDate;
    }

    public static Date getCalCloseDate(BillEntityType sourceEntity, DynamicObject bill) {
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        Set<Long> ownerIds = CloseDateHelper.getAllOwnerIds(sourceEntity, entrys);
        Map ownerCloseDate = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCloseService", (String)"getOwnerCloseDate", (Object[])new Object[]{ownerIds});
        Map closeDateMap = (Map)ownerCloseDate.get("closeDate");
        Date calCloseDate = null;
        for (Object[] closeDate : closeDateMap.values()) {
            Date singleOwnerCloseDate = (Date)closeDate[0];
            if (calCloseDate == null) {
                calCloseDate = singleOwnerCloseDate;
                continue;
            }
            calCloseDate = calCloseDate.after(singleOwnerCloseDate) ? calCloseDate : singleOwnerCloseDate;
        }
        return calCloseDate;
    }

    private static HashMap<Long, Set<Long>> getAllOrgWarehouseMap(String entityName, DynamicObject bill) {
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        HashMap<Long, Set<Long>> orgWarehouseMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject entry : entrys) {
            DynamicObject warehouseDyc = entry.getDynamicObject("warehouse");
            DynamicObject orgDyc = bill.getDynamicObject("org");
            CloseDateHelper.getAllOrgWarehouse(orgWarehouseMap, orgDyc, warehouseDyc);
            if (!entityName.equals("im_transdirbill")) continue;
            DynamicObject outWarehouseDyc = entry.getDynamicObject("outwarehouse");
            DynamicObject outOrg = bill.getDynamicObject("outorg");
            CloseDateHelper.getAllOrgWarehouse(orgWarehouseMap, outOrg, outWarehouseDyc);
        }
        return orgWarehouseMap;
    }

    private static void getAllOrgWarehouse(HashMap<Long, Set<Long>> orgWarehouseMap, DynamicObject org, DynamicObject warehouse) {
        if (org == null || warehouse == null) {
            return;
        }
        orgWarehouseMap.computeIfAbsent((Long)org.getPkValue(), k -> new HashSet());
        orgWarehouseMap.get(org.getPkValue()).add((Long)warehouse.getPkValue());
    }

    private static QFilter buildOrgWarehousesFilter(Map<Long, Set<Long>> orgWarehouseMap) {
        QFilter orgWarehouseFilters = null;
        for (Map.Entry<Long, Set<Long>> entry : orgWarehouseMap.entrySet()) {
            QFilter orgf = new QFilter("org.id", "=", (Object)entry.getKey());
            QFilter orgWarehousef = new QFilter("warehouse.id", "in", (Object)entry.getValue().toArray());
            orgWarehousef.and(orgf);
            orgWarehouseFilters = orgWarehouseFilters == null ? orgWarehousef : orgWarehouseFilters.or(orgWarehousef);
        }
        return orgWarehouseFilters;
    }

    public static Set<Long> getAllOwnerIds(BillEntityType sourceEntity, DynamicObjectCollection entrys) {
        HashSet<Long> ownerIds = new HashSet<Long>(16);
        for (DynamicObject entry : entrys) {
            boolean existOutOwner;
            boolean existOwner;
            if (entry.get("owner") != null) {
                Object owner = entry.get("owner");
                Long ownerId = ((DynamicObject)owner).getLong("id");
                ownerIds.add(ownerId);
            }
            boolean bl = existOwner = sourceEntity.findProperty("owner") != null;
            if (!existOwner && entry.getLong("owner_id") != 0L) {
                ownerIds.add(entry.getLong("owner_id"));
            }
            if (entry.get("outowner") != null) {
                Object outOwner = entry.get("outowner");
                Long outOwnerId = ((DynamicObject)outOwner).getLong("id");
                ownerIds.add(outOwnerId);
            }
            if ((existOutOwner = sourceEntity.findProperty("outowner") != null) || entry.getLong("outowner_id") == 0L) continue;
            ownerIds.add(entry.getLong("outowner_id"));
        }
        return ownerIds;
    }

    public static boolean isExistField(IDataEntityType entityType, String fieldName) {
        boolean isExist = false;
        IDataEntityProperty dataEntiryProperty = ((EntityType)entityType).findProperty(fieldName);
        if (dataEntiryProperty != null) {
            isExist = true;
        }
        return isExist;
    }
}

