/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bd.mpdm.business.helper.MaterialInvInfoHelper;
import kd.bd.mpdm.common.mftorder.utils.CreateStockUtils;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialPlanQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bd.mpdm.common.query.helper.WarehouseQueryHelper;
import kd.bd.mpdm.common.utils.DyObjUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;

public class ManufstockPropertyChangeUtils {
    private static final String ISIGNORECHANGEMFTSTOCK = "isIgnoreChangeMftstock";
    private static final String ENTRYENTITY = "entryentity";
    private static final BigDecimal ONEHUNDRED = new BigDecimal("100");

    public static void changeSupplymode(IFormView view, IDataModel model, Object newObj, Object oldValue, int currentSelectIndex) {
        if (StringUtils.isBlank((Object)newObj)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8d27\u4e3b\u7c7b\u578b\u4e0d\u5141\u8bb8\u6e05\u7a7a\u3002", (String)"ManufstockPropertyChangeUtils_0", (String)"bd-mpdm-business", (Object[])new Object[0]));
            model.setValue("supplymode", oldValue, currentSelectIndex);
            ManufstockPropertyChangeUtils.setSupplyorgfield("mustinput", currentSelectIndex, model, view);
        } else if (!StringUtils.isBlank((Object)oldValue)) {
            ManufstockPropertyChangeUtils.setSupplyorgfield("", currentSelectIndex, model, view);
        }
    }

    public static void setbackflush(Object newObj, int currentIndex, IDataModel model, IFormView view, boolean isShow) {
        if (currentIndex == -1) {
            return;
        }
        if ("B".equals(newObj)) {
            DynamicObject trandym = (DynamicObject)model.getValue("transactiontypeid", currentIndex);
            String backflushtime = trandym.getString("backflushtime");
            if ("".equals(backflushtime)) {
                backflushtime = "A";
            }
            model.setValue("backflushtime", (Object)backflushtime, currentIndex);
            if (isShow) {
                if ("mpdm_transactout".equals(trandym.getDynamicObjectType().getName())) {
                    view.setEnable(Boolean.FALSE, currentIndex, new String[]{"backflushtime"});
                } else {
                    view.setEnable(Boolean.TRUE, currentIndex, new String[]{"backflushtime"});
                }
            }
        } else {
            model.setValue("backflushtime", (Object)" ", currentIndex);
            if (isShow) {
                view.setEnable(Boolean.FALSE, currentIndex, new String[]{"backflushtime"});
            }
        }
    }

    public static void changeMaterial(Object newObj, int currentSelectIndex, int changeIndex, IDataModel model, IFormView view, IPageCache pageCache) {
        ManufstockPropertyChangeUtils.change4material(newObj, "materialunitid", true, changeIndex, currentSelectIndex, model);
        ManufstockPropertyChangeUtils.change4material(newObj, changeIndex, currentSelectIndex, model);
        ManufstockPropertyChangeUtils.setDefault(changeIndex, currentSelectIndex, newObj, model, view, pageCache);
        ManufstockPropertyChangeUtils.setAuxpropLock(newObj, changeIndex, currentSelectIndex, model, view);
        pageCache.put(ISIGNORECHANGEMFTSTOCK, "true");
        ManufstockPropertyChangeUtils.change4qtyRes("qtynumerator", (BigDecimal)model.getValue("qtynumerator", changeIndex), model, changeIndex, currentSelectIndex, view);
    }

    private static void change4material(Object newObj, String destObject, boolean isEntry, int changeIndex, int currentSelectIndex, IDataModel model) {
        if (newObj == null) {
            if (isEntry) {
                model.setValue(destObject, null, changeIndex);
                model.setValue("batchno", null, changeIndex);
                model.setValue("lot", null, changeIndex);
            }
        } else {
            DynamicObject mateMft = (DynamicObject)newObj;
            DynamicObject material = mateMft.getDynamicObject("masterid");
            DynamicObject baseunit = (material = MaterialQueryHelper.getDataCacheByID((Object)material.getPkValue())).getDynamicObject("baseunit");
            if (baseunit != null && isEntry) {
                model.setValue(destObject, null, changeIndex);
                model.setValue(destObject, (Object)baseunit, changeIndex);
            }
        }
    }

    private static void change4material(Object newObj, int changeIndex, int currentSelectIndex, IDataModel model) {
        model.setValue("entryconfiguredcode", null, changeIndex);
        if (newObj == null) {
            model.setValue("isbackflush", (Object)"A", changeIndex);
            model.setValue("iskeypart", (Object)Boolean.FALSE, changeIndex);
            model.setValue("considerminbatch", (Object)Boolean.FALSE, changeIndex);
            model.setValue("overissuecontrl", (Object)"B", changeIndex);
            model.setValue("issinhighlimit", (Object)BigDecimal.ZERO, changeIndex);
            model.setValue("extraratioqty", (Object)BigDecimal.ZERO, changeIndex);
            model.setValue("issinlowlimit", (Object)BigDecimal.ZERO, changeIndex);
            model.setValue("lackraitioqty", (Object)BigDecimal.ZERO, changeIndex);
        } else {
            String changetype = "A";
            if (StringUtils.equals((CharSequence)changetype, (CharSequence)"A")) {
                String isquotacontrol;
                DynamicObject mtfmaterial = (DynamicObject)newObj;
                model.setValue("isbackflush", mtfmaterial.get("isbackflush"), changeIndex);
                model.setValue("iskeypart", mtfmaterial.get("iskeypart"), changeIndex);
                model.setValue("considerminbatch", mtfmaterial.get("considerminbatch"), changeIndex);
                BigDecimal issinhighlimit = mtfmaterial.get("issinhighlimit") == null ? BigDecimal.ZERO : mtfmaterial.getBigDecimal("issinhighlimit");
                model.setValue("issinhighlimit", (Object)issinhighlimit, changeIndex);
                BigDecimal demandQty = (BigDecimal)model.getValue("demandqty", changeIndex);
                BigDecimal extraratioqty = demandQty.multiply(BigDecimal.ONE.add(issinhighlimit.divide(BigDecimal.valueOf(100L), 4, 4)));
                model.setValue("extraratioqty", (Object)extraratioqty, changeIndex);
                BigDecimal issinlowlimit = mtfmaterial.get("issinlowlimit") == null ? BigDecimal.ZERO : mtfmaterial.getBigDecimal("issinlowlimit");
                model.setValue("issinlowlimit", (Object)issinlowlimit, changeIndex);
                BigDecimal lackraitioqty = demandQty.multiply(BigDecimal.ONE.subtract(issinlowlimit.divide(BigDecimal.valueOf(100L), 4, 4)));
                model.setValue("lackraitioqty", (Object)lackraitioqty, changeIndex);
                String string = isquotacontrol = mtfmaterial.get("isquotacontrol") == null ? "" : mtfmaterial.getString("isquotacontrol");
                if (StringUtils.equals((CharSequence)isquotacontrol, (CharSequence)"true")) {
                    model.setValue("overissuecontrl", (Object)"B", changeIndex);
                } else {
                    model.setValue("overissuecontrl", (Object)"A", changeIndex);
                }
            }
        }
    }

    private static void setDefault(int changeIndex, int currentSelectIndex, Object newObj, IDataModel model, IFormView view, IPageCache pageCache) {
        if (newObj != null) {
            DynamicObject material = (DynamicObject)newObj;
            DynamicObject materialinfo = MaterialMftQueryHelper.getDataCacheByID((Object)material.getPkValue());
            DynamicObject masterid = materialinfo.getDynamicObject("masterid");
            model.setValue("materielmasterid", (Object)masterid, changeIndex);
            QFilter filter = new QFilter("masterid", "=", masterid.getPkValue());
            filter.and(new QFilter("status", "=", (Object)"C"));
            filter.and(new QFilter("enable", "=", (Object)"1"));
            DynamicObject mtfOrg = (DynamicObject)model.getValue("org");
            if (mtfOrg == null) {
                return;
            }
            DynamicObject loadSingle = MaterialPlanQueryHelper.getDataCacheByMaterialID((Long)masterid.getLong("id"), (Long)mtfOrg.getLong("id"), null);
            String wastagerateformula = "B";
            DynamicObject tran = (DynamicObject)model.getValue("transactiontypeid", changeIndex);
            boolean s = false;
            if (tran != null) {
                s = tran.getBoolean("isconsiderloss");
            }
            if (loadSingle != null) {
                wastagerateformula = loadSingle.getString("wastagerateformula");
            } else if (!s) {
                wastagerateformula = "";
            }
            model.setValue("wastagerateformula", (Object)wastagerateformula, changeIndex);
            pageCache.put(ISIGNORECHANGEMFTSTOCK, "true");
            model.setValue("isbulkmaterial", materialinfo.get("isbulkmaterial"), changeIndex);
            model.setValue("isstockallot", materialinfo.get("isstockallot"), changeIndex);
            String modestring = MPDMMftGenStocksUtils.getIssuemode((Object)materialinfo.get("issuemode"));
            model.setValue("issuemode", (Object)modestring, changeIndex);
            model.setValue("batchno", null, changeIndex);
            model.setValue("lot", null, changeIndex);
            model.setValue("isbackflush", materialinfo.get("isbackflush"), changeIndex);
            String entityName = model.getDataEntityType().getName();
            DynamicObject orderEntry = (DynamicObject)model.getValue("orderentryid", changeIndex);
            DynamicObject org = (DynamicObject)model.getValue("org", changeIndex);
            DynamicObject stockEntry = model.getEntryRowEntity(ENTRYENTITY, changeIndex);
            CreateStockUtils.getStockWareHouse((DynamicObject)stockEntry, (DynamicObject)orderEntry, (DynamicObject)org, (String)entityName);
            model.setValue("supplyorgid", stockEntry.get("supplyorgid"), changeIndex);
            model.setValue("warehouseid", stockEntry.get("warehouseid"), changeIndex);
            model.setValue("location", stockEntry.get("location"), changeIndex);
            model.setValue("outorgunitid", stockEntry.get("outorgunitid"), changeIndex);
            model.setValue("outwarehouseid", stockEntry.get("outwarehouseid"), changeIndex);
            model.setValue("outlocation", stockEntry.get("outlocation"), changeIndex);
            ManufstockPropertyChangeUtils.setMaterialInvInfo(changeIndex, model);
            DynamicObject product = (DynamicObject)model.getValue("productid", changeIndex);
            model.setValue("rework", (Object)"false", changeIndex);
            if (material != null && product != null && material.getPkValue().equals(product.getPkValue())) {
                model.setValue("rework", (Object)"true", changeIndex);
            }
            ManufstockPropertyChangeUtils.setbackflush(materialinfo.get("isbackflush"), changeIndex, model, view, true);
            ManufstockPropertyChangeUtils.setSupplyorgfield("", changeIndex, model, view);
            if (changeIndex == currentSelectIndex) {
                pageCache.put(ISIGNORECHANGEMFTSTOCK, "true");
                ManufstockPropertyChangeUtils.lockLocationField(model.getValue("warehouseid", changeIndex), changeIndex, model, view);
                ManufstockPropertyChangeUtils.lockOutLocationField(model.getValue("outwarehouseid", changeIndex), changeIndex, model, view);
            }
        }
    }

    private static void setAuxpropLock(Object materialMft, int changeIndex, int currentSelectIndex, IDataModel model, IFormView view) {
        if (ManufstockPropertyChangeUtils.isJumpLevel(changeIndex, model)) {
            return;
        }
        Boolean isbomextend = (Boolean)model.getValue("isbomextend", changeIndex);
        if (changeIndex == currentSelectIndex) {
            if (materialMft != null && !isbomextend.booleanValue()) {
                DynamicObject mateMft = (DynamicObject)materialMft;
                DynamicObject material = mateMft.getDynamicObject("masterid");
                material = MaterialQueryHelper.getDataCacheByID((Object)material.getPkValue());
                view.setEnable(Boolean.TRUE, currentSelectIndex, new String[]{"isstockallot"});
                if (material != null) {
                    boolean isuseauxpty = material.getBoolean("isuseauxpty");
                    if (isuseauxpty) {
                        view.setEnable(Boolean.TRUE, currentSelectIndex, new String[]{"childauxpropertyid"});
                    } else {
                        view.setEnable(Boolean.FALSE, currentSelectIndex, new String[]{"childauxpropertyid"});
                    }
                }
            } else {
                view.setEnable(Boolean.FALSE, currentSelectIndex, new String[]{"childauxpropertyid"});
                if (!StringUtils.equals((CharSequence)"om_mftstock", (CharSequence)model.getDataEntityType().getName())) {
                    view.setEnable(Boolean.FALSE, currentSelectIndex, new String[]{"isstockallot"});
                }
            }
            BigDecimal canqty = (BigDecimal)model.getValue("cansendqty", changeIndex);
            if (canqty.compareTo(BigDecimal.ZERO) < 0) {
                model.setValue("cansendqty", (Object)0, currentSelectIndex);
            }
        }
        ManufstockPropertyChangeUtils.isstockallotChange(changeIndex, currentSelectIndex, model, view);
        ManufstockPropertyChangeUtils.lockLimitQty(changeIndex, currentSelectIndex, model, view);
    }

    private static void change4qtyRes(String field, BigDecimal newDecimal, IDataModel model, int changeIndex, int currentSelectIndex, IFormView view) {
        BigDecimal demandQty;
        BigDecimal standqty;
        BigDecimal standQty;
        DynamicObject unit = (DynamicObject)model.getValue("materialunitid", changeIndex);
        if (unit == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55\u57fa\u672c\u5355\u4f4d\u4e3a\u7a7a\u3002", (String)"ManufstockPropertyChangeUtils_1", (String)"bd-mpdm-business", (Object[])new Object[0]));
            model.setValue(field, null, changeIndex);
            return;
        }
        String qtyType = (String)model.getValue("qtytype", changeIndex);
        if (StringUtils.isEmpty((CharSequence)qtyType)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7528\u91cf\u7c7b\u578b\u3002", (String)"ManufstockPropertyChangeUtils_2", (String)"bd-mpdm-business", (Object[])new Object[0]));
            model.setValue(field, null, changeIndex);
            return;
        }
        if (StringUtils.equals((CharSequence)field, (CharSequence)"useratio")) {
            standQty = ManufstockPropertyChangeUtils.getStandQty(unit, newDecimal, "useratio", model, changeIndex);
            model.setValue("standqty", (Object)standQty, changeIndex);
            model.setValue("demandqty", (Object)ManufstockPropertyChangeUtils.getDemandQty(standQty, unit, null, null, model, changeIndex), changeIndex);
        } else if (StringUtils.equals((CharSequence)field, (CharSequence)"qtynumerator")) {
            standQty = ManufstockPropertyChangeUtils.getStandQty(unit, newDecimal, "qtynumerator", model, changeIndex);
            model.setValue("standqty", (Object)standQty, changeIndex);
            model.setValue("demandqty", (Object)ManufstockPropertyChangeUtils.getDemandQty(standQty, unit, null, null, model, changeIndex), changeIndex);
        } else if (StringUtils.equals((CharSequence)field, (CharSequence)"qtydenominator")) {
            standQty = ManufstockPropertyChangeUtils.getStandQty(unit, newDecimal, "qtydenominator", model, changeIndex);
            model.setValue("standqty", (Object)standQty, changeIndex);
            model.setValue("demandqty", (Object)ManufstockPropertyChangeUtils.getDemandQty(standQty, unit, null, null, model, changeIndex), changeIndex);
        } else if (StringUtils.equals((CharSequence)field, (CharSequence)"fixscrap")) {
            standqty = (BigDecimal)model.getValue("standqty", changeIndex);
            demandQty = ManufstockPropertyChangeUtils.getDemandQty(standqty, unit, newDecimal, "fixscrap", model, changeIndex);
            model.setValue("demandqty", (Object)demandQty, changeIndex);
        } else if (StringUtils.equals((CharSequence)field, (CharSequence)"scraprate")) {
            standqty = (BigDecimal)model.getValue("standqty", changeIndex);
            demandQty = ManufstockPropertyChangeUtils.getDemandQty(standqty, unit, newDecimal, "scraprate", model, changeIndex);
            model.setValue("demandqty", (Object)demandQty, changeIndex);
        } else if (StringUtils.equals((CharSequence)field, (CharSequence)"wastagerateformula")) {
            standqty = (BigDecimal)model.getValue("standqty", changeIndex);
            demandQty = ManufstockPropertyChangeUtils.getDemandQty(standqty, unit, null, null, model, changeIndex);
            model.setValue("demandqty", (Object)demandQty, changeIndex);
        }
        boolean isShow = false;
        if (changeIndex == currentSelectIndex) {
            isShow = true;
        }
        ManufstockPropertyChangeUtils.calHighQty(changeIndex, model, view, isShow);
        ManufstockPropertyChangeUtils.calLowQty(changeIndex, model, view, isShow);
        ManufstockPropertyChangeUtils.changeActissueQty(changeIndex, model, isShow);
        ManufstockPropertyChangeUtils.aculUnSendQty(changeIndex, model, isShow);
        ManufstockPropertyChangeUtils.aculCanSendQty(changeIndex, model, isShow);
        DynamicObject stockEntry = model.getEntryRowEntity(ENTRYENTITY, changeIndex);
        if (stockEntry == null) {
            return;
        }
        DynamicObject orderEntry = (DynamicObject)model.getValue("orderentryid", changeIndex);
        String ordername = "pom_mftorder";
        if (orderEntry == null) {
            return;
        }
        DynamicObject transactiontype = (DynamicObject)model.getValue("transactiontypeid", changeIndex);
        model.setValue("unissueqty", MPDMMftGenStocksUtils.aculUnSendQty((DynamicObject)stockEntry), changeIndex);
        stockEntry.set("useqty", (Object)MPDMMftGenStocksUtils.aculUseQty((DynamicObject)stockEntry, (Object)orderEntry.getPkValue(), (DynamicObject)transactiontype, (String)ordername));
        model.setValue("useqty", stockEntry.get("useqty"), changeIndex);
        stockEntry.set("wipqty", (Object)MPDMMftGenStocksUtils.aculWIPQty((DynamicObject)stockEntry));
        model.setValue("wipqty", stockEntry.get("wipqty"), changeIndex);
    }

    public static BigDecimal getStandQty(DynamicObject unit, BigDecimal mm, String field, IDataModel model, int currentRow) {
        BigDecimal qtydenominator;
        BigDecimal qtynumerator;
        String qtyType = (String)model.getValue("qtytype", currentRow);
        BigDecimal useratio = ((BigDecimal)model.getValue("useratio", currentRow)).divide(ONEHUNDRED, 4, 4);
        BigDecimal orderQty = (BigDecimal)model.getValue("baseqty", currentRow);
        if (StringUtils.equals((CharSequence)"qtynumerator", (CharSequence)field)) {
            qtynumerator = mm;
            qtydenominator = (BigDecimal)model.getValue("qtydenominator", currentRow);
        } else if (StringUtils.equals((CharSequence)"qtydenominator", (CharSequence)field)) {
            qtynumerator = (BigDecimal)model.getValue("qtynumerator", currentRow);
            qtydenominator = mm;
        } else {
            qtynumerator = (BigDecimal)model.getValue("qtynumerator", currentRow);
            qtydenominator = (BigDecimal)model.getValue("qtydenominator", currentRow);
        }
        return ManufstockPropertyChangeUtils.calculateStandQty(unit, qtyType, useratio, orderQty, qtynumerator, qtydenominator);
    }

    private static BigDecimal calculateStandQty(DynamicObject unit, String qtyType, BigDecimal useratio, BigDecimal orderQty, BigDecimal qtynumerator, BigDecimal qtydenominator) {
        BigDecimal standQty = BigDecimal.ZERO;
        if (qtydenominator.compareTo(BigDecimal.ZERO) == 0) {
            throw new KDBizException(new ErrorCode("stock", ResManager.loadKDString((String)"\u5206\u6bcd\u4e0d\u80fd\u4e3a\u96f6\u3002", (String)"ManufstockPropertyChangeUtils_3", (String)"bd-mpdm-business", (Object[])new Object[0])), new Object[0]);
        }
        if (StringUtils.equals((CharSequence)qtyType, (CharSequence)"A") || StringUtils.equals((CharSequence)qtyType, (CharSequence)"C")) {
            standQty = orderQty.multiply(useratio).multiply(qtynumerator).divide(qtydenominator, ManufstockPropertyChangeUtils.getPrecision(unit), ManufstockPropertyChangeUtils.getRoundType(unit));
        } else if (StringUtils.equals((CharSequence)qtyType, (CharSequence)"B")) {
            standQty = useratio.multiply(qtynumerator).divide(qtydenominator, ManufstockPropertyChangeUtils.getPrecision(unit), ManufstockPropertyChangeUtils.getRoundType(unit));
        }
        return standQty;
    }

    public static void calHighQty(int index, IDataModel model, IFormView view, boolean isShow) {
        BigDecimal demandQty = (BigDecimal)model.getValue("demandqty", index);
        BigDecimal highlimit = (BigDecimal)model.getValue("issinhighlimit", index);
        DynamicObject mtfmaterial = (DynamicObject)model.getValue("materialid", index);
        if (mtfmaterial == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7ec4\u4ef6\u3002", (String)"ManufstockPropertyChangeUtils_4", (String)"bd-mpdm-business", (Object[])new Object[0]));
            return;
        }
        BigDecimal extraratioqty = demandQty.multiply(BigDecimal.ONE.add(highlimit.divide(ONEHUNDRED, 4, 4)));
        model.setValue("extraratioqty", (Object)extraratioqty, index);
    }

    public static void calLowQty(int index, IDataModel model, IFormView view, boolean isShow) {
        BigDecimal demandQty = (BigDecimal)model.getValue("demandqty", index);
        BigDecimal highlimit = (BigDecimal)model.getValue("issinlowlimit", index);
        DynamicObject mtfmaterial = (DynamicObject)model.getValue("materialid", index);
        if (mtfmaterial == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7ec4\u4ef6\u3002", (String)"ManufstockPropertyChangeUtils_4", (String)"bd-mpdm-business", (Object[])new Object[0]));
            return;
        }
        BigDecimal extraratioqty = demandQty.multiply(BigDecimal.ONE.subtract(highlimit.divide(ONEHUNDRED, 4, 4)));
        model.setValue("lackraitioqty", (Object)extraratioqty, index);
    }

    public static void aculUnSendQty(int currentIndex, IDataModel model, boolean isShow) {
        Object unsendQty = MPDMMftGenStocksUtils.aculUnSendQty((DynamicObject)model.getEntryRowEntity(ENTRYENTITY, currentIndex));
        model.setValue("unissueqty", unsendQty, currentIndex);
    }

    public static void aculCanSendQty(int currentIndex, IDataModel model, boolean isShow) {
        Object cansendQty = MPDMMftGenStocksUtils.aculCanSendQty((DynamicObject)model.getEntryRowEntity(ENTRYENTITY, currentIndex));
        model.setValue("cansendqty", cansendQty, currentIndex);
    }

    private static void changeActissueQty(int currentIndex, IDataModel model, boolean isShow) {
        DynamicObject stockEntry = model.getEntryRowEntity(ENTRYENTITY, currentIndex);
        BigDecimal actissueQty = stockEntry.getBigDecimal("actissueqty");
        if (stockEntry.getBoolean("iscannegative")) {
            actissueQty = (BigDecimal)MPDMMftGenStocksUtils.aculActissueQty((DynamicObject)stockEntry);
        }
        model.setValue("actissueqty", (Object)actissueQty, currentIndex);
    }

    private static BigDecimal getDemandQty(BigDecimal standqty, DynamicObject unit, BigDecimal mm, String field, IDataModel model, int currentRow) {
        BigDecimal scraprate;
        BigDecimal fixscrap;
        String wastagerateformula = (String)model.getValue("wastagerateformula", currentRow);
        if (StringUtils.equals((CharSequence)"fixscrap", (CharSequence)field)) {
            fixscrap = mm;
            scraprate = (BigDecimal)model.getValue("scraprate", currentRow);
        } else if (StringUtils.equals((CharSequence)"scraprate", (CharSequence)field)) {
            scraprate = mm;
            fixscrap = (BigDecimal)model.getValue("fixscrap", currentRow);
        } else {
            fixscrap = (BigDecimal)model.getValue("fixscrap", currentRow);
            scraprate = (BigDecimal)model.getValue("scraprate", currentRow);
        }
        DynamicObject transactiontype = (DynamicObject)model.getValue("transactiontypeid", currentRow);
        if (transactiontype == null) {
            return BigDecimal.ZERO;
        }
        boolean isconsiderloss = transactiontype.getBoolean("isconsiderloss");
        return ManufstockPropertyChangeUtils.calculateDemadQty(unit, isconsiderloss, standqty, scraprate, fixscrap, wastagerateformula);
    }

    private static BigDecimal calculateDemadQty(DynamicObject unit, boolean isconsiderloss, BigDecimal standqty, BigDecimal scraprate, BigDecimal fixscrap, String wastagerateformula) {
        BigDecimal demandQty = isconsiderloss ? ("A".equals(wastagerateformula) && scraprate.compareTo(BigDecimal.ONE) != 0 ? standqty.divide(BigDecimal.ONE.subtract(scraprate), ManufstockPropertyChangeUtils.getPrecision(unit), ManufstockPropertyChangeUtils.getRoundType(unit)).add(fixscrap) : ("B".equals(wastagerateformula) ? standqty.multiply(BigDecimal.ONE.add(scraprate)).add(fixscrap) : standqty)) : standqty;
        if (standqty.compareTo(BigDecimal.ZERO) == 0) {
            demandQty = BigDecimal.ZERO;
        }
        demandQty = demandQty.setScale(ManufstockPropertyChangeUtils.getPrecision(unit), ManufstockPropertyChangeUtils.getRoundType(unit));
        return demandQty;
    }

    private static int getRoundType(DynamicObject unit) {
        if (unit == null) {
            return 4;
        }
        String precisionAccount = unit.getString("precisionaccount");
        int roundType = 0;
        switch (precisionAccount) {
            case "1": {
                roundType = 4;
                break;
            }
            case "2": {
                roundType = 1;
                break;
            }
            case "3": {
                roundType = 0;
                break;
            }
        }
        return roundType;
    }

    private static int getPrecision(DynamicObject entryunit) {
        if (entryunit == null) {
            return 2;
        }
        return entryunit.get("precision") == null ? 2 : entryunit.getInt("precision");
    }

    public static void isstockallotChange(int changeIndex, int currentSelectIndex, IDataModel model, IFormView view) {
        Boolean isstockallot = (Boolean)model.getValue("isstockallot", changeIndex);
        Boolean isbomextend = (Boolean)model.getValue("isbomextend", changeIndex);
        if (changeIndex == currentSelectIndex) {
            if (isstockallot.booleanValue()) {
                view.setEnable(Boolean.TRUE, changeIndex, new String[]{"outorgunitid"});
                view.setEnable(Boolean.TRUE, changeIndex, new String[]{"outwarehouseid"});
            } else {
                view.setEnable(Boolean.FALSE, changeIndex, new String[]{"outorgunitid"});
                view.setEnable(Boolean.FALSE, changeIndex, new String[]{"outwarehouseid"});
                view.setEnable(Boolean.FALSE, changeIndex, new String[]{"outlocation"});
            }
        }
        if (ObjectUtils.isEmpty((Object)isstockallot) || ObjectUtils.isEmpty((Object)isbomextend)) {
            return;
        }
        if (!isbomextend.booleanValue() && !isstockallot.booleanValue()) {
            model.setValue("outorgunitid", null, changeIndex);
            model.setValue("outwarehouseid", null, changeIndex);
            model.setValue("outlocation", null, changeIndex);
        }
    }

    private static void lockLimitQty(int changeIndex, int currentSelectIndex, IDataModel model, IFormView view) {
        if (((Boolean)model.getValue("iscannegative", changeIndex)).booleanValue()) {
            model.setValue("issuemode", (Object)"C", changeIndex);
            model.setValue("isbackflush", (Object)"A", changeIndex);
            if (changeIndex == currentSelectIndex) {
                view.setEnable(Boolean.FALSE, changeIndex, new String[]{"overissuecontrl"});
                view.setEnable(Boolean.FALSE, changeIndex, new String[]{"issuemode"});
                view.setEnable(Boolean.FALSE, changeIndex, new String[]{"isbackflush"});
            }
        } else if (changeIndex == currentSelectIndex) {
            view.setEnable(Boolean.TRUE, changeIndex, new String[]{"overissuecontrl"});
            view.setEnable(Boolean.TRUE, changeIndex, new String[]{"issuemode"});
            view.setEnable(Boolean.TRUE, changeIndex, new String[]{"isbackflush"});
        }
    }

    public static void setSupplyorgfield(String string, int currentSelectIndex, IDataModel model, IFormView view) {
        String supplyfield = (String)model.getValue("supplymode", currentSelectIndex);
        DynamicObject sypplyorgfield = (DynamicObject)model.getValue("supplyorgid", currentSelectIndex);
        if ("bos_org".equals(supplyfield) && !"mustinput".equals(string) && sypplyorgfield != null) {
            ArrayList<Object> array = new ArrayList<Object>();
            Long orgId = (Long)sypplyorgfield.getPkValue();
            List ownerArray = MPDMMftGenStocksUtils.getOwners((Long)orgId);
            array.addAll(ownerArray);
            if (((Boolean)sypplyorgfield.get("fisaccounting")).booleanValue()) {
                array.add(sypplyorgfield.getPkValue());
            }
            if (!array.isEmpty()) {
                model.setValue("supplierid", array.get(0), currentSelectIndex);
            } else {
                model.setValue("supplierid", null, currentSelectIndex);
            }
        }
    }

    public static int getSelectEntryRowIndex(IFormView view) {
        int currentEntryIndex = -1;
        EntryGrid entryGrid = (EntryGrid)view.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            currentEntryIndex = selectRows[0];
        }
        return currentEntryIndex;
    }

    private static void setMaterialInvInfo(int changeIndex, IDataModel model) {
        DynamicObject mtfOrg = (DynamicObject)model.getValue("supplyorgid", changeIndex);
        DynamicObject materialMft = (DynamicObject)model.getValue("materialid", changeIndex);
        if (materialMft != null) {
            model.setValue("materielinv", (Object)MaterialInvInfoHelper.getMaterialInvInfo(mtfOrg, materialMft.getDynamicObject("masterid")), changeIndex);
        }
    }

    private static void lockLocationField(Object newObj, int changeIndex, IDataModel model, IFormView view) {
        Long dyObjId = DyObjUtils.getDyObjId((Object)newObj);
        if (!DyObjUtils.isEmptyId((Long)dyObjId)) {
            long warehouseId = dyObjId;
            DynamicObject warehouse = WarehouseQueryHelper.getDataCacheByID((Object)warehouseId);
            boolean isopenlocation = warehouse.getBoolean("isopenlocation");
            if (isopenlocation && !ManufstockPropertyChangeUtils.isJumpLevel(changeIndex, model)) {
                view.setEnable(Boolean.TRUE, changeIndex, new String[]{"location"});
            } else {
                view.setEnable(Boolean.FALSE, changeIndex, new String[]{"location"});
            }
        } else {
            view.setEnable(Boolean.FALSE, changeIndex, new String[]{"location"});
        }
    }

    private static void lockOutLocationField(Object newObj, int changeIndex, IDataModel model, IFormView view) {
        if (newObj != null) {
            long warehouseId = (Long)((DynamicObject)newObj).getPkValue();
            DynamicObject warehouse = WarehouseQueryHelper.getDataCacheByID((Object)warehouseId);
            boolean isopenlocation = warehouse.getBoolean("isopenlocation");
            if (isopenlocation && !ManufstockPropertyChangeUtils.isJumpLevel(changeIndex, model)) {
                view.setEnable(Boolean.TRUE, changeIndex, new String[]{"outlocation"});
            } else {
                view.setEnable(Boolean.FALSE, changeIndex, new String[]{"outlocation"});
            }
        } else {
            view.setEnable(Boolean.FALSE, changeIndex, new String[]{"outlocation"});
        }
    }

    public static boolean isJumpLevel(int rowIndex, IDataModel model) {
        if (rowIndex == -1) {
            return false;
        }
        return (Boolean)model.getValue("isjumplevel", rowIndex);
    }

    public static void changeSupplyOrg(IDataModel model, int changeIndex) {
        ManufstockPropertyChangeUtils.setMaterialInvInfo(changeIndex, model);
        model.setValue("batchno", null, changeIndex);
        model.setValue("lot", null, changeIndex);
    }

    public static void changeOutOrgunit(int changeIndex, int currentSelectIndex, IDataModel model, IFormView view) {
        Boolean isstock = (Boolean)model.getValue("isstockallot", currentSelectIndex);
        if (!isstock.booleanValue()) {
            view.setEnable(Boolean.FALSE, currentSelectIndex, new String[]{"outwarehouseid"});
        } else {
            view.setEnable(Boolean.TRUE, currentSelectIndex, new String[]{"outwarehouseid"});
        }
        model.setValue("outwarehouseid", null, currentSelectIndex);
        model.setValue("outlocation", null, currentSelectIndex);
        view.setEnable(Boolean.FALSE, currentSelectIndex, new String[]{"outlocation"});
    }

    public static void changeUseratio(int changeIndex, int currentSelectIndex, IDataModel model, IFormView view, IPageCache pageCache) {
        DynamicObject firstDym = (DynamicObject)model.getValue("replaceplan", changeIndex);
        Long targetBillId = (Long)model.getValue("targetbillid", changeIndex);
        if (firstDym == null) {
            return;
        }
        String pId = model.getValue("pid", changeIndex).toString();
        int priority = (Integer)model.getValue("priority", changeIndex);
        DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRYENTITY);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject replacePlan = entry.getDynamicObject("replaceplan");
            if (replacePlan == null || changeIndex == i || entry.getLong("targetbillid") != targetBillId.longValue() || !replacePlan.getPkValue().equals(firstDym.getPkValue()) || !pId.equals(entry.getString("pid")) || priority != entry.getInt("priority")) continue;
            model.setValue("useratio", model.getValue("useratio", changeIndex), i);
            pageCache.put(ISIGNORECHANGEMFTSTOCK, "true");
            ManufstockPropertyChangeUtils.change4qtyRes("useratio", BigDecimal.ONE, model, i, currentSelectIndex, view);
            pageCache.put(ISIGNORECHANGEMFTSTOCK, "false");
        }
        ManufstockPropertyChangeUtils.changeParentUseratio(changeIndex, currentSelectIndex, model, view, pageCache);
    }

    private static void changeParentUseratio(int changeIndex, int currentSelectIndex, IDataModel model, IFormView view, IPageCache pageCache) {
        DynamicObject firstDym = (DynamicObject)model.getValue("replaceplan", changeIndex);
        Long targetBillId = (Long)model.getValue("targetbillid", changeIndex);
        if (firstDym == null) {
            return;
        }
        String pId = model.getValue("pid", changeIndex).toString();
        DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRYENTITY);
        if (pId.equals("0")) {
            return;
        }
        BigDecimal childUseratio = BigDecimal.ZERO;
        int parentIndex = -1;
        ArrayList<Integer> childList = new ArrayList<Integer>();
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject replacePlan = entry.getDynamicObject("replaceplan");
            if (replacePlan == null || entry.getLong("targetbillid") != targetBillId.longValue()) continue;
            if (entry.getPkValue().toString().equals(pId)) {
                parentIndex = i;
            }
            if (!replacePlan.getPkValue().equals(firstDym.getPkValue()) || !pId.equals(entry.getString("pid"))) continue;
            boolean isUsed = false;
            Integer childPriority = entry.getInt("priority");
            for (int j = 0; j < childList.size(); ++j) {
                if (!childPriority.equals(childList.get(j))) continue;
                isUsed = true;
            }
            if (isUsed) continue;
            childUseratio = childUseratio.add(entry.getBigDecimal("useratio"));
            childList.add(childPriority);
        }
        if (parentIndex == -1) {
            return;
        }
        if (childUseratio.compareTo(new BigDecimal(100)) <= 0) {
            model.setValue("useratio", (Object)new BigDecimal(100).subtract(childUseratio), parentIndex);
            pageCache.put(ISIGNORECHANGEMFTSTOCK, "true");
            ManufstockPropertyChangeUtils.change4qtyRes("useratio", BigDecimal.ONE, model, parentIndex, changeIndex, view);
            ManufstockPropertyChangeUtils.changeParentUseratioByChild(parentIndex, new BigDecimal(100).subtract(childUseratio), model, view, pageCache);
        } else {
            model.setValue("useratio", (Object)0, parentIndex);
            pageCache.put(ISIGNORECHANGEMFTSTOCK, "true");
            ManufstockPropertyChangeUtils.change4qtyRes("useratio", BigDecimal.ONE, model, parentIndex, changeIndex, view);
            ManufstockPropertyChangeUtils.changeParentUseratioByChild(parentIndex, BigDecimal.ONE, model, view, pageCache);
        }
        pageCache.put(ISIGNORECHANGEMFTSTOCK, "false");
    }

    private static void changeParentUseratioByChild(int currentIndex, BigDecimal childUseratio, IDataModel model, IFormView view, IPageCache pageCache) {
        DynamicObject firstDym = (DynamicObject)model.getValue("replaceplan", currentIndex);
        Long targetBillId = (Long)model.getValue("targetbillid", currentIndex);
        if (firstDym == null) {
            return;
        }
        String pId = model.getValue("pid", currentIndex).toString();
        int priority = (Integer)model.getValue("priority", currentIndex);
        DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRYENTITY);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject replacePlan = entry.getDynamicObject("replaceplan");
            if (replacePlan == null || currentIndex == i || entry.getLong("targetbillid") != targetBillId.longValue() || !replacePlan.getPkValue().equals(firstDym.getPkValue()) || !pId.equals(entry.getString("pid")) || priority != entry.getInt("priority")) continue;
            model.setValue("useratio", (Object)childUseratio, i);
            pageCache.put(ISIGNORECHANGEMFTSTOCK, "true");
            ManufstockPropertyChangeUtils.change4qtyRes("useratio", BigDecimal.ONE, model, i, currentIndex, view);
            pageCache.put(ISIGNORECHANGEMFTSTOCK, "false");
        }
    }

    public static void changeScrap(String key, Object newObj, int changeIndex, int currentSelectIndex, IFormView view, IDataModel model, IPageCache pageCache) {
        BigDecimal newDecimal = BigDecimal.ONE;
        if (!key.equals("wastagerateformula")) {
            newDecimal = (BigDecimal)newObj;
        }
        if (ManufstockPropertyChangeUtils.checkEntryMust(key.toLowerCase(), changeIndex, view, model)) {
            pageCache.put(ISIGNORECHANGEMFTSTOCK, "true");
            ManufstockPropertyChangeUtils.change4qtyRes(key.toLowerCase().trim(), newDecimal, model, changeIndex, currentSelectIndex, view);
        }
    }

    private static boolean checkEntryMust(String field, int currentRow, IFormView view, IDataModel model) {
        DynamicObject mtfmaterial = (DynamicObject)model.getValue("materialid", currentRow);
        if (mtfmaterial == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7ec4\u4ef6\u3002", (String)"ManufstockPropertyChangeUtils_4", (String)"bd-mpdm-business", (Object[])new Object[0]));
            return false;
        }
        DynamicObject unit = (DynamicObject)model.getValue("materialunitid", currentRow);
        if (unit == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55\u57fa\u672c\u5355\u4f4d\u4e3a\u7a7a\u3002", (String)"ManufstockPropertyChangeUtils_1", (String)"bd-mpdm-business", (Object[])new Object[0]));
            model.setValue(field, null, currentRow);
            return false;
        }
        String qtyType = (String)model.getValue("qtytype", currentRow);
        if (StringUtils.isEmpty((CharSequence)qtyType)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7528\u91cf\u7c7b\u578b\u3002", (String)"ManufstockPropertyChangeUtils_2", (String)"bd-mpdm-business", (Object[])new Object[0]));
            model.setValue(field, null, currentRow);
            return false;
        }
        return true;
    }

    public static void changeOverissueContrl(Object newObj, int changeIndex, int currentSelectIndex, IFormView view, IDataModel model, IPageCache pageCache) {
        String overfield = (String)model.getValue("overissuecontrl", currentSelectIndex);
        if ("B".equals(overfield)) {
            pageCache.put(ISIGNORECHANGEMFTSTOCK, "true");
            ManufstockPropertyChangeUtils.calHighQty(currentSelectIndex, model, view, true);
            ManufstockPropertyChangeUtils.calLowQty(currentSelectIndex, model, view, true);
        } else if ("A".equals(overfield)) {
            ManufstockPropertyChangeUtils.clearLimitQty(currentSelectIndex, currentSelectIndex, "overissuecontrlfield", model, view);
        }
        ManufstockPropertyChangeUtils.aculCanSendQty(currentSelectIndex, model, true);
    }

    public static void clearLimitQty(int changeIndex, int currentSelectIndex, String key, IDataModel model, IFormView view) {
        Object demandqty = model.getValue("demandqty", changeIndex);
        model.setValue("issinhighlimit", (Object)BigDecimal.ZERO, changeIndex);
        model.setValue("extraratioqty", demandqty, changeIndex);
        model.setValue("issinlowlimit", (Object)BigDecimal.ZERO, changeIndex);
        model.setValue("lackraitioqty", demandqty, changeIndex);
        model.setValue("overissuecontrl", (Object)"A", changeIndex);
        boolean isShow = false;
        ManufstockPropertyChangeUtils.lockLimitQty(changeIndex, currentSelectIndex, model, view);
        if (key.equals("iscannegative")) {
            if (((Boolean)model.getValue("iscannegative", changeIndex)).booleanValue()) {
                model.setValue("actissueqty", model.getValue("demandqty", changeIndex), changeIndex);
            } else {
                model.setValue("actissueqty", (Object)BigDecimal.ZERO, changeIndex);
            }
        }
        ManufstockPropertyChangeUtils.aculCanSendQty(changeIndex, model, isShow);
        DynamicObject stockEntry = model.getEntryRowEntity(ENTRYENTITY, changeIndex);
        DynamicObject orderEntry = (DynamicObject)model.getValue("orderentryid", changeIndex);
        if (orderEntry == null) {
            return;
        }
        DynamicObject transactiontype = (DynamicObject)model.getValue("transactiontypeid", changeIndex);
        model.setValue("unissueqty", MPDMMftGenStocksUtils.aculUnSendQty((DynamicObject)stockEntry), changeIndex);
        String modelName = model.getDataEntityType().getName();
        String ordername = "pom_mftorder";
        stockEntry.set("useqty", (Object)MPDMMftGenStocksUtils.aculUseQty((DynamicObject)stockEntry, (Object)orderEntry.getPkValue(), (DynamicObject)transactiontype, (String)ordername));
        model.setValue("useqty", stockEntry.get("useqty"), changeIndex);
        stockEntry.set("wipqty", (Object)MPDMMftGenStocksUtils.aculWIPQty((DynamicObject)stockEntry));
        model.setValue("wipqty", stockEntry.get("wipqty"), changeIndex);
    }

    public static void changeQtyType(IDataModel model, int changeIndex) {
        model.setValue("qtydenominator", (Object)BigDecimal.ONE, changeIndex);
        model.setValue("qtynumerator", (Object)BigDecimal.ZERO, changeIndex);
        model.setValue("standqty", (Object)BigDecimal.ZERO, changeIndex);
        model.setValue("demandqty", (Object)BigDecimal.ZERO, changeIndex);
        model.setValue("unissueqty", (Object)BigDecimal.ZERO, changeIndex);
        model.setValue("useqty", (Object)BigDecimal.ZERO, changeIndex);
        model.setValue("wipqty", (Object)BigDecimal.ZERO, changeIndex);
    }

    public static boolean getIsShow(int currentIndex, IFormView view) {
        return currentIndex == ManufstockPropertyChangeUtils.getSelectEntryRowIndex(view) && currentIndex != -1;
    }

    public static void calLowLimit(int currentSelectIndex, IDataModel model, IFormView view) {
        BigDecimal demandQty = (BigDecimal)model.getValue("demandqty", currentSelectIndex);
        BigDecimal lowQty = (BigDecimal)model.getValue("lackraitioqty", currentSelectIndex);
        if (lowQty.compareTo(demandQty) > 0) {
            model.setValue("issinlowlimit", (Object)BigDecimal.ZERO, currentSelectIndex);
            model.setValue("lackraitioqty", (Object)demandQty, currentSelectIndex);
        } else if (demandQty.compareTo(BigDecimal.ZERO) == 0) {
            if ((Long)model.getValue("parentid", currentSelectIndex) == 0L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u4e3a\u96f6\u3002", (String)"ManufstockPropertyChangeUtils_5", (String)"bd-mpdm-business", (Object[])new Object[0]));
            }
        } else {
            BigDecimal extraratioqty = BigDecimal.ONE.subtract(lowQty.divide(demandQty, 4, 4)).multiply(ONEHUNDRED);
            model.setValue("issinlowlimit", (Object)extraratioqty, currentSelectIndex);
        }
    }

    public static void changeWarehouse(Object newObj, int currentSelectIndex, IDataModel model, IFormView view) {
        model.setValue("warehouseid", newObj, currentSelectIndex);
        model.setValue("location", null, currentSelectIndex);
        ManufstockPropertyChangeUtils.lockLocationField(newObj, currentSelectIndex, model, view);
    }

    public static void changeOutWarehouse(Object newObj, int currentSelectIndex, IDataModel model, IFormView view) {
        model.setValue("outwarehouseid", newObj, currentSelectIndex);
        model.setValue("outlocation", null, currentSelectIndex);
        ManufstockPropertyChangeUtils.lockOutLocationField(newObj, currentSelectIndex, model, view);
    }

    public static void changeBatchNo(Object newObj, int changeIndex, int currentSelectIndex, IDataModel model, IFormView view, IPageCache pageCache) {
        pageCache.put(ISIGNORECHANGEMFTSTOCK, "true");
        DynamicObject dynamicObject = model.getEntryRowEntity(ENTRYENTITY, changeIndex);
        String lotnumber = dynamicObject.getString("batchno");
        if (lotnumber != null) {
            lotnumber = lotnumber.replaceAll("\u3000", " ").trim();
            model.setValue("batchno", (Object)lotnumber, changeIndex);
        }
        model.setValue("lot", null, changeIndex);
        pageCache.put(ISIGNORECHANGEMFTSTOCK, "false");
    }
}

