/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class MaterialInvInfoHelper {
    private MaterialInvInfoHelper() {
    }

    public static DynamicObject getMaterialInvInfo(DynamicObject org, DynamicObject master) {
        if (org == null || master == null) {
            return null;
        }
        Long masterId = (Long)master.getPkValue();
        Long orgId = (Long)org.getPkValue();
        HashMap<Long, List<Long>> orgMasterMap = new HashMap<Long, List<Long>>(1);
        ArrayList<Long> masterIdList = new ArrayList<Long>(1);
        masterIdList.add(masterId);
        orgMasterMap.put(orgId, masterIdList);
        Map<Long, Map<Long, DynamicObject>> res = MaterialInvInfoHelper.batchGetMaterialInvInfo(orgMasterMap);
        return MaterialInvInfoHelper.getMaterialByRes(res, orgId, masterId);
    }

    public static Map<Long, Map<Long, DynamicObject>> batchGetMaterialInvInfo(Map<Long, List<Long>> orgMasterMap) {
        HashMap<Long, Map<Long, DynamicObject>> res = new HashMap<Long, Map<Long, DynamicObject>>(16);
        if (orgMasterMap == null) {
            return res;
        }
        Set<Long> orgSet = orgMasterMap.keySet();
        Map<Long, QFilter> orgQFilterMap = MaterialInvInfoHelper.getBaseDataFilter(orgSet);
        for (Map.Entry<Long, List<Long>> entry : orgMasterMap.entrySet()) {
            QFilter qFilter = orgQFilterMap.get(entry.getKey());
            qFilter.and(new QFilter("status", "=", (Object)"C"));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            List<Long> masterIdList = entry.getValue();
            Map<Long, DynamicObject> masterInvMap = MaterialInvInfoHelper.getInvMap(qFilter, masterIdList);
            res.put(entry.getKey(), masterInvMap);
        }
        return res;
    }

    private static Map<Long, DynamicObject> getInvMap(QFilter qFilter, List<Long> masterIdList) {
        HashMap<Long, DynamicObject> invMap = new HashMap<Long, DynamicObject>(16);
        Map invMasterMap = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (String)"masterid,id,enablelot", (QFilter[])new QFilter[]{qFilter, new QFilter("masterid", "in", masterIdList)});
        for (Map.Entry entry : invMasterMap.entrySet()) {
            invMap.put((Long)((DynamicObject)entry.getValue()).getDynamicObject("masterid").getPkValue(), (DynamicObject)entry.getValue());
        }
        return invMap;
    }

    private static Map<Long, QFilter> getBaseDataFilter(Set<Long> orgSet) {
        HashMap<Long, QFilter> orgQFilterMap = new HashMap<Long, QFilter>(orgSet.size());
        for (Long orgId : orgSet) {
            orgQFilterMap.put(orgId, MaterialInvInfoHelper.getBaseDataFilter(orgId));
        }
        return orgQFilterMap;
    }

    private static QFilter getBaseDataFilter(Long orgId) {
        return BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)orgId);
    }

    public static DynamicObject getMaterialByRes(Map<Long, Map<Long, DynamicObject>> res, Long orgId, Long masterId) {
        Map<Long, DynamicObject> map = res.get(orgId);
        return map == null ? null : map.get(masterId);
    }
}

