/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;

public class MpdmComboxFieldValidator {
    private static final String ID = "id";
    private static final String SEQ = "seq";

    private static void addErrorMessage(StringBuilder errormessage, Map<?, Set<Integer>> map, String error) {
        Collection<Set<Integer>> coll = map.values();
        for (Set<Integer> set : coll) {
            if (set.size() < 2) continue;
            String msg = String.format(error, set);
            errormessage.append(msg);
        }
    }

    public static StringBuilder verifyComboxFields(IDataModel model, String entityname, String[] objname, String[] field, String errorhtml, Boolean[] isMust, Boolean[] fMust) {
        DynamicObjectCollection stracoll = model.getEntryEntity(entityname);
        HashMap<String, Set<Integer>> stramap = new HashMap<String, Set<Integer>>();
        StringBuilder errormessage = new StringBuilder();
        Iterator its = stracoll.iterator();
        if (!MpdmComboxFieldValidator.getErrorMessage(its, stramap, objname, field, isMust, fMust)) {
            return errormessage;
        }
        MpdmComboxFieldValidator.addErrorMessage(errormessage, stramap, errorhtml);
        return errormessage;
    }

    private static boolean getErrorMessage(Iterator<DynamicObject> its, Map<String, Set<Integer>> stramap, String[] objname, String[] field, Boolean[] isMust, Boolean[] fMust) {
        while (its.hasNext()) {
            StringBuilder idstr = new StringBuilder();
            DynamicObject dyn = its.next();
            if (!MpdmComboxFieldValidator.appendObjStr(dyn, idstr, objname, isMust)) {
                return false;
            }
            if (!MpdmComboxFieldValidator.appendIdStr(dyn, idstr, field, fMust)) {
                return false;
            }
            MpdmComboxFieldValidator.appendStraMap(dyn, stramap, idstr);
        }
        return true;
    }

    private static void appendStraMap(DynamicObject dyn, Map<String, Set<Integer>> stramap, StringBuilder idstr) {
        int seq = dyn.getInt(SEQ);
        HashSet<Integer> set = stramap.get(idstr.toString()) == null ? new HashSet<Integer>() : stramap.get(idstr.toString());
        set.add(seq);
        stramap.put(idstr.toString(), set);
    }

    private static boolean appendIdStr(DynamicObject dyn, StringBuilder idstr, String[] field, Boolean[] isMust) {
        Boolean flag = Boolean.TRUE;
        for (int k = 0; k < field.length; ++k) {
            flag = isMust[k] == false ? true : dyn.get(field[k]) != null;
            if (!flag.booleanValue()) {
                return flag;
            }
            Integer fs = dyn.get(field[k]) == null ? Integer.valueOf(0) : dyn.get(field[k]);
            idstr.append(fs);
        }
        return flag;
    }

    private static boolean appendObjStr(DynamicObject dyn, StringBuilder idstr, String[] field, Boolean[] isMust) {
        Boolean flag = Boolean.TRUE;
        for (int k = 0; k < field.length; ++k) {
            flag = isMust[k] == false ? true : dyn.get(field[k]) != null;
            if (!flag.booleanValue()) {
                return flag;
            }
            Integer id = dyn.get(field[k]) == null ? Integer.valueOf(0) : ((DynamicObject)dyn.get(field[k])).get(ID);
            idstr.append(id);
        }
        return flag;
    }

    public static StringBuilder vertifyComboxMessage(IDataModel model, String entityname, String objname, String Intername, String objhtml, String integerhtml, Boolean isFirst, Boolean isSecond) {
        DynamicObjectCollection stracoll = model.getEntryEntity(entityname);
        HashMap<Long, Set<Integer>> stramap = new HashMap<Long, Set<Integer>>();
        HashMap<Integer, Set<Integer>> primap = new HashMap<Integer, Set<Integer>>();
        StringBuilder errormessage = new StringBuilder();
        Iterator its = stracoll.iterator();
        if (!MpdmComboxFieldValidator.getVerifyMessage(its, objname, Intername, stramap, primap, isFirst, isSecond)) {
            return errormessage;
        }
        MpdmComboxFieldValidator.addErrorMessage(errormessage, stramap, objhtml);
        MpdmComboxFieldValidator.addErrorMessage(errormessage, primap, integerhtml);
        return errormessage;
    }

    private static boolean getVerifyMessage(Iterator<DynamicObject> its, String objname, String Intername, Map<Long, Set<Integer>> stramap, Map<Integer, Set<Integer>> primap, Boolean isFirst, Boolean isSecond) {
        while (its.hasNext()) {
            DynamicObject dynobj = its.next();
            if (!isFirst.booleanValue() || dynobj != null && dynobj.get(objname) != null && !isSecond.booleanValue() || dynobj != null) {
                MpdmComboxFieldValidator.appendMap(dynobj, stramap, primap, objname, Intername);
                continue;
            }
            return false;
        }
        return true;
    }

    private static void appendMap(DynamicObject dynobj, Map<Long, Set<Integer>> stramap, Map<Integer, Set<Integer>> primap, String objname, String Intername) {
        long straid = dynobj.get(objname) == null ? 0L : ((DynamicObject)dynobj.get(objname)).getLong(ID);
        int priority = dynobj.getInt(Intername);
        HashSet<Integer> straset = stramap.get(straid) == null ? new HashSet<Integer>() : stramap.get(straid);
        HashSet<Integer> priset = primap.get(priority) == null ? new HashSet<Integer>() : primap.get(priority);
        straset.add(dynobj.getInt(SEQ));
        priset.add(dynobj.getInt(SEQ));
        stramap.put(straid, straset);
        primap.put(priority, priset);
    }
}

