/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.manuftech.OprUnitHelper;
import kd.bd.mpdm.business.mftorder.splitmodel.SplitModel;
import kd.bd.mpdm.common.manuftech.utils.ManuftechCreateBillUtil;
import kd.bd.mpdm.common.mftorder.utils.JsonUtils;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bd.mpdm.common.mftorder.utils.ReadManuVersionUtils;
import kd.bd.mpdm.common.query.mservice.helper.MsBomQueryHelper;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class OrderSplitTechnicsHelper {
    private static final Log logger = LogFactory.getLog(OrderSplitTechnicsHelper.class);

    public static void updateOrderSpiltTechnicsBill(DynamicObject manftech, DynamicObject orderEntryObj, DynamicObject oldOrder, BigDecimal splitbaseqty) {
        DynamicObjectCollection col = manftech.getDynamicObjectCollection("oprentryentity");
        manftech.set("qty", (Object)orderEntryObj.getBigDecimal("qty"));
        manftech.set("baseqty", (Object)orderEntryObj.getBigDecimal("baseqty"));
        for (int j = 0; j < col.size(); ++j) {
            DynamicObject srcObj = (DynamicObject)col.get(j);
            if (Arrays.asList("F", "G").contains(srcObj.getString("oprstatus")) || srcObj.getBoolean("oprinvalid")) continue;
            BigDecimal bigDecimal = orderEntryObj.getBigDecimal("qty");
            srcObj.set("oprproductionqty", (Object)bigDecimal);
            ManuftechCreateBillUtil.recalculateEntryQty((DynamicObject)srcObj, (DynamicObject)orderEntryObj);
            if (!"C".equals(oldOrder.getString("billstatus"))) continue;
            BigDecimal totalsplitbaseqty = srcObj.getBigDecimal("oprtotalsplitbaseqty");
            totalsplitbaseqty = totalsplitbaseqty.add(splitbaseqty);
            srcObj.set("oprtotalsplitbaseqty", (Object)totalsplitbaseqty);
            Map<String, Object> map = OprUnitHelper.getManftechMap(manftech, srcObj);
            srcObj.set("oprtotalsplitqty", (Object)OprUnitHelper.getOprQty(map, totalsplitbaseqty));
        }
        ManuftechCreateBillUtil.setPorValue((DynamicObject)manftech, (String)"processseq");
    }

    public static DynamicObject createOrderSpiltTechnicsBill(DynamicObject newManftech, DynamicObject newOrderEntryObj, DynamicObject newOrder, Map<Object, DynamicObject> loadf7Map) {
        if (newOrder == null || newManftech == null) {
            return null;
        }
        String manftechType = newManftech.getDataEntityType().getName();
        DynamicObjectCollection proCol = newManftech.getDynamicObjectCollection("proentryentity");
        DynamicObjectCollection col = newManftech.getDynamicObjectCollection("oprentryentity");
        newManftech.set("modifier", (Object)UserServiceHelper.getCurrentUser((String)"id"));
        newManftech.set("modifytime", (Object)new Date());
        newManftech.set("org", newOrder.get("org"));
        newManftech.set("transactiontype", newOrder.get("transactiontype"));
        newManftech.set("material", newOrderEntryObj.get("materielmasterid"));
        newManftech.set("auxproperty", newOrderEntryObj.get("auxproperty"));
        newManftech.set("baseunit", newOrderEntryObj.get("baseunit"));
        newManftech.set("mftentryseq", (Object)loadf7Map.get(newOrderEntryObj.getPkValue()));
        newManftech.set("manufactureorderid", newOrder.getPkValue());
        newManftech.set("manufactureorderseq", newOrderEntryObj.get("seq"));
        newManftech.set("batchno", newOrderEntryObj.get("batchno"));
        DynamicObject bom = newOrderEntryObj.getDynamicObject("bomid");
        if (null != bom && (bom = MsBomQueryHelper.getDataCacheByID((Object)bom.getPkValue())) != null && bom.getDynamicObject("version") != null) {
            newManftech.set("bomversion", (Object)bom.getDynamicObject("version").getString("name"));
        }
        if ("om_mfttechnics".equals(manftechType)) {
            newManftech.set("headsupplier", newOrderEntryObj.get("supplier"));
        }
        newManftech.set("productionworkshop", newOrderEntryObj.get("producedept"));
        newManftech.set("planstarttime", newOrderEntryObj.get("planbegintime"));
        newManftech.set("planfinishtime", newOrderEntryObj.get("planendtime"));
        newManftech.set("qty", (Object)newOrderEntryObj.getBigDecimal("qty"));
        newManftech.set("baseqty", (Object)newOrderEntryObj.getBigDecimal("baseqty"));
        newManftech.set("baseunit", newOrderEntryObj.get("baseunit"));
        newManftech.set("baseqty", newOrderEntryObj.get("baseqty"));
        newManftech.set("auxptyunit", newOrderEntryObj.get("auxptyunit"));
        newManftech.set("auxptyqty", newOrderEntryObj.get("auxptyqty"));
        newManftech.set("parentplanid", (Object)"");
        ArrayList<DynamicObject> delRows = new ArrayList<DynamicObject>(10);
        HashSet<String> oprparents = new HashSet<String>(10);
        for (int j = 0; j < col.size(); ++j) {
            DynamicObject srcObj = (DynamicObject)col.get(j);
            if (!Arrays.asList("F", "G").contains(srcObj.getString("oprstatus")) && !srcObj.getBoolean("oprinvalid")) {
                srcObj.set("oprstatus", (Object)"A");
                BigDecimal bigDecimal = newOrderEntryObj.getBigDecimal("qty");
                srcObj.set("oprproductionqty", (Object)bigDecimal);
                srcObj.set("oprplanbegintime", newOrderEntryObj.get("planbegintime"));
                srcObj.set("oprplanfinishtime", newOrderEntryObj.get("planendtime"));
                srcObj.set("oprearliestbegintime", newOrderEntryObj.get("planbegintime"));
                srcObj.set("oprlatestbegintime", newOrderEntryObj.get("planbegintime"));
                srcObj.set("oprearliestfinishtime", newOrderEntryObj.get("planendtime"));
                srcObj.set("oprlatestfinishtime", newOrderEntryObj.get("planendtime"));
                ManuftechCreateBillUtil.recalculateEntryQty((DynamicObject)srcObj, (DynamicObject)newOrderEntryObj);
                DynamicObjectCollection subEntryCol = srcObj.getDynamicObjectCollection("actsubentryentity");
                for (int k = 0; k < subEntryCol.size(); ++k) {
                    DynamicObject subEntryObj = (DynamicObject)subEntryCol.get(k);
                    ManuftechCreateBillUtil.runFormula((DynamicObject)subEntryObj);
                }
                oprparents.add(srcObj.getString("oprparent"));
                continue;
            }
            delRows.add(srcObj);
        }
        if (!delRows.isEmpty()) {
            col.removeAll(delRows);
        }
        ArrayList<DynamicObject> delProRows = new ArrayList<DynamicObject>(10);
        for (int j = 0; j < proCol.size(); ++j) {
            DynamicObject proObj = (DynamicObject)proCol.get(j);
            if (oprparents.contains(proObj.getString("processseq"))) {
                proObj.set("processplanbegintime", newOrderEntryObj.get("planbegintime"));
                proObj.set("processplanendtime", newOrderEntryObj.get("planendtime"));
                ManuftechCreateBillUtil.setPorValue((DynamicObject)newManftech, (String)"processseq");
                continue;
            }
            delProRows.add(proObj);
        }
        if (!delProRows.isEmpty()) {
            proCol.removeAll(delProRows);
        }
        String sourceBillType = newOrder.getDynamicObjectType().getName();
        String entryName = "treeentryentity";
        Long srcTableId = ConvertMetaServiceHelper.loadTableDefine((String)sourceBillType, (String)entryName).getTableId();
        DynamicObjectCollection linkRows = (DynamicObjectCollection)newManftech.get("billhead_lk");
        linkRows.clear();
        if (linkRows.isEmpty()) {
            DynamicObject linkRow = linkRows.addNew();
            linkRow.set("billhead_lk_stableid", (Object)srcTableId);
            linkRow.set("billhead_lk_sbillid", newOrder.getPkValue());
            linkRow.set("billhead_lk_sid", newOrderEntryObj.getPkValue());
        }
        String billNo = "";
        DynamicObject org = newManftech.getDynamicObject("org");
        if (null != org) {
            String orgId = org.getString("id");
            billNo = JsonUtils.getAutoNumber((DynamicObject)newManftech, (String)orgId, (String)manftechType);
        }
        if (StringUtils.isBlank((CharSequence)billNo)) {
            ORM orm = ORM.create();
            billNo = "mo_" + orm.genLongId(newManftech.getDataEntityType().getName());
        }
        newManftech.set("billno", (Object)billNo);
        return newManftech;
    }

    public static Set<String> getAllEntryFields(String entityKey, String entryEntityKey) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityKey);
        EntityType subEntryType = (EntityType)mainType.getAllEntities().get(entryEntityKey);
        Set<String> keySet = subEntryType.getFields().keySet();
        keySet.remove("setuplocation");
        keySet.remove("isGroupNode");
        return keySet;
    }

    public static Set<String> getAllFields(String entityKey) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityKey);
        Set<String> keySet = mainType.getFields().keySet();
        return keySet;
    }

    public static String getAllProperties(String entityKey, String ... entryEntityKey) {
        StringBuilder sb = new StringBuilder("id");
        Set<String> stockFields = OrderSplitTechnicsHelper.getAllFields(entityKey);
        for (String fields : stockFields) {
            sb.append(",");
            sb.append(fields);
        }
        for (String entryEntity : entryEntityKey) {
            if (!StringUtils.isNotBlank((CharSequence)entryEntity)) continue;
            Set<String> entryFields = OrderSplitTechnicsHelper.getAllEntryFields(entityKey, entryEntity);
            for (String entryField : entryFields) {
                sb.append(",");
                sb.append(entryEntity);
                sb.append(".");
                sb.append(entryField);
            }
        }
        return sb.toString();
    }

    public static void orderSpiltTechnicsBill(Set<Object> orderEntryIds, Map<Object, List<DynamicObject>> newOrderEntryMap, Map<Object, DynamicObject> newOrderMap, Map<Object, DynamicObject> orderEntryMap, Map<Object, DynamicObject> oldOrderMap) {
        HashSet<Object> pomOrderEntrySetIds = new HashSet<Object>(16);
        HashSet<Object> omOrderEntrySetIds = new HashSet<Object>(16);
        for (Map.Entry<Object, DynamicObject> orderEntry : newOrderMap.entrySet()) {
            String entityNo = orderEntry.getValue().getDataEntityType().getName();
            if ("pom_mftorder".equals(entityNo)) {
                pomOrderEntrySetIds.add(orderEntry.getKey());
                continue;
            }
            if (!"om_mftorder".equals(entityNo)) continue;
            omOrderEntrySetIds.add(orderEntry.getKey());
        }
        QFilter filter = new QFilter("mftentryseq", "in", orderEntryIds);
        String selectPro = OrderSplitTechnicsHelper.getAllProperties("sfc_manftech", "oprentryentity", "proentryentity", "ressubentryentity", "actsubentryentity", "repsubentryentity");
        selectPro = selectPro + ",billhead_lk,billhead_lk_stableid,billhead_lk_sbillid,billhead_lk_sid,oprentryentity_lk,oprentryentity_lk_stableid,oprentryentity_lk_sbillid,oprentryentity_lk_sid";
        DynamicObject[] manftechs = BusinessDataServiceHelper.load((String)"sfc_manftech", (String)selectPro, (QFilter[])new QFilter[]{filter});
        HashSet<DynamicObject> pomManfetchs = new HashSet<DynamicObject>(16);
        HashSet<DynamicObject> omManfetchs = new HashSet<DynamicObject>(16);
        for (DynamicObject manftech : manftechs) {
            Object mftentryseq = manftech.getDynamicObject("mftentryseq").getPkValue();
            List<DynamicObject> newOrderEntrys = newOrderEntryMap.get(mftentryseq);
            for (DynamicObject newOrderEntry : newOrderEntrys) {
                if (pomOrderEntrySetIds.contains(newOrderEntry.getPkValue())) {
                    pomManfetchs.add(manftech);
                }
                if (!omOrderEntrySetIds.contains(newOrderEntry.getPkValue())) continue;
                omManfetchs.add(manftech);
            }
        }
        if (CollectionUtils.isNotEmpty(pomManfetchs)) {
            List<DynamicObject> pushBills = OrderSplitTechnicsHelper.pushBills(pomManfetchs.toArray(new DynamicObject[0]));
            HashMap<Object, DynamicObject> newPomManftechMap = new HashMap<Object, DynamicObject>(pushBills.size());
            for (DynamicObject pushBill : pushBills) {
                newPomManftechMap.put(pushBill.get("parentplanid"), pushBill);
            }
            Map<Object, DynamicObject> loadf7Map = OrderSplitTechnicsHelper.loadOrderF7Map("pom_mftorder_f7", pomOrderEntrySetIds);
            OrderSplitTechnicsHelper.executeManftechSplit("mps_scheduleplan", pomManfetchs, pomOrderEntrySetIds, newOrderEntryMap, newOrderMap, orderEntryMap, loadf7Map, oldOrderMap, newPomManftechMap);
        }
        if (CollectionUtils.isNotEmpty(omManfetchs)) {
            List<DynamicObject> pushOmBills = OrderSplitTechnicsHelper.pushOmBills(omManfetchs.toArray(new DynamicObject[0]));
            HashMap<Object, DynamicObject> newOmManftechMap = new HashMap<Object, DynamicObject>(pushOmBills.size());
            for (DynamicObject pushBill : pushOmBills) {
                newOmManftechMap.put(pushBill.get("parentplanid"), pushBill);
            }
            Map<Object, DynamicObject> loadf7Map = OrderSplitTechnicsHelper.loadOrderF7Map("om_mftorder_f7", omOrderEntrySetIds);
            OrderSplitTechnicsHelper.executeManftechSplit("mps_scheduleplan", omManfetchs, omOrderEntrySetIds, newOrderEntryMap, newOrderMap, orderEntryMap, loadf7Map, oldOrderMap, newOmManftechMap);
        }
    }

    public static void orderSpiltTechnicsBillMps(Set<Object> orderEntryIds, Map<Object, List<DynamicObject>> newOrderEntryMap, Map<Object, DynamicObject> newOrderMap, Map<Object, DynamicObject> orderEntryMap, Map<Object, DynamicObject> oldOrderMap) {
        HashSet<Object> pomOrderEntrySetIds = new HashSet<Object>(16);
        HashSet<Object> omOrderEntrySetIds = new HashSet<Object>(16);
        for (Map.Entry<Object, DynamicObject> orderEntry : newOrderMap.entrySet()) {
            String entityNo = orderEntry.getValue().getDataEntityType().getName();
            if ("pom_mftorder".equals(entityNo)) {
                pomOrderEntrySetIds.add(orderEntry.getKey());
                continue;
            }
            if (!"om_mftorder".equals(entityNo)) continue;
            omOrderEntrySetIds.add(orderEntry.getKey());
        }
        QFilter filter = new QFilter("mftentryseq", "in", orderEntryIds);
        String selectPro = OrderSplitTechnicsHelper.getAllProperties("sfc_manftech", "oprentryentity", "proentryentity", "ressubentryentity", "actsubentryentity", "repsubentryentity");
        selectPro = selectPro + ",billhead_lk,billhead_lk_stableid,billhead_lk_sbillid,billhead_lk_sid,oprentryentity_lk,oprentryentity_lk_stableid,oprentryentity_lk_sbillid,oprentryentity_lk_sid";
        DynamicObject[] manftechs = BusinessDataServiceHelper.load((String)"sfc_manftech", (String)selectPro, (QFilter[])new QFilter[]{filter});
        HashSet<DynamicObject> pomManfetchs = new HashSet<DynamicObject>(16);
        HashSet<DynamicObject> omManfetchs = new HashSet<DynamicObject>(16);
        for (DynamicObject manftech : manftechs) {
            Object mftentryseq = manftech.getDynamicObject("mftentryseq").getPkValue();
            List<DynamicObject> newOrderEntrys = newOrderEntryMap.get(mftentryseq);
            for (DynamicObject newOrderEntry : newOrderEntrys) {
                if (pomOrderEntrySetIds.contains(newOrderEntry.getPkValue())) {
                    pomManfetchs.add(manftech);
                }
                if (!omOrderEntrySetIds.contains(newOrderEntry.getPkValue())) continue;
                omManfetchs.add(manftech);
            }
        }
        if (CollectionUtils.isNotEmpty(pomManfetchs)) {
            List<DynamicObject> pushBills = OrderSplitTechnicsHelper.pushBills(pomManfetchs.toArray(new DynamicObject[0]));
            HashMap<Object, DynamicObject> newPomManftechMap = new HashMap<Object, DynamicObject>(pushBills.size());
            for (DynamicObject pushBill : pushBills) {
                newPomManftechMap.put(pushBill.get("parentplanid"), pushBill);
            }
            Map<Object, DynamicObject> loadf7Map = OrderSplitTechnicsHelper.loadOrderF7Map("pom_mftorder_f7", pomOrderEntrySetIds);
            OrderSplitTechnicsHelper.executeManftechSplit("mps_scheduleplan", pomManfetchs, pomOrderEntrySetIds, newOrderEntryMap, newOrderMap, orderEntryMap, loadf7Map, oldOrderMap, newPomManftechMap);
        }
        if (CollectionUtils.isNotEmpty(omManfetchs)) {
            List<DynamicObject> pushOmBills = OrderSplitTechnicsHelper.pushOmBills(omManfetchs.toArray(new DynamicObject[0]));
            HashMap<Object, DynamicObject> newOmManftechMap = new HashMap<Object, DynamicObject>(pushOmBills.size());
            for (DynamicObject pushBill : pushOmBills) {
                newOmManftechMap.put(pushBill.get("parentplanid"), pushBill);
            }
            Map<Object, DynamicObject> loadf7Map = OrderSplitTechnicsHelper.loadOrderF7Map("om_mftorder_f7", omOrderEntrySetIds);
            OrderSplitTechnicsHelper.executeManftechSplit("mps_scheduleplan", omManfetchs, omOrderEntrySetIds, newOrderEntryMap, newOrderMap, orderEntryMap, loadf7Map, oldOrderMap, newOmManftechMap);
        }
    }

    public static void orderSpiltTechnicsBillMps(Set<Object> orderEntryIds, Map<Object, List<DynamicObject>> newOrderEntryMap, Map<Object, DynamicObject> newOrderMap, Map<Object, DynamicObject> orderEntryMap, Map<Object, DynamicObject> oldOrderMap, SplitModel splitModel) {
        HashSet<Object> pomOrderEntrySetIds = new HashSet<Object>(16);
        HashSet<Object> omOrderEntrySetIds = new HashSet<Object>(16);
        for (Map.Entry<Object, DynamicObject> orderEntry : newOrderMap.entrySet()) {
            String entityNo = orderEntry.getValue().getDataEntityType().getName();
            if ("pom_mftorder".equals(entityNo)) {
                pomOrderEntrySetIds.add(orderEntry.getKey());
                continue;
            }
            if (!"om_mftorder".equals(entityNo)) continue;
            omOrderEntrySetIds.add(orderEntry.getKey());
        }
        QFilter filter = new QFilter("mftentryseq", "in", orderEntryIds);
        String selectPro = OrderSplitTechnicsHelper.getAllProperties(splitModel.getMftechEntity(), "oprentryentity", "proentryentity", "ressubentryentity", "actsubentryentity", "repsubentryentity");
        selectPro = selectPro + ",billhead_lk,billhead_lk_stableid,billhead_lk_sbillid,billhead_lk_sid,oprentryentity_lk,oprentryentity_lk_stableid,oprentryentity_lk_sbillid,oprentryentity_lk_sid";
        DynamicObject[] manftechs = BusinessDataServiceHelper.load((String)"sfc_manftech", (String)selectPro, (QFilter[])new QFilter[]{filter});
        HashSet<DynamicObject> pomManfetchs = new HashSet<DynamicObject>(16);
        HashSet<DynamicObject> omManfetchs = new HashSet<DynamicObject>(16);
        for (DynamicObject manftech : manftechs) {
            Object mftentryseq = manftech.getDynamicObject("mftentryseq").getPkValue();
            List<DynamicObject> newOrderEntrys = newOrderEntryMap.get(mftentryseq);
            for (DynamicObject newOrderEntry : newOrderEntrys) {
                if (pomOrderEntrySetIds.contains(newOrderEntry.getPkValue())) {
                    pomManfetchs.add(manftech);
                }
                if (!omOrderEntrySetIds.contains(newOrderEntry.getPkValue())) continue;
                omManfetchs.add(manftech);
            }
        }
        if (CollectionUtils.isNotEmpty(pomManfetchs)) {
            List<DynamicObject> pushBills = OrderSplitTechnicsHelper.pushBills(pomManfetchs.toArray(new DynamicObject[0]));
            HashMap<Object, DynamicObject> newPomManftechMap = new HashMap<Object, DynamicObject>(pushBills.size());
            for (DynamicObject pushBill : pushBills) {
                newPomManftechMap.put(pushBill.get("parentplanid"), pushBill);
            }
            Map<Object, DynamicObject> loadf7Map = OrderSplitTechnicsHelper.loadOrderF7Map("pom_mftorder_f7", pomOrderEntrySetIds);
            OrderSplitTechnicsHelper.executeManftechSplit("mps_scheduleplan", pomManfetchs, pomOrderEntrySetIds, newOrderEntryMap, newOrderMap, orderEntryMap, loadf7Map, oldOrderMap, newPomManftechMap);
        }
        if (CollectionUtils.isNotEmpty(omManfetchs)) {
            List<DynamicObject> pushOmBills = OrderSplitTechnicsHelper.pushOmBills(omManfetchs.toArray(new DynamicObject[0]));
            HashMap<Object, DynamicObject> newOmManftechMap = new HashMap<Object, DynamicObject>(pushOmBills.size());
            for (DynamicObject pushBill : pushOmBills) {
                newOmManftechMap.put(pushBill.get("parentplanid"), pushBill);
            }
            Map<Object, DynamicObject> loadf7Map = OrderSplitTechnicsHelper.loadOrderF7Map("om_mftorder_f7", omOrderEntrySetIds);
            OrderSplitTechnicsHelper.executeManftechSplit("mps_scheduleplan", omManfetchs, omOrderEntrySetIds, newOrderEntryMap, newOrderMap, orderEntryMap, loadf7Map, oldOrderMap, newOmManftechMap);
        }
    }

    public static void orderSpiltTechnicsBill(Set<Object> orderEntryIds, Map<Object, List<DynamicObject>> newOrderEntryMap, Map<Object, DynamicObject> newOrderMap, Map<Object, DynamicObject> orderEntryMap, Map<Object, DynamicObject> oldOrderMap, SplitModel splitModel) {
        HashSet<Object> pomOrderEntrySetIds = new HashSet<Object>(16);
        HashSet<Object> omOrderEntrySetIds = new HashSet<Object>(16);
        for (Map.Entry<Object, DynamicObject> orderEntry : newOrderMap.entrySet()) {
            String entityNo = orderEntry.getValue().getDataEntityType().getName();
            if ("pom_mftorder".equals(entityNo)) {
                pomOrderEntrySetIds.add(orderEntry.getKey());
                continue;
            }
            if (!"om_mftorder".equals(entityNo)) continue;
            omOrderEntrySetIds.add(orderEntry.getKey());
        }
        String mftechEntity = splitModel.getMftechEntity();
        QFilter filter = new QFilter("mftentryseq", "in", orderEntryIds);
        String selectPro = OrderSplitTechnicsHelper.getAllProperties(mftechEntity, "oprentryentity", "proentryentity", "ressubentryentity", "actsubentryentity", "repsubentryentity");
        selectPro = selectPro + ",billhead_lk,billhead_lk_stableid,billhead_lk_sbillid,billhead_lk_sid,oprentryentity_lk,oprentryentity_lk_stableid,oprentryentity_lk_sbillid,oprentryentity_lk_sid";
        DynamicObject[] manftechs = BusinessDataServiceHelper.load((String)mftechEntity, (String)selectPro, (QFilter[])new QFilter[]{filter});
        HashSet<DynamicObject> pomManfetchs = new HashSet<DynamicObject>(16);
        HashSet<DynamicObject> omManfetchs = new HashSet<DynamicObject>(16);
        for (DynamicObject manftech : manftechs) {
            Object mftentryseq = manftech.getDynamicObject("mftentryseq").getPkValue();
            List<DynamicObject> newOrderEntrys = newOrderEntryMap.get(mftentryseq);
            for (DynamicObject newOrderEntry : newOrderEntrys) {
                if (pomOrderEntrySetIds.contains(newOrderEntry.getPkValue())) {
                    pomManfetchs.add(manftech);
                }
                if (!omOrderEntrySetIds.contains(newOrderEntry.getPkValue())) continue;
                omManfetchs.add(manftech);
            }
        }
        if (CollectionUtils.isNotEmpty(pomManfetchs)) {
            List<DynamicObject> pushBills = OrderSplitTechnicsHelper.pushBills(pomManfetchs.toArray(new DynamicObject[0]), mftechEntity, splitModel.getPushPomManFtechRuleId());
            HashMap<Object, DynamicObject> newPomManftechMap = new HashMap<Object, DynamicObject>(pushBills.size());
            for (DynamicObject pushBill : pushBills) {
                newPomManftechMap.put(pushBill.get("parentplanid"), pushBill);
            }
            Map<Object, DynamicObject> loadf7Map = OrderSplitTechnicsHelper.loadOrderF7Map("pom_mftorder_f7", pomOrderEntrySetIds);
            OrderSplitTechnicsHelper.executeManftechSplit("mps_scheduleplan", pomManfetchs, pomOrderEntrySetIds, newOrderEntryMap, newOrderMap, orderEntryMap, loadf7Map, oldOrderMap, newPomManftechMap, splitModel);
        }
        if (CollectionUtils.isNotEmpty(omManfetchs)) {
            List<DynamicObject> pushOmBills = OrderSplitTechnicsHelper.pushOmBills(omManfetchs.toArray(new DynamicObject[0]), mftechEntity, splitModel.getPushOmManFtechRuleId());
            HashMap<Object, DynamicObject> newOmManftechMap = new HashMap<Object, DynamicObject>(pushOmBills.size());
            for (DynamicObject pushBill : pushOmBills) {
                newOmManftechMap.put(pushBill.get("parentplanid"), pushBill);
            }
            Map<Object, DynamicObject> loadf7Map = OrderSplitTechnicsHelper.loadOrderF7Map("om_mftorder_f7", omOrderEntrySetIds);
            OrderSplitTechnicsHelper.executeManftechSplit("mps_scheduleplan", omManfetchs, omOrderEntrySetIds, newOrderEntryMap, newOrderMap, orderEntryMap, loadf7Map, oldOrderMap, newOmManftechMap, splitModel);
        }
    }

    private static Map<Object, DynamicObject> loadOrderF7Map(String f7Type, Set<Object> orderEntrySetIds) {
        DynamicObject[] pomLoads = BusinessDataServiceHelper.load((String)f7Type, (String)"entryseq", (QFilter[])new QFilter[]{new QFilter("id", "in", orderEntrySetIds)});
        HashMap<Object, DynamicObject> loadf7Map = new HashMap<Object, DynamicObject>(pomLoads.length);
        for (DynamicObject load : pomLoads) {
            loadf7Map.put(load.getPkValue(), load);
        }
        return loadf7Map;
    }

    private static void executeManftechSplit(String splitSrcType, Set<DynamicObject> manfetchs, Set<Object> orderEntrySetIds, Map<Object, List<DynamicObject>> newOrderEntryMap, Map<Object, DynamicObject> newOrderMap, Map<Object, DynamicObject> orderEntryMap, Map<Object, DynamicObject> loadf7Map, Map<Object, DynamicObject> oldOrderMap, Map<Object, DynamicObject> newManftechMap) {
        OperationResult saveOperate;
        String entityName;
        ArrayList<DynamicObject> updateTechnics = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> saveTechnics = new ArrayList<DynamicObject>(16);
        HashMap<Long, DynamicObject> orderEntryMapRead = new HashMap<Long, DynamicObject>(16);
        ArrayList<Long> orderentryidList = new ArrayList<Long>(16);
        HashMap<Object, BigDecimal> splitbaseqtyMap = new HashMap<Object, BigDecimal>(newOrderEntryMap.size());
        for (DynamicObject manftech : manfetchs) {
            Object mftentryseq = manftech.getDynamicObject("mftentryseq").getPkValue();
            List<DynamicObject> orderEntrys = newOrderEntryMap.get(mftentryseq);
            for (DynamicObject newOrderEntryObj : orderEntrys) {
                if (!orderEntrySetIds.contains(newOrderEntryObj.getPkValue())) continue;
                BigDecimal qty = null == splitbaseqtyMap.get(mftentryseq) ? BigDecimal.ZERO : (BigDecimal)splitbaseqtyMap.get(mftentryseq);
                qty = qty.add(newOrderEntryObj.getBigDecimal("baseqty"));
                splitbaseqtyMap.put(mftentryseq, qty);
                DynamicObject newOrder = newOrderMap.get(newOrderEntryObj.getPkValue());
                if (!newOrder.getDynamicObject("transactiontype").getBoolean("isprocedure")) continue;
                DynamicObject newManftech = (DynamicObject)OrmUtils.clone((IDataEntityBase)((IDataEntityBase)newManftechMap.get(manftech.getPkValue().toString())), (boolean)false, (boolean)true);
                DynamicObject newTechnicsBill = OrderSplitTechnicsHelper.createOrderSpiltTechnicsBill(newManftech, newOrderEntryObj, newOrder, loadf7Map);
                orderentryidList.add((Long)newOrderEntryObj.getPkValue());
                orderEntryMapRead.put((Long)newOrderEntryObj.getPkValue(), newOrderEntryObj);
                if (null == newTechnicsBill) continue;
                newManftech.set("creator", manftech.get("creator"));
                newManftech.set("createtime", manftech.get("createtime"));
                saveTechnics.add(newTechnicsBill);
            }
            OrderSplitTechnicsHelper.updateOrderSpiltTechnicsBill(manftech, orderEntryMap.get(mftentryseq), oldOrderMap.get(mftentryseq), (BigDecimal)splitbaseqtyMap.get(mftentryseq));
            updateTechnics.add(manftech);
        }
        String string = entityName = saveTechnics.size() > 0 ? ((DynamicObject)saveTechnics.get(0)).getDataEntityType().getName() : "sfc_manftech";
        if (StringUtils.equals((CharSequence)"mps_scheduleplan", (CharSequence)splitSrcType)) {
            long readManuVersionUtilsupdateTechnics = System.currentTimeMillis();
            logger.info("\u91cd\u8bfb\u751f\u4ea7\u7248\u672cupdateTechnics \u5f00\u59cb saveTechnics size:" + saveTechnics.size());
            ReadManuVersionUtils.updateTechnics((String)entityName, orderEntryMapRead, saveTechnics, orderentryidList);
            logger.info("\u91cd\u8bfb\u751f\u4ea7\u7248\u672cupdateTechnics\uff0c\u8017\u65f6 --------------" + (System.currentTimeMillis() - readManuVersionUtilsupdateTechnics));
        }
        OperateOption create = OperateOption.create();
        create.setVariableValue("ishasright", "true");
        create.setVariableValue("ignorewarn", "true");
        create.setVariableValue("ignoreinteraction", "true");
        if ("om_mfttechnics".equals(entityName)) {
            create.setVariableValue("orderBillType", "om_mftorder");
            create.setVariableValue("stockBillType", "om_mftstock");
        }
        if (!(saveOperate = SaveServiceHelper.saveOperate((String)entityName, (DynamicObject[])saveTechnics.toArray(new DynamicObject[saveTechnics.size()]), (OperateOption)create)).isSuccess()) {
            throw new KDBizException(new ErrorCode("OrderSplitTechnicsHelper", String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4fdd\u5b58\u5de5\u5e8f\u8ba1\u5212\u5f02\u5e38\uff1a%1$s", (String)"OrderSplitTechnicsHelper_1", (String)"bd-mpdm-business", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)saveOperate))), new Object[0]);
        }
        SaveServiceHelper.update((DynamicObject[])updateTechnics.toArray(new DynamicObject[0]));
    }

    private static void executeManftechSplit(String splitSrcType, Set<DynamicObject> manfetchs, Set<Object> orderEntrySetIds, Map<Object, List<DynamicObject>> newOrderEntryMap, Map<Object, DynamicObject> newOrderMap, Map<Object, DynamicObject> orderEntryMap, Map<Object, DynamicObject> loadf7Map, Map<Object, DynamicObject> oldOrderMap, Map<Object, DynamicObject> newManftechMap, SplitModel splitModel) {
        OperationResult saveOperate;
        String entityName;
        ArrayList<DynamicObject> updateTechnics = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> saveTechnics = new ArrayList<DynamicObject>(16);
        HashMap<Long, DynamicObject> orderEntryMapRead = new HashMap<Long, DynamicObject>(16);
        ArrayList<Long> orderentryidList = new ArrayList<Long>(16);
        HashMap<Object, BigDecimal> splitbaseqtyMap = new HashMap<Object, BigDecimal>(newOrderEntryMap.size());
        for (DynamicObject manftech : manfetchs) {
            Object mftentryseq = manftech.getDynamicObject("mftentryseq").getPkValue();
            List<DynamicObject> orderEntrys = newOrderEntryMap.get(mftentryseq);
            for (DynamicObject newOrderEntryObj : orderEntrys) {
                if (!orderEntrySetIds.contains(newOrderEntryObj.getPkValue())) continue;
                BigDecimal qty = null == splitbaseqtyMap.get(mftentryseq) ? BigDecimal.ZERO : (BigDecimal)splitbaseqtyMap.get(mftentryseq);
                qty = qty.add(newOrderEntryObj.getBigDecimal("baseqty"));
                splitbaseqtyMap.put(mftentryseq, qty);
                DynamicObject newOrder = newOrderMap.get(newOrderEntryObj.getPkValue());
                if (!newOrder.getDynamicObject("transactiontype").getBoolean("isprocedure")) continue;
                DynamicObject newManftech = (DynamicObject)OrmUtils.clone((IDataEntityBase)((IDataEntityBase)newManftechMap.get(manftech.getPkValue().toString())), (boolean)false, (boolean)true);
                DynamicObject newTechnicsBill = OrderSplitTechnicsHelper.createOrderSpiltTechnicsBill(newManftech, newOrderEntryObj, newOrder, loadf7Map);
                orderentryidList.add((Long)newOrderEntryObj.getPkValue());
                orderEntryMapRead.put((Long)newOrderEntryObj.getPkValue(), newOrderEntryObj);
                if (null == newTechnicsBill) continue;
                newManftech.set("creator", manftech.get("creator"));
                newManftech.set("createtime", manftech.get("createtime"));
                saveTechnics.add(newTechnicsBill);
            }
            OrderSplitTechnicsHelper.updateOrderSpiltTechnicsBill(manftech, orderEntryMap.get(mftentryseq), oldOrderMap.get(mftentryseq), (BigDecimal)splitbaseqtyMap.get(mftentryseq));
            updateTechnics.add(manftech);
        }
        String string = entityName = saveTechnics.size() > 0 ? ((DynamicObject)saveTechnics.get(0)).getDataEntityType().getName() : "sfc_manftech";
        if (StringUtils.equals((CharSequence)"mps_scheduleplan", (CharSequence)splitSrcType)) {
            long readManuVersionUtilsupdateTechnics = System.currentTimeMillis();
            logger.info("\u91cd\u8bfb\u751f\u4ea7\u7248\u672cupdateTechnics \u5f00\u59cb saveTechnics size:" + saveTechnics.size());
            ReadManuVersionUtils.updateTechnics((String)entityName, orderEntryMapRead, saveTechnics, orderentryidList);
            logger.info("\u91cd\u8bfb\u751f\u4ea7\u7248\u672cupdateTechnics\uff0c\u8017\u65f6 --------------" + (System.currentTimeMillis() - readManuVersionUtilsupdateTechnics));
        }
        OperateOption create = OperateOption.create();
        create.setVariableValue("ishasright", "true");
        create.setVariableValue("ignorewarn", "true");
        create.setVariableValue("ignoreinteraction", "true");
        if ("om_mfttechnics".equals(entityName)) {
            create.setVariableValue("orderBillType", "om_mftorder");
            create.setVariableValue("stockBillType", "om_mftstock");
        }
        if (!(saveOperate = SaveServiceHelper.saveOperate((String)entityName, (DynamicObject[])saveTechnics.toArray(new DynamicObject[saveTechnics.size()]), (OperateOption)create)).isSuccess()) {
            throw new KDBizException(new ErrorCode("OrderSplitTechnicsHelper", String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4fdd\u5b58\u5de5\u5e8f\u8ba1\u5212\u5f02\u5e38\uff1a%1$s", (String)"OrderSplitTechnicsHelper_1", (String)"bd-mpdm-business", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)saveOperate))), new Object[0]);
        }
        SaveServiceHelper.update((DynamicObject[])updateTechnics.toArray(new DynamicObject[0]));
    }

    public static List<DynamicObject> pushBills(DynamicObject[] manftechs) {
        return OrderSplitTechnicsHelper.pushBills(manftechs, "sfc_manftech", "1377482293601403904");
    }

    public static List<DynamicObject> pushBills(DynamicObject[] manftechs, String srcManFtech, String ruleId) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(srcManFtech);
        pushArgs.setTargetEntityNumber("sfc_manftech");
        pushArgs.setHasRight(false);
        pushArgs.setRuleId(ruleId);
        pushArgs.setBuildConvReport(true);
        List<DynamicObject> targetBillObjs = OrderSplitTechnicsHelper.doPush(pushArgs, "sfc_manftech", manftechs);
        return targetBillObjs;
    }

    public static List<DynamicObject> pushOmBills(DynamicObject[] manftechs) {
        return OrderSplitTechnicsHelper.pushOmBills(manftechs, "sfc_manftech", "1622558870033496064");
    }

    public static List<DynamicObject> pushOmBills(DynamicObject[] manftechs, String srcManFtech, String ruleId) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(srcManFtech);
        pushArgs.setTargetEntityNumber("om_mfttechnics");
        pushArgs.setHasRight(false);
        pushArgs.setRuleId(ruleId);
        pushArgs.setBuildConvReport(true);
        List<DynamicObject> targetBillObjs = OrderSplitTechnicsHelper.doPush(pushArgs, "om_mfttechnics", manftechs);
        return targetBillObjs;
    }

    private static List<DynamicObject> doPush(PushArgs pushArgs, String entityKey, DynamicObject[] manftechs) {
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(10);
        for (DynamicObject manftech : manftechs) {
            ListSelectedRow srcBill = new ListSelectedRow(manftech.getPkValue());
            needPushRows.add(srcBill);
        }
        if (needPushRows.isEmpty()) {
            logger.info("\u5bf9\u5e94\u7684\u5de5\u5e8f\u8ba1\u5212\u6ca1\u6709\u9700\u8981\u4e0b\u63a8\u7684\u6570\u636e\u3002");
        }
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        StringBuilder errMessage = new StringBuilder().append(pushResult.getMessage());
        for (SourceBillReport billReport : pushResult.getBillReports()) {
            errMessage.append(billReport.getFailMessage());
        }
        if (null != errMessage && !"null".equals(errMessage.toString()) && !"".equals(errMessage.toString())) {
            logger.info("\u4e0b\u63a8\u5931\u8d25:" + errMessage);
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)entityKey);
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        return targetBillObjs;
    }
}

