/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import kd.bos.algo.DataType;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.threads.ThreadPools;

public class ProductCalendarSyncPlanCalendarHelper {
    private static final Log logger = LogFactory.getLog(ProductCalendarSyncPlanCalendarHelper.class);
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("bd-mpdm-business-syncplancalendar");
    private static final String MPDM_CALENDAR = "mpdm_calendar";
    private static final String MRP_PLANCALENDAR = "mrp_plancalendar";
    private static final String TYPE = "syncplancalendar";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> handleSyncPlanCalendar(Set<Long> ids) {
        ArrayList<String> errorInfos = new ArrayList<String>(10);
        HashSet<Long> newIds = new HashSet<Long>(ids);
        try {
            int batch = 10;
            List list = BFTrackerServiceHelper.loadTargetRowIds((String)MPDM_CALENDAR, (Long[])ids.toArray(new Long[0]), (OperateOption)OperateOption.create());
            HashMap<Long, Long> updateTarget2SourceIds = new HashMap<Long, Long>(list.size());
            for (BFRow bfRow : list) {
                BFRowId sourceRow = bfRow.getSId();
                BFRowId targetRow = bfRow.getId();
                TableDefine targetTable = ConvertMetaServiceHelper.loadTableDefine((Long)targetRow.getTableId());
                if (!MRP_PLANCALENDAR.equalsIgnoreCase(targetTable.getEntityNumber())) continue;
                ids.remove(sourceRow.getBillId());
                updateTarget2SourceIds.put(targetRow.getBillId(), sourceRow.getBillId());
            }
            list.clear();
            HashMap<Long, Boolean> org2sync = new HashMap<Long, Boolean>(2);
            Iterator<Long> itIds = ids.iterator();
            HashSet<Long> subIds = new HashSet<Long>(10);
            while (itIds.hasNext()) {
                subIds.clear();
                while (itIds.hasNext() && subIds.size() != 10) {
                    subIds.add(itIds.next());
                }
                ProductCalendarSyncPlanCalendarHelper.pushAndSavePlanCalendar(subIds, errorInfos, org2sync);
            }
            Iterator itUpdateIds = updateTarget2SourceIds.entrySet().iterator();
            HashMap<Long, Long> subUpdateIds = new HashMap<Long, Long>(10);
            HashSet<Long> subProCalendarIds = new HashSet<Long>(10);
            while (itUpdateIds.hasNext()) {
                subUpdateIds.clear();
                subProCalendarIds.clear();
                while (itUpdateIds.hasNext() && subUpdateIds.size() != 10) {
                    Map.Entry next = itUpdateIds.next();
                    subUpdateIds.put((Long)next.getKey(), (Long)next.getValue());
                    subProCalendarIds.add((Long)next.getValue());
                }
                ProductCalendarSyncPlanCalendarHelper.updatePlanCalendar(subUpdateIds, subProCalendarIds, errorInfos, org2sync);
            }
        }
        finally {
            for (Long id : newIds) {
                ProductCalendarSyncPlanCalendarHelper.removeCache(id.toString());
            }
        }
        return errorInfos;
    }

    private static void removeProCalendarByOrgSysParam(Set<Long> ids, Map<Object, DynamicObject> id2Calendar, Map<Long, Boolean> org2sync) {
        ids.removeIf(aLong -> {
            DynamicObject calendar = (DynamicObject)id2Calendar.get(aLong);
            if (calendar != null) {
                DynamicObject createorg = calendar.getDynamicObject("createorg");
                return !ProductCalendarSyncPlanCalendarHelper.isSyncPlanCalendar(createorg.getLong("id"), org2sync);
            }
            return true;
        });
    }

    private static void pushAndSavePlanCalendar(Set<Long> ids, List<String> errorInfos, Map<Long, Boolean> org2sync) {
        if (ids.isEmpty()) {
            return;
        }
        Map id2Calendar = BusinessDataServiceHelper.loadFromCache((String)MPDM_CALENDAR, (String)"id,number,name,isfault,createorg", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        ProductCalendarSyncPlanCalendarHelper.removeProCalendarByOrgSysParam(ids, id2Calendar, org2sync);
        if (ids.isEmpty()) {
            return;
        }
        ConvertRuleElement defaultConvRule = ProductCalendarSyncPlanCalendarHelper.getDefaultRules();
        if (defaultConvRule != null) {
            ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(ids.size());
            for (Long pk : ids) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue((Object)pk);
                selectedRows.add(row);
            }
            PushArgs args = new PushArgs();
            args.setSourceEntityNumber(MPDM_CALENDAR);
            args.setTargetEntityNumber(MRP_PLANCALENDAR);
            args.setRuleId(defaultConvRule.getId());
            args.setSelectedRows(selectedRows);
            ConvertOperationResult result = ConvertServiceHelper.pushAndSave((PushArgs)args);
            if (!result.isSuccess()) {
                StringBuilder error = new StringBuilder(result.getMessage());
                for (SourceBillReport billReport : result.getBillReports()) {
                    if (billReport.isFullSuccess()) continue;
                    Object billId = billReport.getBillId();
                    billId = DataType.convertValue((DataType)DataType.LongType, (Object)billId);
                    DynamicObject calendar = (DynamicObject)id2Calendar.get(billId);
                    error.append("\r\n");
                    error.append(String.format("proCalendar-name\u3010%s\u3011%s\u3002", calendar == null ? "null" : calendar.getString("name"), billReport.getFailMessage()));
                }
                logger.warn(String.format("ProductCalendarSyncPlanCalendar-pushError:%s", error.toString()));
                errorInfos.add(String.format("pushError:%s", error.toString()));
            }
        } else {
            String msg = String.format("convertRule-isempty,proCalendarIds:%s", ids.toString());
            logger.warn(String.format("ProductCalendarSyncPlanCalendar-%s", msg));
            errorInfos.add(msg);
        }
    }

    private static void updatePlanCalendar(Map<Long, Long> updateTarget2SourceIds, Set<Long> proCalendarIds, List<String> errorInfos, Map<Long, Boolean> org2sync) {
        if (updateTarget2SourceIds.isEmpty()) {
            return;
        }
        Map id2proCalendar = BusinessDataServiceHelper.loadFromCache((Object[])proCalendarIds.toArray(), (String)MPDM_CALENDAR);
        ProductCalendarSyncPlanCalendarHelper.removeProCalendarByOrgSysParam(proCalendarIds, id2proCalendar, org2sync);
        if (proCalendarIds.isEmpty()) {
            return;
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)MRP_PLANCALENDAR);
        DynamicObject[] updateDatas = BusinessDataServiceHelper.load((Object[])updateTarget2SourceIds.keySet().toArray(), (DynamicObjectType)mainEntityType);
        HashMap<Object, DynamicObject> id2PlanCalendar = new HashMap<Object, DynamicObject>(updateDatas.length);
        Long defaultCalendar = 0L;
        for (DynamicObject planCalendar : updateDatas) {
            id2PlanCalendar.put(planCalendar.getPkValue(), planCalendar);
            DynamicObject mpdmcalendar = planCalendar.getDynamicObject("mpdmcalendar");
            if (mpdmcalendar != null) {
                mpdmcalendar = id2proCalendar.getOrDefault(mpdmcalendar.getPkValue(), mpdmcalendar);
            } else {
                mpdmcalendar = (DynamicObject)id2proCalendar.get(updateTarget2SourceIds.getOrDefault(planCalendar.getLong("id"), 0L));
                planCalendar.set("mpdmcalendar", (Object)mpdmcalendar);
            }
            if (!proCalendarIds.contains(mpdmcalendar.getLong("id"))) continue;
            if (planCalendar.getBoolean("isfault")) {
                defaultCalendar = planCalendar.getLong("id");
            }
            planCalendar.set("status", (Object)"C");
            planCalendar.set("enable", (Object)"1");
            planCalendar.set("number", mpdmcalendar.get("number"));
            planCalendar.set("name", mpdmcalendar.get("name"));
            planCalendar.set("issunrest", mpdmcalendar.get("issunrest"));
            planCalendar.set("ismonrest", mpdmcalendar.get("ismonrest"));
            planCalendar.set("istuerest", mpdmcalendar.get("istuerest"));
            planCalendar.set("iswedrest", mpdmcalendar.get("iswedrest"));
            planCalendar.set("isthurest", mpdmcalendar.get("isthurest"));
            planCalendar.set("isfrirest", mpdmcalendar.get("isfrirest"));
            planCalendar.set("issatrest", mpdmcalendar.get("issatrest"));
            planCalendar.set("ishalfsunrest", mpdmcalendar.get("ishalfsunrest"));
            planCalendar.set("ishalfmonrest", mpdmcalendar.get("ishalfmonrest"));
            planCalendar.set("ishalftuerest", mpdmcalendar.get("ishalftuerest"));
            planCalendar.set("ishalfwedrest", mpdmcalendar.get("ishalfwedrest"));
            planCalendar.set("ishalfthurest", mpdmcalendar.get("ishalfthurest"));
            planCalendar.set("ishalffrirest", mpdmcalendar.get("ishalffrirest"));
            planCalendar.set("ishalfsatrest", mpdmcalendar.get("ishalfsatrest"));
            planCalendar.set("expiringyearfrom", mpdmcalendar.get("expiringyearfrom"));
            planCalendar.set("expiringmonthfrom", mpdmcalendar.get("expiringmonthfrom"));
            planCalendar.set("expiringyearto", mpdmcalendar.get("expiringyearto"));
            planCalendar.set("expiringmonthto", mpdmcalendar.get("expiringmonthto"));
            DynamicObjectCollection dateentry = planCalendar.getDynamicObjectCollection("dateentry");
            dateentry.clear();
            for (DynamicObject entry : mpdmcalendar.getDynamicObjectCollection("dateentry")) {
                DynamicObject newDateEntry = dateentry.addNew();
                newDateEntry.set("workdate", entry.get("workdate"));
                newDateEntry.set("datetype", entry.get("datetype"));
            }
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)MRP_PLANCALENDAR, (DynamicObject[])updateDatas, (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            StringBuilder error = new StringBuilder(result.getMessage());
            List allErrors = result.getAllErrorOrValidateInfo();
            HashSet successIds = new HashSet(result.getSuccessPkIds());
            if (allErrors != null) {
                for (IOperateInfo info : allErrors) {
                    Object pkValue = info.getPkValue();
                    if (pkValue == null || successIds.contains(pkValue)) continue;
                    pkValue = DataType.convertValue((DataType)DataType.LongType, (Object)pkValue);
                    DynamicObject calendar = (DynamicObject)id2PlanCalendar.get(pkValue);
                    error.append("\r\n");
                    error.append(String.format("planCalendar-name\u3010%s\u3011%s\u3002", calendar == null ? "null" : calendar.getString("name"), info.getMessage()));
                }
            }
            logger.warn(String.format("ProductCalendarSyncPlanCalendar-updatePlanCalendarError:%s", error.toString()));
            errorInfos.add(String.format("updatePlanCalendarError:%s", error.toString()));
        }
        if (defaultCalendar > 0L) {
            ProductCalendarSyncPlanCalendarHelper.setDefaultPlanCalendar(defaultCalendar);
        }
    }

    private static ConvertRuleElement getDefaultRules() {
        List rules = ConvertRuleCache.loadRules((String)MPDM_CALENDAR, (String)MRP_PLANCALENDAR);
        ArrayList<ConvertRuleElement> enableRules = new ArrayList<ConvertRuleElement>();
        for (ConvertRuleElement rule : rules) {
            if (!rule.isEnabled()) continue;
            enableRules.add(rule);
            if (!rule.isDefRule()) continue;
            return rule;
        }
        return enableRules.isEmpty() ? null : (ConvertRuleElement)enableRules.get(0);
    }

    private static boolean isSyncPlanCalendar(Long org, Map<Long, Boolean> org2sync) {
        return org2sync.computeIfAbsent(org, k -> {
            AppParam appParam = new AppParam("064+L=UVGI9P", org);
            Map fmmParam = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
            return fmmParam.containsKey("issyncplancalendar") && (Boolean)fmmParam.get("issyncplancalendar") != false;
        });
    }

    private static void setDefaultPlanCalendar(Long planCalendarId) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)MRP_PLANCALENDAR);
        DBRoute dbRoute = new DBRoute(mainEntityType.getDBRouteKey());
        String table = mainEntityType.getAlias();
        String updateSql = String.format("update %s set fisdefalt = '0' where fisdefalt = '1'", table);
        String updateDefaultSql = String.format("update %s set fisdefalt = '1', fstatus = 'C' , fenable = '1' where fid = ?", table);
        try (DLock lock = DLock.create((String)"bd/mpdm/procalendarsync");){
            lock.lock();
            try (TXHandle tx = TX.requiresNew((String)"ProCalendarSyncPlanCalendar.setDefault");){
                try {
                    DB.execute((DBRoute)dbRoute, (String)updateSql);
                    DB.execute((DBRoute)dbRoute, (String)updateDefaultSql, (Object[])new Object[]{planCalendarId});
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    public static void syncDefaultPlanCalendar(Long orgId, Long proCalendarId) {
        if (ProductCalendarSyncPlanCalendarHelper.isSyncPlanCalendar(orgId, new HashMap<Long, Boolean>())) {
            Timer timer = new Timer();
            SetDefaultCalendarTimer defaultCalendarTimer = new SetDefaultCalendarTimer(RequestContext.get(), timer, proCalendarId);
            timer.scheduleAtFixedRate((TimerTask)defaultCalendarTimer, 10L, 2000L);
        }
    }

    private static void syncDefaultPlanCalendarImpl(Long proCalendarId) {
        List list = BFTrackerServiceHelper.loadTargetRowIds((String)MPDM_CALENDAR, (Long[])new Long[]{proCalendarId}, (OperateOption)OperateOption.create());
        Long defaultPlanCalendar = 0L;
        for (BFRow bfRow : list) {
            BFRowId targetRow = bfRow.getId();
            TableDefine targetTable = ConvertMetaServiceHelper.loadTableDefine((Long)targetRow.getTableId());
            if (!MRP_PLANCALENDAR.equalsIgnoreCase(targetTable.getEntityNumber())) continue;
            defaultPlanCalendar = targetRow.getBillId();
        }
        if (defaultPlanCalendar > 0L) {
            ProductCalendarSyncPlanCalendarHelper.setDefaultPlanCalendar(defaultPlanCalendar);
        }
    }

    public static String getValue(String key) {
        return (String)cache.get(TYPE, key);
    }

    public static void putValue(String key, String value) {
        int timeoutSeconds = 3600;
        cache.put(TYPE, key, value, timeoutSeconds);
    }

    public static void removeCache(String key) {
        cache.remove(TYPE, key);
    }

    private static class SetDefaultCalendarTimer
    extends TimerTask {
        private RequestContext rc;
        private Timer timer;
        private Long proCalendarId;

        public SetDefaultCalendarTimer(RequestContext rc, Timer timer, Long proCalendarId) {
            this.rc = rc;
            this.timer = timer;
            this.proCalendarId = proCalendarId;
        }

        @Override
        public void run() {
            RequestContext.set((RequestContext)this.rc);
            String value = ProductCalendarSyncPlanCalendarHelper.getValue(this.proCalendarId.toString());
            if (!"1".equals(value)) {
                try {
                    ThreadPools.executeOnceIncludeRequestContext((String)"syncDefaultPlanCalendar", () -> ProductCalendarSyncPlanCalendarHelper.syncDefaultPlanCalendarImpl(this.proCalendarId));
                }
                finally {
                    this.cancel();
                    this.timer.cancel();
                }
            }
        }
    }
}

