/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.helper.auxpty;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.helper.auxpty.Auxpty;
import kd.bd.mpdm.business.helper.auxpty.CollectionUtil;
import kd.bd.mpdm.business.helper.auxpty.JsonUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class AuxptyProcessor {
    private static final Log logger = LogFactory.getLog(AuxptyProcessor.class);
    private static final String F_BD_MATERIAL = "bd_material";
    private static final String QUERY_MATERIAL_COLS = "id,isuseauxpty,auxptyentry,auxptyentry.auxpty.id,auxptyentry.iscomcontrol,auxptyentry.isaffectinv,auxptyentry.isaffectprice,auxptyentry.isaffectplan";
    private static final String F_BD_FLEXAUXPROP = "bd_flexauxprop";
    private static final String F_BD_AUXPROPERTY = "bd_auxproperty";

    public DynamicObjectCollection getUseAuxptyByMaterialId(long materialId) {
        QFilter filter = new QFilter("id", "=", (Object)materialId);
        filter.and("isuseauxpty", "=", (Object)"1");
        return QueryServiceHelper.query((String)F_BD_MATERIAL, (String)QUERY_MATERIAL_COLS, (QFilter[])filter.toArray());
    }

    public Auxpty getAuxptyName(long auxptyId) {
        LinkedHashMap<String, String> auxptyValueMap = this.getFlexAuxpropDataMap(auxptyId);
        return new Auxpty(String.valueOf(auxptyId), this.getFlexAuxpropDataName(auxptyValueMap));
    }

    public Map<Long, String> getAuxptyName(List<Long> auxptyIds) {
        Map<Long, String> auxptyValueMap = this.getFlexAuxpropDataMap(auxptyIds);
        return this.getFlexAuxpropDataNameList(auxptyValueMap);
    }

    public List<String> getAuxptyNameList(long auxptyId) {
        LinkedHashMap<String, String> auxptyValueMap = this.getFlexAuxpropDataMap(auxptyId);
        return this.getFlexAuxpropDataNameList(auxptyValueMap);
    }

    private Map<Long, String> getFlexAuxpropDataNameList(Map<Long, String> auxptyValueMap) {
        HashMap<Long, String> result = new HashMap<Long, String>();
        if (auxptyValueMap == null || auxptyValueMap.isEmpty()) {
            return result;
        }
        ArrayList<String> auxpties = new ArrayList<String>();
        for (Map.Entry<Long, String> auxptyValueEntry : auxptyValueMap.entrySet()) {
            LinkedHashMap values = JsonUtil.readValue(auxptyValueEntry.getValue(), LinkedHashMap.class);
            if (values == null || values.isEmpty()) continue;
            for (Map.Entry auxptyValue : values.entrySet()) {
                auxpties.add((String)auxptyValue.getKey());
            }
        }
        DynamicObjectCollection auxPropertyList = this.getAuxPropertyListByFlexfield(auxpties);
        Map<String, DynamicObject> flexValueMap = auxPropertyList.stream().collect(Collectors.toMap(k -> k.getString("flexfield"), v -> v, (r1, r2) -> r1));
        for (Map.Entry<Long, String> auxptyValueEntry : auxptyValueMap.entrySet()) {
            LinkedHashMap values = JsonUtil.readValue(auxptyValueEntry.getValue(), LinkedHashMap.class);
            if (values == null || values.isEmpty()) continue;
            ArrayList<DynamicObject> flexProperty = new ArrayList<DynamicObject>(values.size());
            for (Map.Entry value : values.entrySet()) {
                flexProperty.add(flexValueMap.get(value.getKey()));
            }
            List<String> nameList = this.getNameListByAuxPropertyList(flexProperty, values);
            if (nameList == null || nameList.size() <= 0) continue;
            result.put(auxptyValueEntry.getKey(), CollectionUtil.tranSet2String(nameList));
        }
        return result;
    }

    private List<String> getFlexAuxpropDataNameList(LinkedHashMap<String, String> auxptyValueMap) {
        if (auxptyValueMap == null || auxptyValueMap.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> auxpties = new ArrayList<String>(16);
        for (Map.Entry<String, String> auxptyValueEntry : auxptyValueMap.entrySet()) {
            auxpties.add(auxptyValueEntry.getKey());
        }
        DynamicObjectCollection auxPropertyList = this.getAuxPropertyListByFlexfield(auxpties);
        return this.getNameListByAuxPropertyList((List<DynamicObject>)auxPropertyList, auxptyValueMap);
    }

    private List<String> getNameListByAuxPropertyList(List<DynamicObject> auxPropertyList, LinkedHashMap<String, String> auxptyValueMap) {
        ArrayList<String> nameList = new ArrayList<String>(8);
        if (CollectionUtil.isNull(auxPropertyList) || auxptyValueMap == null || auxptyValueMap.isEmpty()) {
            return nameList;
        }
        for (DynamicObject auxProperty : auxPropertyList) {
            if (auxProperty == null) continue;
            String auxPropertyName = auxProperty.getString("name");
            String valueName = "";
            String valueType = auxProperty.getString("valuetype");
            String flexField = auxProperty.getString("flexfield");
            if ("3".equalsIgnoreCase(valueType)) {
                valueName = auxptyValueMap.get(flexField);
            } else {
                BasedataEntityType sourceType = null;
                if ("1".equalsIgnoreCase(valueType)) {
                    DynamicObject valueSource = auxProperty.getDynamicObject("valuesource");
                    sourceType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)valueSource.getString("number"));
                } else if ("2".equalsIgnoreCase(valueType)) {
                    sourceType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"bos_assistantdata_detail");
                }
                if (sourceType != null) {
                    QFilter filters = new QFilter("id", "=", (Object)auxptyValueMap.get(flexField));
                    DynamicObject dataEntity = this.getValueSource(sourceType.getName(), filters.toArray());
                    if (dataEntity != null) {
                        valueName = dataEntity.getString("name");
                    }
                }
            }
            nameList.add(String.format("%s:%s", auxPropertyName, valueName));
        }
        return nameList;
    }

    private String getFlexAuxpropDataName(LinkedHashMap<String, String> auxptyValueMap) {
        if (auxptyValueMap == null || auxptyValueMap.isEmpty()) {
            return "";
        }
        ArrayList<String> auxpties = new ArrayList<String>(16);
        for (Map.Entry<String, String> auxptyValueEntry : auxptyValueMap.entrySet()) {
            auxpties.add(auxptyValueEntry.getKey());
        }
        DynamicObjectCollection auxPropertyList = this.getAuxPropertyListByFlexfield(auxpties);
        List<String> nameList = this.getNameListByAuxPropertyList((List<DynamicObject>)auxPropertyList, auxptyValueMap);
        if (nameList == null || nameList.size() == 0) {
            return "";
        }
        return CollectionUtil.tranSet2String(nameList);
    }

    private DynamicObject getValueSource(String name, QFilter[] filters) {
        return ORM.create().queryOne(name, filters);
    }

    public DynamicObjectCollection getAuxPropertyListByFlexfield(List<String> auxpties) {
        QFilter apFilters = new QFilter("flexfield", "in", auxpties);
        return ORM.create().query(F_BD_AUXPROPERTY, apFilters.toArray());
    }

    public Map<Long, String> getFlexAuxpropDataMap(List<Long> auxptyIds) {
        QFilter filters = new QFilter("id", "in", auxptyIds);
        DynamicObjectCollection auxptyList = ORM.create().query(F_BD_FLEXAUXPROP, filters.toArray());
        if (auxptyList == null) {
            return new LinkedHashMap<Long, String>();
        }
        Map<Long, String> auxptyMap = auxptyList.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getString("value"), (r1, r2) -> r1));
        return auxptyMap;
    }

    public LinkedHashMap<String, String> getFlexAuxpropDataMap(long auxptyId) {
        QFilter filters = new QFilter("id", "=", (Object)auxptyId);
        DynamicObject auxpty = ORM.create().queryOne(F_BD_FLEXAUXPROP, filters.toArray());
        if (auxpty == null) {
            return new LinkedHashMap<String, String>();
        }
        return JsonUtil.readValue(auxpty.getString("value"), LinkedHashMap.class);
    }

    public DynamicObject getAuxptyDynamicObject(long auxptyId) {
        DynamicObject auxpty = null;
        try {
            auxpty = BusinessDataServiceHelper.loadSingle((Object)auxptyId, (String)F_BD_FLEXAUXPROP);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        return auxpty;
    }
}

