/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.lotmain;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.StreamSupport;
import kd.bd.mpdm.business.helper.SystemCallParamHelper;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import org.apache.commons.lang.StringUtils;

public class MftOrderSelectLotMain {
    private static final Log logger = LogFactory.getLog(MftOrderSelectLotMain.class);
    private static final String ENABLE_LOT_MAIN_FILE = "INV0003";
    private static final String SELECTLOT = "mpdm_selectlot";

    public static void showPageLotMainfileList(IFormPlugin form, IFormView view, IDataModel model, String entityNum) {
        if (MftOrderSelectLotMain.isUseLotMainFile()) {
            DynamicObject bill = model.getDataEntity();
            int rowIndex = model.getEntryCurrentRowIndex(entityNum);
            DynamicObject selectEntry = model.getEntryRowEntity(entityNum, rowIndex);
            String lotnumField = entityNum + "." + "batchno";
            String billtype = bill.getDataEntityType().getName();
            Set cfgDynamicObject = (Set)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getLotMainFileBillConfigByBillAndLotNum", (Object[])new Object[]{billtype, selectEntry.getDataEntityType().getName(), bill, lotnumField});
            if (cfgDynamicObject == null || cfgDynamicObject.size() == 0) {
                return;
            }
            String lotidfield = ((DynamicObject)new ArrayList(cfgDynamicObject).get(0)).getString("lotidfield");
            QFilter filter = (QFilter)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getLotMainfFileFilterByLotnum", (Object[])new Object[]{bill, selectEntry, lotnumField});
            HashMap<String, String> paramMap = new HashMap<String, String>(16);
            paramMap.put("formId", SELECTLOT);
            paramMap.put("lotidfield", lotidfield);
            paramMap.put("lotnumField", lotnumField);
            paramMap.put("filter", filter != null ? filter.toSerializedString() : null);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack(form, SELECTLOT));
            view.showForm(showParameter);
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u542f\u7528\u6279\u53f7\u4e3b\u6863\u3002", (String)"MftOrderSelectLotMain_0", (String)"bd-mpdm-business", (Object[])new Object[0]));
        }
    }

    public static void showPageLotMainfileListForBatchOp(IFormPlugin form, IFormView view, IDataModel model, String targetEntityName, String targetEntryName, String batchEntryName) {
        if (MftOrderSelectLotMain.isUseLotMainFile()) {
            int rowIndex = model.getEntryCurrentRowIndex(batchEntryName);
            DynamicObject selectBatchEntry = model.getEntryRowEntity(batchEntryName, rowIndex);
            MainEntityType targetMetaType = MetadataServiceHelper.getDataEntityType((String)targetEntityName);
            DynamicObject targetBill = BusinessDataServiceHelper.loadSingle((Object)selectBatchEntry.getLong("targetbillid"), (DynamicObjectType)targetMetaType);
            DynamicObjectCollection targetEntrys = targetBill.getDynamicObjectCollection(targetEntryName);
            DynamicObjectType targetEntryType = targetEntrys.getDynamicObjectType();
            Optional<DynamicObject> entryOption = targetEntrys.stream().filter(o -> o.getPkValue().toString().equals(selectBatchEntry.getPkValue().toString())).findFirst();
            DynamicObject selectEntry = entryOption.orElseGet(() -> ((DynamicObjectCollection)targetEntrys).addNew());
            targetEntryType.getProperties().forEach(prop -> {
                if (selectBatchEntry.containsProperty(prop.getName())) {
                    selectEntry.set(prop.getName(), selectBatchEntry.get(prop.getName()));
                }
            });
            String lotnumField = targetEntryName + "." + "batchno";
            Set cfgDynamicObject = (Set)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getLotMainFileBillConfigByBillAndLotNum", (Object[])new Object[]{targetEntityName, targetEntryName, targetBill, lotnumField});
            if (cfgDynamicObject == null || cfgDynamicObject.size() == 0) {
                return;
            }
            String lotidfield = ((DynamicObject)new ArrayList(cfgDynamicObject).get(0)).getString("lotidfield");
            QFilter filter = (QFilter)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getLotMainfFileFilterByLotnum", (Object[])new Object[]{targetBill, selectEntry, lotnumField});
            HashMap<String, String> paramMap = new HashMap<String, String>(16);
            paramMap.put("formId", SELECTLOT);
            paramMap.put("lotidfield", lotidfield);
            paramMap.put("lotnumField", lotnumField);
            paramMap.put("filter", filter != null ? filter.toSerializedString() : null);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack(form, SELECTLOT));
            view.showForm(showParameter);
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u542f\u7528\u6279\u53f7\u4e3b\u6863\u3002", (String)"MftOrderSelectLotMain_0", (String)"bd-mpdm-business", (Object[])new Object[0]));
        }
    }

    public static boolean isUseLotMainFile() {
        return SystemCallParamHelper.isEnable("sbs_scmcapplevelparam", ENABLE_LOT_MAIN_FILE);
    }

    public static void matchBillLotId(DynamicObject[] bills, String operate, String entityName) {
        if (bills == null || bills.length == 0) {
            return;
        }
        String billtype = null;
        int billsize = bills.length;
        ArrayList<Long> billids = new ArrayList<Long>(billsize);
        boolean dirtyflag = false;
        DynamicObject billSingle = null;
        for (DynamicObject bill : bills) {
            if (billtype == null) {
                billtype = bill.getDynamicObjectType().getName();
                boolean isFromDataBase = bill.getDataEntityState().getFromDatabase();
                billSingle = bill;
                if (!isFromDataBase) {
                    dirtyflag = true;
                }
                if (billsize == 1 && MftOrderSelectLotMain.checkDirtyFlag(bill, false, entityName)) {
                    dirtyflag = true;
                }
            }
            Long billid = (Long)bill.getPkValue();
            billids.add(billid);
        }
        Map allLotMatchMap = dirtyflag ? (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"genLotBySingleOperate", (Object[])new Object[]{billtype, operate, billSingle}) : (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"genLotByOperate", (Object[])new Object[]{billtype, operate, billids});
        if (!allLotMatchMap.isEmpty()) {
            HashMap<String, Map<String, List<String>>> errBillsMap = new HashMap<String, Map<String, List<String>>>();
            Map<Object, DynamicObject> lotDynamicObjects = MftOrderSelectLotMain.getLotDynamicObjects(billsize, allLotMatchMap);
            for (DynamicObject bill : bills) {
                String billno = bill.getString("billno");
                if (!allLotMatchMap.containsKey(billno)) continue;
                Map billMatchMap = (Map)allLotMatchMap.get(billno);
                DynamicObjectCollection billentries = bill.getDynamicObjectCollection(entityName);
                for (DynamicObject billentry : billentries) {
                    Set<String> errCols;
                    String billentrykey = entityName + '.' + billentry.get("seq");
                    DynamicObject materielinv = billentry.getDynamicObject("materielinv");
                    if (materielinv == null || !materielinv.getBoolean("enablelot") || !StringUtils.isNotBlank((String)billentry.getString("batchno")) || (errCols = MftOrderSelectLotMain.setEntryLotidByMatch(billentry, billMatchMap, billentrykey, lotDynamicObjects)).isEmpty()) continue;
                    MftOrderSelectLotMain.assembErrMap(errBillsMap, billno, billentry, null);
                }
            }
            if (!errBillsMap.isEmpty()) {
                MftOrderSelectLotMain.showMatchErrmsg(errBillsMap, billtype);
            }
        }
    }

    private static void showMatchErrmsg(Map<String, Map<String, List<String>>> errBillsMap, String billtype) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billtype);
        Map entrytypes = mainEntityType.getAllEntities();
        StringBuilder errEntryMsgBuilder = new StringBuilder();
        for (Map.Entry<String, Map<String, List<String>>> errBillsEntry : errBillsMap.entrySet()) {
            String billno = errBillsEntry.getKey();
            errEntryMsgBuilder.append(billno);
            Map<String, List<String>> errEntriesMap = errBillsEntry.getValue();
            for (Map.Entry<String, List<String>> errEntry : errEntriesMap.entrySet()) {
                String entrytype = errEntry.getKey();
                String entryname = ((EntityType)entrytypes.get(entrytype)).getDisplayName().getLocaleValue();
                errEntryMsgBuilder.append(entryname).append(ResManager.loadKDString((String)"\u7b2c", (String)"MftOrderSelectLotMain_1", (String)"bd-mpdm-business", (Object[])new Object[0])).append(errEntry.getValue()).append(ResManager.loadKDString((String)"\u884c.", (String)"MftOrderSelectLotMain_2", (String)"bd-mpdm-business", (Object[])new Object[0]));
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5355\u636e\u5206\u5f55\u7684\u6279\u53f7\u5df2\u5b58\u5728\uff0c\u4f46\u7269\u6599\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\uff1a%1$s", (String)"MftOrderSelectLotMain_4", (String)"bd-mpdm-business", (Object[])new Object[0]), errEntryMsgBuilder.toString()));
    }

    private static void assembErrMap(Map<String, Map<String, List<String>>> errBillsMap, String billno, DynamicObject billentry, String parantSeq) {
        String seq = String.valueOf(billentry.getInt("seq"));
        String entrytype = billentry.getDataEntityType().getName();
        Map errEntriesMap = errBillsMap.getOrDefault(billno, new HashMap());
        List errEntries = errEntriesMap.getOrDefault(entrytype, new ArrayList());
        if (parantSeq != null) {
            errEntries.add(parantSeq + '-' + seq);
        } else {
            errEntries.add(seq);
        }
        if (!errEntriesMap.containsKey(entrytype)) {
            errEntriesMap.put(entrytype, errEntries);
        }
        if (!errBillsMap.containsKey(billno)) {
            errBillsMap.put(billno, errEntriesMap);
        }
    }

    private static Set<String> setEntryLotidByMatch(DynamicObject billentry, Map<String, Map<String, Long>> billMatchMap, String billentrykey, Map<Object, DynamicObject> objectMap) {
        if (billMatchMap.containsKey(billentrykey)) {
            HashSet<String> errCols = new HashSet<String>();
            Map<String, Long> billentryMatchMap = billMatchMap.get(billentrykey);
            for (Map.Entry<String, Long> billentryMatchEntry : billentryMatchMap.entrySet()) {
                String lotidcol = billentryMatchEntry.getKey();
                Long lotid = billentryMatchEntry.getValue();
                if (lotid > 0L) {
                    DynamicObject lotDynamicObject = objectMap.get(lotid);
                    if (lotDynamicObject != null) {
                        billentry.set(lotidcol, (Object)lotDynamicObject);
                        continue;
                    }
                    billentry.set(lotidcol, (Object)lotid);
                    continue;
                }
                if (lotid >= 0L) continue;
                errCols.add(lotidcol);
            }
            return errCols;
        }
        return Collections.emptySet();
    }

    private static boolean checkDirtyFlag(DynamicObject bill, boolean isHasSubEntry, String entityName) {
        String id_suf = "_id";
        HashSet headColumns = Sets.newHashSet((Object[])new String[]{"org", "transactiontype", "transactiontypeid", "org" + id_suf, "transactiontype" + id_suf, "transactiontypeid" + id_suf});
        HashSet entryColumns = Sets.newHashSet((Object[])new String[]{"material", "batchno", "lot", "supplyorgid", "inwardept", "materialid", "material" + id_suf, "lot_id", "supplyorgid" + id_suf, "inwardept" + id_suf, "materialid" + id_suf});
        DataEntityState state = bill.getDataEntityState();
        long dirtySize = StreamSupport.stream(state.getBizChangedProperties().spliterator(), false).filter(dirtyProp -> headColumns.contains(dirtyProp.getName())).count();
        if (dirtySize > 0L || state.getRemovedItems().booleanValue()) {
            return true;
        }
        DynamicObjectCollection billentries = bill.getDynamicObjectCollection(entityName);
        for (DynamicObject billentry : billentries) {
            state = billentry.getDataEntityState();
            dirtySize = StreamSupport.stream(state.getBizChangedProperties().spliterator(), false).filter(dirtyProp -> entryColumns.contains(dirtyProp.getName())).count();
            if (dirtySize <= 0L && !state.getRemovedItems().booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static Map<Object, DynamicObject> getLotDynamicObjects(int billsize, Map<String, Map<String, Map<String, Long>>> allLotMatchMap) {
        if (billsize == 1) {
            HashSet<Long> lotids = new HashSet<Long>();
            for (Map<String, Map<String, Long>> billMatchMap : allLotMatchMap.values()) {
                for (Map<String, Long> billentryMatchMap : billMatchMap.values()) {
                    for (Long lotid : billentryMatchMap.values()) {
                        if (lotid <= 0L) continue;
                        lotids.add(lotid);
                    }
                }
            }
            if (!lotids.isEmpty()) {
                return BusinessDataServiceHelper.loadFromCache((String)"bd_lot", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", lotids)});
            }
            return Maps.newHashMap();
        }
        return Maps.newHashMap();
    }
}

