/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.mftcommon.impl;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.mftcommon.IMftCommonBusiness;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;

public class MftCommonBusinessImpl
implements IMftCommonBusiness {
    private static final Log logger = LogFactory.getLog(MftCommonBusinessImpl.class);
    public static final String MFTORDER_ENTITY_NUMBER = "pom_mftorder";
    public static final String MFTORDER_ENTRYENTITY_NUMBER = "treeentryentity";
    public static final String MFTSTOCK_ENTITY_NUMBER = "pom_mftstock";
    public static final String MFTSTOCK_ENTRY_NUMBER = "stockentry";
    public static final String MANUINBILL_ENTITY_NUMBER = "im_mdc_mftmanuinbill";
    public static final String MANUINBILL_ENTRY_NUMBER = "billentry";
    public static final String MFTPROORDER_ENTITY_NUMBER = "im_mdc_mftproorder";
    public static final String MFTPROORDER_ENTRY_NUMBER = "billentry";
    public static final String ORDERREPORT_ENTITY_NUMBER = "pom_mftorderreport";
    public static final String ORDERREPORT_SUMENTRY_NUMBER = "sumentry";
    public static final String ORDERREPORT_REPORTENTRY_NUMBER = "childreportentity";
    public static final String SFCREPORT_ENTITY_NUMBER = "sfc_processreportbill";
    public static final String SFCREPORT_SUMENTRY_NUMBER = "sumentry";
    public static final String SFCREPORT_REPORTENTRY_NUMBER = "childreportentity";
    public static final String MANUFTECH_ENTITY_NUMBER = "sfc_manftech";
    public static final String MANUFTECH_OPERENTRY_NUMBER = "oprentryentity";
    public static final String MATERIAL_ENTITY_NUMBER = "bd_material";
    public static final String MFTRETURNORDER_ENTITY_NUMBER = "im_mdc_mftreturnorder";
    public static final String MFTRETURNORDER_ENTRY_NUMBER = "billentry";
    public static final String MATERIALNUMBER_PARAMNUMBER = "materialnumber";
    public static final String INQTY_PARAMNUMBER = "inqty";
    public static final String OUTQTY_PARAMNUMBER = "outqty";
    public static final String WAREHOUSENUMBER_PARAMNUMBER = "warehousenumber";
    public static final String LOCATIONNUMBER_PARAMNUMBER = "locationnumber";
    public static final String OPRNO_PARAMNUMBER = "oprno";
    public static final String PROCESSSEQ_PARAMNUMBER = "processseq";
    public static final String CONFIGUREDCODE_PARAMNUMBER = "configuredcode";
    public static final String ORDERBILLNO_PARAMNUMBER = "orderbillno";
    public static final String COMPLETQTY_PARAMNUMBER = "completqty";
    public static final String QUALIFYQTY_PARAMNUMBER = "qualifyqty";
    public static final String CONCESIONQTY_PARAMNUMBER = "concesionqty";
    public static final String WORKWASTEQTY_PARAMNUMBER = "workwasteqty";
    public static final String SCRAPQTY_PARAMNUMBER = "scrapqty";
    public static final String REPAIRQTY_PARAMNUMBER = "repairqty";
    public static final String REWORKQTY_PARAMNUMBER = "reworkqty";
    public static final String RECEIVEQTY_PARAMNUMBER = "receiveqty";
    public static final String USERNO_PARAMNUMBER = "userno";
    public static final String QTYFIELD_PARAMNUMBER = "qtyfield";
    public static final String PROPORTION_PARAMNUMBER = "proportion";
    public static final String PROCESSACTIVITY_PARAMNUMBER = "repactivity";
    public static final String REPRESOURCES_PARAMNUMBER = "represources";
    public static final String ACTSTANDARDFORMULA_PARAMNUMBER = "actstandardformula";
    public static final String REPBASEQTY_PARAMNUMBER = "repbaseqty";
    public static final String REPACTUALQTY_PARAMNUMBER = "repactualqty";
    public static final String REPACTUALBEGINTIME_PARAMNUMBER = "repactualbegintime";
    public static final String REPACTUALFINISHTIME_PARAMNUMBER = "repactualfinishtime";
    public static final BigDecimal ZERO = new BigDecimal(0);

    @Override
    public Map<String, Object> genReturnMap(String errorString, Boolean success, String errorcode) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("success", success);
        resultMap.put("message", errorString);
        resultMap.put("errorcode", errorcode);
        return resultMap;
    }

    public Set<Long> getOrderID(String orderBillno) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        String selectFields = "id";
        QFilter qFilter = new QFilter("billno", "=", (Object)orderBillno);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-MftCommonBusinessInterfaceImpl-getOrderID", (String)MFTORDER_ENTITY_NUMBER, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            for (Row row : ds) {
                idSet.add(row.getLong("id"));
            }
        }
        return idSet;
    }

    public Set<Long> getOrderReportID(String reportBillno) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        String selectFields = "id";
        QFilter qFilter = new QFilter("billno", "=", (Object)reportBillno);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-MftCommonBusinessInterfaceImpl-getOrderReportID", (String)ORDERREPORT_ENTITY_NUMBER, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            for (Row row : ds) {
                idSet.add(row.getLong("id"));
            }
        }
        return idSet;
    }

    public Set<Long> getProcessReportID(String reportBillno) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        String selectFields = "id";
        QFilter qFilter = new QFilter("billno", "=", (Object)reportBillno);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-MftCommonBusinessInterfaceImpl-getProcessReportID", (String)SFCREPORT_ENTITY_NUMBER, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            for (Row row : ds) {
                idSet.add(row.getLong("id"));
            }
        }
        return idSet;
    }

    public Map<Long, Map<String, Object>> getOrderEntryData(Long orderID) {
        HashMap<Long, Map<String, Object>> orderEntryMap = new HashMap<Long, Map<String, Object>>(16);
        String selectFields = "treeentryentity.id entryid,treeentryentity.material.id materialmftid,treeentryentity.materielmasterid materialid,treeentryentity.qty qty";
        QFilter qFilter = new QFilter("id", "=", (Object)orderID);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-MftCommonBusinessInterfaceImpl-getOrderEntryData", (String)MFTORDER_ENTITY_NUMBER, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            for (Row row : ds) {
                Long entryid = row.getLong("entryid");
                Long materialmftid = row.getLong("materialmftid");
                Long materialid = row.getLong("materialid");
                BigDecimal qty = row.getBigDecimal("qty");
                HashMap<String, Number> dataMap = new HashMap<String, Number>(16);
                dataMap.put("entryid", entryid);
                dataMap.put("materialmftid", materialmftid);
                dataMap.put("materialid", materialid);
                dataMap.put("qty", qty);
                orderEntryMap.put(materialid, dataMap);
            }
        }
        return orderEntryMap;
    }

    public Map<Long, Map<String, Object>> getOrderReportEntryData(Long reportID) {
        HashMap<Long, Map<String, Object>> orderEntryMap = new HashMap<Long, Map<String, Object>>(16);
        String selectFields = "sumentry.id entryid,sumentry.material.id materialmftid,sumentry.material.masterid materialid,sumentry.completqty qty";
        QFilter qFilter = new QFilter("id", "=", (Object)reportID);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-MftCommonBusinessInterfaceImpl-getOrderReportEntryData", (String)ORDERREPORT_ENTITY_NUMBER, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            for (Row row : ds) {
                Long entryid = row.getLong("entryid");
                Long materialmftid = row.getLong("materialmftid");
                Long materialid = row.getLong("materialid");
                BigDecimal qty = row.getBigDecimal("qty");
                HashMap<String, Number> dataMap = new HashMap<String, Number>(16);
                dataMap.put("entryid", entryid);
                dataMap.put("materialmftid", materialmftid);
                dataMap.put("materialid", materialid);
                dataMap.put("qty", qty);
                orderEntryMap.put(materialid, dataMap);
            }
        }
        return orderEntryMap;
    }

    public Map<Long, Map<String, Object>> getSfcReportEntryData(Long reportID) {
        HashMap<Long, Map<String, Object>> orderEntryMap = new HashMap<Long, Map<String, Object>>(16);
        String selectFields = "sumentry.id entryid,sumentry.material.id materialmftid,sumentry.material.masterid materialid,sumentry.completqty qty";
        QFilter qFilter = new QFilter("id", "=", (Object)reportID);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-MftCommonBusinessInterfaceImpl-getSfcReportEntryData", (String)SFCREPORT_ENTITY_NUMBER, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            for (Row row : ds) {
                Long entryid = row.getLong("entryid");
                Long materialmftid = row.getLong("materialmftid");
                Long materialid = row.getLong("materialid");
                BigDecimal qty = row.getBigDecimal("qty");
                HashMap<String, Number> dataMap = new HashMap<String, Number>(16);
                dataMap.put("entryid", entryid);
                dataMap.put("materialmftid", materialmftid);
                dataMap.put("materialid", materialid);
                dataMap.put("qty", qty);
                orderEntryMap.put(materialid, dataMap);
            }
        }
        return orderEntryMap;
    }

    public Set<Long> getMftProOrderID(String billno) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        String selectFields = "id";
        QFilter qFilter = new QFilter("billno", "=", (Object)billno);
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-MftCommonBusinessInterfaceImpl-getMftProOrderID", (String)MFTPROORDER_ENTITY_NUMBER, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            for (Row row : ds) {
                idSet.add(row.getLong("id"));
            }
        }
        return idSet;
    }

    public Map<String, List<Map<String, Object>>> getMftProOrderEntryData(Long id) {
        HashMap<String, List<Map<String, Object>>> entryDataMap = new HashMap<String, List<Map<String, Object>>>(16);
        String selectFields = "id,billentry.id entryid,billentry.materialmasterid materialid,billentry.qty qty ,billentry.oprno oprno,billentry.processseq processseq,billentry.configuredcode configuredcodeid,billentry.manubill orderbillno ";
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-MftCommonBusinessInterfaceImpl-getMftProOrderEntryData", (String)MFTPROORDER_ENTITY_NUMBER, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            for (Row row : ds) {
                Long entryid = row.getLong("entryid");
                Long materialid = row.getLong("materialid");
                BigDecimal qty = row.getBigDecimal("qty");
                String oprno = row.getString(OPRNO_PARAMNUMBER);
                String processseq = row.getString(PROCESSSEQ_PARAMNUMBER);
                Long configuredcodeid = row.getLong("configuredcodeid");
                String orderbillno = row.getString(ORDERBILLNO_PARAMNUMBER);
                HashMap<String, Number> dataMap = new HashMap<String, Number>(16);
                dataMap.put("entryid", entryid);
                dataMap.put("materialid", materialid);
                dataMap.put("qty", qty);
                dataMap.put("id", id);
                String keyString = this.getMftProOrderObjKeys(materialid, oprno, processseq, configuredcodeid, orderbillno);
                ArrayList dataList = (ArrayList)entryDataMap.get(keyString);
                if (dataList == null) {
                    dataList = new ArrayList(16);
                }
                dataList.add(dataMap);
                entryDataMap.put(keyString, dataList);
            }
        }
        return entryDataMap;
    }

    public Map<String, List<Map<String, Object>>> getStockData(String orderno) {
        HashMap<String, List<Map<String, Object>>> stockDataMap = new HashMap<String, List<Map<String, Object>>>(16);
        String selectFields = "id,stockentry.id entryid,stockentry.materialid.id materialmftid,stockentry.materielmasterid materialid,stockentry.demandqty qty ,stockentry.oprno oprno,stockentry.processseq processseq,stockentry.entryconfiguredcode configuredcodeid ";
        QFilter qFilter = new QFilter("orderno", "=", (Object)orderno);
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-MftCommonBusinessInterfaceImpl-getOrderEntryData", (String)MFTSTOCK_ENTITY_NUMBER, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            for (Row row : ds) {
                Long id = row.getLong("id");
                Long entryid = row.getLong("entryid");
                Long materialmftid = row.getLong("materialmftid");
                Long materialid = row.getLong("materialid");
                BigDecimal qty = row.getBigDecimal("qty");
                String oprno = row.getString(OPRNO_PARAMNUMBER);
                String processseq = row.getString(PROCESSSEQ_PARAMNUMBER);
                Long configuredcodeid = row.getLong("configuredcodeid");
                HashMap<String, Number> dataMap = new HashMap<String, Number>(16);
                dataMap.put("entryid", entryid);
                dataMap.put("materialmftid", materialmftid);
                dataMap.put("materialid", materialid);
                dataMap.put("qty", qty);
                dataMap.put("id", id);
                String keyString = this.getObjKeys(materialid, oprno, processseq, configuredcodeid);
                ArrayList dataList = (ArrayList)stockDataMap.get(keyString);
                if (dataList == null) {
                    dataList = new ArrayList(16);
                }
                dataList.add(dataMap);
                stockDataMap.put(keyString, dataList);
            }
        }
        return stockDataMap;
    }

    public String getMftProOrderObjKeys(Object materialid, Object oprno, Object processseq, Object configuredcodeid, Object orderbillno) {
        StringBuilder bf = new StringBuilder();
        bf.append(materialid == null ? "" : materialid.toString());
        bf.append('_');
        bf.append(orderbillno == null ? "" : orderbillno.toString());
        bf.append('_');
        bf.append(oprno == null ? "" : oprno.toString());
        bf.append('_');
        bf.append(processseq == null ? "" : processseq.toString());
        bf.append('_');
        bf.append(configuredcodeid == null || "".equals(configuredcodeid) ? "0" : configuredcodeid.toString());
        return bf.toString();
    }

    public String getObjKeys(Object materialid, Object oprno, Object processseq, Object configuredcodeid) {
        StringBuilder bf = new StringBuilder();
        bf.append(materialid == null ? "" : materialid.toString());
        bf.append('_');
        bf.append(oprno == null ? "" : oprno.toString());
        bf.append('_');
        bf.append(processseq == null ? "" : processseq.toString());
        bf.append('_');
        bf.append(configuredcodeid == null || "".equals(configuredcodeid) ? "0" : configuredcodeid.toString());
        return bf.toString();
    }

    public Map<String, Long> getMaterialID(Set<String> materialNumberSet) {
        HashMap<String, Long> returnMap = new HashMap<String, Long>(materialNumberSet.size());
        String selectFields = "id,number";
        QFilter qFilter = new QFilter("number", "in", materialNumberSet);
        Map dsMap = BusinessDataServiceHelper.loadFromCache((String)MATERIAL_ENTITY_NUMBER, (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        for (Map.Entry entrys : dsMap.entrySet()) {
            returnMap.put(((DynamicObject)entrys.getValue()).getString("number"), ((DynamicObject)entrys.getValue()).getLong("id"));
        }
        return returnMap;
    }

    public PushArgs genPushArgs(String sourceEntity, String targetEntity, String botpID) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(sourceEntity);
        pushArgs.setTargetEntityNumber(targetEntity);
        pushArgs.setHasRight(false);
        if (!StringUtils.isEmpty((String)botpID) && !"0".equals(botpID)) {
            pushArgs.setRuleId(botpID);
        } else {
            String commonBotpID = this.getCommonBotpID(sourceEntity, targetEntity);
            if (!StringUtils.isEmpty((String)commonBotpID) && !"0".equals(commonBotpID)) {
                pushArgs.setRuleId(commonBotpID);
            }
        }
        pushArgs.setBuildConvReport(true);
        return pushArgs;
    }

    public String getErrByRes(ConvertOperationResult pushResult) {
        StringBuilder errMessage = new StringBuilder().append(pushResult.getMessage());
        for (SourceBillReport billReport : pushResult.getBillReports()) {
            if (billReport.isFullSuccess()) continue;
            errMessage.append(billReport.getFailMessage());
        }
        return errMessage.toString();
    }

    public String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        errDetail.append(optResult.getMessage());
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            errDetail.append(errInfo.getMessage());
        }
        return errDetail.toString();
    }

    public String getMaterialNumber(Map<String, Object> dataMap) {
        return dataMap.get(MATERIALNUMBER_PARAMNUMBER) == null ? "" : dataMap.get(MATERIALNUMBER_PARAMNUMBER).toString();
    }

    public String getOprNo(Map<String, Object> dataMap) {
        return dataMap.get(OPRNO_PARAMNUMBER) == null ? "" : dataMap.get(OPRNO_PARAMNUMBER).toString();
    }

    public String getProcessSeq(Map<String, Object> dataMap) {
        return dataMap.get(PROCESSSEQ_PARAMNUMBER) == null ? "" : dataMap.get(PROCESSSEQ_PARAMNUMBER).toString();
    }

    public String getOrderBillNo(Map<String, Object> dataMap) {
        return dataMap.get(ORDERBILLNO_PARAMNUMBER) == null ? "" : dataMap.get(ORDERBILLNO_PARAMNUMBER).toString();
    }

    public BigDecimal getInQty(Map<String, Object> dataMap) {
        if (dataMap.get(INQTY_PARAMNUMBER) == null) {
            return ZERO;
        }
        return new BigDecimal(dataMap.get(INQTY_PARAMNUMBER).toString());
    }

    public BigDecimal getOutQty(Map<String, Object> dataMap) {
        if (dataMap.get(OUTQTY_PARAMNUMBER) == null) {
            return ZERO;
        }
        return new BigDecimal(dataMap.get(OUTQTY_PARAMNUMBER).toString());
    }

    public BigDecimal getCompletQty(Map<String, Object> dataMap) {
        if (dataMap.get(COMPLETQTY_PARAMNUMBER) == null) {
            return ZERO;
        }
        return new BigDecimal(dataMap.get(COMPLETQTY_PARAMNUMBER).toString());
    }

    public BigDecimal getQualifyQty(Map<String, Object> dataMap) {
        if (dataMap.get(QUALIFYQTY_PARAMNUMBER) == null) {
            return ZERO;
        }
        return new BigDecimal(dataMap.get(QUALIFYQTY_PARAMNUMBER).toString());
    }

    public BigDecimal getWorkWasteqty(Map<String, Object> dataMap) {
        if (dataMap.get(WORKWASTEQTY_PARAMNUMBER) == null) {
            return ZERO;
        }
        return new BigDecimal(dataMap.get(WORKWASTEQTY_PARAMNUMBER).toString());
    }

    public BigDecimal getScrapQty(Map<String, Object> dataMap) {
        if (dataMap.get(SCRAPQTY_PARAMNUMBER) == null) {
            return ZERO;
        }
        return new BigDecimal(dataMap.get(SCRAPQTY_PARAMNUMBER).toString());
    }

    public BigDecimal getConcesionQty(Map<String, Object> dataMap) {
        if (dataMap.get(CONCESIONQTY_PARAMNUMBER) == null) {
            return ZERO;
        }
        return new BigDecimal(dataMap.get(CONCESIONQTY_PARAMNUMBER).toString());
    }

    public BigDecimal getReceiveQty(Map<String, Object> dataMap) {
        if (dataMap.get(RECEIVEQTY_PARAMNUMBER) == null) {
            return ZERO;
        }
        return new BigDecimal(dataMap.get(RECEIVEQTY_PARAMNUMBER).toString());
    }

    public BigDecimal getRepairQty(Map<String, Object> dataMap) {
        if (dataMap.get(REPAIRQTY_PARAMNUMBER) == null) {
            return ZERO;
        }
        return new BigDecimal(dataMap.get(REPAIRQTY_PARAMNUMBER).toString());
    }

    public BigDecimal getReworkQty(Map<String, Object> dataMap) {
        if (dataMap.get(REWORKQTY_PARAMNUMBER) == null) {
            return ZERO;
        }
        return new BigDecimal(dataMap.get(REWORKQTY_PARAMNUMBER).toString());
    }

    public DynamicObject getWarehouse(Map<String, Object> dataMap) {
        Object warehouseNumberObj = dataMap.get(WAREHOUSENUMBER_PARAMNUMBER);
        if (warehouseNumberObj == null || "".equals(warehouseNumberObj.toString())) {
            return null;
        }
        QFilter qFilter = new QFilter("number", "=", (Object)warehouseNumberObj.toString());
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_warehouse", (QFilter[])new QFilter[]{qFilter});
    }

    public DynamicObject getLocation(Map<String, Object> dataMap) {
        Object locationNumberObj = dataMap.get(LOCATIONNUMBER_PARAMNUMBER);
        if (locationNumberObj == null || "".equals(locationNumberObj.toString())) {
            return null;
        }
        String selectFields = "id,number";
        QFilter qFilter = new QFilter("number", "=", (Object)locationNumberObj.toString());
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_location", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }

    public DynamicObject getManuPerson(Map<String, Object> dataMap) {
        Object userNumberObj = dataMap.get(USERNO_PARAMNUMBER);
        if (userNumberObj == null || "".equals(userNumberObj.toString())) {
            return null;
        }
        String selectFields = "id,number";
        QFilter qFilter = new QFilter("number", "=", (Object)userNumberObj.toString());
        return BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_manuperson", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }

    public DynamicObject getRepactivity(Map<String, Object> dataMap) {
        Object processActivityObj = dataMap.get(PROCESSACTIVITY_PARAMNUMBER);
        if (processActivityObj == null || "".equals(processActivityObj.toString())) {
            return null;
        }
        String selectFields = "id,number";
        QFilter qFilter = new QFilter("number", "=", (Object)processActivityObj.toString());
        return BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_processactivity", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }

    public DynamicObject getRepresources(Map<String, Object> dataMap) {
        Object repreSourcesObj = dataMap.get(REPRESOURCES_PARAMNUMBER);
        if (repreSourcesObj == null || "".equals(repreSourcesObj.toString())) {
            return null;
        }
        String selectFields = "id,number";
        QFilter qFilter = new QFilter("number", "=", (Object)repreSourcesObj.toString());
        return BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_resources", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }

    public DynamicObject getActstandardformula(Map<String, Object> dataMap) {
        Object actStandardFormulaObj = dataMap.get(ACTSTANDARDFORMULA_PARAMNUMBER);
        if (actStandardFormulaObj == null || "".equals(actStandardFormulaObj.toString())) {
            return null;
        }
        String selectFields = "id,number";
        QFilter qFilter = new QFilter("number", "=", (Object)actStandardFormulaObj.toString());
        return BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_processformula", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }

    public DynamicObject getConfiguredCode(Map<String, Object> dataMap) {
        Object configuredCodeObj = dataMap.get(CONFIGUREDCODE_PARAMNUMBER);
        if (configuredCodeObj == null || "".equals(configuredCodeObj.toString())) {
            return null;
        }
        String selectFields = "id,number";
        QFilter qFilter = new QFilter("number", "=", (Object)configuredCodeObj.toString());
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_configuredcode", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }

    public Long getConfiguredCodeID(Map<String, Object> dataMap) {
        Object configuredCodeObj = dataMap.get(CONFIGUREDCODE_PARAMNUMBER);
        if (configuredCodeObj == null || "".equals(configuredCodeObj.toString())) {
            return 0L;
        }
        String selectFields = "id,number";
        QFilter qFilter = new QFilter("number", "=", (Object)configuredCodeObj.toString());
        DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_configuredcode", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        if (dy == null) {
            return 0L;
        }
        return dy.getLong("id");
    }

    public BigDecimal getPersonQtyField(Map<String, Object> dataMap) {
        if (dataMap.get(QTYFIELD_PARAMNUMBER) == null) {
            return ZERO;
        }
        return new BigDecimal(dataMap.get(QTYFIELD_PARAMNUMBER).toString());
    }

    public BigDecimal getPersonProption(Map<String, Object> dataMap) {
        if (dataMap.get(PROPORTION_PARAMNUMBER) == null) {
            return ZERO;
        }
        return new BigDecimal(dataMap.get(PROPORTION_PARAMNUMBER).toString());
    }

    public BigDecimal getRepbaseqty(Map<String, Object> dataMap) {
        if (dataMap.get(REPBASEQTY_PARAMNUMBER) == null) {
            return ZERO;
        }
        return new BigDecimal(dataMap.get(REPBASEQTY_PARAMNUMBER).toString());
    }

    public BigDecimal getRepactualqty(Map<String, Object> dataMap) {
        if (dataMap.get(REPACTUALQTY_PARAMNUMBER) == null) {
            return ZERO;
        }
        return new BigDecimal(dataMap.get(REPACTUALQTY_PARAMNUMBER).toString());
    }

    public Date getActualBeginTime(Map<String, Object> dataMap) {
        if (dataMap.get(REPACTUALBEGINTIME_PARAMNUMBER) == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return sdf.parse(dataMap.get(REPACTUALBEGINTIME_PARAMNUMBER).toString());
        }
        catch (ParseException e) {
            logger.info("ParseException", (Object)e);
            return null;
        }
    }

    public Date getActualEndTime(Map<String, Object> dataMap) {
        if (dataMap.get(REPACTUALFINISHTIME_PARAMNUMBER) == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return sdf.parse(dataMap.get(REPACTUALFINISHTIME_PARAMNUMBER).toString());
        }
        catch (ParseException e) {
            logger.info("ParseException", (Object)e);
            return null;
        }
    }

    public String getTargetBillNoString(List<DynamicObject> targetBillObjs) {
        StringBuilder billStr = new StringBuilder();
        for (DynamicObject bill : targetBillObjs) {
            String billno = bill.getString("billno");
            if (StringUtils.isEmpty((String)billno)) {
                if (MANUINBILL_ENTITY_NUMBER.equalsIgnoreCase(bill.getDataEntityType().getName())) {
                    DynamicObject newDy = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)bill.getDataEntityType().getName(), (String)"id,billno");
                    billno = newDy.getString("billno");
                }
                if (StringUtils.isEmpty((String)billno)) {
                    billno = String.valueOf(bill.getPkValue());
                }
            }
            billStr.append(billno);
            billStr.append('\u3001');
        }
        String billString = billStr.toString();
        return billString.substring(0, billString.length() - 1);
    }

    public boolean isEmptyList(List lists) {
        return lists == null || lists.isEmpty();
    }

    public boolean isStrEquals(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        String obj1Str = obj1 == null ? "" : obj1.toString();
        String obj2Str = obj2 == null ? "" : obj2.toString();
        return obj1Str.equals(obj2Str);
    }

    public boolean isLongEquals(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        Long obj1Long = obj1 instanceof Long ? (Long)obj1 : Long.valueOf(obj1 == null || "".equals(obj1.toString()) ? 0L : Long.parseLong(obj1.toString()));
        Long obj2Long = obj2 instanceof Long ? (Long)obj2 : Long.valueOf(obj2 == null || "".equals(obj2.toString()) ? 0L : Long.parseLong(obj2.toString()));
        return obj1Long.equals(obj2Long);
    }

    public BigDecimal processPrecision(BigDecimal qty, DynamicObject unit) {
        int precision = unit.getInt("precision");
        return qty.setScale(precision, this.getRoundType(unit));
    }

    public BigDecimal getQtyByUnit(DynamicObject masterid, DynamicObject baseunit, DynamicObject unit, BigDecimal baseqty) {
        if (unit == null) {
            return BigDecimal.ZERO;
        }
        DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)masterid.getPkValue()), (Long)((Long)baseunit.getPkValue()), (Long)((Long)unit.getPkValue()));
        if (muConv == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal numerator = muConv.getBigDecimal("numerator");
        BigDecimal denominator = muConv.getBigDecimal("denominator");
        int precision = unit.getInt("precision");
        return baseqty.multiply(numerator).divide(denominator, precision, this.getRoundType(unit));
    }

    private int getRoundType(DynamicObject unit) {
        String precisionAccount = unit.getString("precisionaccount");
        int roundType = 0;
        switch (precisionAccount) {
            case "1": {
                roundType = 4;
                break;
            }
            case "2": {
                roundType = 1;
                break;
            }
            case "3": {
                roundType = 0;
                break;
            }
        }
        return roundType;
    }

    public OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", "true");
        option.setVariableValue("ignoreinteraction", "true");
        return option;
    }

    public String getCommonBotpID(String sourceEntity, String targetEntity) {
        Long botpID = 0L;
        switch (sourceEntity) {
            case "pom_mftorder": {
                if (MANUINBILL_ENTITY_NUMBER.equalsIgnoreCase(targetEntity)) {
                    botpID = 921672118725403648L;
                }
                if (!ORDERREPORT_ENTITY_NUMBER.equalsIgnoreCase(targetEntity)) break;
                botpID = 978237701344233472L;
                break;
            }
            case "pom_mftstock": {
                if (!MFTPROORDER_ENTITY_NUMBER.equalsIgnoreCase(targetEntity)) break;
                botpID = 919547717489881088L;
                break;
            }
            case "sfc_manftech": {
                if (!SFCREPORT_ENTITY_NUMBER.equalsIgnoreCase(targetEntity)) break;
                botpID = 961510294473985024L;
                break;
            }
            case "sfc_processreportbill": {
                if (!MANUINBILL_ENTITY_NUMBER.equalsIgnoreCase(targetEntity)) break;
                botpID = 1194036655955331072L;
                break;
            }
            case "pom_mftorderreport": {
                if (!MANUINBILL_ENTITY_NUMBER.equalsIgnoreCase(targetEntity)) break;
                botpID = 1114515031602500608L;
                break;
            }
            case "im_mdc_mftproorder": {
                if (!MFTRETURNORDER_ENTITY_NUMBER.equalsIgnoreCase(targetEntity)) break;
                botpID = 919562976292335616L;
                break;
            }
        }
        return String.valueOf(botpID);
    }
}

