/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.mftorder;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.mftorder.OrderBookDateService;
import kd.bd.mpdm.common.mftorder.entity.FormMapInfo;
import kd.bd.mpdm.common.mftorder.entity.ModTimeRowInfo;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class MftOrderModTimeUtils {
    private static Log logger = LogFactory.getLog(MftOrderModTimeUtils.class);

    public static Map<String, Set<ModTimeRowInfo>> handleMatchModTimeRows(List<FormMapInfo> billAndSelectRowMapList) {
        HashMap<String, Set<ModTimeRowInfo>> modTimeRowsMap = new HashMap<String, Set<ModTimeRowInfo>>(16);
        HashSet<ModTimeRowInfo> modTimeHandleRows = new HashSet<ModTimeRowInfo>(16);
        HashSet<ModTimeRowInfo> modTimeFilterRows = new HashSet<ModTimeRowInfo>(16);
        if (billAndSelectRowMapList.size() > 0) {
            for (FormMapInfo formMapInfo : billAndSelectRowMapList) {
                DynamicObjectCollection mftOrderEntrys;
                DynamicObject mftOrderBill = formMapInfo.getBills();
                int[] selectRows = formMapInfo.getSelectRows();
                if (null == mftOrderBill) continue;
                DynamicObject transactiontype = mftOrderBill.getDynamicObject("transactiontype");
                boolean transmitbeginwork = false;
                if (null != transactiontype) {
                    transmitbeginwork = transactiontype.getBoolean("transmitbeginwork");
                }
                if ((mftOrderEntrys = mftOrderBill.getDynamicObjectCollection("treeentryentity")) == null || selectRows.length <= 0) continue;
                for (int i : selectRows) {
                    DynamicObject orderEntry = (DynamicObject)mftOrderEntrys.get(i);
                    ModTimeRowInfo modTimeRowInfo = new ModTimeRowInfo();
                    modTimeRowInfo.setSeq(i);
                    modTimeRowInfo.setEntryId(orderEntry.getString("id"));
                    modTimeRowInfo.setBillNo(mftOrderBill.getString("billNo"));
                    modTimeRowInfo.setPkValue(mftOrderBill.getPkValue().toString());
                    modTimeRowInfo.setTransmitbeginwork(transmitbeginwork);
                    String producttype = orderEntry.getString("producttype");
                    if (StringUtils.equals((CharSequence)"C", (CharSequence)producttype)) {
                        modTimeHandleRows.add(modTimeRowInfo);
                        String entryId = orderEntry.getPkValue().toString();
                        for (DynamicObject mftOrderEntryTemp : mftOrderEntrys) {
                            String tempProductType = mftOrderEntryTemp.getString("producttype");
                            String tempId = mftOrderEntryTemp.get("pid").toString();
                            if (StringUtils.equals((CharSequence)"C", (CharSequence)tempProductType) || !StringUtils.equals((CharSequence)entryId, (CharSequence)tempId)) continue;
                            ModTimeRowInfo modTimeRowInfoTemp = new ModTimeRowInfo(modTimeRowInfo.getPkValue(), modTimeRowInfo.getEntryId(), modTimeRowInfo.getSeq(), modTimeRowInfo.getBillNo(), modTimeRowInfo.getErrorInfo(), modTimeRowInfo.isTransmitbeginwork());
                            modTimeRowInfoTemp.setSeq(mftOrderEntryTemp.getInt("seq") - 1);
                            modTimeRowInfoTemp.setEntryId(mftOrderEntryTemp.getPkValue().toString());
                            modTimeHandleRows.add(modTimeRowInfoTemp);
                        }
                        continue;
                    }
                    ModTimeRowInfo temp = new ModTimeRowInfo(modTimeRowInfo.getPkValue(), modTimeRowInfo.getEntryId(), modTimeRowInfo.getSeq(), modTimeRowInfo.getBillNo(), modTimeRowInfo.getErrorInfo(), modTimeRowInfo.isTransmitbeginwork());
                    modTimeHandleRows.add(temp);
                    String entryPID = orderEntry.getString("pid");
                    boolean matchFlag = false;
                    for (int j : selectRows) {
                        DynamicObject orderEntryTemp = (DynamicObject)mftOrderEntrys.get(j);
                        String tempProductType = orderEntryTemp.getString("producttype");
                        String tempId = orderEntryTemp.getPkValue().toString();
                        if (!StringUtils.equals((CharSequence)"C", (CharSequence)tempProductType) || !StringUtils.equals((CharSequence)entryPID, (CharSequence)tempId)) continue;
                        matchFlag = true;
                        break;
                    }
                    if (matchFlag) continue;
                    temp.setErrorInfo(ResManager.loadKDString((String)"\u4ea7\u54c1\u7c7b\u578b\u4e0d\u4e3a\u4e3b\u4ea7\u54c1\u3002", (String)"MftOrderModTimeUtils_0", (String)"bd-mpdm-business", (Object[])new Object[0]));
                    modTimeFilterRows.add(temp);
                }
            }
        }
        modTimeRowsMap.put("modTimeHandleRows", modTimeHandleRows);
        modTimeRowsMap.put("modTimeFilterRows", modTimeFilterRows);
        return modTimeRowsMap;
    }

    private static Set<ModTimeRowInfo> checkTimeCompareFillTime(Set<ModTimeRowInfo> modTimeHandleRows, List<DynamicObject> mftOrderBillList, Date fillTime, String comrapeFilesName, String compareType, String errorInfo, String compareFlag, String checkType) {
        HashSet<ModTimeRowInfo> resultRows = new HashSet<ModTimeRowInfo>(16);
        Date date = null;
        if (null != mftOrderBillList && null != comrapeFilesName && null != compareType && null != modTimeHandleRows && null != fillTime && mftOrderBillList.size() > 0) {
            block0: for (ModTimeRowInfo modTimeHandleRow : modTimeHandleRows) {
                if (null == modTimeHandleRow || "transmitAfterStartworkTime".equals(checkType) && modTimeHandleRow.isTransmitbeginwork()) continue;
                for (DynamicObject mftOrderBill : mftOrderBillList) {
                    ModTimeRowInfo temp;
                    int seq;
                    DynamicObject mftOrderEntry;
                    DynamicObjectCollection mftOrderEntrys;
                    if (null == mftOrderBill) continue;
                    if (StringUtils.equals((CharSequence)"bill", (CharSequence)compareFlag) && StringUtils.equals((CharSequence)modTimeHandleRow.getPkValue(), (CharSequence)mftOrderBill.getPkValue().toString())) {
                        ModTimeRowInfo temp2;
                        date = mftOrderBill.getDate(comrapeFilesName);
                        if (date == null) continue;
                        if (StringUtils.equals((CharSequence)"before", (CharSequence)compareType) && fillTime.before(date)) {
                            temp2 = new ModTimeRowInfo(modTimeHandleRow.getPkValue(), modTimeHandleRow.getEntryId(), modTimeHandleRow.getSeq(), modTimeHandleRow.getBillNo(), modTimeHandleRow.getErrorInfo(), modTimeHandleRow.isTransmitbeginwork());
                            temp2.setErrorInfo(errorInfo);
                            resultRows.add(temp2);
                            continue block0;
                        }
                        if (!StringUtils.equals((CharSequence)"after", (CharSequence)compareType) || !fillTime.after(date)) continue;
                        temp2 = new ModTimeRowInfo(modTimeHandleRow.getPkValue(), modTimeHandleRow.getEntryId(), modTimeHandleRow.getSeq(), modTimeHandleRow.getBillNo(), modTimeHandleRow.getErrorInfo(), modTimeHandleRow.isTransmitbeginwork());
                        temp2.setErrorInfo(errorInfo);
                        resultRows.add(temp2);
                        continue block0;
                    }
                    if (!StringUtils.equals((CharSequence)modTimeHandleRow.getPkValue(), (CharSequence)mftOrderBill.getPkValue().toString()) || (mftOrderEntrys = mftOrderBill.getDynamicObjectCollection("treeentryentity")) == null || mftOrderEntrys.size() <= 0 || (mftOrderEntry = (DynamicObject)mftOrderEntrys.get(seq = modTimeHandleRow.getSeq())) == null || (date = mftOrderEntry.getDate(comrapeFilesName)) == null) continue;
                    if (StringUtils.equals((CharSequence)"before", (CharSequence)compareType) && fillTime.before(date)) {
                        temp = new ModTimeRowInfo(modTimeHandleRow.getPkValue(), modTimeHandleRow.getEntryId(), modTimeHandleRow.getSeq(), modTimeHandleRow.getBillNo(), modTimeHandleRow.getErrorInfo(), modTimeHandleRow.isTransmitbeginwork());
                        temp.setErrorInfo(errorInfo);
                        resultRows.add(temp);
                        continue block0;
                    }
                    if (!StringUtils.equals((CharSequence)"after", (CharSequence)compareType) || !fillTime.after(date)) continue;
                    temp = new ModTimeRowInfo(modTimeHandleRow.getPkValue(), modTimeHandleRow.getEntryId(), modTimeHandleRow.getSeq(), modTimeHandleRow.getBillNo(), modTimeHandleRow.getErrorInfo(), modTimeHandleRow.isTransmitbeginwork());
                    temp.setErrorInfo(errorInfo);
                    resultRows.add(temp);
                    continue block0;
                }
            }
        }
        return resultRows;
    }

    private static Set<ModTimeRowInfo> checkTransmitTimeAfterPushBillDateRows(Date transmitTime, Set<ModTimeRowInfo> modTimeHandleRows, QFilter filters, String pushEntityName, String sqlSelectProperties, String pushEntryBillNoName, String pushEntryName, String pushEntrySrcEntryIdName, String dateName, String billTypeName) {
        HashSet<ModTimeRowInfo> transmitAfterPushBillDateRows = new HashSet<ModTimeRowInfo>(16);
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)pushEntityName, (String)sqlSelectProperties, (QFilter[])new QFilter[]{filters});
        for (ModTimeRowInfo modTimeRowInfo : modTimeHandleRows) {
            String modTimeRowBillNo = modTimeRowInfo.getBillNo();
            String modTimeRowEntryId = modTimeRowInfo.getEntryId();
            if (!StringUtils.isNotBlank((CharSequence)modTimeRowBillNo) || !StringUtils.isNotBlank((CharSequence)modTimeRowEntryId)) continue;
            block1: for (DynamicObject bill : bills) {
                Date date = bill.getDate(dateName);
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection(pushEntryName);
                for (DynamicObject entry : entrys) {
                    String mftOrderEntryId = "";
                    mftOrderEntryId = StringUtils.equals((CharSequence)"sfc_processreportbill", (CharSequence)pushEntityName) ? entry.getDynamicObject(pushEntrySrcEntryIdName).getPkValue().toString() : entry.getString(pushEntrySrcEntryIdName);
                    String billNo = entry.getString(pushEntryBillNoName);
                    if (!StringUtils.equals((CharSequence)modTimeRowBillNo, (CharSequence)billNo) || !StringUtils.equals((CharSequence)modTimeRowEntryId, (CharSequence)mftOrderEntryId) || null == transmitTime || null == date) continue;
                    date.setHours(0);
                    date.setMinutes(0);
                    date.setSeconds(0);
                    transmitTime.setHours(0);
                    transmitTime.setMinutes(0);
                    transmitTime.setSeconds(0);
                    if (!transmitTime.after(date)) continue block1;
                    String errorInfo = String.format(ResManager.loadKDString((String)"\u4e0b\u8fbe\u65e5\u671f\u4e0d\u5141\u8bb8\u665a\u4e8e\u5176\u4e0b\u6e38\u5355\u636e\uff1a%1$s\uff08%2$s\uff09\u7684\u4e1a\u52a1\u65e5\u671f\u3002", (String)"MftOrderModTimeUtils_28", (String)"bd-mpdm-business", (Object[])new Object[0]), billTypeName, bill.getString("billno"));
                    ModTimeRowInfo temp = new ModTimeRowInfo(modTimeRowInfo.getPkValue(), modTimeRowInfo.getEntryId(), modTimeRowInfo.getSeq(), modTimeRowInfo.getBillNo(), modTimeRowInfo.getErrorInfo(), modTimeRowInfo.isTransmitbeginwork());
                    temp.setErrorInfo(errorInfo);
                    transmitAfterPushBillDateRows.add(temp);
                    continue block1;
                }
            }
        }
        return transmitAfterPushBillDateRows;
    }

    public static Map<String, Set<ModTimeRowInfo>> checkCloseTime(Map<String, Set<ModTimeRowInfo>> modTimeRowsMap, Set<ModTimeRowInfo> modTimeHandleRows, List<DynamicObject> mftOrderBillList, Date closeTime) {
        Set<ModTimeRowInfo> closeTimeBeforeTransmitTimeRows = MftOrderModTimeUtils.checkTimeCompareFillTime(modTimeHandleRows, mftOrderBillList, closeTime, "transmittime", "before", ResManager.loadKDString((String)"\u5173\u95ed\u65f6\u95f4\u4e0d\u5141\u8bb8\u65e9\u4e8e\u4e0b\u8fbe\u65f6\u95f4\u3002", (String)"MftOrderModTimeUtils_2", (String)"bd-mpdm-business", (Object[])new Object[0]), "row", "closeTimeBeforeTransmitTime");
        modTimeRowsMap.put("closeTimeBeforeTransmitTimeRows", closeTimeBeforeTransmitTimeRows);
        Set<ModTimeRowInfo> closeTimeBeforeStartworktimeRows = MftOrderModTimeUtils.checkTimeCompareFillTime(modTimeHandleRows, mftOrderBillList, closeTime, "startworktime", "before", ResManager.loadKDString((String)"\u5173\u95ed\u65f6\u95f4\u4e0d\u5141\u8bb8\u65e9\u4e8e\u5f00\u5de5\u65f6\u95f4\u3002", (String)"MftOrderModTimeUtils_3", (String)"bd-mpdm-business", (Object[])new Object[0]), "row", "closeTimeBeforeStartworktime");
        modTimeRowsMap.put("closeTimeBeforeStartworktimeRows", closeTimeBeforeStartworktimeRows);
        Set<ModTimeRowInfo> closeTimeBeforeEndworktimeRows = MftOrderModTimeUtils.checkTimeCompareFillTime(modTimeHandleRows, mftOrderBillList, closeTime, "endworktime", "before", ResManager.loadKDString((String)"\u5173\u95ed\u65f6\u95f4\u4e0d\u5141\u8bb8\u65e9\u4e8e\u5b8c\u5de5\u65f6\u95f4\u3002", (String)"MftOrderModTimeUtils_4", (String)"bd-mpdm-business", (Object[])new Object[0]), "row", "closeTimeBeforeEndworktime");
        modTimeRowsMap.put("closeTimeBeforeEndworktimeRows", closeTimeBeforeEndworktimeRows);
        return modTimeRowsMap;
    }

    public static Map<String, Set<ModTimeRowInfo>> checkTransmitTime(Map<String, Set<ModTimeRowInfo>> modTimeRowsMap, Set<ModTimeRowInfo> modTimeHandleRows, List<DynamicObject> mftOrderBillList, Date transmitTime, String entityId) {
        Set<ModTimeRowInfo> transmitAfterPushFeedOrderBillDateRows;
        Set<ModTimeRowInfo> transmitAfterPushReturnorderBillDateRows;
        Set<ModTimeRowInfo> transmitAfterPushProorderBillDateRows;
        Set<ModTimeRowInfo> transmitAfterStartworkTimeRows = MftOrderModTimeUtils.checkTimeCompareFillTime(modTimeHandleRows, mftOrderBillList, transmitTime, "startworktime", "after", ResManager.loadKDString((String)"\u4e0b\u8fbe\u65f6\u95f4\u4e0d\u5141\u8bb8\u665a\u4e8e\u5f00\u5de5\u65f6\u95f4\u3002", (String)"MftOrderModTimeUtils_5", (String)"bd-mpdm-business", (Object[])new Object[0]), "row", "transmitAfterStartworkTime");
        modTimeRowsMap.put("transmitAfterStartworkTimeRows", transmitAfterStartworkTimeRows);
        Set<ModTimeRowInfo> transmitAfterEndworktimeRows = MftOrderModTimeUtils.checkTimeCompareFillTime(modTimeHandleRows, mftOrderBillList, transmitTime, "endworktime", "after", ResManager.loadKDString((String)"\u4e0b\u8fbe\u65f6\u95f4\u4e0d\u5141\u8bb8\u665a\u4e8e\u5b8c\u5de5\u65f6\u95f4\u3002", (String)"MftOrderModTimeUtils_6", (String)"bd-mpdm-business", (Object[])new Object[0]), "row", "transmitAfterEndworktime");
        modTimeRowsMap.put("transmitAfterEndworktimeRows", transmitAfterEndworktimeRows);
        ArrayList<Long> entryIds = new ArrayList<Long>(10);
        ArrayList<String> entryIdsStr = new ArrayList<String>(10);
        for (ModTimeRowInfo modTimeRowInfo : modTimeHandleRows) {
            if (!StringUtils.isNotBlank((CharSequence)modTimeRowInfo.getEntryId())) continue;
            entryIds.add(Long.valueOf(modTimeRowInfo.getEntryId()));
            entryIdsStr.add(modTimeRowInfo.getEntryId());
        }
        if ("pom_mftorder".equals(entityId)) {
            transmitAfterPushProorderBillDateRows = MftOrderModTimeUtils.checkTransmitTimeAfterPushBillDateRows(transmitTime, modTimeHandleRows, new QFilter("billentry.manuentryid", "in", entryIds).and("billtype.billformid", "=", (Object)"im_mdc_mftproorder"), "im_mdc_mftproorder", "billentry.manuentryid,billentry.manubill,biztime,billno", "manubill", "billentry", "manuentryid", "biztime", ResManager.loadKDString((String)"\u751f\u4ea7\u9886\u6599\u5355", (String)"MftOrderModTimeUtils_7", (String)"bd-mpdm-business", (Object[])new Object[0]));
            modTimeRowsMap.put("transmitAfterPushProorderBillDateRows", transmitAfterPushProorderBillDateRows);
            transmitAfterPushReturnorderBillDateRows = MftOrderModTimeUtils.checkTransmitTimeAfterPushBillDateRows(transmitTime, modTimeHandleRows, new QFilter("billentry.manuentryid", "in", entryIds).and("billtype.billformid", "=", (Object)"im_mdc_mftreturnorder"), "im_mdc_mftreturnorder", "billentry.manuentryid,billentry.manubill,biztime,billno", "manubill", "billentry", "manuentryid", "biztime", ResManager.loadKDString((String)"\u751f\u4ea7\u9000\u6599\u5355", (String)"MftOrderModTimeUtils_8", (String)"bd-mpdm-business", (Object[])new Object[0]));
            modTimeRowsMap.put("transmitAfterPushReturnorderBillDateRows", transmitAfterPushReturnorderBillDateRows);
            transmitAfterPushFeedOrderBillDateRows = MftOrderModTimeUtils.checkTransmitTimeAfterPushBillDateRows(transmitTime, modTimeHandleRows, new QFilter("billentry.manuentryid", "in", entryIds).and("billtype.billformid", "=", (Object)"im_mdc_mftfeedorder"), "im_mdc_mftfeedorder", "billentry.manuentryid,billentry.manubill,biztime,billno", "manubill", "billentry", "manuentryid", "biztime", ResManager.loadKDString((String)"\u751f\u4ea7\u8865\u6599\u5355", (String)"MftOrderModTimeUtils_9", (String)"bd-mpdm-business", (Object[])new Object[0]));
            modTimeRowsMap.put("transmitAfterPushFeedOrderBillDateRows", transmitAfterPushFeedOrderBillDateRows);
            Set<ModTimeRowInfo> transmitAfterPushReportBillDateRows = MftOrderModTimeUtils.checkTransmitTimeAfterPushBillDateRows(transmitTime, modTimeHandleRows, new QFilter("sumentry.mftentryid", "in", entryIdsStr), "pom_mftorderreport", "sumentry.mftentryid,sumentry.manufacturenun,reportdate,billno", "manufacturenun", "sumentry", "mftentryid", "reportdate", ResManager.loadKDString((String)"\u5de5\u5355\u6c47\u62a5\u5355", (String)"MftOrderModTimeUtils_10", (String)"bd-mpdm-business", (Object[])new Object[0]));
            modTimeRowsMap.put("transmitAfterPushReportBillDateRows", transmitAfterPushReportBillDateRows);
            Set<ModTimeRowInfo> transmitAfterPushProcessReportBillDateRows = MftOrderModTimeUtils.checkTransmitTimeAfterPushBillDateRows(transmitTime, modTimeHandleRows, new QFilter("sumentry.manufactureentryid", "in", entryIds), "sfc_processreportbill", "sumentry.manufactureentryid,sumentry.manufacturenun,reportdate,billno", "manufacturenun", "sumentry", "manufactureentryid", "reportdate", ResManager.loadKDString((String)"\u5de5\u5e8f\u6c47\u62a5\u5355", (String)"MftOrderModTimeUtils_11", (String)"bd-mpdm-business", (Object[])new Object[0]));
            modTimeRowsMap.put("transmitAfterPushProcessReportBillDateRows", transmitAfterPushProcessReportBillDateRows);
            Set<ModTimeRowInfo> transmitAfterPushMftManuinBillDateRows = MftOrderModTimeUtils.checkTransmitTimeAfterPushBillDateRows(transmitTime, modTimeHandleRows, new QFilter("billentry.manuentryid", "in", entryIds).and("billtype.billformid", "=", (Object)"im_mdc_mftmanuinbill"), "im_mdc_mftmanuinbill", "billentry.manuentryid,billentry.manubill,biztime,billno", "manubill", "billentry", "manuentryid", "biztime", ResManager.loadKDString((String)"\u5b8c\u5de5\u5165\u5e93\u5355", (String)"MftOrderModTimeUtils_12", (String)"bd-mpdm-business", (Object[])new Object[0]));
            modTimeRowsMap.put("transmitAfterPushMftManuinBillDateRows", transmitAfterPushMftManuinBillDateRows);
            Set<ModTimeRowInfo> transmitAfterPushMftReturnBillDateRows = MftOrderModTimeUtils.checkTransmitTimeAfterPushBillDateRows(transmitTime, modTimeHandleRows, new QFilter("billentry.manuentryid", "in", entryIds).and("billtype.billformid", "=", (Object)"im_mdc_mftreturnbill"), "im_mdc_mftreturnbill", "billentry.manuentryid,billentry.manubill,biztime,billno", "manubill", "billentry", "manuentryid", "biztime", ResManager.loadKDString((String)"\u5b8c\u5de5\u9000\u5e93\u5355", (String)"MftOrderModTimeUtils_13", (String)"bd-mpdm-business", (Object[])new Object[0]));
            modTimeRowsMap.put("transmitAfterPushMftReturnBillDateRows", transmitAfterPushMftReturnBillDateRows);
        }
        if ("om_mftorder".equals(entityId)) {
            transmitAfterPushProorderBillDateRows = MftOrderModTimeUtils.checkTransmitTimeAfterPushBillDateRows(transmitTime, modTimeHandleRows, new QFilter("billentry.manuentryid", "in", entryIds).and("billtype.billformid", "=", (Object)"im_mdc_omoutbill"), "im_mdc_omoutbill", "billentry.manuentryid,billentry.manubill,biztime,billno", "manubill", "billentry", "manuentryid", "biztime", ResManager.loadKDString((String)"\u59d4\u5916\u9886\u6599\u5355", (String)"MftOrderModTimeUtils_21", (String)"bd-mpdm-business", (Object[])new Object[0]));
            modTimeRowsMap.put("transmitAfterPushProorderBillDateRows", transmitAfterPushProorderBillDateRows);
            transmitAfterPushReturnorderBillDateRows = MftOrderModTimeUtils.checkTransmitTimeAfterPushBillDateRows(transmitTime, modTimeHandleRows, new QFilter("billentry.manuentryid", "in", entryIds).and("billtype.billformid", "=", (Object)"im_mdc_omreturnbill"), "im_mdc_omreturnbill", "billentry.manuentryid,billentry.manubill,biztime,billno", "manubill", "billentry", "manuentryid", "biztime", ResManager.loadKDString((String)"\u59d4\u5916\u9000\u6599\u5355", (String)"MftOrderModTimeUtils_22", (String)"bd-mpdm-business", (Object[])new Object[0]));
            modTimeRowsMap.put("transmitAfterPushReturnorderBillDateRows", transmitAfterPushReturnorderBillDateRows);
            transmitAfterPushFeedOrderBillDateRows = MftOrderModTimeUtils.checkTransmitTimeAfterPushBillDateRows(transmitTime, modTimeHandleRows, new QFilter("billentry.manuentryid", "in", entryIds).and("billtype.billformid", "=", (Object)"im_mdc_omfeedbill"), "im_mdc_omfeedbill", "billentry.manuentryid,billentry.manubill,biztime,billno", "manubill", "billentry", "manuentryid", "biztime", ResManager.loadKDString((String)"\u59d4\u5916\u8865\u6599\u5355", (String)"MftOrderModTimeUtils_23", (String)"bd-mpdm-business", (Object[])new Object[0]));
            modTimeRowsMap.put("transmitAfterPushFeedOrderBillDateRows", transmitAfterPushFeedOrderBillDateRows);
            Set<ModTimeRowInfo> transmitAfterPushProcessReportBillDateRows = MftOrderModTimeUtils.checkTransmitTimeAfterPushBillDateRows(transmitTime, modTimeHandleRows, new QFilter("sumentry.manufactureentryid", "in", entryIds), "om_processreport", "sumentry.manufactureentryid,sumentry.manufacturenun,reportdate,billno", "manufacturenun", "sumentry", "manufactureentryid", "reportdate", ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5e8f\u6c47\u62a5\u5355", (String)"MftOrderModTimeUtils_24", (String)"bd-mpdm-business", (Object[])new Object[0]));
            modTimeRowsMap.put("transmitAfterPushProcessReportBillDateRows", transmitAfterPushProcessReportBillDateRows);
            Set<ModTimeRowInfo> transmitAfterPushMftManuinBillDateRows = MftOrderModTimeUtils.checkTransmitTimeAfterPushBillDateRows(transmitTime, modTimeHandleRows, new QFilter("billentry.manuentryid", "in", entryIds).and("billtype.billformid", "=", (Object)"im_mdc_omcmplinbill"), "im_mdc_omcmplinbill", "billentry.manuentryid,billentry.manubill,biztime,billno", "manubill", "billentry", "manuentryid", "biztime", ResManager.loadKDString((String)"\u59d4\u5916\u5b8c\u5de5\u5165\u5e93\u5355", (String)"MftOrderModTimeUtils_25", (String)"bd-mpdm-business", (Object[])new Object[0]));
            modTimeRowsMap.put("transmitAfterPushMftManuinBillDateRows", transmitAfterPushMftManuinBillDateRows);
        }
        if ("prop_mftorder".equals(entityId)) {
            MftOrderModTimeUtils.checkPropTransmitTime(modTimeRowsMap, modTimeHandleRows, mftOrderBillList, transmitTime, entryIds);
        }
        return modTimeRowsMap;
    }

    private static void checkPropTransmitTime(Map<String, Set<ModTimeRowInfo>> modTimeRowsMap, Set<ModTimeRowInfo> modTimeHandleRows, List<DynamicObject> mftOrderBillList, Date transmitTime, List<Long> entryIds) {
        Set<ModTimeRowInfo> transmitAfterPushProorderBillDateRows = MftOrderModTimeUtils.checkTransmitTimeAfterPushBillDateRows(transmitTime, modTimeHandleRows, new QFilter("billentry.manuentryid", "in", entryIds).and("billtype.billformid", "=", (Object)"im_mdc_mftproorder"), "im_mdc_mftproorder", "billentry.manuentryid,billentry.manubill,biztime,billno", "manubill", "billentry", "manuentryid", "biztime", ResManager.loadKDString((String)"\u751f\u4ea7\u9886\u6599\u5355", (String)"MftOrderModTimeUtils_7", (String)"bd-mpdm-business", (Object[])new Object[0]));
        modTimeRowsMap.put("transmitAfterPushProorderBillDateRows", transmitAfterPushProorderBillDateRows);
        Set<ModTimeRowInfo> transmitAfterPushReturnorderBillDateRows = MftOrderModTimeUtils.checkTransmitTimeAfterPushBillDateRows(transmitTime, modTimeHandleRows, new QFilter("billentry.manuentryid", "in", entryIds).and("billtype.billformid", "=", (Object)"im_mdc_mftreturnorder"), "im_mdc_mftreturnorder", "billentry.manuentryid,billentry.manubill,biztime,billno", "manubill", "billentry", "manuentryid", "biztime", ResManager.loadKDString((String)"\u751f\u4ea7\u9000\u6599\u5355", (String)"MftOrderModTimeUtils_8", (String)"bd-mpdm-business", (Object[])new Object[0]));
        modTimeRowsMap.put("transmitAfterPushReturnorderBillDateRows", transmitAfterPushReturnorderBillDateRows);
        Set<ModTimeRowInfo> transmitAfterPushFeedOrderBillDateRows = MftOrderModTimeUtils.checkTransmitTimeAfterPushBillDateRows(transmitTime, modTimeHandleRows, new QFilter("billentry.manuentryid", "in", entryIds).and("billtype.billformid", "=", (Object)"im_mdc_mftfeedorder"), "im_mdc_mftfeedorder", "billentry.manuentryid,billentry.manubill,biztime,billno", "manubill", "billentry", "manuentryid", "biztime", ResManager.loadKDString((String)"\u751f\u4ea7\u8865\u6599\u5355", (String)"MftOrderModTimeUtils_9", (String)"bd-mpdm-business", (Object[])new Object[0]));
        modTimeRowsMap.put("transmitAfterPushFeedOrderBillDateRows", transmitAfterPushFeedOrderBillDateRows);
        Set<ModTimeRowInfo> transmitAfterPushMftManuinBillDateRows = MftOrderModTimeUtils.checkTransmitTimeAfterPushBillDateRows(transmitTime, modTimeHandleRows, new QFilter("billentry.manuentryid", "in", entryIds).and("billtype.billformid", "=", (Object)"im_mdc_mftmanuinbill"), "im_mdc_mftmanuinbill", "billentry.manuentryid,billentry.manubill,biztime,billno", "manubill", "billentry", "manuentryid", "biztime", ResManager.loadKDString((String)"\u5b8c\u5de5\u5165\u5e93\u5355", (String)"MftOrderModTimeUtils_12", (String)"bd-mpdm-business", (Object[])new Object[0]));
        modTimeRowsMap.put("transmitAfterPushMftManuinBillDateRows", transmitAfterPushMftManuinBillDateRows);
        Set<ModTimeRowInfo> transmitAfterPushMftReturnBillDateRows = MftOrderModTimeUtils.checkTransmitTimeAfterPushBillDateRows(transmitTime, modTimeHandleRows, new QFilter("billentry.manuentryid", "in", entryIds).and("billtype.billformid", "=", (Object)"im_mdc_mftreturnbill"), "im_mdc_mftreturnbill", "billentry.manuentryid,billentry.manubill,biztime,billno", "manubill", "billentry", "manuentryid", "biztime", ResManager.loadKDString((String)"\u5b8c\u5de5\u9000\u5e93\u5355", (String)"MftOrderModTimeUtils_13", (String)"bd-mpdm-business", (Object[])new Object[0]));
        modTimeRowsMap.put("transmitAfterPushMftReturnBillDateRows", transmitAfterPushMftReturnBillDateRows);
    }

    public static String checkCloseTimeEntryErrorInfo(ModTimeRowInfo modTimeRowInfo, Map<String, Set<ModTimeRowInfo>> modTimeRowsMap, String ... name) {
        StringBuilder rowErrorInfo = new StringBuilder(200);
        String pkValue = modTimeRowInfo.getPkValue();
        String entryId = modTimeRowInfo.getEntryId();
        if (StringUtils.isNotBlank((CharSequence)pkValue) && StringUtils.isNotBlank((CharSequence)entryId)) {
            block0: for (String rowsName : name) {
                Set<ModTimeRowInfo> modTimeRows = modTimeRowsMap.get(rowsName);
                if (modTimeRows == null || modTimeRows.size() <= 0) continue;
                for (ModTimeRowInfo modTimeRow : modTimeRows) {
                    String pkValueInRow = modTimeRow.getPkValue();
                    String entryIdInRow = modTimeRow.getEntryId();
                    if (!StringUtils.equals((CharSequence)pkValue, (CharSequence)pkValueInRow) || !StringUtils.equals((CharSequence)entryId, (CharSequence)entryIdInRow)) continue;
                    rowErrorInfo.append(modTimeRow.getErrorInfo());
                    continue block0;
                }
            }
        }
        return rowErrorInfo.toString();
    }

    public static Map<String, Set<ModTimeRowInfo>> checkCloseBizStatusFails(Map<String, Set<ModTimeRowInfo>> modTimeRowsMap, List<FormMapInfo> billAndSelectRowMapList) {
        Set<ModTimeRowInfo> modTimeHandleRows = modTimeRowsMap.get("modTimeHandleRows");
        HashSet<ModTimeRowInfo> bizStatusFailsRows = new HashSet<ModTimeRowInfo>(16);
        for (ModTimeRowInfo modTimeRowInfo : modTimeHandleRows) {
            int seq = modTimeRowInfo.getSeq();
            String pkValue = modTimeRowInfo.getPkValue();
            for (FormMapInfo formMapInfo : billAndSelectRowMapList) {
                DynamicObject mftOrderEntry;
                String bizstatus;
                DynamicObject bill = formMapInfo.getBills();
                DynamicObjectCollection mftOrderEntrys = bill.getDynamicObjectCollection("treeentryentity");
                String billPkValue = bill.getPkValue().toString();
                if (null == mftOrderEntrys || !StringUtils.equals((CharSequence)pkValue, (CharSequence)billPkValue) || StringUtils.equals((CharSequence)"C", (CharSequence)(bizstatus = (mftOrderEntry = (DynamicObject)mftOrderEntrys.get(seq)).getString("bizstatus")))) continue;
                ModTimeRowInfo temp = new ModTimeRowInfo(modTimeRowInfo.getPkValue(), modTimeRowInfo.getEntryId(), modTimeRowInfo.getSeq(), modTimeRowInfo.getBillNo(), modTimeRowInfo.getErrorInfo(), modTimeRowInfo.isTransmitbeginwork());
                temp.setErrorInfo(ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u987b\u4e3a\u5173\u95ed\u72b6\u6001\u3002", (String)"MftOrderModTimeUtils_14", (String)"bd-mpdm-business", (Object[])new Object[0]));
                bizStatusFailsRows.add(temp);
            }
        }
        modTimeRowsMap.put("bizStatusFailsRows", bizStatusFailsRows);
        return modTimeRowsMap;
    }

    public static Map<String, Set<ModTimeRowInfo>> checkTransmitBizStatusFails(Map<String, Set<ModTimeRowInfo>> modTimeRowsMap, List<FormMapInfo> billAndSelectRowMapList) {
        Set<ModTimeRowInfo> modTimeHandleRows = modTimeRowsMap.get("modTimeHandleRows");
        HashSet<ModTimeRowInfo> bizStatusFailsRows = new HashSet<ModTimeRowInfo>(16);
        for (ModTimeRowInfo modTimeRowInfo : modTimeHandleRows) {
            int seq = modTimeRowInfo.getSeq();
            String pkValue = modTimeRowInfo.getPkValue();
            for (FormMapInfo formMapInfo : billAndSelectRowMapList) {
                DynamicObject bill = formMapInfo.getBills();
                DynamicObjectCollection mftOrderEntrys = bill.getDynamicObjectCollection("treeentryentity");
                String billPkValue = bill.getPkValue().toString();
                String billStatus = bill.getString("billstatus");
                if (null == mftOrderEntrys || !StringUtils.equals((CharSequence)pkValue, (CharSequence)billPkValue)) continue;
                DynamicObject mftOrderEntry = (DynamicObject)mftOrderEntrys.get(seq);
                String planstatus = mftOrderEntry.getString("planstatus");
                String bizstatus = mftOrderEntry.getString("bizstatus");
                if (StringUtils.equals((CharSequence)"C", (CharSequence)billStatus) && StringUtils.equals((CharSequence)"C", (CharSequence)planstatus) && StringUtils.equals((CharSequence)"A", (CharSequence)bizstatus)) continue;
                ModTimeRowInfo temp = new ModTimeRowInfo(modTimeRowInfo.getPkValue(), modTimeRowInfo.getEntryId(), modTimeRowInfo.getSeq(), modTimeRowInfo.getBillNo(), modTimeRowInfo.getErrorInfo(), modTimeRowInfo.isTransmitbeginwork());
                temp.setErrorInfo(ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u4ee5\u4e0b\u6761\u4ef6\uff1a\u751f\u4ea7\u5de5\u5355\u7684\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\uff0c\u8ba1\u5212\u72b6\u6001\u4e3a\u201c\u4e0b\u8fbe\u201d\uff0c\u4e1a\u52a1\u72b6\u6001\u4e3a\u201c\u6b63\u5e38\u201d\u3002", (String)"MftOrderModTimeUtils_15", (String)"bd-mpdm-business", (Object[])new Object[0]));
                bizStatusFailsRows.add(temp);
            }
        }
        modTimeRowsMap.put("bizStatusFailsRows", bizStatusFailsRows);
        return modTimeRowsMap;
    }

    public static Map<String, Set<ModTimeRowInfo>> checkBeginBookTimeFails(Map<String, Set<ModTimeRowInfo>> modTimeRowsMap, List<FormMapInfo> billAndSelectRowMapList, Date fillDate, Map<Long, Date> productOrgAndBookDateMap, Map<Long, Date> maxInvOrgAndBookDateMap) {
        Set<ModTimeRowInfo> modTimeHandleRows = modTimeRowsMap.get("modTimeHandleRows");
        HashSet<ModTimeRowInfo> bizStatusFailsRows = new HashSet<ModTimeRowInfo>(16);
        HashSet<ModTimeRowInfo> afterCloseBookDateRows = new HashSet<ModTimeRowInfo>(16);
        HashSet<ModTimeRowInfo> afterMaxBookDateRows = new HashSet<ModTimeRowInfo>(16);
        for (ModTimeRowInfo modTimeRowInfo : modTimeHandleRows) {
            int seq = modTimeRowInfo.getSeq();
            String pkValue = modTimeRowInfo.getPkValue();
            for (FormMapInfo formMapInfo : billAndSelectRowMapList) {
                String productType;
                DynamicObject mftOrderEntry;
                DynamicObject bill = formMapInfo.getBills();
                DynamicObjectCollection mftOrderEntrys = bill.getDynamicObjectCollection("treeentryentity");
                String billPkValue = bill.getPkValue().toString();
                if (null == mftOrderEntrys || !StringUtils.equals((CharSequence)pkValue, (CharSequence)billPkValue) || null == (mftOrderEntry = (DynamicObject)mftOrderEntrys.get(seq)) || !"C".equals(productType = mftOrderEntry.getString("producttype"))) continue;
                String planStatus = mftOrderEntry.getString("planstatus");
                if (!StringUtils.equals((CharSequence)"C", (CharSequence)planStatus)) {
                    ModTimeRowInfo temp = new ModTimeRowInfo(modTimeRowInfo.getPkValue(), modTimeRowInfo.getEntryId(), modTimeRowInfo.getSeq(), modTimeRowInfo.getBillNo(), modTimeRowInfo.getErrorInfo(), modTimeRowInfo.isTransmitbeginwork());
                    temp.setErrorInfo(ResManager.loadKDString((String)"\u8ba1\u5212\u72b6\u6001\u4e0d\u4e3a\u201c\u4e0b\u8fbe\u201d\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5de5\u5355\u8bb0\u8d26\u65e5\u671f\u3002", (String)"MftOrderModTimeUtils_17", (String)"bd-mpdm-business", (Object[])new Object[0]));
                    bizStatusFailsRows.add(temp);
                }
                Date closeBookDate = mftOrderEntry.getDate("closebookdate");
                if (null != fillDate && null != closeBookDate && fillDate.after(DateUtils.getShortDate((Date)closeBookDate))) {
                    SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                    ModTimeRowInfo temp = new ModTimeRowInfo(modTimeRowInfo.getPkValue(), modTimeRowInfo.getEntryId(), modTimeRowInfo.getSeq(), modTimeRowInfo.getBillNo(), modTimeRowInfo.getErrorInfo(), modTimeRowInfo.isTransmitbeginwork());
                    temp.setErrorInfo(String.format(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u8981\u6c42\uff1a\u5de5\u5355\u5173\u95ed\u8bb0\u8d26\u65e5\u671f\uff08%1$s\uff09\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5de5\u5355\u8bb0\u8d26\u65e5\u671f\uff08%2$s\uff09\u3002", (String)"MftOrderModTimeUtils_29", (String)"bd-mpdm-business", (Object[])new Object[0]), sf.format(closeBookDate), sf.format(fillDate)));
                    afterCloseBookDateRows.add(temp);
                }
                long invOrgId = 0L;
                DynamicObject invOrgDyn = mftOrderEntry.getDynamicObject("inwardept");
                if (null != invOrgDyn) {
                    invOrgId = invOrgDyn.getLong("id");
                }
                long orgId = 0L;
                DynamicObject orgDyn = bill.getDynamicObject("org");
                if (null != orgDyn) {
                    orgId = orgDyn.getLong("id");
                }
                Date bookDate = OrderBookDateService.queryMaxBookDate(orgId, invOrgId, productOrgAndBookDateMap, maxInvOrgAndBookDateMap);
                if (null == fillDate || null == bookDate || !fillDate.before(OrderBookDateService.theDayAfterMaxBookDate(bookDate))) continue;
                SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                ModTimeRowInfo temp = new ModTimeRowInfo(modTimeRowInfo.getPkValue(), modTimeRowInfo.getEntryId(), modTimeRowInfo.getSeq(), modTimeRowInfo.getBillNo(), modTimeRowInfo.getErrorInfo(), modTimeRowInfo.isTransmitbeginwork());
                temp.setErrorInfo(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4fee\u6539\u540e\u7684\u5de5\u5355\u8bb0\u8d26\u65e5\u671f%1$s\u5c0f\u4e8e\u5173\u8d26\u65e5\u671f\u7684\u540e\u4e00\u5929%2$s\uff0c\u4fee\u6539\u5931\u8d25\u3002", (String)"MftOrderModTimeUtils_30", (String)"bd-mpdm-business", (Object[])new Object[0]), sf.format(fillDate), sf.format(OrderBookDateService.theDayAfterMaxBookDate(bookDate))));
                afterMaxBookDateRows.add(temp);
            }
        }
        modTimeRowsMap.put("bizStatusFailsRows", bizStatusFailsRows);
        modTimeRowsMap.put("afterCloseBookDateRows", afterCloseBookDateRows);
        modTimeRowsMap.put("afterMaxBookDateRows", afterMaxBookDateRows);
        return modTimeRowsMap;
    }

    public static Map<String, Set<ModTimeRowInfo>> checkBlankBeginBookTimeFails(Map<String, Set<ModTimeRowInfo>> modTimeRowsMap, List<FormMapInfo> billAndSelectRowMapList, Date fillDate, Map<Long, Date> productOrgAndBookDateMap, Map<Long, Date> maxInvOrgAndBookDateMap, Map<Long, Date> mftEntryId_maxInvBookDateMap) {
        Set<ModTimeRowInfo> modTimeHandleRows = modTimeRowsMap.get("modTimeHandleRows");
        HashSet<ModTimeRowInfo> setBookBlankfailRows = new HashSet<ModTimeRowInfo>(16);
        block0: for (ModTimeRowInfo modTimeRowInfo : modTimeHandleRows) {
            int seq = modTimeRowInfo.getSeq();
            String pkValue = modTimeRowInfo.getPkValue();
            for (FormMapInfo formMapInfo : billAndSelectRowMapList) {
                String productType;
                DynamicObject mftOrderEntry;
                DynamicObject bill = formMapInfo.getBills();
                DynamicObjectCollection mftOrderEntrys = bill.getDynamicObjectCollection("treeentryentity");
                String billPkValue = bill.getPkValue().toString();
                if (null == mftOrderEntrys || !StringUtils.equals((CharSequence)pkValue, (CharSequence)billPkValue) || null == (mftOrderEntry = (DynamicObject)mftOrderEntrys.get(seq)) || !"C".equals(productType = mftOrderEntry.getString("producttype"))) continue;
                Date oldBeginBookDate = mftOrderEntry.getDate("beginbookdate");
                if (oldBeginBookDate == null && fillDate == null) {
                    ModTimeRowInfo temp = new ModTimeRowInfo(modTimeRowInfo.getPkValue(), modTimeRowInfo.getEntryId(), modTimeRowInfo.getSeq(), modTimeRowInfo.getBillNo(), modTimeRowInfo.getErrorInfo(), modTimeRowInfo.isTransmitbeginwork());
                    temp.setErrorInfo(String.format(ResManager.loadKDString((String)"\u5de5\u5355\u8bb0\u8d26\u65e5\u671f\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u6e05\u7a7a\u5de5\u5355\u8bb0\u8d26\u65e5\u671f\u3002", (String)"MftOrderModTimeUtils_36", (String)"bd-mpdm-business", (Object[])new Object[0]), new Object[0]));
                    setBookBlankfailRows.add(temp);
                    continue;
                }
                String bizStatus = mftOrderEntry.getString("bizstatus");
                if (StringUtils.equals((CharSequence)"C", (CharSequence)bizStatus) && fillDate == null) {
                    ModTimeRowInfo temp = new ModTimeRowInfo(modTimeRowInfo.getPkValue(), modTimeRowInfo.getEntryId(), modTimeRowInfo.getSeq(), modTimeRowInfo.getBillNo(), modTimeRowInfo.getErrorInfo(), modTimeRowInfo.isTransmitbeginwork());
                    temp.setErrorInfo(ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u7b49\u4e8e\u201c\u5173\u95ed\u201d\uff0c\u4e0d\u5141\u8bb8\u6e05\u7a7a\u5de5\u5355\u8bb0\u8d26\u65e5\u671f\u3002", (String)"MftOrderModTimeUtils_33", (String)"bd-mpdm-business", (Object[])new Object[0]));
                    setBookBlankfailRows.add(temp);
                    continue block0;
                }
                long invOrgId = 0L;
                DynamicObject invOrgDyn = mftOrderEntry.getDynamicObject("inwardept");
                if (null != invOrgDyn) {
                    invOrgId = invOrgDyn.getLong("id");
                }
                long orgId = 0L;
                DynamicObject orgDyn = bill.getDynamicObject("org");
                if (null != orgDyn) {
                    orgId = orgDyn.getLong("id");
                }
                Date bookDate = OrderBookDateService.queryMaxBookDate(orgId, invOrgId, productOrgAndBookDateMap, maxInvOrgAndBookDateMap);
                if (fillDate == null && oldBeginBookDate != null && bookDate != null && oldBeginBookDate.before(OrderBookDateService.theDayAfterMaxBookDate(bookDate))) {
                    SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                    ModTimeRowInfo temp = new ModTimeRowInfo(modTimeRowInfo.getPkValue(), modTimeRowInfo.getEntryId(), modTimeRowInfo.getSeq(), modTimeRowInfo.getBillNo(), modTimeRowInfo.getErrorInfo(), modTimeRowInfo.isTransmitbeginwork());
                    temp.setErrorInfo(String.format(ResManager.loadKDString((String)"\u5de5\u5355\u8bb0\u8d26\u65e5\u671f%1$s\u5c0f\u4e8e\u5b58\u8d27\u5173\u8d26\u65e5\u671f\u7684\u540e\u4e00\u5929%2$s\uff0c\u4e0d\u5141\u8bb8\u6e05\u7a7a\u5de5\u5355\u8bb0\u8d26\u65e5\u671f\u3002", (String)"MftOrderModTimeUtils_34", (String)"bd-mpdm-business", (Object[])new Object[0]), sf.format(oldBeginBookDate), sf.format(OrderBookDateService.theDayAfterMaxBookDate(bookDate))));
                    setBookBlankfailRows.add(temp);
                    continue block0;
                }
                if (fillDate != null || !mftEntryId_maxInvBookDateMap.containsKey(mftOrderEntry.getLong("id"))) continue;
                ModTimeRowInfo temp = new ModTimeRowInfo(modTimeRowInfo.getPkValue(), modTimeRowInfo.getEntryId(), modTimeRowInfo.getSeq(), modTimeRowInfo.getBillNo(), modTimeRowInfo.getErrorInfo(), modTimeRowInfo.isTransmitbeginwork());
                temp.setErrorInfo(String.format(ResManager.loadKDString((String)"\u4e0b\u6e38\u5b58\u5728\u5df2\u6267\u884c\u7684\u76f8\u5173\u4e1a\u52a1\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u6e05\u7a7a\u5de5\u5355\u8bb0\u8d26\u65e5\u671f\u3002", (String)"MftOrderModTimeUtils_35", (String)"bd-mpdm-business", (Object[])new Object[0]), new Object[0]));
                setBookBlankfailRows.add(temp);
                continue block0;
            }
        }
        modTimeRowsMap.put("setBookBlankfailRows", setBookBlankfailRows);
        return modTimeRowsMap;
    }

    public static Map<String, Set<ModTimeRowInfo>> checkCloseBookTimeFails(Map<String, Set<ModTimeRowInfo>> modTimeRowsMap, List<FormMapInfo> billAndSelectRowMapList, Date fillDate, Map<Long, Date> productOrgAndBookDateMap, Map<Long, Date> maxInvOrgAndBookDateMap) {
        Set<ModTimeRowInfo> modTimeHandleRows = modTimeRowsMap.get("modTimeHandleRows");
        HashSet<ModTimeRowInfo> bizStatusFailsRows = new HashSet<ModTimeRowInfo>(16);
        HashSet<ModTimeRowInfo> beforeBeginBookDateRows = new HashSet<ModTimeRowInfo>(16);
        HashSet<ModTimeRowInfo> afterMaxBookDateRows = new HashSet<ModTimeRowInfo>(16);
        for (ModTimeRowInfo modTimeRowInfo : modTimeHandleRows) {
            int seq = modTimeRowInfo.getSeq();
            String pkValue = modTimeRowInfo.getPkValue();
            for (FormMapInfo formMapInfo : billAndSelectRowMapList) {
                Date closeBookDate;
                String productType;
                DynamicObject mftOrderEntry;
                DynamicObject bill = formMapInfo.getBills();
                DynamicObjectCollection mftOrderEntrys = bill.getDynamicObjectCollection("treeentryentity");
                String billPkValue = bill.getPkValue().toString();
                if (null == mftOrderEntrys || !StringUtils.equals((CharSequence)pkValue, (CharSequence)billPkValue) || null == (mftOrderEntry = (DynamicObject)mftOrderEntrys.get(seq)) || !"C".equals(productType = mftOrderEntry.getString("producttype"))) continue;
                String bizstatus = mftOrderEntry.getString("bizstatus");
                if (!StringUtils.equals((CharSequence)"C", (CharSequence)bizstatus)) {
                    ModTimeRowInfo temp = new ModTimeRowInfo(modTimeRowInfo.getPkValue(), modTimeRowInfo.getEntryId(), modTimeRowInfo.getSeq(), modTimeRowInfo.getBillNo(), modTimeRowInfo.getErrorInfo(), modTimeRowInfo.isTransmitbeginwork());
                    temp.setErrorInfo(ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u5173\u95ed\u201d\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5de5\u5355\u5173\u95ed\u8bb0\u8d26\u65e5\u671f\u3002", (String)"MftOrderModTimeUtils_19", (String)"bd-mpdm-business", (Object[])new Object[0]));
                    bizStatusFailsRows.add(temp);
                }
                if ((closeBookDate = mftOrderEntry.getDate("closebookdate")) == null) {
                    ModTimeRowInfo temp = new ModTimeRowInfo(modTimeRowInfo.getPkValue(), modTimeRowInfo.getEntryId(), modTimeRowInfo.getSeq(), modTimeRowInfo.getBillNo(), modTimeRowInfo.getErrorInfo(), modTimeRowInfo.isTransmitbeginwork());
                    temp.setErrorInfo(ResManager.loadKDString((String)"\u5de5\u5355\u5173\u95ed\u8bb0\u8d26\u65e5\u671f\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5de5\u5355\u5173\u95ed\u8bb0\u8d26\u65e5\u671f\u3002", (String)"MftOrderModTimeUtils_20", (String)"bd-mpdm-business", (Object[])new Object[0]));
                    bizStatusFailsRows.add(temp);
                }
                Date beginbookdate = mftOrderEntry.getDate("beginbookdate");
                if (null != fillDate && null != beginbookdate && DateUtils.getShortDate((Date)beginbookdate).after(fillDate)) {
                    SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                    ModTimeRowInfo temp = new ModTimeRowInfo(modTimeRowInfo.getPkValue(), modTimeRowInfo.getEntryId(), modTimeRowInfo.getSeq(), modTimeRowInfo.getBillNo(), modTimeRowInfo.getErrorInfo(), modTimeRowInfo.isTransmitbeginwork());
                    temp.setErrorInfo(String.format(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u8981\u6c42\uff1a\u5de5\u5355\u5173\u95ed\u8bb0\u8d26\u65e5\u671f\uff08%1$s\uff09\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5de5\u5355\u8bb0\u8d26\u65e5\u671f\uff08%2$s\uff09\u3002", (String)"MftOrderModTimeUtils_29", (String)"bd-mpdm-business", (Object[])new Object[0]), sf.format(fillDate), sf.format(beginbookdate)));
                    beforeBeginBookDateRows.add(temp);
                }
                long invOrgId = 0L;
                DynamicObject invOrgDyn = mftOrderEntry.getDynamicObject("inwardept");
                if (null != invOrgDyn) {
                    invOrgId = invOrgDyn.getLong("id");
                }
                long orgId = 0L;
                DynamicObject orgDyn = bill.getDynamicObject("org");
                if (null != orgDyn) {
                    orgId = orgDyn.getLong("id");
                }
                Date bookDate = OrderBookDateService.queryMaxBookDate(orgId, invOrgId, productOrgAndBookDateMap, maxInvOrgAndBookDateMap);
                if (null == fillDate || null == bookDate || !fillDate.before(OrderBookDateService.theDayAfterMaxBookDate(bookDate))) continue;
                SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                ModTimeRowInfo temp = new ModTimeRowInfo(modTimeRowInfo.getPkValue(), modTimeRowInfo.getEntryId(), modTimeRowInfo.getSeq(), modTimeRowInfo.getBillNo(), modTimeRowInfo.getErrorInfo(), modTimeRowInfo.isTransmitbeginwork());
                temp.setErrorInfo(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4fee\u6539\u540e\u7684\u5de5\u5355\u5173\u95ed\u8bb0\u8d26\u65e5\u671f%1$s\u5c0f\u4e8e\u5173\u8d26\u65e5\u671f\u7684\u540e\u4e00\u5929%2$s\uff0c\u4fee\u6539\u5931\u8d25\u3002", (String)"MftOrderModTimeUtils_32", (String)"bd-mpdm-business", (Object[])new Object[0]), sf.format(fillDate), sf.format(OrderBookDateService.theDayAfterMaxBookDate(bookDate))));
                afterMaxBookDateRows.add(temp);
            }
        }
        modTimeRowsMap.put("bizStatusFailsRows", bizStatusFailsRows);
        modTimeRowsMap.put("beforeBeginBookDateRows", beforeBeginBookDateRows);
        modTimeRowsMap.put("afterMaxBookDateRows", afterMaxBookDateRows);
        return modTimeRowsMap;
    }

    public static List<ModTimeRowInfo> modTimeRowsMapTransStringToMap(String jsonString) {
        ArrayList<ModTimeRowInfo> result = new ArrayList(10);
        ObjectMapper mapper = new ObjectMapper();
        try {
            result = (List)mapper.readValue(jsonString, (TypeReference)new TypeReference<List<ModTimeRowInfo>>(){});
        }
        catch (IOException e) {
            logger.info(e.getMessage(), (Object)e);
        }
        return result;
    }

    public static List<ModTimeRowInfo> makeFormRowInfos(DynamicObject mftOrderBill, int[] selectRows) {
        ArrayList<ModTimeRowInfo> rowInfos = new ArrayList<ModTimeRowInfo>(10);
        DynamicObjectCollection mftOrderEntrys = mftOrderBill.getDynamicObjectCollection("treeentryentity");
        String pkValue = mftOrderBill.getPkValue().toString();
        for (int row : selectRows) {
            ModTimeRowInfo modTimeRowInfo = new ModTimeRowInfo();
            modTimeRowInfo.setPkValue(pkValue);
            modTimeRowInfo.setEntryId(((DynamicObject)mftOrderEntrys.get(row)).getPkValue().toString());
            rowInfos.add(modTimeRowInfo);
        }
        return rowInfos;
    }

    public static List<ModTimeRowInfo> makeListRowInfos(ListSelectedRowCollection selects) {
        ArrayList<ModTimeRowInfo> rowInfos = new ArrayList<ModTimeRowInfo>(10);
        for (ListSelectedRow listSelectedRow : selects) {
            if (null == listSelectedRow || null == listSelectedRow.getPrimaryKeyValue() || null == listSelectedRow.getEntryPrimaryKeyValue()) continue;
            ModTimeRowInfo modTimeRowInfo = new ModTimeRowInfo();
            String pkid = listSelectedRow.getPrimaryKeyValue().toString();
            String entryPk = listSelectedRow.getEntryPrimaryKeyValue().toString();
            modTimeRowInfo.setPkValue(pkid);
            modTimeRowInfo.setEntryId(entryPk);
            rowInfos.add(modTimeRowInfo);
        }
        return rowInfos;
    }

    public static List<FormMapInfo> selectsToBillAndSelectRowMapList(List<ModTimeRowInfo> selects, ExtendedDataEntity[] dataEntities) {
        ArrayList<FormMapInfo> billAndSelectRowMapList = new ArrayList<FormMapInfo>(10);
        if (selects.size() > 0) {
            String pkid;
            HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>(selects.size());
            for (ModTimeRowInfo modTimeRowInfo : selects) {
                pkid = modTimeRowInfo.getPkValue();
                String entryPk = modTimeRowInfo.getEntryId();
                ArrayList<String> entryPkList = (ArrayList<String>)map.get(pkid);
                if (null == entryPkList || entryPkList.size() == 0) {
                    entryPkList = new ArrayList<String>(10);
                }
                entryPkList.add(entryPk);
                map.put(pkid, entryPkList);
            }
            for (Map.Entry entry : map.entrySet()) {
                pkid = (String)entry.getKey();
                List entryPks = (List)entry.getValue();
                FormMapInfo formMapInfo = new FormMapInfo();
                ArrayList<Integer> selectRows = new ArrayList<Integer>(entryPks.size());
                for (ExtendedDataEntity dataEntitie : dataEntities) {
                    DynamicObject manubill = dataEntitie.getDataEntity();
                    String billPkValue = manubill.getPkValue().toString();
                    if (!StringUtils.equals((CharSequence)pkid, (CharSequence)billPkValue)) continue;
                    DynamicObjectCollection mftOrderEntryCol = manubill.getDynamicObjectCollection("treeentryentity");
                    block3: for (int j = 0; j < mftOrderEntryCol.size(); ++j) {
                        DynamicObject mftOrderEntry = (DynamicObject)mftOrderEntryCol.get(j);
                        String mftOrderEntryId = mftOrderEntry.getPkValue().toString();
                        for (String entryPk : entryPks) {
                            if (!StringUtils.equals((CharSequence)mftOrderEntryId, (CharSequence)entryPk)) continue;
                            selectRows.add(mftOrderEntry.getInt("seq") - 1);
                            continue block3;
                        }
                    }
                    int[] selectRowsArray = new int[selectRows.size()];
                    for (int i = 0; i < selectRows.size(); ++i) {
                        int row;
                        selectRowsArray[i] = row = ((Integer)selectRows.get(i)).intValue();
                    }
                    formMapInfo.setSelectRows(selectRowsArray);
                    formMapInfo.setBills(manubill);
                    billAndSelectRowMapList.add(formMapInfo);
                }
            }
        }
        return billAndSelectRowMapList;
    }

    public static FormShowParameter modTimeShowForm(String caption, IFormPlugin plugin, String action, String formId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.setCaption(caption);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, action));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        return showParameter;
    }

    public static String closedCallBackInvokeParams(Map<String, Object> returnData) {
        SimpleDateFormat sf;
        String timeStr;
        Date closeTime;
        String result = "";
        if (null != returnData && (closeTime = (Date)returnData.get("datetime")) != null && StringUtils.isNotBlank((CharSequence)(timeStr = (sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(closeTime)))) {
            result = result + timeStr;
        }
        return result;
    }

    public static Map<Long, Date> getMaxOrMinInvBookDateMap(boolean max, String mftOrderEntity, Set<Long> mftEntryIds) {
        HashMap<Long, Date> entryId_MaxInvBookDateMap = new HashMap<Long, Date>(16);
        String invBillKey = "im_mdc_mftproorder";
        String invComBillKey = "im_mdc_mftmanuinbill";
        String reportBillKey = "sfc_processreportbill";
        if ("om_mftorder".equals(mftOrderEntity)) {
            invBillKey = "im_mdc_omoutbill";
            invComBillKey = "im_mdc_omcmplinbill";
            reportBillKey = "om_processreport";
        }
        String sels = "to_char(billentry.manuentryid) orderentryid,bookdate";
        QFilter statusQf = new QFilter("billstatus", "=", (Object)"C");
        QFilter mftEntryIdsQf = new QFilter("billentry.manuentryid", "in", mftEntryIds);
        QFilter[] invQfs = new QFilter[]{statusQf, mftEntryIdsQf};
        try (AlgoContext context = Algo.newContext();){
            DataSet invdDataSet = QueryServiceHelper.queryDataSet((String)"query-invBill", (String)invBillKey, (String)sels, (QFilter[])invQfs, null);
            DataSet comDataSet = QueryServiceHelper.queryDataSet((String)"query-invComBill", (String)invComBillKey, (String)sels, (QFilter[])invQfs, null);
            QFilter opreportFilter = new QFilter("sumentry.manufactureentryid", "in", mftEntryIds);
            DataSet opreportDataSet = QueryServiceHelper.queryDataSet((String)"query-opreportBill", (String)reportBillKey, (String)"to_char(sumentry.manufactureentryid) orderentryid,bookdate", (QFilter[])new QFilter[]{opreportFilter, statusQf}, null);
            DataSet dateSet = invdDataSet.union(new DataSet[]{comDataSet, opreportDataSet});
            if ("pom_mftorder".equals(mftOrderEntity)) {
                List mftEntryIdStrs = mftEntryIds.stream().map(k -> k.toString()).collect(Collectors.toList());
                QFilter reportFilter = new QFilter("sumentry.mftentryid", "in", mftEntryIdStrs);
                DataSet reportDataSet = QueryServiceHelper.queryDataSet((String)"query-reportBill", (String)"pom_mftorderreport", (String)"sumentry.mftentryid orderentryid,bookdate", (QFilter[])new QFilter[]{reportFilter, statusQf}, null);
                invComBillKey = "im_mdc_omcmplinbill";
                QFilter modeltypeQf = new QFilter("modeltype", "=", (Object)"B");
                DataSet omDataSet = QueryServiceHelper.queryDataSet((String)"query-ominvComBill", (String)invComBillKey, (String)sels, (QFilter[])new QFilter[]{statusQf, mftEntryIdsQf, modeltypeQf}, null);
                dateSet = dateSet.union(new DataSet[]{reportDataSet, omDataSet});
            }
            String[] gStr = new String[]{"orderentryid"};
            dateSet = max ? dateSet.groupBy(gStr).max("bookdate").finish() : dateSet.groupBy(gStr).min("bookdate").finish();
            if (dateSet != null) {
                while (dateSet.hasNext()) {
                    Row next = dateSet.next();
                    entryId_MaxInvBookDateMap.put(next.getLong("orderentryid"), next.getDate("bookdate"));
                }
            }
        }
        return entryId_MaxInvBookDateMap;
    }
}

