/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.mftorder;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class MftOrderSetManuVersionHelper {
    public List<QFilter> getManuVersionFilters(String typename, DynamicObject entry, DynamicObject org) {
        DynamicObject materialManu = (DynamicObject)entry.get("material");
        BigDecimal qtyManu = (BigDecimal)entry.get("qty");
        Date bomManu = (Date)entry.get("expendbomtime");
        DynamicObject configCodeManu = (DynamicObject)entry.get("configuredcode");
        DynamicObject workCenterManu = (DynamicObject)entry.get("workcenter");
        ArrayList<QFilter> qfList = new ArrayList<QFilter>(16);
        if ("pom_mftorder".equals(typename) || "om_mftorder".equals(typename)) {
            QFilter orgFil = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_manuversion", (Long)org.getLong("id"));
            qfList.add(orgFil);
            qfList.add(new QFilter("status", "=", (Object)"C"));
            qfList.add(new QFilter("enable", "=", (Object)"1"));
            qfList.add(new QFilter("material", "=", materialManu.get("id")));
            qfList.add(new QFilter("beginqty", "<=", (Object)qtyManu));
            qfList.add(new QFilter("endqty", ">=", (Object)qtyManu));
            qfList.add(new QFilter("begindate", "<=", (Object)bomManu));
            qfList.add(new QFilter("enddate", ">=", (Object)bomManu));
            if (workCenterManu != null) {
                qfList.add(new QFilter("workcenter", "=", workCenterManu.get("id")));
            }
        }
        return qfList;
    }

    public DataSet getBatchManuVersionData(Set<DynamicObject> orderBills) {
        if (orderBills == null || orderBills.size() < 1) {
            return null;
        }
        Long orgId = 0L;
        HashSet<Object> materialIds = new HashSet<Object>(16);
        for (DynamicObject order : orderBills) {
            orgId = order.getDynamicObject("org").getLong("id");
            DynamicObjectCollection entrys = order.getDynamicObjectCollection("treeentryentity");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                materialIds.add(entry.getDynamicObject("material").getPkValue());
            }
        }
        if (materialIds.isEmpty()) {
            return null;
        }
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_manuversion", (Long)orgId);
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("material", "in", materialIds));
        DataSet manuVersionDatas = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".getBatchManuVersionData"), (String)"pdm_manuversion", (String)"id,material,workcenter,beginqty,endqty,begindate,enddate,audittime", (QFilter[])qFilter.toArray(), null);
        return manuVersionDatas;
    }

    public List<Object> manuVerSetIds(List<QFilter> qfList) {
        QFilter[] qFilters = qfList.toArray(new QFilter[0]);
        ArrayList<Object> manuIds = new ArrayList<Object>(16);
        DataSet manuDataSet = QueryServiceHelper.queryDataSet((String)"query_pdm_manuversion", (String)"pdm_manuversion", (String)"id,begindate,audittime", (QFilter[])qFilters, null);
        DataSet finalDataSet = manuDataSet.orderBy(new String[]{"begindate desc", "audittime desc"});
        finalDataSet.copy().forEach(row -> manuIds.add(row.get("id")));
        return manuIds;
    }

    public void mvFieldsSet(DynamicObject version, DynamicObject entry, List<Object> manuIds) {
        if (manuIds.size() != 0) {
            DynamicObject schedulerManu;
            entry.set("manuversion", (Object)version);
            DynamicObject workCenterManu = (DynamicObject)entry.get("workcenter");
            if (workCenterManu == null) {
                DynamicObject dynWorkCenter = (DynamicObject)version.get("workcenter");
                entry.set("workcenter", (Object)dynWorkCenter);
            }
            if ((schedulerManu = (DynamicObject)entry.get("scheduler")) == null) {
                if (version.get("person") != null) {
                    DynamicObject dynScheduler = (DynamicObject)version.get("person");
                    entry.set("scheduler", (Object)dynScheduler);
                } else {
                    this.setScheduler(entry);
                }
            }
        } else {
            this.setScheduler(entry);
            entry.set("manuversion", null);
        }
    }

    public void propChangeFieldsSet(IDataModel thModel, int rowIndex) {
        Date expBomDat;
        DynamicObject manuVersionDyn = (DynamicObject)thModel.getValue("transactiontype");
        if (manuVersionDyn == null) {
            return;
        }
        boolean isVersionReq = manuVersionDyn.getBoolean("versionreq");
        boolean isEnablePlanScope = (Boolean)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IPlanScopeService", (String)"isEnablePlanScope", (Object[])new Object[0]);
        if (!isEnablePlanScope && !isVersionReq) {
            return;
        }
        DynamicObject org = (DynamicObject)thModel.getValue("org");
        DynamicObject materialDyn = (DynamicObject)thModel.getValue("material", rowIndex);
        BigDecimal qtyDec = (BigDecimal)thModel.getValue("qty", rowIndex);
        if ("0E-10".equals(qtyDec.toString()) || "0.0000".equals(qtyDec.toString())) {
            qtyDec = BigDecimal.valueOf(0L);
        }
        if ((expBomDat = (Date)thModel.getValue("expendbomtime", rowIndex)) == null) {
            thModel.setValue("manuversion", null, rowIndex);
            return;
        }
        Date startOfDay = MftOrderSetManuVersionHelper.getStartOfDay(expBomDat);
        Date endOfDay = MftOrderSetManuVersionHelper.getEndOfDay(expBomDat);
        DynamicObject workCenterDyn = (DynamicObject)thModel.getValue("workcenter", rowIndex);
        ArrayList<QFilter> qfList = new ArrayList<QFilter>(16);
        if (materialDyn != null && !qtyDec.equals(BigDecimal.valueOf(0L))) {
            QFilter orgFil = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_manuversion", (Long)org.getLong("id"));
            qfList.add(orgFil);
            qfList.add(new QFilter("status", "=", (Object)"C"));
            qfList.add(new QFilter("enable", "=", (Object)"1"));
            qfList.add(new QFilter("material", "=", materialDyn.get("id")));
            qfList.add(new QFilter("beginqty", "<=", (Object)qtyDec));
            qfList.add(new QFilter("endqty", ">=", (Object)qtyDec));
            qfList.add(new QFilter("begindate", "<=", (Object)startOfDay));
            qfList.add(new QFilter("enddate", ">=", (Object)endOfDay));
            if (workCenterDyn != null) {
                qfList.add(new QFilter("workcenter", "=", workCenterDyn.get("id")));
            }
            List<Object> manuIds = this.manuVerSetIds(qfList);
            ArrayList<QFilter> manuRemovePro = new ArrayList<QFilter>(16);
            List<Object> manuRemoveProIds = new ArrayList(16);
            if (manuIds.size() == 0) {
                for (QFilter qFilter : qfList) {
                    String property = qFilter.getProperty();
                    if ("workcenter".equals(property)) continue;
                    manuRemovePro.add(qFilter);
                }
                manuRemoveProIds = this.manuVerSetIds(manuRemovePro);
            }
            if (manuRemoveProIds.size() != 0 && manuIds.size() == 0 || manuIds.size() != 0) {
                Object mId = null;
                mId = manuIds.size() != 0 ? manuIds.get(0) : manuRemoveProIds.get(0);
                DynamicObject version = BusinessDataServiceHelper.loadSingle((Object)mId, (String)"pdm_manuversion", (String)"id,workcenter,person");
                DynamicObject scheduler = (DynamicObject)thModel.getValue("scheduler", rowIndex);
                if (scheduler == null) {
                    if (version.get("person") != null) {
                        DynamicObject dynScheduler = (DynamicObject)version.get("person");
                        thModel.setValue("scheduler", (Object)dynScheduler, rowIndex);
                    } else {
                        this.setSchedulerForPropChange(thModel, rowIndex);
                    }
                }
                thModel.setValue("manuversion", (Object)version, rowIndex);
            } else {
                this.setSchedulerForPropChange(thModel, rowIndex);
                thModel.setValue("manuversion", null, rowIndex);
            }
        }
    }

    public static Date getEndOfDay(Date date) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime endOfDay = localDateTime.with(LocalTime.MAX);
        return Date.from(endOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getStartOfDay(Date date) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime startOfDay = localDateTime.with(LocalTime.MIN);
        return Date.from(startOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }

    private void setSchedulerForPropChange(IDataModel thModel, int rowIndex) {
        DynamicObject materialManu = (DynamicObject)thModel.getValue("material", rowIndex);
        if (materialManu != null && materialManu.get("person") != null) {
            DynamicObject person = (DynamicObject)materialManu.get("person");
            thModel.setValue("scheduler", (Object)person, rowIndex);
        }
    }

    private void setScheduler(DynamicObject entry) {
        DynamicObject materialManu = entry.getDynamicObject("material");
        if (materialManu != null && materialManu.get("person") != null) {
            DynamicObject person = (DynamicObject)materialManu.get("person");
            entry.set("scheduler", (Object)person);
        }
    }
}

