/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.business.mftorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsBomQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsManuVersionQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsProcessRouteQueryHelper;
import kd.bd.mpdm.common.utils.MulBaseDataUtils;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class MftOrderSetWorkCenterHelper {
    public void setWorkCenter(DynamicObject bill, int entryIndex, DynamicObject workCenter) {
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("treeentryentity");
        DynamicObject changedRow = (DynamicObject)entry.get(entryIndex);
        changedRow.set("workcenter", (Object)workCenter);
        this.setManuVersion(bill, changedRow);
        this.setBomAndProcessRoute(bill, changedRow);
    }

    private void setManuVersion(DynamicObject bill, DynamicObject row) {
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject materialDyn = row.getDynamicObject("material");
        BigDecimal qtyDec = row.getBigDecimal("qty");
        if (qtyDec == null) {
            qtyDec = BigDecimal.ZERO;
        }
        Date expBomDat = row.getDate("expendbomtime");
        DynamicObject workCenterDyn = row.getDynamicObject("workcenter");
        ArrayList<QFilter> qfList = new ArrayList<QFilter>(16);
        if (materialDyn != null && qtyDec.compareTo(BigDecimal.ZERO) != 0) {
            List<Object> manuIds;
            QFilter orgFil = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_manuversion", (Long)org.getLong("id"));
            qfList.add(orgFil);
            qfList.add(new QFilter("status", "=", (Object)"C"));
            qfList.add(new QFilter("enable", "=", (Object)"1"));
            qfList.add(new QFilter("material", "=", materialDyn.get("id")));
            qfList.add(new QFilter("beginqty", "<=", (Object)qtyDec));
            qfList.add(new QFilter("endqty", ">=", (Object)qtyDec));
            qfList.add(new QFilter("begindate", "<=", (Object)expBomDat));
            qfList.add(new QFilter("enddate", ">=", (Object)expBomDat));
            if (workCenterDyn != null) {
                qfList.add(new QFilter("workcenter", "=", workCenterDyn.get("id")));
            }
            if ((manuIds = this.manuVerSetIds(qfList)).size() != 0) {
                DynamicObject scheduler;
                Object mId = manuIds.get(0);
                DynamicObject version = BusinessDataServiceHelper.loadSingleFromCache((Object)mId, (String)"pdm_manuversion");
                DynamicObject workCenter = row.getDynamicObject("workcenter");
                if (workCenter == null) {
                    DynamicObject dynWorkCenter = (DynamicObject)version.get("workcenter");
                    row.set("workcenter", (Object)dynWorkCenter);
                }
                if ((scheduler = row.getDynamicObject("scheduler")) == null) {
                    if (version.get("person") != null) {
                        DynamicObject dynScheduler = (DynamicObject)version.get("person");
                        row.set("scheduler", (Object)dynScheduler);
                    } else {
                        this.setSchedulerForPropChange(row);
                    }
                }
                row.set("manuversion", (Object)version);
            } else {
                this.setSchedulerForPropChange(row);
                row.set("manuversion", null);
            }
        }
    }

    private List<Object> manuVerSetIds(List<QFilter> qfList) {
        QFilter[] qFilters = qfList.toArray(new QFilter[0]);
        ArrayList<Object> manuIds = new ArrayList<Object>(16);
        DataSet manuDataSet = QueryServiceHelper.queryDataSet((String)"query_pdm_manuversion", (String)"pdm_manuversion", (String)"id,begindate", (QFilter[])qFilters, null);
        DataSet finalDataSet = manuDataSet.orderBy(new String[]{"begindate desc"});
        finalDataSet.copy().forEach(row -> manuIds.add(row.get("id")));
        return manuIds;
    }

    private void setSchedulerForPropChange(DynamicObject row) {
        DynamicObject materialManu = row.getDynamicObject("material");
        if (materialManu != null && materialManu.get("person") != null) {
            DynamicObject person = (DynamicObject)materialManu.get("person");
            row.set("scheduler", (Object)person);
        }
    }

    private void setBomAndProcessRoute(DynamicObject bill, DynamicObject row) {
        DynamicObject manuVersion = row.getDynamicObject("manuversion");
        if (manuVersion != null) {
            DynamicObject processRoute;
            QFilter routeQfilter;
            String type = row.getString("producttype");
            if (!StringUtils.equals((CharSequence)"C", (CharSequence)type)) {
                return;
            }
            DynamicObject loadSingle = MsManuVersionQueryHelper.getDataCacheByID((Object)manuVersion.getPkValue());
            DynamicObject versionBom = (DynamicObject)loadSingle.get("bom");
            DynamicObject versionProcessRoute = (DynamicObject)loadSingle.get("processRoute");
            DynamicObject material = row.getDynamicObject("material");
            DynamicObject org = bill.getDynamicObject("org");
            if (!this.checkManuVersionBOMType(bill, versionBom)) {
                row.set("manuversion", null);
                return;
            }
            DynamicObject route = (DynamicObject)loadSingle.get("processroute");
            if (!this.checkManuVersionRoute(route, routeQfilter = this.getProcessRouteFilter(material, org))) {
                row.set("manuversion", null);
                return;
            }
            DynamicObject bom = MsBomQueryHelper.getDataCacheByID((Object)versionBom.getLong("id"));
            if (null != bom) {
                String bomEnable = bom.getString("enable");
                if (StringUtils.equals((CharSequence)"1", (CharSequence)bomEnable)) {
                    row.set("bomid", (Object)bom);
                } else {
                    row.set("bomid", null);
                }
            }
            if (null != (processRoute = MsProcessRouteQueryHelper.getDataCacheByID((Object)versionProcessRoute.get("id")))) {
                String processrouteEnable = processRoute.getString("enable");
                if (StringUtils.equals((CharSequence)"1", (CharSequence)processrouteEnable)) {
                    row.set("processroute", (Object)route);
                } else {
                    row.set("processroute", null);
                }
            }
            DynamicObject mftmaterial = MaterialMftQueryHelper.getDataCacheByID((Object)material.getPkValue());
            this.setECNVersionByExpandDate(bill, row, mftmaterial.getDynamicObject("masterid"), loadSingle);
        }
    }

    private boolean checkManuVersionBOMType(DynamicObject bill, DynamicObject versionBom) {
        DynamicObject transtype = bill.getDynamicObject("transactiontype");
        DynamicObject transtypeload = TransactionTypeQueryHelper.getDataCacheByID((Object)transtype.getPkValue());
        DynamicObjectCollection transbomtypes = transtypeload.getDynamicObjectCollection("bomtypes");
        if (CollectionUtils.isEmpty((Collection)transbomtypes)) {
            return false;
        }
        DynamicObject bomload = MsBomQueryHelper.getDataCacheByID((Object)versionBom.getPkValue());
        DynamicObject bomtype = bomload.getDynamicObject("type");
        return bomtype != null && MulBaseDataUtils.getPkValuesByMulData((DynamicObjectCollection)transbomtypes).contains((Long)bomtype.getPkValue());
    }

    private boolean checkManuVersionRoute(DynamicObject versionRoute, QFilter routeFilter) {
        QFilter qFilter = new QFilter("id", "=", versionRoute.getPkValue());
        return QueryServiceHelper.exists((String)"pdm_route", (QFilter[])new QFilter[]{qFilter, routeFilter});
    }

    private QFilter getProcessRouteFilter(DynamicObject mftmaterial, DynamicObject org) {
        QFilter orgqFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_route", (Long)((Long)org.getPkValue()));
        QFilter typeA = new QFilter("processtype", "=", (Object)"A");
        QFilter typeB = new QFilter("processtype", "=", (Object)"B");
        QFilter typeC = new QFilter("processtype", "=", (Object)"C");
        mftmaterial = MaterialMftQueryHelper.getDataCacheByID((Object)mftmaterial.getPkValue());
        DynamicObject bdmaterial = mftmaterial.getDynamicObject("masterid");
        QFilter materialFilter = new QFilter("material.id", "=", bdmaterial.getPkValue());
        DynamicObjectCollection materialgroup = mftmaterial.getDynamicObjectCollection("mftcontrolentry");
        ArrayList<Long> grouplist = new ArrayList<Long>();
        for (DynamicObject group : materialgroup) {
            grouplist.add((Long)group.getDynamicObject("materialcontrol").getPkValue());
        }
        QFilter result = orgqFilter.and(new QFilter("status", "=", (Object)"C"));
        QFilter statusFilter = typeA.and(materialFilter);
        if (grouplist.size() > 0) {
            statusFilter.or(typeB.and(new QFilter("materialgroup", "in", grouplist)));
        }
        statusFilter.or(typeC);
        result.and(statusFilter);
        return result;
    }

    private void setECNVersionByExpandDate(DynamicObject bill, DynamicObject row, DynamicObject pkmaterial, DynamicObject manuversion) {
        DynamicObjectCollection bomtypes;
        Date expendbomtime = row.getDate("expendbomtime");
        if (expendbomtime == null) {
            expendbomtime = new Date();
        }
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject transactiontype = bill.getDynamicObject("transactiontype");
        HashSet<Long> bomTypeIDSet = null;
        if (transactiontype != null && CollectionUtils.isNotEmpty((Collection)(bomtypes = transactiontype.getDynamicObjectCollection("bomtypes")))) {
            bomTypeIDSet = new HashSet<Long>(16);
            for (DynamicObject dyn : bomtypes) {
                bomTypeIDSet.add(dyn.getLong("fbasedataid_id"));
            }
        }
        String selectProperties = "number,enable,id,ecn,type,version,yieldrate";
        String orderByStr = "";
        DynamicObject bom = MsBomQueryHelper.getBomFromCache((DynamicObject)pkmaterial, (Long)org.getLong("id"), (DynamicObject)manuversion, bomTypeIDSet, (Date)expendbomtime, (String)selectProperties, (String)orderByStr);
        row.set("bomid", (Object)bom);
    }
}

